/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupInfo;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractInventoryCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.BillWrittenOffData;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateDiffAmt;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffGroup;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffHashMap;
import com.kingdee.eas.scm.cal.app.newutil.WriteOffHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonFacade;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PurInWarehouseAPCalculate
extends AbstractInventoryCalculate {
    private boolean isWriteOffWithBlueBill = true;
    private boolean isCrossPeriodNotWriteOff = false;
    private int inPeriod = 0;
    private int inPeriodYear = 0;
    private DevolveWriteOffGroupInfo devWriteOffGroupInfo = null;

    @Override
    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        PurInWarehsBillInfo bill = (PurInWarehsBillInfo)scminfo;
        this.srcEntryTableName = "t_im_purinwarehsentry";
        StringBuffer selectSQL = this.takeSQLBill(ctx, this.srcEntryTableName);
        CalculateWrittenOffBill purInBill = this.takeWrittenOffBill(ctx, (CoreBillBaseInfo)bill, this.srcEntryTableName, selectSQL);
        if (purInBill == null) {
            return;
        }
        if (4 != purInBill.getBaseStatus()) {
            ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx).inverseWriteOff(new String[]{bill.getId().toString()}, "103");
        } else {
            int i;
            MappingConditionEntryCollection mappingEntryColl = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE mappingCondition.number = '001' AND isFlowWriteOff = 1 order by flowWriteOffSeq, mappingField.seq");
            FilterInfo secFilter = new FilterInfo();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(scminfo.getId().toString());
            secFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            secFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            secFilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
            secFilter.getFilterItems().add(new FilterItemInfo("entry.isPresent", (Object)Boolean.FALSE, CompareType.EQUALS));
            secFilter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
            FilterInfo mainFilter = new FilterInfo();
            mainFilter.getFilterItems().add(new FilterItemInfo("entry.unwriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3, CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("billType", (Object)"202", CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)0, CompareType.EQUALS));
            FilterInfo sameSideFilter = new FilterInfo();
            this.dischargeType = CalculateUtil.getDischargeType(ctx, this.companyOrgUnitInfo.getId().toString());
            if (this.dischargeType != 0) {
                mainFilter.getFilterItems().add(new FilterItemInfo("year * 100 + period <= " + (bill.getYear() * 100 + bill.getPeriod())));
            }
            this.isDevolve = purInBill.getPurchaseType() == 1;
            WriteOffCommonParams params = new WriteOffCommonParams();
            params.put((Object)"isDevolve", (Object)this.isDevolve);
            params.setFlowWriteOff(true);
            params.setFlowWfBillId(scminfo.getId().toString());
            params.setFromMain(false);
            params.setStrategy("purWriteOff");
            params.setCompanyId(this.companyOrgUnitInfo.getId().toString());
            params.setMainEntityId("48DA3A71");
            params.setSecEntityId("783061E3");
            params.setMainQueryName("com.kingdee.eas.fi.ap.app.OtherBillQuery");
            params.setSecQueryName("com.kingdee.eas.scm.im.inv.PurInWarehsQuery");
            params.setMainEntryIdField("entry.id");
            params.setSecEntryIdField("entry.id");
            params.put((Object)"mainFilter", (Object)mainFilter);
            params.put((Object)"secFilter", (Object)secFilter);
            IWriteOffCommonFacade iWriteOffCommonFacade = WriteOffCommonFacadeFactory.getLocalInstance((Context)ctx);
            HashMap cacheMap = new HashMap();
            MappingConditionEntryInfo mappingInfo = new MappingConditionEntryInfo();
            MappingFieldCollection coll = new MappingFieldCollection();
            MappingFieldInfo info = new MappingFieldInfo();
            info.setSecField("entry.sourceBillEntryId");
            info.setMainField("entry.id");
            coll.add(info);
            mappingInfo.getMappingField().addCollection(coll);
            mappingInfo.setId(BOSUuid.read((String)"dBC/vlCCS6W9QaL2vxItOZVAboA="));
            params.put((Object)"mappingEntryInfo", (Object)mappingInfo);
            params.put((Object)"isBotpWriteOff", (Object)true);
            iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
            params.put((Object)"isBotpWriteOff", null);
            int size = mappingEntryColl.size();
            for (i = 0; i < size; ++i) {
                params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
            }
            mappingInfo.getMappingField().clear();
            mappingInfo.getMappingField().addCollection(this.getSameSideMappingField(new String[]{"entry.purOrderEntry"}));
            mappingInfo.setId(null);
            iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
            size = mappingEntryColl.size();
            for (i = 0; i < size; ++i) {
                params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                iWriteOffCommonFacade.flowWriteOff(params, mappingEntryColl, cacheMap);
            }
        }
        ArrayList entrys = purInBill.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)entrys.get(i);
            this.calculator.calculateCost(ctx, this.companyOrgUnitInfo, this.periodInfo, this.materialCalType, entry.getAmount(), entry.getBaseUnitQty(), purInBill, entry, true);
        }
    }

    private void initParam(Context ctx, int pucharseType) throws BOSException, EASBizException {
        String[] numbers = new String[]{"SCM_CAL_001", "SCM_CAL_004", "SCM_CAL_012", "SCM_CAL_018"};
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap paramMap = ipc.getParamHashMap(numbers, this.companyOrgUnitInfo.getId().toString());
        Object param = paramMap.get("SCM_CAL_018");
        int value = Integer.parseInt(param != null ? param.toString() : "0");
        this.isWriteOffWithBlueBill = value == 0;
        this.isCrossPeriodNotWriteOff = value == 2;
        param = paramMap.get("SCM_CAL_004");
        if (param != null && param.toString().equalsIgnoreCase("0")) {
            this.isMerageCostAdjust = true;
        }
        if ((param = paramMap.get("SCM_CAL_001")) == null || param.equals("")) {
            throw new CalculateException(CalculateException.PARAM_NOT_EXIST);
        }
        this.dischargeType = Integer.parseInt(param.toString());
        param = paramMap.get("SCM_CAL_012");
        if (param != null) {
            this.isAdjust = param.toString().equalsIgnoreCase("true");
        }
        this.isDevolve = pucharseType == 1;
    }

    protected CalculateWrittenOffHashMap getWriteOffBillMap(Context ctx, CalculateWrittenOffBill bill) throws BOSException, EASBizException {
        CalculateWrittenOffHashMap writeOffBillMap = new CalculateWrittenOffHashMap();
        StringBuffer selectSQL = this.takeSQLBill(ctx, this.srcEntryTableName);
        if (bill.isReversed()) {
            this.takeSQLSourceBill(ctx, this.srcEntryTableName, selectSQL, writeOffBillMap, bill);
        } else {
            if (this.isWriteOffWithBlueBill || this.isCrossPeriodNotWriteOff) {
                this.takeBlueBill(ctx, bill, this.srcEntryTableName, writeOffBillMap);
            }
            if (bill.isWriteOff()) {
                this.takeArApBills(ctx, bill, this.destEntryTableName, writeOffBillMap);
            }
        }
        return writeOffBillMap;
    }

    @Override
    protected String getBlueBillWhereSQL(Context ctx, CalculateWrittenOffBill bill) throws BOSException {
        String orderEntryId;
        StringBuffer sSQL = new StringBuffer();
        String billID = bill.getId().toString();
        sSQL.append(" where Entry.FUnWriteOffQty <> 0 ");
        sSQL.append(" and Entry.FCompanyOrgUnitId = '").append(this.companyOrgUnitInfo.getId().toString()).append("'");
        if (RedBlueEnum.BLUE.equals((Object)this.billDirection)) {
            sSQL.append(" and Entry.FBaseQty < 0");
        } else {
            sSQL.append(" and Entry.FBaseQty > 0");
        }
        sSQL.append(" and Bill.FBaseStatus = ").append(4);
        if (this.isCrossPeriodNotWriteOff) {
            sSQL.append(" and Bill.FYear = ").append(bill.getPeriodYear()).append(" and Bill.FPeriod = ").append(bill.getPeriod());
        }
        if (!StringUtil.isEmpty((String)(orderEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FPurOrderEntryID")))) {
            sSQL.append(" and Entry.FPurOrderEntryID in (").append(orderEntryId).append(")");
        } else {
            String srcEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FSourceBillEntryId");
            if (!StringUtil.isEmpty((String)srcEntryId)) {
                sSQL.append(" and Entry.FID in (").append(srcEntryId).append(")");
            } else {
                sSQL.append(" and 1 = 2");
            }
        }
        return sSQL.toString();
    }

    @Override
    protected String getArApBillWhereSQL(Context ctx, String billID) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" where Bill.FBillStatus = ").append(3);
        sSQL.append(" and IsNull(Bill.FIsBizBill, 0) = 0");
        sSQL.append(" and Bill.FBillType = ").append(202);
        sSQL.append(" and Entry.FUnwriteOffBaseQty <> 0 ");
        if (this.dischargeType != 0) {
            sSQL.append(" and Bill.FYear * 100 + Bill.FPeriod <= ").append(this.inPeriodYear * 100 + this.inPeriod);
        }
        sSQL.append(" and Bill.FCompanyID = '").append(this.companyOrgUnitInfo.getId()).append("'");
        String orderEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FPurOrderEntryID");
        if (!StringUtil.isEmpty((String)orderEntryId)) {
            sSQL.append(" and Entry.FCoreBillEntryId in (").append(orderEntryId).append(")");
        } else {
            sSQL.append(" and Entry.FSourceBillID = '").append(billID).append("'");
        }
        return sSQL.toString();
    }

    @Override
    protected String getExtendInvBillSelector() {
        return this.getExtendPurInBillSelector();
    }

    public CalculateDiffAmt calculateBillWrittenOff(Context ctx, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill invBill, CalculateWrittenOffEntry invEntry, WriteOffGroupInfo writeoffgroupinfo) throws EASBizException, BOSException {
        Map.Entry mapBill;
        Iterator it;
        boolean isFullWriteOff = false;
        boolean isRevOrBack = false;
        BigDecimal diffAmountTotal = CalConstant.ZERO;
        BigDecimal writeOffQtyTotal = CalConstant.ZERO;
        BigDecimal writeOffAmtTotal = CalConstant.ZERO;
        BigDecimal[] writeOffQtyAndAmount = new BigDecimal[]{writeOffQtyTotal, writeOffAmtTotal, diffAmountTotal};
        CalculateDiffAmt cDiffSum = new CalculateDiffAmt();
        Vector vDiffAmount = new Vector();
        cDiffSum.setVDiffAmt(vDiffAmount);
        cDiffSum.setDiffAmtTotale(writeOffQtyAndAmount[2]);
        if (invEntry.getUnWriteOffQty().compareTo(CalConstant.ZERO) == 0) {
            return cDiffSum;
        }
        CalculateWrittenOffBill apBill = null;
        CalculateWrittenOffGroup billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(invEntry.getSourceIDKey());
        if (billMap != null && !billMap.isEmpty()) {
            it = billMap.entrySet().iterator();
            mapBill = null;
            while (it.hasNext()) {
                mapBill = it.next();
                apBill = (CalculateWrittenOffBill)mapBill.getValue();
                isFullWriteOff = this.writeOffBill(ctx, apBill, invBill, invEntry, writeoffgroupinfo, writeOffQtyAndAmount, vDiffAmount);
            }
            isRevOrBack = true;
        }
        if ((billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(invEntry.getCoreIDKey())) != null && !billMap.isEmpty()) {
            it = billMap.entrySet().iterator();
            mapBill = null;
            while (it.hasNext()) {
                mapBill = it.next();
                apBill = (CalculateWrittenOffBill)mapBill.getValue();
                isFullWriteOff = this.writeOffBill(ctx, apBill, invBill, invEntry, writeoffgroupinfo, writeOffQtyAndAmount, vDiffAmount);
            }
        }
        if (isFullWriteOff) {
            writeOffQtyAndAmount[0] = invEntry.getBaseUnitQty();
            writeOffQtyAndAmount[1] = invEntry.getPurchaseCost();
        }
        isRevOrBack = this.isDevolve && isRevOrBack && invEntry.getDosingType() != 4;
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, writeOffQtyAndAmount[0], writeOffQtyAndAmount[1], invEntry.getBaseUnitPrice(), invBill, invEntry, null);
        if (isRevOrBack) {
            WriteOffHelper.createDevWrittenOffRecord(ctx, invEntry, invBill, writeOffQtyAndAmount[0], writeOffQtyAndAmount[1], this.devWriteOffGroupInfo, 1);
        }
        this.turnOverNoteWriteOffInfo(ctx, invEntry, isRevOrBack);
        if (invEntry.isNeedRetWriteUnitCost() && CalConstant.ZERO.compareTo(writeOffQtyAndAmount[2]) != 0) {
            this.needReCalcPurInEntryIdList.add(invEntry.getId());
        }
        return cDiffSum;
    }

    @Override
    protected boolean writeOffEntry(Context ctx, CalculateWrittenOffEntry invEntry, CalculateWrittenOffEntry apEntry, CalculateWrittenOffBill apBill, WriteOffGroupInfo writeoffgroupinfo, CalculateWrittenOffBill invBill, BigDecimal[] writeOffQtyAndAmount, Vector vDiffAmount) throws EASBizException, BOSException {
        boolean isFullWriteOff = false;
        if (!this.billwriteoff.isCanWriteOff(invEntry, apEntry)) {
            return isFullWriteOff;
        }
        invEntry.setNeedRetWriteUnitCost(this.isNeedReWriteCost(invBill, invEntry));
        if (apBill.getBillType().equals(invBill.getBillType())) {
            invEntry.setNeedRetWriteUnitCost(false);
        }
        BillWrittenOffData bwod = this.billwriteoff.calculateWriteOffDiffAmt(invEntry, apEntry);
        BigDecimal writeOffQty = bwod.getWriteOffQty();
        BigDecimal writeOffAmtInvo = bwod.getWriteOffAmtInvo();
        BigDecimal writeOffAmtBill = bwod.getWriteOffAmtBill();
        isFullWriteOff = bwod.isFullWriteOff();
        BigDecimal diffSum = writeOffAmtInvo.subtract(writeOffAmtBill);
        apEntry.setCurrWriteOffAmt(writeOffAmtInvo);
        apEntry.setCurrWriteOffQty(writeOffQty);
        invEntry.setCurrWriteOffAmt(writeOffAmtBill);
        invEntry.setCurrWriteOffQty(writeOffQty);
        writeOffQtyAndAmount[0] = writeOffQtyAndAmount[0].add(writeOffQty);
        writeOffQtyAndAmount[1] = writeOffQtyAndAmount[1].add(writeOffAmtBill);
        writeOffQtyAndAmount[2] = writeOffQtyAndAmount[2].add(bwod.isNeedReCalculte() ? new BigDecimal("1.00") : CalConstant.ZERO);
        BigDecimal invWriteOffQty = isFullWriteOff ? bwod.getWriteOffQtyInvo() : writeOffQty;
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, invWriteOffQty, writeOffAmtInvo, apEntry.getBaseUnitPrice(), apBill, apEntry, null);
        if (this.isDevolve && "t_im_purinwarehsentry".equalsIgnoreCase(apEntry.getTableName())) {
            WriteOffHelper.createDevWrittenOffRecord(ctx, apEntry, apBill, invWriteOffQty, writeOffAmtInvo, this.devWriteOffGroupInfo, 1);
        }
        this.turnOverNoteWriteOffInfo(ctx, apEntry, this.isDevolve);
        if (this.isNeedCreateCostAdjBill(diffSum, invBill, apBill)) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("writeOffNoteSeq", new Integer(invEntry.getSeq()));
            infoMap.put("diffSum", diffSum);
            infoMap.put("OtherbillPrice", apEntry.getBaseUnitPrice());
            infoMap.put("writetenOff_Entry", apEntry);
            vDiffAmount.add(infoMap);
        }
        if (invEntry.isNeedRetWriteUnitCost() && CalConstant.ZERO.compareTo(invEntry.getReverseQty()) < 0) {
            this.handleFullReverseBill(ctx, invEntry, this.isDevolve);
        }
        return isFullWriteOff;
    }

    @Override
    protected CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException {
        return CalculateKindEnum.INPUT_WAREHOUSE;
    }
}

