/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractArApCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.BillWrittenOffData;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.newutil.WriteOffHelper;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonFacade;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;

public class Sale2IncomeConfirmCalculate
extends AbstractArApCalculate {
    @Override
    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        MappingConditionEntryCollection mappingEntryColl = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE mappingCondition.number = '013' AND isFlowWriteOff = 1 order by flowWriteOffSeq, mappingField.seq");
        FilterInfo mainFilter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(scminfo.getId().toString());
        mainFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        mainFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3, CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("billType", (Object)"301", CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)0, CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
        FilterInfo secFilter = new FilterInfo();
        secFilter.getFilterItems().add(new FilterItemInfo("entry.unwriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
        secFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        secFilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        secFilter.getFilterItems().add(new FilterItemInfo("transactionType.isWriteOff", (Object)Boolean.TRUE, CompareType.EQUALS));
        secFilter.getFilterItems().add(new FilterItemInfo("entry.isIncomeConfirm", (Object)BigDecimal.ONE, CompareType.EQUALS));
        WriteOffCommonParams params = new WriteOffCommonParams();
        params.setFlowWriteOff(true);
        params.setFlowWfBillId(scminfo.getId().toString());
        params.setFromMain(true);
        params.setStrategy("inComeConfirmWriteOff");
        params.setCompanyId(this.companyOrgUnitInfo.getId().toString());
        params.setMainEntityId("A8378ABC");
        params.setSecEntityId("CC3E933B");
        params.setMainQueryName("com.kingdee.eas.fi.ar.app.IncomeConfirmBillQuery");
        params.setSecQueryName("com.kingdee.eas.scm.im.inv.SaleIssueBillQuery");
        params.setMainEntryIdField("entry.id");
        params.setSecEntryIdField("entry.id");
        params.put((Object)"mainFilter", (Object)mainFilter);
        params.put((Object)"secFilter", (Object)secFilter);
        SorterItemCollection mainSorter = new SorterItemCollection();
        mainSorter.add(new SorterItemInfo("billDate"));
        params.put((Object)"mainSorter", (Object)mainSorter);
        SorterItemCollection secSorter = new SorterItemCollection();
        secSorter.add(new SorterItemInfo("bizDate"));
        secSorter.add(new SorterItemInfo("auditTime"));
        params.put((Object)"secSorter", (Object)secSorter);
        IWriteOffCommonFacade iWriteOffCommonFacade = WriteOffCommonFacadeFactory.getLocalInstance((Context)ctx);
        HashMap cacheMap = new HashMap();
        int size = mappingEntryColl.size();
        for (int i = 0; i < size; ++i) {
            params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
            iWriteOffCommonFacade.flowWriteOff(params, mappingEntryColl, cacheMap);
        }
    }

    @Override
    protected String getInventoryBillWhereSQL(Context ctx, String billID) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" Where Entry.FCompanyOrgUnitId = '").append(this.companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" and Bill.FBaseStatus = ").append(4);
        sSQL.append(" and TransType.FIsWriteOff = 1 ");
        sSQL.append(" and Entry.FUnWriteOffQty <> 0 ");
        String orderEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FCoreBillEntryId");
        if (!StringUtil.isEmpty((String)orderEntryId)) {
            sSQL.append(" and Entry.FSaleOrderEntryID in (").append(orderEntryId).append(")");
        } else {
            String srcEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FSourceBillEntryId");
            if (!StringUtil.isEmpty((String)srcEntryId)) {
                sSQL.append(" and Entry.FID in (").append(srcEntryId).append(")");
            } else {
                sSQL.append(" and 1 = 2");
            }
        }
        return sSQL.toString();
    }

    @Override
    protected String getExtendInvBillSelector() {
        return this.getExtendSaleIssueBillSelector();
    }

    @Override
    protected CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException {
        return CalculateKindEnum.OUTPUT_WAREHOUSE;
    }

    @Override
    protected boolean writeOffEntry(Context ctx, CalculateWrittenOffEntry entry, CalculateWrittenOffEntry invEntry, CalculateWrittenOffBill invBill, WriteOffGroupInfo writeoffgroupinfo, CalculateWrittenOffBill apBill, BigDecimal[] writeOffQtyAndAmount) throws EASBizException, BOSException {
        boolean isFullWriteOff = false;
        if (!this.billwriteoff.isCanWriteOff(entry, invEntry)) {
            return isFullWriteOff;
        }
        BillWrittenOffData bwod = this.billwriteoff.calculateVoucherDiffAmt(invEntry, entry);
        BigDecimal writeOffQty = bwod.getWriteOffQty();
        BigDecimal writeOffAmtInvo = bwod.getWriteOffAmtInvo();
        BigDecimal writeOffAmtBill = bwod.getWriteOffAmtBill();
        isFullWriteOff = bwod.isFullWriteOff();
        writeOffQtyAndAmount[0] = writeOffQtyAndAmount[0].add(writeOffQty);
        writeOffQtyAndAmount[1] = writeOffQtyAndAmount[1].add(writeOffAmtInvo);
        if (isFullWriteOff) {
            writeOffQty = bwod.getWriteOffQtyBill();
        }
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, writeOffQty, writeOffAmtBill, invEntry.getBaseUnitPrice(), invBill, invEntry, apBill.getPaymentType());
        this.turnOverNoteWriteOffInfo(ctx, invEntry);
        return isFullWriteOff;
    }
}

