/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractInventoryCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.BillWrittenOffData;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateDiffAmt;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffGroup;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffHashMap;
import com.kingdee.eas.scm.cal.app.newutil.WriteOffHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonFacade;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleOptFacadeFactory;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SaleOutWarehouseARCalculate
extends AbstractInventoryCalculate {
    protected String paymentType = null;
    private boolean isWriteOffWithBlueBill = true;
    private boolean isCrossPeriodNotWriteOff = false;
    private String paramValue = null;

    @Override
    protected void init(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        super.init(ctx, scminfo);
    }

    @Override
    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        ArrayList entrys;
        SaleIssueBillInfo bill = (SaleIssueBillInfo)scminfo;
        SaleIssueEntryCollection billEntry = bill.getEntry();
        boolean hasIncomeConfirm = false;
        boolean hasNormal = false;
        for (int i = 0; i < billEntry.size(); ++i) {
            if (billEntry.get(i).isIsIncomeConfirm()) {
                hasIncomeConfirm = true;
            } else {
                hasNormal = true;
            }
            if (hasNormal && hasIncomeConfirm) break;
        }
        this.srcEntryTableName = "t_im_saleissueentry";
        StringBuffer selectSQL = this.takeSQLBill(ctx, this.srcEntryTableName);
        boolean isSysBill = scminfo.getBoolean("issysbill");
        CalculateWrittenOffBill saleIssueBill = this.takeWrittenOffBill(ctx, (CoreBillBaseInfo)bill, this.srcEntryTableName, selectSQL);
        if (saleIssueBill == null) {
            return;
        }
        saleIssueBill.setIssysbill(isSysBill);
        if (4 != saleIssueBill.getBaseStatus()) {
            ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx).inverseWriteOff(new String[]{saleIssueBill.getId().toString()}, "102");
        } else {
            int i;
            int size;
            MappingConditionEntryCollection mappingEntryColl;
            entrys = saleIssueBill.getEntry();
            CalculateWrittenOffEntry entry = null;
            int size2 = entrys.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                entry = (CalculateWrittenOffEntry)entrys.get(i2);
                if (bill.isIsInitBill()) continue;
                this.calculator.takeOutWarehouseCost(ctx, saleIssueBill, entry, this.materialCalType, this.takeOutOrInWarehouseKind(), this.srcEntryTableName);
                this.updateIMBill4MoveAddAverage(ctx, entry, false);
            }
            FilterInfo secFilter = new FilterInfo();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(scminfo.getId().toString());
            secFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            secFilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
            secFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            secFilter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
            FilterInfo mainFilter = new FilterInfo();
            mainFilter.getFilterItems().add(new FilterItemInfo("entry.unwriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3, CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)0, CompareType.EQUALS));
            WriteOffCommonParams params = new WriteOffCommonParams();
            params.setFlowWriteOff(true);
            params.setFlowWfBillId(scminfo.getId().toString());
            params.setFromMain(false);
            params.setCompanyId(this.companyOrgUnitInfo.getId().toString());
            params.setSecEntityId("CC3E933B");
            params.setSecQueryName("com.kingdee.eas.scm.im.inv.SaleIssueBillQuery");
            params.setMainEntryIdField("entry.id");
            params.setSecEntryIdField("entry.id");
            params.put((Object)"mainFilter", (Object)mainFilter);
            params.put((Object)"secFilter", (Object)secFilter);
            IWriteOffCommonFacade iWriteOffCommonFacade = WriteOffCommonFacadeFactory.getLocalInstance((Context)ctx);
            MappingConditionEntryInfo mappingInfo = new MappingConditionEntryInfo();
            mappingInfo.getMappingField().addCollection(this.getSameSideMappingField(new String[]{"entry.saleOrderEntry"}));
            HashMap cacheMap = new HashMap();
            if (hasIncomeConfirm) {
                mainFilter.getFilterItems().add(new FilterItemInfo("billType", (Object)"301", CompareType.EQUALS));
                params.setMainEntityId("A8378ABC");
                params.setMainQueryName("com.kingdee.eas.fi.ar.app.IncomeConfirmBillQuery");
                mappingEntryColl = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE mappingCondition.number = '013' AND isFlowWriteOff = 1 order by flowWriteOffSeq, mappingField.seq");
                params.setStrategy("inComeConfirmWriteOff");
                secFilter.getFilterItems().add(new FilterItemInfo("entry.isIncomeConfirm", (Object)1));
                size = mappingEntryColl.size();
                for (i = 0; i < size; ++i) {
                    params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                    iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
                }
                params.put((Object)"mappingEntryInfo", (Object)mappingInfo);
                iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
                size = mappingEntryColl.size();
                for (i = 0; i < size; ++i) {
                    params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                    iWriteOffCommonFacade.flowWriteOff(params, mappingEntryColl, cacheMap);
                }
            }
            if (hasNormal) {
                mainFilter.getFilterItems().add(new FilterItemInfo("billType", (Object)"102", CompareType.EQUALS));
                params.setMainEntityId("FC910EF3");
                params.setMainQueryName("com.kingdee.eas.fi.ar.app.OtherBill");
                mappingEntryColl = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE mappingCondition.number = '002' AND isFlowWriteOff = 1 order by flowWriteOffSeq, mappingField.seq");
                params.setStrategy("saleWriteOff");
                secFilter.getFilterItems().remove(new FilterItemInfo("entry.isIncomeConfirm", (Object)1));
                secFilter.getFilterItems().add(new FilterItemInfo("entry.isIncomeConfirm", (Object)0));
                size = mappingEntryColl.size();
                for (i = 0; i < size; ++i) {
                    params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                    iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
                }
                params.put((Object)"mappingEntryInfo", (Object)mappingInfo);
                iWriteOffCommonFacade.flowWriteOffSameSide(params, mappingEntryColl, cacheMap);
                size = mappingEntryColl.size();
                for (i = 0; i < size; ++i) {
                    params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                    iWriteOffCommonFacade.flowWriteOff(params, mappingEntryColl, cacheMap);
                }
            }
        }
        entrys = saleIssueBill.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)entrys.get(i);
            if (4 == saleIssueBill.getBaseStatus() && !bill.isIsInitBill()) {
                this.calculator.takeOutWarehouseCost(ctx, saleIssueBill, entry, this.materialCalType, this.takeOutOrInWarehouseKind(), this.srcEntryTableName);
                this.updateIMBill4MoveAddAverage(ctx, entry, true);
            }
            if (RecIssueTypeConstant.CONSIGNOUT_RITYPEID == saleIssueBill.getRecIssueType() || RecIssueTypeConstant.CONSIGNRT_RITYPEID == saleIssueBill.getRecIssueType() || bill.isIsInitBill()) continue;
            this.calculator.calculateCost(ctx, this.companyOrgUnitInfo, this.periodInfo, this.materialCalType, entry.getAmount().multiply(CalConstant.ONE_MINUS), entry.getBaseUnitQty().multiply(CalConstant.ONE_MINUS), saleIssueBill, entry, true);
        }
        if (4 != saleIssueBill.getBaseStatus()) {
            VMISettleOptFacadeFactory.getLocalInstance((Context)ctx).redBlueUnSettle((IObjectValue)bill, "50957179-0105-1000-e000-015bc0a812fd463ED552");
        } else {
            VMISettleOptFacadeFactory.getLocalInstance((Context)ctx).redBlueSettle((IObjectValue)bill, "50957179-0105-1000-e000-015bc0a812fd463ED552");
        }
    }

    private void updateIMBill4MoveAddAverage(Context ctx, CalculateWrittenOffEntry calEntry, Boolean updateMoveAverage) throws EASBizException, BOSException {
        StringBuffer sql;
        String tableName = calEntry.getTableName();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        if (!updateMoveAverage.booleanValue()) {
            if (this.paramValue == null) {
                this.paramValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectStringPK(calEntry.getFinanceOrg().getId().toString()), "AR_032");
            }
            if ("true".equals(this.paramValue) || "false".equals(this.paramValue) && !calEntry.isPresent()) {
                hm.put("FUnWriteOffBaseQty", calEntry.getBaseUnitQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
                hm.put("FWrittenOffBaseQty", ZERO.setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
                hm.put("FUnWriteOffQty", calEntry.getQty().setScale(calEntry.getPrecision().getQtyPrecision(), 4));
                hm.put("FWrittenOffQty", ZERO.setScale(calEntry.getPrecision().getQtyPrecision(), 4));
                hm.put("FUnWriteOffAmount", calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
                hm.put("FWrittenOffAmount", ZERO.setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            } else {
                hm.put("FUnWriteOffAmount", ZERO.setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
                hm.put("FWrittenOffAmount", calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            }
        }
        if (AccountType.MOVE_ADD_AVERAGE.equals((Object)calEntry.getMaterialAccountType()) && updateMoveAverage.booleanValue()) {
            hm.put("FActualCost", calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            if (calEntry.getMaterialBaseUnit() != null && calEntry.getMaterialUnit() != null && calEntry.getMaterialUnit().equals((Object)calEntry.getMaterialBaseUnit())) {
                hm.put("FUnitActualCost", calEntry.getInvoUnitPrice());
            } else {
                hm.put("FUnitActualCost", "ROUND(" + CalculateUtil.to_decimal_divide(StringUtil.bigDecimal2String((BigDecimal)calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4)) + "/fQty") + "," + calEntry.getPrecision().getPricePrecision() + ")");
            }
        }
        if ((sql = this.createSQL4SaleWriteOff(tableName, hm, calEntry.getId())).length() > 0) {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void initParam(Context ctx) throws BOSException, EASBizException {
        String[] numbers = new String[]{"SCM_CAL_020"};
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap paramMap = ipc.getParamHashMap(numbers, this.companyOrgUnitInfo.getId().toString());
        Object param = paramMap.get("SCM_CAL_020");
        int value = Integer.parseInt(param != null ? param.toString() : "0");
        this.isWriteOffWithBlueBill = value == 0;
        this.isCrossPeriodNotWriteOff = value == 2;
    }

    protected CalculateWrittenOffHashMap getWriteOffBillMap(Context ctx, CalculateWrittenOffBill bill) throws BOSException, EASBizException {
        CalculateWrittenOffHashMap writeOffBillMap = new CalculateWrittenOffHashMap();
        StringBuffer selectSQL = this.takeSQLBill(ctx, this.srcEntryTableName);
        if (bill.isReversed()) {
            this.takeSQLSourceBill(ctx, this.srcEntryTableName, selectSQL, writeOffBillMap, bill);
        } else {
            if (this.isWriteOffWithBlueBill || this.isCrossPeriodNotWriteOff) {
                this.takeBlueBill(ctx, bill, this.srcEntryTableName, writeOffBillMap);
            }
            if (bill.isWriteOff()) {
                this.takeArApBills(ctx, bill, this.destEntryTableName, writeOffBillMap);
            }
        }
        return writeOffBillMap;
    }

    @Override
    protected String getBlueBillWhereSQL(Context ctx, CalculateWrittenOffBill bill) throws BOSException {
        String orderEntryId;
        StringBuffer sSQL = new StringBuffer();
        String billID = bill.getId().toString();
        sSQL.append(" where Entry.FUnWriteOffQty <> 0 ");
        sSQL.append(" and Entry.FCompanyOrgUnitId = '").append(this.companyOrgUnitInfo.getId().toString()).append("'");
        if (RedBlueEnum.BLUE.equals((Object)this.billDirection)) {
            sSQL.append(" and Entry.FBaseQty < 0");
        } else {
            sSQL.append(" and Entry.FBaseQty > 0");
        }
        sSQL.append(" and Bill.FBaseStatus = ").append(4);
        if (this.isCrossPeriodNotWriteOff) {
            sSQL.append(" and Bill.FYear = ").append(bill.getPeriodYear()).append(" and Bill.FPeriod = ").append(bill.getPeriod());
        }
        if (!StringUtil.isEmpty((String)(orderEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FSaleOrderEntryID")))) {
            sSQL.append(" and Entry.FSaleOrderEntryID in (").append(orderEntryId).append(")");
        } else {
            String srcEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FSourceBillEntryId");
            if (!StringUtil.isEmpty((String)srcEntryId)) {
                sSQL.append(" and Entry.FID in (").append(srcEntryId).append(")");
            } else {
                sSQL.append(" and 1 = 2");
            }
        }
        return sSQL.toString();
    }

    @Override
    protected String getArApBillWhereSQL(Context ctx, String billID) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" where Bill.FBillStatus = ").append(3);
        sSQL.append(" and Bill.FIsBizBill = 0");
        sSQL.append(" and Bill.FBillType = ").append(102);
        sSQL.append(" and Bill.FCompanyID = '").append(this.companyOrgUnitInfo.getId()).append("'");
        sSQL.append(" and Entry.FUnwriteOffBaseQty <> 0 ");
        String orderEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FSaleOrderEntryID");
        if (!StringUtil.isEmpty((String)orderEntryId)) {
            sSQL.append(" and Entry.FCoreBillEntryId in (").append(orderEntryId).append(")");
        } else {
            sSQL.append(" and Entry.FSourceBillID = '").append(billID).append("'");
        }
        return sSQL.toString();
    }

    @Override
    protected String getExtendInvBillSelector() {
        return this.getExtendSaleIssueBillSelector();
    }

    public CalculateDiffAmt calculateBillWrittenOff(Context ctx, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill InvBill, CalculateWrittenOffEntry invEntry, WriteOffGroupInfo writeoffgroupinfo) throws EASBizException, BOSException {
        Map.Entry mapBill;
        Iterator it;
        if (!(invEntry.getUnWriteOffQty().compareTo(CalConstant.ZERO) != 0 || invEntry.isPresent() && AccountType.MOVE_ADD_AVERAGE.equals((Object)invEntry.getMaterialAccountType()))) {
            return null;
        }
        Vector vDiffSum = new Vector();
        BigDecimal diffAmountTotal = CalConstant.ZERO;
        BigDecimal writeOffQtyTotal = CalConstant.ZERO;
        BigDecimal writeOffAmtTotal = CalConstant.ZERO;
        BigDecimal[] writeOffQtyAndAmount = new BigDecimal[]{writeOffQtyTotal, writeOffAmtTotal, diffAmountTotal};
        boolean isFullWriteOff = false;
        CalculateWrittenOffBill arBill = null;
        CalculateWrittenOffGroup billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(invEntry.getSourceIDKey());
        if (billMap != null && !billMap.isEmpty()) {
            it = billMap.entrySet().iterator();
            mapBill = null;
            while (it.hasNext()) {
                mapBill = it.next();
                arBill = (CalculateWrittenOffBill)mapBill.getValue();
                isFullWriteOff = this.writeOffBill(ctx, arBill, InvBill, invEntry, writeoffgroupinfo, writeOffQtyAndAmount, vDiffSum);
            }
        }
        if ((billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(invEntry.getCoreIDKey())) != null && !billMap.isEmpty()) {
            it = billMap.entrySet().iterator();
            mapBill = null;
            while (it.hasNext()) {
                mapBill = it.next();
                arBill = (CalculateWrittenOffBill)mapBill.getValue();
                isFullWriteOff = this.writeOffBill(ctx, arBill, InvBill, invEntry, writeoffgroupinfo, writeOffQtyAndAmount, vDiffSum);
            }
        }
        if (isFullWriteOff) {
            writeOffQtyAndAmount[0] = invEntry.getBaseUnitQty();
            writeOffQtyAndAmount[1] = invEntry.getAmount();
        }
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, writeOffQtyAndAmount[0], writeOffQtyAndAmount[1], invEntry.getBaseUnitPrice(), InvBill, invEntry, this.paymentType);
        this.turnOverNoteWriteOffInfo(ctx, invEntry);
        return null;
    }

    @Override
    protected CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException {
        return CalculateKindEnum.OUTPUT_WAREHOUSE;
    }

    @Override
    protected boolean writeOffEntry(Context ctx, CalculateWrittenOffEntry invEntry, CalculateWrittenOffEntry arEntry, CalculateWrittenOffBill arBill, WriteOffGroupInfo writeoffgroupinfo, CalculateWrittenOffBill invBill, BigDecimal[] writeOffQtyAndAmount, Vector vDiffAmount) throws EASBizException, BOSException {
        boolean isFullWriteOff = false;
        if (!this.billwriteoff.isCanWriteOff(invEntry, arEntry)) {
            return isFullWriteOff;
        }
        if (StringUtil.isEmpty((String)this.paymentType)) {
            this.paymentType = arBill.getPaymentType();
        }
        BillWrittenOffData bwod = this.billwriteoff.calculateVoucherDiffAmt(invEntry, arEntry);
        BigDecimal writeOffQty = bwod.getWriteOffQty();
        BigDecimal writeOffAmtInvo = bwod.getWriteOffAmtInvo();
        BigDecimal writeOffAmtBill = bwod.getWriteOffAmtBill();
        BigDecimal diffSum = writeOffAmtInvo.subtract(writeOffAmtBill);
        isFullWriteOff = bwod.isFullWriteOff();
        writeOffQtyAndAmount[0] = writeOffQtyAndAmount[0].add(writeOffQty);
        writeOffQtyAndAmount[1] = writeOffQtyAndAmount[1].add(writeOffAmtBill);
        writeOffQtyAndAmount[2] = writeOffQtyAndAmount[2].add(diffSum);
        if (isFullWriteOff) {
            writeOffQty = bwod.getWriteOffQtyInvo();
        }
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, writeOffQty, writeOffAmtInvo, arEntry.getBaseUnitPrice(), arBill, arEntry, arBill.getPaymentType());
        this.turnOverNoteWriteOffInfo(ctx, arEntry);
        return isFullWriteOff;
    }
}

