/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionException;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.ManualWriteOffException;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordCollection;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class CostAdjustHelp {
    public static String takeCostAdjustBillNumber(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String billNumber) {
        String number = "";
        if (billNumber == null || "".equals(billNumber)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CostAdjustBillInfo cabi = new CostAdjustBillInfo();
                String companyid = aCompanyOrgUnitInfo.getId().toString();
                if (companyid != null && iCodingRuleManager.isExist((IObjectValue)cabi, companyid)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)cabi, aCompanyOrgUnitInfo.getId().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((number == null || "".equals(number)) && (number = new StringBuffer("CA-").append(billNumber).append("-").append(System.currentTimeMillis()).toString()).length() > 80) {
            number = number.substring(80);
        }
        return number;
    }

    public static String creatCostAdjustBillNumber(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String billNumber) {
        String number = "";
        if (billNumber == null || "".equals(billNumber)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CostAdjustBillInfo cabi = new CostAdjustBillInfo();
                String companyid = aCompanyOrgUnitInfo.getId().toString();
                if (companyid != null && iCodingRuleManager.isExist((IObjectValue)cabi, companyid)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)cabi, aCompanyOrgUnitInfo.getId().toString());
                }
            }
            catch (Exception iCodingRuleManager) {
                // empty catch block
            }
        }
        if (number == null || "".equals(number.trim())) {
            SecureRandom ran3 = new SecureRandom();
            StringBuffer temp = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                temp.append(ran3.nextInt());
            }
            String temp2 = temp.substring(0, 10);
            number = new StringBuffer("CA-").append(billNumber).append("-").append(System.currentTimeMillis()).append(temp2).toString();
            if (number.length() > 80) {
                number = number.substring(80);
            }
        }
        return number;
    }

    public static StringBuffer createCostAdjustBillSQL(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo periodInfo, ResultSet rs, ObjectUuidPK billid, String storageorgid, int outwarehouseType, String number, String CostCenter) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        long time = new Date().getTime();
        if (periodInfo.getEndDate() != null) {
            time = periodInfo.getEndDate().getTime();
        }
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",FIsInitBill,FCreateType,FCostCenterOrgUnitID");
        sql.append(") Values(");
        sql.append("'").append(billid.toString()).append("'");
        sql.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(",'").append(number).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new Date(time))).append("')");
        sql.append(",0");
        sql.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(",").append(4);
        sql.append(",'").append(storageorgid).append("'");
        sql.append(",").append("NULL").append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",").append(1).append("");
        sql.append(",").append(outwarehouseType).append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",'").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sql.append(",").append(periodInfo.getPeriodNumber());
        sql.append(",").append(periodInfo.getPeriodYear());
        sql.append(",0");
        sql.append(",").append(3);
        if (CostCenter == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(CostCenter).append("'");
        }
        sql.append(")");
        return sql;
    }

    public static StringBuffer createCostAdjustBillSQL(CostAdjustBillInfo billinfo) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",FIsInitBill,FCreateType,FSupplierID,FCustomerID,FSourceBillID,FAdminOrgUnitID,FCostCenterOrgUnitID");
        sql.append(") Values(");
        sql.append("'").append(billinfo.getId()).append("'");
        if (billinfo.getCreator() != null) {
            sql.append(",'").append(billinfo.getCreator().getId()).append("'");
        } else {
            sql.append(",NULL");
        }
        sql.append(",TO_DATE('").append(sdf.format(billinfo.getCreateTime())).append("')");
        if (billinfo.getLastUpdateUser() != null) {
            sql.append(",'").append(billinfo.getLastUpdateUser().getId()).append("'");
        } else {
            sql.append(",null");
        }
        if (billinfo.getLastUpdateTime() != null) {
            sql.append(",TO_DATE('").append(sdf.format(billinfo.getLastUpdateTime())).append("')");
        } else {
            sql.append(",NULL");
        }
        sql.append(",'").append(billinfo.getCU().getId()).append("'");
        sql.append(",'").append(billinfo.getNumber()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(billinfo.getBizDate())).append("')");
        sql.append(",0");
        String auditor = null;
        if (billinfo.getAuditor() != null) {
            auditor = billinfo.getAuditor().getId().toString();
        }
        sql.append(",'").append(auditor).append("'");
        sql.append(",TO_DATE('").append(sdf.format(billinfo.getAuditTime())).append("')");
        sql.append(",").append(billinfo.getBaseStatus().getValue());
        sql.append(",'").append(billinfo.getStorageOrgUnit().getId()).append("'");
        sql.append(",").append("NULL").append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",").append(billinfo.getCalculateKind().getValue()).append("");
        sql.append(",").append(billinfo.getIssueType().getValue()).append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",'").append(billinfo.getBillType().getId()).append("'");
        sql.append(",").append(billinfo.getPeriod());
        sql.append(",").append(billinfo.getYear());
        sql.append(",0");
        sql.append(",").append(billinfo.getCreateType().getValue());
        if (billinfo.getSupplier() == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(billinfo.getSupplier().getId()).append("'");
        }
        if (billinfo.getCustomer() == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(billinfo.getCustomer().getId()).append("'");
        }
        sql.append(",'" + billinfo.getSourceBillId()).append("'");
        if (billinfo.getAdminOrgUnit() != null) {
            sql.append(",'").append(billinfo.getAdminOrgUnit().getId()).append("'");
        } else {
            sql.append(",NULL");
        }
        if (billinfo.getCostCenterOrgUnit() == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(billinfo.getCostCenterOrgUnit().getId()).append("'");
        }
        sql.append(")");
        return sql;
    }

    public static CostAdjustBillInfo createCostAdjustBill(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, StorageOrgUnitInfo storage, HashMap period, CalculateKindEnum aCostAdjustTypeEnum, CalculateWrittenOffBill calculateWrittenOffBill, boolean isDevolve) throws EASBizException, BOSException {
        CostAdjustBillInfo cabi = new CostAdjustBillInfo();
        cabi.setId(BOSUuid.create((BOSObjectType)cabi.getBOSType()));
        cabi.setNumber(CostAdjustHelp.takeCostAdjustBillNumber(ctx, aCompanyOrgUnitInfo, calculateWrittenOffBill.getNumber()));
        cabi.setCalculateKind(aCostAdjustTypeEnum);
        cabi.setIssueType(IssueTypeEnum.NULL);
        if (period != null) {
            cabi.setBizDate((Date)period.get("d"));
            cabi.setYear(((PeriodInfo)period.get("p")).getPeriodYear());
            cabi.setPeriod(((PeriodInfo)period.get("p")).getPeriodNumber());
        }
        if (aCostAdjustTypeEnum == CalculateKindEnum.OUTPUT_WAREHOUSE) {
            cabi.setIssueType(IssueTypeEnum.SALEISSUEBILL);
        }
        cabi.setStorageOrgUnit(storage);
        SupplierInfo supplierinfo = null;
        if (calculateWrittenOffBill.getSupplier() != null && calculateWrittenOffBill.getSupplier().trim().length() > 0) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(BOSUuid.read((String)calculateWrittenOffBill.getSupplier()));
        }
        CustomerInfo customerinfo = null;
        if (calculateWrittenOffBill.getCustomer() != null && calculateWrittenOffBill.getCustomer().trim().length() > 0) {
            customerinfo = new CustomerInfo();
            customerinfo.setId(BOSUuid.read((String)calculateWrittenOffBill.getCustomer()));
        }
        cabi.setSupplier(supplierinfo);
        cabi.setCustomer(customerinfo);
        cabi.setIsInitBill(false);
        cabi.setIsReversed(false);
        cabi.setFiVouchered(false);
        cabi.setTotalActualCost(CalculateUtil.ZERO);
        cabi.setTotalStandardCost(CalculateUtil.ZERO);
        cabi.setTotalAmount(CalculateUtil.ZERO);
        cabi.setTotalQty(CalculateUtil.ZERO);
        cabi.setCreateTime(new Timestamp(new Date().getTime()));
        cabi.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        cabi.setLastUpdateTime(new Timestamp(new Date().getTime()));
        cabi.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        cabi.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        cabi.setAuditTime(new Timestamp(new Date().getTime()));
        cabi.setBaseStatus(BillBaseStatusEnum.AUDITED);
        if (isDevolve) {
            cabi.setCreateType(CostAdjuestCreateTypeEnum.DEV_AUTOCREATE);
        } else {
            cabi.setCreateType(CostAdjuestCreateTypeEnum.AUTOCREATE);
        }
        cabi.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        AdminOrgUnitInfo adminOrgUnit = null;
        if (calculateWrittenOffBill.getAdminOrgUnit() != null && calculateWrittenOffBill.getAdminOrgUnit().trim().length() != 0) {
            adminOrgUnit = new AdminOrgUnitInfo();
            adminOrgUnit.setId(BOSUuid.read((String)calculateWrittenOffBill.getAdminOrgUnit()));
        }
        cabi.setAdminOrgUnit(adminOrgUnit);
        CostCenterOrgUnitInfo costCenter = null;
        if (calculateWrittenOffBill.getCostCenter() != null && calculateWrittenOffBill.getCostCenter().trim().length() != 0) {
            costCenter = new CostCenterOrgUnitInfo();
            costCenter.setId(BOSUuid.read((String)calculateWrittenOffBill.getCostCenter()));
        }
        cabi.setCostCenterOrgUnit(costCenter);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
        cabi.setBillType(aBillTypeInfo);
        return cabi;
    }

    public static void setCostAdjustBillPeriod(HashMap period, CostAdjustBillInfo cabi, WriteOffGroupInfo writeoffgroupinfo) {
        cabi.setBizDate((Date)period.get("d"));
        cabi.setYear(((PeriodInfo)period.get("p")).getPeriodYear());
        cabi.setPeriod(((PeriodInfo)period.get("p")).getPeriodNumber());
        WriteOffRecordCollection collection = writeoffgroupinfo.getEntry();
        for (int i = 0; collection != null && i < collection.size(); ++i) {
            WriteOffRecordInfo writeOffRecordInfo = collection.get(i);
            if (!"410".equals(writeOffRecordInfo.getBillTypeNumber())) continue;
            writeOffRecordInfo.setBillDate(cabi.getBizDate());
        }
    }

    public static StringBuffer createCostAdjustEntrySQL(ObjectUuidPK billid, ObjectUuidPK entryid, PeriodInfo periodInfo, ResultSet rs, int i, int Local_Currency_Presision) throws SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        long time = new Date().getTime();
        if (periodInfo.getEndDate() != null) {
            time = periodInfo.getEndDate().getTime();
        }
        String amount = StringUtil.toString((BigDecimal)rs.getBigDecimal("FIssueCostDiffAmt").setScale(Local_Currency_Presision, 4));
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID");
        sqlentry.append(",FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID");
        sqlentry.append(",FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty,FCostObjectId,FCostObjectSuiteID,FCostItemID,FIsReWork");
        sqlentry.append(",FStoreTypeID,FStoreStatusID,FBizDate");
        sqlentry.append(")Values(");
        sqlentry.append("'").append(entryid.toString()).append("'");
        sqlentry.append(",").append(i);
        sqlentry.append(",0");
        sqlentry.append(",").append(4).append("");
        sqlentry.append(",'").append(rs.getString("FMaterialID")).append("'");
        sqlentry.append(",NULL");
        sqlentry.append(",NULL");
        sqlentry.append(",'").append(rs.getString("FStorageOrgUnitId")).append("'");
        sqlentry.append(",'").append(rs.getString("FCompanyOrgUnitId")).append("'");
        sqlentry.append(",'").append(rs.getString("FWarehouseId")).append("'");
        sqlentry.append(",NULL");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",").append(amount).append("");
        sqlentry.append(",0");
        sqlentry.append(",").append(amount);
        sqlentry.append(",0");
        sqlentry.append(",").append(amount);
        sqlentry.append(",'").append(billid.toString()).append("'");
        sqlentry.append(",0");
        sqlentry.append(",0");
        String costObject = rs.getString("FCostObject");
        if (costObject == null) {
            sqlentry.append(",NULL");
        } else {
            sqlentry.append(",'").append(costObject).append("'");
        }
        String costObjectsuite = rs.getString("FCostObjectSuiteID");
        if (costObjectsuite == null) {
            sqlentry.append(",NULL");
        } else {
            sqlentry.append(",'").append(costObjectsuite).append("'");
        }
        String costitem = rs.getString("FCostItemID");
        if (costitem == null) {
            sqlentry.append(",NULL");
        } else {
            sqlentry.append(",'").append(costitem).append("'");
        }
        boolean isReWork = rs.getBoolean("FIsReWork");
        if (!isReWork) {
            sqlentry.append(",0");
        } else {
            sqlentry.append(",1");
        }
        sqlentry.append(",'").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        sqlentry.append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
        sqlentry.append(",TO_DATE('").append(sdf.format(new Date(time))).append("')");
        sqlentry.append(")");
        return sqlentry;
    }

    public static StringBuffer createCostAdjustEntrySQL(BOSUuid uuid, CostAdjustBillEntryInfo entryinfo, boolean isAdjust, boolean isSpecialAcc) throws EASBizException, BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID,FAssistPropertyID");
        sqlentry.append(",FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID");
        sqlentry.append(",FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty");
        sqlentry.append(",FReturnBaseQty,FReverseBaseQty");
        sqlentry.append(",FSOURCEBILLID,FSOURCEBILLNUMBER,FSOURCEBILLENTRYID,FSOURCEBILLENTRYSEQ,FStoreTypeID,FStoreStatusID,FLocationID,FIsDischg");
        sqlentry.append(",FBizDate");
        sqlentry.append(",FProjectID,FTrackNumberID");
        sqlentry.append(")Values(");
        sqlentry.append("'").append(entryinfo.getId()).append("'");
        sqlentry.append(",").append(entryinfo.getSeq());
        sqlentry.append(",0");
        sqlentry.append(",").append(entryinfo.getBaseStatus().getValue()).append("");
        sqlentry.append(",'").append(entryinfo.getMaterial().getId()).append("'");
        if (isAdjust && entryinfo.getAssistProperty() != null) {
            sqlentry.append(",'").append(entryinfo.getAssistProperty().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getUnit().getId().toString()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getBaseUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getBaseUnit().getId().toString()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getStorageOrgUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getStorageOrgUnit().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getCompanyOrgUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getCompanyOrgUnit().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getWarehouse() != null) {
            sqlentry.append(",'").append(entryinfo.getWarehouse().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if ((isAdjust || isSpecialAcc) && null != entryinfo.getLot()) {
            sqlentry.append(",'").append(entryinfo.getLot()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getQty() == null ? CalculateUtil.ZERO : entryinfo.getQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getBaseQty() == null ? CalculateUtil.ZERO : entryinfo.getBaseQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getAssistQty() == null ? CalculateUtil.ZERO : entryinfo.getAssistQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getReverseQty() == null ? CalculateUtil.ZERO : entryinfo.getReverseQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getReturnsQty() == null ? CalculateUtil.ZERO : entryinfo.getReturnsQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getPrice() == null ? CalculateUtil.ZERO : entryinfo.getPrice())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getAmount() == null ? CalculateUtil.ZERO : entryinfo.getAmount()))).append("");
        sqlentry.append(",0");
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getStandardCost() == null ? CalculateUtil.ZERO : entryinfo.getStandardCost())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getUnitActualCost() == null ? CalculateUtil.ZERO : entryinfo.getUnitActualCost())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getActualCost() == null ? CalculateUtil.ZERO : entryinfo.getActualCost())));
        sqlentry.append(",'").append(uuid).append("'");
        sqlentry.append(",0");
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getAssociateQty() == null ? CalculateUtil.ZERO : entryinfo.getAssociateQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getReturnBaseQty() == null ? CalculateUtil.ZERO : entryinfo.getReturnBaseQty())));
        sqlentry.append(",").append(StringUtil.toString((BigDecimal)(entryinfo.getReverseBaseQty() == null ? CalculateUtil.ZERO : entryinfo.getReverseBaseQty())));
        sqlentry.append(",'").append(entryinfo.getSourceBillId() == null ? "" : entryinfo.getSourceBillId()).append("'");
        sqlentry.append(",'").append(entryinfo.getSourceBillNumber() == null ? "" : entryinfo.getSourceBillNumber()).append("'");
        sqlentry.append(",'").append(entryinfo.getSourceBillEntryId() == null ? "" : entryinfo.getSourceBillEntryId()).append("'");
        sqlentry.append(",").append(entryinfo.getSourceBillEntrySeq());
        sqlentry.append(",'").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        sqlentry.append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
        if (entryinfo.getLocation() != null && entryinfo.getLocation().getId() != null) {
            sqlentry.append(",'").append(entryinfo.getLocation().getId().toString()).append("'");
        } else {
            sqlentry.append(",''");
        }
        sqlentry.append(",").append(entryinfo.isIsDischg() ? 1 : 0);
        sqlentry.append(",TO_DATE('").append(sdf.format(entryinfo.getBizDate())).append("')");
        if (entryinfo.getProject() != null && entryinfo.getProject().getId() != null) {
            sqlentry.append(",'").append(entryinfo.getProject().getId().toString()).append("'");
        } else {
            sqlentry.append(",''");
        }
        if (entryinfo.getTrackNumber() != null && entryinfo.getTrackNumber().getId() != null) {
            sqlentry.append(",'").append(entryinfo.getTrackNumber().getId().toString()).append("'");
        } else {
            sqlentry.append(",''");
        }
        sqlentry.append(")");
        return sqlentry;
    }

    public static CostAdjustBillEntryInfo createCostAdjustEntry(CalculateWrittenOffBill calBill, CalculateWrittenOffEntry calEntry, int seq, BigDecimal diffSum) throws CalculateException {
        CostAdjustBillEntryInfo caei = null;
        if (CalculateUtil.ZERO.compareTo(diffSum) != 0) {
            caei = new CostAdjustBillEntryInfo();
            caei.setId(BOSUuid.create((BOSObjectType)caei.getBOSType()));
            caei.setSeq(seq + 1);
            caei.setSourceBillId(calBill.getId());
            caei.setSourceBillEntryId(calEntry.getId());
            caei.setIsPresent(false);
            caei.setAssCoefficient(CalculateUtil.ZERO);
            caei.setAmount(diffSum.setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            caei.setPrice(CalculateUtil.ZERO);
            caei.setActualCost(caei.getAmount());
            caei.setUnitActualCost(CalculateUtil.ZERO);
            caei.setStandardCost(caei.getAmount());
            caei.setUnitStandardCost(CalculateUtil.ZERO);
            caei.setQty(CalculateUtil.ZERO);
            caei.setBaseQty(CalculateUtil.ZERO);
            caei.setAssistQty(CalculateUtil.ZERO);
            caei.setAssociateQty(CalculateUtil.ZERO);
            caei.setReturnBaseQty(CalculateUtil.ZERO);
            caei.setReverseBaseQty(CalculateUtil.ZERO);
            caei.setReturnsQty(CalculateUtil.ZERO);
            caei.setReverseQty(CalculateUtil.ZERO);
            caei.setMaterial(calEntry.getMaterial());
            caei.setLot(calEntry.getBatch());
            caei.setBaseUnit(calEntry.getMaterialBaseUnit());
            caei.setUnit(calEntry.getMaterialUnit());
            caei.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            if (calEntry.getWarehouse() == null || calEntry.getWarehouse().getId() == null) {
                throw new CalculateException(CalculateException.WAREHOUSE_NOT_EXIST);
            }
            if (calEntry.getStorageOrg() == null || calEntry.getStorageOrg().getId() == null) {
                throw new CalculateException(CalculateException.STOREAGE_ORG_NOT_EXIST);
            }
            if (calEntry.getFinanceOrg() == null || calEntry.getFinanceOrg().getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            caei.setWarehouse(calEntry.getWarehouse());
            caei.setStorageOrgUnit(calEntry.getStorageOrg());
            caei.setCompanyOrgUnit(calEntry.getFinanceOrg());
        }
        return caei;
    }

    public static CostAdjustBillEntryInfo createCostAdjustEntry2(CalculateWrittenOffBill calBill, CalculateWrittenOffEntry calEntry, int seq, BigDecimal diffSum, boolean isReverseSign, boolean isMerageCostAdjBill) throws CalculateException {
        CostAdjustBillEntryInfo caei = null;
        caei = new CostAdjustBillEntryInfo();
        BigDecimal netno1 = new BigDecimal("-1.00");
        caei.setId(BOSUuid.create((BOSObjectType)caei.getBOSType()));
        caei.setSeq(seq + 1);
        if (isReverseSign) {
            caei.setSourceBillId(calBill.getId());
            caei.setSourceBillEntryId(calEntry.getId());
            caei.setSourceBillNumber(calBill.getNumber());
            caei.setSourceBillEntrySeq(calEntry.getSeq());
        }
        caei.setIsPresent(false);
        caei.setAssCoefficient(CalculateUtil.ZERO);
        if (isMerageCostAdjBill) {
            caei.setAmount(diffSum);
            caei.setActualCost(diffSum);
            caei.setStandardCost(diffSum);
            caei.setQty(CalculateUtil.ZERO);
        } else if (isReverseSign) {
            caei.setAmount(calEntry.getCurrWriteOffAmt().multiply(netno1));
            caei.setActualCost(calEntry.getCurrWriteOffAmt().multiply(netno1));
            caei.setStandardCost(calEntry.getCurrWriteOffAmt().multiply(netno1));
            caei.setQty(CalculateUtil.ZERO.compareTo(caei.getActualCost()) < 0 ? calEntry.getCurrWriteOffQty().abs() : calEntry.getCurrWriteOffQty().abs().negate());
        } else {
            caei.setAmount(calEntry.getCurrWriteOffAmt());
            caei.setActualCost(calEntry.getCurrWriteOffAmt());
            caei.setStandardCost(calEntry.getCurrWriteOffAmt());
            caei.setQty(CalculateUtil.ZERO.compareTo(caei.getActualCost()) < 0 ? calEntry.getCurrWriteOffQty().abs() : calEntry.getCurrWriteOffQty().abs().negate());
        }
        caei.setBaseQty(caei.getQty());
        caei.setAssistQty(CalculateUtil.ZERO);
        caei.setUnitActualCost(calEntry.getBaseUnitPrice());
        if (CalculateUtil.ZERO.compareTo(caei.getQty()) == 0) {
            caei.setPrice(CalculateUtil.ZERO);
        } else {
            caei.setPrice(calEntry.getCurrWriteOffAmt().abs().divide(calEntry.getCurrWriteOffQty().abs(), calEntry.getPrecision().getPricePrecision(), 4));
        }
        caei.setUnitStandardCost(CalculateUtil.ZERO);
        caei.setAssociateQty(CalculateUtil.ZERO);
        caei.setReturnBaseQty(CalculateUtil.ZERO);
        caei.setReverseBaseQty(CalculateUtil.ZERO);
        caei.setReturnsQty(CalculateUtil.ZERO);
        caei.setReverseQty(CalculateUtil.ZERO);
        caei.setMaterial(calEntry.getMaterial());
        caei.setBaseUnit(calEntry.getMaterialBaseUnit());
        caei.setUnit(calEntry.getMaterialBaseUnit());
        caei.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        caei.setLot(calEntry.getBatch());
        caei.setAssistProperty(calEntry.getAssistProperty());
        if (calEntry.getFinanceOrg() == null || calEntry.getFinanceOrg().getId() == null) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        caei.setWarehouse(calEntry.getWarehouse());
        caei.setStorageOrgUnit(calEntry.getStorageOrg());
        caei.setCompanyOrgUnit(calEntry.getFinanceOrg());
        StoreTypeInfo storeType = new StoreTypeInfo();
        storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        StoreStateInfo storeState = new StoreStateInfo();
        storeState.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        caei.setStoreType(storeType);
        caei.setStoreStatus(storeState);
        LocationInfo locationInfo = new LocationInfo();
        if (calEntry.getLocationId() != null) {
            locationInfo.setId(BOSUuid.read((String)calEntry.getLocationId()));
        }
        caei.setLocation(locationInfo);
        if (CalculateUtil.ZERO.compareTo(calEntry.getAmount()) != 0 && CalculateUtil.ZERO.compareTo(diffSum) != 0 && calEntry.getAmount().signum() != diffSum.signum()) {
            caei.setIsDischg(true);
        }
        if (calEntry.getProjectID() != null) {
            ProjectInfo project = new ProjectInfo();
            project.setId(BOSUuid.read((String)calEntry.getProjectID()));
            caei.setProject(project);
        }
        if (calEntry.getTrackNumberID() != null) {
            TrackNumberInfo trackNumber = new TrackNumberInfo();
            trackNumber.setId(BOSUuid.read((String)calEntry.getTrackNumberID()));
            caei.setTrackNumber(trackNumber);
        }
        return caei;
    }

    public static boolean isMergeCostAdjustBill(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        String calType = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyOrgUnitID)), "SCM_CAL_004");
        return calType != null && calType.equalsIgnoreCase("0");
    }

    public static String getPreparedInsertCostadjustBillSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",\n FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",\n FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",\n FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",\n FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",\n FIsInitBill,FCreateType");
        sql.append(") Values(");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?)");
        return sql.toString();
    }

    public static String getPreparedInserCostadjustEntrySQL() {
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("\n FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID");
        sqlentry.append(",\n FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID");
        sqlentry.append(",\n FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",\n FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",\n FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty");
        sqlentry.append(",\n FReturnBaseQty,FReverseBaseQty,FStoreTypeID,FStoreStatusID,FBizDate");
        sqlentry.append(",\n FAssistPropertyID,FProjectID,FTrackNumberID,FISREWORK");
        sqlentry.append(") Values(");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?)");
        return sqlentry.toString();
    }

    public static String getPreparedInsertCostadjustEntrySQL() {
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("\n FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID");
        sqlentry.append(",\n FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID,FLocationID");
        sqlentry.append(",\n FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",\n FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",\n FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty");
        sqlentry.append(",\n FReturnBaseQty,FReverseBaseQty,FStoreTypeID,FStoreStatusID,FCustomerID,FAssistPropertyID,FBizDate");
        sqlentry.append(",\n FProjectID,FTrackNumberID");
        sqlentry.append(") Values(");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,?,?,");
        sqlentry.append("\n ?,?)");
        return sqlentry.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteCostAdjustBill(Context ctx, CalculateParams params, CostAdjuestCreateTypeEnum type, SysTempTableHelper sysTempTableHelper) throws BOSException {
        Set storageOrgBegs;
        String calType;
        String companyId;
        boolean success = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" create table temp (fid varchar(44))");
        String idTempTable = sysTempTableHelper.createTempTable(ctx, sql.toString());
        sql.setLength(0);
        sql.append(" insert into ");
        sql.append(idTempTable).append(" ");
        sql.append("\n SELECT T2.FID  FROM T_CL_COSTADJUSTBILL T2,T_CL_COSTADJUSTBILLENTRY T1 WHERE T2.FID = T1.FPARENTID");
        PeriodInfo period = (PeriodInfo)params.getObject("PERIOD_OBJ");
        if (period != null) {
            sql.append("\n AND T2.FYEAR = ").append(period.getPeriodYear());
            sql.append(" AND T2.FPERIOD = ").append(period.getPeriodNumber());
        }
        if (type != null) {
            sql.append("\n AND T2.FCREATETYPE = ").append(type.getValue());
        }
        if ((companyId = params.getString("COMPANY_ID")) != null) {
            sql.append("\n AND T1.FCOMPANYORGUNITID = '").append(companyId).append("'");
        }
        if ("1".equals(calType = params.getString("CALTYPE"))) {
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sql.append("\n AND T1.FStorageOrgUnitID in ").append(orgIds);
            }
        } else if ("2".equals(calType)) {
            Set wareHouseIds;
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sql.append("\n AND T1.FStorageOrgUnitID in ").append(orgIds);
            }
            if ((wareHouseIds = (Set)params.getObject("WAREHOUSEID")) != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                sql.append("\n AND T1.FWareHouseID in ").append(warehouseIds);
            }
        }
        sql.append("\n AND T2.FFIVOUCHERED = 0 ");
        sql.append(" ");
        try {
            sysTempTableHelper.execute(sql.toString());
            params.setString("tempTable", idTempTable);
            if (params != null) {
                String[] sqls = new String[]{CostAdjustHelp.getDeleteCostAdjBillEntrySql(params, type), CostAdjustHelp.getDeleteCostAdjBillSql(params, type)};
                sysTempTableHelper.execute(sqls);
                success = true;
            }
        }
        finally {
            sysTempTableHelper.releaseTempTable(idTempTable);
        }
        return success;
    }

    public static String getDeleteCostAdjBillSql(CalculateParams params, CostAdjuestCreateTypeEnum type) {
        StringBuffer bufferSql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        bufferSql.append("DELETE FROM T_CL_COSTADJUSTBILL  ");
        bufferSql.append(" where fid in (select fid from ").append(tempTable);
        bufferSql.append(") ");
        return bufferSql.toString();
    }

    public static String getDeleteCostAdjBillEntrySql(CalculateParams params, CostAdjuestCreateTypeEnum type) {
        StringBuffer bufferSql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        bufferSql.append("DELETE FROM T_CL_COSTADJUSTBILLENTRY ");
        bufferSql.append(" where fparentid in (select fid from ").append(tempTable);
        bufferSql.append(") ");
        return bufferSql.toString();
    }

    public static boolean isExistExpAdjZeroCostAdjBill(Context ctx, CalculateParams params, CostAdjuestCreateTypeEnum type, SysTempTableHelper sysTempTableHelper) throws BOSException, CalculateException {
        String orgIds;
        Set storageOrgBegs;
        if (params == null) {
            return false;
        }
        PeriodInfo period = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String companyId = params.getString("COMPANY_ID");
        String calType = params.getString("CALTYPE");
        StringBuffer filterStr = new StringBuffer();
        if (type != null) {
            filterStr.append("T1.FCreateType = ").append(type.getValue());
        }
        if (period != null) {
            filterStr.append("\n AND T1.FYEAR = ").append(period.getPeriodYear());
            filterStr.append("\n AND T1.FPERIOD = ").append(period.getPeriodNumber());
        }
        if (companyId != null) {
            filterStr.append("\n AND T2.FCOMPANYORGUNITID = '").append(companyId).append("'");
        }
        filterStr.append("\n AND T1.FFIVOUCHERED = 1 AND T1.FBASESTATUS = ").append(4);
        if ("1".equals(calType)) {
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                filterStr.append("\n AND T2.FStorageOrgUnitID in ").append(orgIds);
            }
        } else if ("2".equals(calType)) {
            Set wareHouseIds;
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                filterStr.append("\n AND T2.FStorageOrgUnitID in ").append(orgIds);
            }
            if ((wareHouseIds = (Set)params.getObject("WAREHOUSEID")) != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                filterStr.append("\n AND T2.FWareHouseID in ").append(warehouseIds);
            }
        }
        StringBuffer bufferSql = new StringBuffer();
        bufferSql.append("SELECT 1 FROM T_CL_COSTADJUSTBILL T1 ");
        bufferSql.append("\n INNER JOIN T_CL_COSTADJUSTBILLENTRY T2 ON T1.FID = T2.FPARENTID");
        bufferSql.append("\n WHERE ").append(filterStr.toString());
        try {
            IRowSet rowSet = sysTempTableHelper.executeQuery(bufferSql.toString());
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.EXPCOSTADJZERO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static void generateVoucherInNewThread(final Context ctx, final CoreBillBaseCollection collection, final String companyOrgUnititid) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CostAdjustHelp.generAteNewVoucher(ctx, collection, companyOrgUnititid);
                }
                catch (EASBizException eASBizException) {
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public static void generAteNewVoucher(Context ctx, CoreBillBaseCollection collection, String companyOrgUnititid) throws EASBizException, BOSException {
        try {
            if (companyOrgUnititid != null) {
                ICompanyOrgUnit icomp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selColl = new SelectorItemCollection();
                selColl.add(new SelectorItemInfo("id"));
                selColl.add(new SelectorItemInfo("cu"));
                CompanyOrgUnitInfo selectCompany = icomp.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnititid));
                CtrlUnitInfo cu = selectCompany.getCU();
                ObjectUuidPK botMappingPk = null;
                if (cu != null) {
                    IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                    HashMap<String, CtrlUnitInfo> curCtx = new HashMap<String, CtrlUnitInfo>();
                    curCtx.put("TRANSMITCU", cu);
                    String voucherBosType = new VoucherInfo().getBOSType().toString();
                    BOTMappingCollection bc = iBotMapping.getMappingCollectionForSelect(collection, voucherBosType, DefineSysEnum.DAP, curCtx);
                    if (bc.get(0) != null) {
                        botMappingPk = new ObjectUuidPK(bc.get(0).getId());
                    }
                    ICostAdjustBill ii = CostAdjustBillFactory.getLocalInstance(ctx);
                    ii.generateVoucher(collection, (IObjectPK)botMappingPk);
                }
            }
        }
        catch (Exception e) {
            Logger.info((String)e.toString());
        }
    }

    public static CostAdjustBillInfo createCostAdjustBill(CostAdjustBillInfo bill, CostAdjustBillInfo newBill, CalculateKindEnum calculateKind) {
        if (bill != null) {
            newBill.setAuditor(bill.getAuditor());
            newBill.setAdminOrgUnit(bill.getAdminOrgUnit());
            newBill.setBaseStatus(bill.getBaseStatus());
            newBill.setBizDate(bill.getBizDate());
            newBill.setId(BOSUuid.create((BOSObjectType)bill.getBOSType()));
            newBill.setIssueType(IssueTypeEnum.SALEISSUEBILL);
            newBill.setCU(bill.getCU());
            newBill.setCreateTime(bill.getCreateTime());
            newBill.setCreator(bill.getCreator());
            newBill.setLastUpdateUser(bill.getLastUpdateUser());
            newBill.setAuditTime(bill.getAuditTime());
            newBill.setStorageOrgUnit(bill.getStorageOrgUnit());
            newBill.setCalculateKind(calculateKind);
            newBill.setYear(bill.getYear());
            newBill.setPeriod(bill.getPeriod());
            newBill.setSupplier(bill.getSupplier());
            newBill.setCustomer(bill.getCustomer());
            newBill.setLastUpdateTime(bill.getLastUpdateTime());
            newBill.setBillType(bill.getBillType());
            if (bill.getAuditor() == null) {
                newBill.setAuditor(bill.getCreator());
            } else {
                newBill.setAuditor(bill.getAuditor());
            }
        }
        return newBill;
    }

    public static CostAdjustBillEntryInfo createExpCostAdjustEntry(CalculateWrittenOffEntry calEntry, int seq, BigDecimal diffSum) throws CalculateException {
        CostAdjustBillEntryInfo caei = null;
        if (CalculateUtil.ZERO.compareTo(diffSum) != 0) {
            caei = new CostAdjustBillEntryInfo();
            caei.setId(BOSUuid.create((String)"2774F28C"));
            caei.setSeq(seq + 1);
            caei.setIsPresent(false);
            caei.setAssCoefficient(CalculateUtil.ZERO);
            caei.setAmount(diffSum.setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            caei.setPrice(CalculateUtil.ZERO);
            caei.setActualCost(caei.getAmount());
            caei.setUnitActualCost(CalculateUtil.ZERO);
            caei.setStandardCost(caei.getAmount());
            caei.setUnitStandardCost(CalculateUtil.ZERO);
            caei.setQty(CalculateUtil.ZERO);
            caei.setBaseQty(CalculateUtil.ZERO);
            caei.setAssistQty(CalculateUtil.ZERO);
            caei.setAssociateQty(CalculateUtil.ZERO);
            caei.setReturnBaseQty(CalculateUtil.ZERO);
            caei.setReverseBaseQty(CalculateUtil.ZERO);
            caei.setReturnsQty(CalculateUtil.ZERO);
            caei.setReverseQty(CalculateUtil.ZERO);
            caei.setMaterial(calEntry.getMaterial());
            caei.setLot(calEntry.getBatch());
            if (calEntry.getMaterialBaseUnit() == null) {
                caei.setBaseUnit(calEntry.getMaterialUnit());
                caei.setUnit(calEntry.getMaterialUnit());
            } else {
                caei.setBaseUnit(calEntry.getMaterialBaseUnit());
                caei.setUnit(calEntry.getMaterialBaseUnit());
            }
            caei.setAssistProperty(calEntry.getAssistProperty());
            caei.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            if (calEntry.getWarehouse() == null || calEntry.getWarehouse().getId() == null) {
                throw new CalculateException(CalculateException.WAREHOUSE_NOT_EXIST);
            }
            if (calEntry.getStorageOrg() == null || calEntry.getStorageOrg().getId() == null) {
                throw new CalculateException(CalculateException.STOREAGE_ORG_NOT_EXIST);
            }
            if (calEntry.getFinanceOrg() == null || calEntry.getFinanceOrg().getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            caei.setWarehouse(calEntry.getWarehouse());
            caei.setStorageOrgUnit(calEntry.getStorageOrg());
            caei.setCompanyOrgUnit(calEntry.getFinanceOrg());
        }
        return caei;
    }

    public static String getCostAdjSql(Context ctx, String billNumber) {
        StringBuffer sqldel = new StringBuffer();
        sqldel.append("SELECT ");
        sqldel.append("bill.FNumber,");
        sqldel.append("0 AS FQty,");
        sqldel.append("factualcost AS FCost,");
        sqldel.append("entry.FMaterialID AS FMaterialID,");
        sqldel.append("materialcompany.FAccountType AS FAccountType ,");
        sqldel.append("entry.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqldel.append("entry.FStorageOrgUnitID AS FStorageOrgUnitID,");
        sqldel.append("entry.FWarehouseID AS FWarehouseID ");
        sqldel.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqldel.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqldel.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqldel.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqldel.append("\n FROM t_cl_costadjustbill bill ");
        sqldel.append(" inner join t_cl_costadjustbillentry entry on bill.fid=entry.fparentid ");
        sqldel.append(" INNER JOIN T_BD_MaterialCompanyInfo materialcompany ");
        sqldel.append(" ON (entry.FMaterialID = materialcompany.FMaterialID ");
        sqldel.append(" AND entry.FCompanyOrgUnitID = materialcompany.FCompanyID )");
        sqldel.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqldel.append(" ON entry.FMaterialID = MATERIAL.FId");
        sqldel.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqldel.append(" ON (entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sqldel.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqldel.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sqldel.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqldel.append(" ON entry.FCompanyOrgUnitID = COMPANY.FID");
        sqldel.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqldel.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sqldel.append("\n WHERE materialcompany.FAccountType = 1");
        sqldel.append(" AND bill.FFIVOUCHERED=0 ");
        sqldel.append(" AND bill.fnumber='").append(billNumber).append("'");
        sqldel.append(" Order by entry.Fseq");
        return sqldel.toString();
    }

    public static String[] getDeleteCostAdjustbill(String billNumber) {
        String[] sqlArr = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM t_cl_costadjustbillentry WHERE fparentid =(");
        buffer.append(" SELECT FID FROM t_cl_costadjustbill WHERE FNUMBER='").append(billNumber).append("')");
        sqlArr[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("DELETE FROM t_cl_costadjustbill WHERE FNUMBER='").append(billNumber).append("'");
        sqlArr[1] = buffer.toString();
        return sqlArr;
    }

    public static String getCostAdjSqlForNumber(Context ctx, String[] numbers) {
        StringBuffer sqldel = new StringBuffer();
        sqldel.append("SELECT ");
        sqldel.append("bill.FNumber,");
        sqldel.append("0 AS FQty,");
        sqldel.append("factualcost AS FCost,");
        sqldel.append("entry.FMaterialID AS FMaterialID,");
        sqldel.append("materialcompany.FAccountType AS FAccountType ,");
        sqldel.append("entry.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqldel.append("entry.FStorageOrgUnitID AS FStorageOrgUnitID,");
        sqldel.append("entry.FWarehouseID AS FWarehouseID ");
        sqldel.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqldel.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqldel.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqldel.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqldel.append("\n FROM t_cl_costadjustbill bill ");
        sqldel.append(" inner join t_cl_costadjustbillentry entry on bill.fid=entry.fparentid ");
        sqldel.append(" INNER JOIN T_BD_MaterialCompanyInfo materialcompany ");
        sqldel.append(" ON (entry.FMaterialID = materialcompany.FMaterialID ");
        sqldel.append(" AND entry.FCompanyOrgUnitID = materialcompany.FCompanyID )");
        sqldel.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqldel.append(" ON entry.FMaterialID = MATERIAL.FId");
        sqldel.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqldel.append(" ON (entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sqldel.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqldel.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sqldel.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqldel.append(" ON entry.FCompanyOrgUnitID = COMPANY.FID");
        sqldel.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqldel.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sqldel.append("\n WHERE materialcompany.FAccountType = 1");
        sqldel.append(" AND bill.fnumber IN ").append(CostAdjustHelp.getSqlInPart(numbers));
        sqldel.append(" Order by entry.Fseq");
        return sqldel.toString();
    }

    public static String getCostAdjnumberSql(String[] ids) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT CONCAT('*',FNUMBER) AS NEWFNUMBER,FNUMBER AS FNUMBER FROM t_cl_costadjustbill  \n WHERE FFIVOUCHERED =0 AND FID IN").append(CostAdjustHelp.getSqlInPart(ids));
        return buffer.toString();
    }

    public static String getSqlInPart(String[] ids) {
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        return bf.toString();
    }

    public static String getSqlInOrEqualPart(String[] ids) {
        StringBuffer bf = new StringBuffer();
        if (ids != null) {
            if (ids.length == 1) {
                bf.append("'").append(ids[0]).append("'");
            } else {
                bf.append(CostAdjustHelp.getSqlInPart(ids));
            }
        }
        return bf.toString();
    }

    public static boolean checkCostAdjBillIsVouchered(Context ctx, String[] fnumber, boolean isExpenseApportionException) throws BOSException, SQLException, ExpenseApportionException, ManualWriteOffException {
        StringBuffer buffer = new StringBuffer();
        if (fnumber != null) {
            String equalOrInStr = "=";
            if (fnumber.length > 1) {
                equalOrInStr = "IN";
            }
            buffer.append("SELECT FFiVouchered as FFiVouchered,FNUMBER AS FNUMBER FROM  T_CL_COSTADJUSTBILL \n WHERE FNUMBER ").append(equalOrInStr);
            buffer.append(CostAdjustHelp.getSqlInOrEqualPart(fnumber));
            IRowSet row = DBUtil.executeQuery((Context)ctx, (String)buffer.toString());
            while (row.next()) {
                if (row.getInt("FFiVouchered") != 1) continue;
                if (isExpenseApportionException) {
                    throw new ExpenseApportionException(ExpenseApportionException.DEL_APPORLISTING_ALERT, new String[]{row.getString("FNUMBER")});
                }
                throw new ManualWriteOffException(ManualWriteOffException.DEL_WRITEOFF_ALERT);
            }
        } else {
            return false;
        }
        return false;
    }
}

