/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupInfo;
import com.kingdee.eas.scm.cal.DevolveWriteOffRecordInfo;
import com.kingdee.eas.scm.cal.MatCostWriteOffTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffCreateTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.DischargeTypeEnum;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class WriteOffHelp {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.help.WriteOffHelp");

    public static WriteOffGroupInfo createWrittenOffGroup(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, CalculateKindEnum kind, HashMap periodhm) throws EASBizException, BOSException {
        WriteOffGroupInfo writeoffgroupinfo = new WriteOffGroupInfo();
        Date date = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        writeoffgroupinfo.setId(BOSUuid.create((BOSObjectType)writeoffgroupinfo.getBOSType()));
        writeoffgroupinfo.setNumber(sf.format(date));
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setWriteOffDate(date);
        writeoffgroupinfo.setWriteOffYear(((PeriodInfo)periodhm.get("p")).getPeriodYear());
        writeoffgroupinfo.setWriteOffPeriod(((PeriodInfo)periodhm.get("p")).getPeriodNumber());
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setCompanyOrgUnit(aCompanyOrgUnitInfo);
        writeoffgroupinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffgroupinfo.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        writeoffgroupinfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return writeoffgroupinfo;
    }

    public static WriteOffGroupInfo createWrittenOffGroup(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, CalculateKindEnum kind, HashMap periodhm, WriteOffGroupInfo writeoffgroupinfo) throws EASBizException, BOSException {
        Date date = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        writeoffgroupinfo.setId(BOSUuid.create((BOSObjectType)writeoffgroupinfo.getBOSType()));
        writeoffgroupinfo.setNumber(sf.format(date));
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setWriteOffDate(date);
        writeoffgroupinfo.setWriteOffYear(((PeriodInfo)periodhm.get("p")).getPeriodYear());
        writeoffgroupinfo.setWriteOffPeriod(((PeriodInfo)periodhm.get("p")).getPeriodNumber());
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setCompanyOrgUnit(aCompanyOrgUnitInfo);
        writeoffgroupinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffgroupinfo.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        writeoffgroupinfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        writeoffgroupinfo.setCreateType(WriteOffCreateTypeEnum.SAL_AUTO_WRITEOFF);
        return writeoffgroupinfo;
    }

    public static WriteOffGroupInfo createWrittenOffGroup(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, CalculateKindEnum kind, HashMap periodhm, CalculateWrittenOffBill calculateWrittenOffBill) throws EASBizException, BOSException {
        WriteOffGroupInfo writeoffgroupinfo = new WriteOffGroupInfo();
        Date date = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        writeoffgroupinfo.setId(BOSUuid.create((BOSObjectType)writeoffgroupinfo.getBOSType()));
        writeoffgroupinfo.setNumber(sf.format(date));
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setWriteOffDate(date);
        writeoffgroupinfo.setWriteOffYear(((PeriodInfo)periodhm.get("p")).getPeriodYear());
        writeoffgroupinfo.setWriteOffPeriod(((PeriodInfo)periodhm.get("p")).getPeriodNumber());
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setCompanyOrgUnit(aCompanyOrgUnitInfo);
        writeoffgroupinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffgroupinfo.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        writeoffgroupinfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)calculateWrittenOffBill.getCurrency()));
        writeoffgroupinfo.setCurrency(currencyInfo);
        writeoffgroupinfo.setExchangeRate(calculateWrittenOffBill.getExchangeRate());
        return writeoffgroupinfo;
    }

    public static WriteOffGroupInfo createWrittenOffGroup(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, CalculateKindEnum kind, HashMap periodhm, CalculateWrittenOffBill calculateWrittenOffBill, WriteOffGroupInfo writeoffgroupinfo, WriteOffCreateTypeEnum createType, int dischargeType) throws EASBizException, BOSException {
        Date date = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        writeoffgroupinfo.setId(BOSUuid.create((BOSObjectType)writeoffgroupinfo.getBOSType()));
        writeoffgroupinfo.setNumber(sf.format(date));
        writeoffgroupinfo.setCalculateKind(kind);
        writeoffgroupinfo.setWriteOffDate(date);
        writeoffgroupinfo.setWriteOffYear(((PeriodInfo)periodhm.get("p")).getPeriodYear());
        writeoffgroupinfo.setWriteOffPeriod(((PeriodInfo)periodhm.get("p")).getPeriodNumber());
        writeoffgroupinfo.setCompanyOrgUnit(aCompanyOrgUnitInfo);
        writeoffgroupinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffgroupinfo.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        writeoffgroupinfo.setCreateType(createType);
        writeoffgroupinfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        if (dischargeType != 0 && calculateWrittenOffBill.getIsInitBill()) {
            writeoffgroupinfo.setDisChargeType(DischargeTypeEnum.BillComeClear);
        } else {
            writeoffgroupinfo.setDisChargeType(DischargeTypeEnum.getEnum((int)dischargeType));
        }
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)calculateWrittenOffBill.getCurrency()));
        writeoffgroupinfo.setCurrency(currencyInfo);
        writeoffgroupinfo.setExchangeRate(calculateWrittenOffBill.getExchangeRate());
        return writeoffgroupinfo;
    }

    public static String createWrittenOffGroupSQL(WriteOffGroupInfo writeoffgroupinfo) throws EASBizException, BOSException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_WriteOffGroup");
        sql.append("(FID,FCreatorID,FCreateTime,FControlUnitID");
        sql.append(",FWriteOffDate,FWriteOffYear,FWriteOffPeriod,FCompanyOrgUnitID,FCalculateKind,FNumber");
        if (null != writeoffgroupinfo.getCurrency()) {
            sql.append(",FExchangeRate,FCurrencyID");
        }
        sql.append(",FCreateType,FDischargeType) Values(");
        sql.append("  '").append(writeoffgroupinfo.getId()).append("'");
        sql.append(" ,'").append(writeoffgroupinfo.getCreator().getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(writeoffgroupinfo.getCreateTime())).append("')");
        sql.append(" ,'").append(writeoffgroupinfo.getCU() != null ? writeoffgroupinfo.getCU().getId().toString() : "").append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(writeoffgroupinfo.getWriteOffDate())).append("')");
        sql.append(" ,").append(writeoffgroupinfo.getWriteOffYear()).append("");
        sql.append(" ,").append(writeoffgroupinfo.getWriteOffPeriod()).append("");
        sql.append(" ,'").append(writeoffgroupinfo.getCompanyOrgUnit().getId()).append("'");
        sql.append(" ,").append(writeoffgroupinfo.getCalculateKind().getValue()).append("");
        sql.append(" ,'").append(sf.format(writeoffgroupinfo.getCreateTime())).append("'");
        if (null != writeoffgroupinfo.getCurrency()) {
            sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffgroupinfo.getExchangeRate())).append("");
            sql.append(" ,'").append(writeoffgroupinfo.getCurrency().getId().toString()).append("'");
        }
        sql.append(",").append(writeoffgroupinfo.getCreateType().getValue());
        if (null != writeoffgroupinfo.getDisChargeType()) {
            sql.append(",").append(writeoffgroupinfo.getDisChargeType().getValue());
        }
        sql.append(")");
        return sql.toString();
    }

    public WriteOffGroupInfo createWrittenOffGroupSQL2(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, CalculateKindEnum kind, HashMap periodhm) throws EASBizException, BOSException {
        WriteOffGroupInfo writeoffgroupinfo = new WriteOffGroupInfo();
        ObjectUuidPK pkid = new ObjectUuidPK(writeoffgroupinfo.getBOSType());
        writeoffgroupinfo.setId(BOSUuid.read((String)pkid.toString()));
        Date date = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_WriteOffGroup");
        sql.append("(FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID");
        sql.append(",FWriteOffDate,FWriteOffYear,FWriteOffPeriod,FCompanyOrgUnitID,FCalculateKind,FNumber");
        sql.append(") Values(");
        sql.append("  '").append(pkid.toString()).append("'");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(date)).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(date)).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(date)).append("')");
        sql.append(" ,").append(((PeriodInfo)periodhm.get("p")).getPeriodYear()).append("");
        sql.append(" ,").append(((PeriodInfo)periodhm.get("p")).getPeriodNumber()).append("");
        sql.append(" ,'").append(aCompanyOrgUnitInfo.getId()).append("'");
        sql.append(" ,").append(kind.getValue()).append("");
        sql.append(" ,'").append(sf.format(date)).append("'");
        sql.append(")");
        return writeoffgroupinfo;
    }

    public static void createWrittenOffRecord(Context ctx, WriteOffGroupInfo writeoffgroupinfo, BigDecimal writeOffQty, BigDecimal writeOffAmt, BigDecimal baseUnitPrice, CalculateWrittenOffBill calBill, CalculateWrittenOffEntry calEntry) {
        if (CalculateUtil.ZERO.compareTo(writeOffQty) == 0 && CalculateUtil.ZERO.compareTo(writeOffAmt) == 0) {
            return;
        }
        WriteOffRecordInfo writeoffrecordinfo = new WriteOffRecordInfo();
        writeoffrecordinfo.setId(BOSUuid.create((BOSObjectType)writeoffrecordinfo.getBOSType()));
        writeoffrecordinfo.setSeq(1);
        if (writeoffgroupinfo.getEntry() != null && writeoffgroupinfo.getEntry().size() > 0) {
            writeoffrecordinfo.setSeq(writeoffgroupinfo.getEntry().size() + 1);
        }
        writeoffrecordinfo.setOrderBillNumber(calEntry.getOrderBillNumber());
        writeoffrecordinfo.setOrderBillEntrySeq(calEntry.getOrderBillEntrySeq());
        SupplierInfo supplierinfo = null;
        if (calBill.getSupplier() != null) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(BOSUuid.read((String)calBill.getSupplier()));
        }
        CustomerInfo customerinfo = null;
        if (calBill.getCustomer() != null) {
            customerinfo = new CustomerInfo();
            customerinfo.setId(BOSUuid.read((String)calBill.getCustomer()));
        }
        writeoffrecordinfo.setSupplier(supplierinfo);
        writeoffrecordinfo.setCustomer(customerinfo);
        writeoffrecordinfo.setMaterial(calEntry.getMaterial());
        writeoffrecordinfo.setAssistProperty(calEntry.getAssistProperty());
        writeoffrecordinfo.setBaseUnit(calEntry.getMaterialBaseUnit());
        writeoffrecordinfo.setBillID(calBill.getId());
        writeoffrecordinfo.setBillEntryID(calEntry.getId());
        writeoffrecordinfo.setBillNumber(calBill.getNumber());
        writeoffrecordinfo.setBillEntrySeq(calEntry.getSeq());
        writeoffrecordinfo.setBillDate(calBill.getBizDate());
        writeoffrecordinfo.setBillTypeNumber(calBill.getBillType());
        writeoffrecordinfo.setTransactionType(calBill.getTransactionTypeID());
        writeoffrecordinfo.setLot(calEntry.getBatch());
        writeoffrecordinfo.setCurrWrittenOffQty(CalculateUtil.ZERO.compareTo(calEntry.getBaseUnitQty()) > 0 ? writeOffQty.abs().multiply(CalculateUtil.ONE_MINUS) : writeOffQty);
        writeoffrecordinfo.setCurrWrittenOffAmount(CalculateUtil.ZERO.compareTo(calEntry.getBaseUnitQty()) > 0 ? writeOffAmt.abs().multiply(CalculateUtil.ONE_MINUS) : writeOffAmt);
        writeoffrecordinfo.setCurrWrittenOffPrice(baseUnitPrice);
        writeoffrecordinfo.setWirttenOffQty(calEntry.getWrittenOffQty());
        writeoffrecordinfo.setWrittenOffAmount(calEntry.getWrittenOffAmt());
        writeoffrecordinfo.setUnWirteOffQty(calEntry.getUnWriteOffQty());
        writeoffrecordinfo.setUnWriteOffAmount(calEntry.getUnWriteOffAmt());
        writeoffrecordinfo.setCalcutator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffrecordinfo.setCompanyOrgUnit(calEntry.getFinanceOrg().getId().toString());
        if (calEntry.getTableName().equalsIgnoreCase("t_im_purinwarehsentry")) {
            writeoffrecordinfo.setActualCost(calEntry.getPurchaseCost());
            writeoffrecordinfo.setAmount(calEntry.getPurchaseCost());
            writeoffrecordinfo.setLocalAmount(calEntry.getPurchaseCost());
        } else {
            writeoffrecordinfo.setActualCost(calEntry.getActualCost());
            writeoffrecordinfo.setAmount(calEntry.getAmount2());
            writeoffrecordinfo.setLocalAmount(calEntry.getLocalAmount());
        }
        writeoffrecordinfo.setTax(calEntry.getTax());
        writeoffrecordinfo.setLocalTax(calEntry.getLocalTax());
        PaymentTypeInfo paymentTypeInfo = null;
        if (calBill.getPaymentType() != null) {
            paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)calBill.getPaymentType()));
        }
        writeoffrecordinfo.setPaymentType(paymentTypeInfo);
        writeoffgroupinfo.getEntry().add(writeoffrecordinfo);
    }

    public static void createWrittenOffRecord(Context ctx, WriteOffGroupInfo writeoffgroupinfo, BigDecimal writeOffNum, BigDecimal writeOffSumInvo, BigDecimal writeOffPrice, String supplier, String customer, Date bizDate, String billid, String sourceBillNum, String sourceBillTypeNum, String transactionType, String orderOrSaleBillNum, int orderOrSaleentrySeq, String billentryid, int sourceBillEntrySeq, CompanyOrgUnitInfo financeOrg, MaterialInfo material, MeasureUnitInfo baseMeasureUnit, AsstAttrValueInfo assistProperty, String lot, BigDecimal baseUnitQty, BigDecimal hadWirteOffNumber, BigDecimal hadWriteOffSum, BigDecimal noWirteOffNumber, BigDecimal noWriteOffSum) {
        if (CalculateUtil.ZERO.compareTo(writeOffNum) == 0 && CalculateUtil.ZERO.compareTo(writeOffSumInvo) == 0) {
            return;
        }
        WriteOffRecordInfo writeoffrecordinfo = new WriteOffRecordInfo();
        writeoffrecordinfo.setId(BOSUuid.create((BOSObjectType)writeoffrecordinfo.getBOSType()));
        writeoffrecordinfo.setSeq(1);
        if (writeoffgroupinfo.getEntry() != null && writeoffgroupinfo.getEntry().size() > 0) {
            writeoffrecordinfo.setSeq(writeoffgroupinfo.getEntry().size() + 1);
        }
        writeoffrecordinfo.setOrderBillNumber(orderOrSaleBillNum);
        writeoffrecordinfo.setOrderBillEntrySeq(orderOrSaleentrySeq);
        SupplierInfo supplierinfo = null;
        if (supplier != null && supplier.length() > 0) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(BOSUuid.read((String)supplier));
        }
        CustomerInfo customerinfo = null;
        if (customer != null && customer.length() > 0) {
            customerinfo = new CustomerInfo();
            customerinfo.setId(BOSUuid.read((String)customer));
        }
        writeoffrecordinfo.setSupplier(supplierinfo);
        writeoffrecordinfo.setCustomer(customerinfo);
        writeoffrecordinfo.setMaterial(material);
        writeoffrecordinfo.setAssistProperty(assistProperty);
        writeoffrecordinfo.setBaseUnit(baseMeasureUnit);
        writeoffrecordinfo.setBillID(billid);
        writeoffrecordinfo.setBillEntryID(billentryid);
        writeoffrecordinfo.setBillNumber(sourceBillNum);
        writeoffrecordinfo.setBillEntrySeq(sourceBillEntrySeq);
        writeoffrecordinfo.setBillDate(bizDate);
        writeoffrecordinfo.setBillTypeNumber(sourceBillTypeNum);
        writeoffrecordinfo.setTransactionType(transactionType);
        writeoffrecordinfo.setLot(lot);
        writeoffrecordinfo.setCurrWrittenOffQty(CalculateUtil.ZERO.compareTo(baseUnitQty) > 0 ? writeOffNum.abs().multiply(CalculateUtil.ONE_MINUS) : writeOffNum);
        writeoffrecordinfo.setCurrWrittenOffAmount(CalculateUtil.ZERO.compareTo(baseUnitQty) > 0 ? writeOffSumInvo.abs().multiply(CalculateUtil.ONE_MINUS) : writeOffSumInvo);
        writeoffrecordinfo.setCurrWrittenOffPrice(writeOffPrice);
        writeoffrecordinfo.setWirttenOffQty(hadWirteOffNumber);
        writeoffrecordinfo.setWrittenOffAmount(hadWriteOffSum);
        writeoffrecordinfo.setUnWirteOffQty(noWirteOffNumber);
        writeoffrecordinfo.setUnWriteOffAmount(noWriteOffSum);
        writeoffrecordinfo.setCalcutator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffrecordinfo.setCompanyOrgUnit(financeOrg.getId().toString());
        writeoffgroupinfo.getEntry().add(writeoffrecordinfo);
    }

    public static String createWrittenOffRecordSQL(BOSUuid uuid, WriteOffRecordInfo writeoffrecordinfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        String supplier = "null";
        if (writeoffrecordinfo.getSupplier() != null && writeoffrecordinfo.getSupplier().getId().toString().length() > 0) {
            supplier = "'" + writeoffrecordinfo.getSupplier().getId().toString() + "'";
        }
        String customer = "null";
        if (writeoffrecordinfo.getCustomer() != null && writeoffrecordinfo.getCustomer().getId().toString().length() > 0) {
            customer = "'" + writeoffrecordinfo.getCustomer().getId().toString() + "'";
        }
        String assistproperty = "null";
        if (writeoffrecordinfo.getAssistProperty() != null && writeoffrecordinfo.getAssistProperty().getId() != null && writeoffrecordinfo.getAssistProperty().getId().toString().length() > 0) {
            assistproperty = "'" + writeoffrecordinfo.getAssistProperty().getId().toString() + "'";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_WriteOffRecord");
        sql.append("(FID,FSeq,FParentID");
        sql.append(",FOrderBillNumber,FOrderBillEntrySeq");
        sql.append(",FSupplierID,FCustomerID,FMaterialID,FAssistPropertyID,FBaseUnitID");
        sql.append(",FBillID,FBillEntryID");
        sql.append(",FBillNumber,FBillEntrySeq,FBillTypeNumber,FBillDate");
        sql.append(",FLot,FTransactionTypeID");
        sql.append(",FCurrWrittenOffQty,FCurrWrittenOffPrice,FCurrWrittenOffAmount");
        sql.append(",FWirttenOffQty,FWrittenOffAmount");
        sql.append(",FUnWirteOffQty,FUnWriteOffAmount");
        sql.append(",FCalcutatorID,FCompanyOrgUnitID");
        if (null != writeoffrecordinfo.getActualCost()) {
            sql.append(",FActualCost,FLocalTax,FTax,FLocalAmount,FAmount");
        }
        if ("102".equalsIgnoreCase(writeoffrecordinfo.getBillTypeNumber().trim()) || "330".equalsIgnoreCase(writeoffrecordinfo.getBillTypeNumber().trim())) {
            sql.append(",FPaymentTypeID");
        }
        sql.append(") Values(");
        sql.append("  '").append(writeoffrecordinfo.getId()).append("'");
        sql.append(" ,").append(writeoffrecordinfo.getSeq()).append("");
        sql.append(" ,'").append(uuid).append("'");
        sql.append(" ,'").append(writeoffrecordinfo.getOrderBillNumber()).append("'");
        sql.append(" ,").append(writeoffrecordinfo.getOrderBillEntrySeq()).append("");
        sql.append(" ,").append(supplier).append("");
        sql.append(" ,").append(customer).append("");
        sql.append(" ,'").append(writeoffrecordinfo.getMaterial().getId()).append("'");
        sql.append(" ,").append(assistproperty).append("");
        sql.append(" ,'").append(writeoffrecordinfo.getBaseUnit().getId()).append("'");
        sql.append(" ,'").append(writeoffrecordinfo.getBillID()).append("'");
        sql.append(" ,'").append(writeoffrecordinfo.getBillEntryID()).append("'");
        sql.append(" ,'").append(writeoffrecordinfo.getBillNumber()).append("'");
        sql.append(" ,").append(writeoffrecordinfo.getBillEntrySeq()).append("");
        sql.append(" ,'").append(writeoffrecordinfo.getBillTypeNumber()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(writeoffrecordinfo.getBillDate())).append("')");
        sql.append(" ,''");
        sql.append(" ,'").append(writeoffrecordinfo.getTransactionType()).append("'");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getCurrWrittenOffQty())).append("");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getCurrWrittenOffPrice())).append("");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getCurrWrittenOffAmount())).append("");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getWirttenOffQty())).append("");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getWrittenOffAmount())).append("");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getUnWirteOffQty())).append("");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getUnWriteOffAmount())).append("");
        sql.append(" ,'").append(writeoffrecordinfo.getCalcutator().getId()).append("'");
        sql.append(" ,'").append(writeoffrecordinfo.getCompanyOrgUnit()).append("'");
        if (null != writeoffrecordinfo.getActualCost()) {
            sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getActualCost())).append("");
            sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getLocalTax())).append("");
            sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getTax())).append("");
            sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getLocalAmount())).append("");
            sql.append(" ,").append(StringUtil.toString((BigDecimal)writeoffrecordinfo.getAmount())).append("");
        }
        if ("102".equalsIgnoreCase(writeoffrecordinfo.getBillTypeNumber().trim()) || "330".equalsIgnoreCase(writeoffrecordinfo.getBillTypeNumber().trim())) {
            sql.append(",'").append(writeoffrecordinfo.getPaymentType().getId().toString()).append("'");
        }
        sql.append(")");
        return sql.toString();
    }

    public static DevolveWriteOffGroupInfo createDevWrittenOffGroup(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        DevolveWriteOffGroupInfo groupInfo = new DevolveWriteOffGroupInfo();
        groupInfo.setId(BOSUuid.create((BOSObjectType)groupInfo.getBOSType()));
        groupInfo.setNumber(format.format(date));
        groupInfo.setCompanyOrgUnit(companyOrgUnitInfo);
        groupInfo.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
        groupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        groupInfo.setWriteOffDate(date);
        groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        groupInfo.setFiVouchered(false);
        groupInfo.setCreateType(MatCostWriteOffTypeEnum.RedBlueWriteOff);
        return groupInfo;
    }

    public static DevolveWriteOffRecordInfo createDevWrittenOffRecord(Context ctx, CalculateWrittenOffEntry calEntry, CalculateWrittenOffBill calBill, BigDecimal writeOffQty, BigDecimal writeOffAmt, DevolveWriteOffGroupInfo groupInfo, int groupNO) {
        BigDecimal wfBaseQty;
        if (CalculateUtil.ZERO.compareTo(writeOffQty) == 0 && CalculateUtil.ZERO.compareTo(writeOffAmt) == 0) {
            return null;
        }
        DevolveWriteOffRecordInfo writeOffRecordInfo = new DevolveWriteOffRecordInfo();
        writeOffRecordInfo.setId(BOSUuid.create((BOSObjectType)writeOffRecordInfo.getBOSType()));
        writeOffRecordInfo.setGroupNO(groupNO);
        writeOffRecordInfo.setSeq(groupInfo.getEntry().size() + 1);
        writeOffRecordInfo.setOrderBillNumber(calEntry.getOrderBillNumber());
        writeOffRecordInfo.setOrderBillEntrySeq(calEntry.getOrderBillEntrySeq());
        SupplierInfo supplierinfo = null;
        if (calBill.getSupplier() != null) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(BOSUuid.read((String)calBill.getSupplier()));
        }
        writeOffRecordInfo.setSupplier(supplierinfo);
        MaterialInfo material = null;
        if (calEntry.getMaterialId() != null) {
            material = new MaterialInfo();
            material.setId(BOSUuid.read((String)calEntry.getMaterialId()));
        }
        writeOffRecordInfo.setMaterial(material);
        writeOffRecordInfo.setBaseUnit(calEntry.getMaterialBaseUnit());
        writeOffRecordInfo.setBillID(calBill.getId());
        writeOffRecordInfo.setBillEntryID(calEntry.getId());
        writeOffRecordInfo.setBillNumber(calBill.getNumber());
        writeOffRecordInfo.setBillEntrySeq(calEntry.getSeq());
        writeOffRecordInfo.setBillDate(calBill.getBizDate());
        writeOffRecordInfo.setBillTypeNumber(calBill.getBillType());
        writeOffRecordInfo.setTransactionType(calBill.getTransactionTypeID());
        writeOffRecordInfo.setLot(calEntry.getBatch());
        writeOffRecordInfo.setCompanyOrgUnit(calEntry.getFinanceOrg().getId().toString());
        writeOffRecordInfo.setCalcutator(ContextUtil.getCurrentUserInfo((Context)ctx));
        BigDecimal bigDecimal = wfBaseQty = calEntry.getBaseUnitQty().signum() < 0 ? writeOffQty.abs().negate() : writeOffQty.abs();
        if (calEntry.getBaseUnitQty().compareTo(wfBaseQty) == 0) {
            writeOffRecordInfo.setCurrWriteOffQty(calEntry.getQty());
        } else {
            writeOffRecordInfo.setCurrWriteOffQty(wfBaseQty.divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4));
        }
        writeOffRecordInfo.setCurrWriteOffBaseQty(wfBaseQty);
        if (writeOffAmt != null) {
            writeOffRecordInfo.setCurrWriteOffAmount(calEntry.getBaseUnitQty().signum() < 0 ? writeOffAmt.abs().negate() : writeOffAmt.abs());
        } else {
            writeOffRecordInfo.setCurrWriteOffAmount(new BigDecimal("0.00"));
        }
        writeOffRecordInfo.setBillUnWriteOffBaseQty(calEntry.getBaseUnitQty().subtract(wfBaseQty));
        groupInfo.getEntry().add(writeOffRecordInfo);
        return writeOffRecordInfo;
    }

    public static String updateWriteOffRecordMantissaSQL(String bill, String billEntry, BOSUuid billID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FCurrWrittenOffAmount) = (");
        sql.append(" SELECT Entry.FActualCost");
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN T_CL_WriteOffRecord AS writeoff");
        sql.append(" ON (Entry.FParentID = writeoff.FBillID");
        sql.append(" AND Entry.FID = writeoff.FBillEntryID");
        sql.append(" )");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" WHERE entry.FUNWRITEOFFQTY = 0 and writeoff.FCURRWRITTENOFFQTY = entry.fbaseqty ");
        sql.append(" AND Bill.FID = '").append(billID).append("' ");
        sql.append(" AND writeoff.fid=T.fid");
        sql.append(" )");
        return sql.toString();
    }

    public static String updateWriteOffRecordMantissaNextSQL(String bill, String billEntry, BOSUuid billID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FCurrWrittenOffAmount) = (");
        sql.append(" SELECT T0.factualcost-(T0.FTotalCurrWrittenOffAmount-FCurrWrittenOffAmount) from (");
        sql.append(" SELECT MAX(writeoff.fid) as FID,");
        sql.append(" sum(writeoff.FCurrWrittenOffAmount) as FTotalCurrWrittenOffAmount,MAX(entry.factualcost) as factualcost");
        sql.append(" FROM T_CL_WRITEOFFRECORD writeoff");
        sql.append(" inner JOIN ").append(billEntry).append(" entry ON writeoff.fbillentryid = entry.fid");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" where entry.FUnWriteOffQty = 0");
        sql.append(" AND Bill.FID = '").append(billID).append("' ");
        sql.append(" GROUP BY writeoff.fbillentryid");
        sql.append(" HAVING count(1)>1");
        sql.append(" AND SUM(writeoff.FCurrWrittenOffAmount)<>MAX(entry.factualcost)");
        sql.append(" ) T0  WHERE T.fid = T0.fid");
        sql.append(" )");
        return sql.toString();
    }

    public static String updateWriteOffRecordPriceSQL(String bill, String billEntry, BOSUuid billID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FCurrWrittenOffPrice,FCurrWrittenOffAmount,FWrittenOffAmount,FUnWriteOffAmount) = (");
        sql.append(" SELECT ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision) ");
        sql.append(" ,ROUND(ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)*writeoff.FCurrWrittenOffQty,CURRENCY.FPrecision)");
        sql.append(" ,writeoff.FWrittenOffAmount - ");
        sql.append(" (abs(writeoff.FCurrWrittenOffAmount) - ");
        sql.append(" abs(ROUND(ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)*writeoff.FCurrWrittenOffQty,CURRENCY.FPrecision))");
        sql.append(" )* (abs(writeoff.FCurrWrittenOffQty)/writeoff.FCurrWrittenOffQty)");
        sql.append(" ,ROUND(ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)*writeoff.funwirteoffqty,CURRENCY.FPrecision)");
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN T_CL_WriteOffRecord AS writeoff");
        sql.append(" ON (Entry.FParentID = writeoff.FBillID");
        sql.append(" AND Entry.FID = writeoff.FBillEntryID");
        sql.append(" )");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FId");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ");
        sql.append(" ON ENTRY.FCompanyOrgUnitID = COMPANY.FID ");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ");
        sql.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID ");
        sql.append(" WHERE bill.FID = '").append(billID).append("' ");
        sql.append(" AND writeoff.FCurrWrittenOffPrice");
        sql.append("    != ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)");
        sql.append(" AND writeoff.fid=T.fid");
        sql.append(" )");
        return sql.toString();
    }

    public static String updateWriteOffRecordReverceBillPriceSQL(String bill, String billEntry, BOSUuid billID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FCurrWrittenOffPrice,FCurrWrittenOffAmount,FWrittenOffAmount,FUnWriteOffAmount) = (");
        sql.append(" SELECT ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision) ");
        sql.append(" ,ROUND(ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)*writeoff.FCurrWrittenOffQty,CURRENCY.FPrecision)");
        sql.append(" ,ROUND(ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)*writeoff.fwirttenoffqty,CURRENCY.FPrecision)");
        sql.append(" ,ROUND(ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)*writeoff.funwirteoffqty,CURRENCY.FPrecision)");
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN T_CL_WriteOffRecord AS writeoff");
        sql.append(" ON (Entry.FParentID = writeoff.FBillID");
        sql.append(" AND Entry.FID = writeoff.FBillEntryID");
        sql.append(" )");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FId");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (Entry.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" AND Entry.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ");
        sql.append(" ON Entry.FCompanyOrgUnitID = COMPANY.FID ");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ");
        sql.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID ");
        sql.append(" WHERE BILL.FIsReversed  = 1 ");
        sql.append(" AND Entry.fsourcebillid = '").append(billID).append("' ");
        sql.append(" AND writeoff.FCurrWrittenOffPrice");
        sql.append("    != ROUND(" + KsqlUtil.TO_DECIMAL((String)"Entry.FActualCost/Entry.FBaseQty") + ",MATERIAL.FPricePrecision)");
        sql.append(" AND writeoff.fid=T.fid");
        sql.append(" )");
        return sql.toString();
    }

    public static void createWrittenOffRecord2(Context ctx, WriteOffGroupInfo writeoffgroupinfo, CostAdjustBillInfo costadjustbillinfo, CostAdjustBillEntryInfo costEntryInfo, CalculateWrittenOffEntry calEntry) {
        WriteOffRecordInfo writeoffrecordinfo = new WriteOffRecordInfo();
        writeoffrecordinfo.setId(BOSUuid.create((BOSObjectType)writeoffrecordinfo.getBOSType()));
        writeoffrecordinfo.setSeq(1);
        if (writeoffgroupinfo.getEntry() != null && writeoffgroupinfo.getEntry().size() > 0) {
            writeoffrecordinfo.setSeq(writeoffgroupinfo.getEntry().size() + 1);
        }
        writeoffrecordinfo.setOrderBillNumber(calEntry.getOrderBillNumber());
        writeoffrecordinfo.setOrderBillEntrySeq(calEntry.getOrderBillEntrySeq());
        SupplierInfo supplierinfo = null;
        if (costadjustbillinfo.getSupplier() != null) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(costadjustbillinfo.getSupplier().getId());
        }
        CustomerInfo customerinfo = null;
        if (costadjustbillinfo.getCustomer() != null) {
            customerinfo = new CustomerInfo();
            customerinfo.setId(costadjustbillinfo.getCustomer().getId());
        }
        writeoffrecordinfo.setSupplier(supplierinfo);
        writeoffrecordinfo.setCustomer(customerinfo);
        writeoffrecordinfo.setMaterial(costEntryInfo.getMaterial());
        writeoffrecordinfo.setAssistProperty(costEntryInfo.getAssistProperty());
        writeoffrecordinfo.setBaseUnit(costEntryInfo.getBaseUnit());
        writeoffrecordinfo.setBillID(costadjustbillinfo.getId().toString());
        writeoffrecordinfo.setBillEntryID(costEntryInfo.getId().toString());
        writeoffrecordinfo.setBillNumber(costadjustbillinfo.getNumber());
        writeoffrecordinfo.setBillEntrySeq(costEntryInfo.getSeq());
        writeoffrecordinfo.setBillDate(costadjustbillinfo.getBizDate());
        writeoffrecordinfo.setBillTypeNumber("410");
        writeoffrecordinfo.setTransactionType(costadjustbillinfo.getTransactionType() != null && costadjustbillinfo.getTransactionType().getId() != null ? costadjustbillinfo.getTransactionType().getId().toString() : null);
        writeoffrecordinfo.setLot(costEntryInfo.getLot());
        writeoffrecordinfo.setCurrWrittenOffQty(costEntryInfo.getQty());
        writeoffrecordinfo.setCurrWrittenOffAmount(costEntryInfo.getAmount());
        writeoffrecordinfo.setCurrWrittenOffPrice(costEntryInfo.getPrice());
        writeoffrecordinfo.setWirttenOffQty(CalculateUtil.ZERO);
        writeoffrecordinfo.setWrittenOffAmount(CalculateUtil.ZERO);
        writeoffrecordinfo.setUnWirteOffQty(CalculateUtil.ZERO);
        writeoffrecordinfo.setUnWriteOffAmount(CalculateUtil.ZERO);
        writeoffrecordinfo.setCalcutator(ContextUtil.getCurrentUserInfo((Context)ctx));
        writeoffrecordinfo.setCompanyOrgUnit(costEntryInfo.getCompanyOrgUnit().getId().toString());
        writeoffgroupinfo.getEntry().add(writeoffrecordinfo);
    }

    public static String getCalcPurActualCostSQL2() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update T_IM_PurInWarehsEntry as t set (FActualCost,FUnitActualCost,FAmount,FLocalTax,FTax,FTaxAmount,FLocalTaxAmount,FDiscountAmount,FTaxPrice,FPrice,FActualPrice,FActualTaxPrice)=");
        sSQL.append("(select t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost,");
        sSQL.append(" ROUND(TO_DECIMAL((t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost)/t1.fqty,17,4), t2.FPriceprecision),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,17,4) else t3.FExchangeRate end),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),17,4), t6.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8)*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost+t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),17,4), t6.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*t1.FDiscountRate/100*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),21,8)/TO_DECIMAL((1-t1.FDiscountRate/100),21,8),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),21,8)/t1.FQty,21,8)/TO_DECIMAL((1-t1.FDiscountRate/100),21,8),21,8), t2.FPriceprecision),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL(t1.FPurchaseCost*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end)/t1.FQty,21,8)/TO_DECIMAL((1-t1.FDiscountRate/100),21,8),21,8), t2.FPriceprecision),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end)/t1.FQty,21,8), t2.FPriceprecision), ");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),21,8)/t1.FQty,21,8), t2.FPriceprecision) ");
        sSQL.append(" from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid");
        sSQL.append(" inner join T_IM_PurInWarehsBill t3 on t3.fid = t1.fparentid");
        sSQL.append(" inner join T_BD_CURRENCY t4 on t3.FCURRENCYID = t4.fid");
        sSQL.append(" inner join T_ORG_COMPANY t5 on t5.FID = t1.FCompanyOrgunitID");
        sSQL.append(" inner join T_BD_CURRENCY t6 on t5.FBASECURRENCYID = t6.fid");
        sSQL.append(" where t1.FID = ?)");
        sSQL.append(" where t.FID = ?");
        return sSQL.toString();
    }

    public static String getCalcPurActualCostSQL(String entryId) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update T_IM_PurInWarehsEntry as t set (FActualCost,FUnitActualCost,FAmount,FLocalTax,FTax,FTaxAmount,FLocalTaxAmount,FDiscountAmount,FTaxPrice,FPrice,FActualPrice,FActualTaxPrice)=");
        sSQL.append("(select t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost,");
        sSQL.append(" ROUND(TO_DECIMAL((t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost)/t1.fqty,21,8), t2.FPriceprecision),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),17,4), t6.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8)*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost+t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),17,4), t6.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*t1.FDiscountRate/100*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),21,8)/TO_DECIMAL((1-t1.FDiscountRate/100),21,8),17,4), T4.FPRECISION),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),21,8)/t1.FQty,21,8)/TO_DECIMAL((1-t1.FDiscountRate/100),21,8),21,8), t2.FPriceprecision),");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL(t1.FPurchaseCost*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end)/t1.FQty,21,8)/TO_DECIMAL((1-t1.FDiscountRate/100),21,8),21,8), t2.FPriceprecision),");
        sSQL.append(" ROUND(TO_DECIMAL(t1.FPurchaseCost*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end)/t1.FQty,21,8), t2.FPriceprecision), ");
        sSQL.append(" ROUND(TO_DECIMAL(TO_DECIMAL((t1.FPurchaseCost+TO_DECIMAL(t1.FPurchaseCost*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t1.FTaxRate/(100-t1.FTaxRate),21,8) else t1.FTaxRate/100 end),21,8))*(case t3.fconvertmode when 0 then TO_DECIMAL(1/t3.FExchangeRate,21,8) else t3.FExchangeRate end),21,8)/t1.FQty,21,8), t2.FPriceprecision) ");
        sSQL.append(" from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid");
        sSQL.append(" inner join T_IM_PurInWarehsBill t3 on t3.fid = t1.fparentid");
        sSQL.append(" inner join T_BD_CURRENCY t4 on t3.FCURRENCYID = t4.fid");
        sSQL.append(" inner join T_ORG_COMPANY t5 on t5.FID = t1.FCompanyOrgunitID");
        sSQL.append(" inner join T_BD_CURRENCY t6 on t5.FBASECURRENCYID = t6.fid");
        sSQL.append(" where t1.FID = '" + entryId + "')");
        sSQL.append(" where t.FID = '" + entryId + "'");
        return sSQL.toString();
    }

    public static String getCalcPurActualCostSQL() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update T_IM_PurInWarehsEntry as t set (FActualCost, FUnitActualCost)=");
        sSQL.append("(select t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost,");
        sSQL.append(" case when t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost = t1.FActualCost then t1.FUnitActualCost else ");
        sSQL.append(" ROUND(TO_DECIMAL((t1.FPurchaseCost+t1.FPurchaseFee+t1.FMaterialCost)/t1.fqty,21,8), t2.FPriceprecision) end ");
        sSQL.append(" from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid");
        sSQL.append(" where t1.FID = ?)");
        sSQL.append(" where t.FID = ?");
        return sSQL.toString();
    }

    public static void updDevWritRecordOnMatreqCostChange(Context ctx, List entyIdList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTable = null;
        try {
            logger.error((Object)"\u672c\u6b21\u66f4\u65b0\u6210\u672c\u7684\u5206\u5f55id\u4e3a\uff1a\n");
            StringBuffer logStr = new StringBuffer();
            int size = entyIdList.size();
            for (int i = 0; i < size; ++i) {
                logStr.append(entyIdList.get(i)).append(", ");
            }
            logger.error((Object)logStr.toString());
            sql.append(" create table temp (");
            sql.append(" fMatReqid varchar(44),");
            sql.append(" fWriteid varchar(44),");
            sql.append(" fMatReqCost NUMERIC(17,4) DEFAULT 0 NOT NULL ,");
            sql.append(" fMatReqbaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,");
            sql.append(" fWriteCost NUMERIC(17,4) DEFAULT 0 NOT NULL ,");
            sql.append(" fWritebaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,");
            sql.append(" famoutPersion int,");
            sql.append(" fisAdjDiff int default 0,");
            sql.append(" fdiffCost NUMERIC(17,4) DEFAULT 0 NOT NULL)");
            tempTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(tempTable);
            sql.append(" (fMatReqid,fWriteid,fMatReqCost,fMatReqbaseQty,fWriteCost,fWritebaseQty,famoutPersion)");
            sql.append(" ");
            sql.append(" SELECT  MREntry.fid ,DWRecord.fid, MREntry.FSCWRITTENOFFAMOUNT ,MREntry.FSUBWRITTENOFFBASEQTY ,");
            sql.append(" DWRecord.FCURRWRITEOFFAMOUNT ,DWRecord.FCURRWRITEOFFBASEQTY,");
            sql.append(" Currency.FPRECISION ");
            sql.append(" FROM                                           \n");
            sql.append(" T_IM_MATERIALREQBILLENTRY MREntry              \n");
            sql.append(" INNER JOIN T_CL_DevolveWriteOffRecord DWRecord \n");
            sql.append(" ON MREntry.fid = DWRecord.fbillEntryID         \n");
            sql.append(" INNER JOIN T_ORG_Company Comp                  \n");
            sql.append(" ON MREntry.FCOMPANYORGUNITID = Comp.fID        \n");
            sql.append(" INNER JOIN T_BD_CURRENCY Currency              \n");
            sql.append(" ON Comp.FBASECURRENCYID = Currency.fid         \n");
            sql.append(" WHERE  MREntry.fid in(");
            sql.append(ArrayUtil.getStringFromArr((Object[])entyIdList.toArray()));
            sql.append(")");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable);
            sql.append(" set fWriteCost =  ");
            sql.append(" Round(to_decimal(to_decimal(fMatReqCost/fMatReqbaseQty,21,8)*fWritebaseQty,17,4),famoutPersion)  ");
            sql.append(" where fMatReqbaseQty <> 0 ");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("UPDATE ").append(tempTable).append(" AS T ");
            sql.append(" SET (fdiffCost");
            sql.append(" ) = ( ");
            sql.append("  select fdiffCost from ( ");
            sql.append("  select fdiffCost,fMatReqid from ( ");
            sql.append(" select max(temp.fMatReqCost)- sum(temp.fWriteCost)  as fdiffCost,fMatReqid from  ");
            sql.append(tempTable).append(" as temp  group by fMatReqid  ");
            sql.append("   ) t1 ) t2  ");
            sql.append(" where t.fMatReqid = t2.fMatReqid ) ");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable);
            sql.append(" set fisAdjDiff = 1 where fWriteid in (");
            sql.append(" select max(fWriteid) from " + tempTable + " T1 inner join (");
            sql.append(" select max(abs(fWriteCost)) as maxCost,fMatReqid from ");
            sql.append(tempTable).append("  group by fMatReqid ) T2 ");
            sql.append(" on abs(T1.fWriteCost) = T2.maxCost and T1.fMatReqid = T2.fMatReqid ");
            sql.append(" group by  abs(T1.fWriteCost),T1.fMatReqid)");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable);
            sql.append(" set fWriteCost =  fWriteCost + fdiffCost");
            sql.append(" where fisAdjDiff = 1");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update T_CL_DevolveWriteOffRecord T set (FCURRWRITEOFFAMOUNT)= ");
            sql.append(" ( select fWriteCost from ").append(tempTable);
            sql.append("  T1 where T.fid = T1.fWriteid)");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)ctx, tempTable);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
    }

    public static void updDevWritRecordOnMatreqCostChangeCurrPeriod(Context ctx, String idTbl, int periodNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTable = null;
        try {
            sql.append(" create table temp (");
            sql.append(" fMatReqid varchar(44),");
            sql.append(" fWriteid varchar(44),");
            sql.append(" fMatReqCost NUMERIC(17,4) DEFAULT 0 NOT NULL ,");
            sql.append(" fMatReqbaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,");
            sql.append(" fWriteCost NUMERIC(17,4) DEFAULT 0 NOT NULL ,");
            sql.append(" fWritebaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,");
            sql.append(" fSumWritebaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,");
            sql.append(" famoutPersion int,");
            sql.append(" fCurrPeriodFullWriteOff int default 0,");
            sql.append(" fisBeforePeriod int,");
            sql.append(" fisAdjDiff int default 0,");
            sql.append(" fdiffCost NUMERIC(17,4) DEFAULT 0 NOT NULL)");
            tempTable = DBUtil.createTempTable(ctx, sql.toString());
            DBUtil.createTempTableIndex(ctx, tempTable, "fMatReqid", false, false);
            DBUtil.createTempTableIndex(ctx, tempTable, "fWriteid", false, false);
            sql.setLength(0);
            sql.append(" insert into ").append(tempTable);
            sql.append(" (fMatReqid,fWriteid,fMatReqCost,fMatReqbaseQty,fWriteCost,fWritebaseQty,famoutPersion,fisBeforePeriod)");
            sql.append(" ");
            sql.append(" SELECT  MREntry.fid ,DWRecord.fid, MREntry.FSCWRITTENOFFAMOUNT ,MREntry.FSUBWRITTENOFFBASEQTY ,");
            sql.append(" DWRecord.FCURRWRITEOFFAMOUNT ,DWRecord.FCURRWRITEOFFBASEQTY,");
            sql.append(" Currency.FPRECISION, ");
            sql.append(" case when (dwg.FWRITEOFFYEAR * 100 + dwg.FWRITEOFFPERIOD)  < ").append(periodNumber).append(" then 1 else 0 end ");
            sql.append(" FROM                                           \n");
            sql.append(" T_IM_MATERIALREQBILLENTRY MREntry              \n");
            sql.append(" INNER JOIN T_CL_DevolveWriteOffRecord DWRecord \n");
            sql.append(" ON MREntry.fid = DWRecord.fbillEntryID         \n");
            sql.append(" INNER JOIN ").append(idTbl).append(" IDTBL ON IDTBL.FID = MREntry.fid");
            sql.append(" INNER JOIN T_CL_DevolveWriteOffGroup dwg on dwg.fid = DWRecord.fparentid \n");
            sql.append(" INNER JOIN T_ORG_Company Comp                  \n");
            sql.append(" ON MREntry.FCOMPANYORGUNITID = Comp.fID        \n");
            sql.append(" INNER JOIN T_BD_CURRENCY Currency              \n");
            sql.append(" ON Comp.FBASECURRENCYID = Currency.fid         \n");
            sql.append(" where (dwg.FWRITEOFFYEAR * 100 + dwg.FWRITEOFFPERIOD) <= ").append(periodNumber);
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" t1");
            sql.append(" set fSumWritebaseQty = (select sum(fWritebaseQty) fSumWritebaseQty from ").append(tempTable).append(" t2");
            sql.append(" where t1.FMATREQID = t2.FMATREQID group by FMATREQID)");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" t1 set fCurrPeriodFullWriteOff = 1");
            sql.append(" where FMATREQBASEQTY = FSUMWRITEBASEQTY");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable);
            sql.append(" set fWriteCost =  ");
            sql.append(" Round(to_decimal(to_decimal(fMatReqCost/fMatReqbaseQty,21,8)*fWritebaseQty,17,4),famoutPersion)  ");
            sql.append(" where fMatReqbaseQty <> 0 and fisBeforePeriod = 0");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("UPDATE ").append(tempTable).append(" AS T ");
            sql.append(" SET (fdiffCost");
            sql.append(" ) = ( ");
            sql.append("  select fdiffCost from ( ");
            sql.append("  select fdiffCost,fMatReqid from ( ");
            sql.append(" select max(temp.fMatReqCost)- sum(temp.fWriteCost)  as fdiffCost,fMatReqid from  ");
            sql.append(tempTable).append(" as temp where temp.fCurrPeriodFullWriteOff = 1 group by fMatReqid  ");
            sql.append("   ) t1 ) t2  ");
            sql.append(" where t.fMatReqid = t2.fMatReqid )");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable);
            sql.append(" set fisAdjDiff = 1 where fWriteid in (");
            sql.append(" select max(fWriteid) from " + tempTable + " T1 inner join (");
            sql.append(" select max(abs(fWriteCost)) as maxCost,fMatReqid from ");
            sql.append(tempTable).append(" where fisBeforePeriod = 0 group by fMatReqid ) T2 ");
            sql.append(" on abs(T1.fWriteCost) = T2.maxCost and T1.fMatReqid = T2.fMatReqid ");
            sql.append(" and t1.fisBeforePeriod = 0 and t1.fCurrPeriodFullWriteOff = 1");
            sql.append(" group by  abs(T1.fWriteCost),T1.fMatReqid)");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tempTable);
            sql.append(" set fWriteCost =  fWriteCost + fdiffCost");
            sql.append(" where fisAdjDiff = 1");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update T_CL_DevolveWriteOffRecord T set (FCURRWRITEOFFAMOUNT)= ");
            sql.append(" ( select fWriteCost from ").append(tempTable);
            sql.append("  T1 where T.fid = T1.fWriteid)");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)ctx, tempTable);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
    }
}

