/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.newutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionException;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.ManualWriteOffException;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordCollection;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.util.app.db.SysTempTableHelper;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CostAdjustHelper {
    public static String takeCostAdjustBillNumber(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String billNumber) {
        String number = "";
        if (StringUtil.isEmpty((String)billNumber)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CostAdjustBillInfo cabi = new CostAdjustBillInfo();
                String companyid = aCompanyOrgUnitInfo.getId().toString();
                if (companyid != null && iCodingRuleManager.isExist((IObjectValue)cabi, companyid)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)cabi, aCompanyOrgUnitInfo.getId().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtil.isEmpty((String)number) && (number = new StringBuffer("CA-").append(billNumber).append("-").append(System.currentTimeMillis()).toString()).length() > 80) {
            number = number.substring(80);
        }
        return number;
    }

    public static String creatCostAdjustBillNumber(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, String billNumber) {
        String number = "";
        if (StringUtil.isEmpty((String)billNumber)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                CostAdjustBillInfo cabi = new CostAdjustBillInfo();
                String companyid = aCompanyOrgUnitInfo.getId().toString();
                if (companyid != null && iCodingRuleManager.isExist((IObjectValue)cabi, companyid)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)cabi, aCompanyOrgUnitInfo.getId().toString());
                }
            }
            catch (Exception iCodingRuleManager) {
                // empty catch block
            }
        }
        if (StringUtil.isEmpty((String)number)) {
            SecureRandom ran3 = new SecureRandom();
            StringBuffer temp = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                temp.append(ran3.nextInt());
            }
            String temp2 = temp.substring(0, 10);
            number = new StringBuffer("CA-").append(billNumber).append("-").append(System.currentTimeMillis()).append(temp2).toString();
            if (number.length() > 80) {
                number = number.substring(80);
            }
        }
        return number;
    }

    public static String createCostAdjustBillSQL(CostAdjustBillInfo billinfo) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",FIsInitBill,FCreateType,FSupplierID,FCustomerID,FSourceBillID,FAdminOrgUnitID,FCostCenterOrgUnitID");
        sql.append(") Values(");
        sql.append("'").append(billinfo.getId()).append("'");
        if (billinfo.getCreator() != null) {
            sql.append(",'").append(billinfo.getCreator().getId()).append("'");
        } else {
            sql.append(",NULL");
        }
        sql.append(",TO_DATE('").append(sdf.format(billinfo.getCreateTime())).append("')");
        if (billinfo.getLastUpdateUser() != null) {
            sql.append(",'").append(billinfo.getLastUpdateUser().getId()).append("'");
        } else {
            sql.append(",NULL");
        }
        if (billinfo.getLastUpdateTime() != null) {
            sql.append(",TO_DATE('").append(sdf.format(billinfo.getLastUpdateTime())).append("')");
        } else {
            sql.append(",NULL");
        }
        sql.append(",'").append(billinfo.getCU().getId()).append("'");
        sql.append(",'").append(billinfo.getNumber()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(billinfo.getBizDate())).append("')");
        sql.append(",0");
        String auditor = null;
        if (billinfo.getAuditor() != null) {
            auditor = billinfo.getAuditor().getId().toString();
        }
        sql.append(",'").append(auditor).append("'");
        sql.append(",TO_DATE('").append(sdf.format(billinfo.getAuditTime())).append("')");
        sql.append(",").append(billinfo.getBaseStatus().getValue());
        sql.append(",'").append(billinfo.getStorageOrgUnit().getId()).append("'");
        sql.append(",").append("NULL").append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",").append(billinfo.getCalculateKind().getValue()).append("");
        sql.append(",").append(billinfo.getIssueType().getValue()).append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",'").append(billinfo.getBillType().getId()).append("'");
        sql.append(",").append(billinfo.getPeriod());
        sql.append(",").append(billinfo.getYear());
        sql.append(",0");
        sql.append(",").append(billinfo.getCreateType().getValue());
        if (billinfo.getSupplier() == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(billinfo.getSupplier().getId()).append("'");
        }
        if (billinfo.getCustomer() == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(billinfo.getCustomer().getId()).append("'");
        }
        sql.append(",'" + billinfo.getSourceBillId()).append("'");
        if (billinfo.getAdminOrgUnit() != null) {
            sql.append(",'").append(billinfo.getAdminOrgUnit().getId()).append("'");
        } else {
            sql.append(",NULL");
        }
        if (billinfo.getCostCenterOrgUnit() == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(billinfo.getCostCenterOrgUnit().getId()).append("'");
        }
        sql.append(")");
        return sql.toString();
    }

    public static CostAdjustBillInfo createCostAdjustBill(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, StorageOrgUnitInfo storageOrgInfo, HashMap period, String supplier, CalculateKindEnum calculateKind, CalculateWrittenOffBill purInBill, boolean isDevolve) throws EASBizException, BOSException {
        CostAdjustBillInfo cabi = new CostAdjustBillInfo();
        cabi.setId(BOSUuid.create((BOSObjectType)cabi.getBOSType()));
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
        cabi.setBillType(aBillTypeInfo);
        cabi.setNumber(CostAdjustHelper.takeCostAdjustBillNumber(ctx, aCompanyOrgUnitInfo, purInBill.getNumber()));
        cabi.setCalculateKind(calculateKind);
        if (period != null) {
            cabi.setBizDate((Date)period.get("BizDate"));
            cabi.setYear(((PeriodInfo)period.get("Period")).getPeriodYear());
            cabi.setPeriod(((PeriodInfo)period.get("Period")).getPeriodNumber());
        }
        if (calculateKind == CalculateKindEnum.OUTPUT_WAREHOUSE) {
            cabi.setIssueType(IssueTypeEnum.SALEISSUEBILL);
        } else {
            cabi.setIssueType(IssueTypeEnum.NULL);
        }
        cabi.setStorageOrgUnit(storageOrgInfo);
        SupplierInfo supplierinfo = null;
        if (!StringUtil.isEmpty((String)supplier)) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(BOSUuid.read((String)supplier));
        }
        cabi.setSupplier(supplierinfo);
        CustomerInfo customerinfo = null;
        if (!StringUtil.isEmpty((String)purInBill.getCustomer())) {
            customerinfo = new CustomerInfo();
            customerinfo.setId(BOSUuid.read((String)purInBill.getCustomer()));
        }
        cabi.setCustomer(customerinfo);
        AdminOrgUnitInfo adminOrgUnit = null;
        if (!StringUtil.isEmpty((String)purInBill.getAdminOrgUnit())) {
            adminOrgUnit = new AdminOrgUnitInfo();
            adminOrgUnit.setId(BOSUuid.read((String)purInBill.getAdminOrgUnit()));
        }
        cabi.setAdminOrgUnit(adminOrgUnit);
        CostCenterOrgUnitInfo costCenter = null;
        if (purInBill.getCostCenter() != null && purInBill.getCostCenter().trim().length() != 0) {
            costCenter = new CostCenterOrgUnitInfo();
            costCenter.setId(BOSUuid.read((String)purInBill.getCostCenter()));
        }
        cabi.setCostCenterOrgUnit(costCenter);
        cabi.setIsInitBill(false);
        cabi.setIsReversed(false);
        cabi.setFiVouchered(false);
        cabi.setTotalActualCost(CalConstant.ZERO);
        cabi.setTotalStandardCost(CalConstant.ZERO);
        cabi.setTotalAmount(CalConstant.ZERO);
        cabi.setTotalQty(CalConstant.ZERO);
        cabi.setCreateTime(new Timestamp(new Date().getTime()));
        cabi.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        cabi.setLastUpdateTime(new Timestamp(new Date().getTime()));
        cabi.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        cabi.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        cabi.setAuditTime(new Timestamp(new Date().getTime()));
        cabi.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (isDevolve) {
            cabi.setCreateType(CostAdjuestCreateTypeEnum.DEV_AUTOCREATE);
        } else {
            cabi.setCreateType(CostAdjuestCreateTypeEnum.AUTOCREATE);
        }
        cabi.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return cabi;
    }

    public static void setCostAdjustBillPeriod(Map period, CostAdjustBillInfo cabi, WriteOffGroupInfo writeoffgroupinfo) {
        cabi.setBizDate((Date)period.get("BizDate"));
        cabi.setYear(((PeriodInfo)period.get("Period")).getPeriodYear());
        cabi.setPeriod(((PeriodInfo)period.get("Period")).getPeriodNumber());
        WriteOffRecordCollection collection = writeoffgroupinfo.getEntry();
        for (int i = 0; collection != null && i < collection.size(); ++i) {
            WriteOffRecordInfo writeOffRecordInfo = collection.get(i);
            if (!"410".equals(writeOffRecordInfo.getBillTypeNumber())) continue;
            writeOffRecordInfo.setBillDate(cabi.getBizDate());
        }
    }

    public static String createCostAdjustEntrySQL(CostAdjustBillInfo adjBill, CostAdjustBillEntryInfo entryinfo, boolean isAdjust, boolean isSpecialAcc) throws EASBizException, BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID,FAssistPropertyID");
        sqlentry.append(",FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID");
        sqlentry.append(",FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty");
        sqlentry.append(",FReturnBaseQty,FReverseBaseQty");
        sqlentry.append(",FSOURCEBILLID,FSOURCEBILLNUMBER,FSOURCEBILLENTRYID,FSOURCEBILLENTRYSEQ ");
        sqlentry.append(",FProjectID,FTrackNumberID,FStoreTypeID,FStoreStatusID,FLocationID,FIsDischg,FBizDate )Values(");
        sqlentry.append("'").append(entryinfo.getId()).append("'");
        sqlentry.append(",").append(entryinfo.getSeq());
        sqlentry.append(",0");
        sqlentry.append(",").append(entryinfo.getBaseStatus().getValue()).append("");
        sqlentry.append(",'").append(entryinfo.getMaterial().getId()).append("'");
        if (isAdjust && entryinfo.getAssistProperty() != null) {
            sqlentry.append(",'").append(entryinfo.getAssistProperty().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getUnit().getId().toString()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getBaseUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getBaseUnit().getId().toString()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getStorageOrgUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getStorageOrgUnit().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getCompanyOrgUnit() != null) {
            sqlentry.append(",'").append(entryinfo.getCompanyOrgUnit().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if (entryinfo.getWarehouse() != null) {
            sqlentry.append(",'").append(entryinfo.getWarehouse().getId()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        if ((isAdjust || isSpecialAcc) && null != entryinfo.getLot()) {
            sqlentry.append(",'").append(entryinfo.getLot()).append("'");
        } else {
            sqlentry.append(",NULL");
        }
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getQty() == null ? CalConstant.ZERO : entryinfo.getQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getBaseQty() == null ? CalConstant.ZERO : entryinfo.getBaseQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getAssistQty() == null ? CalConstant.ZERO : entryinfo.getAssistQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getReverseQty() == null ? CalConstant.ZERO : entryinfo.getReverseQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getReturnsQty() == null ? CalConstant.ZERO : entryinfo.getReturnsQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getPrice() == null ? CalConstant.ZERO : entryinfo.getPrice())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getAmount() == null ? CalConstant.ZERO : entryinfo.getAmount()))).append("");
        sqlentry.append(",0");
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getStandardCost() == null ? CalConstant.ZERO : entryinfo.getStandardCost())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getUnitActualCost() == null ? CalConstant.ZERO : entryinfo.getUnitActualCost())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getActualCost() == null ? CalConstant.ZERO : entryinfo.getActualCost())));
        sqlentry.append(",'").append(adjBill.getId()).append("'");
        sqlentry.append(",0");
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getAssociateQty() == null ? CalConstant.ZERO : entryinfo.getAssociateQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getReturnBaseQty() == null ? CalConstant.ZERO : entryinfo.getReturnBaseQty())));
        sqlentry.append(",").append(StringUtil.bigDecimal2String((BigDecimal)(entryinfo.getReverseBaseQty() == null ? CalConstant.ZERO : entryinfo.getReverseBaseQty())));
        sqlentry.append(",'").append(entryinfo.getSourceBillId() == null ? "" : entryinfo.getSourceBillId()).append("'");
        sqlentry.append(",'").append(entryinfo.getSourceBillNumber() == null ? "" : entryinfo.getSourceBillNumber()).append("'");
        sqlentry.append(",'").append(entryinfo.getSourceBillEntryId() == null ? "" : entryinfo.getSourceBillEntryId()).append("'");
        sqlentry.append(",").append(entryinfo.getSourceBillEntrySeq());
        if (entryinfo.getProject() != null && entryinfo.getProject().getId() != null) {
            sqlentry.append(",'").append(entryinfo.getProject().getId().toString()).append("'");
        } else {
            sqlentry.append(", NULL");
        }
        if (entryinfo.getTrackNumber() != null && entryinfo.getTrackNumber().getId() != null) {
            sqlentry.append(",'").append(entryinfo.getTrackNumber().getId().toString()).append("'");
        } else {
            sqlentry.append(", NULL");
        }
        if (entryinfo.getStoreType() == null) {
            sqlentry.append(",'").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        } else {
            sqlentry.append(",'").append(entryinfo.getStoreType().getId().toString()).append("'");
        }
        if (entryinfo.getStoreStatus() == null) {
            sqlentry.append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
        } else {
            sqlentry.append(",'").append(entryinfo.getStoreStatus().getId().toString()).append("'");
        }
        if (entryinfo.getLocation() != null && entryinfo.getLocation().getId() != null) {
            sqlentry.append(",'").append(entryinfo.getLocation().getId().toString()).append("'");
        } else {
            sqlentry.append(", NULL");
        }
        sqlentry.append(",").append(entryinfo.isIsDischg() ? 1 : 0);
        sqlentry.append(",TO_DATE('").append(sdf.format(adjBill.getBizDate())).append("')");
        sqlentry.append(")");
        return sqlentry.toString();
    }

    public static CostAdjustBillEntryInfo createCostAdjustEntry(CalculateWrittenOffBill calBill, CalculateWrittenOffEntry calEntry, int seq, BigDecimal diffSum) throws CalculateException {
        CostAdjustBillEntryInfo caei = null;
        if (!NumericUtil.isEqualsZero((BigDecimal)diffSum)) {
            caei = new CostAdjustBillEntryInfo();
            caei.setId(BOSUuid.create((BOSObjectType)caei.getBOSType()));
            caei.setSeq(seq + 1);
            caei.setSourceBillId(calBill.getId());
            caei.setSourceBillEntryId(calEntry.getId());
            caei.setIsPresent(false);
            caei.setAssCoefficient(CalConstant.ZERO);
            caei.setAmount(diffSum.setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            caei.setPrice(CalConstant.ZERO);
            caei.setActualCost(caei.getAmount());
            caei.setUnitActualCost(CalConstant.ZERO);
            caei.setStandardCost(caei.getAmount());
            caei.setUnitStandardCost(CalConstant.ZERO);
            caei.setQty(CalConstant.ZERO);
            caei.setBaseQty(CalConstant.ZERO);
            caei.setAssistQty(CalConstant.ZERO);
            caei.setAssociateQty(CalConstant.ZERO);
            caei.setReturnBaseQty(CalConstant.ZERO);
            caei.setReverseBaseQty(CalConstant.ZERO);
            caei.setReturnsQty(CalConstant.ZERO);
            caei.setReverseQty(CalConstant.ZERO);
            caei.setMaterial(calEntry.getMaterial());
            caei.setLot(calEntry.getBatch());
            caei.setBaseUnit(calEntry.getMaterialBaseUnit());
            caei.setUnit(calEntry.getMaterialUnit());
            caei.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            if (calEntry.getWarehouse() == null || calEntry.getWarehouse().getId() == null) {
                throw new CalculateException(CalculateException.WAREHOUSE_NOT_EXIST);
            }
            if (calEntry.getStorageOrg() == null || calEntry.getStorageOrg().getId() == null) {
                throw new CalculateException(CalculateException.STOREAGE_ORG_NOT_EXIST);
            }
            if (calEntry.getFinanceOrg() == null || calEntry.getFinanceOrg().getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            caei.setWarehouse(calEntry.getWarehouse());
            caei.setStorageOrgUnit(calEntry.getStorageOrg());
            caei.setCompanyOrgUnit(calEntry.getFinanceOrg());
        }
        return caei;
    }

    public static CostAdjustBillEntryInfo createCostAdjustEntry2(CalculateWrittenOffBill calBill, CalculateWrittenOffEntry calEntry, int seq, BigDecimal diffSum, boolean isReverseSign, boolean isMerageCostAdjBill) throws CalculateException {
        CostAdjustBillEntryInfo caei = null;
        caei = new CostAdjustBillEntryInfo();
        BigDecimal netno1 = new BigDecimal("-1.00");
        caei.setId(BOSUuid.create((BOSObjectType)caei.getBOSType()));
        caei.setSeq(seq + 1);
        if (isReverseSign) {
            caei.setSourceBillId(calBill.getId());
            caei.setSourceBillEntryId(calEntry.getId());
            caei.setSourceBillNumber(calBill.getNumber());
            caei.setSourceBillEntrySeq(calEntry.getSeq());
        }
        caei.setIsPresent(false);
        caei.setAssCoefficient(CalConstant.ZERO);
        if (isMerageCostAdjBill) {
            caei.setAmount(diffSum);
            caei.setActualCost(diffSum);
            caei.setStandardCost(diffSum);
            caei.setQty(CalConstant.ZERO);
        } else if (isReverseSign) {
            caei.setAmount(calEntry.getCurrWriteOffAmt().multiply(netno1));
            caei.setActualCost(calEntry.getCurrWriteOffAmt().multiply(netno1));
            caei.setStandardCost(calEntry.getCurrWriteOffAmt().multiply(netno1));
            caei.setQty(CalConstant.ZERO.compareTo(caei.getActualCost()) < 0 ? calEntry.getCurrWriteOffQty().abs() : calEntry.getCurrWriteOffQty().abs().negate());
        } else {
            caei.setAmount(calEntry.getCurrWriteOffAmt());
            caei.setActualCost(calEntry.getCurrWriteOffAmt());
            caei.setStandardCost(calEntry.getCurrWriteOffAmt());
            caei.setQty(CalConstant.ZERO.compareTo(caei.getActualCost()) < 0 ? calEntry.getCurrWriteOffQty().abs() : calEntry.getCurrWriteOffQty().abs().negate());
        }
        caei.setBaseQty(caei.getQty());
        caei.setAssistQty(CalConstant.ZERO);
        caei.setUnitActualCost(calEntry.getBaseUnitPrice());
        if (NumericUtil.isEqualsZero((BigDecimal)caei.getQty())) {
            caei.setPrice(CalConstant.ZERO);
        } else {
            caei.setPrice(calEntry.getCurrWriteOffAmt().abs().divide(calEntry.getCurrWriteOffQty().abs(), calEntry.getPrecision().getPricePrecision(), 4));
        }
        caei.setUnitStandardCost(CalConstant.ZERO);
        caei.setAssociateQty(CalConstant.ZERO);
        caei.setReturnBaseQty(CalConstant.ZERO);
        caei.setReverseBaseQty(CalConstant.ZERO);
        caei.setReturnsQty(CalConstant.ZERO);
        caei.setReverseQty(CalConstant.ZERO);
        caei.setMaterial(calEntry.getMaterial());
        caei.setBaseUnit(calEntry.getMaterialBaseUnit());
        caei.setUnit(calEntry.getMaterialBaseUnit());
        caei.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        caei.setLot(calEntry.getBatch());
        caei.setAssistProperty(calEntry.getAssistProperty());
        if (calEntry.getFinanceOrg() == null || calEntry.getFinanceOrg().getId() == null) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        caei.setWarehouse(calEntry.getWarehouse());
        caei.setStorageOrgUnit(calEntry.getStorageOrg());
        caei.setCompanyOrgUnit(calEntry.getFinanceOrg());
        StoreTypeInfo storeType = new StoreTypeInfo();
        storeType.setId(BOSUuid.read((String)calEntry.getStoreTypeId()));
        StoreStateInfo storeState = new StoreStateInfo();
        storeState.setId(BOSUuid.read((String)calEntry.getStoreStateId()));
        caei.setStoreType(storeType);
        caei.setStoreStatus(storeState);
        if (calEntry.getLocationId() != null) {
            LocationInfo locationInfo = new LocationInfo();
            locationInfo.setId(BOSUuid.read((String)calEntry.getLocationId()));
            caei.setLocation(locationInfo);
        }
        if (calEntry.getProjectID() != null) {
            ProjectInfo project = new ProjectInfo();
            project.setId(BOSUuid.read((String)calEntry.getProjectID()));
            caei.setProject(project);
        }
        if (calEntry.getTrackNumberID() != null) {
            TrackNumberInfo trackNumber = new TrackNumberInfo();
            trackNumber.setId(BOSUuid.read((String)calEntry.getTrackNumberID()));
            caei.setTrackNumber(trackNumber);
        }
        if (!isMerageCostAdjBill && isReverseSign && CalculateUtil.ZERO.compareTo(calEntry.getAmount().abs()) != 0 && CalculateUtil.ZERO.compareTo(caei.getAmount().abs()) != 0 && calEntry.getAmount().signum() != caei.getAmount().signum()) {
            caei.setIsDischg(true);
        }
        return caei;
    }

    public static boolean isMergeCostAdjustBill(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        String calType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_004");
        return "0".equals(calType);
    }

    public static String getPreparedInsertCostadjustBillSQL() {
        StringBuffer sql = new StringBuffer(512);
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",\n FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",\n FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",\n FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",\n FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",\n FIsInitBill,FCreateType");
        sql.append(") Values(");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?)");
        return sql.toString();
    }

    public static String getPreparedInserCostadjustEntrySQL() {
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("\n FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID");
        sqlentry.append(",\n FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID");
        sqlentry.append(",\n FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",\n FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",\n FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty");
        sqlentry.append(",\n FReturnBaseQty,FReverseBaseQty,FStoreTypeID,FStoreStatusID,FBizDate");
        sqlentry.append(") Values(");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?)");
        return sqlentry.toString();
    }

    public static String getPreparedInsertCostadjustEntrySQL() {
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("\n FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID");
        sqlentry.append(",\n FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID,FLocationID");
        sqlentry.append(",\n FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",\n FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",\n FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty");
        sqlentry.append(",\n FReturnBaseQty,FReverseBaseQty,FStoreTypeID,FStoreStatusID,FCustomerID,FAssistPropertyID,FBizDate");
        sqlentry.append(") Values(");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,");
        sqlentry.append("\n ?,?,?,?,?,?,?)");
        return sqlentry.toString();
    }

    public static boolean deleteCostAdjustBill(Context ctx, CalculateParams params, CostAdjuestCreateTypeEnum type, SysTempTableHelper sysTempTableHelper) throws BOSException {
        boolean success = false;
        if (params != null) {
            String[] sqls = new String[]{CostAdjustHelper.getDeleteCostAdjBillEntrySql(params, type), CostAdjustHelper.getDeleteCostAdjBillSql(params, type)};
            sysTempTableHelper.execute(sqls);
            success = true;
        }
        return success;
    }

    public static String getDeleteCostAdjBillSql(CalculateParams params, CostAdjuestCreateTypeEnum type) {
        StringBuffer bufferSql = new StringBuffer();
        bufferSql.append("DELETE FROM T_CL_COSTADJUSTBILL ");
        bufferSql.append("\n WHERE EXISTS(");
        bufferSql.append("\n SELECT T1.FID FROM T_CL_COSTADJUSTBILL T1");
        bufferSql.append("\n LEFT JOIN T_CL_COSTADJUSTBILLENTRY T2 ON T1.FID = T2.FPARENTID");
        bufferSql.append("\n WHERE T1.FBASESTATUS = 4 AND T2.FID IS  NULL  \n AND T_CL_COSTADJUSTBILL.FID = T1.FID )");
        return bufferSql.toString();
    }

    public static String getDeleteCostAdjBillEntrySql(CalculateParams params, CostAdjuestCreateTypeEnum type) {
        String calType;
        String companyId;
        StringBuffer bufferSql = new StringBuffer(256);
        bufferSql.append("DELETE FROM T_CL_COSTADJUSTBILLENTRY ");
        bufferSql.append("\n WHERE  EXISTS ( ");
        bufferSql.append("\n SELECT T2.FID  FROM T_CL_COSTADJUSTBILL T2,T_CL_COSTADJUSTBILLENTRY T1 WHERE T2.FID = T1.FPARENTID");
        PeriodInfo period = (PeriodInfo)params.getObject("PERIOD_OBJ");
        if (period != null) {
            bufferSql.append("\n AND T2.FYEAR = ").append(period.getPeriodYear());
            bufferSql.append(" AND T2.FPERIOD = ").append(period.getPeriodNumber());
        }
        if (type != null) {
            bufferSql.append("\n AND T2.FCREATETYPE = ").append(type.getValue());
        }
        if ((companyId = params.getString("COMPANY_ID")) != null) {
            bufferSql.append("\n AND T1.FCOMPANYORGUNITID = '").append(companyId).append("'");
        }
        if ("1".equals(calType = params.getString("CALTYPE"))) {
            String storageId = params.getString("STORAGEORGUNITID");
            if (!StringUtil.isEmpty((String)storageId)) {
                bufferSql.append("\n AND T1.FStorageOrgUnitID = '").append(storageId).append("'");
            }
        } else if ("2".equals(calType)) {
            String warehouseId;
            String storageId = params.getString("STORAGEORGUNITID");
            if (StringUtil.isEmpty((String)storageId)) {
                bufferSql.append("\n AND T1.FStorageOrgUnitID = '").append(storageId).append("'");
            }
            if (!StringUtil.isEmpty((String)(warehouseId = params.getString("WAREHOUSEID")))) {
                bufferSql.append("\n AND T1.FWareHouseID = '").append(warehouseId).append("'");
            }
        }
        bufferSql.append("\n AND T2.FFIVOUCHERED = 0 ");
        bufferSql.append(" AND T_CL_COSTADJUSTBILLENTRY.FPARENTID = T2.FID");
        bufferSql.append(")");
        return bufferSql.toString();
    }

    public static boolean isExistExpAdjZeroCostAdjBill(Context ctx, CalculateParams params, CostAdjuestCreateTypeEnum type, SysTempTableHelper sysTempTableHelper) throws BOSException, CalculateException {
        String storageId;
        if (params == null) {
            return false;
        }
        PeriodInfo period = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String companyId = params.getString("COMPANY_ID");
        String calType = params.getString("CALTYPE");
        StringBuffer filterStr = new StringBuffer();
        if (type != null) {
            filterStr.append("T1.FCreateType = ").append(type.getValue());
        }
        if (period != null) {
            filterStr.append("\n AND T1.FYEAR = ").append(period.getPeriodYear());
            filterStr.append("\n AND T1.FPERIOD = ").append(period.getPeriodNumber());
        }
        if (companyId != null) {
            filterStr.append("\n AND T2.FCOMPANYORGUNITID = '").append(companyId).append("'");
        }
        filterStr.append("\n AND T1.FFIVOUCHERED = 1 AND T1.FBASESTATUS = ").append(4);
        if ("1".equals(calType)) {
            storageId = params.getString("STORAGEORGUNITID");
            if (!StringUtil.isEmpty((String)storageId)) {
                filterStr.append("\n AND T2.FStorageOrgUnitID = '").append(storageId).append("'");
            }
        } else if ("2".equals(calType)) {
            String warehouseId;
            storageId = params.getString("STORAGEORGUNITID");
            if (!StringUtil.isEmpty((String)storageId)) {
                filterStr.append("\n AND T2.FStorageOrgUnitID = '").append(storageId).append("'");
            }
            if (!StringUtil.isEmpty((String)(warehouseId = params.getString("WAREHOUSEID")))) {
                filterStr.append("\n AND T2.FWareHouseID = '").append(warehouseId).append("'");
            }
        }
        StringBuffer bufferSql = new StringBuffer(128);
        bufferSql.append("SELECT 1 FROM T_CL_COSTADJUSTBILL T1 ");
        bufferSql.append("\n INNER JOIN T_CL_COSTADJUSTBILLENTRY T2 ON T1.FID = T2.FPARENTID");
        bufferSql.append("\n WHERE ").append(filterStr.toString());
        try {
            IRowSet rowSet = sysTempTableHelper.executeQuery(bufferSql.toString());
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.EXPCOSTADJZERO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static void generateVoucherInNewThread(final Context ctx, final CoreBillBaseCollection collection, final String companyOrgUnititid) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CostAdjustHelper.generAteNewVoucher(ctx, collection, companyOrgUnititid);
                }
                catch (EASBizException eASBizException) {
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public static void generAteNewVoucher(Context ctx, CoreBillBaseCollection collection, String companyOrgUnititid) throws EASBizException, BOSException {
        try {
            if (companyOrgUnititid != null) {
                ICompanyOrgUnit icomp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selColl = new SelectorItemCollection();
                selColl.add(new SelectorItemInfo("id"));
                selColl.add(new SelectorItemInfo("cu"));
                CompanyOrgUnitInfo selectCompany = icomp.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnititid));
                CtrlUnitInfo cu = selectCompany.getCU();
                ObjectUuidPK botMappingPk = null;
                if (cu != null) {
                    IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                    HashMap<String, CtrlUnitInfo> curCtx = new HashMap<String, CtrlUnitInfo>();
                    curCtx.put("TRANSMITCU", cu);
                    String voucherBosType = new VoucherInfo().getBOSType().toString();
                    BOTMappingCollection bc = iBotMapping.getMappingCollectionForSelect(collection, voucherBosType, DefineSysEnum.DAP, curCtx);
                    if (bc.get(0) != null) {
                        botMappingPk = new ObjectUuidPK(bc.get(0).getId());
                    }
                    ICostAdjustBill ii = CostAdjustBillFactory.getLocalInstance(ctx);
                    ii.generateVoucher(collection, (IObjectPK)botMappingPk);
                }
            }
        }
        catch (Exception e) {
            Logger.info((String)e.toString());
        }
    }

    public static CostAdjustBillInfo createCostAdjustBill(CostAdjustBillInfo bill, CostAdjustBillInfo newBill, CalculateKindEnum calculateKind) {
        if (bill != null) {
            newBill.setAuditor(bill.getAuditor());
            newBill.setAdminOrgUnit(bill.getAdminOrgUnit());
            newBill.setBaseStatus(bill.getBaseStatus());
            newBill.setBizDate(bill.getBizDate());
            newBill.setId(BOSUuid.create((BOSObjectType)bill.getBOSType()));
            newBill.setIssueType(IssueTypeEnum.SALEISSUEBILL);
            newBill.setCU(bill.getCU());
            newBill.setCreateTime(bill.getCreateTime());
            newBill.setCreator(bill.getCreator());
            newBill.setLastUpdateUser(bill.getLastUpdateUser());
            newBill.setAuditTime(bill.getAuditTime());
            newBill.setStorageOrgUnit(bill.getStorageOrgUnit());
            newBill.setCalculateKind(calculateKind);
            newBill.setYear(bill.getYear());
            newBill.setPeriod(bill.getPeriod());
            newBill.setSupplier(bill.getSupplier());
            newBill.setCustomer(bill.getCustomer());
            newBill.setLastUpdateTime(bill.getLastUpdateTime());
            newBill.setBillType(bill.getBillType());
            if (bill.getAuditor() == null) {
                newBill.setAuditor(bill.getCreator());
            } else {
                newBill.setAuditor(bill.getAuditor());
            }
        }
        return newBill;
    }

    public static CostAdjustBillEntryInfo createExpCostAdjustEntry(CalculateWrittenOffEntry calEntry, int seq, BigDecimal diffSum) throws CalculateException {
        CostAdjustBillEntryInfo caei = null;
        if (!NumericUtil.isEqualsZero((BigDecimal)diffSum)) {
            caei = new CostAdjustBillEntryInfo();
            caei.setId(BOSUuid.create((String)"2774F28C"));
            caei.setSeq(seq + 1);
            caei.setIsPresent(false);
            caei.setAssCoefficient(CalConstant.ZERO);
            caei.setAmount(diffSum.setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            caei.setPrice(CalConstant.ZERO);
            caei.setActualCost(caei.getAmount());
            caei.setUnitActualCost(CalConstant.ZERO);
            caei.setStandardCost(caei.getAmount());
            caei.setUnitStandardCost(CalConstant.ZERO);
            caei.setQty(CalConstant.ZERO);
            caei.setBaseQty(CalConstant.ZERO);
            caei.setAssistQty(CalConstant.ZERO);
            caei.setAssociateQty(CalConstant.ZERO);
            caei.setReturnBaseQty(CalConstant.ZERO);
            caei.setReverseBaseQty(CalConstant.ZERO);
            caei.setReturnsQty(CalConstant.ZERO);
            caei.setReverseQty(CalConstant.ZERO);
            caei.setMaterial(calEntry.getMaterial());
            caei.setLot(calEntry.getBatch());
            if (calEntry.getMaterialBaseUnit() == null) {
                caei.setBaseUnit(calEntry.getMaterialUnit());
                caei.setUnit(calEntry.getMaterialUnit());
            } else {
                caei.setBaseUnit(calEntry.getMaterialBaseUnit());
                caei.setUnit(calEntry.getMaterialBaseUnit());
            }
            caei.setAssistProperty(calEntry.getAssistProperty());
            caei.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            if (calEntry.getWarehouse() == null || calEntry.getWarehouse().getId() == null) {
                throw new CalculateException(CalculateException.WAREHOUSE_NOT_EXIST);
            }
            if (calEntry.getStorageOrg() == null || calEntry.getStorageOrg().getId() == null) {
                throw new CalculateException(CalculateException.STOREAGE_ORG_NOT_EXIST);
            }
            if (calEntry.getFinanceOrg() == null || calEntry.getFinanceOrg().getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            caei.setWarehouse(calEntry.getWarehouse());
            caei.setStorageOrgUnit(calEntry.getStorageOrg());
            caei.setCompanyOrgUnit(calEntry.getFinanceOrg());
            if (calEntry.getLocationId() != null) {
                LocationInfo locationInfo = new LocationInfo();
                locationInfo.setId(BOSUuid.read((String)calEntry.getLocationId()));
                caei.setLocation(locationInfo);
            }
        }
        return caei;
    }

    public static String getCostAdjSql(Context ctx, String billNumber) {
        StringBuffer sqldel = new StringBuffer(1024);
        sqldel.append("SELECT ");
        sqldel.append("bill.FNumber,");
        sqldel.append("0 AS FQty,");
        sqldel.append("factualcost AS FCost,");
        sqldel.append("entry.FMaterialID AS FMaterialID,");
        sqldel.append("materialcompany.FAccountType AS FAccountType ,");
        sqldel.append("entry.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqldel.append("entry.FStorageOrgUnitID AS FStorageOrgUnitID,");
        sqldel.append("entry.FWarehouseID AS FWarehouseID ");
        sqldel.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqldel.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqldel.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqldel.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqldel.append("\n FROM t_cl_costadjustbill bill ");
        sqldel.append(" inner join t_cl_costadjustbillentry entry on bill.fid=entry.fparentid ");
        sqldel.append(" INNER JOIN T_BD_MaterialCompanyInfo materialcompany ");
        sqldel.append(" ON (entry.FMaterialID = materialcompany.FMaterialID ");
        sqldel.append(" AND entry.FCompanyOrgUnitID = materialcompany.FCompanyID )");
        sqldel.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqldel.append(" ON entry.FMaterialID = MATERIAL.FId");
        sqldel.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqldel.append(" ON (entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sqldel.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqldel.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sqldel.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqldel.append(" ON entry.FCompanyOrgUnitID = COMPANY.FID");
        sqldel.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqldel.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sqldel.append("\n WHERE materialcompany.FAccountType = 1");
        sqldel.append(" AND bill.FFIVOUCHERED=0 ");
        sqldel.append(" AND bill.fnumber='").append(billNumber).append("'");
        sqldel.append(" Order by entry.Fseq");
        return sqldel.toString();
    }

    public static String[] getDeleteCostAdjustbill(String billNumber) {
        String[] sqlArr = new String[2];
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("DELETE FROM t_cl_costadjustbillentry WHERE fparentid =(");
        buffer.append(" SELECT FID FROM t_cl_costadjustbill WHERE FNUMBER='").append(billNumber).append("')");
        sqlArr[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("DELETE FROM t_cl_costadjustbill WHERE FNUMBER='").append(billNumber).append("'");
        sqlArr[1] = buffer.toString();
        return sqlArr;
    }

    public static String getCostAdjSqlForNumber(Context ctx, String[] numbers) {
        StringBuffer sqldel = new StringBuffer(1024);
        sqldel.append("SELECT ");
        sqldel.append("bill.FNumber,");
        sqldel.append("0 AS FQty,");
        sqldel.append("factualcost AS FCost,");
        sqldel.append("entry.FMaterialID AS FMaterialID,");
        sqldel.append("materialcompany.FAccountType AS FAccountType ,");
        sqldel.append("entry.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqldel.append("entry.FStorageOrgUnitID AS FStorageOrgUnitID,");
        sqldel.append("entry.FWarehouseID AS FWarehouseID ");
        sqldel.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqldel.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqldel.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqldel.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqldel.append("\n FROM t_cl_costadjustbill bill ");
        sqldel.append(" inner join t_cl_costadjustbillentry entry on bill.fid=entry.fparentid ");
        sqldel.append(" INNER JOIN T_BD_MaterialCompanyInfo materialcompany ");
        sqldel.append(" ON (entry.FMaterialID = materialcompany.FMaterialID ");
        sqldel.append(" AND entry.FCompanyOrgUnitID = materialcompany.FCompanyID )");
        sqldel.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqldel.append(" ON entry.FMaterialID = MATERIAL.FId");
        sqldel.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqldel.append(" ON (entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sqldel.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqldel.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sqldel.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqldel.append(" ON entry.FCompanyOrgUnitID = COMPANY.FID");
        sqldel.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqldel.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sqldel.append("\n WHERE materialcompany.FAccountType = 1");
        sqldel.append(" AND bill.fnumber IN ").append(CostAdjustHelper.getSqlInPart(numbers));
        sqldel.append(" Order by entry.Fseq");
        return sqldel.toString();
    }

    public static String getCostAdjnumberSql(String[] ids) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("SELECT CONCAT('*',FNUMBER) AS NEWFNUMBER,FNUMBER AS FNUMBER FROM t_cl_costadjustbill  \n WHERE FFIVOUCHERED =0 AND FID IN").append(CostAdjustHelper.getSqlInPart(ids));
        return buffer.toString();
    }

    public static String getSqlInPart(String[] ids) {
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        return bf.toString();
    }

    public static String getSqlInOrEqualPart(String[] ids) {
        StringBuffer bf = new StringBuffer();
        if (ids != null) {
            if (ids.length == 1) {
                bf.append("'").append(ids[0]).append("'");
            } else {
                bf.append(CostAdjustHelper.getSqlInPart(ids));
            }
        }
        return bf.toString();
    }

    public static boolean checkCostAdjBillIsVouchered(Context ctx, String[] fnumber, boolean isExpenseApportionException) throws BOSException, SQLException, ExpenseApportionException, ManualWriteOffException {
        StringBuffer buffer = new StringBuffer();
        if (fnumber != null) {
            String equalOrInStr = "=";
            if (fnumber.length > 1) {
                equalOrInStr = "IN";
            }
            buffer.append("SELECT FFiVouchered as FFiVouchered,FNUMBER AS FNUMBER FROM  T_CL_COSTADJUSTBILL \n WHERE FNUMBER ").append(equalOrInStr);
            buffer.append(CostAdjustHelper.getSqlInOrEqualPart(fnumber));
            IRowSet row = DBUtil.executeQuery((Context)ctx, (String)buffer.toString());
            while (row.next()) {
                if (row.getInt("FFiVouchered") != 1) continue;
                if (isExpenseApportionException) {
                    throw new ExpenseApportionException(ExpenseApportionException.DEL_APPORLISTING_ALERT, new String[]{row.getString("FNUMBER")});
                }
                throw new ManualWriteOffException(ManualWriteOffException.DEL_WRITEOFF_ALERT);
            }
        }
        return false;
    }
}

