/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.newutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RecentCostHelper {
    private static Logger logger = Logger.getLogger(RecentCostHelper.class);
    private static String costAdjustBillEntryName = "T_CL_CostAdjustBillEntry";
    private static String T_IM_INVENTORYBALANCE = "T_IM_INVENTORYBALANCE";
    private static String T_CL_INVENTORYBALANCE = "T_CL_INVENTORYBALANCE";

    public String calculateCost(Context ctx, String materialCalType, CalculateWrittenOffEntry entry, HashMap materialRecentCostHashMap, BigDecimal qty, BigDecimal sum) throws EASBizException, BOSException {
        StringBuffer returnStr = new StringBuffer();
        if (!AccountType.MOVE_ADD_AVERAGE.equals((Object)entry.getMaterialAccountType()) || materialRecentCostHashMap == null) {
            return null;
        }
        String id = CalculateUtil.getCalTypeMaterialKey(materialCalType, entry.getMaterialId(), entry.getFinanceOrg().getId().toString(), entry.getStorageOrgUnitId(), entry.getWarehouseId());
        HashMap<String, Boolean> innerHm = (HashMap<String, Boolean>)materialRecentCostHashMap.get(id.toString());
        if (innerHm != null) {
            returnStr.append(RecentCostHelper.takeAmountQytPriceDesc(((BigDecimal)innerHm.get("FRecentCost")).setScale(entry.getPrecision().getLocalCurrencyPrecision(), 4), ((BigDecimal)innerHm.get("FRecentQty")).setScale(entry.getPrecision().getBaseQtyPrecision(), 4), RecentCostHelper.getPrice(ctx, (BigDecimal)innerHm.get("FRecentCost"), (BigDecimal)innerHm.get("FRecentQty"), entry.getPrecision().getPricePrecision(), entry, false)));
            this.setRecentCostHashMap(ctx, innerHm, entry, qty.add((BigDecimal)innerHm.get("FRecentQty")), sum.add((BigDecimal)innerHm.get("FRecentCost")));
        } else {
            returnStr.append(RecentCostHelper.takeAmountQytPriceDesc(CalConstant.ZERO, CalConstant.ZERO, CalConstant.ZERO));
            innerHm = new HashMap<String, Boolean>();
            innerHm.put("isUpdate", new Boolean(false));
            this.setRecentCostHashMap(ctx, innerHm, entry, qty, sum);
            materialRecentCostHashMap.put(id.toString(), innerHm);
        }
        if (!"".equals(returnStr.toString())) {
            returnStr.append("\n");
        }
        returnStr.append(RecentCostHelper.takeAmountQytPriceDesc((BigDecimal)innerHm.get("FRecentCost"), (BigDecimal)innerHm.get("FRecentQty"), (BigDecimal)innerHm.get("FPrice")));
        return returnStr.toString();
    }

    public String calculateCost(Context ctx, String calMode, CalculateWrittenOffEntry entryInfo, ArrayList arraySQL, BigDecimal qty, BigDecimal inSum, BigDecimal diffSum) throws BOSException, EASBizException {
        StringBuffer returnStr = new StringBuffer();
        if (!AccountType.MOVE_ADD_AVERAGE.equals((Object)entryInfo.getMaterialAccountType())) {
            return null;
        }
        RecentCostInfo info = new RecentCostInfo();
        RecentCostInfo tempInfo = RecentCostHelper.getRecentCost(ctx, calMode, entryInfo);
        String id = RecentCostHelper.getRecentCostID(ctx, RecentCostHelper.getFilterByCalMode(calMode, entryInfo));
        String sql = null;
        if (tempInfo != null && !StringUtil.isEmpty((String)id)) {
            returnStr.append(RecentCostHelper.takeAmountQytPriceDesc(tempInfo.getRecentCost(), tempInfo.getRecentQty(), tempInfo.getPrice()));
            BigDecimal qtyAll = qty.add(tempInfo.getRecentQty());
            BigDecimal inSumAll = inSum.add(tempInfo.getRecentCost());
            BigDecimal diffSumAll = diffSum;
            RecentCostHelper.setRecentCostInfo(ctx, info, entryInfo, qtyAll, inSumAll.add(diffSumAll));
            sql = this.updateRecentCostSQL(info, id);
        } else {
            returnStr.append(RecentCostHelper.takeAmountQytPriceDesc(CalConstant.ZERO, CalConstant.ZERO, CalConstant.ZERO));
            BigDecimal qtyAll = qty;
            BigDecimal inSumAll = inSum;
            BigDecimal diffSumAll = diffSum;
            RecentCostHelper.setRecentCostInfo(ctx, info, entryInfo, qtyAll, inSumAll.add(diffSumAll));
            sql = this.addNewRecentCostSQL(ctx, info);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (!"".equals(returnStr.toString())) {
            returnStr.append("\n");
        }
        returnStr.append(RecentCostHelper.takeAmountQytPriceDesc(info.getRecentCost(), info.getRecentQty(), info.getPrice()));
        return returnStr.toString();
    }

    private String addNewRecentCostSQL(Context ctx, RecentCostInfo info) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer(128);
        sql.append(" Insert Into T_CL_RecentCost(FID,FCreatorID,FCreateTime");
        sql.append(" ,FLastUpdateUserID,FLastUpdateTime,FControlUnitID");
        sql.append(" ,FRecentCost,FRecentQty,FPrice");
        if (info.getMaterial() != null && info.getMaterial().getId() != null) {
            sql.append(" ,FMaterialID");
        }
        if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
            sql.append(" ,FCompanyOrgUnitID");
        }
        if (info.getStorageOrgUnit() != null && info.getStorageOrgUnit().getId() != null) {
            sql.append(" ,FStorageOrgUnitID");
        }
        if (info.getWarehouse() != null && info.getWarehouse().getId() != null) {
            sql.append(" ,FWarehouseID");
        }
        sql.append(" )");
        sql.append(" Values(");
        sql.append("  newbosid('").append(info.getBOSType()).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(" ,").append(StringUtil.bigDecimal2String((BigDecimal)info.getRecentCost())).append("");
        sql.append(" ,").append(StringUtil.bigDecimal2String((BigDecimal)info.getRecentQty())).append("");
        sql.append(" ,").append(StringUtil.bigDecimal2String((BigDecimal)info.getPrice())).append("");
        if (info.getMaterial() != null && info.getMaterial().getId() != null) {
            sql.append(" ,'").append(info.getMaterial().getId()).append("'");
        }
        if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
            sql.append(" ,'").append(info.getCompanyOrgUnit().getId()).append("'");
        }
        if (info.getStorageOrgUnit() != null && info.getStorageOrgUnit().getId() != null) {
            sql.append(" ,'").append(info.getStorageOrgUnit().getId()).append("'");
        }
        if (info.getWarehouse() != null && info.getWarehouse().getId() != null) {
            sql.append(" ,'").append(info.getWarehouse().getId()).append("'");
        }
        sql.append(")");
        return sql.toString();
    }

    private String updateRecentCostSQL(RecentCostInfo info, String id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CL_RecentCost ");
        sql.append("      set FRecentCost=").append(StringUtil.bigDecimal2String((BigDecimal)info.getRecentCost())).append("");
        sql.append("         ,FRecentQty=").append(StringUtil.bigDecimal2String((BigDecimal)info.getRecentQty())).append("");
        sql.append("         ,FPrice=").append(StringUtil.bigDecimal2String((BigDecimal)info.getPrice())).append("");
        sql.append(" where FID='").append(id).append("'");
        return sql.toString();
    }

    public static StringBuffer updateRecentCostSQL(BigDecimal price, BigDecimal recentQty, BigDecimal recentCost, String materialID, String CompanyOrgUnitID, String storageOrgUnitID, String warehouseID, String materialCalType) {
        StringBuffer returnStrSQL = new StringBuffer(512);
        returnStrSQL.append(" update t_cl_recentcost");
        returnStrSQL.append(" set ");
        returnStrSQL.append(" FPrice = ").append(StringUtil.bigDecimal2String((BigDecimal)price));
        returnStrSQL.append(",FRecentQty = ").append(StringUtil.bigDecimal2String((BigDecimal)recentQty));
        returnStrSQL.append(",FRecentCost = ").append(StringUtil.bigDecimal2String((BigDecimal)recentCost));
        returnStrSQL.append(" WHERE FMaterialID = '").append(materialID).append("'");
        returnStrSQL.append(" AND FCompanyOrgUnitID = '").append(CompanyOrgUnitID).append("'");
        if (storageOrgUnitID != null && !"0".equals(materialCalType)) {
            returnStrSQL.append(" AND FStorageOrgUnitID = '").append(storageOrgUnitID).append("'");
        }
        if (warehouseID != null && "2".equals(materialCalType)) {
            returnStrSQL.append(" AND FWarehouseID = '").append(warehouseID).append("'");
        }
        return returnStrSQL;
    }

    public static StringBuffer takeAmountQytPriceDesc(BigDecimal recentCost, BigDecimal recentQty, BigDecimal price) {
        return RecentCostHelper.takeAmountQytPriceDesc(recentCost, recentQty, price, false);
    }

    public static StringBuffer takeAmountQytPriceDesc(BigDecimal recentCost, BigDecimal recentQty, BigDecimal price, boolean isCostAjdust) {
        StringBuffer returnStr = new StringBuffer();
        if (!NumericUtil.isEqualsZero((BigDecimal)recentCost)) {
            if (NumericUtil.isEqualsZero((BigDecimal)recentQty) && !isCostAjdust) {
                returnStr.append(recentQty);
                returnStr.append(" * ");
                if (price != null) {
                    returnStr.append(price);
                } else {
                    returnStr.append("0.00");
                }
                returnStr.append(" = ");
            }
            returnStr.append(recentCost);
        } else {
            if (!NumericUtil.isEqualsZero((BigDecimal)recentQty)) {
                returnStr.append(recentQty);
            } else {
                returnStr.append("0.00");
            }
            returnStr.append(" * ").append("0.00").append(" = ").append("0.00");
        }
        return returnStr;
    }

    public static String getRecentCostID(Context ctx, String filterByCalMode) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            String string;
            conn = null;
            stmt = null;
            rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID ");
            sql.append("FROM T_CL_RecentCost ");
            sql.append("WHERE ");
            sql.append(filterByCalMode);
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql.toString());
                rs = stmt.executeQuery();
                if (rs == null || !rs.next()) break block4;
                string = rs.getString("FID");
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    public static void setRecentCostInfo(Context ctx, RecentCostInfo info, CalculateWrittenOffEntry entryInfo, BigDecimal qty, BigDecimal sum) throws EASBizException, BOSException {
        info.setCompanyOrgUnit(entryInfo.getFinanceOrg());
        info.setStorageOrgUnit(entryInfo.getStorageOrg());
        info.setWarehouse(entryInfo.getWarehouse());
        info.setMaterial(entryInfo.getMaterial());
        info.setRecentQty(qty.setScale(entryInfo.getPrecision().getBaseQtyPrecision(), 4));
        info.setRecentCost(sum.setScale(entryInfo.getPrecision().getLocalCurrencyPrecision(), 4));
        info.setPrice(RecentCostHelper.getPrice(ctx, info.getRecentCost(), info.getRecentQty(), entryInfo.getPrecision().getPricePrecision(), entryInfo, true));
    }

    public static BigDecimal getPrice(Context ctx, BigDecimal RecentCost2, BigDecimal RecentQty, int precision, CalculateWrittenOffEntry entryInfo, boolean isCheck) throws EASBizException, BOSException {
        if (!NumericUtil.isEqualsZero((BigDecimal)RecentQty)) {
            BigDecimal temp = NumericUtil.divideBigDecimal((BigDecimal)RecentCost2, (BigDecimal)RecentQty, (int)precision);
            if (temp.compareTo(CalConstant.ZERO) < 0 && isCheck) {
                IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                MaterialInfo minfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId()));
                throw new CalculateException(CalculateException.MATERIAL_RECENT_UNIT_COST_LESS_ZERO, new String[]{CalculateUtil.takeFormateDesc(minfo.getName(), minfo.getNumber())});
            }
            return temp;
        }
        return CalConstant.ZERO;
    }

    public static RecentCostInfo getRecentCost(Context ctx, String calMode, CalculateWrittenOffEntry entry) throws BOSException, EASBizException {
        RecentCostInfo recentCostInfo;
        RecentCostInfo info;
        PreparedStatement stmt;
        Connection conn;
        ResultSet rs;
        block5: {
            rs = null;
            conn = null;
            stmt = null;
            info = new RecentCostInfo();
            StringBuffer sqlBuffer = new StringBuffer(128);
            sqlBuffer.append("SELECT SUM(FRecentCost) AS FRecentCost,SUM(FRecentQty) AS FRecentQty ");
            sqlBuffer.append("FROM T_CL_RecentCost ");
            sqlBuffer.append("WHERE ");
            sqlBuffer.append(RecentCostHelper.getFilterByCalMode(calMode, entry));
            sqlBuffer.append(RecentCostHelper.getGroupSegmentByCalMode(calMode));
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sqlBuffer.toString());
            rs = stmt.executeQuery();
            if (rs != null) break block5;
            RecentCostInfo recentCostInfo2 = null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return recentCostInfo2;
        }
        try {
            info.setRecentQty(rs.getBigDecimal("FRecentQty").setScale(entry.getPrecision().getBaseQtyPrecision(), 4));
            info.setRecentCost(rs.getBigDecimal("FRecentCost").setScale(entry.getPrecision().getLocalCurrencyPrecision(), 4));
            info.setPrice(RecentCostHelper.getPrice(ctx, info.getRecentCost(), info.getRecentQty(), entry.getPrecision().getPricePrecision(), entry, false));
            recentCostInfo = info;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return recentCostInfo;
    }

    public static String getFilterByCalMode(String calMode, CalculateWrittenOffEntry entry) {
        String materialID = "";
        if (entry.getMaterial() != null && entry.getMaterial().getId() != null) {
            materialID = entry.getMaterial().getId().toString();
        }
        String companyOrgID = "";
        if (entry.getFinanceOrg() != null && entry.getFinanceOrg().getId() != null) {
            companyOrgID = entry.getFinanceOrg().getId().toString();
        }
        String storageOrgID = "";
        if (entry.getStorageOrg() != null && entry.getStorageOrg().getId() != null) {
            storageOrgID = entry.getStorageOrg().getId().toString();
        }
        String warehouseID = "";
        if (entry.getWarehouse() != null && entry.getWarehouse().getId() != null) {
            warehouseID = entry.getWarehouse().getId().toString();
        }
        return RecentCostHelper.getFilterByCalMode(calMode, materialID, companyOrgID, storageOrgID, warehouseID);
    }

    public static String getFilterByCalMode(String calMode, String materialID, String companyOrgID, String storageOrgID, String warehouseID) {
        StringBuffer strFilter = new StringBuffer(128);
        if ("0".equals(calMode)) {
            strFilter.append(" FMaterialID in ('").append(materialID).append("')");
            strFilter.append(" AND FCompanyOrgUnitID = '").append(companyOrgID).append("'");
        } else if ("2".equals(calMode)) {
            strFilter.append(" FMaterialID in ('").append(materialID).append("')");
            strFilter.append(" AND FCompanyOrgUnitID = '").append(companyOrgID).append("' ");
            if (storageOrgID != null && storageOrgID.length() > 1) {
                strFilter.append(" AND FStorageOrgUnitID = '").append(storageOrgID).append("' ");
            }
            if (warehouseID != null && warehouseID.length() > 1) {
                strFilter.append(" AND FWarehouseID = '").append(warehouseID).append("'");
            }
        } else if ("1".equals(calMode)) {
            strFilter.append(" FMaterialID in ('").append(materialID).append("')");
            strFilter.append(" AND FCompanyOrgUnitID = '").append(companyOrgID).append("' ");
            if (storageOrgID != null && storageOrgID.length() > 1) {
                strFilter.append(" AND FStorageOrgUnitID = '").append(storageOrgID).append("' ");
            }
        } else {
            strFilter.append(" FMaterialID in ('").append(materialID).append("')");
            strFilter.append(" AND FCompanyOrgUnitID = '").append(companyOrgID).append("'");
        }
        return strFilter.toString();
    }

    public static String getGroupSegmentByCalMode(String calMode) {
        String strGroupBy = "0".equals(calMode) ? " GROUP BY FCompanyOrgUnitID" : ("2".equals(calMode) ? " GROUP BY FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID" : ("1".equals(calMode) ? " GROUP BY FCompanyOrgUnitID,FStorageOrgUnitID" : " GROUP BY FCompanyOrgUnitID"));
        return strGroupBy;
    }

    public static CalculateException throwException(Context ctx, NumericExceptionSubItem calculateException, String calMode, CalculateWrittenOffEntry entry, String exception_msg) throws EASBizException, BOSException {
        String calModeName = "";
        String orgName = "";
        if ("2".equals(calMode)) {
            calModeName = MaterialCalTypeEnum.CAL_TYPE_PARTITION_WAREHOUSE.toString();
            IWarehouse iw = WarehouseFactory.getLocalInstance((Context)ctx);
            WarehouseInfo winfo = iw.getWarehouseInfo((IObjectPK)new ObjectUuidPK(entry.getWarehouse().getId()));
            orgName = CalculateUtil.takeFormateDesc(winfo.getName(), winfo.getNumber());
        } else if ("1".equals(calMode)) {
            calModeName = MaterialCalTypeEnum.CAL_TYPE_PARTITION_STORAGE.toString();
            IStorageOrgUnit ib = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitInfo sinfo = ib.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(entry.getStorageOrgUnitId()));
            orgName = CalculateUtil.takeFormateDesc(sinfo.getName(), sinfo.getNumber());
        } else {
            calModeName = MaterialCalTypeEnum.CAL_TYPE_PARTITION_FINANCE.toString();
            ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo cinfo = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(entry.getFinanceOrg().getId()));
            orgName = CalculateUtil.takeFormateDesc(cinfo.getName(), cinfo.getNumber());
        }
        IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInfo minfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getId()));
        if (exception_msg == null) {
            exception_msg = "";
        }
        return new CalculateException(calculateException, new String[]{CalculateUtil.takeFormateDesc(calModeName), orgName, CalculateUtil.takeFormateDesc(minfo.getName(), minfo.getNumber()), exception_msg});
    }

    public static CalculateException throwException(Context ctx, NumericExceptionSubItem calculateException, String calMode, CalculateWrittenOffEntry entry) throws EASBizException, BOSException {
        return RecentCostHelper.throwException(ctx, calculateException, calMode, entry, "");
    }

    private void setRecentCostHashMap(Context ctx, HashMap innerHm, CalculateWrittenOffEntry entry, BigDecimal qty, BigDecimal sum) throws EASBizException, BOSException {
        if (entry.getMaterial() != null && entry.getMaterial().getId() != null) {
            innerHm.put("FMaterialID", entry.getMaterial().getId().toString());
        }
        if (entry.getFinanceOrg() != null && entry.getFinanceOrg().getId() != null) {
            innerHm.put("FCompanyOrgUnitID", entry.getFinanceOrg().getId().toString());
        }
        if (entry.getStorageOrg() != null && entry.getStorageOrg().getId() != null) {
            innerHm.put("FStorageOrgUnitID", entry.getStorageOrg().getId().toString());
        }
        if (entry.getWarehouse() != null && entry.getWarehouse().getId() != null) {
            innerHm.put("FWarehouseID", entry.getWarehouse().getId().toString());
        }
        innerHm.put("FRecentQty", qty.setScale(entry.getPrecision().getBaseQtyPrecision(), 4));
        innerHm.put("FRecentCost", sum.setScale(entry.getPrecision().getLocalCurrencyPrecision(), 4));
        innerHm.put("FPrice", RecentCostHelper.getPrice(ctx, (BigDecimal)innerHm.get("FRecentCost"), (BigDecimal)innerHm.get("FRecentQty"), entry.getPrecision().getPricePrecision(), entry, false));
    }

    public static RecentCostInfo getMaterialRecentCost(Context ctx, String calMode, CalculateWrittenOffEntry entry, CalculateKindEnum calculateKindEnum) throws EASBizException, BOSException {
        RecentCostInfo recentCostInfo = null;
        NumericExceptionSubItem exceptionitem = CalculateException.MATERIAL_RECENT_COST_NOT_EXIST;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            recentCostInfo = RecentCostHelper.getMaterialRecentCost(ctx, null, entry.getBaseUnitQty(), calculateKindEnum, RecentCostHelper.getFilterByCalMode(calMode, entry), conn, false);
        }
        catch (SQLException ex) {
            throw RecentCostHelper.throwException(ctx, exceptionitem, calMode, entry);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("\u5373\u65f6\u51fa\u5e93\u6210\u672c\uff1a" + recentCostInfo.getRecentCost()));
        return recentCostInfo;
    }

    public static RecentCostInfo getMaterialRecentCost(Context ctx, BigDecimal Qty, BigDecimal BaseQty, CalculateKindEnum calculateKindEnum, String materialID, String companyOrgID, String storageOrgID, String warehouseID) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String calMode = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "SCM_CAL_002");
        RecentCostInfo recentCostInfo = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            recentCostInfo = RecentCostHelper.getMaterialRecentCost(ctx, Qty, BaseQty, calculateKindEnum, RecentCostHelper.getFilterByCalMode(calMode, materialID, companyOrgID, storageOrgID, warehouseID), conn, true);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("\u5373\u65f6\u51fa\u5e93\u6210\u672c\uff1a" + recentCostInfo.getRecentCost()));
        return recentCostInfo;
    }

    private static RecentCostInfo getMaterialRecentCost(Context ctx, BigDecimal Qty, BigDecimal BaseQty, CalculateKindEnum calculateKindEnum, String filterByCalMode, Connection conn, Boolean isNeedUnitActualCost) throws SQLException {
        RecentCostInfo recentCostInfo = new RecentCostInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FRecentCost,FRecentQty,FPrice");
        sql.append(" ,CURRENCY.FPrecision AS CURRENCYPRECISION");
        sql.append(" ,MATERIAL.FPricePrecision AS FPricePrecision");
        sql.append(" FROM T_CL_RecentCost ");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sql.append(" ON T_CL_RecentCost.FCompanyOrgUnitID = COMPANY.FID");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sql.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON T_CL_RecentCost.FMaterialID = MATERIAL.FId");
        sql.append(" WHERE T_CL_RecentCost.FID in (");
        sql.append(" SELECT FID ");
        sql.append(" FROM T_CL_RecentCost ");
        sql.append(" WHERE ");
        sql.append(filterByCalMode);
        sql.append(" )");
        JdbcRowSet rs = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
        if (rs != null && rs.next() && rs.getBigDecimal("FPrice") != null && rs.getBigDecimal("FRecentCost") != null && rs.getBigDecimal("FRecentQty") != null) {
            logger.debug((Object)("\u5e93\u5b58\u91cc\u7684\u5373\u65f6\u6570\u91cf\uff1a" + rs.getBigDecimal("FRecentQty")));
            logger.debug((Object)("\u5e93\u5b58\u91cc\u7684\u5373\u65f6\u5355\u4ef7\uff1a" + rs.getBigDecimal("FPrice")));
            logger.debug((Object)("\u5e93\u5b58\u91cc\u7684\u5373\u65f6\u6210\u672c\uff1a" + rs.getBigDecimal("FRecentCost")));
            if (rs.getBigDecimal("FRecentQty").add(BaseQty.multiply(calculateKindEnum.equals((Object)CalculateKindEnum.INPUT_WAREHOUSE) ? CalConstant.ONE : CalConstant.ONE_MINUS)).compareTo(CalConstant.ZERO) == 0) {
                logger.debug((Object)"\u5b8c\u5168\u51fa\u5e93\uff0c\u4ee5\u51fa\u5e93\u6210\u672c\u4e3a\u51c6\u3002");
                recentCostInfo.setRecentCost(rs.getBigDecimal("FRecentCost"));
                if (CalConstant.ZERO.compareTo(recentCostInfo.getRecentCost()) != 0) {
                    recentCostInfo.setPrice(rs.getBigDecimal("FPrice").setScale(rs.getInt("FPricePrecision"), 4));
                }
            } else {
                logger.debug((Object)"\u975e\u5b8c\u5168\u51fa\u5e93\uff0c\u4ee5\u51fa\u5e93\u5355\u4ef7\u4e3a\u51c6\u3002");
                logger.debug((Object)("\u5373\u65f6\u51fa\u5e93\u6210\u672c[," + rs.getInt("CURRENCYPRECISION") + "]=" + rs.getBigDecimal("FPrice") + "*" + BaseQty));
                recentCostInfo.setRecentCost(rs.getBigDecimal("FPrice").multiply(BaseQty).setScale(rs.getInt("CURRENCYPRECISION"), 4));
                if (CalConstant.ZERO.compareTo(recentCostInfo.getRecentCost()) != 0) {
                    recentCostInfo.setPrice(rs.getBigDecimal("FPrice").setScale(rs.getInt("FPricePrecision"), 4));
                } else {
                    StringBuffer msg = new StringBuffer();
                    msg.append(":");
                    msg.append("\n-------------\n");
                    msg.append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"179_RecentCostHelp", (Locale)ctx.getLocale()));
                    msg.append("\n");
                    msg.append(recentCostInfo.getRecentCost());
                    msg.append(" = ");
                    msg.append("[");
                    msg.append(BaseQty);
                    msg.append("*");
                    msg.append(rs.getBigDecimal("FPrice"));
                    msg.append(",");
                    msg.append(rs.getInt("CURRENCYPRECISION"));
                    msg.append("]");
                    msg.append("\n-------------\n");
                    recentCostInfo.setString("exception_msg", msg.toString());
                }
            }
            if (isNeedUnitActualCost.booleanValue()) {
                BigDecimal unitActualCost = recentCostInfo.getRecentCost().abs().divide(Qty, rs.getInt("FPricePrecision"), 4);
                recentCostInfo.setBigDecimal("FUnitActualCost", unitActualCost);
            }
        }
        return recentCostInfo;
    }

    public static StringBuffer insertRecentCostSQL(BigDecimal price, BigDecimal recentQty, BigDecimal recentCost, String materialID, String companyOrgUnitID, String storageOrgUnitID, String warehouseID) {
        StringBuffer returnStrSQL = new StringBuffer(128);
        returnStrSQL.append(" insert into t_cl_recentcost");
        returnStrSQL.append(" (Fid,FPrice,FRecentQty,FRecentCost");
        returnStrSQL.append(" ,FMaterialID,FCompanyOrgUnitID");
        returnStrSQL.append(" ,FStorageOrgUnitID");
        returnStrSQL.append(" ,FWarehouseID");
        returnStrSQL.append(" )values( ");
        returnStrSQL.append(" newbosid('").append(new RecentCostInfo().getBOSType()).append("')");
        returnStrSQL.append(" ,").append(StringUtil.bigDecimal2String((BigDecimal)price));
        returnStrSQL.append(" ,").append(StringUtil.bigDecimal2String((BigDecimal)recentQty));
        returnStrSQL.append(" ,").append(StringUtil.bigDecimal2String((BigDecimal)recentCost));
        returnStrSQL.append(" ,'").append(materialID).append("'");
        returnStrSQL.append(" ,'").append(companyOrgUnitID).append("'");
        if (storageOrgUnitID != null) {
            returnStrSQL.append(" ,'").append(storageOrgUnitID).append("'");
        } else {
            returnStrSQL.append(" ,null");
        }
        if (warehouseID != null) {
            returnStrSQL.append(" ,'").append(warehouseID).append("'");
        } else {
            returnStrSQL.append(" ,null");
        }
        returnStrSQL.append(" )");
        return returnStrSQL;
    }

    public static boolean isCostAdjustBill(RecentCostInfo info) {
        return info != null && info.getString("FEntryTableMame") != null && info.getString("FEntryTableMame").equalsIgnoreCase(costAdjustBillEntryName);
    }

    public static String getInsertPrepareRecentCostSQL() {
        StringBuffer returnStrSQL = new StringBuffer();
        returnStrSQL.append(" insert into t_cl_recentcost");
        returnStrSQL.append(" (Fid,FPrice,FRecentQty,FRecentCost");
        returnStrSQL.append(" ,FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID)");
        returnStrSQL.append(" values (?,?,?,?");
        returnStrSQL.append(" ,?,?,?,?)");
        return returnStrSQL.toString();
    }

    public static void calculateBalance(RecentCostInfo balanceBill, RecentCostInfo billInfo, String strCalType, boolean isIn) {
        if (RecentCostHelper.isEffectBalance(billInfo, strCalType)) {
            if (isIn) {
                if (1 == billInfo.getInt("FCalculateKind")) {
                    if (!billInfo.isCostAdjustBill()) {
                        balanceBill.setRecentQty(balanceBill.getRecentQty().add(billInfo.getRecentQty().negate()));
                    }
                    balanceBill.setRecentCost(balanceBill.getRecentCost().add(billInfo.getRecentCost().negate()));
                } else {
                    if (!billInfo.isCostAdjustBill()) {
                        balanceBill.setRecentQty(balanceBill.getRecentQty().add(billInfo.getRecentQty()));
                    }
                    balanceBill.setRecentCost(balanceBill.getRecentCost().add(billInfo.getRecentCost()));
                }
            } else {
                if (!billInfo.isCostAdjustBill()) {
                    balanceBill.setRecentQty(balanceBill.getRecentQty().subtract(billInfo.getRecentQty()));
                }
                balanceBill.setRecentCost(balanceBill.getRecentCost().subtract(billInfo.getRecentCost()));
            }
            RecentCostHelper.calculateAvgPrice(balanceBill);
        }
    }

    public static void calculateAvgPrice(RecentCostInfo billInfo) {
        RecentCostHelper.calculateAvgPrice(billInfo, billInfo.getInt("FPricePrecision"));
    }

    public static void calculateAvgPrice(RecentCostInfo billInfo, int presion) {
        if (CalConstant.ZERO.compareTo(billInfo.getRecentQty()) == 0) {
            billInfo.setPrice(CalConstant.ZERO);
        } else {
            billInfo.setPrice(billInfo.getRecentCost().divide(billInfo.getRecentQty(), presion, 4));
        }
    }

    public static boolean isEffectBalance(RecentCostInfo billInfo, String strCalType) {
        if (billInfo.isCostPriceMove()) {
            if ("0".equals(strCalType)) {
                return false;
            }
            if ("1".equals(strCalType)) {
                return billInfo.isMoveInCostPriceStorage();
            }
            return true;
        }
        return !billInfo.isCommissionSaleOut();
    }

    public static boolean isPrePeriodBill(RecentCostInfo billInfo, PeriodInfo periodInfo) {
        if (billInfo != null && periodInfo != null && billInfo.getString("FEntryTableMame") != null && !billInfo.getString("FEntryTableMame").equalsIgnoreCase(T_IM_INVENTORYBALANCE) && !billInfo.getString("FEntryTableMame").equalsIgnoreCase(T_CL_INVENTORYBALANCE)) {
            return periodInfo.getBeginDate().compareTo(billInfo.getDate("FBizDate")) > 0;
        }
        return false;
    }
}

