/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.svr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.InpWarehsSumCalculateFactory;
import com.kingdee.eas.scm.cal.InpWarehsSumCalculateInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class InpWarehsSumCalDataTransmission
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.svr.InpWarehsSumCalDataTransmission");
    private static final int WAREHOUSE = 0;
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InpWarehsSumCalculateFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InpWarehsSumCalculateInfo info = new InpWarehsSumCalculateInfo();
        try {
            this.createEntry(info, hsData, ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return info;
    }

    private String updateTemp(Context ctx, InpWarehsSumCalculateInfo entry, String tableTempName) {
        StringBuffer sqlSpecal = new StringBuffer();
        if (5 == entry.getAccountType()) {
            if (entry.getLot() == null || entry.getLot().trim().length() == 0) {
                sqlSpecal.append(" AND FLot IS NULL ");
            } else {
                sqlSpecal.append(" AND FLot = '").append(entry.getLot()).append("' ");
            }
            if (entry.getAssistProperty() == null || entry.getAssistProperty().trim().length() == 0) {
                sqlSpecal.append(" AND FAssistPropertyID IS NULL ");
            } else {
                sqlSpecal.append(" AND FAssistPropertyID = '").append(entry.getAssistProperty()).append("' ");
            }
            if (entry.getProject() == null || entry.getProject().trim().length() == 0) {
                sqlSpecal.append(" AND FProjectID IS NULL ");
            } else {
                sqlSpecal.append(" AND FProjectID = '").append(entry.getProject()).append("' ");
            }
            if (entry.getTrackNumber() == null || entry.getTrackNumber().trim().length() == 0) {
                sqlSpecal.append(" AND FTrackNumberID IS NULL ");
            } else {
                sqlSpecal.append(" AND FTrackNumberID = '").append(entry.getTrackNumber()).append("' ");
            }
        } else {
            sqlSpecal.append(" AND 1=1 ");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tableTempName);
        sql.append(" set FActualBaseUnitCost = ");
        if (CalculateUtil.ZERO.compareTo(entry.getActualCost()) == 0) {
            sql.append(entry.getActualBaseUnitCost());
        } else {
            sql.append(" Case When FBaseQty = 0 Then");
            sql.append(" 0");
            sql.append(" else");
            sql.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE(entry.getActualCost() + "/FBaseQty")).append(",FPricePrecision)");
            sql.append(" End");
        }
        sql.append(", FActualCost = ");
        if (CalculateUtil.ZERO.compareTo(entry.getActualCost()) == 0) {
            sql.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_AMT(entry.getActualBaseUnitCost() + "* FBaseQty")).append(",FLocalCurrencyPrecision)");
        } else {
            sql.append(entry.getActualCost());
        }
        sql.append(" WHERE FMaterialID ='").append(entry.getMaterialID()).append("'");
        sql.append(sqlSpecal);
        if (1 == Integer.parseInt(this.getContextParameter("SUMCONDITION").toString())) {
            sql.append("   AND FStorageOrgUnitID = '").append(entry.getStorageOrgUnitID()).append("'");
        }
        if (2 == Integer.parseInt(this.getContextParameter("SUMCONDITION").toString())) {
            sql.append("   AND FWarehouseID = '").append(entry.getWarehouseID()).append("'");
        }
        if (5 == entry.getAccountType()) {
            sql.append(" AND FAccountType = ").append(5);
        }
        return sql.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createEntry(InpWarehsSumCalculateInfo entryinfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        String[] DECIMAL_ENTRY_FIELDS = new String[]{"ActualBaseUnitCost", "ActualCost"};
        String[] DECIMAL_ENTRY_PROPERTY = new String[]{"price", "amount"};
        for (int i = 0; i < DECIMAL_ENTRY_PROPERTY.length; ++i) {
            try {
                Object o = ((DataToken)hsData.get((Object)DECIMAL_ENTRY_PROPERTY[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    BigDecimal value = new BigDecimal(o.toString());
                    if (value == null) continue;
                    entryinfo.setBigDecimal(DECIMAL_ENTRY_FIELDS[i], value);
                    continue;
                }
                entryinfo.setBigDecimal(DECIMAL_ENTRY_FIELDS[i], CalculateUtil.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex);
                throw new TaskExternalException(DECIMAL_ENTRY_PROPERTY[i] + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"NUMBER_FORMATE_ERROR", (Context)ctx));
            }
        }
        try {
            ProjectCollection coll;
            ObjectUuidPK cuPK;
            CtrlUnitInfo cu;
            FilterInfo filter2;
            HashSet<Integer> status;
            EntityViewInfo viewInfo;
            FilterInfo filter;
            String number = null;
            CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            Object data = ((DataToken)hsData.get((Object)"storageOrgUnit.number")).data;
            if (data != null) {
                number = data.toString();
                if (number == null || number.length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ORG_NOT_EXIST", (Context)ctx));
                IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = isou.getStorageOrgUnitCollection(this.getFilter(number));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(number + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ORG_NOT_EXIST", (Context)ctx));
                sou = collection.get(0);
                if (sou == null) throw new TaskExternalException(number + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ORG_NOT_EXIST", (Context)ctx));
                if (!sou.isIsBizUnit()) {
                    throw new TaskExternalException(number + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"ORG_VOID", (Context)ctx));
                }
                entryinfo.setStorageOrgUnitID(sou.getId().toString());
            }
            if (sou != null && sou.getId() != null) {
                OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(sou.getId().toString(), 4, 1);
                if (orgCol.get(0) == null || ((CompanyOrgUnitInfo)orgCol.get(0)).getId() == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"StorageOrgNotHasCompanyOrg", (Context)ctx));
                cou = (CompanyOrgUnitInfo)orgCol.get(0);
                entryinfo.setCompanyOrgUnitID(((CompanyOrgUnitInfo)orgCol.get(0)).getId().toString());
            }
            WarehouseInfo warehouseInfo = new WarehouseInfo();
            data = ((DataToken)hsData.get((Object)"warehouse.number")).data;
            if (data != null && data.toString() != null && data.toString().length() > 0 && (number = data.toString()) != null) {
                IWarehouse iw = WarehouseFactory.getLocalInstance((Context)ctx);
                WarehouseCollection collection = iw.getWarehouseCollection(this.getFilter(number));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WarehouseNotExists", (Context)ctx));
                WarehouseInfo info = collection.get(0);
                if (info == null) throw new TaskExternalException(data.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WarehouseNotExists", (Context)ctx));
                if (!info.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                    throw new TaskExternalException(info.getNumber() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WarehouseNotActive", (Context)ctx));
                }
                entryinfo.setWarehouseID(info.getId().toString());
                warehouseInfo = info;
            }
            MaterialCompanyInfoInfo materialCompanyInfo = null;
            MaterialCompanyInfoCollection mcompanyCol = null;
            MaterialInventoryInfo materialInventoryInfo = null;
            data = ((DataToken)hsData.get((Object)"material.number")).data;
            if (data != null) {
                number = data.toString();
                if (number == null || number.trim().length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"MATERIAL_NOT_EXIST", (Context)ctx));
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                MaterialCollection collection = imaterial.getMaterialCollection(this.getFilter(number));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(number + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"MATERIAL_NOT_EXIST", (Context)ctx));
                materialInfo = collection.get(0);
                if (materialInfo == null) throw new TaskExternalException(number + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"MATERIAL_NOT_EXIST", (Context)ctx));
                entryinfo.setMaterialID(materialInfo.getId().toString());
                entryinfo.setPricePrecision(materialInfo.getPricePrecision());
                EntityViewInfo viewInfo2 = new EntityViewInfo();
                filter = new FilterInfo();
                SelectorItemCollection sc = SCMSelectorFactory.getMaterialCompanyInfoSelector();
                filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)cou.getId().toString(), CompareType.EQUALS));
                viewInfo2.setFilter(filter);
                viewInfo2.setSelector(sc);
                mcompanyCol = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo2);
                if (mcompanyCol != null && mcompanyCol.size() > 0) {
                    materialCompanyInfo = mcompanyCol.get(0);
                }
                if (materialCompanyInfo == null || materialCompanyInfo != null && materialCompanyInfo.getAccountType() == null) {
                    throw new TaskExternalException(materialInfo.getNumber() + " has not accountType!");
                }
                entryinfo.setAccountType(materialCompanyInfo.getAccountType().getValue());
            }
            if (materialCompanyInfo == null || materialCompanyInfo.getAccountType() == null || 5 != materialCompanyInfo.getAccountType().getValue()) return;
            if (materialInfo != null && materialInfo.getId() != null && sou != null && sou.getId() != null && (materialCompanyInfo.isIsProject() || materialCompanyInfo.isIsTrackNumber())) {
                materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
            }
            if (materialCompanyInfo.isIsLot()) {
                data = ((DataToken)hsData.get((Object)"lot")).data;
                if (data == null || data.toString() == null || data.toString().trim().length() == 0) {
                    entryinfo.setLot(null);
                } else {
                    entryinfo.setLot(data.toString().trim());
                }
            }
            if (materialCompanyInfo.isIsAssistProperty() && (data = ((DataToken)hsData.get((Object)"assistProperty.number")).data) != null && (number = data.toString()) != null && number.trim().length() > 0 && materialInfo != null && materialInfo.getAssistAttr() != null) {
                AsstAttrValueInfo info;
                IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                String oql = "";
                oql = number.indexOf("/") > 0 ? "select id,number,name where (number='" + number + "' or name ='" + number + "') and compondingType.id = '" + materialInfo.getAssistAttr().getId().toString() + "'" : "select id,number,name where (number='" + number + "' or name ='" + number + "') and basictype.id = '" + materialInfo.getAssistAttr().getId().toString() + "'";
                AsstAttrValueCollection collection = iasstAttrValue.getAsstAttrValueCollection(oql);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    entryinfo.setAssistProperty(info.getId().toString());
                }
            }
            if (materialCompanyInfo.isIsProject() && materialInventoryInfo != null && materialInventoryInfo.isIsProjectNumber()) {
                try {
                    data = ((DataToken)hsData.get((Object)"projectNumber.number")).data;
                    if (data != null && (number = data.toString()) != null && number.trim().length() > 0) {
                        IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                        viewInfo = new EntityViewInfo();
                        status = new HashSet<Integer>();
                        status.add(new Integer(4));
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                        filter2 = new FilterInfo();
                        cu = sou.getCU();
                        cuPK = null;
                        cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                        filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                        if (filter2 != null) {
                            filter.mergeFilter(filter2, "and");
                        }
                        viewInfo.setFilter(filter);
                        coll = iProject.getProjectCollection(viewInfo);
                        if (coll != null && coll.size() > 0) {
                            ProjectInfo projectInfo = coll.get(0);
                            entryinfo.setProject(projectInfo.getId().toString());
                        }
                    }
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            if (!materialCompanyInfo.isIsTrackNumber() || materialInventoryInfo == null || !materialInventoryInfo.isIsTrackingNumber()) return;
            try {
                data = ((DataToken)hsData.get((Object)"trackNumber.number")).data;
                if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) return;
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                status = new HashSet();
                status.add(new Integer(10));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                filter2 = new FilterInfo();
                cu = sou.getCU();
                cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll == null || coll.size() <= 0) return;
                TrackNumberInfo trackNumberInfo = coll.get(0);
                entryinfo.setTrackNumber(trackNumberInfo.getId().toString());
                return;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            int i = this.executeUpdate(ctx, this.updateTemp(ctx, (InpWarehsSumCalculateInfo)coreBaseInfo, (String)this.getContextParameter("TEMPTABLE")));
            if (i <= 0) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DATA_UPDATE", (Context)ctx));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public int executeUpdate(Context ctx, String sql) throws BOSException {
        int n;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            n = statement.executeUpdate(sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return n;
    }
}

