/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.config;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.verifyStatusEnum;
import com.kingdee.eas.fi.arap.config.OtherBillCommonHandler;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class ArOtherBillWriteOffHandler
extends OtherBillCommonHandler {
    public String[][] getDisplayFields() {
        return new String[][]{{"false", "selected", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"selected")}, {"false", "number", null}, {"false", "billDate", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"bizDate")}, {"false", "company.name", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"companyOrgUnitName")}, {"false", "asstActType.name", null}, {"false", "asstActName", null}, {"false", "material.number", null}, {"false", "material.name", null}, {"false", "material.shortName", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"shortName")}, {"true", "entry.quantity", null}, {"false", "baseUnit.name", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"baseUnit")}, {"true", "entry.baseQty", null}, {"true", "entry.recievePayAmountLocal", null}, {"true", "entry.amountLocal", null}, {"true", "entry.unwriteOffBaseQty", null}, {"true", "entry.localUnwriteOffAmount", null}, {"true", "thisWriteOffBaseQty", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"curWriteOffBaseQty")}, {"true", "thisWriteOffAmount", EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"curWriteOffAmount")}, {"false", "coreBillType.name", null}, {"false", "entry.coreBillNumber", null}, {"false", "entry.coreBillEntrySeq", null}};
    }

    public String[] getHiddenFields() {
        return new String[]{"currency.precision", "baseCurrency.precision", "id", "entry.id", "lastUpdateTime", "multiUnit.qtyPrecision", "entry.unwriteOffBaseQty", "entry.localUnwriteOffAmount"};
    }

    public String[] getModifyFields() {
        return new String[]{"selected", "thisWriteOffBaseQty"};
    }

    public String[] getSumFields() {
        return new String[]{"thisWriteOffBaseQty", "thisWriteOffAmount"};
    }

    public void handleTableEditStopped(KDTEditEvent e) throws Exception {
        KDTable tbl = (KDTable)e.getSource();
        if ("thisWriteOffBaseQty".equalsIgnoreCase(tbl.getColumnKey(e.getColIndex()))) {
            int selectRow = e.getRowIndex();
            int selectCol = e.getColIndex();
            int colCurWriteOffBaseQty = tbl.getColumnIndex("thisWriteOffBaseQty");
            int colUnWriteOffBaseQty = tbl.getColumnIndex("entry.unwriteOffBaseQty");
            int colCurWriteOffAmount = tbl.getColumnIndex("thisWriteOffAmount");
            int colUnWriteOffAmount = tbl.getColumnIndex("entry.localUnwriteOffAmount");
            if (selectCol == colCurWriteOffBaseQty) {
                IRow curRow = tbl.getRow(selectRow);
                BigDecimal unWriteOffBaseQty = (BigDecimal)curRow.getCell(colUnWriteOffBaseQty).getValue();
                BigDecimal curWriteOffBaseQty = curRow.getCell(colCurWriteOffBaseQty).getValue() == null ? SysConstant.BIGZERO : (BigDecimal)curRow.getCell(colCurWriteOffBaseQty).getValue();
                BigDecimal unWriteOffAmount = (BigDecimal)curRow.getCell(colUnWriteOffAmount).getValue();
                if (unWriteOffBaseQty.signum() != curWriteOffBaseQty.signum()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"orientationAlert"));
                    curRow.getCell(colCurWriteOffBaseQty).setValue((Object)unWriteOffBaseQty);
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)unWriteOffAmount);
                } else if (unWriteOffBaseQty.abs().compareTo(curWriteOffBaseQty.abs()) < 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"writeOffBaseQtyAlert"));
                    curRow.getCell(colCurWriteOffBaseQty).setValue((Object)unWriteOffBaseQty);
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)unWriteOffAmount);
                } else if (unWriteOffBaseQty.abs().compareTo(curWriteOffBaseQty.abs()) > 0) {
                    BigDecimal writeOffAmount = unWriteOffAmount.divide(unWriteOffBaseQty, 10, 4).multiply(curWriteOffBaseQty).setScale((int)Integer.valueOf(curRow.getCell("baseCurrency.precision").getValue().toString()), 4);
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)writeOffAmount);
                }
                if (unWriteOffBaseQty.compareTo(curWriteOffBaseQty) == 0) {
                    curRow.getCell(colCurWriteOffAmount).setValue((Object)unWriteOffAmount);
                }
            }
        }
    }

    public void handleTableRowData(IRow row, Object[] rowData, boolean isHeadView) {
        int i;
        row.getCell("selected").setValue((Object)Boolean.FALSE);
        if (row.getCell("billType").getValue() != null) {
            row.getCell("billType").setValue((Object)OtherBillTypeEnum.getEnum((int)Integer.valueOf(row.getCell("billType").getValue().toString())));
        }
        if (row.getCell("billStatus").getValue() != null) {
            row.getCell("billStatus").setValue((Object)BillStatusEnum.getEnum((int)Integer.valueOf(row.getCell("billStatus").getValue().toString())));
        }
        if (row.getCell("sourceBillType").getValue() != null) {
            row.getCell("sourceBillType").setValue((Object)VerificateBillTypeEnum.getEnum((int)Integer.valueOf(row.getCell("sourceBillType").getValue().toString())));
        }
        if (row.getCell("entry.discountType").getValue() != null) {
            row.getCell("entry.discountType").setValue((Object)DiscountModeEnum.getEnum((int)Integer.valueOf(row.getCell("entry.discountType").getValue().toString())));
        }
        if (row.getCell("verifyStatus").getValue() != null) {
            row.getCell("verifyStatus").setValue((Object)verifyStatusEnum.getEnum((int)Integer.valueOf(row.getCell("verifyStatus").getValue().toString())));
        }
        int baseQtyPrecision = 2;
        if (row.getCell("multiUnit.qtyPrecision").getValue() != null) {
            baseQtyPrecision = Integer.valueOf(row.getCell("multiUnit.qtyPrecision").getValue().toString());
        }
        KDFormattedTextField text = new KDFormattedTextField();
        text.setDataType(1);
        text.setPrecision(baseQtyPrecision);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)text);
        row.getCell("thisWriteOffBaseQty").setEditor((ICellEditor)editor);
        row.getCell("thisWriteOffBaseQty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        row.getCell("thisWriteOffBaseQty").setValue(row.getCell("entry.unwriteOffBaseQty").getValue());
        row.getCell("thisWriteOffAmount").setValue(row.getCell("entry.localUnwriteOffAmount").getValue());
        String[] fields = this.getAmountFields();
        String formatString = PrecisionFormatUtils.getFormatString((int)Integer.valueOf(row.getCell("currency.precision").getValue().toString()));
        int len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
        fields = this.getLocalAmountFields();
        formatString = PrecisionFormatUtils.getFormatString((int)Integer.valueOf(row.getCell("baseCurrency.precision").getValue().toString()));
        len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
        row.getCell("entry.quantity").setEditor((ICellEditor)editor);
        row.getCell("entry.quantity").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        row.getCell("entry.baseQty").setEditor((ICellEditor)editor);
        row.getCell("entry.baseQty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
        row.getCell("entry.unwriteOffBaseQty").setEditor((ICellEditor)editor);
        row.getCell("entry.unwriteOffBaseQty").getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString((int)baseQtyPrecision));
    }

    public String[] getUserDefineFields() {
        return new String[]{"selected", "thisWriteOffBaseQty", "thisWriteOffAmount"};
    }

    public String getBOSType() {
        return "FC910EF3";
    }

    public String getEditUIClassName() {
        return "com.kingdee.eas.fi.ar.client.OtherBillEditUI";
    }

    public CustomerQueryPanel getQueryUI(String companyId, Map uiContext) throws Exception {
        uiContext.put("isVerifi", Boolean.TRUE);
        uiContext.put("companyId", companyId);
        IUIWindow qryUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.ar.client.OtherBillQueryUI", uiContext, null, OprtState.VIEW);
        CustomerQueryPanel queryUI = (CustomerQueryPanel)qryUI.getUIObject();
        queryUI.setSize(508, 435);
        return queryUI;
    }

    public String[] getLocalAmountFields() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getLocalAmountFields()));
        list.add("thisWriteOffAmount");
        return list.toArray(new String[list.size()]);
    }

    public List getWriteOffList(KDTable table) {
        ArrayList<WriteOffCommonInfo> list = new ArrayList<WriteOffCommonInfo>();
        WriteOffCommonInfo info = null;
        int rowCount = table.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            if (!Boolean.TRUE.equals(table.getCell(i, "selected").getValue())) continue;
            info = new WriteOffCommonInfo();
            info.setBaseQty((BigDecimal)table.getCell(i, "thisWriteOffBaseQty").getValue());
            info.setLocalAmount((BigDecimal)table.getCell(i, "thisWriteOffAmount").getValue());
            info.setBillId((String)table.getCell(i, "id").getValue());
            info.setEntryId((String)table.getCell(i, "entry.id").getValue());
            info.setLastUpdateTime((Date)table.getCell(i, "lastUpdateTime").getValue());
            info.setBillNumber((String)table.getCell(i, "number").getValue());
            list.add(info);
        }
        return list;
    }
}

