/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.invdep.DepChargeEntryCollection;
import com.kingdee.eas.scm.cal.invdep.DepChargeEntryInfo;
import com.kingdee.eas.scm.cal.invdep.DepChargeException;
import com.kingdee.eas.scm.cal.invdep.DepChargeFactory;
import com.kingdee.eas.scm.cal.invdep.DepChargeInfo;
import com.kingdee.eas.scm.cal.invdep.IDepCharge;
import com.kingdee.eas.scm.cal.invdep.app.AbstractDepChargeControllerBean;
import com.kingdee.eas.scm.cal.invdep.app.DepChargeServerHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DepChargeControllerBean
extends AbstractDepChargeControllerBean {
    private static final long serialVersionUID = -2494674173292317913L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.invdep.app.DepChargeControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DepChargeInfo info = (DepChargeInfo)model;
        if (info == null || info.getEntrys() == null || info.getEntrys().size() < 1) {
            throw new SCMBillException(SCMBillException.ENTRIESNOTNULL);
        }
        if (info.getBillType() == null) {
            String DEPCHARGE_BILLTYPEID = "BNBrqgEeEADgAAAKfwAAAb1GBGM=";
            BillTypeInfo typeInfo = new BillTypeInfo();
            typeInfo.setId(BOSUuid.read((String)DEPCHARGE_BILLTYPEID));
            info.setBillType(typeInfo);
        }
        IObjectPK pk = super._save(ctx, model);
        this.checkDepcharged(ctx, info, pk.toString());
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DepChargeInfo info = (DepChargeInfo)model;
        if (info.getEntrys() == null || info.getEntrys().size() == 0) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"202_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getBaseStatus() != null && info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"203_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getEntrys() != null && info.getEntrys().size() > 0) {
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                DepChargeEntryInfo entry = info.getEntrys().get(i);
                if (entry.getDepToCharge() == null) {
                    entry.setDepToCharge(SysConstant.BIGZERO);
                }
                if (entry.getCurDepCharge() == null) {
                    entry.setCurDepCharge(SysConstant.BIGZERO);
                }
                if (SysConstant.BIGZERO.compareTo(entry.getDepToCharge()) != 0 || SysConstant.BIGZERO.compareTo(entry.getCurDepCharge()) != 0) continue;
                info.getEntrys().removeObject(i);
                --i;
            }
        }
        if (info.getEntrys().size() == 0) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"204_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        this.checkDepreversed(ctx, info);
        if (info.getBillType() == null) {
            String DEPCHARGE_BILLTYPEID = "BNBrqgEeEADgAAAKfwAAAb1GBGM=";
            BillTypeInfo typeInfo = new BillTypeInfo();
            typeInfo.setId(BOSUuid.read((String)DEPCHARGE_BILLTYPEID));
            info.setBillType(typeInfo);
        }
        IObjectPK pk = super._submit(ctx, model);
        this.checkDepcharged(ctx, info, pk.toString());
        String orgUnitID = info.getCompany().getId().toString();
        if (this.isAuditAfterSubmit(ctx, info, orgUnitID, 1)) {
            this.auditAndLog(ctx, pk, info.getBOSType(), info.getNumber(), "scm_depCharge_audit");
        }
        return pk;
    }

    private void checkDepcharged(Context ctx, DepChargeInfo info, String id) throws BOSException, EASBizException {
        DepChargeEntryCollection entrys = info.getEntrys();
        ArrayList<BOSUuid> materialIds = new ArrayList<BOSUuid>();
        int idSize = entrys.size();
        for (int idIndex = 0; idIndex < idSize; ++idIndex) {
            if (entrys.get(idIndex).getMaterial() == null) continue;
            materialIds.add(entrys.get(idIndex).getMaterial().getId());
        }
        if (materialIds.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo currentCompany = info.getCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct material.fnumber from t_su_depchargeentry entry ").append("\r\n");
        sb.append(" right outer join t_su_depcharge bill on bill.fid = entry.fparentid ").append("\r\n");
        sb.append(" left outer join t_bd_material material on material.fid = entry.fmaterialid ").append("\r\n");
        sb.append(" where bill.fperiod = ").append(currentPeriod.getPeriodNumber()).append("\r\n");
        sb.append(" and bill.fyear = ").append(currentPeriod.getPeriodYear()).append("\r\n");
        sb.append(" and (bill.fbasestatus = ").append(4).append("\r\n");
        sb.append(" or bill.fbasestatus = ").append(2).append("\r\n");
        sb.append(" or bill.fbasestatus = ").append(1).append(")\r\n");
        sb.append(" and bill.fid != '").append(id).append("'\r\n");
        if (materialIds.size() > 0) {
            sb.append("and entry.fmaterialid in ( ").append(DepChargeServerHelper.ids2SqlString(materialIds)).append(") \r\n");
        }
        sb.append(" and fcompanyid= '").append(currentCompany.getId().toString()).append("'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs.size() > 0) {
            StringBuffer msg = new StringBuffer(100);
            msg.append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"205_DepChargeControllerBean", (Locale)ctx.getLocale()));
            try {
                while (rs.next()) {
                    msg.append("\n").append(rs.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            msg.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"206_DepChargeControllerBean", (Locale)ctx.getLocale()));
            throw new DepChargeException(DepChargeException.BLANK, new String[]{msg.toString()});
        }
    }

    private void checkDepreversed(Context ctx, DepChargeInfo info) throws BOSException, EASBizException {
        DepChargeEntryCollection entrys = info.getEntrys();
        ArrayList<BOSUuid> materialIds = new ArrayList<BOSUuid>();
        int idSize = entrys.size();
        for (int idIndex = 0; idIndex < idSize; ++idIndex) {
            if (entrys.get(idIndex).getMaterial() == null) continue;
            materialIds.add(entrys.get(idIndex).getMaterial().getId());
        }
        CompanyOrgUnitInfo currentCompany = info.getCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct material.fnumber from T_SU_DepReverseEntry entry  ").append("\r\n");
        sb.append(" right outer join T_SU_DepReverse bill on bill.fid = entry.fparentid ").append("\r\n");
        sb.append(" left outer join t_bd_material material on material.fid = entry.fmaterialid ");
        sb.append(" where bill.fperiod = ").append(currentPeriod.getPeriodNumber()).append("\r\n");
        sb.append(" and bill.fyear = ").append(currentPeriod.getPeriodYear()).append("\r\n");
        sb.append(" and bill.fbasestatus = ").append(4).append("\r\n");
        if (materialIds.size() > 0) {
            sb.append("and entry.fmaterialid in ( ").append(DepChargeServerHelper.ids2SqlString(materialIds)).append(") \r\n");
        }
        sb.append(" and fcompanyid= '").append(currentCompany.getId().toString()).append("'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs.size() > 0) {
            StringBuffer msg = new StringBuffer(100);
            msg.append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"207_DepChargeControllerBean", (Locale)ctx.getLocale()));
            try {
                while (rs.next()) {
                    msg.append("\n").append(rs.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            msg.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"208_DepChargeControllerBean", (Locale)ctx.getLocale()));
            throw new DepChargeException(DepChargeException.BLANK, new String[]{msg.toString()});
        }
    }

    @Override
    protected BigDecimal[] _getCurLastUnNetRealizable(Context ctx, HashMap materialPriceMap) throws BOSException, EASBizException {
        if (materialPriceMap == null || materialPriceMap.get("materialInfos") == null || materialPriceMap.get("priceArray") == null) {
            return null;
        }
        MaterialInfo[] materialInfos = (MaterialInfo[])materialPriceMap.get("materialInfos");
        BigDecimal[] priceArray = (BigDecimal[])materialPriceMap.get("priceArray");
        Object obj = materialPriceMap.get("currentCompany");
        CompanyOrgUnitInfo currentCompany = obj instanceof CompanyOrgUnitInfo ? (CompanyOrgUnitInfo)obj : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BigDecimal[] unNetRealizable = new BigDecimal[materialInfos.length];
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        int size = materialInfos.length;
        for (int i = 0; i < size; ++i) {
            BigDecimal preInvPrice = SysConstant.BIGZERO;
            StringBuffer selectSQL = new StringBuffer();
            selectSQL.append(" select top 1 FUnNetRealizable from t_su_depchargeentry entry ");
            selectSQL.append(" right outer join t_su_depcharge bill on bill.fid = entry.fparentid ");
            selectSQL.append(" where fmaterialid = '").append(materialInfos[i].getId().toString()).append("' \r\n");
            selectSQL.append(" and bill.fperiod =  ").append(new Integer(currentPeriod.getPeriodNumber())).append(" \r\n");
            selectSQL.append(" and bill.fyear =  ").append(new Integer(currentPeriod.getPeriodYear())).append(" \r\n");
            selectSQL.append(" and bill.fbasestatus = ").append(4).append("\r\n");
            selectSQL.append(" and bill.fcompanyid = '").append(currentCompany.getId().toString()).append("' \r\n");
            selectSQL.append(" order by bill.fcreatetime desc ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
            try {
                while (rowSet.next()) {
                    preInvPrice = rowSet.getBigDecimal("FUnNetRealizable");
                    if (priceArray[i] != null && SysConstant.BIGZERO.compareTo(priceArray[i]) != 0 && priceArray[i].compareTo(preInvPrice) >= 0) {
                        unNetRealizable[i] = preInvPrice;
                        continue;
                    }
                    unNetRealizable[i] = null;
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return unNetRealizable;
    }

    @Override
    protected BigDecimal[] _getLastDepCharged(Context ctx, HashMap materialMap) throws BOSException, EASBizException {
        if (materialMap == null || materialMap.get("materialInfos") == null) {
            return null;
        }
        MaterialInfo[] materialInfos = (MaterialInfo[])materialMap.get("materialInfos");
        Object obj = materialMap.get("currentCompany");
        CompanyOrgUnitInfo currentCompany = obj instanceof CompanyOrgUnitInfo ? (CompanyOrgUnitInfo)obj : ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BigDecimal[] depCharged = new BigDecimal[materialInfos.length];
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        PeriodInfo lastPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        int size = materialInfos.length;
        for (int i = 0; i < size; ++i) {
            BigDecimal preDepCharged = SysConstant.BIGZERO;
            StringBuffer selectSQL = new StringBuffer();
            selectSQL.append(" select top 1 FDepToCharge - FAmtReverse FDepCharged from t_su_depchargeentry entry  ").append(" \r\n");
            selectSQL.append(" right outer join t_su_depcharge bill on bill.fid = entry.fparentid ").append(" \r\n");
            selectSQL.append(" where fmaterialid = '").append(materialInfos[i].getId().toString()).append("' \r\n");
            selectSQL.append(" and bill.fperiod <=  ").append(new Integer(lastPeriod.getPeriodNumber())).append(" \r\n");
            selectSQL.append(" and bill.fyear =  ").append(new Integer(lastPeriod.getPeriodYear())).append(" \r\n");
            selectSQL.append(" and bill.fbasestatus = ").append(4).append("\r\n");
            selectSQL.append(" and bill.fcompanyid = '").append(currentCompany.getId().toString()).append("' \r\n");
            selectSQL.append(" order by bill.fcreatetime desc ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
            try {
                depCharged[i] = SysConstant.BIGZERO;
                while (rowSet.next()) {
                    preDepCharged = rowSet.getBigDecimal("FDepCharged");
                    if (SysConstant.BIGZERO.compareTo(preDepCharged) == 0) continue;
                    depCharged[i] = preDepCharged;
                }
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return depCharged;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._passAudit(ctx, pk, null);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        DepChargeInfo info = (DepChargeInfo)model;
        if (info == null) {
            IDepCharge iDepCharge = DepChargeFactory.getLocalInstance(ctx);
            info = iDepCharge.getDepChargeInfo(pk);
        }
        this.checkDepreversed(ctx, info);
        if (info.getBaseStatus() != null && info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"209_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        this.isSamePerson4Audit(ctx, info);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp currTime = new Timestamp(System.currentTimeMillis());
        Integer status = new Integer(4);
        String sql = "UPDATE T_SU_DepCharge SET FAuditorID = ?, FAuditTime = ?, FBaseStatus = ? WHERE FID = ?";
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"210_DepChargeControllerBean", (Locale)ctx.getLocale()) + pk.toString()));
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), currTime, status, pk.toString()});
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        super._passAudit(ctx, pk, (IObjectValue)info);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        DepChargeInfo depInfo = this.getDepChargeInfo(ctx, pk);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)depInfo.getCompany());
        if (depInfo.getBaseStatus() == null || depInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"211_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        this.checkAssociated(ctx, depInfo);
        if (depInfo.isFivouchered()) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"212_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        if (currentPeriod.getBeginDate().after(depInfo.getBizDate())) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"213_DepChargeControllerBean", (Locale)ctx.getLocale())});
        }
        this.update(ctx, pk, depInfo);
        this._unAudit(ctx, pks);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("auditor.*"));
            DepChargeInfo depInfo = this.getDepChargeInfo(ctx, pks[j], sic);
            if (depInfo.getBillType() == null) {
                String DEPCHARGE_BILLTYPEID = "BNBrqgEeEADgAAAKfwAAAb1GBGM=";
                BillTypeInfo typeInfo = new BillTypeInfo();
                typeInfo.setId(BOSUuid.read((String)DEPCHARGE_BILLTYPEID));
                depInfo.setBillType(typeInfo);
            }
            SCMServerUtils.checkParamCanUnAudit((Context)ctx, (SCMBillBaseInfo)depInfo);
            SCMServerUtils.checkBaseStatus((SCMBillBaseInfo)depInfo);
            SCMServerUtils.checkDownriver((Context)ctx, (SCMBillBaseInfo)depInfo);
            this.isSamePerson4UnAudit(ctx, depInfo);
        }
        StringBuffer params = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        String sp = " \r\n";
        strSQL.append("update T_SU_DepCharge set FBaseStatus =1,FAuditorId=null,FAuditTime = null where fid in(").append(sp);
        strSQL.append(params.toString());
        strSQL.append(");");
        DbUtil.execute((Context)ctx, (String)strSQL.toString());
    }

    private void checkAssociated(Context ctx, DepChargeInfo depInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = depInfo.getCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct bill.fnumber from T_SU_DepReverse bill  ").append("\r\n");
        sb.append(" left outer join T_SU_DepReverseEntry entry on bill.fid = entry.fparentid  ").append("\r\n");
        sb.append(" where bill.fperiod = ").append(currentPeriod.getPeriodNumber()).append("\r\n");
        sb.append(" and bill.fyear = ").append(currentPeriod.getPeriodYear()).append("\r\n");
        sb.append(" and bill.fbasestatus = ").append(4).append("\r\n");
        if (depInfo.getId() != null) {
            sb.append("and entry.fsourcebillid = '").append(depInfo.getId().toString()).append("' \r\n");
        }
        sb.append(" and fcompanyid= '").append(currentCompany.getId().toString()).append("'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs.size() > 0) {
            StringBuffer msg = new StringBuffer(100);
            msg.append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"214_DepChargeControllerBean", (Locale)ctx.getLocale()));
            try {
                while (rs.next()) {
                    msg.append("\n").append(rs.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            msg.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"215_DepChargeControllerBean", (Locale)ctx.getLocale()));
            throw new DepChargeException(DepChargeException.BLANK, new String[]{msg.toString()});
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String sql = "select fcompanyid from t_su_depcharge where fid  = '" + pk.toString().trim() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                String companyID = rowSet.getString(1);
                ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return company;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        DepChargeInfo depChargeInfo = (DepChargeInfo)model;
        if (depChargeInfo != null) {
            company = depChargeInfo.getCompany();
        }
        return company;
    }

    public String getParamCon4Audit() {
        return "SCM_CAL_A02";
    }

    public String getParamCon4UnAudit() {
        return "SCM_CAL_A01";
    }
}

