/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.invdep.app.AbstractDepChargeFacadeControllerBean;
import com.kingdee.eas.scm.cal.invdep.app.DepChargeSQL;
import com.kingdee.eas.scm.cal.invdep.app.DepChargeServerHelper;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DepChargeFacadeControllerBean
extends AbstractDepChargeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.invdep.app.DepChargeFacadeControllerBean");
    String line = "\r\n";

    @Override
    protected HashMap _getMaterialQtyAmt(Context ctx, IObjectPK companyPK, ArrayList materialIds) throws BOSException, EASBizException {
        return this._getTempTableMaterialQtyAmt(ctx, companyPK, materialIds);
    }

    private HashMap _getTempTableMaterialQtyAmt(Context ctx, IObjectPK companyPK, ArrayList materialIds) throws BOSException, EASBizException {
        HashSet<IObjectPK> companyIdSet = new HashSet<IObjectPK>();
        if (companyPK == null || materialIds.size() == 0) {
            return new HashMap();
        }
        companyIdSet.add(companyPK);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)companyPK);
        String tableName = null;
        tableName = this.createMaterialQtyAmtTable(ctx, currentPeriod, companyPK, materialIds);
        logger.error((Object)tableName);
        HashMap resultMap = null;
        try {
            resultMap = this.lookForCompMaterialQtyCost(ctx, tableName, companyIdSet, materialIds);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap lookForCompMaterialQtyCost(Context ctx, String tableName, Set companyIdSet, ArrayList materialIds) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, BigDecimal[]> materialQtyCostMap = new HashMap<String, BigDecimal[]>();
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(this.qtyCostQuery(tableName, companyIdSet, materialIds));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                materialQtyCostMap.put(rs.getString("FCompanyOrgUnitID") + rs.getString("FMaterialID"), new BigDecimal[]{rs.getBigDecimal("FBaseQty"), rs.getBigDecimal("FActualCost")});
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)con);
        }
        return materialQtyCostMap;
    }

    private String qtyCostQuery(String tableName, Set companyIdSet, ArrayList materialIds) throws CalculateException {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append("select FCompanyOrgUnitID, FMaterialID, sum(FPeriodBeginQty) + sum(FBaseQty) FBaseQty, sum(FPeriodBeginBalance) + sum(FActualCost) FActualCost from ").append(this.line);
        selectSQL.append(tableName);
        selectSQL.append(" where FCompanyOrgUnitID in ( ").append(DepChargeServerHelper.ids2SqlString(companyIdSet)).append(" ) ");
        selectSQL.append(" and FMaterialID in ( ").append(DepChargeServerHelper.ids2SqlString(materialIds)).append(" ) ");
        selectSQL.append(" group by FCompanyOrgUnitID, FMaterialID ");
        return selectSQL.toString();
    }

    private String createMaterialQtyAmtTable(Context ctx, PeriodInfo currentPeriod, IObjectPK companyPK, ArrayList materialIds) throws BOSException, EASBizException {
        String tempTable = null;
        String tmpTableDefine = this.getTempTableDefine();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            con = this.getConnection(ctx);
            tempTable = DepChargeServerHelper.createTempTable(ctx, con, "DepChargeMaterialQtyAmtTbl", tmpTableDefine.toString());
            stmt = con.createStatement();
            StringBuffer insPrefix = new StringBuffer();
            insPrefix.append("insert into ").append(tempTable);
            insPrefix.append(" ( FCompanyOrgUnitID, FMaterialID, ");
            insPrefix.append(" FPeriodBeginQty, FPeriodBeginBalance ) ").append(this.line);
            String StrMaterialIds = DepChargeServerHelper.ids2SqlString(materialIds);
            StringBuffer sql = new StringBuffer();
            sql.append(insPrefix);
            sql.append(this.materialInitQtyBalSql(companyPK, currentPeriod, StrMaterialIds));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append(this.comBizMaterialQtyAmt(currentPeriod, tempTable, companyPK, StrMaterialIds));
            logger.debug((Object)("comBizMaterialQtyAmt sql :\r\n" + sql));
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"prepareArCreditBal execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(pstmt);
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        return tempTable;
    }

    private String comBizMaterialQtyAmt(PeriodInfo currentPeriod, String tempTable, IObjectPK companyPK, String StrMaterialIds) {
        String extCondition = " and entry.fmaterialid in(" + StrMaterialIds + ") ";
        DepChargeSQL depSQL = new DepChargeSQL(currentPeriod);
        depSQL.setCompanyOrgUnitId(companyPK.toString());
        StringBuffer sSql = new StringBuffer();
        sSql.append(" insert into ").append(tempTable);
        sSql.append(" (FCompanyOrgUnitID,  FMaterialID, FBaseQty, FActualCost) ");
        sSql.append(" select tSum.FCompanyOrgUnitID FCompanyOrgUnitID, tSum.FMaterialID FMaterialID, sum(tSum.FBaseQty) FBaseQty, sum(tSum.FActualCost) FActualCost from ( ");
        sSql.append(" select tIn.FCompanyOrgUnitID FCompanyOrgUnitID, tIn.FMaterialID FMaterialID, sum(tIn.FBaseQty) FBaseQty, sum(tIn.FActualCost) FActualCost from ( ");
        sSql.append(depSQL.getInBillSql(extCondition));
        sSql.append(" UNION ALL ");
        sSql.append(depSQL.getCostAdjustBillSql(0, extCondition));
        sSql.append(" ) tIn group by tIn.FCompanyOrgUnitID, tIn.FMaterialID   union all ");
        sSql.append(" select tOut.FCompanyOrgUnitID FCompanyOrgUnitID, tOut.FMaterialID FMaterialID, 0-sum(tOut.FBaseQty) FBaseQty, 0-sum(tOut.FActualCost) FActualCost from ( ");
        sSql.append(depSQL.getOutBillSql(extCondition));
        sSql.append(" UNION ALL ");
        sSql.append(depSQL.getCostAdjustBillSql(1, extCondition));
        sSql.append(" ) tOut group by tOut.FCompanyOrgUnitID, tOut.FMaterialID ");
        sSql.append(" ) tSum ");
        sSql.append(" group by tSum.FCompanyOrgUnitID, tSum.FMaterialID  ");
        return sSql.toString();
    }

    private String materialInitQtyBalSql(IObjectPK companyPK, PeriodInfo currentPeriod, String StrMaterialIds) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t1.FCompanyOrgUnitID FCompanyOrgUnitID, t1.FMaterialID FMaterialID, ").append(this.line);
        sql.append(" sum(t1.FPeriodBeginQty) FPeriodBeginQty, ").append(this.line);
        sql.append(" sum(t1.FPeriodBeginBalance) FPeriodBeginBalance ").append(this.line);
        sql.append(" from T_IM_INVENTORYBALANCE  t1").append(this.line);
        sql.append(" where 1=1 ").append(this.line);
        sql.append(" and t1.fmaterialid in(").append(StrMaterialIds).append(")").append(this.line);
        sql.append(" and t1.fiscalculate = ").append(new Integer(1)).append(" ").append(this.line);
        sql.append(" and t1.FPeriod = ").append(new Integer(currentPeriod.getPeriodNumber())).append(" ").append(this.line);
        sql.append(" and t1.FYear = ").append(new Integer(currentPeriod.getPeriodYear())).append(" ").append(this.line);
        sql.append(" group by t1.FCompanyOrgUnitID, t1.FMaterialID ").append(this.line);
        logger.debug((Object)("materialInitQtyBalSql" + sql.toString()));
        return sql.toString();
    }

    private String getTempTableDefine() {
        StringBuffer tmpTableDefine = new StringBuffer();
        tmpTableDefine.append("( FCompanyOrgUnitID varchar(44), ");
        tmpTableDefine.append("FMaterialID varchar(44), ");
        tmpTableDefine.append("FPeriodBeginQty decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FBaseQty decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FPeriodBeginBalance decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FActualCost decimal(28, 10) NOT NULL DEFAULT 0 ) ");
        return tmpTableDefine.toString();
    }
}

