/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.invdep.DepChargeException;
import com.kingdee.eas.scm.cal.invdep.DepReverseEntryCollection;
import com.kingdee.eas.scm.cal.invdep.DepReverseEntryInfo;
import com.kingdee.eas.scm.cal.invdep.DepReverseException;
import com.kingdee.eas.scm.cal.invdep.DepReverseFacadeFactory;
import com.kingdee.eas.scm.cal.invdep.DepReverseFactory;
import com.kingdee.eas.scm.cal.invdep.DepReverseInfo;
import com.kingdee.eas.scm.cal.invdep.IDepReverse;
import com.kingdee.eas.scm.cal.invdep.IDepReverseFacade;
import com.kingdee.eas.scm.cal.invdep.app.AbstractDepReverseControllerBean;
import com.kingdee.eas.scm.cal.invdep.app.DepChargeServerHelper;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DepReverseControllerBean
extends AbstractDepReverseControllerBean {
    private static final long serialVersionUID = 274321245733460259L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.invdep.app.DepReverseControllerBean");
    public static final String DEPREVERSE_BILLTYPEID = "0Vh8gAEdEADgAFFNwKgSQUY+1VI=";

    @Override
    protected HashMap _createDepReverse(Context ctx, HashMap filterMap) throws BOSException, EASBizException {
        return null;
    }

    protected void checkAudit(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IDepReverse iDepReverse = DepReverseFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkAudit(ctx, iDepReverse, pks[i]);
                    continue;
                }
                catch (PurOrderException ex) {
                    if (num > 1) {
                        throw new DepReverseException(DepReverseException.DEP_CANNOT_AUDIT_NOTSUBMIT);
                    }
                    throw ex;
                }
            }
        }
    }

    private void checkAudit(Context ctx, IDepReverse iDepReverse, IObjectPK pk) throws EASBizException, BOSException {
        DepReverseInfo depReverseInfo = iDepReverse.getDepReverseInfo(pk);
        if (depReverseInfo.getBaseStatus().getValue() != 2) {
            throw new DepReverseException(DepReverseException.DEP_CANNOT_AUDIT_NOTSUBMIT);
        }
        this.checkDepCharged(ctx, depReverseInfo);
        this.isSamePerson4Audit(ctx, depReverseInfo);
    }

    private void checkDepCharged(Context ctx, DepReverseInfo depReverse) throws EASBizException, BOSException {
        DepReverseEntryCollection entrys = depReverse.getEntrys();
        ArrayList<BOSUuid> materialIds = new ArrayList<BOSUuid>();
        int idSize = entrys.size();
        for (int idIndex = 0; idIndex < idSize; ++idIndex) {
            if (entrys.get(idIndex).getMaterial() == null) continue;
            materialIds.add(entrys.get(idIndex).getMaterial().getId());
        }
        CompanyOrgUnitInfo currentCompany = depReverse.getCompany();
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct material.fnumber from T_SU_DepChargeEntry entry  ").append("\r\n");
        sb.append(" right outer join T_SU_DepCharge bill on bill.fid = entry.fparentid ").append("\r\n");
        sb.append(" left outer join t_bd_material material on material.fid = entry.fmaterialid ");
        sb.append(" where bill.fperiod = ").append(currentPeriod.getPeriodNumber()).append("\r\n");
        sb.append(" and bill.fyear = ").append(currentPeriod.getPeriodYear()).append("\r\n");
        sb.append(" and bill.fbasestatus = ").append(4).append("\r\n");
        if (materialIds.size() > 0) {
            sb.append("and entry.fmaterialid in ( ").append(DepChargeServerHelper.ids2SqlString(materialIds)).append(") \r\n");
        }
        sb.append(" and fcompanyid= '").append(currentCompany.getId().toString()).append("'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        StringBuffer seqStr = new StringBuffer();
        if (rs.size() > 0) {
            int i = 0;
            try {
                while (rs.next()) {
                    ++i;
                    seqStr.append(rs.getString(1)).append(",");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"207_DepChargeControllerBean", (Locale)ctx.getLocale()) + seqStr + ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"216_DepReverseControllerBean", (Locale)ctx.getLocale())});
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this.audit(ctx, pk);
        IDepReverse iDepReverse = DepReverseFactory.getLocalInstance(ctx);
        DepReverseInfo depReverseInfo = iDepReverse.getDepReverseInfo(pk);
        this.isSamePerson4Audit(ctx, depReverseInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DepReverseInfo depReverseInfo = (DepReverseInfo)model;
        IObjectPK pk = super._submit(ctx, model);
        String orgUnitID = depReverseInfo.getCompany().getId().toString();
        DepReverseEntryCollection entries = depReverseInfo.getEntrys();
        if (entries == null || entries.size() == 0) {
            throw new DepReverseException(DepReverseException.ENTRY_NULL_CANNOT_SUBMIT);
        }
        for (int i = 0; i < entries.size(); ++i) {
            if (entries.get(i).getCurPeriodDrAmt() != null && entries.get(i).getCurPeriodDrAmt().compareTo(new BigDecimal("0.00")) != 0 || entries.get(i).getCurPeriodDrQty() != null && entries.get(i).getCurPeriodDrQty().compareTo(new BigDecimal("0.00")) != 0) continue;
            throw new DepReverseException(DepReverseException.QTY_AMT_NULL_CANNOT_SUBMIT);
        }
        this.checkDepCharged(ctx, depReverseInfo);
        IDepReverseFacade reverseFacade = DepReverseFacadeFactory.getLocalInstance(ctx);
        if (!reverseFacade.canSubmit(depReverseInfo.getId().toString())) {
            throw new DepReverseException(DepReverseException.BILL_AUDIT_NOT_SUBMIT);
        }
        if (this.isAuditAfterSubmit(ctx, depReverseInfo, orgUnitID, 1)) {
            this.auditAndLog(ctx, pk, depReverseInfo.getBOSType(), depReverseInfo.getNumber(), "scm_depReverse_audit");
        }
        return pk;
    }

    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkAudit(ctx, pks);
        StringBuffer params = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        String sp = " \r\n";
        strSQL.append("update T_SU_DepReverse set FBaseStatus =4,FAuditorId='");
        strSQL.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        strSQL.append("',FAuditTime = getDate() where fid in(").append(sp);
        strSQL.append(params.toString());
        strSQL.append(");");
        DbUtil.execute((Context)ctx, (String)strSQL.toString());
        String selectSql = "select FCurPeriodDrQty,FCurPeriodDrAmt,FSourceBillEntryID from T_SU_DepReverseentry where FParentID = ? ";
        this.feedBack(ctx, pks, selectSql);
    }

    private void feedBack(Context ctx, IObjectPK[] pks, String selectSql) throws BOSException {
        int length = pks.length;
        Object[] pa = new Object[1];
        IRowSet rowSet = null;
        String feedBack = "update T_SU_DepChargeEntry set FQtyReverse = ? ,FAmtReverse= ? where FID = ? ;";
        BigDecimal qty = new BigDecimal("0.00");
        BigDecimal amt = new BigDecimal("0.00");
        String fid = "";
        Connection con = null;
        PreparedStatement ppst = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ppst = con.prepareStatement(feedBack);
            for (int i = 0; i < length; ++i) {
                IObjectPK pk = pks[i];
                pa[0] = pk.toString();
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])pa);
                while (rowSet.next()) {
                    qty = rowSet.getBigDecimal(1);
                    amt = rowSet.getBigDecimal(2);
                    fid = rowSet.getString(3);
                    ppst.setBigDecimal(1, qty);
                    ppst.setBigDecimal(2, amt);
                    ppst.setString(3, fid);
                    ppst.executeUpdate();
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Audit write  back:" + e));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ppst, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ppst, (Connection)con);
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._audit(ctx, pks);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._unAudit(ctx, pks);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        BillTypeInfo billType = null;
        DepReverseInfo depInfo = null;
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            depInfo = DepReverseFactory.getLocalInstance(ctx).getDepReverseInfo(pks[j]);
            billType = depInfo.getBillType();
            if (billType == null) {
                billType = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(DEPREVERSE_BILLTYPEID));
                depInfo.setBillType(billType);
            }
            SCMServerUtils.checkParamCanUnAudit((Context)ctx, (SCMBillBaseInfo)depInfo);
            SCMServerUtils.checkBaseStatus((SCMBillBaseInfo)depInfo);
            SCMServerUtils.checkDownriver((Context)ctx, (SCMBillBaseInfo)depInfo);
            this.isSamePerson4UnAudit(ctx, depInfo);
        }
        StringBuffer params = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        String sp = " \r\n";
        strSQL.append("update T_SU_DepReverse set FBaseStatus =1,FAuditorId=null,FAuditTime = null where fid in(").append(sp);
        strSQL.append(params.toString());
        strSQL.append(");");
        DbUtil.execute((Context)ctx, (String)strSQL.toString());
        String selectSql = "select FDepReverseQty,FDepReverseAmt,FSourceBillEntryID from T_SU_DepReverseentry where FParentID = ? ";
        this.feedBack(ctx, pks, selectSql);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String sql = "select fcompanyid from t_su_depreverse where fid  = '" + pk.toString().trim() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                String companyID = rowSet.getString(1);
                ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return company;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DepReverseInfo depInfo = (DepReverseInfo)model;
        IObjectPK logPK = null;
        if (depInfo.getId() != null) {
            logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)depInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(depInfo.getId().toString()), (String)depInfo.getNumber(), (String)"cal_depReverse_convert");
        }
        IObjectPK pk = super._save(ctx, model);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, logPK);
        }
        return pk;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        DepReverseInfo depReverseInfo = (DepReverseInfo)model;
        if (null == depReverseInfo.getId()) {
            return company;
        }
        String sql = "select fcompanyid from t_su_depreverse where fid  = '" + depReverseInfo.getId().toString().trim() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                String companyID = rowSet.getString(1);
                ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return company;
    }

    public String getParamCon4Audit() {
        return "SCM_CAL_A02";
    }

    public String getParamCon4UnAudit() {
        return "SCM_CAL_A01";
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue model = collection.getObject(i);
            try {
                this.initBotpData(ctx, model);
                continue;
            }
            catch (Exception e) {
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        DepReverseInfo info = (DepReverseInfo)model;
        if (info == null || info.getCompany() == null) {
            return;
        }
        info.setFivouchered(false);
        DepReverseEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        BigDecimal invQty = SysConstant.BIGZERO;
        BigDecimal depReverseQty = SysConstant.BIGZERO;
        int entrySize = info.getEntrys().size();
        for (int i = 0; i < entrySize; ++i) {
            entryInfo = info.getEntrys().get(i);
            if (entryInfo.getSourceBillEntryId() == null) continue;
            materialInfo = entryInfo.getMaterial();
            if (entryInfo == null || materialInfo == null) continue;
            invQty = entryInfo.getInvQty();
            depReverseQty = entryInfo.getDepReverseQty();
            if (invQty == null) {
                invQty = SysConstant.BIGZERO;
                entryInfo.setInvQty(invQty);
            }
            if (depReverseQty != null) continue;
            depReverseQty = SysConstant.BIGZERO;
            entryInfo.setDepReverseQty(depReverseQty);
        }
    }
}

