/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.cal.invdep.DepChargeException;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryEntryCollection;
import com.kingdee.eas.scm.cal.invdep.MaterialCategoryInfo;
import com.kingdee.eas.scm.cal.invdep.app.AbstractMaterialCategoryControllerBean;
import com.kingdee.eas.scm.cal.invdep.app.DepChargeServerHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MaterialCategoryControllerBean
extends AbstractMaterialCategoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.invdep.app.MaterialCategoryControllerBean");

    @Override
    protected HashMap _getTreeTableMap(Context ctx, IObjectPK companyPK, IObjectPK materialCategoryPK) throws BOSException, EASBizException {
        return new HashMap();
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        MaterialCategoryInfo info = (MaterialCategoryInfo)model;
        MaterialCategoryEntryCollection entrys = info.getEntry();
        if (info.getEntry() != null && info.getEntry().size() > 0) {
            IRowSet rs;
            ArrayList<BOSUuid> materialIds = new ArrayList<BOSUuid>();
            for (int idIndex = 0; idIndex < entrys.size(); ++idIndex) {
                if (entrys.get(idIndex) != null && entrys.get(idIndex).getMaterial() != null) {
                    materialIds.add(entrys.get(idIndex).getMaterial().getId());
                    continue;
                }
                entrys.removeObject(idIndex);
                --idIndex;
            }
            if (info.getEntry() == null || info.getEntry().size() == 0) {
                throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"218_MaterialCategoryControllerBean", (Locale)ctx.getLocale())});
            }
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            this.setNumberFromCodingRule(ctx, info, currentCompany.getId().toString());
            StringBuffer sb = new StringBuffer();
            sb.append(" select 1 from T_SU_MaterialCategoryEntry entry ").append("\r\n");
            sb.append(" right outer join T_SU_MaterialCategory bill on bill.fid = entry.fparentid ").append("\r\n");
            sb.append(" where \r\n");
            if (materialIds.size() > 0) {
                sb.append(" entry.fmaterialid in ( ").append(DepChargeServerHelper.ids2SqlString(materialIds)).append(") \r\n");
            }
            sb.append(" and bill.fcompanyid = '").append(currentCompany.getId()).append("'").append("\r\n");
            if (info.getId() != null) {
                sb.append(" and bill.fid <> '").append(info.getId()).append("'").append("\r\n");
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString())).size() > 0) {
                sb = new StringBuffer();
                sb.append(" select distinct material.fnumber from T_SU_MaterialCategoryEntry entry ").append("\r\n");
                sb.append(" right outer join T_SU_MaterialCategory bill on bill.fid = entry.fparentid ").append("\r\n");
                sb.append(" left outer join t_bd_material material on material.fid = entry.fmaterialid ").append("\r\n");
                sb.append(" where \r\n");
                if (materialIds.size() > 0) {
                    sb.append(" entry.fmaterialid in ( ").append(DepChargeServerHelper.ids2SqlString(materialIds)).append(") \r\n");
                }
                sb.append(" and bill.fcompanyid = '").append(currentCompany.getId()).append("'").append("\r\n");
                if (info.getId() != null) {
                    sb.append(" and bill.fid <> '").append(info.getId()).append("'").append("\r\n");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                StringBuffer seqStr = new StringBuffer();
                int i = 0;
                try {
                    while (rs.next()) {
                        seqStr.append(rs.getString(1)).append(",");
                        if (++i != 4) continue;
                        break;
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"219_MaterialCategoryControllerBean", (Locale)ctx.getLocale()) + seqStr.deleteCharAt(seqStr.length() - 1).toString() + ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"220_MaterialCategoryControllerBean", (Locale)ctx.getLocale())});
            }
        }
        if (this.isSameNumber(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info)) {
            throw new DepChargeException(DepChargeException.BLANK, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"221_MaterialCategoryControllerBean", (Locale)ctx.getLocale())});
        }
        return super.save(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        if (caller.getNumber() != null && caller.getNumber().trim().length() > 0) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = this.getNextCompanyId(ctx);
        }
        if (orgId == null || orgId.trim().length() == 0) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId) && !iCodingRuleManager.isUserSelect((IObjectValue)caller, orgId)) {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            } else if (iCodingRuleManager.isAddView((IObjectValue)caller, orgId)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)caller, orgId)) {
                    iCodingRuleManager.checkModifiedNumber((IObjectValue)caller, orgId, caller.getNumber().toString());
                }
            } else {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            }
        }
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MaterialCategoryInfo materialCateInfo = (MaterialCategoryInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)materialCateInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (materialCateInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)materialCateInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (materialCateInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)materialCateInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (materialCateInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)materialCateInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }
}

