/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.newutil;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.GregorianCalendar;

public class DepChargeHelper {
    private static String path = "com.kingdee.eas.fm.common.FMResource";

    public static Date downTimestamp(Timestamp oldTime) {
        return DepChargeHelper.changeTimestamp(oldTime, -1);
    }

    public static Date upTimestamp(Timestamp oldTime) {
        return DepChargeHelper.changeTimestamp(oldTime, 1);
    }

    private static Date changeTimestamp(Timestamp oldTime, int i) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5) + i);
        Date date = new Date(calendarUp.getTime().getTime());
        return date;
    }

    public static Date timestampToDate(Timestamp time) {
        return DepChargeHelper.changeTimestamp(time, 0);
    }

    public static boolean isChargeByMaterial() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        return DepChargeHelper.isChargeByMaterial(company.getId().toString());
    }

    public static boolean isChargeByMaterial(String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String sParamValue = null;
        try {
            sParamValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"SCM_CAL_007");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return "0".equals(sParamValue);
    }

    public static IRow addRow(KDTable table) {
        IRow row = table.getRowCount() > 0 ? table.addRow(table.getRowCount() - 1) : table.addRow();
        return row;
    }

    public static void setEntrySeq(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        int seq = 1;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = table.getRow(i);
            row.getCell("seq").setValue((Object)new Integer(seq++));
        }
    }

    public static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public EntityViewInfo getAcctEvi(CtrlUnitInfo cu, AccountTableInfo accountTable) {
        FilterInfo filter = new FilterInfo();
        if (cu != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu));
        }
        if (accountTable != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTable));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)CalConstant.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)CalConstant.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)CalConstant.TRUE));
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        return customEvi;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (StringUtil.isEmpty((String)txt)) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? DepChargeHelper.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        DepChargeHelper.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        DepChargeHelper.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? DepChargeHelper.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = DepChargeHelper.getCompLabelText(component);
        return ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"CanNotBeNull", (String[])new String[]{text});
    }

    private static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }
}

