/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.help.CalcCycleTrans;
import com.kingdee.eas.scm.cal.help.Topology;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.onekey.AbstractSmartCalculateFacadeControllerBean;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SmartCalculateFacadeControllerBean
extends AbstractSmartCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.SmartCalculateFacadeControllerBean");
    private Set md5KeySet = new HashSet();

    @Override
    protected void _reCalcMaterialRelationStructure(Context ctx, HashMap param) throws BOSException, EASBizException {
        try {
            int count;
            String outMd5Key;
            String inMd5Key;
            String companyId = (String)param.get("companyId");
            companyId = "c6oAAAAAJKLM567U";
            CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
            cou.setId(BOSUuid.read((String)companyId));
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            int year = currentPeriodInfo.getPeriodYear();
            int period = currentPeriodInfo.getPeriodNumber();
            Date beginDate = currentPeriodInfo.getBeginDate();
            Timestamp endDate = currentPeriodInfo.getEndDate();
            StringBuffer sql = new StringBuffer();
            IRowSet inOutRs = this.getInOutData(ctx, companyId, beginDate, endDate);
            IRowSet devRs = this.getDevData(ctx, companyId, year, period, beginDate, endDate);
            HashSet<String> matIdSet = new HashSet<String>();
            while (inOutRs.next()) {
                matIdSet.add(inOutRs.getString("outFMATERIALID"));
                matIdSet.add(inOutRs.getString("inFMATERIALID"));
            }
            while (devRs.next()) {
                matIdSet.add(devRs.getString("FOUTMAT"));
                matIdSet.add(devRs.getString("FINMAT"));
            }
            if (matIdSet.size() == 0) {
                return;
            }
            Map matComMap = this.getMaterialCompanyCalcInfo(ctx, cou.getId().toString(), matIdSet);
            sql.setLength(0);
            String insertSql = "insert into t_cl_materialRelationStructure(fid,fcount,FCompanyOrgUnitId,FPeriodId,FMaterialFrom,FMaterialTo,FKeyFrom,FKeyTo) values(newbosid('D1F79EED'),?,?,?,?,?,?,?)";
            String deleteSql = "delete t_cl_materialRelationStructure where FPeriodId = '" + currentPeriodInfo.getId().toString() + "' and FCompanyOrgUnitId = '" + cou.getId().toString() + "'";
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            String calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
            HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
            StringBuffer unionKey = new StringBuffer();
            inOutRs.beforeFirst();
            while (inOutRs.next()) {
                unionKey.setLength(0);
                inMd5Key = this.getMd5CalKey(ctx, calType, inOutRs.getString("inFMATERIALID"), companyId, inOutRs.getString("inFSTORAGEORGUNITID"), inOutRs.getString("inFWAREHOUSEID"), inOutRs.getString("inFLOT"), inOutRs.getString("inFASSISTPROPERTYID"), inOutRs.getString("inFPROJECTID"), inOutRs.getString("inFTRACKNUMBERID"), matComMap);
                outMd5Key = this.getMd5CalKey(ctx, calType, inOutRs.getString("outFMATERIALID"), companyId, inOutRs.getString("outFSTORAGEORGUNITID"), inOutRs.getString("outFWAREHOUSEID"), inOutRs.getString("outFLOT"), inOutRs.getString("outFASSISTPROPERTYID"), inOutRs.getString("outFPROJECTID"), inOutRs.getString("outFTRACKNUMBERID"), matComMap);
                unionKey.append(inOutRs.getString("outFMATERIALID")).append(";").append(inOutRs.getString("inFMATERIALID")).append(";");
                unionKey.append(outMd5Key).append(";").append(inMd5Key);
                if (!keyCount.containsKey(unionKey.toString())) {
                    keyCount.put(unionKey.toString(), 1);
                    continue;
                }
                count = (Integer)keyCount.get(unionKey.toString());
                keyCount.put(unionKey.toString(), ++count);
            }
            devRs.beforeFirst();
            while (devRs.next()) {
                unionKey.setLength(0);
                inMd5Key = this.getMd5CalKey(ctx, calType, devRs.getString("FINMAT"), companyId, devRs.getString("FINSOU"), devRs.getString("FINWAREHOUSE"), devRs.getString("FINLOT"), devRs.getString("FINASST"), devRs.getString("FINPROJECT"), devRs.getString("FINTRACKNUM"), matComMap);
                outMd5Key = this.getMd5CalKey(ctx, calType, devRs.getString("FOUTMAT"), companyId, devRs.getString("FOUTSOU"), devRs.getString("FOUTWAREHOUSE"), devRs.getString("FOUTLOT"), devRs.getString("FOUTASST"), devRs.getString("FOUTPROJECT"), devRs.getString("FOUTTRACKNUM"), matComMap);
                unionKey.append(devRs.getString("FOUTMAT")).append(";").append(devRs.getString("FINMAT")).append(";");
                unionKey.append(outMd5Key).append(";").append(inMd5Key);
                if (!keyCount.containsKey(unionKey.toString())) {
                    keyCount.put(unionKey.toString(), 1);
                    continue;
                }
                count = (Integer)keyCount.get(unionKey.toString());
                keyCount.put(unionKey.toString(), ++count);
            }
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
            Iterator iterator = keyCount.entrySet().iterator();
            while (iterator.hasNext()) {
                Object[] insertParam = new Object[7];
                Map.Entry entry = iterator.next();
                String[] unionKeys = ((String)entry.getKey()).split(";");
                insertParam[0] = Integer.parseInt(entry.getValue().toString());
                insertParam[1] = companyId;
                insertParam[2] = currentPeriodInfo.getId().toString();
                insertParam[3] = unionKeys[0];
                insertParam[4] = unionKeys[1];
                insertParam[5] = unionKeys[2];
                insertParam[6] = unionKeys[3];
                insertParams.add(insertParam);
            }
            DbUtil.execute((Context)ctx, (String)deleteSql);
            DbUtil.executeBatch((Context)ctx, (String)insertSql, insertParams);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String convertIdSet2String(Set<String> idSet) {
        StringBuffer ids = new StringBuffer();
        ids.append("(");
        for (String s : idSet) {
            ids.append("'").append(s).append("',");
        }
        ids.setLength(ids.length() - 1);
        ids.append(")");
        return ids.toString();
    }

    private String getMd5CalKey(Context ctx, String calType, String materialId, String couId, String souId, String warehouseId, String lot, String assistPropertyId, String projectId, String trackNumberId, Map matComMap) throws NoSuchAlgorithmException, BOSException, SQLException {
        String md5Key;
        String insertSql = "insert into T_CL_CalculateKeyMapping(fid,FMD5Key,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) values (newbosid('243A15B2'),?,?,?,?,?,?,?,?)";
        Object[] param = new String[8];
        StringBuffer calKey = new StringBuffer();
        if ("0".equals(calType)) {
            calKey.append(couId);
            param[1] = couId;
        } else if ("1".equals(calType)) {
            calKey.append(couId).append(souId);
            param[1] = couId;
            param[2] = souId;
        } else if ("2".equals(calType)) {
            calKey.append(couId).append(souId).append(warehouseId);
            param[1] = couId;
            param[2] = souId;
            param[3] = warehouseId;
        }
        if (matComMap.get(materialId) != null) {
            HashMap specialCalKeyMap = (HashMap)matComMap.get(materialId);
            if (Integer.parseInt(specialCalKeyMap.get("FISLOT").toString()) == 1) {
                calKey.append(lot);
                param[4] = lot;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISASSISTPROPERTY").toString()) == 1) {
                calKey.append(assistPropertyId);
                param[5] = assistPropertyId;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISPROJECT").toString()) == 1) {
                calKey.append(projectId);
                param[6] = projectId;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISTRACKNUMBER").toString()) == 1) {
                calKey.append(trackNumberId);
                param[7] = trackNumberId;
            }
        }
        if (!this.md5KeySet.contains(md5Key = BalanceUtil.getMd5((String)calKey.toString()))) {
            this.md5KeySet.add(md5Key);
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)("select count(1) count from T_CL_CalculateKeyMapping where FMD5Key = '" + md5Key + "'"));
            while (result.next()) {
                if (result.getInt("count") != 0) continue;
                param[0] = md5Key;
                DbUtil.execute((Context)ctx, (String)insertSql, (Object[])param);
            }
        }
        return md5Key;
    }

    @Override
    protected void _calcRank(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        companyId = "c6oAAAAAJKLM567U";
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        String periodId = currentPeriodInfo.getId().toString();
        DBUtil.execute((Context)ctx, (String)("delete T_CL_MATERIALCALCRANK where FCompanyOrgUnitId = '" + companyId + "' and FPeriodId = '" + periodId + "'"));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FMATERIALFROM,FKEYFROM,FMATERIALTO,FKEYTO,FGROUPKEY FROM t_cl_materialRelationStructure ");
        sql.append("WHERE FCOMPANYORGUNITID = '").append(companyId).append("' ");
        sql.append("AND FPERIODID = '").append(periodId).append("' ");
        sql.append("ORDER BY FGROUPKEY,FBIZDATE,FAUDITTIME");
        HashMap<String, Integer> fromToMap = new HashMap<String, Integer>();
        HashMap<Integer, String> fromToMapOpposite = new HashMap<Integer, String>();
        HashMap<String, Integer> fromToSerialMap = new HashMap<String, Integer>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        int keyCount = 1;
        int serial = 1;
        String fromDot = null;
        String toDot = null;
        String fromToDot = null;
        String groupKey = null;
        try {
            while (rs.next()) {
                if (groupKey != null && !groupKey.equals(rs.getString("FGROUPKEY"))) {
                    this.calcCurrGroupRank(ctx, keyCount, fromToSerialMap, fromToMap, fromToMapOpposite, companyId, periodId, groupKey);
                    keyCount = 1;
                    serial = 1;
                    fromToSerialMap = new HashMap();
                    fromToMap = new HashMap();
                    fromToMapOpposite = new HashMap();
                }
                groupKey = rs.getString("FGROUPKEY");
                fromDot = rs.getString("FMATERIALFROM") + ";" + rs.getString("FKEYFROM");
                toDot = rs.getString("FMATERIALTO") + ";" + rs.getString("FKEYTO");
                if (!fromToMap.containsKey(fromDot)) {
                    fromToMap.put(fromDot, keyCount);
                    fromToMapOpposite.put(keyCount, fromDot);
                    ++keyCount;
                }
                if (!fromToMap.containsKey(toDot)) {
                    fromToMap.put(toDot, keyCount);
                    fromToMapOpposite.put(keyCount, toDot);
                    ++keyCount;
                }
                fromToDot = fromDot + "_" + toDot;
                fromToSerialMap.put(fromToDot, serial);
                ++serial;
            }
            this.calcCurrGroupRank(ctx, keyCount, fromToSerialMap, fromToMap, fromToMapOpposite, companyId, periodId, groupKey);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void calcCurrGroupRank(Context ctx, int keyCount, Map fromToSerialMap, Map fromToMap, Map fromToMapOpposite, String couId, String periodId, String groupKey) throws BOSException {
        byte[][] fromToArray = new byte[keyCount][keyCount];
        int[][] fromToSerialArray = new int[keyCount][keyCount];
        int rowindex = 0;
        int colindex = 0;
        String[] temp = null;
        Set keySet = fromToSerialMap.keySet();
        String fromDot = null;
        String toDot = null;
        String fromToDot2 = null;
        for (String fromToDot2 : keySet) {
            temp = fromToDot2.split("_");
            fromDot = temp[0];
            toDot = temp[1];
            rowindex = (Integer)fromToMap.get(fromDot);
            colindex = (Integer)fromToMap.get(toDot);
            fromToArray[rowindex][colindex] = 1;
            fromToSerialArray[rowindex][colindex] = (Integer)fromToSerialMap.get(fromToDot2);
        }
        Set cycle = CalcCycleTrans.getCycle(fromToArray);
        String cycleString = this.getCycleString(cycle, fromToMapOpposite);
        fromToArray = CalcCycleTrans.breakCycle(fromToArray, fromToSerialArray);
        Topology topology = new Topology(keyCount, fromToArray);
        String outOrInID2 = null;
        keySet = fromToMap.keySet();
        for (String outOrInID2 : keySet) {
            rowindex = (Integer)fromToMap.get(outOrInID2);
            topology.setVertexs(rowindex, outOrInID2);
        }
        Object[] result = topology.topoByte();
        String insertSql = "insert into T_CL_MATERIALCALCRANK(fid,FCompanyOrgUnitId,FPeriodId,FGroupKey,FMaterialId,FCalculateKey,FRank) values(newbosid('F99C1DF4'),?,?,?,?,?,?)";
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        LinkedList outList = new LinkedList();
        int n = result.length;
        for (int j = 0; j < n; ++j) {
            if (result[j] == null) continue;
            String[] matKey = result[j].toString().split(";");
            Object[] param = new Object[]{couId, periodId, groupKey, matKey[0], matKey[1], j + 1};
            insertParamList.add(param);
        }
        DBUtil.executeBatch((Context)ctx, (String)insertSql, insertParamList);
    }

    private String getCycleString(Set cycle, Map fromToMapOpposite) {
        StringBuffer cycleSb = new StringBuffer();
        for (List cycleList : cycle) {
            int size = cycleList.size();
            for (int i = 0; i < size; ++i) {
                cycleSb.append(fromToMapOpposite.get(Integer.parseInt(cycleList.get(i).toString())));
                if (i == size - 1) {
                    cycleSb.append("\n");
                    continue;
                }
                cycleSb.append("->");
            }
        }
        return cycleSb.toString();
    }

    @Override
    protected void _calcGroupKey(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        companyId = "c6oAAAAAJKLM567U";
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid,FMaterialFrom,FKeyFrom,FMaterialTo,FKeyTo from t_cl_materialRelationStructure ");
            sql.append("where FCompanyOrgUnitId = '").append(companyId).append("' ");
            sql.append("and FPeriodId = '").append(currentPeriodInfo.getId().toString()).append("'");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String[]> updateParamList = new ArrayList<String[]>();
            ArrayList<String[]> insertParamList = new ArrayList<String[]>();
            ArrayList groupkeySetList = new ArrayList();
            HashMap<Integer, String> groupKeyMap = new HashMap<Integer, String>();
            String groupKey = null;
            boolean hasContain = false;
            while (rs.next()) {
                String[] insertParamTo;
                String fromKey = rs.getString("FMaterialFrom") + ";" + rs.getString("FKeyFrom");
                String toKey = rs.getString("FMaterialTo") + ";" + rs.getString("FKeyTo");
                for (int i = 0; i < groupkeySetList.size(); ++i) {
                    Set set = (Set)groupkeySetList.get(i);
                    if (!set.contains(fromKey) && !set.contains(toKey)) continue;
                    hasContain = true;
                    groupKey = (String)groupKeyMap.get(i);
                    if (!set.contains(fromKey)) {
                        set.add(fromKey);
                        String[] insertParamFrom = new String[]{currentPeriodInfo.getId().toString(), companyId, groupKey, rs.getString("FMaterialFrom"), rs.getString("FKeyFrom")};
                        insertParamList.add(insertParamFrom);
                    }
                    if (set.contains(toKey)) continue;
                    set.add(toKey);
                    insertParamTo = new String[]{currentPeriodInfo.getId().toString(), companyId, groupKey, rs.getString("FMaterialTo"), rs.getString("FKeyTo")};
                    insertParamList.add(insertParamTo);
                }
                if (!hasContain) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(fromKey);
                    set.add(toKey);
                    groupkeySetList.add(set);
                    groupKey = UUID.randomUUID().toString();
                    groupKeyMap.put(groupkeySetList.size() - 1, groupKey);
                    String[] insertParamFrom = new String[]{currentPeriodInfo.getId().toString(), companyId, groupKey, rs.getString("FMaterialFrom"), rs.getString("FKeyFrom")};
                    insertParamTo = new String[]{currentPeriodInfo.getId().toString(), companyId, groupKey, rs.getString("FMaterialTo"), rs.getString("FKeyTo")};
                    insertParamList.add(insertParamFrom);
                    insertParamList.add(insertParamTo);
                }
                hasContain = false;
                String[] updateParam = new String[]{groupKey, rs.getString("fid")};
                updateParamList.add(updateParam);
            }
            if (updateParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)"update t_cl_materialRelationStructure set FGroupKey = ? where fid = ?", updateParamList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _calcFirstBizTime(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        companyId = "c6oAAAAAJKLM567U";
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Date beginDate = currentPeriodInfo.getBeginDate();
        Timestamp endDate = currentPeriodInfo.getEndDate();
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
        try {
            Object[] firstBizDate;
            String fromToKey;
            String toKey;
            String fromKey;
            IRowSet inOutRs = this.getInOutData(ctx, companyId, beginDate, endDate);
            IRowSet devRs = this.getDevData(ctx, companyId, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), beginDate, endDate);
            HashSet<String> matIdSet = new HashSet<String>();
            while (inOutRs.next()) {
                matIdSet.add(inOutRs.getString("inFMATERIALID"));
                matIdSet.add(inOutRs.getString("outFMATERIALID"));
            }
            while (devRs.next()) {
                matIdSet.add(devRs.getString("FINMAT"));
                matIdSet.add(devRs.getString("FOUTMAT"));
            }
            Map matComMap = this.getMaterialCompanyCalcInfo(ctx, cou.getId().toString(), matIdSet);
            HashMap<String, Object[]> firstBizMap = new HashMap<String, Object[]>();
            inOutRs.beforeFirst();
            while (inOutRs.next()) {
                fromKey = this.getMd5CalKey(ctx, calType, inOutRs.getString("outFMATERIALID"), companyId, inOutRs.getString("outFSTORAGEORGUNITID"), inOutRs.getString("outFWAREHOUSEID"), inOutRs.getString("outFLOT"), inOutRs.getString("outFASSISTPROPERTYID"), inOutRs.getString("outFPROJECTID"), inOutRs.getString("outFTRACKNUMBERID"), matComMap);
                toKey = this.getMd5CalKey(ctx, calType, inOutRs.getString("inFMATERIALID"), companyId, inOutRs.getString("inFSTORAGEORGUNITID"), inOutRs.getString("inFWAREHOUSEID"), inOutRs.getString("inFLOT"), inOutRs.getString("inFASSISTPROPERTYID"), inOutRs.getString("inFPROJECTID"), inOutRs.getString("inFTRACKNUMBERID"), matComMap);
                fromToKey = inOutRs.getString("outFMATERIALID") + fromKey + inOutRs.getString("inFMATERIALID") + toKey;
                if (firstBizMap.containsKey(fromToKey)) {
                    firstBizDate = (Object[])firstBizMap.get(fromToKey);
                    if (((Date)firstBizDate[0]).compareTo(inOutRs.getDate("FBIZDATE")) > 0) {
                        firstBizDate[0] = inOutRs.getDate("FBIZDATE");
                        firstBizDate[1] = inOutRs.getDate("FAUDITTIME");
                        firstBizDate[2] = inOutRs.getString("inBillId");
                        continue;
                    }
                    if (((Date)firstBizDate[0]).compareTo(inOutRs.getDate("FBIZDATE")) != 0 || ((Date)firstBizDate[1]).compareTo(inOutRs.getDate("FAUDITTIME")) <= 0) continue;
                    firstBizDate[1] = inOutRs.getDate("FAUDITTIME");
                    firstBizDate[2] = inOutRs.getString("inBillId");
                    continue;
                }
                firstBizDate = new Object[]{inOutRs.getDate("FBIZDATE"), inOutRs.getDate("FAUDITTIME"), inOutRs.getString("inBillId")};
                firstBizMap.put(fromToKey, firstBizDate);
            }
            devRs.beforeFirst();
            while (devRs.next()) {
                toKey = this.getMd5CalKey(ctx, calType, devRs.getString("FINMAT"), companyId, devRs.getString("FINSOU"), devRs.getString("FINWAREHOUSE"), devRs.getString("FINLOT"), devRs.getString("FINASST"), devRs.getString("FINPROJECT"), devRs.getString("FINTRACKNUM"), matComMap);
                fromKey = this.getMd5CalKey(ctx, calType, devRs.getString("FOUTMAT"), companyId, devRs.getString("FOUTSOU"), devRs.getString("FOUTWAREHOUSE"), devRs.getString("FOUTLOT"), devRs.getString("FOUTASST"), devRs.getString("FOUTPROJECT"), devRs.getString("FOUTTRACKNUM"), matComMap);
                fromToKey = devRs.getString("FOUTMAT") + fromKey + devRs.getString("FINMAT") + toKey;
                if (firstBizMap.containsKey(fromToKey)) {
                    firstBizDate = (Object[])firstBizMap.get(fromToKey);
                    if (((Date)firstBizDate[0]).compareTo(devRs.getDate("FBIZDATE")) <= 0) continue;
                    firstBizDate[0] = devRs.getDate("FBIZDATE");
                    firstBizDate[1] = devRs.getDate("FCREATETIME");
                    firstBizDate[2] = devRs.getString("FID");
                    continue;
                }
                firstBizDate = new Object[]{devRs.getDate("FBIZDATE"), devRs.getDate("FCREATETIME"), devRs.getString("FID")};
                firstBizMap.put(fromToKey, firstBizDate);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID,FMATERIALFROM,FKEYFROM,FMATERIALTO,FKEYTO FROM t_cl_materialRelationStructure");
            sql.append(" where FCOMPANYORGUNITID = '").append(companyId).append("'");
            sql.append(" and FPERIODID = '").append(currentPeriodInfo.getId().toString()).append("'");
            IRowSet matRelationRs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            while (matRelationRs.next()) {
                String fromToKey2 = matRelationRs.getString("FMATERIALFROM") + matRelationRs.getString("FKEYFROM") + matRelationRs.getString("FMATERIALTO") + matRelationRs.getString("FKEYTO");
                if (!firstBizMap.containsKey(fromToKey2)) continue;
                Object[] firstBizDate2 = (Object[])firstBizMap.get(fromToKey2);
                Object[] updateParam = new Object[]{firstBizDate2[0], firstBizDate2[1], firstBizDate2[2], matRelationRs.getString("fid")};
                updateParamList.add(updateParam);
            }
            String updateSql = "update t_cl_materialRelationStructure set FBIZDATE = ?, FAUDITTIME = ?, FBILLID = ? where fid = ?";
            DBUtil.executeBatch((Context)ctx, (String)updateSql, updateParamList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _checkInCalc(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        companyId = "c6oAAAAAJKLM567U";
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Date beginDate = currentPeriodInfo.getBeginDate();
        Timestamp endDate = currentPeriodInfo.getEndDate();
        String periodId = currentPeriodInfo.getId().toString();
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT entry.FMATERIALID ,entry.FCOMPANYORGUNITID ,entry.FSTORAGEORGUNITID ,entry.FWAREHOUSEID,entry.FLOT ,entry.FASSISTPROPERTYID, ");
            sql.append(" entry.FPROJECTID ,entry.FTRACKNUMBERID, bill.FSOURCEBILLTYPEID FROM t_im_otherInwarehsBill bill ");
            sql.append(" INNER JOIN t_im_otherInwarehsBillEntry entry ON BILL.FID = ENTRY.FPARENTID");
            sql.append(" where entry.FCOMPANYORGUNITID = '").append(companyId).append("'");
            sql.append(" and entry.FBIZDATE >= to_date('").append(beginDate).append("')");
            sql.append(" and entry.FBIZDATE <= to_date('").append(endDate).append("')");
            sql.append(" and bill.FSOURCEBILLTYPEID in ").append(this.specialBillTypeId());
            IRowSet inRs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> matIdSet = new HashSet<String>();
            while (inRs.next()) {
                matIdSet.add(inRs.getString("FMATERIALID"));
            }
            Map materialCompanyCalcMap = this.getMaterialCompanyCalcInfo(ctx, companyId, matIdSet);
            inRs.beforeFirst();
            HashMap<String, int[]> needCalcMap = new HashMap<String, int[]>();
            while (inRs.next()) {
                int[] needCal;
                String calcKey = this.getMd5CalKey(ctx, calType, inRs.getString("FMATERIALID"), companyId, inRs.getString("FSTORAGEORGUNITID"), inRs.getString("FWAREHOUSEID"), inRs.getString("FLOT"), inRs.getString("FASSISTPROPERTYID"), inRs.getString("FPROJECTID"), inRs.getString("FTRACKNUMBERID"), materialCompanyCalcMap);
                String calcRankKey = inRs.getString("FMATERIALID") + ";" + calcKey;
                if (needCalcMap.containsKey(calcRankKey)) {
                    needCal = (int[])needCalcMap.get(calcRankKey);
                } else {
                    needCal = new int[3];
                    needCalcMap.put(calcRankKey, needCal);
                }
                if ("CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(inRs.getString("FSOURCEBILLTYPEID"))) {
                    needCal[0] = 1;
                    continue;
                }
                if ("CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(inRs.getString("FSOURCEBILLTYPEID"))) {
                    needCal[1] = 1;
                    continue;
                }
                if (!"50957179-0105-1000-e000-888880a812fd463ED552".equals(inRs.getString("FSOURCEBILLTYPEID"))) continue;
                needCal[2] = 1;
            }
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            Iterator iterator = needCalcMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object[] updateParam = new Object[7];
                Map.Entry entry = iterator.next();
                String[] matAndCalcKey = ((String)entry.getKey()).split(";");
                int[] needCal = (int[])entry.getValue();
                updateParam[0] = needCal[0];
                updateParam[1] = needCal[1];
                updateParam[2] = needCal[2];
                updateParam[3] = companyId;
                updateParam[4] = periodId;
                updateParam[5] = matAndCalcKey[0];
                updateParam[6] = matAndCalcKey[1];
                updateParamList.add(updateParam);
            }
            String updateSql = "update T_CL_MATERIALCALCRANK set FISASSEMBLECALC = ?, FISDISASSEMBLECALC = ?, FISMATCHANGECALC = ? where FCOMPANYORGUNITID = ? and FPERIODID = ? and FMATERIALID =? and FCALCULATEKEY = ?";
            DBUtil.executeBatch((Context)ctx, (String)updateSql, updateParamList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String specialBillTypeId() {
        StringBuffer s = new StringBuffer();
        s.append("('").append("50957179-0105-1000-e000-888880a812fd463ED552").append("','").append("CJeXjSzrKhfgU0ETqMA1nkY+1VI=").append("','").append("CJewLHpKKe/gU0ETqMDAp0Y+1VI=").append("')");
        return s.toString();
    }

    public Map getMaterialCompanyCalcInfo(Context ctx, String couId, Set matIdSet) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FMATERIALID, FISLOT, FISASSISTPROPERTY, FISPROJECT, FISTRACKNUMBER FROM t_bd_materialCompanyinfo ");
        sql.append("WHERE FCOMPANYID = '").append(couId).append("' and FACCOUNTTYPE = 5 ");
        sql.append("AND FMATERIALID IN ").append(this.convertIdSet2String(matIdSet));
        IRowSet matComRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap matComMap = new HashMap();
        while (matComRs.next()) {
            HashMap<String, Integer> specialCalKeyMap = new HashMap<String, Integer>();
            specialCalKeyMap.put("FISLOT", matComRs.getInt("FISLOT"));
            specialCalKeyMap.put("FISASSISTPROPERTY", matComRs.getInt("FISASSISTPROPERTY"));
            specialCalKeyMap.put("FISPROJECT", matComRs.getInt("FISPROJECT"));
            specialCalKeyMap.put("FISTRACKNUMBER", matComRs.getInt("FISTRACKNUMBER"));
            matComMap.put(matComRs.getString("FMATERIALID"), specialCalKeyMap);
        }
        return matComMap;
    }

    private IRowSet getInOutData(Context ctx, String companyId, Date beginDate, Date endDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT outEntry.FMATERIALID outFMATERIALID,outEntry.FCOMPANYORGUNITID ,outEntry.FSTORAGEORGUNITID outFSTORAGEORGUNITID,");
        sql.append(" outEntry.FWAREHOUSEID outFWAREHOUSEID,outEntry.FLOT outFLOT,outEntry.FASSISTPROPERTYID  outFASSISTPROPERTYID,");
        sql.append(" outEntry.FPROJECTID outFPROJECTID,outEntry.FTRACKNUMBERID outFTRACKNUMBERID,outBill.FYEAR outFYEAR,outBill.FPERIOD outFPERIOD, ");
        sql.append(" outEntry.FSOURCEBILLENTRYID,inEntry.FMATERIALID inFMATERIALID,inEntry.FSTORAGEORGUNITID inFSTORAGEORGUNITID,");
        sql.append(" inEntry.FWAREHOUSEID inFWAREHOUSEID,inEntry.FLOT inFLOT,inEntry.FASSISTPROPERTYID inFASSISTPROPERTYID,");
        sql.append(" inEntry.FPROJECTID inFPROJECTID,inEntry.FTRACKNUMBERID inFTRACKNUMBERID,inBill.FYEAR inFYEAR,outBill.FPERIOD inFPERIOD, ");
        sql.append(" inBill.FSOURCEBILLTYPEID, inBill.FBIZDATE, inbill.FAUDITTIME,inBill.fid inBillId ");
        sql.append(" FROM T_IM_OTHERINWAREHSBILL inBill");
        sql.append(" INNER JOIN T_IM_OTHERINWAREHSBILLENTRY inEntry ON INBILL.FID = INENTRY.FPARENTID");
        sql.append(" INNER JOIN T_IM_OTHERISSUEBILLENTRY outEntry on outEntry.FSOURCEBILLENTRYID = inEntry.FSOURCEBILLENTRYID  ");
        sql.append(" INNER JOIN T_IM_OTHERISSUEBILL outBill on outEntry.FPARENTID = outBill.FID ");
        sql.append(" WHERE inEntry.FBIZDATE >= to_date('").append(beginDate).append("')");
        sql.append(" and inEntry.FBIZDATE <= to_date('").append(endDate).append("')");
        sql.append(" AND inEntry.FCOMPANYORGUNITID = '").append(companyId).append("'");
        sql.append(" AND inBill.FSOURCEBILLTYPEID in").append(this.specialBillTypeId());
        sql.append(" and outEntry.FBIZDATE >= to_date('").append(beginDate).append("')");
        sql.append(" and outEntry.FBIZDATE <= to_date('").append(endDate).append("')");
        return DBUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getDevData(Context ctx, String companyId, int year, int period, Date beginDate, Date endDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("CREATE TABLE TBL (FID VARCHAR(44), FBIZDATE DateTime,FCREATETIME DateTime,FNUMBER NVARCHAR(80),FGROUPNO INT,FBILLTYPENUMBER NVARCHAR(44),FOUTMAT VARCHAR(44), FOUTSOU VARCHAR(44), FOUTWAREHOUSE VARCHAR(44), FOUTLOT NVARCHAR(80), FOUTASST VARCHAR(44), FOUTPROJECT VARCHAR(44), FOUTTRACKNUM VARCHAR(44), FINMAT VARCHAR(44), FINSOU VARCHAR(44), FINWAREHOUSE VARCHAR(44), FINLOT NVARCHAR(80), FINASST VARCHAR(44),FINPROJECT VARCHAR(44), FINTRACKNUM VARCHAR(44)) ");
        String tempTable = DBUtil.createTempTable(ctx, sql.toString());
        DBUtil.createTempTableIndex(ctx, tempTable, "FNUMBER,FGROUPNO", false, false);
        sql.setLength(0);
        sql.append("INSERT INTO ").append(tempTable).append(" (FID,FBIZDATE,FCREATETIME,FNUMBER,FGROUPNO,FBILLTYPENUMBER,FOUTMAT,FOUTSOU,FOUTWAREHOUSE,FOUTLOT,FOUTASST,");
        sql.append("FOUTPROJECT,FOUTTRACKNUM,FINMAT,FINSOU,FINWAREHOUSE,FINLOT,FINASST,FINPROJECT,FINTRACKNUM) ");
        sql.append("SELECT devGroup.FID,devGroup.FBIZDATE, devGroup.FCREATETIME,devGroup.FNUMBER,devRecord.FGROUPNO ,devRecord.FBILLTYPENUMBER ,outEntry.FMATERIALID,");
        sql.append("outEntry.FSTORAGEORGUNITID,outEntry.FWAREHOUSEID,outEntry.FLOT,");
        sql.append("outEntry.FASSISTPROPERTYID ,outEntry.FPROJECTID,outEntry.FTRACKNUMBERID,");
        sql.append("inEntry.FMATERIALID,inEntry.FSTORAGEORGUNITID,inEntry.FWAREHOUSEID,");
        sql.append("inEntry.FLOT,inEntry.FASSISTPROPERTYID,inEntry.FPROJECTID,inEntry.FTRACKNUMBERID ");
        sql.append("FROM T_CL_DEVOLVEWRITEOFFRECORD devRecord ");
        sql.append("INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP devGroup on devRecord.FPARENTID = devGroup.FID ");
        sql.append("LEFT JOIN T_IM_PURINWAREHSENTRY inEntry on inEntry.fid = devRecord.FBILLENTRYID ");
        sql.append(" and inEntry.FBIZDATE >= to_date('").append(beginDate).append("')");
        sql.append(" and inEntry.FBIZDATE <= to_date('").append(endDate).append("')");
        sql.append(" LEFT OUTER JOIN T_IM_MATERIALREQBILLENTRY outEntry on outEntry.FID = devRecord.FBILLENTRYID ");
        sql.append(" and outEntry.FBIZDATE >= to_date('").append(beginDate).append("')");
        sql.append(" and outEntry.FBIZDATE <= to_date('").append(endDate).append("')");
        sql.append(" WHERE devGrouP.FCOMPANYORGUNITID = '").append(companyId).append("' ");
        sql.append(" and devGrouP.FWRITEOFFPERIOD = ").append(period).append(" and devGrouP.FWRITEOFFYEAR = ").append(year);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" outTbl set (FINMAT,FINSOU,FINWAREHOUSE,FINLOT,FINASST,FINPROJECT,FINTRACKNUM) = ");
        sql.append("(select FINMAT,FINSOU,FINWAREHOUSE,FINLOT,FINASST,FINPROJECT,FINTRACKNUM from ").append(tempTable).append(" inTbl ");
        sql.append("where outTbl.FNUMBER = inTbl.FNUMBER and outTbl.FGROUPNO = inTbl.FGROUPNO and inTbl.FBILLTYPENUMBER = 103)");
        DBUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete ").append(tempTable).append(" where FBILLTYPENUMBER = 103");
        DBUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select * from ").append(tempTable);
        return DBUtil.executeQuery((Context)ctx, (String)sql.toString());
    }
}

