/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.onekey.app.AbstractOneKeyCalProductFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class OneKeyCalProductFacadeControllerBean
extends AbstractOneKeyCalProductFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.onekey.app.OneKeyCalProductFacadeControllerBean");
    private String loc = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams rptParams;
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.loc = this.getLoc(ctx);
        String companyId = params.getString("companyId");
        String tempTable = this.createTempTable(ctx, this.getCreateTempTableSql());
        String sumTempTable = this.createTempTable(ctx, this.getCreateSumTempTableSql());
        String inputMatTab = null;
        try {
            this.buildSumTempTableData(ctx, sumTempTable, params);
            if (this.isNCMStart(ctx, companyId)) {
                inputMatTab = this.getInputTemp(ctx, params);
                this.buildTempTableData(ctx, tempTable, sumTempTable, inputMatTab);
            }
            params.setString("tempTable", tempTable);
            rptParams = params;
        }
        catch (Throwable throwable) {
            this.dropTempTable(sumTempTable, ctx);
            this.dropTempTable(inputMatTab, ctx);
            throw throwable;
        }
        this.dropTempTable(sumTempTable, ctx);
        this.dropTempTable(inputMatTab, ctx);
        return rptParams;
    }

    private boolean isNCMStart(Context ctx, String companyId) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyId));
    }

    private String getCreateSumTempTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" CREATE TABLE TEMP (");
        sql.append(" FYEAR INT,");
        sql.append(" FPERIOD INT,");
        sql.append(" FISOUTCAL INT,");
        sql.append(" FCOMPANYID VARCHAR(44),");
        sql.append(" FSTORAGEID VARCHAR(44),");
        sql.append(" FWAREHOUSEID VARCHAR(44),");
        sql.append(" FMATERIALID VARCHAR(44),");
        sql.append(" FLOT NVARCHAR(255),");
        sql.append(" FASSISTPROPERTYID VARCHAR(44),");
        sql.append(" FPROJECTID VARCHAR(44),");
        sql.append(" FTRACKNUMBERID VARCHAR(44))");
        return sql.toString();
    }

    private String getInputTemp(Context ctx, RptParams params) throws EASBizException, BOSException {
        String inputMatTemp = null;
        StringBuilder sql = new StringBuilder();
        String companyId = params.getString("companyId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)period, (IObjectPK)new ObjectUuidPK(companyId));
        String ncmBalanceTbl = this.getNCMBalanceTabl(ctx, params);
        sql.append("CREATE TABLE TEMP ( FMATERIALID VARCHAR(44)) ");
        inputMatTemp = this.createTempTable(ctx, sql.toString());
        sql.setLength(0);
        if (!StringUtils.isEmpty((String)ncmBalanceTbl)) {
            sql.append(" INSERT INTO ").append(inputMatTemp).append(" (FMATERIALID) \n");
            sql.append(" SELECT DISTINCT MAT.FID FROM ").append(ncmBalanceTbl).append(" bala \n");
            sql.append(" INNER JOIN T_BD_COSTOBJECT COBJ ON BALA.FCOSTOBJECTID = COBJ.FID \n");
            sql.append(" INNER JOIN T_BD_MATERIAL MAT ON COBJ.FRELATEDID = MAT.FID \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        sql.append(" INSERT INTO ").append(inputMatTemp).append(" (FMATERIALID) \n");
        sql.append(" SELECT DISTINCT MAT.FID FROM T_NCM_INPUTQTYBILL BILL ");
        sql.append(" INNER JOIN T_NCM_INPUTQTYBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID ");
        sql.append(" INNER JOIN T_BD_COSTOBJECT COBJ ON ENTRY.FCOSTOBJECTID = COBJ.FID ");
        sql.append(" INNER JOIN T_BD_MATERIAL MAT ON COBJ.FRELATEDID = MAT.FID ");
        sql.append(" WHERE BILL.FCOMPANYORG = ? AND BILL.FCALCULATEPERIOD = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId, periodInfo.getId().toString()});
        sql.setLength(0);
        return inputMatTemp;
    }

    private String getNCMBalanceTabl(Context ctx, RptParams params) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder();
        String companyId = params.getString("companyId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        sql.append("SELECT FPHYSICALTBLNAME FROM T_NCM_DYNAMICTABLEMAP WHERE FCOMPANYID = ? AND FBUSINESSTBLNAME = 'T_NCM_BALANCE'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId});
        sql.setLength(0);
        String ncmBalanceTbl = null;
        try {
            if (rs.next()) {
                ncmBalanceTbl = rs.getString("FPHYSICALTBLNAME");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ncmBalanceTbl;
    }

    private void buildSumTempTableData(Context ctx, String sumTempTable, RptParams params) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" INSERT INTO ").append(sumTempTable);
        sql.append(" (FYEAR,FPERIOD,FCOMPANYID,FSTORAGEID,FWAREHOUSEID,FMATERIALID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) ");
        sql.append(" SELECT DISTINCT REPORT.FYEAR,REPORT.FPERIOD,REPORT.FCOMPANYORGUNITID,REPORT.FSTORAGEORGUNITID,REPORT.FWAREHOUSEID,REPORT.FMATERIALID,");
        sql.append(" REPORT.FLOT,REPORT.FASSISTPROPERTYID,REPORT.FPROJECTID,REPORT.FTRACKNUMBERID ");
        sql.append(" FROM T_CL_COSTCOMPUTEPRICEREPORT REPORT");
        sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MAC ON REPORT.FMATERIALID = MAC.FMATERIALID AND REPORT.FCOMPANYORGUNITID = MAC.FCOMPANYID ");
        sql.append(" WHERE MAC.FCALCULATETYPE = 2 AND REPORT.FCOMPANYORGUNITID = '").append(params.getString("companyId")).append("'");
        sql.append(" AND REPORT.FYEAR = ").append(params.getInt("year")).append(" AND REPORT.FPERIOD = ").append(params.getInt("period"));
        sql.append(" AND REPORT.FPARENTID = '").append(params.getString("reportHeaderId")).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" INSERT INTO ").append(sumTempTable);
        sql.append(" (FYEAR,FPERIOD,FCOMPANYID,FSTORAGEID,FWAREHOUSEID,FMATERIALID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) ");
        sql.append(" SELECT DISTINCT REPORT.FYEAR,REPORT.FPERIOD,REPORT.FCOMPANYID,REPORT.FSTORAGEID,REPORT.FWAREHOUSEID,REPORT.FMATERIALID,");
        sql.append(" REPORT.FLOT,REPORT.FASSISTPROPERTYID,REPORT.FPROJECTID,REPORT.FTRACKNUMBERID");
        sql.append(" FROM T_CL_ONEKEYCALCULATEREPORT REPORT");
        sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MAC ON REPORT.FMATERIALID = MAC.FMATERIALID AND REPORT.FCOMPANYID = MAC.FCOMPANYID ");
        sql.append(" WHERE MAC.FCALCULATETYPE = 2 AND REPORT.FCOMPANYID = '").append(params.getString("companyId")).append("'");
        sql.append(" AND REPORT.FYEAR = ").append(params.getInt("year")).append(" AND REPORT.FPERIOD = ").append(params.getInt("period"));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void buildTempTableData(Context ctx, String tempTable, String sumTempTable, String inputMatTab) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" INSERT INTO ").append(tempTable).append("(");
        sql.append(" FYEAR,FPERIOD,FCOMPANYNUMBER,FCOMPANYNAME,FSTORAGENUMBER,FSTORAGENAME, ");
        sql.append(" FWAREHOUSENUMBER,FWAREHOUSENAME,FMATERIALNUMBER,FMATERIALNAME, ");
        sql.append(" FLOT,FASSISTPROPERTY,FPROJECT,FTRACKNUMBER) ");
        sql.append(" SELECT ");
        sql.append(" REPORT.FYEAR FYEAR, REPORT.FPERIOD FPERIOD, ");
        sql.append(" COMPANY.FNUMBER FCOMPANYNUMBER, COMPANY.FNAME_").append(this.loc).append(" FCOMPANYNAME,");
        sql.append(" STORAGE.FNUMBER FSTORAGENUMBERF,STORAGE.FNAME_").append(this.loc).append(" STORAGENAME,");
        sql.append(" WAREHOUSE.FNUMBER FWAREHOUSENUMBER,WAREHOUSE.FNAME_").append(this.loc).append(" FWAREHOUSENAME,");
        sql.append(" material.fnumber FMATERIALNUMBER,material.FNAME_").append(this.loc).append(" FMATERIALNAME,");
        sql.append(" REPORT.FLOT,ASSPRO.FNAME_").append(this.loc).append(" FASSISTPROPERTY,");
        sql.append(" proj.fnumber FPROJECT,trackNum.fnumber FTRACKNUMBER ");
        sql.append(" FROM ").append(sumTempTable).append(" REPORT ");
        sql.append(" INNER JOIN T_ORG_COMPANY COMPANY ON REPORT.FCOMPANYID = COMPANY.FID");
        sql.append(" LEFT JOIN T_ORG_STORAGE STORAGE ON REPORT.FSTORAGEID = STORAGE.FID");
        sql.append(" LEFT JOIN T_DB_WAREHOUSE WAREHOUSE ON REPORT.FWAREHOUSEID = WAREHOUSE.FID");
        sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL ON REPORT.FMATERIALID = MATERIAL.FID");
        sql.append(" LEFT JOIN T_BD_ASSTATTRVALUE ASSPRO ON REPORT.FASSISTPROPERTYID = ASSPRO.FID");
        sql.append(" LEFT JOIN T_MM_PROJECT PROJ ON REPORT.FPROJECTID = PROJ.FID");
        sql.append(" LEFT JOIN T_MM_TRACKNUMBER TRACKNUM ON REPORT.FTRACKNUMBERID = TRACKNUM.FID");
        sql.append(" WHERE REPORT.FMATERIALID IN (SELECT FMATERIALID FROM ").append(inputMatTab).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getCreateTempTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" CREATE TABLE TEMP (");
        sql.append(" FYEAR INT,");
        sql.append(" FPERIOD INT,");
        sql.append(" FCOMPANYID VARCHAR(44),");
        sql.append(" FCOMPANYNUMBER NVARCHAR(80),");
        sql.append(" FCOMPANYNAME NVARCHAR(255),");
        sql.append(" FSTORAGENUMBER NVARCHAR(80),");
        sql.append(" FSTORAGENAME NVARCHAR(255),");
        sql.append(" FWAREHOUSENUMBER NVARCHAR(80),");
        sql.append(" FWAREHOUSENAME NVARCHAR(255),");
        sql.append(" FMATERIALNUMBER NVARCHAR(80),");
        sql.append(" FMATERIALNAME NVARCHAR(255),");
        sql.append(" FLOT NVARCHAR(255),");
        sql.append(" FASSISTPROPERTY NVARCHAR(255),");
        sql.append(" FPROJECT NVARCHAR(255),");
        sql.append(" FTRACKNUMBER NVARCHAR(255))");
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append(" FYEAR,FPERIOD,FCOMPANYNUMBER,FCOMPANYNAME,FMATERIALNUMBER,FMATERIALNAME, ");
        sql.append(" FSTORAGENUMBER,FSTORAGENAME,FWAREHOUSENUMBER,FWAREHOUSENAME, ");
        sql.append(" FLOT,FASSISTPROPERTY,FPROJECT,FTRACKNUMBER");
        sql.append(" FROM ").append(tempTable);
        sql.append(" ORDER BY FYEAR,FPERIOD,FCOMPANYNUMBER,FCOMPANYNAME,FMATERIALNUMBER,FMATERIALNAME");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        params.setObject("rowset", (Object)rs);
        return params;
    }
}

