/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.onekey.app.AbstractOneKeyComputeReportFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OneKeyComputeReportFacadeControllerBean
extends AbstractOneKeyComputeReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.onekey.app.OneKeyComputeReportFacadeControllerBean");
    private String loc = null;

    @Override
    protected List _getMaterialIdList(Context ctx, RptParams params) throws BOSException {
        ArrayList<String> materialIdList = new ArrayList<String>();
        String companyId = params.getString("companyId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT FMATERIALID FROM T_CL_ONEKEYCALCULATEREPORT \n");
        sql.append(" WHERE  FCOMPANYID = ? AND FYEAR = ? AND FPERIOD = ? ");
        sql.append(" AND FMATERIALID NOT IN (SELECT DISTINCT FMATERIALID FROM T_CL_ONEKEYCALCULATEREPORT ");
        sql.append(" WHERE  FCOMPANYID = ? AND FYEAR = ? AND FPERIOD = ? AND FSTATE <> 1 )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, year, period, companyId, year, period});
        try {
            while (rs.next()) {
                materialIdList.add(rs.getString("FMATERIALID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return materialIdList;
    }

    @Override
    protected RptParams _getMaterialData(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.loc = this.getLoc(ctx);
        String tempTable = this.createTempTable(ctx, this.getCreateTempTableSql());
        this.buildTempTableData(ctx, tempTable, params);
        RptParams result = this.builderResult(ctx, params, tempTable);
        return result;
    }

    private RptParams builderResult(Context ctx, RptParams params, String tempTable) throws BOSException, EASBizException {
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        String companyId = params.getString("companyId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        String materialId = params.getString("materialId");
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId));
        result.setObject("material", (Object)materialInfo);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getMaterialDataSql(), (Object[])new Object[]{companyId, year, period, materialId});
        try {
            if (rs.next()) {
                result.setInt("accountType", rs.getInt("FACCOUNTTYPE"));
                result.setString("calType", rs.getInt("FCALTYPE") + "");
                result.setString("baseUnitName", rs.getString("FBASEUNITNAME"));
                result.setBoolean("isLot", rs.getBoolean("FISLOT"));
                result.setBoolean("isAssistProp", rs.getBoolean("FISASSISTPROPERTY"));
                result.setBoolean("isProject", rs.getBoolean("FISPROJECT"));
                result.setBoolean("isTrackNumber", rs.getBoolean("FISTRACKNUMBER"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getMaterialDataSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT TOP 1  REPORT.FCALTYPE FCALTYPE ,REPORT.FACCOUNTTYPE FACCOUNTTYPE,BASEUNIT.FNAME_").append(this.loc).append(" FBASEUNITNAME,\n");
        sql.append(" MATCOM.FISLOT FISLOT,MATCOM.FISASSISTPROPERTY FISASSISTPROPERTY,MATCOM.FISPROJECT FISPROJECT,MATCOM.FISTRACKNUMBER  FISTRACKNUMBER").append("\n");
        sql.append(" FROM T_CL_ONEKEYCALCULATEREPORT REPORT ").append("\n");
        sql.append(" INNER JOIN T_BD_MATERIAL MAT ON REPORT.FMATERIALID = MAT.FID").append("\n");
        sql.append(" INNER JOIN T_BD_MEASUREUNIT BASEUNIT ON MAT.FBASEUNIT = BASEUNIT.FID").append("\n");
        sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MATCOM ON REPORT.FMATERIALID = MATCOM.FMATERIALID AND REPORT.FCOMPANYID = MATCOM.FCOMPANYID ").append("\n");
        sql.append(" WHERE REPORT.FCOMPANYID = ? AND  REPORT.FYEAR =? AND REPORT.FPERIOD= ? AND REPORT.FMATERIALID = ? ");
        return sql.toString();
    }

    private void buildTempTableData(Context ctx, String tempTable, RptParams params) throws BOSException {
        String companyId = params.getString("companyId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        String materialId = params.getString("materialId");
        StringBuilder sql = new StringBuilder();
        sql.append(this.getInsertTempTable(tempTable));
        sql.append(this.getSelectOneKeyRpt());
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, year, period, materialId});
    }

    private String getSelectOneKeyRpt() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT REPORT.FYEAR FYEAR,REPORT.FPERIOD FPERIOD,MAT.FNUMBER FMATERIALNUMBER,MAT.FNAME_").append(this.loc).append(" FMATERIALNAME,\n");
        sql.append(" STORG.FNAME_").append(this.loc).append(" FSTORAGENAME,WAREHS.FNAME_").append(this.loc).append(" FWAREHOUSENAME,REPORT.FLOT FLOT,").append("\n");
        sql.append(" ASSPRO.FNAME_").append(this.loc).append(" FASSISTPROPERTY,PROJ.FNUMBER FPROJECT,TRACKNUM.FNUMBER FTRACKNUMBER,REPORT.FBILLNAME FBILLNAME,").append("\n");
        sql.append(" REPORT.FBILLNUMBER FBILLNUMBER,REPORT.FINCOME FINCOME,REPORT.FPAYOUT FPAYOUT,REPORT.FSETTLEACCOUNTS FSETTLEACCOUNTS,").append("\n");
        sql.append(" REPORT.FPRICESOURCE FPRICESOURCE,REPORT.FCREATETIME FCREATETIME,REPORT.FTIMESERIALNUMBER FTIMESERIALNUMBER,REPORT.FID FID").append("\n");
        sql.append(" FROM T_CL_ONEKEYCALCULATEREPORT REPORT ").append("\n");
        sql.append(" INNER JOIN T_BD_MATERIAL MAT ON REPORT.FMATERIALID = MAT.FID").append("\n");
        sql.append(" LEFT JOIN T_ORG_STORAGE STORG ON REPORT.FSTORAGEID = STORG.FID").append("\n");
        sql.append(" LEFT JOIN T_DB_WAREHOUSE WAREHS ON REPORT.FWAREHOUSEID = WAREHS.FID").append("\n");
        sql.append(" LEFT JOIN T_BD_ASSTATTRVALUE ASSPRO ON REPORT.FASSISTPROPERTYID = ASSPRO.FID").append("\n");
        sql.append(" LEFT JOIN T_MM_PROJECT PROJ ON REPORT.FPROJECTID = PROJ.FID").append("\n");
        sql.append(" LEFT JOIN T_MM_TRACKNUMBER TRACKNUM ON REPORT.FTRACKNUMBERID = TRACKNUM.FID").append("\n");
        sql.append(" WHERE REPORT.FCOMPANYID = ? AND  REPORT.FYEAR =? AND REPORT.FPERIOD= ? AND REPORT.FMATERIALID = ? ");
        return sql.toString();
    }

    private String getInsertTempTable(String tempTable) {
        StringBuilder sql = new StringBuilder();
        sql.append(" INSERT INTO ").append(tempTable);
        sql.append(" ( FYEAR ,FPERIOD ,FMATERIALNUMBER ,FMATERIALNAME ,FSTORAGENAME ,FWAREHOUSENAME ,FLOT ,FASSISTPROPERTY ,");
        sql.append(" FPROJECT ,FTRACKNUMBER ,FBILLNAME ,FBILLNUMBER ,FINCOME ,FPAYOUT ,FSETTLEACCOUNTS ,FPRICESOURCE ,FCREATETIME,FTIMESERIALNUMBER,FID ) \n");
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FYEAR ,FPERIOD ,FMATERIALNUMBER ,FMATERIALNAME ,FSTORAGENAME ,FWAREHOUSENAME ,FLOT ,FASSISTPROPERTY ,");
        sql.append(" FPROJECT ,FTRACKNUMBER ,FBILLNAME ,FBILLNUMBER ,FINCOME ,FPAYOUT ,FSETTLEACCOUNTS ,FPRICESOURCE ,FID  \n");
        sql.append(" FROM ").append(tempTable).append("\n");
        sql.append(" ORDER BY FSTORAGENAME,FWAREHOUSENAME,FLOT,FASSISTPROPERTY,FPROJECT,FTRACKNUMBER,FCREATETIME,FTIMESERIALNUMBER,FID");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String getCreateTempTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" CREATE TABLE TEMP (");
        sql.append(" FYEAR INT,");
        sql.append(" FPERIOD INT,");
        sql.append(" FMATERIALNUMBER NVARCHAR(80),");
        sql.append(" FMATERIALNAME NVARCHAR(255),");
        sql.append(" FSTORAGENAME NVARCHAR(255),");
        sql.append(" FWAREHOUSENAME NVARCHAR(255),");
        sql.append(" FLOT NVARCHAR(255),");
        sql.append(" FASSISTPROPERTY NVARCHAR(255),");
        sql.append(" FPROJECT NVARCHAR(255),");
        sql.append(" FTRACKNUMBER NVARCHAR(255),");
        sql.append(" FBILLNAME NVARCHAR(255),");
        sql.append(" FBILLNUMBER NVARCHAR(80),");
        sql.append(" FINCOME NVARCHAR(255),");
        sql.append(" FPAYOUT NVARCHAR(255),");
        sql.append(" FSETTLEACCOUNTS NVARCHAR(255),");
        sql.append(" FPRICESOURCE NVARCHAR(255),");
        sql.append(" FCREATETIME DateTime,");
        sql.append(" FTIMESERIALNUMBER VARCHAR(20),");
        sql.append(" FID VARCHAR(44))");
        return sql.toString();
    }
}

