/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.calculateimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceCollection;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceFactory;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceInfo;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.onekey.BillTypeEnum;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.IOneKeyCalculate;
import com.kingdee.eas.scm.cal.onekey.OneKeyBalanceCostInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBillCostInfo;
import com.kingdee.eas.scm.cal.onekey.app.MatAttrChangeVO;
import com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateParams;
import com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateTempTableManager;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateHelper;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMRptUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractOneKeyCalculate
implements IOneKeyCalculate {
    public OneKeyCalculateTempTableManager tempManager = new OneKeyCalculateTempTableManager();
    public static final String NEWLINE = "\t\n";
    public static final String CALRESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";
    public OneKeyCalculateParams calParams = null;
    protected List<Map> updateMovLocList = new ArrayList<Map>();
    public static final int PERIOD_END = 3;
    public static final int PERIOD_START = 2;
    public static final int PERIOD_DIFF_APPORTION = 4;
    protected static final String RESOURCE = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";
    protected List<CalculateUnitInfo> calculateUnitList;
    protected static final int NEW_OUT_PRICE = 0;
    protected static final int NEW_IN_PRICE = 1;
    protected static final int STANDARD_PRICE = 2;
    protected static final int MANUAL_HAND = 3;
    protected static final int NEW_OUT_RETURN_PRICE = 4;
    protected String errorMsg;
    ThreadLocal<CostComputeReportPriceSourceCollection> reportColLocal = new ThreadLocal();
    CoreBaseCollection allReport = new CoreBaseCollection();
    Set<String> updateMoveLocMat = null;
    protected static final String[][] INVENTORYBILL_TABLENAME = new String[][]{{"T_IM_PurInWarehsEntry", "T_IM_PurInWarehsBill"}, {"T_IM_ManufactureRecBillEntry", "T_IM_ManufactureRecBill"}, {"T_IM_MoveInWarehsBillEntry", "T_IM_MoveInWarehsBill"}, {"T_IM_OtherInWarehsBillEntry", "T_IM_OtherInWarehsBill"}, {"T_IM_SaleIssueEntry", "T_IM_SaleIssueBill"}, {"T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill"}, {"T_IM_MoveIssueBillEntry", "T_IM_MoveIssueBill"}, {"T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill"}, {"T_CL_CostAdjustBillEntry", "T_CL_CostAdjustBill"}};

    @Override
    public void calculate(Context ctx, List<CalculateUnitInfo> calculateUnitList, OneKeyCalculateParams calParams) throws BOSException, EASBizException {
        this.calParams = calParams;
        this.calculateUnitList = calculateUnitList;
        this.errorMsg = SCMUtils.getResource((String)CALRESOURCE, (String)"COST_NOT_PRICE", (Context)ctx);
        this.initTempTable(ctx);
        this.beforeCalculate(ctx);
        this.calcBySubThread(ctx);
        this.afterCalculate(ctx);
    }

    protected ResultSet getBillRowSet(PreparedStatement preStmt, CalculateUnitInfo calculateUnitInfo) throws BOSException {
        try {
            Object[] sqlParams = this.getSqlParams(calculateUnitInfo);
            for (int i = 0; i < sqlParams.length; ++i) {
                preStmt.setObject(i + 1, sqlParams[i]);
            }
            return preStmt.executeQuery();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected PreparedStatement getBillPreparedStatement(Connection con, CalculateUnitInfo calculateUnitInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTableFIFOBills = this.tempManager.getInOutBillTemp();
        sql.append("select Bill.* from ").append(tempTableFIFOBills).append(" Bill ");
        sql.append(this.getBillWhere(calculateUnitInfo));
        sql.append(this.getBillSqlOrder());
        try {
            return con.prepareStatement(sql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getBillSqlOrder() {
        return "";
    }

    protected String getBillWhere(CalculateUnitInfo calculateUnitInfo) {
        String strCalType = this.calParams.getCalType();
        AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
        StringBuilder sql = new StringBuilder();
        sql.append(" WHERE Bill.FMATERIALID = ?").append(NEWLINE);
        if (strCalType.equals("1") && !StringUtils.isEmpty((String)calculateUnitInfo.getStorageOrgUnitId())) {
            sql.append(" AND Bill.FStorageOrgUnitID = ? ");
        }
        if (strCalType.equals("2")) {
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getStorageOrgUnitId())) {
                sql.append(" AND Bill.FStorageOrgUnitID = ? ");
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getWarehouseId())) {
                sql.append(" AND Bill.FWareHouseID = ? ");
            }
        }
        if (accountType == AccountType.SPECIAL_ACCT) {
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getLot())) {
                sql.append(" AND Bill.FLOT = ? ");
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getAssistPropertyId())) {
                sql.append(" AND Bill.FAssistPropertyID = ? ");
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getProjectId())) {
                sql.append(" AND Bill.FProjectID = ? ");
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getTrackNumberId())) {
                sql.append(" AND Bill.FTrackNumberID = ? ");
            }
        }
        return sql.toString();
    }

    protected void beforeCalculate(Context ctx) throws BOSException, EASBizException {
        if (this.calculateUnitList.size() > 1) {
            this.buildCalcUnitTempData(ctx, this.calculateUnitList);
        }
        this.clearOldReport(ctx);
        this.buildInOutBillsData(ctx);
        this.adjustPrePeriodData(ctx);
        this.buildPrePeriodCostMoveBill(ctx);
        this.getNeedUpdateMoveLocBillMaterial(ctx);
    }

    private void clearOldReport(Context ctx) throws EASBizException, BOSException {
        String companyId = this.calParams.getCompanyInfo().getId().toString();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String reportHeaderId = this.calParams.getReportHeaderInfo().getId().toString();
        String calType = this.calParams.getCalType();
        StringBuilder sql = new StringBuilder();
        if (this.calculateUnitList.size() > 1) {
            String calUnitTemp = this.tempManager.getCalUnitTemp();
            sql.append(" DELETE FROM T_CL_COSTCOMPUTEPRICEREPORT WHERE FID IN (");
            sql.append(" SELECT T0.FID FROM T_CL_COSTCOMPUTEPRICEREPORT T0 ");
            sql.append(" INNER JOIN t_bd_materialcompanyInfo T2 on ");
            sql.append(" T0.FMATERIALID = T2.fmaterialid and t0.FCOMPANYORGUNITID = t2.fcompanyid ");
            sql.append(" INNER JOIN ").append(calUnitTemp).append(" T1 ON ");
            sql.append(" T0.FCOMPANYORGUNITID = T1.FCOMPANYORGUNITID ");
            sql.append(" AND T0.FMATERIALID = T1.FMATERIALID ");
            if ("1".equals(calType)) {
                sql.append(" AND ISNULL(T0.FSTORAGEORGUNITID,'X') = ISNULL(T1.FSTORAGEORGUNITID,'X') ");
            }
            if ("2".equals(calType)) {
                sql.append(" AND ISNULL(T0.FSTORAGEORGUNITID,'X') = ISNULL(T1.FSTORAGEORGUNITID,'X') ");
                sql.append(" AND ISNULL(T0.FWAREHOUSEID,'X') = ISNULL(T1.FWAREHOUSEID,'X') ");
            }
            sql.append(" AND (CASE WHEN T2.FISLOT = 0 THEN 1 ");
            sql.append(" WHEN T2.FISLOT = 1 AND ISNULL(T0.FLot, N'null') = ISNULL(T1.FLot, N'null') THEN 1 ");
            sql.append(" ELSE 0 END) = 1 ");
            sql.append("  AND (CASE WHEN T2.FISASSISTPROPERTY = 0 THEN 1 ");
            sql.append(" WHEN T2.FISASSISTPROPERTY = 1 AND ISNULL(T0.FAssistPropertyID, 'null') = ISNULL(T1.FASSISTPROPERTYID, 'null') THEN 1 ");
            sql.append("\t\tELSE 0 END) = 1 ");
            sql.append("  AND (CASE WHEN T2.FISPROJECT = 0 THEN 1");
            sql.append(" WHEN T2.FISPROJECT = 1 AND ISNULL(T0.FProjectID, 'null') = ISNULL(T1.FPROJECTID, 'null') THEN 1 ");
            sql.append("      ELSE 0 END) = 1 ");
            sql.append("  AND (CASE WHEN T2.FISTRACKNUMBER = 0 THEN 1 ");
            sql.append(" WHEN T2.FISTRACKNUMBER = 1 AND ISNULL(T0.FTrackNumberID, 'null') = ISNULL(T1.FTRACKNUMBERID, 'null') THEN 1 ");
            sql.append("      ELSE 0 END) = 1 ");
            sql.append(" WHERE T0.FCOMPANYORGUNITID = ? AND T0.FYEAR = ? AND T0.FPERIOD = ? AND T0.FPARENTID = ?)");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber(), reportHeaderId});
        }
        if (this.calculateUnitList.size() == 1) {
            String strCalType = this.calParams.getCalType();
            AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
            CalculateUnitInfo calculateUnitInfo = this.calculateUnitList.get(0);
            ArrayList<Object> paramList = new ArrayList<Object>();
            sql.append(" DELETE FROM T_CL_CostComputePriceReport WHERE ");
            sql.append(" FCOMPANYORGUNITID = ? AND FYEAR = ? AND FPERIOD = ? ");
            sql.append(" AND FMATERIALID = ? ").append(NEWLINE);
            sql.append(" AND FPARENTID = ? ").append(NEWLINE);
            paramList.add(companyId);
            paramList.add(periodInfo.getPeriodYear());
            paramList.add(periodInfo.getPeriodNumber());
            paramList.add(calculateUnitInfo.getMaterialId());
            paramList.add(reportHeaderId);
            if (strCalType.equals("1") && !StringUtils.isEmpty((String)calculateUnitInfo.getStorageOrgUnitId())) {
                sql.append(" AND FSTORAGEORGUNITID = ? ");
                paramList.add(calculateUnitInfo.getStorageOrgUnitId());
            }
            if (strCalType.equals("2")) {
                if (!StringUtils.isEmpty((String)calculateUnitInfo.getStorageOrgUnitId())) {
                    sql.append(" AND FSTORAGEORGUNITID = ? ");
                    paramList.add(calculateUnitInfo.getStorageOrgUnitId());
                }
                if (!StringUtils.isEmpty((String)calculateUnitInfo.getWarehouseId())) {
                    sql.append(" AND FWareHouseID = ? ");
                    paramList.add(calculateUnitInfo.getWarehouseId());
                }
            }
            if (accountType == AccountType.SPECIAL_ACCT) {
                if (!StringUtils.isEmpty((String)calculateUnitInfo.getLot())) {
                    sql.append(" AND FLOT = ? ");
                    paramList.add(calculateUnitInfo.getLot());
                }
                if (!StringUtils.isEmpty((String)calculateUnitInfo.getAssistPropertyId())) {
                    sql.append(" AND FAssistPropertyID = ? ");
                    paramList.add(calculateUnitInfo.getAssistPropertyId());
                }
                if (!StringUtils.isEmpty((String)calculateUnitInfo.getProjectId())) {
                    sql.append(" AND FProjectID = ? ");
                    paramList.add(calculateUnitInfo.getProjectId());
                }
                if (!StringUtils.isEmpty((String)calculateUnitInfo.getTrackNumberId())) {
                    sql.append(" AND FTrackNumberID = ? ");
                    paramList.add(calculateUnitInfo.getTrackNumberId());
                }
            }
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        }
    }

    private void buildCalcUnitTempData(Context ctx, List<CalculateUnitInfo> calculateUnitList) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            StringBuilder sql = new StringBuilder();
            ArrayList param = new ArrayList();
            sql.append("insert into ").append(this.tempManager.getCalUnitTemp());
            sql.append(" (FMATERIALID,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) values(?,?,?,?,?,?,?,?)");
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            int count = 0;
            for (int i = 0; i < calculateUnitList.size(); ++i) {
                CalculateUnitInfo calcInfo = calculateUnitList.get(i);
                stmt.setObject(1, calcInfo.getMaterialId());
                stmt.setObject(2, calcInfo.getCompanyOrgUnitId());
                stmt.setObject(3, calcInfo.getStorageOrgUnitId());
                stmt.setObject(4, calcInfo.getWarehouseId());
                stmt.setObject(5, calcInfo.getLot());
                stmt.setObject(6, calcInfo.getAssistPropertyId());
                stmt.setObject(7, calcInfo.getProjectId());
                stmt.setObject(8, calcInfo.getTrackNumberId());
                stmt.addBatch();
                if (++count != 500) continue;
                count = 0;
                stmt.executeBatch();
                stmt.clearBatch();
            }
            if (count > 0) {
                stmt.executeBatch();
            }
            KsqlUtil.analyseTable((Context)ctx, (Connection)conn, (String)this.tempManager.getCalUnitTemp());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected OneKeyBillCostInfo convertOneKeyBillCostInfo(ResultSet rs, long timeSerialNumber) throws SQLException {
        String strCalType = this.calParams.getCalType();
        boolean isLot = OneKeyCalculateParams.accountTypeThreadLocal.get() == AccountType.SPECIAL_ACCT;
        PeriodInfo currPeriod = this.calParams.getPeriodInfo();
        OneKeyBillCostInfo bill = new OneKeyBillCostInfo();
        bill.setPrice(rs.getBigDecimal("FPrice").setScale(rs.getInt("FPricePrecision"), 4));
        bill.setActualCost(rs.getBigDecimal("FActualCost").setScale(rs.getInt("FLocalCurrencyPrecision"), 4));
        bill.setBaseQty(rs.getBigDecimal("FBaseQty").setScale(rs.getInt("FQtyPrecision"), 4));
        bill.setRedBill(bill.getBaseQty().signum() < 0);
        bill.setPricePrecision(rs.getInt("FPricePrecision"));
        bill.setBaseCurrencyPrecision(rs.getInt("FLocalCurrencyPrecision"));
        bill.setQtyPrecision(rs.getInt("FQtyPrecision"));
        bill.setBillEntryId(rs.getString("FBillEntryId"));
        bill.setBillId(rs.getString("FBillId"));
        bill.setEntryTableMame(rs.getString("FEntryTableMame"));
        bill.setBillNumber(rs.getString("FNumber"));
        if (rs.getInt("FisWriteOffVouched") == 1) {
            bill.setFiVouchered(1);
        } else {
            bill.setFiVouchered(rs.getInt("FFiVouchered"));
        }
        bill.setTimeSerialNumber(timeSerialNumber);
        bill.setReverseQty(rs.getBigDecimal("FReverseQty"));
        bill.setBaseQtyBak(rs.getBigDecimal("FBaseQtyBak"));
        bill.setCalculateKind(rs.getInt("FCalculateKind"));
        bill.setReverseQty(rs.getBigDecimal("freverseqty"));
        bill.setStorageOrgUnitId(rs.getString("FStorageOrgUnitId"));
        bill.setWarehouseId(rs.getString("FWarehouseId"));
        bill.setMaterialId(rs.getString("FMaterialID"));
        bill.setCompanyOrgUnitId(rs.getString("FCompanyOrgUnitID"));
        bill.setBillTypeId(rs.getString("FBillTypeID"));
        bill.setBizDate(rs.getTimestamp("FBizDate"));
        bill.setBizTypeId(rs.getString("FBizTypeId"));
        String billTypeName = "";
        billTypeName = "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getBillTypeId()) ? rs.getString("FBillTypeName") : rs.getString("FBillTypeName") + " - " + rs.getString("FTransactionTypeName");
        if ("T_IM_InventoryBalance".equals(rs.getString("FEntryTableMame"))) {
            billTypeName = "";
        }
        bill.setBillTypeName(billTypeName);
        bill.setDealComplete(false);
        bill.setMinusSettleAccount(false);
        bill.setAddUpQty(CalculateUtil.ZERO);
        bill.setAddUpAmount(CalculateUtil.ZERO);
        bill.setBillTypeId(rs.getString("FBillTypeID"));
        bill.setSourceBillEntryId(rs.getString("FSourceBillEntryID"));
        bill.setSourceUnitActualCost(rs.getBigDecimal("FSourceUnitActualCost"));
        bill.setActualCostBak(rs.getBigDecimal("FActualCostBak"));
        bill.setMaterialNumber(rs.getString("FmaterialNumber"));
        bill.setIsCombition(rs.getInt("FisCombition"));
        bill.setSrcBilInCurrPid(rs.getInt("FisSrcBilInCurrPid"));
        bill.setLot(rs.getString("FLot"));
        bill.setStrCalType(this.calParams.getCalType());
        bill.setSourceBillTypeId(rs.getString("FSourceBillTypeID"));
        bill.setReversed(rs.getInt("FIsReversed") == 1);
        bill.setCalculate(true);
        bill.setAssistPropertyId(rs.getString("FAssistPropertyID"));
        bill.setProjectId(rs.getString("FProjectID"));
        bill.setTrackNumberId(rs.getString("FTrackNumberID"));
        bill.setKeyId(this.getCalTypeKey(bill, strCalType, isLot));
        bill.setCswKeyId(this.getCSWKey(bill));
        bill.setReWork(rs.getInt("FIsReWork") == 1);
        bill.setStoreTypeId(rs.getString("FStoreTypeID"));
        bill.setStoreTypePreId(rs.getString("FStoreTypePreID"));
        bill.setBaseUnitId(rs.getString("FBaseUnit"));
        bill.setUnitId(rs.getString("FUnitID"));
        bill.setQty(rs.getBigDecimal("FQty"));
        bill.setWrittenOffBaseQty(rs.getBigDecimal("FWrittenOffBaseQty"));
        bill.setUnWriteOffBaseQty(rs.getBigDecimal("FUnWriteOffBaseQty"));
        bill.setStockTransBillEntryId(rs.getString("FStockTransBillEntryID"));
        bill.setBillEntryId(rs.getString("FBillEntryId"));
        bill.setSourceBillEntryId(rs.getString("FSourceBillEntryID"));
        bill.setBaseConvsRate(rs.getBigDecimal("FBASECONVSRATE"));
        bill.setStockClose(7 == rs.getInt("FStockStatus"));
        bill.setStockCloseInAfterPeriod(rs.getInt("FStockClosePeriod") > currPeriod.getNumber());
        return bill;
    }

    private String getCSWKey(OneKeyBillCostInfo bill) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bill.getCompanyOrgUnitId());
        if (bill.getStorageOrgUnitId() != null) {
            buffer.append("_$$$$_").append(bill.getStorageOrgUnitId());
        }
        if (bill.getWarehouseId() != null) {
            buffer.append("_$$$$_").append(bill.getWarehouseId());
        }
        return buffer.toString();
    }

    protected String getCalTypeKey(OneKeyBillCostInfo bill, String strCalType, boolean isAddLot) {
        StringBuffer buffer = new StringBuffer();
        if ("0".equals(strCalType)) {
            buffer.append(bill.getCompanyOrgUnitId());
        } else if ("1".equals(strCalType)) {
            buffer.append(bill.getCompanyOrgUnitId());
            if (bill.getStorageOrgUnitId() != null) {
                buffer.append("_$$$$_").append(bill.getStorageOrgUnitId());
            }
        } else {
            buffer.append(bill.getCompanyOrgUnitId());
            if (bill.getStorageOrgUnitId() != null) {
                buffer.append("_$$$$_").append(bill.getStorageOrgUnitId());
            }
            if (bill.getWarehouseId() != null) {
                buffer.append("_$$$$_").append(bill.getWarehouseId());
            }
        }
        if (isAddLot) {
            buffer.append(this.getCalModelKey(bill.getLot()));
            buffer.append(this.getCalModelKey(bill.getAssistPropertyId()));
            buffer.append(this.getCalModelKey(bill.getProjectId()));
            buffer.append(this.getCalModelKey(bill.getTrackNumberId()));
        }
        return buffer.toString();
    }

    protected StringBuffer getCalModelKey(String calModelKey) {
        StringBuffer calModelSb = new StringBuffer();
        if (!StringUtils.isEmpty((String)calModelKey)) {
            calModelSb.append("_$$$$_").append(calModelKey);
        } else {
            calModelSb.append("_$$$$_").append("X");
        }
        return calModelSb;
    }

    protected void afterCalculate(Context ctx) throws BOSException, EASBizException {
        this.handleOtherData(ctx);
        this.tempManager.releaseTempTables(ctx);
        if (this.updateMoveLocMat != null) {
            this.updateMoveLocMat.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReport(Context ctx) throws EASBizException, BOSException {
        if (this.reportColLocal.get() != null && !this.reportColLocal.get().isEmpty()) {
            CoreBaseCollection coreBaseCollection = this.allReport;
            synchronized (coreBaseCollection) {
                this.allReport.addObjectCollection((IObjectCollection)this.reportColLocal.get());
                if (this.allReport.size() > 1000) {
                    CostComputeReportPriceSourceFactory.getLocalInstance(ctx).addnewBatchData(this.allReport);
                    this.allReport.clear();
                }
            }
        }
        this.reportColLocal.remove();
    }

    protected void handleOtherData(Context ctx) throws BOSException {
        String tempTableName = this.tempManager.getInOutBillTemp();
        DbUtil.execute((Context)ctx, (String)this.getInsertWriteoffRecordSql(tempTableName));
        DbUtil.execute((Context)ctx, (String)this.updateWriteOffRecordPriceSQL("T_IM_SaleIssueEntry"));
        DbUtil.execute((Context)ctx, (String)this.updateWriteOffRecordMantissaSQL("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"));
        DbUtil.execute((Context)ctx, (String)this.updateWriteOffRecordMantissaNextSQL("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"));
        DbUtil.execute((Context)ctx, (String)this.getTempDataBillSQL(ctx));
        DbUtil.execute((Context)ctx, (String)this.handleReqBillCompJump());
        DbUtil.execute((Context)ctx, (String)this.handleReqBillStorageJump());
        this.handleDevWriteOffRecord(ctx, tempTableName);
        this.handleMovLocBill(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMovLocBill(Context ctx) throws BOSException {
        if ("0".equals(this.calParams.getCalMoveLocationBill()) || this.updateMovLocList.isEmpty()) {
            return;
        }
        String newPricetempTable = null;
        try {
            newPricetempTable = this.getNewPriceData(ctx, CalculateKindEnum.OUTPUT_WAREHOUSE);
            int currencyPrecision = this.calParams.getBaseCurrencyPrecision();
            PeriodInfo periodInfo = this.calParams.getPeriodInfo();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
            String companyOrgID = this.calParams.getCompanyInfo().getId().toString();
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("UPDATE T_IM_MOVELOCATIONBILLENTRY T SET (FPRICE,FAMOUNT) = (SELECT ");
            updateSql.append(" Round(ROUND(ENTRY.FBASEQTY * TMP.FBaseUnitActualCost,").append(currencyPrecision).append(")/ENTRY.FQTY,MAT.FPRICEPRECISION),");
            updateSql.append(" ROUND(ENTRY.FBASEQTY * TMP.FBaseUnitActualCost,").append(currencyPrecision).append(")");
            updateSql.append(" FROM T_IM_MOVELOCATIONBILLENTRY ENTRY ");
            updateSql.append(" INNER JOIN T_IM_MOVELOCATIONBILL BILL ON BILL.FID = ENTRY.FPARENTID ");
            updateSql.append(" INNER JOIN t_bd_material MAT ON MAT.FID = ENTRY.FMATERIALID ");
            updateSql.append(" INNER JOIN t_bd_materialCompanyInfo MC ON MC.FMATERIALID = ENTRY.FMATERIALID ");
            updateSql.append(" AND MC.FCOMPANYID = ENTRY.FCOMPANYORGUNITID ");
            updateSql.append(" INNER JOIN ( ").append(this.getTheNewPriceSql(newPricetempTable)).append(" ) TMP ON TMP.FMATERIALID = ENTRY.FMATERIALID ");
            if (!this.calParams.getCalType().equals("0")) {
                updateSql.append(" AND TMP.FSTORAGEORGUNITID = ENTRY.FSTORAGEORGUNITID ");
            }
            if (this.calParams.getCalType().equals("2")) {
                updateSql.append(" AND TMP.FWAREHOUSEID = ENTRY.FWAREHOUSEID ");
            }
            updateSql.append(" AND (CASE WHEN MC.FISLOT = 0 THEN 1 ");
            updateSql.append(" WHEN MC.FISLOT = 1 AND ISNULL(TMP.FLot, N'null') = ISNULL(ENTRY.FLot, N'null') THEN 1 ");
            updateSql.append(" ELSE 0 END) = 1 ");
            updateSql.append("  AND (CASE WHEN MC.FISASSISTPROPERTY = 0 THEN 1 ");
            updateSql.append(" WHEN MC.FISASSISTPROPERTY = 1 AND ISNULL(TMP.FAssistPropertyID, 'null') = ISNULL(ENTRY.FASSISTPROPERTYID, 'null') THEN 1 ");
            updateSql.append("\t\tELSE 0 END) = 1 ");
            updateSql.append("  AND (CASE WHEN MC.FISPROJECT = 0 THEN 1");
            updateSql.append(" WHEN MC.FISPROJECT = 1 AND ISNULL(TMP.FProjectID, 'null') = ISNULL(ENTRY.FPROJECTID, 'null') THEN 1 ");
            updateSql.append("      ELSE 0 END) = 1 ");
            updateSql.append("  AND (CASE WHEN MC.FISTRACKNUMBER = 0 THEN 1 ");
            updateSql.append(" WHEN MC.FISTRACKNUMBER = 1 AND ISNULL(TMP.FTrackNumberID, 'null') = ISNULL(ENTRY.FTRACKNUMBERID, 'null') THEN 1 ");
            updateSql.append("      ELSE 0 END) = 1 ");
            updateSql.append(" WHERE BILL.FBASESTATUS = 4 ");
            updateSql.append(" AND ENTRY.FCOMPANYORGUNITID ='").append(companyOrgID).append("'");
            updateSql.append(" AND ENTRY.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            updateSql.append(" AND ENTRY.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            updateSql.append(" AND BILL.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            updateSql.append(" AND BILL.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            updateSql.append(" AND T.FID = ENTRY.FID )");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)newPricetempTable);
            this.updateMovLocList.clear();
        }
    }

    protected StringBuffer getTheNewPriceSql(String newPriceTmpTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("  SELECT Max(middle.FBaseUnitActualCost) AS FBaseUnitActualCost,middle.FMaterialID").append(NEWLINE);
        sql.append(this.getCalTypeSelectSql("middle.", false)).append(NEWLINE);
        sql.append("  FROM ").append(newPriceTmpTable).append(" middle").append(NEWLINE);
        sql.append("  INNER JOIN (").append(NEWLINE);
        sql.append(" \tSelect MAX(FBizDate) as FBizDate, FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeGroupSql("")).append(NEWLINE);
        sql.append(" \tFROM ").append(newPriceTmpTable).append(NEWLINE);
        sql.append(" \tGroup by FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeGroupSql("")).append(NEWLINE);
        sql.append("  ) maxBizDate on middle.FMaterialID = maxBizDate.FMaterialID and maxBizDate.FBizDate = middle.FBizDate").append(NEWLINE);
        sql.append(this.getCalTypeJoinSql("maxBizDate", "middle")).append(NEWLINE);
        sql.append("  Group by middle.FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeGroupSql("middle.")).append(NEWLINE);
        return sql;
    }

    private String getCalTypeJoinSql(String subTableName, String nextTableName) {
        return this.getCalTypeJoinSql(subTableName, nextTableName, false);
    }

    private String getCalTypeJoinSql(String subTableName, String nextTableName, Boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if ("1".equals(this.calParams.getCalType()) || "2".equals(this.calParams.getCalType())) {
            sql.append("\n AND ").append(subTableName).append(".FSTORAGEORGUNITID = ").append(nextTableName).append(".FSTORAGEORGUNITID ");
        }
        if ("2".equals(this.calParams.getCalType())) {
            sql.append("\n AND ").append(subTableName).append(".FWAREHOUSEID = ").append(nextTableName).append(".FWAREHOUSEID ");
        }
        if (isAddLot.booleanValue()) {
            sql.append("\n AND isnull(").append(subTableName).append(".FLot,N'NULLID') = (case when MATERIALCOMPANY.Fislot  = 1 then isnull(").append(nextTableName).append(".FLot,N'NULLID') else N'NULLID' end)");
            sql.append("\n AND isnull(").append(subTableName).append(".FAssistPropertyID,'NULLID') = (case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then isnull(").append(nextTableName).append(".FAssistPropertyID,'NULLID') else 'NULLID' end)");
            sql.append("\n AND isnull(").append(subTableName).append(".FProjectID,'NULLID') = (case when MATERIALCOMPANY.FISPROJECT = 1 then isnull(").append(nextTableName).append(".FProjectID,'NULLID') else 'NULLID' end) ");
            sql.append("\n AND isnull(").append(subTableName).append(".FTrackNumberID,'NULLID') = (case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then isnull(").append(nextTableName).append(".FTrackNumberID,'NULLID') else 'NULLID' end) ");
        } else {
            sql.append("\n AND isnull(").append(subTableName).append(".FLot,N'NULLID') = isnull(").append(nextTableName).append(".FLot,N'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FAssistPropertyID,'NULLID') = isnull(").append(nextTableName).append(".FAssistPropertyID,'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FProjectID,'NULLID') = isnull(").append(nextTableName).append(".FProjectID,'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FTrackNumberID,'NULLID') = isnull(").append(nextTableName).append(".FTrackNumberID,'NULLID') ");
        }
        return sql.toString();
    }

    private String getCalTypeGroupSql(String tableNameWithdot) {
        return this.getCalTypeGroupSql(tableNameWithdot, false);
    }

    private String getCalTypeGroupSql(String tableNameWithdot, Boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if ("1".equals(this.calParams.getCalType()) || "2".equals(this.calParams.getCalType())) {
            sql.append(",").append(tableNameWithdot).append("FSTORAGEORGUNITID ");
        }
        if ("2".equals(this.calParams.getCalType())) {
            sql.append(",").append(tableNameWithdot).append("FWAREHOUSEID ");
        }
        if (isAddLot.booleanValue()) {
            sql.append(", case when MATERIALCOMPANY.FISLOT = 1 then ").append(tableNameWithdot).append("FLot else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then ").append(tableNameWithdot).append("FAssistPropertyID else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISPROJECT = 1 then ").append(tableNameWithdot).append("FProjectID else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then ").append(tableNameWithdot).append("FTrackNumberID else null end  ");
        } else {
            sql.append(",").append(tableNameWithdot).append("FLot ");
            sql.append(",").append(tableNameWithdot).append("FAssistPropertyID ");
            sql.append(",").append(tableNameWithdot).append("FProjectID ");
            sql.append(",").append(tableNameWithdot).append("FTrackNumberID ");
        }
        return sql.toString();
    }

    private String getCalTypeSelectSql(String tableNameWithdot, Boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if ("1".equals(this.calParams.getCalType()) || "2".equals(this.calParams.getCalType())) {
            sql.append(",").append(tableNameWithdot).append("FSTORAGEORGUNITID ");
        }
        if ("2".equals(this.calParams.getCalType())) {
            sql.append(",").append(tableNameWithdot).append("FWAREHOUSEID ");
        }
        if (isAddLot.booleanValue()) {
            sql.append(", case when MATERIALCOMPANY.FISLOT = 1 then ").append(tableNameWithdot).append("FLot else null end  FLot ");
            sql.append(", case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then ").append(tableNameWithdot).append("FAssistPropertyID else null end FAssistPropertyID ");
            sql.append(", case when MATERIALCOMPANY.FISPROJECT = 1 then ").append(tableNameWithdot).append("FProjectID else null end FProjectID ");
            sql.append(", case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then ").append(tableNameWithdot).append("FTrackNumberID else null end FTrackNumberID ");
        } else {
            sql.append(",").append(tableNameWithdot).append("FLot ");
            sql.append(",").append(tableNameWithdot).append("FAssistPropertyID ");
            sql.append(",").append(tableNameWithdot).append("FProjectID ");
            sql.append(",").append(tableNameWithdot).append("FTrackNumberID ");
        }
        return sql.toString();
    }

    private String getUpdateMovLocTemp(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create table tempTable (").append("\r\n");
        sql.append("FmaterialId VARCHAR(44),").append("\r\n");
        sql.append("FcompanyOrgUnitID VARCHAR(44),").append("\r\n");
        sql.append("FstorageOrgUnitID VARCHAR(44),").append("\r\n");
        sql.append("FwareHouseID VARCHAR(44),").append("\r\n");
        sql.append("FLot VARCHAR(44),").append("\r\n");
        sql.append("FAssistPropertyID VARCHAR(44),").append("\r\n");
        sql.append("FProjectID VARCHAR(44),").append("\r\n");
        sql.append("FTrackNumberID VARCHAR(44))").append("\r\n");
        String tempTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("Insert Into ").append(tempTable).append(" ( ");
        sql.append(" FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID");
        sql.append(",FLOT,FAssistPropertyID,FProjectID,FTrackNumberID ) ");
        sql.append(" VALUES(?,?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            for (Map map : this.updateMovLocList) {
                ps.setString(1, (String)map.get("materialId"));
                ps.setString(2, (String)map.get("companyOrgUnitID"));
                ps.setString(3, (String)map.get("storageOrgUnitID"));
                ps.setString(4, (String)map.get("wareHouseID"));
                ps.setString(5, (String)map.get("Lot"));
                ps.setString(6, (String)map.get("AssistPropertyID"));
                ps.setString(7, (String)map.get("ProjectID"));
                ps.setString(8, (String)map.get("TrackNumberID"));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return tempTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewPriceData(Context ctx, CalculateKindEnum calKind) throws BOSException {
        String middlTempTableName = DBUtil.createTempTable(ctx, this.getCreateNewPriceMiddleTempTableSQL("NewPriceMiddleTable"));
        String tempTable = this.getUpdateMovLocTemp(ctx);
        int calType = Integer.parseInt(this.calParams.getCalType());
        int start = 0;
        int end = 4;
        if (CalculateKindEnum.OUTPUT_WAREHOUSE == calKind) {
            start = 4;
            end = 8;
        }
        StringBuffer sql = new StringBuffer();
        String maxBizDateTemp = DBUtil.createTempTable(ctx, this.getCreateMiddleTempTableSQL("maxBizDateTemp"));
        try {
            for (int i = start; i < end; ++i) {
                DBUtil.execute((Context)ctx, (String)("truncate table " + maxBizDateTemp));
                this.insertTempTable(ctx, INVENTORYBILL_TABLENAME[i], calKind.getValue(), maxBizDateTemp, tempTable);
                sql.setLength(0);
                sql.append(this.getInsertNewPriceSQL(calType, middlTempTableName));
                sql.append(this.getSingleBillNewPriceSQL(calType, INVENTORYBILL_TABLENAME[i], calKind.getValue(), maxBizDateTemp));
                DBUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)maxBizDateTemp);
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
        }
        return middlTempTableName;
    }

    private String getSingleBillNewPriceSQL(int calType, String[] tabName, int billType, String tempTable) {
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("Select ENTRY.FMaterialId, ENTRY.FBizDate").append(NEWLINE);
        sql.append(this.getCalTypeSelectSql(calType, "ENTRY.", true));
        sql.append(", MAX(CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0)").append(NEWLINE);
        sql.append("ELSE TO_DECIMAL(TO_DECIMAL(ENTRY.FActualCost, 17, 4)/ENTRY.FBaseQty, 21, 8) END) AS FBaseUnitActualCost").append(NEWLINE);
        sql.append("FROM ").append(tabName[0]).append(" ENTRY").append(NEWLINE);
        sql.append("INNER JOIN ").append(tabName[1]).append(" BILL ON BILL.FID = ENTRY.FParentID ").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MATERIALCOMPANY ");
        sql.append(" ON MATERIALCOMPANY.FMATERIALID = ENTRY.FMATERIALID AND MATERIALCOMPANY.FCOMPANYID = ENTRY.FCOMPANYORGUNITID ").append(NEWLINE);
        sql.append(this.getSqlJoinByBillType(billType));
        sql.append("INNER JOIN ").append(NEWLINE);
        sql.append(tempTable);
        sql.append(" maxBizDate ON maxBizDate.fbizdate = ENTRY.FBizDate and maxBizDate.FMaterialId = ENTRY.FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeJoinSql(calType, "maxBizDate", "ENTRY", true));
        sql.append(this.getBillBaseWhereSql(false));
        sql.append(" AND SCMTRANSACTIONTYPE.FIsCalculate = 1").append(NEWLINE);
        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
        sql.append(this.getCalUnitWhereFilter());
        if (!this.calParams.isCalculteCostPriceMovein() && INVENTORYBILL_TABLENAME[6][0].equals(tabName[0])) {
            sql.append(" AND BILL.FBizTypeID NOT IN (");
            sql.append("'").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(")").append(NEWLINE);
        }
        sql.append("AND Entry.FUnitActualCost > 0").append(NEWLINE);
        sql.append("GROUP BY ENTRY.FMaterialId, ENTRY.FBizDate").append(NEWLINE);
        sql.append(this.getCalTypeGroupSql(calType, "ENTRY.", true));
        return sql.toString();
    }

    private String getInsertNewPriceSQL(int calType, String middlTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(middlTempTableName).append("(FMaterialId, FBizDate").append(this.getCalTypeGroupSql(calType, "", false)).append(",FBaseUnitActualCost)").append(NEWLINE);
        return sql.toString();
    }

    private void insertTempTable(Context ctx, String[] tabName, int billType, String maxBizDateTemp, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        int calType = Integer.parseInt(this.calParams.getCalType());
        sql.append("insert into ").append(maxBizDateTemp).append(NEWLINE);
        sql.append("(FBizDate,FMaterialId").append(NEWLINE);
        if (calType == 1 || calType == 2) {
            sql.append(",FSTORAGEORGUNITID").append(NEWLINE);
        }
        if (calType == 2) {
            sql.append(",FWAREHOUSEID").append(NEWLINE);
        }
        sql.append(",FLot,FAssistPropertyID,FProjectID,FTrackNumberID)").append(NEWLINE);
        sql.append("Select MAX(ENTRY.FBizDate) bizdate,ENTRY.FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeSelectSql(calType, "ENTRY.", true));
        sql.append(" FROM ").append(tabName[0]).append(" ENTRY").append(NEWLINE);
        sql.append(" INNER JOIN ").append(tabName[1]).append(" BILL ON BILL.FID = ENTRY.FParentID ").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MATERIALCOMPANY ");
        sql.append(" ON MATERIALCOMPANY.FMATERIALID = ENTRY.FMATERIALID AND MATERIALCOMPANY.FCOMPANYID = ENTRY.FCOMPANYORGUNITID ").append(NEWLINE);
        sql.append(this.getSqlJoinByBillType(billType));
        sql.append(" INNER JOIN ").append(tempTable).append(" tempTable ON ENTRY.FMaterialId = tempTable.FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeJoinSql(calType, "tempTable", "ENTRY", true));
        sql.append(this.getBillBaseWhereSql(false));
        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
        sql.append(this.getCalUnitWhereFilter());
        if (!this.calParams.isCalculteCostPriceMovein() && INVENTORYBILL_TABLENAME[6][0].equals(tabName[0])) {
            sql.append(" AND BILL.FBizTypeID NOT IN (");
            sql.append("'").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(")").append(NEWLINE);
        }
        sql.append(" AND Entry.FUnitActualCost > 0").append(NEWLINE);
        sql.append(" GROUP BY ENTRY.FMaterialId").append(NEWLINE);
        sql.append(this.getCalTypeGroupSql(calType, "ENTRY.", true));
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getCalTypeGroupSql(int calType, String tableNameWithdot, boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if (calType == 1 || calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FSTORAGEORGUNITID ");
        }
        if (calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FWAREHOUSEID ");
        }
        if (isAddLot) {
            sql.append(", case when MATERIALCOMPANY.FISLOT = 1 then ").append(tableNameWithdot).append("FLot else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then ").append(tableNameWithdot).append("FAssistPropertyID else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISPROJECT = 1 then ").append(tableNameWithdot).append("FProjectID else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then ").append(tableNameWithdot).append("FTrackNumberID else null end  ");
        } else {
            sql.append(",").append(tableNameWithdot).append("FLot ");
            sql.append(",").append(tableNameWithdot).append("FAssistPropertyID ");
            sql.append(",").append(tableNameWithdot).append("FProjectID ");
            sql.append(",").append(tableNameWithdot).append("FTrackNumberID ");
        }
        return sql.toString();
    }

    private String getCalTypeSelectSql(int calType, String tableNameWithdot, boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if (calType == 1 || calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FSTORAGEORGUNITID ");
        }
        if (calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FWAREHOUSEID ");
        }
        if (isAddLot) {
            sql.append(", case when MATERIALCOMPANY.FISLOT = 1 then ").append(tableNameWithdot).append("FLot else null end  FLot ");
            sql.append(", case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then ").append(tableNameWithdot).append("FAssistPropertyID else null end FAssistPropertyID ");
            sql.append(", case when MATERIALCOMPANY.FISPROJECT = 1 then ").append(tableNameWithdot).append("FProjectID else null end FProjectID ");
            sql.append(", case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then ").append(tableNameWithdot).append("FTrackNumberID else null end FTrackNumberID ");
        } else {
            sql.append(",").append(tableNameWithdot).append("FLot ");
            sql.append(",").append(tableNameWithdot).append("FAssistPropertyID ");
            sql.append(",").append(tableNameWithdot).append("FProjectID ");
            sql.append(",").append(tableNameWithdot).append("FTrackNumberID ");
        }
        return sql.toString();
    }

    protected String getSqlJoinByBillType(int billType) {
        StringBuilder sql = new StringBuilder();
        sql.append(" LEFT JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
        sql.append(" LEFT JOIN T_MM_Project project ON Entry.FProjectID = project.FID").append(NEWLINE);
        sql.append(" LEFT JOIN T_MM_TrackNumber trackNumber ON Entry.FTrackNumberID = trackNumber.FID").append(NEWLINE);
        if (billType == 2) {
            sql.append(" INNER JOIN T_IM_STORETYPE storetype on Entry.FStoreTypeID = storetype.FID ").append(NEWLINE);
        } else {
            sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON Entry.FInvUpdateTypeID = InvUpdateType.FID").append(NEWLINE);
            if (billType == 0) {
                sql.append(" INNER JOIN T_IM_STORETYPE storetype on InvUpdateType.FStoreTypeID = storetype.FID ").append(NEWLINE);
            } else if (billType == 1) {
                sql.append(" INNER JOIN T_IM_STORETYPE storetype on InvUpdateType.FStoreTypePreID = storetype.FID ").append(NEWLINE);
            }
        }
        return sql.toString();
    }

    private String getCalTypeJoinSql(int calType, String subTableName, String nextTableName, boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if (calType == 1 || calType == 2) {
            sql.append("\n AND ").append(subTableName).append(".FSTORAGEORGUNITID = ").append(nextTableName).append(".FSTORAGEORGUNITID ");
        }
        if (calType == 2) {
            sql.append("\n AND ").append(subTableName).append(".FWAREHOUSEID = ").append(nextTableName).append(".FWAREHOUSEID ");
        }
        if (isAddLot) {
            sql.append("\n AND isnull(").append(subTableName).append(".FLot,N'NULLID') = (case when MATERIALCOMPANY.Fislot  = 1 then isnull(").append(nextTableName).append(".FLot,N'NULLID') else N'NULLID' end)");
            sql.append("\n AND isnull(").append(subTableName).append(".FAssistPropertyID,'NULLID') = (case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then isnull(").append(nextTableName).append(".FAssistPropertyID,'NULLID') else 'NULLID' end)");
            sql.append("\n AND isnull(").append(subTableName).append(".FProjectID,'NULLID') = (case when MATERIALCOMPANY.FISPROJECT = 1 then isnull(").append(nextTableName).append(".FProjectID,'NULLID') else 'NULLID' end) ");
            sql.append("\n AND isnull(").append(subTableName).append(".FTrackNumberID,'NULLID') = (case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then isnull(").append(nextTableName).append(".FTrackNumberID,'NULLID') else 'NULLID' end) ");
        } else {
            sql.append("\n AND isnull(").append(subTableName).append(".FLot,N'NULLID') = isnull(").append(nextTableName).append(".FLot,N'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FAssistPropertyID,'NULLID') = isnull(").append(nextTableName).append(".FAssistPropertyID,'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FProjectID,'NULLID') = isnull(").append(nextTableName).append(".FProjectID,'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FTrackNumberID,'NULLID') = isnull(").append(nextTableName).append(".FTrackNumberID,'NULLID') ");
        }
        return sql.toString();
    }

    private String getCreateMiddleTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("\n FBizDate DATETIME,");
        sql.append("\n FMaterialID VARCHAR(44),");
        sql.append("\n FSTORAGEORGUNITID VARCHAR(44),");
        sql.append("\n FWAREHOUSEID VARCHAR(44),");
        sql.append("\n FLot NVARCHAR(80),");
        sql.append("\n FAssistPropertyID VARCHAR(44),");
        sql.append("\n FProjectID VARCHAR(44),");
        sql.append("\n FTrackNumberID VARCHAR(44)");
        sql.append(")");
        return sql.toString();
    }

    private String getCreateNewPriceMiddleTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("\n FBizDate DATETIME,");
        sql.append("\n FMaterialID VARCHAR(44),");
        sql.append("\n FSTORAGEORGUNITID VARCHAR(44),");
        sql.append("\n FWAREHOUSEID VARCHAR(44),");
        sql.append("\n FLot NVARCHAR(80),");
        sql.append("\n FAssistPropertyID VARCHAR(44),");
        sql.append("\n FProjectID VARCHAR(44),");
        sql.append("\n FTrackNumberID VARCHAR(44),");
        sql.append("\n FBaseUnitActualCost NUMERIC(21,8) default 0");
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDevWriteOffRecord(Context ctx, String tempTableName) throws BOSException {
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String[][] fields = new String[][]{{"fid", "varchar(44) not null"}};
        String idTbl = KsqlUtil.createTempTable((Context)ctx, (String)this.tempManager.getCreateSQl(fields));
        KsqlUtil.createTempTableIndex((Context)ctx, (String)idTbl, (String)"fid", (boolean)true, (boolean)false);
        try {
            StringBuffer sql = new StringBuffer(500);
            sql.append("INSERT INTO ").append(idTbl).append(" SELECT distinct r.FBILLENTRYID FROM T_CL_DEVOLVEWRITEOFFRECORD r").append(" \r\n");
            sql.append("INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP g on g.FID = r.FPARENTID").append(" \r\n");
            sql.append("INNER JOIN T_IM_MATERIALREQBILLENTRY entry on entry.FID = r.FBILLENTRYID ").append(" \r\n");
            sql.append(this.getCalUnitJoinFilter());
            sql.append("where (g.FWRITEOFFYEAR * 100 + g.FWRITEOFFPERIOD) = '").append(periodInfo.getNumber()).append("'").append(" \r\n");
            sql.append(this.getCalUnitWhereFilter());
            DbUtil.execute((Context)ctx, (String)sql.toString());
            WriteOffHelp.updDevWritRecordOnMatreqCostChangeCurrPeriod(ctx, idTbl, periodInfo.getNumber());
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)idTbl);
        }
    }

    protected String handleReqBillStorageJump() {
        int baseCurrency = this.calParams.getBaseCurrencyPrecision();
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        String companyOrgID = this.calParams.getCompanyInfo().getId().toString();
        if (periodInfo != null) {
            sql.append("update T_IM_MaterialReqBillEntry t set (FActualCost,FUnitActualCost,FBaseUnitActualCost) = ");
            sql.append("(select ");
            sql.append(" case when reqentry.fqty = movInEntry.fqty then  movInEntry.FActualCost else round(reqentry.fqty * movInEntry.FUnitActualCost,").append(baseCurrency).append(") end , ");
            sql.append(" movInEntry.FUnitActualCost as FUnitActualCost");
            sql.append(" ,(case when movInEntry.FBASEQTY = 0 then 0 else round(TO_DECIMAL( movInEntry.FActualCost/movInEntry.FBASEQTY,21,8),material.FPricePrecision ) end ) as FBaseUnitActualCost ");
            sql.append(" from T_IM_MaterialReqBill reqbill inner join T_IM_MaterialReqBillEntry reqentry on reqbill.fid= reqentry.fparentid ");
            sql.append(" inner join T_IM_MoveInWarehsBillEntry movInEntry on movInEntry.FSOURCEBILLENTRYID = reqentry.fid  ");
            sql.append(" inner join t_bd_material material on reqentry.fmaterialid = material.fid ");
            sql.append(" where reqbill.FBIZTYPEID = '").append("i6DbShN4SLaNlFkX90UXOiQHQ1w=").append("' ");
            sql.append(" AND reqentry.FCompanyOrgUnitId = '").append(companyOrgID).append("' ");
            sql.append(" AND reqentry.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqentry.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqbill.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FFiVouchered = 0");
            sql.append(" AND reqbill.FBASESTATUS = 4");
            sql.append(" AND t.fid = reqentry.fid)");
        }
        return sql.toString();
    }

    protected String getTempDataBillSQL(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        String companyOrgID = this.calParams.getCompanyInfo().getId().toString();
        if (periodInfo != null) {
            this.tempManager.createReqTempTable(ctx);
            String reqTempTable = this.tempManager.getReqTemp();
            sql.append("insert into " + reqTempTable + "(FEntryId,FMaterialId,FUnitActualCost,FQty,FBaseQty,FActualCost)");
            sql.append(" select reqentry.fid,reqentry.FMaterialId,purentry.FUnitActualCost,");
            sql.append(" sum(purentry.FQty) ,sum(purentry.FBASEQTY),sum(purentry.FActualCost) ");
            sql.append(" from T_IM_MaterialReqBill reqbill inner join T_IM_MaterialReqBillEntry reqentry on reqbill.fid= reqentry.fparentid ");
            sql.append(" inner join t_im_purinwarehsentry purentry on purentry.FPurOrderEntryId = reqentry.fid  ");
            sql.append(" inner join t_im_purinwarehsbill purbill on purbill.fid = purentry.fparentid   ");
            sql.append(" where reqbill.FBIZTYPEID = '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ");
            sql.append(" AND purbill.FBIZTYPEID = '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ");
            sql.append(" AND reqentry.FCompanyOrgUnitId = '").append(companyOrgID).append("' ");
            sql.append(" AND reqentry.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqentry.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqbill.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FFiVouchered = 0");
            sql.append(" AND reqbill.FBASESTATUS = 4");
            sql.append(" Group by reqentry.fid,reqentry.FMaterialId ,purentry.FUnitActualCost ");
        }
        return sql.toString();
    }

    protected String handleReqBillCompJump() {
        StringBuffer sql = new StringBuffer();
        int baseCurrencyPrecision = this.calParams.getBaseCurrencyPrecision();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        String companyOrgID = this.calParams.getCompanyInfo().getId().toString();
        String tempTable = this.tempManager.getReqTemp();
        if (periodInfo != null && tempTable != null) {
            sql.append("update T_IM_MaterialReqBillEntry t set (FActualCost,FUnitActualCost,FBaseUnitActualCost) = ");
            sql.append(" (select ");
            sql.append(" case when reqentry.fqty = temp.fqty then  temp.FActualCost else round(reqentry.fqty * temp.FUnitActualCost,").append(baseCurrencyPrecision).append(") end , ");
            sql.append(" temp.FUnitActualCost as FUnitActualCost");
            sql.append(" ,(case when temp.FBASEQTY = 0 then 0 else round(TO_DECIMAL( temp.FActualCost/temp.FBASEQTY,21,8),material.FPricePrecision ) end) as FBaseUnitActualCost ");
            sql.append(" from T_IM_MaterialReqBill reqbill inner join T_IM_MaterialReqBillEntry reqentry on reqbill.fid= reqentry.fparentid ");
            sql.append(" inner join  " + tempTable + " as temp on reqentry.fid = temp.FEntryId");
            sql.append(" inner join t_bd_material material on temp.fmaterialid = material.fid ");
            sql.append(" where reqbill.FBIZTYPEID = '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ");
            sql.append(" AND reqentry.FCompanyOrgUnitId = '").append(companyOrgID).append("' ");
            sql.append(" AND reqentry.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqentry.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqbill.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FFiVouchered = 0");
            sql.append(" AND reqbill.FBASESTATUS = 4");
            sql.append(" AND t.fid = reqentry.fid)");
        }
        return sql.toString();
    }

    public String updateWriteOffRecordMantissaNextSQL(String bill, String billEntry) {
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FCurrWrittenOffAmount) = (");
        sql.append(" SELECT T0.factualcost-(T0.FTotalCurrWrittenOffAmount-FCurrWrittenOffAmount)  from (");
        sql.append(" SELECT MAX(writeoff.fid) as FID,");
        sql.append(" sum(writeoff.FCurrWrittenOffAmount) as FTotalCurrWrittenOffAmount,MAX(entry.factualcost) as factualcost");
        sql.append(" FROM T_CL_WriteOffRecord writeoff");
        sql.append(" inner JOIN ").append(billEntry).append(" entry ON (writeoff.fbillentryid = entry.fid and writeoff.fbillid = entry.fparentid)");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ON ENTRY.FMaterialID = MATERIAL.FId").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialID = MATERIALCOMPANY.FMaterialID").append(NEWLINE);
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
        sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ");
        sql.append(" ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ");
        sql.append(" ON ENTRY.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE");
        sql.append(" ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
        sql.append(this.getCalUnitJoinFilter());
        sql.append(" WHERE BILL.FBaseStatus = ").append(4);
        sql.append(" AND ISNULL(BILL.FIsInitBill, 0) = 0").append(NEWLINE);
        sql.append(" AND ISNULL(SCMTRANSACTIONTYPE.FIsCalculate, 1) = 1").append(NEWLINE);
        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
        sql.append(this.getCalUnitWhereFilter());
        sql.append(" AND entry.FUnWriteOffQty = 0");
        sql.append(" AND Entry.FCompanyOrgUnitID ='").append(this.calParams.getCompanyInfo().getId().toString()).append("'");
        sql.append(" GROUP BY writeoff.fbillentryid");
        sql.append(" HAVING count(1)>1");
        sql.append(" AND SUM(writeoff.FCurrWrittenOffAmount)<>MAX(entry.factualcost)");
        sql.append(" ) T0 WHERE T.fid = T0.fid");
        sql.append(" )");
        return sql.toString();
    }

    public String updateWriteOffRecordMantissaSQL(String bill, String billEntry) {
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String wirteoffTmpTable = this.tempManager.getWriteOffTemp();
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FWrittenOffAmount,FUnWriteOffAmount) = (");
        sql.append(" SELECT Entry.FActualCost,0");
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(wirteoffTmpTable).append(" AS writeoff ");
        sql.append(" ON (Entry.FParentID = writeoff.FBillID AND Entry.FID = writeoff.FBillEntryID)");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ON ENTRY.FMaterialID = MATERIAL.FId").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialID = MATERIALCOMPANY.FMaterialID").append(NEWLINE);
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
        sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ");
        sql.append(" ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ");
        sql.append(" ON ENTRY.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE");
        sql.append(" ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
        sql.append(this.getCalUnitJoinFilter());
        sql.append(" WHERE BILL.FBaseStatus = ").append(4);
        sql.append(" AND ISNULL(BILL.FIsInitBill, 0) = 0").append(NEWLINE);
        sql.append(" AND ISNULL(SCMTRANSACTIONTYPE.FIsCalculate, 1) = 1").append(NEWLINE);
        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
        sql.append(this.getCalUnitWhereFilter());
        sql.append(" AND writeoff.FUnWirteOffQty = 0");
        sql.append(" AND Entry.FUnWriteOffQty = 0");
        sql.append(" AND (writeoff.FWrittenOffAmount > Entry.FActualCost");
        sql.append(" OR writeoff.FWrittenOffAmount < Entry.FActualCost)");
        sql.append("\n AND Entry.FCompanyOrgUnitID ='").append(this.calParams.getCompanyInfo().getId().toString()).append("'");
        sql.append(" AND writeoff.fid=T.fid");
        sql.append(" )");
        return sql.toString();
    }

    protected String updateWriteOffRecordPriceSQL(String billEntry) {
        int baseCurrencyPrecision = this.calParams.getBaseCurrencyPrecision();
        String wirteoffTmpTable = this.tempManager.getWriteOffTemp();
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_CL_WriteOffRecord as T");
        sql.append(" SET (FCurrWrittenOffPrice,FCurrWrittenOffAmount,FWrittenOffAmount,FUnWriteOffAmount) = (");
        sql.append(" SELECT ROUND(Entry.FUnitActualCost,MATERIAL.FPricePrecision) ");
        sql.append(" ,case when entry.FBaseQty = writeoff.FCurrWrittenOffQty then entry.FActualCost else ");
        sql.append("  ROUND(Entry.FUnitActualCost *writeoff.FCurrWrittenOffQty,").append(baseCurrencyPrecision).append(") end ");
        sql.append(" ,writeoff.FWrittenOffAmount - ");
        sql.append(" (");
        sql.append(" abs(writeoff.FCurrWrittenOffAmount) - ");
        sql.append(" abs(ROUND(Entry.FUnitActualCost*writeoff.FCurrWrittenOffQty,").append(baseCurrencyPrecision).append("))");
        sql.append(" )* (").append("abs(writeoff.FCurrWrittenOffQty)/writeoff.FCurrWrittenOffQty").append(")");
        sql.append(" ,Entry.FActualCost - ");
        sql.append(" writeoff.FWrittenOffAmount - ");
        sql.append(" (");
        sql.append(" abs(writeoff.FCurrWrittenOffAmount) - ");
        sql.append(" abs(ROUND(Entry.FUnitActualCost*writeoff.FCurrWrittenOffQty,").append(baseCurrencyPrecision).append("))");
        sql.append(" )* (").append("abs(writeoff.FCurrWrittenOffQty)/writeoff.FCurrWrittenOffQty").append(")");
        sql.append("\n FROM ").append(billEntry).append(" Entry ");
        sql.append("\n INNER JOIN ").append(wirteoffTmpTable).append(" AS writeoff ");
        sql.append(" ON (Entry.FParentID = writeoff.FBillID");
        sql.append(" AND Entry.FID = writeoff.FBillEntryID");
        sql.append(" )");
        sql.append("\n INNER JOIN T_BD_Material MATERIAL  ON ENTRY.FMaterialID = MATERIAL.FId");
        sql.append("\n WHERE 1=1 ");
        sql.append(" AND writeoff.fid=T.fid");
        sql.append(" )");
        return sql.toString();
    }

    protected String getInsertWriteoffRecordSql(String tmpTable) {
        StringBuffer sqlBuffer = new StringBuffer();
        String wirteoffTmpTable = this.tempManager.getWriteOffTemp();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        sqlBuffer.append(" INSERT INTO ").append(wirteoffTmpTable);
        sqlBuffer.append("(FID,FBillID,FBillEntryID,FCurrWrittenOffQty,FUnWirteOffQty,FCurrWrittenOffAmount,FWrittenOffAmount)");
        sqlBuffer.append("\n SELECT distinct ENTRY.FID,ENTRY.FBillID,ENTRY.FBillEntryID,ENTRY.FCurrWrittenOffQty,ENTRY.FUnWirteOffQty");
        sqlBuffer.append("\n ,ENTRY.FCurrWrittenOffAmount,ENTRY.FWrittenOffAmount");
        sqlBuffer.append("\n FROM T_CL_WriteOffRecord ENTRY ");
        sqlBuffer.append("\n INNER JOIN T_CL_WriteOffGroup BILL ON BILL.FID = ENTRY.FParentID");
        sqlBuffer.append("\n INNER JOIN ").append(tmpTable).append(" TempT ");
        sqlBuffer.append("\n ON (ENTRY.FBILLID = TempT.FBILLID AND ENTRY.FBILLENTRYID = TempT.FBILLENTRYID) ");
        sqlBuffer.append("\n WHERE 1=1 AND BILL.FFiVouchered = 0 AND ENTRY.FBILLTYPENUMBER = '").append("102").append("'");
        sqlBuffer.append(" AND ENTRY.FBILLDATE>=TO_DATE('").append(SCMRptUtils.getFilterBeginDate((Date)periodInfo.getBeginDate())).append("')");
        sqlBuffer.append("\n AND ENTRY.FCompanyOrgUnitID ='").append(this.calParams.getCompanyInfo().getId().toString()).append("'");
        return sqlBuffer.toString();
    }

    protected abstract void calculateStrategy(Context var1, CalculateUnitInfo var2) throws EASBizException, BOSException;

    protected void getNeedUpdateMoveLocBillMaterial(Context ctx) throws BOSException {
        if (this.calParams.getCalMoveLocationBill().equals("0")) {
            return;
        }
        StringBuilder idSb = new StringBuilder();
        int size = this.calculateUnitList.size();
        for (int i = 0; i < size; ++i) {
            if (idSb.length() > 0) {
                idSb.append(",");
            }
            idSb.append("'").append(this.calculateUnitList.get(i).getMaterialId()).append("'");
        }
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        this.updateMoveLocMat = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ENTRY.FMATERIALID AS FMATERIALID from T_IM_MOVELOCATIONBILLENTRY ENTRY ");
        sql.append(" INNER JOIN  T_IM_MOVELOCATIONBILL BILL on BILL.FID = ENTRY.FPARENTID ");
        sql.append(" WHERE BILL.FBaseStatus = ").append(4);
        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
        sql.append(" AND ENTRY.FMATERIALID IN (  ").append(idSb.toString()).append(" ) ");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = ? ");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{this.calParams.getCompanyInfo().getId().toString()});
        try {
            while (rs.next()) {
                this.updateMoveLocMat.add(rs.getString("FMATERIALID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void buildPrePeriodCostMoveBill(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempStockEntryIDs = KsqlUtil.createTempTable((Context)ctx, (String)SysTempTableHelper.getCreateSQl((String[][])InventoryBillHelp.getStockTransEntryAndClosePeriod()));
        Connection conn = null;
        try {
            sql.append("Insert into ").append(tempStockEntryIDs).append("(FStockTransBillEntryID,FClosePeriod,FBASESTATUS)").append(NEWLINE);
            sql.append("Select temp.FStockTransBillEntryID,stEntry.FClosePeriod,stEntry.FBASESTATUS From ").append(NEWLINE);
            sql.append(this.tempManager.getInOutBillTemp()).append(" temp").append(NEWLINE);
            sql.append("inner join T_IM_STOCKTRANSFERBILLENTRY stEntry on stEntry.fid = temp.FStockTransBillEntryID").append(NEWLINE);
            sql.append("Where temp.FStockTransBillEntryID IS NOT NULL").append(NEWLINE);
            sql.append("Group by temp.FStockTransBillEntryID,stEntry.FClosePeriod,stEntry.FBASESTATUS");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            DBUtil.execute((Context)ctx, (String)this.getPreMoveIssueInsertInOutTempSql(ctx, tempStockEntryIDs));
            DBUtil.execute((Context)ctx, (String)this.getPreMoveInInsertInOutTempSql(ctx, tempStockEntryIDs));
            conn = EJBFactory.getConnection((Context)ctx);
            KsqlUtil.analyseTable((Context)ctx, (Connection)conn, (String)this.tempManager.getCostMoveOutTemp());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)ctx, (String)tempStockEntryIDs);
                KsqlUtil.cleanup(conn);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempStockEntryIDs);
        KsqlUtil.cleanup((Connection)conn);
    }

    private String getPreMoveInInsertInOutTempSql(Context ctx, String tempStockEntryIDs) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getInsertInOutTempSql(true));
        sql.append(this.getInOutBillTempSqlSelect());
        sql.append(" from (");
        String fields = this.getInOutBillShareFieldsCalcuate(ctx, "T_IM_MoveInWarehsBillEntry", BillTypeEnum.MOVEIN, -1);
        sql.append(this.getPreMoveInBillSql(fields, tempStockEntryIDs));
        sql.append(" ) Bill ");
        return sql.toString();
    }

    private String getPreMoveIssueInsertInOutTempSql(Context ctx, String tempStockEntryIDs) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getInsertInOutTempSql(true));
        sql.append(this.getInOutBillTempSqlSelect());
        sql.append(" from (");
        String fields = this.getInOutBillShareFieldsCalcuate(ctx, "T_IM_MoveIssueBillEntry", BillTypeEnum.MOVEISSUE, 3);
        sql.append(this.getPreMoveIssueBillSql(fields, tempStockEntryIDs));
        sql.append(" ) Bill ");
        return sql.toString();
    }

    private String getPreMoveIssueBillSql(String fields, String tempStockEntryIDs) {
        StringBuilder sql = new StringBuilder();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        sql.append(" SELECT ").append(fields).append(NEWLINE);
        sql.append(" FROM T_IM_MoveIssueBillEntry ENTRY").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_MoveIssueBill BILL ON BILL.FID = ENTRY.FParentID ").append(NEWLINE);
        sql.append(" INNER JOIN ").append(tempStockEntryIDs).append(" STEntry ON STEntry.FStockTransBillEntryID=ENTRY.FStockTransBillEntryID").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypePreID = StoreType.FID ").append(NEWLINE);
        sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON entry.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON entry.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_Material MATERIAL ON entry.FMaterialID = MATERIAL.FId").append(NEWLINE);
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID").append(NEWLINE);
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)").append(NEWLINE);
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid");
        sql.append(" AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)").append(NEWLINE);
        sql.append(this.getBillBaseWhereSql(false));
        sql.append(" AND SCMTRANSACTIONTYPE.FIsCalculate = 1").append(NEWLINE);
        sql.append(this.getPeroidWhereSql(periodInfo, true, false, false));
        sql.append(" AND ENTRY.FMATERIALID = '").append(this.calculateUnitList.get(0).getMaterialId()).append("' ");
        sql.append(" AND Bill.FBizTypeID IN (");
        sql.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(")").append(NEWLINE);
        return sql.toString();
    }

    private String getPreMoveInBillSql(String fields, String tempStockEntryIDs) {
        StringBuilder sql = new StringBuilder();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        sql.append(" SELECT ").append(fields).append(NEWLINE);
        sql.append(" FROM T_IM_MoveInWarehsBillEntry ENTRY").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_MoveInWarehsBill BILL ON BILL.FID = ENTRY.FParentID ").append(NEWLINE);
        sql.append(" INNER JOIN ").append(tempStockEntryIDs).append(" STEntry ON STEntry.FStockTransBillEntryID=ENTRY.FStockTransBillEntryID").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypeID = StoreType.FID ").append(NEWLINE);
        sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON entry.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON entry.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_Material MATERIAL ON entry.FMaterialID = MATERIAL.FId").append(NEWLINE);
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID").append(NEWLINE);
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)").append(NEWLINE);
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid");
        sql.append(" AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)").append(NEWLINE);
        sql.append(this.getBillBaseWhereSql(false));
        sql.append(" AND SCMTRANSACTIONTYPE.FIsCalculate = 1").append(NEWLINE);
        sql.append(this.getPeroidWhereSql(periodInfo, true, false, false));
        sql.append(this.getCalUnitWhereFilter());
        sql.append(" AND Bill.FBizTypeID IN (");
        sql.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(")").append(NEWLINE);
        return sql.toString();
    }

    protected abstract void adjustPrePeriodData(Context var1) throws BOSException;

    protected String getUpateCostAdjustBillDate(PeriodInfo periodInfo) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.tempManager.getInOutBillTemp()).append(" AS T ");
        buffer.append("\n SET (FBizDate) = (");
        buffer.append("\n SELECT FBEGINDATE  FROM T_BD_PERIOD WHERE T_BD_PERIOD.FID ='");
        buffer.append(periodInfo.getId().toString()).append("')");
        buffer.append("\n WHERE T.FBILLTYPEID = '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        buffer.append("\n AND EXISTS(SELECT 1 FROM T_CL_CostAdjustBill BILL WHERE BILL.FID = T.FBILLID AND BILL.FCREATETYPE <> 1)");
        buffer.append("\n AND T.FISCOMBITION = 0");
        return buffer.toString();
    }

    protected String getUpdateSrcBillBizDate() {
        String inOutBillTempTable = this.tempManager.getInOutBillTemp();
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(inOutBillTempTable).append(" AS T1");
        buffer.append("\n SET (FBizDate,FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT ADD_SECONDS(T2.FBIZDATE,1),-1 FROM ").append(inOutBillTempTable).append(" AS T2");
        buffer.append("\n WHERE T1.FSourceBillEntryID = T2.FBillEntryId and T1.FEntryTablemame = T2.FEntryTablemame");
        buffer.append("\n AND T1.FEntryTablemame !='t_cl_costadjustbillentry'");
        buffer.append("\n AND not (T1.fstoretypeid is null and T1.fbiztypeid = 'd8e80652-0113-1000-e000-04c5c0a812202407435C')");
        buffer.append("\n )");
        return buffer.toString();
    }

    protected String[] getUpateCostMoveInFromPrePeriod(PeriodInfo periodInfo) {
        String inOutBillTemp = this.tempManager.getInOutBillTemp();
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_MOVEINWAREHSBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MOVEINWAREHSBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(inOutBillTemp).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_MoveInWarehsBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(periodInfo.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(periodInfo.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(periodInfo.getPeriodYear()).append(")");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n )");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET ( FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid \n FROM  T_IM_MOVEINWAREHSBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MOVEINWAREHSBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(inOutBillTemp).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_MoveInWarehsBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(periodInfo.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(periodInfo.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(periodInfo.getPeriodYear()).append(")");
        buffer.append("\n )");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String getUpateCostMoveIssueFromPrePeriod(PeriodInfo periodInfo) {
        String inOutBillTemp = this.tempManager.getInOutBillTemp();
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T ");
        buffer.append("\n SET (FBizDate) = (");
        buffer.append("\n SELECT FBEGINDATE  FROM T_BD_PERIOD WHERE T_BD_PERIOD.FID ='");
        buffer.append(periodInfo.getId().toString()).append("')");
        buffer.append("\n WHERE T.FBILLTYPEID = '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        buffer.append("\n AND EXISTS(SELECT 1 FROM T_CL_CostAdjustBill BILL WHERE BILL.FID = T.FBILLID AND BILL.FCREATETYPE <> 1)");
        buffer.append("\n AND T.FISCOMBITION = 0");
        return buffer.toString();
    }

    protected String[] getUpateSaleIssuePriceFromPrePeriod(PeriodInfo periodInfo) {
        String inOutBillTemp = this.tempManager.getInOutBillTemp();
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_SALEISSUEENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_SALEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(inOutBillTemp).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(periodInfo.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(periodInfo.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(periodInfo.getPeriodYear()).append(")");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry' and T1.FFIVOUCHERED = 0");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET  (FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid \n FROM  T_IM_SALEISSUEENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_SALEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(inOutBillTemp).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(periodInfo.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(periodInfo.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(periodInfo.getPeriodYear()).append(")");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry' ");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String[] getUpateMaterialReqPriceFromPrePeriod(PeriodInfo periodInfo) {
        String inOutBillTemp = this.tempManager.getInOutBillTemp();
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_MATERIALREQBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MATERIALREQBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(inOutBillTemp).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID");
        buffer.append("\n AND T1.FENTRYTABLEMAME ='T_IM_MaterialReqBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(periodInfo.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(periodInfo.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(periodInfo.getPeriodYear()).append(") ");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n )");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET  (FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid  \n FROM  T_IM_MATERIALREQBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MATERIALREQBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(inOutBillTemp).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID");
        buffer.append("\n AND T1.FENTRYTABLEMAME ='T_IM_MaterialReqBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(periodInfo.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(periodInfo.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(periodInfo.getPeriodYear()).append(")");
        buffer.append("\n )");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String getUpdateCombitionBizDateSQL() {
        String inOutBillTemp = this.tempManager.getInOutBillTemp();
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(inOutBillTemp).append(" AS T1");
        buffer.append("\n SET (FBizDate,FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT TOP 1 ADD_SECONDS(T2.FBIZDATE,1),1 FROM ").append(inOutBillTemp).append(" AS T2");
        buffer.append("\n WHERE T1.FSourceBillEntryID = T2.FBillEntryId ");
        buffer.append("\n AND T2.FISCOMBITION = 1");
        buffer.append("\n )");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCombitionRetBill(Context ctx) throws BOSException {
        String tempAssistTable = KsqlUtil.createTempTable((Context)ctx, (String)SysTempTableHelper.getCreateSQl((String[][])InventoryBillHelp.getAssistTableFields()));
        String inOutBillTemp = this.tempManager.getInOutBillTemp();
        try {
            DBUtil.execute((Context)ctx, (String)("insert into " + tempAssistTable + "(FID,FBaseQty,FActualCost,FOutwarehouseType,FEntryTableMame) " + this.getInsertCombitionRetBillSQL(inOutBillTemp)));
            DBUtil.execute((Context)ctx, (String)this.getUpdateCombitionSrcBillSql(inOutBillTemp, tempAssistTable));
            DBUtil.execute((Context)ctx, (String)this.getUpdateCombitionRetBillSql(inOutBillTemp, tempAssistTable));
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempAssistTable);
        }
    }

    protected String getUpdateCombitionSrcBillSql(String fifoBillTmpTabName, String tempAssistTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append(" as T1").append(NEWLINE);
        buffer.append(" SET (FBaseQty,FActualCost,FisCombition) =(");
        buffer.append("\n SELECT T2.FBaseQty,T2.FActualCost,T2.FOutwarehouseType FROM ");
        buffer.append(tempAssistTable).append(" AS T2 ");
        buffer.append("\n WHERE ").append("T1.FID = T2.FID");
        buffer.append(")");
        return buffer.toString();
    }

    protected String getInsertCombitionRetBillSQL(String fifoBillTmpTabName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n SELECT T2.FID,(T1.FBASEQTY+T2.FBASEQTY) AS FBASEQTY,(T1.FACTUALCOST+T2.FACTUALCOST) AS FACTUALCOST, 1 AS FisCombition, T2.FEntryTableMame  FROM ");
        buffer.append("\n (SELECT FSourceBillEntryID,FEntryTableMame,SUM(FBaseQty) AS FBASEQTY ,SUM(FActualCost) AS FACTUALCOST FROM ");
        buffer.append(fifoBillTmpTabName);
        buffer.append("\n WHERE FSourceBillEntryID IS NOT NULL");
        buffer.append(" AND FEntryTableMame != 't_cl_costadjustbillentry' AND FEntryTableMame != 'T_CL_InventoryBalance' ");
        buffer.append("\n GROUP BY FSourceBillEntryID,FEntryTableMame) AS T1");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTabName).append(" AS T2");
        buffer.append("\n ON (t1.FSOURCEBILLENTRYID = T2.FBillEntryId AND T1.FEntryTableMame = T2.FEntryTableMame)");
        buffer.append("\n WHERE T1.FBASEQTY * T2.FBASEQTY < 0");
        return buffer.toString();
    }

    protected String getUpdateCombitionRetBillSql(String fifoBillTmpTabName, String tempAssistTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append(NEWLINE);
        buffer.append(" SET FisCombition = 2 ").append(NEWLINE);
        buffer.append(" WHERE FID IN (SELECT T2.FID FROM ").append(tempAssistTable).append(" T1");
        buffer.append(" INNER JOIN ").append(fifoBillTmpTabName).append(" T2 ON T1.FID = T2.FSourceBillEntryID AND T1.FEntryTableMame = T2.FEntryTableMame)");
        return buffer.toString();
    }

    private void initTempTable(Context ctx) throws BOSException {
        this.tempManager.initTempTables(ctx);
    }

    protected void buildInOutBillsData(Context ctx) throws BOSException {
        this.insertInOutData2TempTable(ctx);
        this.insertBalAndCostAdjData2TempTable(ctx);
    }

    protected void insertCalcResultInfo(Context ctx, OneKeyBillCostInfo billInfo, String calcResultTbl) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(calcResultTbl).append(NEWLINE);
        sql.append("(FMATERIALID,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID,FPRICE)").append(NEWLINE);
        sql.append("values(?,?,?,?,?,?,?,?,?)");
        Object[] param = new Object[]{billInfo.getMaterialId(), billInfo.getCompanyOrgUnitId(), billInfo.getStorageOrgUnitId(), billInfo.getWarehouseId(), billInfo.getLot(), billInfo.getAssistPropertyId(), billInfo.getProjectId(), billInfo.getTrackNumberId(), billInfo.getPrice()};
        DBUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    private void insertBalAndCostAdjData2TempTable(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getInsertInOutTempSql(false));
        sql.append(this.getBalanceAndCostAdjSelectSql());
        sql.append(" From (");
        sql.append(this.getBalanceTempSqlCalculate(ctx));
        sql.append(" ) temp ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(this.getInsertInOutTempSql(false));
        sql.append(this.getBalanceAndCostAdjSelectSql());
        sql.append(" From (");
        sql.append(this.getSQLInpourCostAdjBillCalculate(ctx));
        sql.append(" ) temp ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(this.getInsertInOutTempSql(false));
        sql.append(this.getBalanceAndCostAdjSelectSql());
        sql.append(" From (");
        sql.append(this.getOutSQLPayoutCostAdjBillCalculate(ctx));
        sql.append(" ) temp ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
    }

    protected Object[] getSqlParams(CalculateUnitInfo calculateUnitInfo) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(calculateUnitInfo.getMaterialId());
        String calType = this.calParams.getCalType();
        AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
        if (calType.equals("1") && !StringUtils.isEmpty((String)calculateUnitInfo.getStorageOrgUnitId())) {
            paramList.add(calculateUnitInfo.getStorageOrgUnitId());
        }
        if (calType.equals("2")) {
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getStorageOrgUnitId())) {
                paramList.add(calculateUnitInfo.getStorageOrgUnitId());
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getWarehouseId())) {
                paramList.add(calculateUnitInfo.getWarehouseId());
            }
        }
        if (accountType == AccountType.SPECIAL_ACCT) {
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getLot())) {
                paramList.add(calculateUnitInfo.getLot());
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getAssistPropertyId())) {
                paramList.add(calculateUnitInfo.getAssistPropertyId());
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getProjectId())) {
                paramList.add(calculateUnitInfo.getProjectId());
            }
            if (!StringUtils.isEmpty((String)calculateUnitInfo.getTrackNumberId())) {
                paramList.add(calculateUnitInfo.getTrackNumberId());
            }
        }
        return paramList.toArray();
    }

    private String getSQLCostAdjBillCalculate(Context ctx, CalculateKindEnum calculateKind) {
        StringBuilder sql = new StringBuilder();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        boolean isInBill = CalculateKindEnum.INPUT_WAREHOUSE == calculateKind;
        sql.append(" SELECT /*+ leading(BILL)*/ ");
        sql.append(this.getCostAdjBillShareFieldsCalculate(ctx, isInBill)).append(NEWLINE);
        sql.append(" FROM T_CL_CostAdjustBill BILL").append(NEWLINE);
        sql.append(" INNER JOIN T_ORG_UNITRELATION Relation ON BILL.FSTORAGEORGUNITID = Relation.FFROMUNITID");
        sql.append(" INNER JOIN ").append(this.calParams.getCostAdjEntryTempTbl()).append(" ENTRY ON BILL.FID = ENTRY.FParentID").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON StoreType.FID = ENTRY.FStoreTypeID").append(NEWLINE);
        sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON entry.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON entry.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL ON entry.FMaterialID = MATERIAL.FId").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (entry.FMaterialId = MATERIALCOMPANY.FMaterialID").append(NEWLINE);
        sql.append(" AND entry.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
        sql.append(" left JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND ENTRY.FBASEUNITID = MeasureUnitBase.FMeasureUnitID)").append(NEWLINE);
        sql.append(this.getCalUnitJoinFilter());
        sql.append(this.getBillBaseWhereSql(false));
        sql.append((CharSequence)this.getRelationOrgFilter(BillTypeEnum.COSTADJUST));
        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
        sql.append(this.getCalUnitWhereFilter());
        sql.append(" AND BILL.FCalculateKind =").append(calculateKind.getValue());
        sql.append(" AND StoreType.FIsForwardAmt = 1 ");
        return sql.toString();
    }

    private String getSQLInpourCostAdjBillCalculate(Context ctx) {
        return this.getSQLCostAdjBillCalculate(ctx, CalculateKindEnum.INPUT_WAREHOUSE);
    }

    private String getOutSQLPayoutCostAdjBillCalculate(Context ctx) {
        return this.getSQLCostAdjBillCalculate(ctx, CalculateKindEnum.OUTPUT_WAREHOUSE);
    }

    private String getCostAdjBillShareFieldsCalculate(Context ctx, boolean isInBill) {
        StringBuffer fields = new StringBuffer();
        String billTypeName = SCMUtils.getResource((String)CALRESOURCE, (String)"COST_ADJUST_BILL", (Context)ctx);
        fields.append(" Entry.FMaterialID,ENTRY.FCompanyOrgUnitId FCompanyOrgUnitID,");
        fields.append(" STORAGEORGUNIT.FNUMBER Fstorageorg,WAREHOUSE.FNUMBER Fwarehouse,");
        fields.append(" Entry.FStorageOrgUnitID AS FStorageOrgUnitID,ENTRY.FWarehouseID AS FWarehouseID,");
        fields.append(" 0 AS FPeriodBeginCostDiff,0 AS FPeriodBeginBalance,0 AS FIncomeCostAdjustAmt,").append(NEWLINE);
        fields.append(" 0 AS FStandardCost,ENTRY.FAmount AS FActualCost,ENTRY.FBaseQty AS FBaseQty,");
        fields.append(" 0 AS FBaseUnitActualCost,0 AS FPeriodBeginQty,").append(NEWLINE);
        fields.append(" Bill.FBillTypeID,BILL.FNumber,Bill.FBizDate,").append(NEWLINE);
        fields.append(" Bill.FBizTypeID,N'' AS FTRANSACTIONTYPENAME,").append(NEWLINE);
        fields.append(" Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.FId as FBillId,Entry.FId as FBillEntryId,").append(NEWLINE);
        if (isInBill) {
            fields.append(" 0 AS FCalculateKind,");
        } else {
            fields.append(" 1 AS FCalculateKind,");
        }
        fields.append(" Bill.FIsReversed,Entry.FReverseQty,NULL AS FStockTransBillEntryID,BILL.FAUDITTIME,").append(NEWLINE);
        fields.append(" NULL as FSourceBillTypeID,MATERIAL.FNUMBER AS FMATERIALNUMBER,").append(NEWLINE);
        fields.append(" MATERIAL.FBASEUNIT,isnull(MeasureUnitBase.FQtyPrecision,4) as FQtyPrecision,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,ENTRY.FISPRESENT,");
        fields.append(" NULL AS FSourceBillID,NULL AS FSourceBillEntryID,0 AS FSourceBillEntrySeq,").append(NEWLINE);
        if (!isInBill) {
            fields.append(" Bill.FIssueType AS FOutwarehouseType,");
        } else {
            fields.append(" ").append(-1).append(" AS FOutwarehouseType,");
        }
        fields.append("'T_CL_CostAdjustBillEntry' AS FEntryTableMame");
        if (this.calParams.isNeedCostCenter()) {
            fields.append(",null as FCostCenter");
            fields.append(",null AS FCostObject");
        }
        if (this.calParams.isNeedReWork()) {
            fields.append(",0 as FIsReWork");
        }
        fields.append(" ,'" + billTypeName + "' AS FBillTypeName");
        fields.append(",Entry.FStoreTypeId as FStoreTypeId, Entry.FStoreTypeId as FStoreTypePreId");
        if (AccountType.SPECIAL_ACCT.equals(OneKeyCalculateParams.accountTypeThreadLocal.get())) {
            fields.append(" ,(case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT,");
            fields.append(" (case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID,");
            fields.append(" (case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID,");
            fields.append(" (case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID,");
        } else {
            fields.append(" ,null as FLOT,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,").append(NEWLINE);
        }
        fields.append(" null as FUnitID");
        fields.append(" ,0 as FQty");
        fields.append(" ,0 as FWrittenOffBaseQty");
        fields.append(" ,0 as FUnWriteOffBaseQty");
        fields.append(" ,0 as FisWriteOffVouched");
        fields.append(" ,0 as FBASECONVSRATE");
        return fields.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInOutData2TempTable(Context ctx) throws BOSException {
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        Connection connection = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            String insetSql = this.getPurInInsertInOutTempSql(ctx);
            QueryDataTask purInThread = new QueryDataTask(lock, "PURINWAREHS_LOCK", connection, insetSql);
            lock.addLock("PURINWAREHS_LOCK");
            threadPool.addTask((Runnable)purInThread);
            insetSql = this.getManuInInsertInOutTempSql(ctx);
            QueryDataTask manuInThread = new QueryDataTask(lock, "MANUFACTUREREC_LOCK", connection, insetSql);
            lock.addLock("MANUFACTUREREC_LOCK");
            threadPool.addTask((Runnable)manuInThread);
            insetSql = this.getMoveInInsertInOutTempSql(ctx);
            QueryDataTask moveInThread = new QueryDataTask(lock, "MOVEINWAREHS_LOCK", connection, insetSql);
            lock.addLock("MOVEINWAREHS_LOCK");
            threadPool.addTask((Runnable)moveInThread);
            insetSql = this.getOtherInInsertInOutTempSql(ctx);
            QueryDataTask otherInThread = new QueryDataTask(lock, "OTHERINWAREHS_LOCK", connection, insetSql);
            lock.addLock("OTHERINWAREHS_LOCK");
            threadPool.addTask((Runnable)otherInThread);
            insetSql = this.getSaleIssueInsertInOutTempSql(ctx);
            QueryDataTask saleIssueThread = new QueryDataTask(lock, "SALEISSUE_LOCK", connection, insetSql);
            lock.addLock("SALEISSUE_LOCK");
            threadPool.addTask((Runnable)saleIssueThread);
            insetSql = this.getMatReqInsertInOutTempSql(ctx);
            QueryDataTask matReqThread = new QueryDataTask(lock, "MATERIALREQ_LOCK", connection, insetSql);
            lock.addLock("MATERIALREQ_LOCK");
            threadPool.addTask((Runnable)matReqThread);
            insetSql = this.getMoveIssueInsertInOutTempSql(ctx, false);
            QueryDataTask moveIssueThread = new QueryDataTask(lock, "MOVEISSUE_LOCK", connection, insetSql);
            lock.addLock("MOVEISSUE_LOCK");
            threadPool.addTask((Runnable)moveIssueThread);
            if (!"0".equals(this.calParams.getCalType())) {
                insetSql = this.getMoveIssueInsertInOutTempSql(ctx, true);
                QueryDataTask moveIssueByInThread = new QueryDataTask(lock, "MOVEISSUEBYIN_LOCK", connection, insetSql);
                lock.addLock("MOVEISSUEBYIN_LOCK");
                threadPool.addTask((Runnable)moveIssueByInThread);
            }
            insetSql = this.getOtherIssueInsertInOutTempSql(ctx);
            QueryDataTask otherIssueThread = new QueryDataTask(lock, "OTHERISSUE_LOCK", connection, insetSql);
            lock.addLock("OTHERISSUE_LOCK");
            threadPool.addTask((Runnable)otherIssueThread);
            try {
                lock.waitFinish();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    private String getPurInInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_Purinwarehsbill", "T_IM_PurinwarehsEntry", this.calParams.getPurInTempTbl(), BillTypeEnum.PURIN, -1, false);
    }

    private String getManuInInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", this.calParams.getManuRecEntryTempTbl(), BillTypeEnum.MANUIN, -1, false);
    }

    private String getMoveInInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", this.calParams.getMoveInTempTbl(), BillTypeEnum.MOVEIN, -1, false);
    }

    private String getOtherInInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", this.calParams.getOtherInTempTbl(), BillTypeEnum.OTHERIN, -1, false);
    }

    private String getSaleIssueInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", this.calParams.getSaleIssueEntryTempTbl(), BillTypeEnum.SALEISSUE, 0, false);
    }

    private String getMatReqInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", this.calParams.getMatReqEntryTempTbl(), BillTypeEnum.MATREQ, 1, false);
    }

    private String getMoveIssueInsertInOutTempSql(Context ctx, boolean costMoveIssueByIn) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", this.calParams.getMoveIssueTempTbl(), BillTypeEnum.MOVEISSUE, 3, costMoveIssueByIn);
    }

    private String getOtherIssueInsertInOutTempSql(Context ctx) {
        return this.getBillInsertInOutTempSql(ctx, "T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", this.calParams.getOtherIssueTempTbl(), BillTypeEnum.OTHERISSUE, 2, false);
    }

    private String getBillInsertInOutTempSql(Context ctx, String billTab, String entryTab, String entryTempTab, BillTypeEnum billType, int issueType, boolean costMoveIssueByIn) {
        StringBuilder sql;
        block6: {
            PeriodInfo periodInfo;
            block7: {
                block8: {
                    block5: {
                        periodInfo = this.calParams.getPeriodInfo();
                        sql = new StringBuilder();
                        sql.append(this.getInsertInOutTempSql(costMoveIssueByIn));
                        sql.append(this.getInOutBillTempSqlSelect());
                        sql.append(" from (");
                        String fields = this.getInOutBillShareFieldsCalcuate(ctx, entryTab, billType, issueType);
                        sql.append(this.getInOutBillSqlCaluate(billType, billTab, entryTempTab, fields));
                        if (!costMoveIssueByIn) break block5;
                        sql.append(this.getCostMoveInByIssue());
                        sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
                        break block6;
                    }
                    sql.append(this.getCalUnitJoinFilter());
                    sql.append(this.getBillBaseWhereSql(false));
                    if (this.isInBill(billType)) break block7;
                    if (OneKeyCalculateParams.accountTypeThreadLocal.get() == AccountType.ADD_AVERAGE) break block8;
                    if (OneKeyCalculateParams.accountTypeThreadLocal.get() != AccountType.SPECIAL_ACCT) break block7;
                }
                if ("1".equals(this.calParams.getNotCalConsignSale())) {
                    sql.append(" AND StoreType.FID !='").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append(NEWLINE);
                }
            }
            sql.append(" AND SCMTRANSACTIONTYPE.FIsCalculate = 1").append(NEWLINE);
            if (this.isInBill(billType) || BillTypeEnum.MOVEISSUE != billType) {
                // empty if block
            }
            sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
            sql.append(this.getCalUnitWhereFilter());
            sql.append((CharSequence)this.getRelationOrgFilter(billType));
            sql.append(this.getJumpOrgBillCondition(billType));
        }
        sql.append(NEWLINE).append(" ) Bill");
        return sql.toString();
    }

    private String getCostMoveInByIssue() {
        StringBuilder sql = new StringBuilder();
        sql.append(" WHERE BILL.FBASESTATUS = 4");
        sql.append(" AND EXISTS(SELECT 1 FROM ").append(this.tempManager.getInOutBillTemp()).append(" temp where entry.FSTOCKTRANSBILLENTRYID = temp.FSTOCKTRANSBILLENTRYID ");
        sql.append(" AND temp.FEntryTableMame = 'T_IM_MoveInWarehsBillEntry' ");
        if ("1".equals(this.calParams.getCalType())) {
            sql.append(" AND temp.FBIZTYPEID = '").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        } else {
            sql.append(" AND (temp.FBIZTYPEID = '").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(" OR temp.FBIZTYPEID = '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("')");
        }
        sql.append(")");
        return sql.toString();
    }

    private StringBuilder getRelationOrgFilter(BillTypeEnum billTypeEnum) {
        StringBuilder sql = new StringBuilder();
        if (BillTypeEnum.COSTADJUST.equals((Object)billTypeEnum) || BillTypeEnum.PURIN.equals((Object)billTypeEnum) || BillTypeEnum.SALEISSUE.equals((Object)billTypeEnum) || BillTypeEnum.MATREQ.equals((Object)billTypeEnum)) {
            sql.append(" AND Relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5' and Relation.FTOUNITID ='");
            sql.append(this.calParams.getCompanyInfo().getId().toString()).append("'").append(NEWLINE);
        }
        return sql;
    }

    protected String getJumpOrgBillCondition(BillTypeEnum billType) {
        if (BillTypeEnum.MATREQ.equals((Object)billType) || BillTypeEnum.MOVEIN.equals((Object)billType) || BillTypeEnum.PURIN.equals((Object)billType)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" and ( ");
            if (BillTypeEnum.MATREQ.equals((Object)billType)) {
                sb.append(" bill.FBizTypeID not in  (");
                sb.append("'").append("i6DbShN4SLaNlFkX90UXOiQHQ1w=").append("' ,");
                sb.append("'").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ,");
                sb.append("'").append("YJN9V65PSkutQxeUH6F72SQHQ1w=").append("') ");
            } else if (BillTypeEnum.MOVEIN.equals((Object)billType)) {
                sb.append(" bill.FBizTypeID not in  (");
                sb.append("'").append("i6DbShN4SLaNlFkX90UXOiQHQ1w=").append("' ,");
                sb.append("'").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ,");
                sb.append("'").append("YJN9V65PSkutQxeUH6F72SQHQ1w=").append("')");
            } else if (BillTypeEnum.PURIN.equals((Object)billType)) {
                sb.append(" bill.FBizTypeID <> '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("'");
            }
            sb.append(" ) ");
            return sb.toString();
        }
        return "";
    }

    private String getCalUnitWhereFilter() {
        if (this.calculateUnitList != null && this.calculateUnitList.size() == 1) {
            CalculateUnitInfo calUnitInfo = this.calculateUnitList.get(0);
            StringBuffer sql = new StringBuffer();
            String calType = this.calParams.getCalType();
            AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
            sql.append(" AND ENTRY.FMATERIALID = '").append(calUnitInfo.getMaterialId()).append("'").append(NEWLINE);
            if (calType.equals("1") && !StringUtils.isEmpty((String)calUnitInfo.getStorageOrgUnitId())) {
                sql.append(" AND entry.FStorageOrgUnitID = '").append(calUnitInfo.getStorageOrgUnitId()).append("'");
            }
            if (calType.equals("2")) {
                if (!StringUtils.isEmpty((String)calUnitInfo.getStorageOrgUnitId())) {
                    sql.append(" AND entry.FStorageOrgUnitID = '").append(calUnitInfo.getStorageOrgUnitId()).append("'");
                }
                if (!StringUtils.isEmpty((String)calUnitInfo.getWarehouseId())) {
                    sql.append(" AND entry.FWareHouseID = '").append(calUnitInfo.getWarehouseId()).append("'");
                }
            }
            if (accountType == AccountType.SPECIAL_ACCT) {
                if (!StringUtils.isEmpty((String)calUnitInfo.getLot())) {
                    sql.append(" AND ENTRY.FLOT = '").append(calUnitInfo.getLot()).append("'");
                }
                if (!StringUtils.isEmpty((String)calUnitInfo.getAssistPropertyId())) {
                    sql.append(" AND ENTRY.FAssistPropertyID = '").append(calUnitInfo.getAssistPropertyId()).append("'");
                }
                if (!StringUtils.isEmpty((String)calUnitInfo.getProjectId())) {
                    sql.append(" AND ENTRY.FProjectID = '").append(calUnitInfo.getProjectId()).append("'");
                }
                if (!StringUtils.isEmpty((String)calUnitInfo.getTrackNumberId())) {
                    sql.append(" AND ENTRY.FTrackNumberID = '").append(calUnitInfo.getTrackNumberId()).append("'");
                }
            }
            return sql.toString();
        }
        return "";
    }

    private String getCalUnitJoinFilter() {
        if (this.calculateUnitList != null && this.calculateUnitList.size() > 1) {
            StringBuilder sql = new StringBuilder();
            String calType = this.calParams.getCalType();
            AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
            sql.append(" INNER JOIN ").append(this.tempManager.getCalUnitTemp()).append(" CALUNIT");
            sql.append(" ON ENTRY.FMATERIALID = CALUNIT.FMATERIALID ");
            sql.append(" AND ENTRY.FCompanyOrgUnitId = CALUNIT.FCOMPANYORGUNITID ");
            if (calType.equals("1")) {
                sql.append(" AND (CASE WHEN CALUNIT.FStorageOrgUnitID IS NULL THEN 1 WHEN entry.FStorageOrgUnitID = CALUNIT.FStorageOrgUnitID THEN 1 ELSE 0 END) = 1");
            }
            if (calType.equals("2")) {
                sql.append(" AND (CASE WHEN CALUNIT.FStorageOrgUnitID IS NULL THEN 1 WHEN entry.FStorageOrgUnitID = CALUNIT.FStorageOrgUnitID THEN 1 ELSE 0 END) = 1");
                sql.append(" AND (CASE WHEN CALUNIT.FWareHouseID IS NULL THEN 1 WHEN entry.FWareHouseID = CALUNIT.FWareHouseID THEN 1 ELSE 0 END) = 1");
            }
            if (accountType == AccountType.SPECIAL_ACCT) {
                sql.append(" AND (CASE WHEN CALUNIT.FLOT IS NULL THEN 1 WHEN ENTRY.FLOT = CALUNIT.FLOT THEN 1 ELSE 0 END) = 1 ");
                sql.append(" AND (CASE WHEN CALUNIT.FAssistPropertyID IS NULL THEN 1 WHEN ENTRY.FAssistPropertyID = CALUNIT.FAssistPropertyID THEN 1 ELSE 0 END) = 1 ");
                sql.append(" AND (CASE WHEN CALUNIT.FProjectID IS NULL THEN 1 WHEN ENTRY.FProjectID = CALUNIT.FProjectID THEN 1 ELSE 0 END) = 1 ");
                sql.append(" AND (CASE WHEN CALUNIT.FTrackNumberID IS NULL THEN 1 WHEN ENTRY.FTrackNumberID = CALUNIT.FTrackNumberID THEN 1 ELSE 0 END) = 1");
            }
            return sql.toString();
        }
        return "";
    }

    protected String getInOutBillShareFieldsCalcuate(Context ctx, String entryTab, BillTypeEnum billType, int issueType) {
        StringBuffer fields = new StringBuffer();
        fields.append(" Entry.FMaterialID,ENTRY.FCompanyOrgUnitId FCompanyOrgUnitID,");
        fields.append(" STORAGEORGUNIT.FNUMBER Fstorageorg,WAREHOUSE.FNUMBER Fwarehouse,");
        fields.append(" Entry.FStorageOrgUnitID AS FStorageOrgUnitID,ENTRY.FWarehouseID AS FWarehouseID,");
        fields.append(" 0 AS FPeriodBeginCostDiff,0 AS FPeriodBeginBalance,0 AS FIncomeCostAdjustAmt,").append(NEWLINE);
        fields.append(" ENTRY.FStandardCost AS FStandardCost,ENTRY.FActualCost AS FActualCost,ENTRY.FBaseQty AS FBaseQty,").append(NEWLINE);
        fields.append(" MATERIAL.Fnumber as FmaterialNumber,").append(NEWLINE);
        fields.append(" SCMTRANSACTIONTYPE.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FTransactionTypeName,");
        fields.append(" CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0)").append(NEWLINE);
        fields.append("     ELSE ").append(CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("ENTRY.FActualCost") + "/ENTRY.FBaseQty"));
        fields.append(" END AS FBaseUnitActualCost,").append(NEWLINE);
        fields.append(" 0 AS FPeriodBeginQty,Bill.FBillTypeID,BILL.FNumber,Bill.FBizDate,").append(NEWLINE);
        fields.append(" ENTRY.FUnitID,ENTRY.FQty,");
        if (BillTypeEnum.PURIN.equals((Object)billType) || BillTypeEnum.SALEISSUE.equals((Object)billType)) {
            fields.append(" ENTRY.FWrittenOffBaseQty,ENTRY.FUnWriteOffBaseQty,").append(NEWLINE);
        } else if (BillTypeEnum.MATREQ.equals((Object)billType)) {
            fields.append(" ENTRY.FSubWrittenOffBaseQty as FWrittenOffBaseQty,ENTRY.FSubUnWriteOffBaseQty as FUnWriteOffBaseQty,").append(NEWLINE);
        } else {
            fields.append(" 0 as FWrittenOffBaseQty,0 as FUnWriteOffBaseQty,").append(NEWLINE);
        }
        fields.append(" Bill.FBizTypeID,Bill.FTransactionTypeID,").append(NEWLINE);
        fields.append(" Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.FId as FBillId,Entry.FId as FBillEntryId,").append(NEWLINE);
        if (this.isInBill(billType)) {
            fields.append(" 0 AS FCalculateKind,");
        } else {
            fields.append(" 1 AS FCalculateKind,");
        }
        fields.append(" Bill.FIsReversed,Entry.FReverseQty,");
        fields.append(" ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,");
        fields.append(" ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision,");
        fields.append(this.calParams.getBaseCurrencyPrecision()).append(" AS FLocalCurrencyPrecision,").append(NEWLINE);
        if (BillTypeEnum.MOVEIN.equals((Object)billType) || BillTypeEnum.MOVEISSUE.equals((Object)billType)) {
            fields.append(" ENTRY.FStockTransBillEntryID AS FSTOCKTRANSBILLENTRYID,").append(NEWLINE);
        } else {
            fields.append(" NULL AS FSTOCKTRANSBILLENTRYID,").append(NEWLINE);
        }
        fields.append(" BILL.FAUDITTIME,Bill.FSourceBillTypeID as FSourceBillTypeID,");
        if (this.isInBill(billType)) {
            fields.append(" ENTRY.FISPRESENT AS FISPRESENT,");
        } else {
            fields.append(" 0 AS FISPRESENT,");
        }
        fields.append(" InvUpdateType.FStoreTypeID AS FStoreTypeID, InvUpdateType.FStoreTypePreID AS FStoreTypePreID,");
        fields.append(" to_char(ENTRY.FSourceBillID) AS FSourceBillID,to_char(ENTRY.FSourceBillEntryID) AS FSourceBillEntryID,ENTRY.FSourceBillEntrySeq,").append(NEWLINE);
        fields.append(" ").append(issueType).append(" AS FOutwarehouseType,");
        fields.append("'").append(entryTab).append("' AS FEntryTableMame");
        if (this.calParams.isNeedCostCenter()) {
            if (BillTypeEnum.MATREQ.equals((Object)billType) || BillTypeEnum.MANUIN.equals((Object)billType)) {
                fields.append(",BILL.FCostCenterOrgUnitId as FCostCenter");
                fields.append(",ENTRY.FCostObjectId AS FCostObject");
            } else {
                fields.append(",null AS FCostCenter");
                fields.append(",null AS FCostObject");
            }
        }
        if (this.calParams.isNeedReWork()) {
            if (BillTypeEnum.MATREQ.equals((Object)billType)) {
                fields.append(",ENTRY.FIsReWork as FIsReWork");
            } else {
                fields.append(",0 as FIsReWork");
            }
        }
        if (BillTypeEnum.PURIN.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"PurchaseReceipt", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.MANUIN.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"ProductionReceipt", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.MOVEIN.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"StockTransferReceipt", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.OTHERIN.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"MiscellaneousReceipt", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.SALEISSUE.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"SalesDelivery", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.MATREQ.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"PickingList", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.MOVEISSUE.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"StockTransferDelivery", (Context)ctx) + "' as FBillTypeName");
        } else if (BillTypeEnum.OTHERISSUE.equals((Object)billType)) {
            fields.append(" ,'" + SCMUtils.getResource((String)CALRESOURCE, (String)"MiscellaneousDeliveryNote", (Context)ctx) + "' as FBillTypeName");
        }
        fields.append(" ,ENTRY.FBaseUnitID as FBASEUNIT , ");
        if (AccountType.SPECIAL_ACCT.equals(OneKeyCalculateParams.accountTypeThreadLocal.get())) {
            fields.append(" (case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT,");
            fields.append(" (case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID,");
            fields.append(" (case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID,");
            fields.append(" (case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID");
        } else {
            fields.append(" null as FLOT,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID").append(NEWLINE);
        }
        if (BillTypeEnum.SALEISSUE.equals((Object)billType)) {
            fields.append(" ,BILL.FisWriteOffVouched as FisWriteOffVouched ");
        } else {
            fields.append(" ,0 as FisWriteOffVouched ");
        }
        fields.append(" ,MeasureUnit.FBASECONVSRATE ");
        if (BillTypeEnum.MOVEIN.equals((Object)billType) || BillTypeEnum.MOVEISSUE.equals((Object)billType)) {
            fields.append(" ,STEntry.FbaseStatus,STEntry.FClosePeriod\t ");
        } else {
            fields.append(" ,0 as FbaseStatus,0 as FClosePeriod ");
        }
        return fields.toString();
    }

    private boolean isInBill(BillTypeEnum billType) {
        return BillTypeEnum.MANUIN.equals((Object)billType) || BillTypeEnum.PURIN.equals((Object)billType) || BillTypeEnum.MOVEIN.equals((Object)billType) || BillTypeEnum.OTHERIN.equals((Object)billType);
    }

    protected String getInOutBillSqlCaluate(BillTypeEnum billType, String billTab, String entryTempTab, String fieldSql) {
        StringBuilder sql;
        block10: {
            block9: {
                sql = new StringBuilder();
                sql.append(" select ").append(fieldSql);
                sql.append(" FROM ").append(entryTempTab).append(" ENTRY").append(NEWLINE);
                sql.append(" INNER JOIN ").append(billTab).append(" BILL ON BILL.FID = ENTRY.FParentID ").append(NEWLINE);
                if (!this.isInBill(billType) && BillTypeEnum.MOVEISSUE != billType) {
                    sql.append(this.getOutRetBillJoinSql(billTab));
                }
                if (BillTypeEnum.MOVEIN == billType || BillTypeEnum.MOVEISSUE == billType) {
                    sql.append(" LEFT JOIN T_IM_StockTransferBillEntry STEntry ");
                    sql.append(" ON ENTRY.FSTOCKTRANSBILLENTRYID = STEntry.Fid ").append(NEWLINE);
                }
                if (BillTypeEnum.PURIN.equals((Object)billType) || BillTypeEnum.SALEISSUE.equals((Object)billType) || BillTypeEnum.MATREQ.equals((Object)billType)) {
                    sql.append(" INNER JOIN T_ORG_UNITRELATION Relation ON BILL.FSTORAGEORGUNITID = Relation.FFROMUNITID ").append(NEWLINE);
                }
                sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append(NEWLINE);
                if (this.isInBill(billType)) {
                    sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypeID = StoreType.FID ").append(NEWLINE);
                } else {
                    sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FSTORETYPEPREID = StoreType.FID ").append(NEWLINE);
                }
                if (AccountType.ADD_AVERAGE == OneKeyCalculateParams.accountTypeThreadLocal.get()) break block9;
                if (AccountType.SPECIAL_ACCT != OneKeyCalculateParams.accountTypeThreadLocal.get()) break block10;
            }
            if (BillTypeEnum.SALEISSUE == billType && "1".equals(this.calParams.getNotCalConsignSale())) {
                sql.append(" LEFT JOIN T_IM_StoreType StoreTypeIn ON InvUpdateType.FStoreTypeID = StoreTypeIn.FID ").append(NEWLINE);
            }
        }
        sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID");
        sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON entry.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON entry.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ").append(NEWLINE);
        sql.append(" ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase").append(NEWLINE);
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)").append(NEWLINE);
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit").append(NEWLINE);
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)").append(NEWLINE);
        return sql.toString();
    }

    private String getOutRetBillJoinSql(String billTab) {
        StringBuffer buffer;
        block2: {
            block3: {
                buffer = new StringBuffer();
                if (!"1".equals(this.calParams.getNoSrcOutBillCalType()) && !"1".equals(this.calParams.getSrcBillPreperiodCalType())) break block2;
                if (AccountType.ADD_AVERAGE == OneKeyCalculateParams.accountTypeThreadLocal.get()) break block3;
                if (AccountType.SPECIAL_ACCT != OneKeyCalculateParams.accountTypeThreadLocal.get()) break block2;
            }
            buffer.append(" LEFT JOIN ").append(billTab).append(" SOURCEBILL ON SOURCEBILL.FID = ENTRY.FSourceBillID");
        }
        return buffer.toString();
    }

    protected String getBillBaseWhereSql(boolean isJump) {
        StringBuilder sql = new StringBuilder();
        sql.append(" WHERE BILL.FBaseStatus = ").append(4).append(NEWLINE);
        sql.append(" AND ISNULL(BILL.FIsInitBill, 0) = 0").append(NEWLINE);
        if (!this.calParams.isCalReversed()) {
            sql.append(" AND ISNULL(Bill.FIsReversed, 0) = 0").append(NEWLINE);
        }
        sql.append(" AND StoreType.FIsForwardAmt = 1").append(NEWLINE);
        sql.append(" AND ENTRY.FCompanyOrgUnitID = '").append(this.calParams.getCompanyInfo().getId().toString()).append("'").append(NEWLINE);
        if (isJump) {
            sql.append(" AND Bill.FBizTypeID = '").append("YJN9V65PSkutQxeUH6F72SQHQ1w=").append("'").append(NEWLINE);
        }
        return sql.toString();
    }

    protected String getPeroidWhereSql(PeriodInfo periodInfo, boolean includePrePeriod, boolean includeCurPeriod, boolean includeAfterPeriod) {
        StringBuilder sql = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        if (includePrePeriod && !includeCurPeriod && !includeAfterPeriod) {
            sql.append(" AND BILL.FBIZDATE < TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND ENTRY.FBIZDATE < TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
        }
        if (!includePrePeriod && includeCurPeriod && includeAfterPeriod) {
            sql.append(" AND BILL.FBIZDATE >=TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND ENTRY.FBIZDATE >=TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
        }
        if (includePrePeriod && includeCurPeriod && !includeAfterPeriod) {
            sql.append(" AND BILL.FBIZDATE  <= TO_DATE('").append(format.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND ENTRY.FBIZDATE <= TO_DATE('").append(format.format((Object)periodInfo.getEndDate())).append("')");
        }
        if (!includePrePeriod && includeCurPeriod && !includeAfterPeriod) {
            sql.append(" AND (BILL.fyear = " + periodInfo.getPeriodYear() + " and BILL.Fperiod = " + periodInfo.getPeriodNumber() + ")");
            sql.append(" AND (BILL.FBIZDATE >=TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND BILL.FBIZDATE <=TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("'))");
            sql.append(" AND (ENTRY.FBIZDATE >=TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND ENTRY.FBIZDATE <=TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("'))");
        }
        return sql.toString();
    }

    protected String getInsertInOutTempSql(boolean costMoveInByIssue) {
        StringBuffer buffer = new StringBuffer();
        if (costMoveInByIssue) {
            buffer.append("INSERT INTO ").append(this.tempManager.getCostMoveOutTemp());
        } else {
            buffer.append("INSERT INTO ").append(this.tempManager.getInOutBillTemp());
        }
        buffer.append("(FID,FBillId,FBillEntryId,FEntryTableMame,FNumber,FBizDate,FCompanyOrgUnitID,FMaterialId,").append(NEWLINE);
        buffer.append(" FStorageorg,Fstorageorgunitid,Fwarehouse,Fwarehouseid,FBaseQty,FBaseQtyBak,FActualCost,FPrice,FReverseQty,FPricePrecision,FQtyPrecision,").append(NEWLINE);
        buffer.append(" FLocalCurrencyPrecision,FCalculateKind,FbillTypeID,FTransactionTypeName,FSeqNum,FFiVouchered,FBizTypeID,FSourceBillID,FSourceBillEntryID,FSourceBillEntrySeq,").append(NEWLINE);
        buffer.append(" FSourceUnitActualCost,FActualCostBak,FmaterialNumber,FisCombition,FisSrcBilInCurrPid,FISPRESENT,FStockTransBillEntryID,FAUDITTIME,").append(NEWLINE);
        buffer.append(" FSourceBillTypeID,FIsReversed,FIsReWork,FOutwarehouseType,FStoreTypeID,FStoreTypePreID,FBillTypeName,FBaseUnit,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,").append(NEWLINE);
        buffer.append(" FUnitID,FQty,FWrittenOffBaseQty,FUnWriteOffBaseQty,FisWriteOffVouched,FBASECONVSRATE,FStockStatus,FStockClosePeriod)").append(NEWLINE);
        buffer.append(NEWLINE);
        return buffer.toString();
    }

    protected String getInOutBillTempSqlSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Bill.FBillEntryId,Bill.FBillId,Bill.FBillEntryId,FEntryTableMame,Bill.FNumber,Bill.FBizDate,").append(NEWLINE);
        sql.append(" Bill.FCompanyOrgUnitID,Bill.FMaterialId,Bill.FStorageorg,Bill.Fstorageorgunitid,Bill.Fwarehouse,Bill.Fwarehouseid,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end,").append(NEWLINE);
        sql.append(" Bill.FBaseUnitActualCost as FPrice,Bill.FReverseQty,");
        sql.append(" Bill.FPricePrecision,Bill.FQtyPrecision,Bill.FLocalCurrencyPrecision,");
        sql.append(" Bill.FCalculateKind,Bill.FbillTypeID,Bill.FTransactionTypeName,Bill.FSeqNum,").append(NEWLINE);
        sql.append(" ISNULL(Bill.FFiVouchered, 0) AS FFiVouchered,Bill.FBizTypeID,Bill.FSourceBillID,Bill.FSourceBillEntryID,").append(NEWLINE);
        sql.append(" Bill.FSourceBillEntrySeq,0 AS FSourceUnitActualCost,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end,").append(NEWLINE);
        sql.append(" Bill.FmaterialNumber, 0 AS FisCombition,0 AS FisSrcBilInCurrPid,Bill.FIsPresent,BILL.FStockTransBillEntryID,").append(NEWLINE);
        sql.append(" BILL.FAUDITTIME,Bill.FSourceBillTypeID,Bill.FIsReversed,Bill.FIsReWork,").append(NEWLINE);
        sql.append(" Bill.FOutwarehouseType,Bill.FStoreTypeID,Bill.FStoreTypePreID,Bill.FBillTypeName,Bill.FBaseUnit,Bill.FLot,Bill.FAssistPropertyID,Bill.FProjectID,Bill.FTrackNumberID,").append(NEWLINE);
        sql.append(" Bill.FUnitID,Bill.FQty,Bill.FWrittenOffBaseQty,Bill.FUnWriteOffBaseQty,Bill.FisWriteOffVouched,Bill.FBASECONVSRATE,Bill.FbaseStatus,Bill.FClosePeriod").append(NEWLINE);
        return sql.toString();
    }

    protected String getBalanceTempSqlCalculate(Context ctx) {
        StringBuilder sql;
        String calType;
        String periodBeginTableName;
        block10: {
            block9: {
                periodBeginTableName = this.calParams.getInvBalanceTempTbl();
                AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
                if (accountType != null && accountType.getValue() == 4) {
                    periodBeginTableName = this.calParams.getClBalanceTempTbl();
                }
                PeriodInfo periodInfo = this.calParams.getPeriodInfo();
                calType = this.calParams.getCalType();
                sql = new StringBuilder();
                sql.append(" SELECT");
                sql.append(this.getBeginBalanceFieldsCalculate(ctx, periodBeginTableName));
                sql.append(" FROM ").append(periodBeginTableName).append(" AS ENTRY").append(NEWLINE);
                sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL ON ENTRY.FMaterialID = MATERIAL.FId").append(NEWLINE);
                sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT.FID").append(NEWLINE);
                sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON ENTRY.FWareHouseID = WAREHOUSE.FID").append(NEWLINE);
                sql.append(" LEFT JOIN T_IM_STORETYPE STORETYPE ON ENTRY.FStoreTypeId = STORETYPE.FID").append(NEWLINE);
                sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
                sql.append(" ON (entry.FMaterialId = MATERIALCOMPANY.FMaterialID").append(NEWLINE);
                sql.append(" AND entry.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append(NEWLINE);
                sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
                sql.append(" ON (MATERIAL.FID = MeasureUnitBase.FMaterialid");
                sql.append(" AND MATERIAL.FBASEUNIT = MeasureUnitBase.FMeasureUnitID)").append(NEWLINE);
                sql.append(this.getCalUnitJoinFilter());
                sql.append(" WHERE ENTRY.FYear = ").append(periodInfo.getPeriodYear());
                sql.append(" AND ENTRY.FPeriod = ").append(periodInfo.getPeriodNumber()).append(NEWLINE);
                sql.append(this.getCalUnitWhereFilter());
                if (OneKeyCalculateParams.accountTypeThreadLocal.get() == AccountType.ADD_AVERAGE) break block9;
                if (OneKeyCalculateParams.accountTypeThreadLocal.get() != AccountType.SPECIAL_ACCT) break block10;
            }
            if (this.calParams.getNotCalConsignSale().equals("1")) {
                sql.append(" AND STORETYPE.FID != '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append(NEWLINE);
            }
        }
        if ("T_IM_InventoryBalance".equalsIgnoreCase(periodBeginTableName)) {
            sql.append(" AND ENTRY.FISCALCULATE = 1").append(NEWLINE);
            if ("0".equals(calType)) {
                sql.append(" AND ENTRY.FMOVETYPE = 0 ");
            } else if ("1".equals(calType)) {
                sql.append(" AND ENTRY.FMOVETYPE <> 2 ");
            }
        }
        sql.append(" AND STORETYPE.FIsForwardAmt = 1").append(NEWLINE);
        return sql.toString();
    }

    private String getBalanceAndCostAdjSelectSql() {
        int baseCurrencyPresision = this.calParams.getBaseCurrencyPrecision();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT temp.FBillEntryId,temp.FBillId,temp.FBillEntryId,temp.FEntryTableMame,temp.FNumber,temp.FBizDate,temp.FCompanyOrgUnitID,").append(NEWLINE);
        sql.append(" temp.FMaterialId,temp.Fstorageorg,temp.Fstorageorgunitid,temp.Fwarehouse,temp.Fwarehouseid,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else temp.FBaseQty end,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else temp.FBaseQty end,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else temp.FActualCost end,").append(NEWLINE);
        sql.append(" temp.FBaseUnitActualCost as FPrice,temp.FReverseQty,temp.FPricePrecision,isnull(temp.FQtyPrecision,4),");
        sql.append(baseCurrencyPresision).append(" AS FLocalCurrencyPrecision,").append(NEWLINE);
        sql.append(" temp.FCalculateKind,temp.FbillTypeID,temp.FTransactionTypeName,temp.FSeqNum,ISNULL(temp.FFiVouchered, 0) AS FFiVouchered,").append(NEWLINE);
        sql.append(" temp.FBizTypeID,temp.FSourceBillID,temp.FSourceBillEntryID,temp.FSourceBillEntrySeq,0 AS FSourceUnitActualCost,").append(NEWLINE);
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else temp.FActualCost end,temp.FmaterialNumber,").append(NEWLINE);
        sql.append(" 0 AS FisCombition,0 AS FisSrcBilInCurrPid,temp.FIsPresent,temp.FStockTransBillEntryID,temp.FAUDITTIME,temp.FSourceBillTypeID,").append(NEWLINE);
        sql.append(" temp.FIsReversed,");
        sql.append(" temp.FIsReWork,temp.FOutwarehouseType,temp.FStoreTypeID,temp.FStoreTypePreID,temp.FBillTypeName,temp.FBaseUnit,");
        sql.append(" temp.FLot,temp.FAssistPropertyID,temp.FProjectID,temp.FTrackNumberID, ");
        sql.append(" temp.FUnitID,temp.FQty,temp.FWrittenOffBaseQty,temp.FUnWriteOffBaseQty,temp.FisWriteOffVouched,temp.FBASECONVSRATE,");
        sql.append(" null as FbaseStatus,null as FClosePeriod ").append(NEWLINE);
        return sql.toString();
    }

    private String getBeginBalanceFieldsCalculate(Context ctx, String balanceTab) {
        StringBuilder fields = new StringBuilder();
        fields.append(" Entry.FMaterialID,ENTRY.FCompanyOrgUnitId FCompanyOrgUnitID,");
        fields.append(" STORAGEORGUNIT.FNUMBER Fstorageorg,WAREHOUSE.FNUMBER Fwarehouse,");
        fields.append(" Entry.FStorageOrgUnitID AS FStorageOrgUnitID,ENTRY.FWarehouseID AS FWarehouseID,");
        fields.append(" FPeriodBeginCostDiff AS FPeriodBeginCostDiff");
        fields.append(" ,FPeriodBeginBalance AS FPeriodBeginBalance");
        fields.append(" ,0 AS FIncomeCostAdjustAmt,").append(NEWLINE);
        fields.append(" 0 AS FStandardCost,0 AS FActualCost,0 AS FBaseQty,0 AS FBaseUnitActualCost");
        fields.append(" ,FPeriodBeginQty AS FPeriodBeginQty,").append(NEWLINE);
        fields.append(" null as FBillTypeID,");
        fields.append("N'").append(SCMUtils.getResource((String)CALRESOURCE, (String)"PERIOD_BEGIN_CLOSE_ACCOUNT", (Context)ctx)).append("' as FNumber");
        fields.append(",TO_DATE('1900-01-01 00:00:00.000') as FBizDate, ").append(NEWLINE);
        fields.append(" NULL as FBizTypeID,N'' AS FTRANSACTIONTYPENAME,0 as FFiVouchered,FSeqNum,Entry.FId as FBillId,Entry.FId as FBillEntryId,2 AS FCalculateKind,").append(NEWLINE);
        fields.append(" 0 AS FIsReversed,0 as FReverseQty,NULL AS FStockTransBillEntryID,TO_DATE('1900-01-01 00:00:00.000') as FAUDITTIME,").append(NEWLINE);
        fields.append(" NULL as FSourceBillTypeID,MATERIAL.FNUMBER AS FMATERIALNUMBER,").append(NEWLINE);
        fields.append(" MATERIAL.FBASEUNIT,isnull(MEASUREUNITBASE.FQTYPRECISION,4) as FQtyPrecision ,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,0 AS FISPRESENT, ");
        fields.append(" NULL AS FSourceBillID,NULL AS FSourceBillEntryID,0 AS FSourceBillEntrySeq,").append(NEWLINE);
        fields.append(" ").append(-1).append(" AS FOutwarehouseType");
        fields.append(",'").append(balanceTab).append("' AS FEntryTableMame");
        if (this.calParams.isNeedCostCenter()) {
            fields.append(",null AS FCostCenter");
            fields.append(",null AS FCostObject");
        }
        if (this.calParams.isNeedReWork()) {
            fields.append(",0 as FIsReWork");
        }
        fields.append(",Entry.FStoreTypeId as FStoreTypeId, NULL as FStoreTypePreId");
        fields.append(" ,N'' AS FBillTypeName,");
        if (AccountType.SPECIAL_ACCT.equals(OneKeyCalculateParams.accountTypeThreadLocal.get())) {
            fields.append(" (case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT,");
            fields.append(" (case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID,");
            fields.append(" (case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID,");
            fields.append(" (case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID,");
        } else {
            fields.append(" null as FLOT,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,").append(NEWLINE);
        }
        fields.append(" null as FUnitID");
        fields.append(" ,0 as FQty");
        fields.append(" ,0 as FWrittenOffBaseQty");
        fields.append(" ,0 as FUnWriteOffBaseQty");
        fields.append(" ,0 as FisWriteOffVouched");
        fields.append(" ,0 as FBASECONVSRATE");
        return fields.toString();
    }

    protected void setCostMoveIsCalculate(OneKeyBillCostInfo bill) {
        String calType = this.calParams.getCalType();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        if (bill.isCostPriceMove()) {
            if (this.isPrePeriodBill(bill, periodInfo)) {
                bill.setCalculate(false);
                bill.setDealComplete(true);
            } else if ("2".equals(calType)) {
                bill.setCalculate(true);
            } else if ("1".equals(calType)) {
                if (bill.isMoveInCostPriceStorage()) {
                    bill.setCalculate(true);
                } else {
                    bill.setCalculate(false);
                }
            } else {
                bill.setCalculate(false);
            }
        }
    }

    protected boolean isPrePeriodBill(OneKeyBillCostInfo billInfo, PeriodInfo periodInfo) {
        if (billInfo != null && periodInfo != null && billInfo.getEntryTableMame() != null && !billInfo.getEntryTableMame().equalsIgnoreCase("T_IM_InventoryBalance") && !billInfo.getEntryTableMame().equalsIgnoreCase("T_CL_InventoryBalance")) {
            return periodInfo.getBeginDate().compareTo(billInfo.getBizDate()) > 0;
        }
        return false;
    }

    protected void buildCostPriceMove(OneKeyBillCostInfo bill, HashMap costMoveMap) {
        if (bill.isCostPriceMove()) {
            OneKeyBillCostInfo costMoveBill = null;
            if (costMoveMap.get(bill.getStockTransBillEntryId()) == null) {
                costMoveBill = new OneKeyBillCostInfo();
                costMoveBill.setStockTransBillEntryId(bill.getStockTransBillEntryId());
                costMoveMap.put(bill.getStockTransBillEntryId(), costMoveBill);
            } else {
                costMoveBill = (OneKeyBillCostInfo)costMoveMap.get(bill.getStockTransBillEntryId());
            }
            if (bill.isMoveOutBill()) {
                costMoveBill.addMoveOutbillList(bill);
            } else if (bill.isMoveInBill()) {
                costMoveBill.addMoveInbillList(bill);
            }
        }
    }

    protected void buildMatAttrChange(OneKeyBillCostInfo bill, HashMap matAttrChgMap) {
        String sourceEntryID = bill.getSourceBillEntryId();
        MatAttrChangeVO vo = (MatAttrChangeVO)matAttrChgMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatAttrChangeVO(sourceEntryID);
        }
        if (bill.isOutBill()) {
            vo.addOutBill(bill);
        } else {
            vo.addInBill(bill);
        }
        matAttrChgMap.put(sourceEntryID, vo);
    }

    protected void handleSrcBill(List srcBillList, OneKeyBillCostInfo info) {
        BigDecimal totalAmount = CalculateUtil.ZERO;
        BigDecimal totalQty = CalculateUtil.ZERO;
        OneKeyBillCostInfo tmpInfo = null;
        OneKeyBillCostInfo lastInfo = null;
        boolean isAdjSeq = false;
        for (int i = 0; srcBillList != null && i < srcBillList.size(); ++i) {
            tmpInfo = (OneKeyBillCostInfo)srcBillList.get(i);
            if (!tmpInfo.isDealComplete()) {
                lastInfo = tmpInfo;
            }
            totalQty = totalQty.add(tmpInfo.getRecentQty().abs());
            if (i == srcBillList.size() - 1 && totalQty.compareTo(info.getRecentQty()) == 0) {
                if (tmpInfo.isDealComplete()) {
                    tmpInfo = lastInfo;
                    isAdjSeq = true;
                }
                if (tmpInfo == null) continue;
                if (tmpInfo.isRedBill()) {
                    tmpInfo.setRecentCost(info.getRecentCost().subtract(totalAmount).negate());
                } else if (isAdjSeq) {
                    if ((totalAmount = totalAmount.add(((OneKeyBillCostInfo)srcBillList.get(i)).getRecentCost().abs())).compareTo(info.getRecentCost()) != 0) {
                        tmpInfo.setRecentCost(tmpInfo.getRecentCost().add(info.getRecentCost().subtract(totalAmount)));
                    }
                } else {
                    tmpInfo.setRecentCost(info.getRecentCost().subtract(totalAmount));
                }
                tmpInfo.setNeedUpdate(true);
                if (!tmpInfo.isDealComplete()) {
                    tmpInfo.setPriceSource(PriceSourEnum.sourBillPrice);
                }
                tmpInfo.setPrice(info.getPrice());
                break;
            }
            if (!tmpInfo.isDealComplete()) {
                tmpInfo.setRecentCost(tmpInfo.getRecentQty().multiply(info.getPrice()).setScale(tmpInfo.getBaseCurrencyPrecision(), 4));
                tmpInfo.setPrice(info.getPrice());
                if (!tmpInfo.isDealComplete()) {
                    tmpInfo.setPriceSource(PriceSourEnum.sourBillPrice);
                }
                tmpInfo.setNeedUpdate(true);
            }
            tmpInfo.setNotUpdateCostAgain(true);
            totalAmount = totalAmount.add(tmpInfo.getRecentCost().abs());
        }
    }

    public void updateMoveLocationBill(Context ctx, Map balanceMap, List keyList, CalculateUnitInfo calculateUnitInfo) throws BOSException, SQLException {
        String strCalType = this.calParams.getCalType();
        String materialId = calculateUnitInfo.getMaterialId();
        if ("0".equals(this.calParams.getCalMoveLocationBill()) || !this.updateMoveLocMat.contains(materialId)) {
            return;
        }
        BigDecimal price = BigDecimal.ZERO;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> totalUpdateSql = new ArrayList<String>();
        String fKey = null;
        OneKeyBalanceCostInfo balanceCostInfo = null;
        OneKeyBillCostInfo resultInfo = null;
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String companyId = this.calParams.getCompanyInfo().getId().toString();
        String storageOrgUnitID = null;
        String wareHouseID = null;
        int currencyPrecision = this.calParams.getBaseCurrencyPrecision();
        BigDecimal minValueByScale = RecentCostHelp.getMinValueByScale(currencyPrecision, 1);
        int pricePercision = 6;
        String[] calModel = null;
        String getPrecisionSql = "select FPRICEPRECISION from t_bd_material where fid='" + materialId + "'";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getPrecisionSql);
        if (rs.next()) {
            pricePercision = rs.getInt("FPRICEPRECISION");
        }
        Map paramFromKey = null;
        for (int i = 0; i < keyList.size(); ++i) {
            fKey = keyList.get(i).toString();
            paramFromKey = this.getParamFromKey(fKey);
            storageOrgUnitID = (String)paramFromKey.get("storageOrgUnitID");
            wareHouseID = (String)paramFromKey.get("wareHouseID");
            if (AccountType.SPECIAL_ACCT == OneKeyCalculateParams.accountTypeThreadLocal.get()) {
                calModel = new String[]{(String)paramFromKey.get("LOT"), (String)paramFromKey.get("AssistPropertyID"), (String)paramFromKey.get("ProjectID"), (String)paramFromKey.get("TrackNumberID")};
            }
            if ((resultInfo = (balanceCostInfo = (OneKeyBalanceCostInfo)balanceMap.get(fKey)).getReusltBillInfo()).isExceptionState() || resultInfo.getRecentQty().compareTo(BigDecimal.ZERO) > 0 && resultInfo.getRecentCost().compareTo(BigDecimal.ZERO) < 0) continue;
            if (resultInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
                paramFromKey.put("materialId", materialId);
                this.updateMovLocList.add(paramFromKey);
                continue;
            }
            price = resultInfo.getRecentCost().divide(resultInfo.getRecentQty(), pricePercision, 4);
            sql.setLength(0);
            sql.append(this.getMoveLocationUpdateSql(periodInfo, companyId, materialId, currencyPrecision, minValueByScale, pricePercision, price));
            if ("1".equals(strCalType)) {
                sql.append(" and entry.FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
            } else if ("2".equals(strCalType)) {
                sql.append(" and entry.FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
                sql.append(" and entry.FWAREHOUSEID = '").append(wareHouseID).append("'");
            }
            if (AccountType.SPECIAL_ACCT == OneKeyCalculateParams.accountTypeThreadLocal.get()) {
                if (calModel[0] != null && !"X".equals(calModel[0])) {
                    sql.append("  And entry.FLot = '").append(calModel[0]).append("'");
                }
                if (calModel[1] != null && !"X".equals(calModel[1])) {
                    sql.append("  And entry.FAssistPropertyID = '").append(calModel[1]).append("'");
                }
                if (calModel[2] != null && !"X".equals(calModel[2])) {
                    sql.append("  And entry.FProjectID = '").append(calModel[2]).append("'");
                }
                if (calModel[3] != null && !"X".equals(calModel[3])) {
                    sql.append("  And entry.FTrackNumberID = '").append(calModel[3]).append("'");
                }
            }
            sql.append(" )");
            totalUpdateSql.add(sql.toString());
            if (totalUpdateSql.size() <= 500) continue;
            DBUtil.execBatchSql(ctx, totalUpdateSql, true);
            totalUpdateSql.clear();
        }
        if (totalUpdateSql != null && !totalUpdateSql.isEmpty()) {
            DBUtil.execBatchSql(ctx, totalUpdateSql, true);
        }
    }

    protected String getMoveLocationUpdateSql(PeriodInfo periodInfo, String companyId, String materialId, int currencyPrecision, BigDecimal minValueByScale, int pricePercision, BigDecimal price) {
        StringBuffer updateSql = new StringBuffer();
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            updateSql.append("update T_IM_MOVELOCATIONBILLENTRY T set (FPRICE,FAMOUNT) = (select 0,0 ");
        } else {
            updateSql.append("update T_IM_MOVELOCATIONBILLENTRY T set (FPRICE,FAMOUNT) = (select ");
            updateSql.append(" case when ROUND(entry.FBASEQTY*").append(price).append(",").append(currencyPrecision).append(") = 0 ");
            updateSql.append("  then Round(").append(minValueByScale).append("/entry.FQTY," + pricePercision + ")");
            updateSql.append(" else Round(ROUND(entry.FBASEQTY*").append(price).append(",").append(currencyPrecision).append(")/entry.FQTY," + pricePercision + ") end as fprice,");
            updateSql.append(" case when ROUND(entry.FBASEQTY*").append(price).append(",").append(currencyPrecision).append(") = 0 ");
            updateSql.append(" then ").append(minValueByScale).append(" else ROUND(entry.FBASEQTY*").append(price).append(",").append(currencyPrecision).append(") end as famount");
        }
        updateSql.append(" from T_IM_MOVELOCATIONBILLENTRY entry inner join T_IM_MOVELOCATIONBILL bill on entry.FPARENTID = bill.FID ");
        updateSql.append(" where T.FID = entry.FID and bill.FBASESTATUS = 4 ");
        updateSql.append(" and bill.FYEAR =").append(periodInfo.getPeriodYear());
        updateSql.append(" and bill.FPERIOD =").append(periodInfo.getPeriodNumber());
        updateSql.append(" and entry.FMATERIALID ='").append(materialId).append("'");
        updateSql.append(" and entry.FCOMPANYORGUNITID ='").append(companyId).append("'");
        return updateSql.toString();
    }

    protected void calCostMoveBill(OneKeyBillCostInfo costMoveObj, OneKeyBillCostInfo bill, boolean isMoveInbill) throws CalculateException {
        OneKeyBillCostInfo needUpdateMoveCostBill = null;
        ArrayList needUpdateMoveCostList = null;
        OneKeyBillCostInfo currResultBill = null;
        ArrayList<Object> currResultBillList = null;
        int listIndex = 0;
        if (costMoveObj == null) {
            return;
        }
        currResultBillList = costMoveObj.getMoveBillList();
        if (currResultBillList == null) {
            ArrayList tempList = costMoveObj.getMoveOutbillList();
            currResultBillList = new ArrayList<Object>();
            for (int i = 0; i < tempList.size(); ++i) {
                currResultBillList.add(((OneKeyBillCostInfo)tempList.get(i)).clone());
            }
            costMoveObj.setMoveBillList(currResultBillList);
        }
        if ((needUpdateMoveCostList = isMoveInbill ? costMoveObj.getMoveOutbillList() : costMoveObj.getMoveInbillList()) != null) {
            OneKeyBillCostInfo info;
            if (currResultBillList == null || currResultBillList.isEmpty()) {
                throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{costMoveObj.getMaterialNumber()});
            }
            currResultBill = (OneKeyBillCostInfo)currResultBillList.get(listIndex++);
            BigDecimal currResultQty = currResultBill.getRecentQty();
            BigDecimal currResultCost = currResultBill.getRecentCost();
            BigDecimal avgPrice = BigDecimal.ZERO;
            int adjustIndex = -1;
            BigDecimal maxQty = BigDecimal.ZERO;
            BigDecimal outTotalAmount = BigDecimal.ZERO;
            BigDecimal inTotalAmount = BigDecimal.ZERO;
            for (int i = 0; i < needUpdateMoveCostList.size(); ++i) {
                needUpdateMoveCostBill = (OneKeyBillCostInfo)needUpdateMoveCostList.get(i);
                if (!needUpdateMoveCostBill.isDealComplete()) {
                    needUpdateMoveCostBill.setPriceSource(PriceSourEnum.costMove);
                }
                if (isMoveInbill) continue;
                BigDecimal qty = needUpdateMoveCostBill.getRecentQty();
                BigDecimal amount = BigDecimal.ZERO;
                while (currResultQty.compareTo(qty) < 0 && listIndex < currResultBillList.size()) {
                    qty = qty.subtract(currResultQty);
                    amount = amount.add(currResultCost);
                    outTotalAmount = outTotalAmount.add(currResultCost);
                    currResultBill.setRecentQty(BigDecimal.ZERO);
                    currResultBill.setRecentCost(BigDecimal.ZERO);
                    currResultBill = (OneKeyBillCostInfo)currResultBillList.get(listIndex++);
                    currResultQty = currResultBill.getRecentQty();
                    currResultCost = currResultBill.getRecentCost();
                }
                if (listIndex >= currResultBillList.size() && qty.compareTo(currResultCost) > 1) {
                    throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{bill.getMaterialNumber()});
                }
                if (currResultQty.compareTo(qty) == 0) {
                    amount = amount.add(currResultCost);
                    outTotalAmount = outTotalAmount.add(currResultCost);
                    currResultQty = BigDecimal.ZERO;
                    currResultCost = BigDecimal.ZERO;
                } else {
                    BigDecimal amt = qty.multiply(currResultBill.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4);
                    if (amt.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) != 0 && currResultBill.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                        amt = RecentCostHelp.getMinValueByScale(bill.getBaseCurrencyPrecision(), qty.signum());
                    }
                    amount = amount.add(amt);
                    outTotalAmount = outTotalAmount.add(amt);
                    currResultQty = currResultQty.subtract(qty);
                    currResultCost = currResultCost.subtract(amt);
                }
                currResultBill.setRecentQty(currResultQty);
                currResultBill.setRecentCost(currResultCost);
                if (!needUpdateMoveCostBill.isDealComplete() && !needUpdateMoveCostBill.isNeedUpdate()) {
                    if (maxQty.compareTo(needUpdateMoveCostBill.getRecentQty()) <= 0) {
                        adjustIndex = i;
                        maxQty = needUpdateMoveCostBill.getRecentQty();
                    }
                    needUpdateMoveCostBill.setRecentCost(amount);
                    avgPrice = amount.divide(needUpdateMoveCostBill.getRecentQty(), bill.getPricePrecision(), 4);
                    needUpdateMoveCostBill.setPrice(avgPrice);
                    needUpdateMoveCostBill.setNeedUpdate(true);
                }
                inTotalAmount = inTotalAmount.add(needUpdateMoveCostBill.getRecentCost());
            }
            this.clearDealedInpourList(currResultBillList);
            if (!isMoveInbill && currResultBillList.size() == 1 && (info = (OneKeyBillCostInfo)currResultBillList.get(0)).getRecentQty().compareTo(BigDecimal.ZERO) == 0 && adjustIndex != -1) {
                needUpdateMoveCostBill = (OneKeyBillCostInfo)needUpdateMoveCostList.get(adjustIndex);
                BigDecimal diff = outTotalAmount.subtract(inTotalAmount);
                needUpdateMoveCostBill.setRecentCost(needUpdateMoveCostBill.getRecentCost().add(diff));
                OneKeyCalculateHelper.calculateAvgPrice(needUpdateMoveCostBill);
                if (needUpdateMoveCostBill.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                    needUpdateMoveCostBill.setDealdiffOK(false);
                    needUpdateMoveCostBill.setRecentCost(needUpdateMoveCostBill.getRecentQty().multiply(BigDecimal.ZERO).setScale(bill.getBaseCurrencyPrecision(), 4));
                    needUpdateMoveCostBill.setPrice(BigDecimal.ZERO);
                }
            }
        }
    }

    protected void clearDealedInpourList(ArrayList rsInpour) {
        for (int i = rsInpour.size() - 1; i >= 0; --i) {
            OneKeyBillCostInfo settleAccounts = (OneKeyBillCostInfo)rsInpour.get(i);
            BigDecimal baseqtyInpour = settleAccounts.getRecentQty();
            BigDecimal amtInpour = settleAccounts.getRecentCost();
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0 || CalculateUtil.ZERO.compareTo(amtInpour) != 0 || rsInpour.size() <= 1) continue;
            rsInpour.remove(i);
        }
    }

    public Map getParamFromKey(String keyId) {
        String strCalType = this.calParams.getCalType();
        HashMap<String, String> keyParam = new HashMap<String, String>();
        if (keyId.length() > 0) {
            String[] temp = keyId.split("\\_\\$\\$\\$\\$\\_");
            keyParam.put("companyOrgUnitID", temp[0]);
            if ("1".equals(strCalType)) {
                keyParam.put("storageOrgUnitID", temp[1]);
            } else if ("2".equals(strCalType)) {
                keyParam.put("storageOrgUnitID", temp[1]);
                keyParam.put("wareHouseID", temp[2]);
            }
            if (AccountType.SPECIAL_ACCT == OneKeyCalculateParams.accountTypeThreadLocal.get()) {
                String key = "X";
                if (!key.equals(temp[temp.length - 4])) {
                    keyParam.put("Lot", temp[temp.length - 4]);
                }
                if (!key.equals(temp[temp.length - 3])) {
                    keyParam.put("AssistPropertyID", temp[temp.length - 3]);
                }
                if (!key.equals(temp[temp.length - 2])) {
                    keyParam.put("ProjectID", temp[temp.length - 2]);
                }
                if (!key.equals(temp[temp.length - 1])) {
                    keyParam.put("TrackNumberID", temp[temp.length - 1]);
                }
            }
        }
        return keyParam;
    }

    protected void updateToPrePeriodCostMovePrice(HashMap prePeriodCostMoveMap, HashMap costMoveMap, List inBillNeddUpdated) throws CalculateException {
        if (prePeriodCostMoveMap == null || costMoveMap == null || inBillNeddUpdated == null) {
            return;
        }
        OneKeyBillCostInfo bill2 = null;
        OneKeyBillCostInfo costMoveObj = null;
        OneKeyBillCostInfo moveCostBill = null;
        for (OneKeyBillCostInfo bill2 : prePeriodCostMoveMap.values()) {
            if (bill2 == null) continue;
            this.synCostMovePriceBill(costMoveMap, bill2);
            if (((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get()).equals((Object)AccountType.FIN_FOUT) || (costMoveObj = (OneKeyBillCostInfo)costMoveMap.get(bill2.getStockTransBillEntryId())) == null || costMoveObj.getMoveInbillList() == null) continue;
            ArrayList moveCostList = costMoveObj.getMoveInbillList();
            for (int j = 0; j < moveCostList.size(); ++j) {
                moveCostBill = (OneKeyBillCostInfo)moveCostList.get(j);
                if (moveCostBill.isDealComplete()) continue;
                inBillNeddUpdated.add(moveCostBill);
            }
        }
    }

    protected void synCostMovePriceBill(HashMap costMoveMap, OneKeyBillCostInfo bill) throws CalculateException {
        if (bill.isCostPriceMove()) {
            OneKeyBillCostInfo costMoveObj = (OneKeyBillCostInfo)costMoveMap.get(bill.getStockTransBillEntryId());
            boolean isMoveInbill = false;
            if (bill.isMoveInBill()) {
                isMoveInbill = true;
            }
            if (!isMoveInbill && costMoveObj != null) {
                OneKeyBillCostInfo moveCostBill = null;
                ArrayList moveCostList = costMoveObj.getMoveOutbillList();
                for (int i = 0; i < moveCostList.size(); ++i) {
                    moveCostBill = (OneKeyBillCostInfo)moveCostList.get(i);
                    if (moveCostBill.isDealComplete() || moveCostBill.isNeedUpdate()) continue;
                    return;
                }
            }
            this.calCostMoveBill(costMoveObj, bill, isMoveInbill);
        }
    }

    protected BigDecimal getPrice(Context ctx, OneKeyBillCostInfo billInfo) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        String companyId = billInfo.getCompanyOrgUnitId();
        String materialId = billInfo.getMaterialId();
        int priceType = Integer.parseInt(this.calParams.getZeroGetCostType());
        if (priceType == 0) {
            newPrice = this.getNewInOrOutPrice(ctx, billInfo, true, false, false);
        } else if (priceType == 1) {
            newPrice = this.getNewInOrOutPrice(ctx, billInfo, true, true, false);
        } else if (priceType == 2) {
            newPrice = this.getMaterialStandardCost(ctx, companyId, materialId);
        } else if (priceType == 4) {
            newPrice = this.getNewInOrOutPrice(ctx, billInfo, true, false, true);
        }
        return newPrice;
    }

    protected void handleBlueBillAndRedBillRel(List redList, OneKeyBillCostInfo info) {
        OneKeyBillCostInfo billInfo = null;
        ArrayList<OneKeyBillCostInfo> redBillList = new ArrayList<OneKeyBillCostInfo>();
        for (int i = 0; i < redList.size(); ++i) {
            billInfo = (OneKeyBillCostInfo)redList.get(i);
            if (!billInfo.isRedBill() || !info.getBillEntryId().equals(billInfo.getSourceBillEntryId()) || billInfo.getEntryTableMame() == null || !billInfo.getEntryTableMame().equals(info.getEntryTableMame())) continue;
            redBillList.add(billInfo);
        }
        info.setRedBillList(redBillList);
        if (redBillList != null && !redBillList.isEmpty()) {
            this.handleSrcBill(redBillList, info);
        }
    }

    protected BigDecimal getMaterialStandardCost(Context ctx, String companyId, String materialId) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        if (companyId == null || materialId == null) {
            return newPrice;
        }
        String getMaterialStandardCostSql = "select ISNULL(FStandardCost,0) as FStandardCost from T_BD_MaterialCompanyInfo where FMaterialid='" + materialId + "' and FCompanyid='" + companyId + "'";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getMaterialStandardCostSql);
        try {
            if (rs.next()) {
                newPrice = rs.getBigDecimal("FStandardCost");
            }
            return newPrice;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BigDecimal getNewInOrOutPrice(Context ctx, OneKeyBillCostInfo billInfo, boolean includeBeforePeriod, boolean isInPrice, boolean isSaleRe) throws BOSException {
        String companyId = billInfo.getCompanyOrgUnitId();
        String materialId = billInfo.getMaterialId();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        BigDecimal newPrice = CalculateUtil.ZERO;
        if (companyId == null || materialId == null || periodInfo == null) {
            return newPrice;
        }
        String getSQL = this.getNewInOrOutPriceSQL(billInfo, includeBeforePeriod, isInPrice, isSaleRe);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getSQL);
        try {
            if (rs.next()) {
                newPrice = rs.getBigDecimal("FBaseUnitActualCost");
            }
            return newPrice;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getNewInOrOutPriceSQL(OneKeyBillCostInfo billInfo, boolean includeBeforePeriod, boolean isInPrice, boolean isSaleRe) {
        int i;
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String companyId = this.calParams.getCompanyInfo().getId().toString();
        if (companyId == null || billInfo == null || periodInfo == null) {
            return null;
        }
        String materialId = billInfo.getMaterialId();
        String strCalType = this.calParams.getCalType();
        String keyId = billInfo.getKeyId();
        String storageOrgUnitID = null;
        String wareHouseID = null;
        if (keyId.length() > 0 && keyId.split("\\_\\$\\$\\$\\$\\_").length >= 2) {
            String[] temp = keyId.split("\\_\\$\\$\\$\\$\\_");
            if ("1".equals(strCalType)) {
                storageOrgUnitID = temp[1];
            } else if ("2".equals(strCalType)) {
                storageOrgUnitID = temp[1];
                wareHouseID = temp[2];
            }
        }
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append("Where Bill.FBaseStatus = ").append(4).append(NEWLINE);
        whereSQL.append("  And ISNULL(BILL.FIsInitBill, 0) = 0 And ISNULL(Bill.FIsReversed, 0) = 0").append(NEWLINE);
        whereSQL.append("  And Entry.FUnitActualCost > 0").append(NEWLINE);
        whereSQL.append("  And Entry.FCompanyOrgUnitId = '").append(companyId).append("'").append(NEWLINE);
        if ("2".equals(strCalType)) {
            if (!StringUtil.isEmpty((String)storageOrgUnitID)) {
                whereSQL.append(" AND ").append("Entry.FStorageOrgUnitID = '").append(storageOrgUnitID).append("'").append(NEWLINE);
            }
            if (!StringUtil.isEmpty((String)wareHouseID)) {
                whereSQL.append(" AND ").append("Entry.FWarehouseID = '").append(wareHouseID).append("'").append(NEWLINE);
            }
        } else if ("1".equals(strCalType) && !StringUtil.isEmpty((String)storageOrgUnitID)) {
            whereSQL.append(" AND ").append("Entry.FStorageOrgUnitID = '").append(storageOrgUnitID).append("'").append(NEWLINE);
        }
        whereSQL.append("  And Entry.FMaterialId = '").append(materialId).append("'").append(NEWLINE);
        whereSQL.append("  And SCMTRANSACTIONTYPE.FIsCalculate = 1").append(NEWLINE);
        if (!isInPrice && isSaleRe) {
            whereSQL.append(" And RECISSUETYPE.FBIZDIRECTION = -1").append(NEWLINE);
        }
        if (OneKeyCalculateParams.accountTypeThreadLocal.get() == AccountType.SPECIAL_ACCT) {
            if (!StringUtil.isEmpty((String)billInfo.getLot())) {
                whereSQL.append("  And isnull(Entry.FLot,'X') = '").append(billInfo.getLot()).append("'").append(NEWLINE);
            }
            if (!StringUtil.isEmpty((String)billInfo.getAssistPropertyId())) {
                whereSQL.append("  And isnull(Entry.FAssistPropertyID,'X') = '").append(billInfo.getAssistPropertyId()).append("'").append(NEWLINE);
            }
            if (!StringUtil.isEmpty((String)billInfo.getProjectId())) {
                whereSQL.append("  And isnull(Entry.FProjectID,'X') = '").append(billInfo.getProjectId()).append("'").append(NEWLINE);
            }
            if (!StringUtil.isEmpty((String)billInfo.getTrackNumberId())) {
                whereSQL.append("  And isnull(Entry.FTrackNumberID,'X') = '").append(billInfo.getTrackNumberId()).append("'").append(NEWLINE);
            }
        }
        if (includeBeforePeriod) {
            whereSQL.append("  And (Bill.FYear * 100 + Bill.FPeriod) < ").append(periodInfo.getNumber());
        } else {
            whereSQL.append("  And Bill.FYear = ").append(periodInfo.getPeriodYear()).append("  And Bill.FPeriod = ").append(periodInfo.getPeriodNumber());
        }
        String calTypeSQL = this.getCalTypeSQL(strCalType, "Entry");
        StringBuffer selectBillPriceSQL = new StringBuffer();
        selectBillPriceSQL.append("Select Entry.FCompanyOrgUnitId, ").append(NEWLINE);
        selectBillPriceSQL.append(calTypeSQL);
        selectBillPriceSQL.append(" Entry.FMaterialId,Bill.FBizDate,").append(NEWLINE);
        selectBillPriceSQL.append(" CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0)").append(NEWLINE);
        selectBillPriceSQL.append("     ELSE TO_Decimal(ISNULL(ENTRY.FActualCost,0)/ENTRY.FBaseQty, 21, 8)").append(NEWLINE);
        selectBillPriceSQL.append(" END AS FBaseUnitActualCost");
        String selectMaxBizDateSQL = "Select Entry.FCompanyOrgUnitId," + calTypeSQL + " Entry.FMaterialId,Max(Bill.FBizDate) as FBizDate";
        String groupBySQL = "Group By Entry.FCompanyOrgUnitId," + calTypeSQL + " Entry.FMaterialId";
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select Temp.FCompanyOrgUnitId,");
        sSQL.append(this.getCalTypeSQL(strCalType, "Temp"));
        sSQL.append(" Temp.FMaterialId,Max(Temp.FBaseUnitActualCost) as FBaseUnitActualCost From (").append(NEWLINE);
        int start = 0;
        int end = 0;
        if (isInPrice) {
            start = 0;
            end = 3;
        } else {
            start = 4;
            end = 7;
        }
        for (i = start; i <= end; ++i) {
            if (i > start) {
                sSQL.append(NEWLINE).append(NEWLINE).append(" Union All ").append(NEWLINE).append(NEWLINE);
            }
            sSQL.append(" ").append(selectBillPriceSQL).append(NEWLINE);
            sSQL.append(" From ").append(INVENTORYBILL_TABLENAME[i][0]).append(" Entry").append(NEWLINE);
            sSQL.append(" INNER JOIN ").append(INVENTORYBILL_TABLENAME[i][1]).append(" Bill On Bill.FID = Entry.FParentID").append(NEWLINE);
            sSQL.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE");
            sSQL.append(" ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
            sSQL.append(" INNER JOIN T_IM_RecIssueType RECISSUETYPE");
            sSQL.append(" ON SCMTRANSACTIONTYPE.FRITYPEID = RECISSUETYPE.FID").append(NEWLINE);
            sSQL.append(" ").append(whereSQL);
        }
        sSQL.append(") Temp Inner Join (").append(NEWLINE);
        sSQL.append(" ").append("Select Entry.FCompanyOrgUnitId,");
        sSQL.append(this.getCalTypeSQL(strCalType, "Entry"));
        sSQL.append(" Entry.FMaterialId,Max(Entry.FBizDate) as FBizDate").append(" From (").append(NEWLINE);
        for (i = start; i <= end; ++i) {
            if (i > start) {
                sSQL.append(NEWLINE).append(NEWLINE).append("  Union All ").append(NEWLINE).append(NEWLINE);
            }
            sSQL.append("  ").append(selectMaxBizDateSQL).append(NEWLINE);
            sSQL.append("  From ").append(INVENTORYBILL_TABLENAME[i][0]).append(" Entry").append(NEWLINE);
            sSQL.append("  INNER JOIN ").append(INVENTORYBILL_TABLENAME[i][1]).append(" Bill On Bill.FID = Entry.FParentID").append(NEWLINE);
            sSQL.append("  INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE");
            sSQL.append(" ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append(NEWLINE);
            sSQL.append(" INNER JOIN T_IM_RecIssueType RECISSUETYPE");
            sSQL.append(" ON SCMTRANSACTIONTYPE.FRITYPEID = RECISSUETYPE.FID").append(NEWLINE);
            sSQL.append("  ").append(whereSQL).append(NEWLINE);
            sSQL.append("  ").append(groupBySQL);
        }
        sSQL.append(NEWLINE).append(" ) Entry ").append(groupBySQL).append(NEWLINE);
        sSQL.append(") MaxBizDate ON Temp.FCompanyOrgUnitId = MaxBizDate.FCompanyOrgUnitId").append(NEWLINE);
        if ("2".equals(strCalType)) {
            sSQL.append(" And Temp.FStorageOrgUnitID = MaxBizDate.FStorageOrgUnitID And Temp.FWarehouseID = MaxBizDate.FWarehouseID ").append(NEWLINE);
        } else if ("1".equals(strCalType)) {
            sSQL.append(" And Temp.FStorageOrgUnitID = MaxBizDate.FStorageOrgUnitID ").append(NEWLINE);
        }
        sSQL.append("And Temp.FMaterialId = MaxBizDate.FMaterialId").append(NEWLINE);
        sSQL.append("And Temp.FBizDate = MaxBizDate.FBizDate").append(NEWLINE);
        sSQL.append("Group By Temp.FCompanyOrgUnitId,");
        sSQL.append(this.getCalTypeSQL(strCalType, "Temp"));
        sSQL.append("Temp.FMaterialId");
        return sSQL.toString();
    }

    private String getCalTypeSQL(String strCalType, String tablename) {
        StringBuffer calTypeSQL = new StringBuffer();
        if ("2".equals(strCalType)) {
            calTypeSQL.append(" Entry.FStorageOrgUnitID ,Entry.FWarehouseID, ").append(NEWLINE);
        } else if ("1".equals(strCalType)) {
            calTypeSQL.append(" Entry.FStorageOrgUnitID, ").append(NEWLINE);
        } else {
            calTypeSQL.append(" ").append(NEWLINE);
        }
        return calTypeSQL.toString().replaceAll("Entry", tablename);
    }

    protected void calMatAttrChangeCost(Map matAttrChgMap) {
        for (Map.Entry entry : matAttrChgMap.entrySet()) {
            MatAttrChangeVO vo = (MatAttrChangeVO)entry.getValue();
            vo.calculateCost();
        }
    }

    protected void addOneKeyReportInfo(Context ctx, List rptList, Map keyExceptionState) throws EASBizException, BOSException {
        if (this.calParams.isWriteReport()) {
            if (rptList == null) {
                return;
            }
            PeriodInfo period = this.calParams.getPeriodInfo();
            String strCalType = this.calParams.getCalType();
            String diffAdjustFail = "";
            OneKeyBillCostInfo billInfo = null;
            Date now = new Date();
            boolean isOnlyWriteExpRpt = this.calParams.isOnlyWriteExpReport();
            StringBuffer buffer = null;
            AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
            for (int i = 0; rptList != null && i < rptList.size(); ++i) {
                billInfo = (OneKeyBillCostInfo)rptList.get(i);
                if (!OneKeyCalculateHelper.isEffectBalance(billInfo, this.calParams) && !billInfo.isCommissionSaleOut()) continue;
                if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) == 0) {
                    OneKeyCalculateHelper.calculateAvgPrice(billInfo);
                }
                if (billInfo.isCostPriceMove() && OneKeyCalculateHelper.isPrePeriodBill(billInfo, period) || isOnlyWriteExpRpt && keyExceptionState != null && keyExceptionState.get(billInfo.getKeyId()) != null && !((Boolean)keyExceptionState.get(billInfo.getKeyId())).booleanValue() && billInfo.isDealdiffOK()) continue;
                CostComputeReportPriceSourceInfo reportInfo = new CostComputeReportPriceSourceInfo();
                reportInfo.setParent(this.calParams.getReportHeaderInfo());
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)billInfo.getCompanyOrgUnitId()));
                reportInfo.setCompanyOrgUnit(companyInfo);
                PeriodInfo periodInfo = this.calParams.getPeriodInfo();
                reportInfo.setYear(periodInfo.getPeriodYear());
                reportInfo.setPeriod(periodInfo.getPeriodNumber());
                if (!StringUtil.isEmpty((String)billInfo.getStorageOrgUnitId())) {
                    StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
                    storageInfo.setId(BOSUuid.read((String)billInfo.getStorageOrgUnitId()));
                    reportInfo.setStorageOrgUnit(storageInfo);
                }
                if (!StringUtil.isEmpty((String)billInfo.getWarehouseId())) {
                    WarehouseInfo warehouseInfo = new WarehouseInfo();
                    warehouseInfo.setId(BOSUuid.read((String)billInfo.getWarehouseId()));
                    reportInfo.setWarehouse(warehouseInfo);
                }
                if (!StringUtil.isEmpty((String)billInfo.getMaterialId())) {
                    MaterialInfo materialInfo = new MaterialInfo();
                    materialInfo.setId(BOSUuid.read((String)billInfo.getMaterialId()));
                    reportInfo.setMaterial(materialInfo);
                }
                reportInfo.setAccountType((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get());
                if (accountType == AccountType.SPECIAL_ACCT) {
                    if (!StringUtil.isEmpty((String)billInfo.getLot())) {
                        reportInfo.setLot(billInfo.getLot());
                    }
                    if (!StringUtil.isEmpty((String)billInfo.getAssistPropertyId())) {
                        AsstAttrValueInfo assPropInfo = new AsstAttrValueInfo();
                        assPropInfo.setId(BOSUuid.read((String)billInfo.getAssistPropertyId()));
                        reportInfo.setAssistProperty(assPropInfo);
                    }
                    if (!StringUtil.isEmpty((String)billInfo.getProjectId())) {
                        ProjectInfo projectInfo = new ProjectInfo();
                        projectInfo.setId(BOSUuid.read((String)billInfo.getProjectId()));
                        reportInfo.setProject(projectInfo);
                    }
                    if (!StringUtil.isEmpty((String)billInfo.getTrackNumberId())) {
                        TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                        trackNumberInfo.setId(BOSUuid.read((String)billInfo.getTrackNumberId()));
                        reportInfo.setTrackNumber(trackNumberInfo);
                    }
                }
                int state = billInfo.isExceptionState() ? 0 : 1;
                reportInfo.setState(state);
                reportInfo.setBillName(billInfo.getBillTypeName());
                reportInfo.setBillNumber(billInfo.getBillNumber());
                String intComment = "";
                String outComment = "";
                String balanceCommnet = "";
                if (1 != billInfo.getCalculateKind() || billInfo.isOutRetBillisIn()) {
                    BigDecimal recentCost = billInfo.getRecentCost();
                    int costScale = recentCost.scale();
                    BigDecimal recentQty = billInfo.getRecentQty();
                    int qtyScale = recentQty.scale();
                    if (billInfo.isOutRetBillisIn()) {
                        recentCost = recentCost.multiply(CalculateUtil.ONE_MINUS).setScale(costScale);
                        recentQty = recentQty.multiply(CalculateUtil.ONE_MINUS).setScale(qtyScale);
                    }
                    intComment = RecentCostHelp.takeAmountQytPriceDesc(recentCost, recentQty, billInfo.getPrice()).toString();
                    if (billInfo.isCommissionSaleOut() && (!this.calParams.getNotCalConsignSale().equals("1") || accountType != AccountType.ADD_AVERAGE && accountType != AccountType.SPECIAL_ACCT)) {
                        intComment = intComment + "\n" + RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost(), billInfo.getRecentQty(), billInfo.getPrice()).toString();
                    }
                } else {
                    outComment = RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost(), billInfo.getRecentQty(), billInfo.getPrice()).toString();
                    if (billInfo.isCommissionSaleOut() && (!this.calParams.getNotCalConsignSale().equals("1") || accountType != AccountType.ADD_AVERAGE && accountType != AccountType.SPECIAL_ACCT)) {
                        outComment = outComment + "\n\r" + RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost().negate(), billInfo.getRecentQty().negate(), billInfo.getPrice()).toString();
                    }
                    if ("2".equals(strCalType) && billInfo.getHandleTailDiff() == 1) {
                        String handleTailDiff = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"HANDLE_TAIL_DIFF", (Context)ctx);
                        outComment = outComment + "\n" + handleTailDiff;
                    }
                }
                reportInfo.setIncome(intComment);
                reportInfo.setPayout(outComment);
                if (billInfo.isExceptionState()) {
                    balanceCommnet = this.errorMsg;
                } else if (accountType == AccountType.MOVE_ADD_AVERAGE || accountType == AccountType.MOVE_WEIGHTED_AVERAGE) {
                    buffer = RecentCostHelp.takeAmountQytPriceDesc(billInfo.getMoveAvgCost(), billInfo.getMoveAvgQty(), billInfo.getMoveAvgPrice());
                    balanceCommnet = buffer.toString();
                }
                reportInfo.setSettleAccounts(balanceCommnet);
                reportInfo.setCalculateKind(billInfo.getCalculateKind());
                reportInfo.setTimeSerialNumber(String.valueOf(billInfo.getTimeSerialNumber()));
                if (1 == billInfo.getCalculateKind()) {
                    reportInfo.setPriceSource(billInfo.getPriceSource());
                }
                reportInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                Timestamp createTime = new Timestamp(now.getTime());
                if (accountType == AccountType.ADD_AVERAGE || accountType == AccountType.SPECIAL_ACCT) {
                    createTime = billInfo.getBizDate();
                }
                reportInfo.setCreateTime(createTime);
                reportInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                this.reportColLocal.get().add(reportInfo);
                if (billInfo.isDealdiffOK()) continue;
                reportInfo = new CostComputeReportPriceSourceInfo();
                reportInfo.setParent(this.calParams.getReportHeaderInfo());
                diffAdjustFail = billInfo.getBillNumber() + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"diffAdjustFail", (Context)ctx);
                reportInfo.setBillNumber(diffAdjustFail);
                if (accountType == AccountType.ADD_AVERAGE || accountType == AccountType.SPECIAL_ACCT) {
                    reportInfo.setCreateTime(new Timestamp(billInfo.getBizDate().getTime() + 1000L));
                } else {
                    reportInfo.setCreateTime(new Timestamp(now.getTime() + 1000L));
                }
                String diffAdjustFailTips = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"diffAdjustFailTips", (Context)ctx);
                reportInfo.setPayout(diffAdjustFailTips);
                reportInfo.setState(0);
                this.reportColLocal.get().add(reportInfo);
                if (this.reportColLocal.get().size() < 500) continue;
                CoreBaseCollection coll = new CoreBaseCollection();
                coll.addObjectCollection((IObjectCollection)this.reportColLocal.get());
                CostComputeReportPriceSourceFactory.getLocalInstance(ctx).addnewBatchData(coll);
                this.reportColLocal.get().clear();
            }
        }
    }

    protected Map getKeyExceptionState(HashMap balanceMap) {
        HashMap keyExceptionMap = new HashMap();
        Iterator iter = balanceMap.entrySet().iterator();
        OneKeyBalanceCostInfo balInfo = null;
        OneKeyBillCostInfo billInfo = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getKey().equals("CostPriceMove__") || entry.getKey().equals("ALLINOUTLIST") || entry.getKey().equals("INBILLLIST") || entry.getKey().equals("OUTBILLLIST") || entry.getKey().equals("INBILLNEEDUPDATED") || entry.getKey().equals("costMoveCycle") || entry.getValue() instanceof HashMap) continue;
            balInfo = (OneKeyBalanceCostInfo)entry.getValue();
            billInfo = balInfo.getReusltBillInfo();
            keyExceptionMap.put(entry.getKey(), billInfo.isExceptionState() || balInfo.isExceptionState());
        }
        return keyExceptionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCostMoveInBillByIssue(Connection conn, HashMap prePeriodCostMoveMap, LinkedHashMap costMoveMap, long timeSerialNumber, PeriodInfo periodInfo) throws BOSException, SQLException {
        if (!costMoveMap.isEmpty()) {
            HashSet<String> stockTransEntryId;
            PreparedStatement statement;
            block9: {
                statement = null;
                stockTransEntryId = new HashSet<String>();
                for (Map.Entry entry : costMoveMap.entrySet()) {
                    OneKeyBillCostInfo costMoveBill = (OneKeyBillCostInfo)entry.getValue();
                    if (costMoveBill.getMoveInbillList() == null || costMoveBill.getMoveOutbillList() != null) continue;
                    stockTransEntryId.add(entry.getKey().toString());
                }
                if (stockTransEntryId.size() != 0) break block9;
                KsqlUtil.cleanup(statement);
                return;
            }
            try {
                StringBuilder sql = new StringBuilder();
                sql.append("select * from ").append(this.tempManager.getCostMoveOutTemp()).append(" bill where FSTOCKTRANSBILLENTRYID in (");
                for (int i = 0; i < stockTransEntryId.size(); ++i) {
                    if (i != stockTransEntryId.size() - 1) {
                        sql.append("?,");
                        continue;
                    }
                    sql.append("?)");
                }
                sql.append(this.getBillSqlOrder());
                statement = conn.prepareStatement(sql.toString());
                int index = 1;
                for (String s : stockTransEntryId) {
                    statement.setString(index, s);
                    ++index;
                }
                ResultSet costMoveInRs = statement.executeQuery();
                timeSerialNumber = 0L;
                while (costMoveInRs.next()) {
                    OneKeyBillCostInfo bill = this.convertOneKeyBillCostInfo(costMoveInRs, timeSerialNumber);
                    this.buildCostPriceMove(bill, costMoveMap);
                    if (!bill.isMoveOutBill() || !OneKeyCalculateHelper.isPrePeriodBill(bill, periodInfo)) continue;
                    prePeriodCostMoveMap.put(bill.getStockTransBillEntryId(), bill);
                }
            }
            catch (Throwable throwable) {
                KsqlUtil.cleanup(statement);
                throw throwable;
            }
            KsqlUtil.cleanup((Statement)statement);
        }
    }

    protected void calcBySubThread(Context ctx) throws EASBizException, BOSException {
        try {
            int maxExecuteNum = 10;
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)"SELECT fvalue FROM t_dt_dttempparam where fkey = 'oneKeyCalcMultiThread'");
            while (rowSet.next()) {
                maxExecuteNum = rowSet.getInt("fvalue");
            }
            ThreadLocalHelper.childExecutor.set(Executors.newFixedThreadPool(maxExecuteNum));
            ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)ThreadLocalHelper.childExecutor.get());
            for (int i = 0; i < this.calculateUnitList.size(); ++i) {
                if (i > maxExecuteNum - 1) {
                    completionService.take().get();
                }
                CalculateUnitInfo calculateUnitInfo = this.calculateUnitList.get(i);
                CalcUnitThread calcUnitThread = new CalcUnitThread(ctx, calculateUnitInfo);
                completionService.submit(calcUnitThread);
            }
            int unCatchJob = Math.min(maxExecuteNum, this.calculateUnitList.size());
            for (int i = 0; i < unCatchJob; ++i) {
                completionService.take().get();
            }
            if (this.allReport.size() > 0) {
                CostComputeReportPriceSourceFactory.getLocalInstance(ctx).addnewBatchData(this.allReport);
                this.allReport.clear();
            }
        }
        catch (Exception e) {
            if (ThreadLocalHelper.childExecutor.get() != null) {
                ((ExecutorService)ThreadLocalHelper.childExecutor.get()).shutdownNow();
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ThreadLocalHelper.childExecutor.get() != null) {
                ((ExecutorService)ThreadLocalHelper.childExecutor.get()).shutdownNow();
            }
            ThreadLocalHelper.childExecutor.remove();
        }
    }

    protected void checkInterrupted() throws InterruptedException {
        if (ThreadLocalHelper.childExecutor.get() == null || ((ExecutorService)ThreadLocalHelper.childExecutor.get()).isShutdown() || ThreadLocalHelper.calcOutExcutor.get() == null || ((ExecutorService)ThreadLocalHelper.calcOutExcutor.get()).isShutdown() || ThreadLocalHelper.mainExcutor.get() == null || ((ExecutorService)ThreadLocalHelper.mainExcutor.get()).isShutdown()) {
            throw new InterruptedException("\u5176\u4ed6\u4efb\u52a1\u5df2\u4e2d\u65ad job was interrupted by other thread");
        }
    }

    class CalcUnitThread
    implements Callable {
        Context ctx;
        CalculateUnitInfo calculateUnitInfo;

        public CalcUnitThread(Context ctx, CalculateUnitInfo calculateUnitInfo) {
            this.ctx = ctx;
            this.calculateUnitInfo = calculateUnitInfo;
        }

        public Object call() throws Exception {
            AbstractOneKeyCalculate.this.reportColLocal.set(new CostComputeReportPriceSourceCollection());
            AbstractOneKeyCalculate.this.calculateStrategy(this.ctx, this.calculateUnitInfo);
            AbstractOneKeyCalculate.this.handleReport(this.ctx);
            return null;
        }
    }
}

