/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.calculateimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceCollection;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceFactory;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceInfo;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBalanceCostInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBillCostInfo;
import com.kingdee.eas.scm.cal.onekey.app.MatAttrChangeVO;
import com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateParams;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.AbstractOneKeyCalculate;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyUpdateBillCostHelper;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateHelper;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OneKeyFIFOCalculate
extends AbstractOneKeyCalculate {
    private static Logger logger = Logger.getLogger(OneKeyFIFOCalculate.class);

    private ArrayList fifoCalculate(Context ctx, CalculateUnitInfo calculateUnitInfo, Connection conn) throws EASBizException, BOSException, InterruptedException {
        ArrayList arrayList;
        ArrayList<OneKeyBillCostInfo> listAllBill = new ArrayList<OneKeyBillCostInfo>();
        ArrayList handredAdjustList = new ArrayList();
        ResultSet rs = null;
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        PreparedStatement billPreStatement = null;
        try {
            String key = null;
            HashMap<String, ArrayList> calMap = new HashMap<String, ArrayList>();
            LinkedHashMap costMoveMap = new LinkedHashMap();
            ArrayList listPeriodBeginIn = new ArrayList();
            ArrayList needUpdatedBills = new ArrayList();
            ArrayList listInBill = null;
            HashMap<String, OneKeyBillCostInfo> combitionMap = new HashMap<String, OneKeyBillCostInfo>();
            HashMap<String, ArrayList> periodBeginInMap = new HashMap<String, ArrayList>();
            HashMap matAttrChgMap = new HashMap();
            HashMap prePeriodCostMoveMap = new HashMap();
            billPreStatement = this.getBillPreparedStatement(conn, calculateUnitInfo);
            rs = this.getBillRowSet(billPreStatement, calculateUnitInfo);
            this.checkInterrupted();
            long timeSerialNumber = new Date().getTime();
            while (rs.next()) {
                OneKeyBillCostInfo combinBill;
                OneKeyBillCostInfo bill = this.convertOneKeyBillCostInfo(rs, timeSerialNumber += 10L);
                if (bill.getFiVouchered() == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                if (bill.getSrcBilInCurrPid() > 0) {
                    bill.setNeedUpdate(true);
                }
                if (bill.getIsCombition() != 1 && CalculateUtil.ZERO.compareTo(bill.getRecentQty()) == 0 && CalculateUtil.ZERO.compareTo(bill.getRecentCost()) == 0) continue;
                key = bill.getKeyId();
                if (calMap.get(key) == null) {
                    listInBill = new ArrayList();
                    calMap.put(key, listInBill);
                } else {
                    listInBill = (ArrayList)calMap.get(key);
                }
                if (periodBeginInMap.get(key) == null) {
                    listPeriodBeginIn = new ArrayList();
                    periodBeginInMap.put(key, listPeriodBeginIn);
                } else {
                    listPeriodBeginIn = (ArrayList)periodBeginInMap.get(key);
                }
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill);
                    this.buildCostPriceMove(bill, costMoveMap);
                }
                if (!(bill.getSrcBilInCurrPid() == 1 && (bill.getSrcBilInCurrPid() != 1 || bill.getIsCombition() != 0) || OneKeyCalculateHelper.isPrePeriodBill(bill, periodInfo) || bill.isMatAttrChange() && !bill.isOutBill())) {
                    listAllBill.add(bill);
                }
                if (bill.isMatAttrChange()) {
                    bill.setCalculate(false);
                    this.buildMatAttrChange(bill, matAttrChgMap);
                }
                if (2 == bill.getCalculateKind()) {
                    if (CalculateUtil.ZERO.compareTo(bill.getRecentQty()) != 0) {
                        bill.setPrice(bill.getRecentCost().divide(bill.getRecentQty(), bill.getPricePrecision(), 4));
                    }
                    listInBill.add(bill.clone());
                    listPeriodBeginIn.add(bill);
                    continue;
                }
                if (0 == bill.getCalculateKind()) {
                    if (bill.isCalculate() && !bill.isRedBill() && bill.getIsCombition() != 2 || bill.isCostAdjustBill()) {
                        listInBill.add(bill.clone());
                    }
                    if (bill.getIsCombition() == 1) {
                        combitionMap.put(bill.getBillEntryId(), bill);
                        continue;
                    }
                    if (bill.getSrcBilInCurrPid() != 1 || !combitionMap.containsKey(bill.getSourceBillEntryId())) continue;
                    combinBill = (OneKeyBillCostInfo)combitionMap.get(bill.getSourceBillEntryId());
                    bill.setTimeSerialNumber(combinBill.getTimeSerialNumber() + 1L);
                    combinBill.addCombition(bill);
                    continue;
                }
                if (1 != bill.getCalculateKind() || !bill.isCalculate()) continue;
                if (bill.getSrcBilInCurrPid() == 1 && bill.getIsCombition() != 0 && combitionMap.containsKey(bill.getSourceBillEntryId())) {
                    combinBill = (OneKeyBillCostInfo)combitionMap.get(bill.getSourceBillEntryId());
                    bill.setTimeSerialNumber(combinBill.getTimeSerialNumber() + 1L);
                    combinBill.addCombition(bill);
                }
                if (bill.getIsCombition() == 1) {
                    combitionMap.put(bill.getBillEntryId(), bill);
                }
                if (bill.isRedBill() && bill.getSrcBilInCurrPid() != 1 && OneKeyCalculateHelper.isEffectBalance(bill, this.calParams)) {
                    OneKeyBillCostInfo tempbill = (OneKeyBillCostInfo)bill.clone();
                    tempbill.setRecentCost(tempbill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                    tempbill.setRecentQty(tempbill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                    listInBill.add(tempbill);
                }
                if (!bill.isSrcOutBillInPrePeriod()) continue;
                bill.setNeedUpdate(true);
            }
            this.checkInterrupted();
            this.getCostMoveInBillByIssue(conn, prePeriodCostMoveMap, costMoveMap, timeSerialNumber, periodInfo);
            HashMap periodBeginInPrice = this.getPriceMap(periodBeginInMap);
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, needUpdatedBills);
            this.calculateCost(ctx, calMap, periodBeginInPrice, combitionMap, costMoveMap, matAttrChgMap, listAllBill, handredAdjustList, needUpdatedBills, calculateUnitInfo);
            arrayList = needUpdatedBills;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, billPreStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)billPreStatement);
        return arrayList;
    }

    @Override
    protected String getBillSqlOrder() {
        return " Order by Bill.FBizdate,Bill.FAuditTime,Bill.FNumber,Bill.FSeqNum";
    }

    @Override
    public void calculateStrategy(Context ctx, CalculateUnitInfo calculateUnitInfo) throws EASBizException, BOSException {
        OneKeyUpdateBillCostHelper updateBillCostHelper = null;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            updateBillCostHelper = new OneKeyUpdateBillCostHelper(con);
            this.checkInterrupted();
            try {
                ArrayList needUpdatedBills = this.fifoCalculate(ctx, calculateUnitInfo, con);
                updateBillCostHelper.updateBills(needUpdatedBills, new HashMap());
                this.checkInterrupted();
                if (this.calParams.getCalcResulteTbl() != null && needUpdatedBills.size() > 0) {
                    OneKeyBillCostInfo lastBill = null;
                    for (int i = needUpdatedBills.size() - 1; i >= 0; --i) {
                        if (((OneKeyBillCostInfo)needUpdatedBills.get(i)).getFiVouchered() != 0) continue;
                        OneKeyBillCostInfo currBill = (OneKeyBillCostInfo)needUpdatedBills.get(i);
                        if (lastBill != null && !currBill.getKeyId().equals(lastBill.getKeyId())) {
                            this.insertCalcResultInfo(ctx, (OneKeyBillCostInfo)needUpdatedBills.get(i), this.calParams.getCalcResulteTbl());
                        }
                        lastBill = (OneKeyBillCostInfo)needUpdatedBills.get(i);
                    }
                }
            }
            catch (Exception e) {
                this.addExpReportInfo(ctx, calculateUnitInfo);
                throw new BOSException((Throwable)e);
            }
            updateBillCostHelper.executeBatch(true);
            this.checkInterrupted();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            updateBillCostHelper.close();
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected void adjustPrePeriodData(Context ctx) throws BOSException {
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        this.updateCombitionRetBill(ctx);
        DBUtil.execute((Context)ctx, (String)this.getUpateCostAdjustBillDate(periodInfo));
        DBUtil.execute((Context)ctx, (String)this.getUpdateCombitionBizDateSQL());
        DBUtil.execute(ctx, this.getUpateMaterialReqPriceFromPrePeriod(periodInfo));
        DBUtil.execute(ctx, this.getUpateSaleIssuePriceFromPrePeriod(periodInfo));
        DBUtil.execute((Context)ctx, (String)this.getUpateCostMoveIssueFromPrePeriod(periodInfo));
        DBUtil.execute(ctx, this.getUpateCostMoveInFromPrePeriod(periodInfo));
    }

    protected void calculateCost(Context ctx, HashMap calMap, HashMap periodBeginInPrice, HashMap combitionMap, HashMap costMoveMap, HashMap matAttrChgMap, ArrayList listAllBill, ArrayList handredAdjustList, ArrayList needUpdatedBills, CalculateUnitInfo calculateUnitInfo) throws SQLException, EASBizException, BOSException {
        String strCalType = this.calParams.getCalType();
        HashMap<String, ArrayList> payOutMap = new HashMap<String, ArrayList>();
        ArrayList listPayout = new ArrayList();
        ArrayList listInBill = null;
        BigDecimal newOutPrice = CalculateUtil.ZERO;
        BigDecimal newInpPrice = CalculateUtil.ZERO;
        HashMap<String, BigDecimal> newOutPriceMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> newInpPriceMap = new HashMap<String, BigDecimal>();
        HashMap<String, Boolean> exceptMap = null;
        boolean isExceptionState = false;
        for (int i = 0; listAllBill != null && i < listAllBill.size(); ++i) {
            OneKeyBillCostInfo bill = (OneKeyBillCostInfo)listAllBill.get(i);
            if (exceptMap != null && exceptMap.get(bill.getKeyId()) != null) continue;
            listInBill = (ArrayList)calMap.get(bill.getKeyId());
            listPayout = (ArrayList)payOutMap.get(bill.getKeyId());
            if (listPayout == null) {
                listPayout = new ArrayList();
                payOutMap.put(bill.getKeyId(), listPayout);
            }
            if (2 == bill.getCalculateKind()) {
                newInpPriceMap.put(bill.getKeyId(), bill.getPrice());
            } else if (0 == bill.getCalculateKind()) {
                if (CalculateUtil.ZERO.compareTo(bill.getPrice()) <= 0) {
                    newInpPriceMap.put(bill.getKeyId(), bill.getPrice());
                }
                if (bill.isRedBill() && bill.getSrcBilInCurrPid() != 1 && !bill.isCostAdjustBill()) {
                    bill.setRecentCost(bill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                    bill.setRecentQty(bill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                    if (!bill.isCostPriceMove()) {
                        bill.setDealComplete(true);
                    }
                    isExceptionState = this.calculateFIFOOutBillCost(listInBill, bill, (BigDecimal)newInpPriceMap.get(bill.getKeyId()));
                    bill.setRecentCost(bill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                    bill.setRecentQty(bill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                }
                if (bill.isCostAdjustBill()) {
                    try {
                        this.calculateInCostAdjustBill(listInBill, bill);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        logger.error((Object)e.getStackTrace());
                    }
                }
            } else {
                if (bill.getFiVouchered() != 1 && bill.isReWork()) {
                    if ("1".equals(this.calParams.getReworkCostType())) {
                        OneKeyBillCostInfo costInfo = (OneKeyBillCostInfo)periodBeginInPrice.get(bill.getKeyId());
                        if (costInfo != null && CalculateUtil.ZERO.compareTo(costInfo.getPrice()) != 0) {
                            bill.setPrice(costInfo.getPrice());
                            bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4));
                            bill.setPriceSource(PriceSourEnum.periodBeginPriceReWork);
                            bill.setNeedUpdate(true);
                        } else {
                            bill.setPriceSource(PriceSourEnum.zeroPrice);
                            bill.setDealComplete(true);
                        }
                    } else if ("0".equals(this.calParams.getReworkCostType()) && !bill.isExistSrcBill()) {
                        bill.setPriceSource(PriceSourEnum.userDefine);
                        bill.setDealComplete(true);
                    }
                }
                if (bill.isRedBill()) {
                    bill.setPriceSource(PriceSourEnum.userDefine);
                    if (CalculateUtil.ZERO.compareTo(bill.getRecentCost()) == 0 && !bill.isDealComplete() && bill.getSrcBilInCurrPid() == 0) {
                        this.setBillPrice(listInBill, (BigDecimal)newOutPriceMap.get(bill.getKeyId()), (BigDecimal)newInpPriceMap.get(bill.getKeyId()), bill);
                        if (CalculateUtil.ZERO.compareTo(bill.getPrice()) == 0 && !bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.zeroPrice);
                        }
                        if (OneKeyCalculateHelper.isEffectBalance(bill, this.calParams)) {
                            for (int k = listInBill.size() - 1; k >= 0; --k) {
                                OneKeyBillCostInfo settleAccounts = (OneKeyBillCostInfo)listInBill.get(k);
                                if (!settleAccounts.getBillEntryId().equals(bill.getBillEntryId())) continue;
                                settleAccounts.setPrice(bill.getPrice());
                                settleAccounts.setRecentCost(bill.getRecentCost().negate());
                                settleAccounts.setRecentQty(bill.getRecentQty().negate());
                                break;
                            }
                        }
                    }
                } else {
                    listPayout.add(bill);
                    if (bill.getIsCombition() == 1 && !bill.isCostAdjustBill() && CalculateUtil.ZERO.compareTo(bill.getRecentQty()) == 0) {
                        newOutPrice = (BigDecimal)newOutPriceMap.get(bill.getKeyId());
                        if (newOutPrice != null && newOutPrice.compareTo(CalculateUtil.ZERO) > 0) {
                            bill.setPriceSource(PriceSourEnum.newOut);
                            bill.setPrice(newOutPrice);
                        }
                        if ((newInpPrice = (BigDecimal)newInpPriceMap.get(bill.getKeyId())) != null && CalculateUtil.ZERO.compareTo(bill.getPrice()) == 0) {
                            bill.setPrice(newInpPrice);
                            bill.setPriceSource(PriceSourEnum.newIn);
                        }
                    } else if (!OneKeyCalculateHelper.isEffectBalance(bill, this.calParams)) {
                        this.setBillPrice(listInBill, (BigDecimal)newOutPriceMap.get(bill.getKeyId()), (BigDecimal)newInpPriceMap.get(bill.getKeyId()), bill);
                    } else if (bill.isCalculate()) {
                        isExceptionState = this.calculateFIFOOutBillCost(listInBill, bill, (BigDecimal)newInpPriceMap.get(bill.getKeyId()));
                    }
                    newOutPriceMap.put(bill.getKeyId(), bill.getPrice());
                    if (bill.getIsCombition() == 1 && combitionMap.containsKey(bill.getBillEntryId())) {
                        OneKeyBillCostInfo combitInfo = (OneKeyBillCostInfo)combitionMap.get(bill.getBillEntryId());
                        combitInfo.setCombitionCost(bill.getRecentCost());
                    }
                }
            }
            if (isExceptionState) {
                bill.setExceptionState(isExceptionState);
                if (bill.isReWork()) {
                    needUpdatedBills.add(bill);
                }
                if (this.calParams.isWriteReport()) {
                    this.addReportInfo(ctx, bill, listInBill, bill.getCalculateKind(), 0);
                }
                isExceptionState = false;
                if ("0".equals(strCalType)) break;
                if (exceptMap == null) {
                    exceptMap = new HashMap<String, Boolean>();
                }
                exceptMap.put(bill.getKeyId(), isExceptionState);
                continue;
            }
            if (bill.isCostPriceMove() && bill.isMoveOutBill()) {
                this.synCostMovePriceBill(costMoveMap, bill);
                this.synCostMovePriceToInList(costMoveMap, calMap, bill);
            }
            if (bill.isCostPriceMove() && bill.isMoveInBill() && !bill.isNeedUpdate()) {
                this.synCostMoveInPrice(ctx, costMoveMap, bill);
                this.synCostMovePriceToInList(calMap, bill);
            }
            this.calMatAttrChangeCost(needUpdatedBills, matAttrChgMap);
            this.billDealProces(ctx, bill, listInBill, needUpdatedBills, combitionMap);
        }
        HashMap balanceMap = new HashMap();
        ArrayList<String> calOrder = new ArrayList<String>();
        for (Map.Entry entry : calMap.entrySet()) {
            listInBill = (ArrayList)entry.getValue();
            listPayout = (ArrayList)payOutMap.get(entry.getKey());
            this.handleDetailDiffer(ctx, listInBill, listPayout, needUpdatedBills);
            this.getFifoBalance(balanceMap, listInBill, entry.getKey().toString());
            calOrder.add(entry.getKey().toString());
        }
        this.updateMoveLocationBill(ctx, balanceMap, calOrder, calculateUnitInfo);
        if (this.calParams.isWriteReport()) {
            this.writeEndCostComputeReport(ctx, calMap, calculateUnitInfo, exceptMap);
        }
    }

    private void calculateInCostAdjustBill(ArrayList rsList, OneKeyBillCostInfo currBill) {
        if (!rsList.contains(currBill)) {
            return;
        }
        int previousInBill = -1;
        int currPostion = -1;
        for (int i = 0; i < rsList.size(); ++i) {
            if (!((OneKeyBillCostInfo)rsList.get(i)).isCostAdjustBill()) {
                previousInBill = i;
            }
            if (!rsList.get(i).equals(currBill)) continue;
            currPostion = i;
            break;
        }
        if (previousInBill < 0) {
            return;
        }
        int pricePrecision = currBill.getPricePrecision();
        OneKeyBillCostInfo lastRs = (OneKeyBillCostInfo)rsList.get(previousInBill);
        lastRs.setRecentCost(lastRs.getRecentCost().add(currBill.getRecentCost()));
        lastRs.setRecentQty(lastRs.getRecentQty().add(currBill.getRecentQty()));
        if (lastRs.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
            lastRs.setPrice(BigDecimal.ZERO);
        } else {
            lastRs.setPrice(lastRs.getRecentCost().divide(lastRs.getRecentQty(), pricePrecision, 4));
        }
        rsList.remove(currPostion);
    }

    private void synCostMoveInPrice(Context ctx, HashMap costMoveMap, OneKeyBillCostInfo bill) throws EASBizException {
        OneKeyBillCostInfo costMoveObj = (OneKeyBillCostInfo)costMoveMap.get(bill.getStockTransBillEntryId());
        OneKeyBillCostInfo moveCostBill = null;
        BigDecimal avgPrice = BigDecimal.ZERO;
        ArrayList moveCostList = costMoveObj.getMoveInbillList();
        ArrayList<Object> billList = costMoveObj.getMoveBillList();
        if (billList == null) {
            ArrayList tempList = costMoveObj.getMoveOutbillList();
            billList = new ArrayList<Object>();
            for (int i = 0; i < tempList.size(); ++i) {
                billList.add(((OneKeyBillCostInfo)tempList.get(i)).clone());
            }
            costMoveObj.setMoveBillList(billList);
        }
        if (billList == null || billList.isEmpty()) {
            throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{costMoveObj.getMaterialNumber()});
        }
        int listIndex = 0;
        OneKeyBillCostInfo billInfo = (OneKeyBillCostInfo)billList.get(listIndex++);
        BigDecimal costMoveQty = billInfo.getQty();
        BigDecimal costMoveCost = billInfo.getRecentCost();
        for (int i = 0; i < moveCostList.size(); ++i) {
            moveCostBill = (OneKeyBillCostInfo)moveCostList.get(i);
            if (!moveCostBill.isDealComplete()) {
                moveCostBill.setPriceSource(PriceSourEnum.costMove);
            }
            BigDecimal qty = moveCostBill.getRecentQty();
            BigDecimal amount = BigDecimal.ZERO;
            while (costMoveQty.compareTo(qty) < 0 && listIndex < billList.size()) {
                qty = qty.subtract(costMoveQty);
                amount = amount.add(costMoveCost);
                billInfo.setRecentQty(BigDecimal.ZERO);
                billInfo.setRecentCost(BigDecimal.ZERO);
                billInfo = (OneKeyBillCostInfo)billList.get(listIndex++);
                costMoveQty = billInfo.getRecentQty();
                costMoveCost = billInfo.getRecentCost();
            }
            if (listIndex > billList.size()) {
                throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{costMoveObj.getMaterialNumber()});
            }
            if (costMoveQty.compareTo(qty) == 0) {
                amount = amount.add(costMoveCost);
                costMoveQty = BigDecimal.ZERO;
                costMoveCost = BigDecimal.ZERO;
            } else {
                BigDecimal amt = qty.multiply(billInfo.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4);
                if (amt.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) != 0 && billInfo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                    amt = RecentCostHelp.getMinValueByScale(bill.getBaseCurrencyPrecision(), qty.signum());
                }
                amount = amount.add(amt);
                costMoveQty = costMoveQty.subtract(qty);
                costMoveCost = costMoveCost.subtract(amt);
            }
            billInfo.setRecentQty(costMoveQty);
            billInfo.setRecentCost(costMoveCost);
            if (moveCostBill.getBillEntryId().equals(bill.getBillEntryId())) {
                bill.setRecentCost(amount);
                avgPrice = amount.divide(bill.getRecentQty(), bill.getPricePrecision(), 4);
                bill.setPrice(avgPrice);
                bill.setNeedUpdate(true);
                moveCostList.remove(moveCostBill);
                break;
            }
            moveCostBill.setRecentQty(BigDecimal.ZERO);
            moveCostBill.setRecentCost(BigDecimal.ZERO);
        }
        this.clearDealedInpourList(billList);
        this.clearDealedInpourList(moveCostList);
    }

    private void setBillPrice(ArrayList listInBill, BigDecimal newOutPrice, BigDecimal newInpPrice, OneKeyBillCostInfo bill) {
        if (newOutPrice != null && newOutPrice.compareTo(CalculateUtil.ZERO) > 0) {
            bill.setPrice(newOutPrice.setScale(bill.getPricePrecision(), 4));
            bill.setPriceSource(PriceSourEnum.newOut);
        } else if (newInpPrice != null && newInpPrice.compareTo(CalculateUtil.ZERO) > 0) {
            bill.setPriceSource(PriceSourEnum.newIn);
            bill.setPrice(newInpPrice.setScale(bill.getPricePrecision(), 4));
        }
        if (CalculateUtil.ZERO.compareTo(bill.getPrice()) == 0) {
            OneKeyBillCostInfo settleAccounts = null;
            for (int n = 0; listInBill != null && n < listInBill.size(); ++n) {
                settleAccounts = (OneKeyBillCostInfo)listInBill.get(n);
                if (settleAccounts == null || settleAccounts.getPrice().compareTo(CalculateUtil.ZERO) <= 0) continue;
                bill.setPrice(settleAccounts.getPrice());
                bill.setPriceSource(PriceSourEnum.fifoPrice);
                break;
            }
        }
        bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4));
    }

    protected void billDealProces(Context ctx, OneKeyBillCostInfo bill, ArrayList listInpour, List needdUpdateBill, HashMap combitionMap) throws EASBizException, BOSException {
        if (bill.getIsCombition() == 1) {
            bill.setCombitionQty(bill.getRecentQty());
            bill.setRecentQty(bill.getBaseQtyBak());
            bill.setCombitionCost(bill.getRecentCost());
            bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4));
        }
        if (1 != bill.getCalculateKind()) {
            if (OneKeyCalculateHelper.isEffectBalance(bill, this.calParams)) {
                this.writeComputeReport(ctx, bill, listInpour, 1);
                this.dealInWarehouseCombition(ctx, bill, listInpour, needdUpdateBill);
            }
            if (bill.isCostPriceMove() && !bill.isDealComplete() && bill.isNeedUpdate()) {
                needdUpdateBill.add(bill);
            }
        } else {
            if (OneKeyCalculateHelper.isEffectBalance(bill, this.calParams)) {
                this.writeComputeReport(ctx, bill, listInpour, 1);
            }
            this.dealOutWarehouseCombition(ctx, bill, listInpour, needdUpdateBill);
            if (!bill.isDealComplete() && !bill.isCostAdjustBill()) {
                bill.setNeedUpdate(true);
                needdUpdateBill.add(bill);
            }
        }
    }

    private void dealInWarehouseCombition(Context ctx, OneKeyBillCostInfo bill, ArrayList listInpour, List needdUpdateBill) throws EASBizException, BOSException {
        OneKeyBillCostInfo redBillInfo = null;
        if (bill.getIsCombition() == 1) {
            ArrayList redBillList = bill.getCombitionList();
            for (int i = 0; redBillList != null && i < redBillList.size(); ++i) {
                redBillInfo = (OneKeyBillCostInfo)redBillList.get(i);
                if (bill.isCostPriceMove() && !redBillInfo.isDealComplete()) {
                    redBillInfo.setNeedUpdate(true);
                    needdUpdateBill.add(redBillInfo);
                }
                this.writeComputeReport(ctx, (OneKeyBillCostInfo)redBillList.get(i), listInpour, 1);
            }
        }
    }

    private void dealOutWarehouseCombition(Context ctx, OneKeyBillCostInfo bill, ArrayList listInpour, List needdUpdateBill) throws EASBizException, BOSException {
        OneKeyBillCostInfo redBillInfo = null;
        if (bill.getIsCombition() == 1) {
            ArrayList redBillList = bill.getCombitionList();
            if (redBillList != null && !redBillList.isEmpty()) {
                this.handleSrcBill(redBillList, bill);
            }
            for (int i = 0; redBillList != null && i < redBillList.size(); ++i) {
                redBillInfo = (OneKeyBillCostInfo)redBillList.get(i);
                if (!redBillInfo.isDealComplete()) {
                    redBillInfo.setNeedUpdate(true);
                    redBillInfo.setPriceSource(PriceSourEnum.sourBillPrice);
                    needdUpdateBill.add(redBillInfo);
                }
                if (!OneKeyCalculateHelper.isEffectBalance(redBillInfo, this.calParams)) continue;
                this.writeComputeReport(ctx, redBillInfo, listInpour, 1);
            }
        }
    }

    private void writeComputeReport(Context ctx, OneKeyBillCostInfo bill, ArrayList list, int state) throws EASBizException, BOSException {
        if (!this.calParams.isWriteReport()) {
            return;
        }
        boolean isWriteExrpt = this.calParams.isOnlyWriteExpReport();
        if (isWriteExrpt && (state == 0 || state == 2)) {
            return;
        }
        this.synListInBill(list, bill);
        this.addReportInfo(ctx, bill, list, bill.getCalculateKind(), state);
    }

    private void writeEndCostComputeReport(Context ctx, HashMap calMap, CalculateUnitInfo calUnitInfo, HashMap exceptMap) throws EASBizException, BOSException {
        OneKeyBillCostInfo tempbill = new OneKeyBillCostInfo();
        tempbill.setMaterialId(calUnitInfo.getMaterialId());
        tempbill.setCompanyOrgUnitId(calUnitInfo.getCompanyOrgUnitId());
        tempbill.setPricePrecision(calUnitInfo.getPricePrecision());
        boolean isWriteExrpt = this.calParams.isOnlyWriteExpReport();
        Iterator it = calMap.entrySet().iterator();
        ArrayList listInBill = null;
        int isExceptionState = 1;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String[] orgId = key.split("_[$]{4}_");
            if (orgId.length >= 1) {
                tempbill.setCompanyOrgUnitId(orgId[0]);
            }
            if (orgId.length >= 2) {
                tempbill.setStorageOrgUnitId(orgId[1]);
            }
            if (orgId.length >= 3) {
                tempbill.setWarehouseId(orgId[2]);
            }
            listInBill = (ArrayList)entry.getValue();
            isExceptionState = exceptMap != null && exceptMap.containsKey(key) ? 2 : 1;
            if (isWriteExrpt && isExceptionState != 2) continue;
            this.addReportInfo(ctx, tempbill, listInBill, 3, isExceptionState);
        }
    }

    private HashMap getCombitionMap(Context ctx, ArrayList list) {
        OneKeyBillCostInfo bill = null;
        OneKeyBillCostInfo currBill = null;
        HashMap<String, OneKeyBillCostInfo> combtionMap = new HashMap<String, OneKeyBillCostInfo>();
        String keyId = null;
        for (int i = 0; i < list.size(); ++i) {
            currBill = (OneKeyBillCostInfo)list.get(i);
            keyId = currBill.getKeyId();
            if (!combtionMap.containsKey(keyId)) {
                bill = (OneKeyBillCostInfo)currBill.clone();
                bill.setRecentCost(CalculateUtil.ZERO);
                bill.setRecentQty(CalculateUtil.ZERO);
                bill.setCalculateKind(0);
                bill.setBillNumber(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMBITIONCOSTAJDJUST", (Context)ctx));
                combtionMap.put(keyId, bill);
            } else {
                bill = (OneKeyBillCostInfo)combtionMap.get(keyId);
            }
            bill.setRecentCost(bill.getRecentCost().add(currBill.getRecentCost()));
        }
        return combtionMap;
    }

    private void handleCombitionList(Context ctx, ArrayList listAllBill, Map calMap, ArrayList costAdjBillList) {
        HashMap combitionMap = this.getCombitionMap(ctx, costAdjBillList);
        Iterator it = combitionMap.keySet().iterator();
        String keyID = null;
        OneKeyBillCostInfo costBill = null;
        OneKeyBillCostInfo currInBill = null;
        ArrayList<Object> inBillList = null;
        int index = 0;
        for (index = 0; index < listAllBill.size() && 2 == (costBill = (OneKeyBillCostInfo)listAllBill.get(index)).getCalculateKind(); ++index) {
        }
        while (it.hasNext()) {
            keyID = (String)it.next();
            costBill = (OneKeyBillCostInfo)combitionMap.get(keyID);
            inBillList = (ArrayList<Object>)calMap.get(keyID);
            for (int i = 0; inBillList != null && i < inBillList.size(); ++i) {
                currInBill = (OneKeyBillCostInfo)inBillList.get(i);
                if (2 != currInBill.getCalculateKind()) {
                    inBillList.add(i, costBill.clone());
                    listAllBill.add(index++, costBill);
                    break;
                }
                if (2 != currInBill.getCalculateKind() || i != inBillList.size() - 1) continue;
                inBillList.add(costBill.clone());
                listAllBill.add(index++, costBill);
                break;
            }
            if (inBillList != null) continue;
            inBillList = new ArrayList<Object>();
            inBillList.add(costBill.clone());
            calMap.put(keyID, inBillList);
        }
    }

    private void addExpReportInfo(Context ctx, CalculateUnitInfo calculateUnitInfo) {
        CostComputeReportPriceSourceInfo reportInfo = new CostComputeReportPriceSourceInfo();
        reportInfo.setParent(this.calParams.getReportHeaderInfo());
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)calculateUnitInfo.getCompanyOrgUnitId()));
        reportInfo.setCompanyOrgUnit(companyInfo);
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(periodInfo.getPeriodNumber());
        if (!StringUtil.isEmpty((String)calculateUnitInfo.getMaterialId())) {
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)calculateUnitInfo.getMaterialId()));
            reportInfo.setMaterial(materialInfo);
        }
        reportInfo.setAccountType((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get());
        reportInfo.setState(0);
        String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"257_FailCalculate", (Locale)ctx.getLocale());
        reportInfo.setPayout(msg);
        reportInfo.setSettleAccounts(msg);
        reportInfo.setCalculateKind(0);
        reportInfo.setTimeSerialNumber("0");
        reportInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        try {
            Timestamp timestamp = new Timestamp(sdf.parse("2900-01-01 00:00:00.000").getTime());
            reportInfo.setCreateTime(timestamp);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        reportInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        ((CostComputeReportPriceSourceCollection)((Object)this.reportColLocal.get())).add(reportInfo);
    }

    private HashMap getPriceMap(HashMap map) {
        HashMap<String, OneKeyBillCostInfo> tmpMap = new HashMap<String, OneKeyBillCostInfo>();
        if ("1".equals(this.calParams.getReworkCostType())) {
            for (String key : map.keySet()) {
                ArrayList periodBeginInList = (ArrayList)map.get(key);
                if (periodBeginInList == null || periodBeginInList.isEmpty()) continue;
                OneKeyBillCostInfo recentCost = (OneKeyBillCostInfo)periodBeginInList.get(0);
                recentCost = (OneKeyBillCostInfo)recentCost.clone();
                for (int i = 1; i < periodBeginInList.size(); ++i) {
                    OneKeyBillCostInfo recentCostTmp = (OneKeyBillCostInfo)periodBeginInList.get(i);
                    recentCost.setRecentCost(recentCost.getRecentCost().add(recentCostTmp.getRecentCost()));
                    recentCost.setRecentQty(recentCost.getRecentQty().add(recentCostTmp.getRecentQty()));
                }
                OneKeyCalculateHelper.calculateAvgPrice(recentCost);
                tmpMap.put(key, recentCost);
            }
        }
        return tmpMap;
    }

    protected void synCostMovePriceToInList(HashMap costMoveMap, HashMap calMap, OneKeyBillCostInfo bill) {
        if (bill.isCostPriceMove()) {
            OneKeyBillCostInfo costMoveObj = (OneKeyBillCostInfo)costMoveMap.get(bill.getStockTransBillEntryId());
            OneKeyBillCostInfo tempBill = null;
            OneKeyBillCostInfo moveBill = null;
            ArrayList moveInBill = costMoveObj.getMoveInbillList();
            for (int j = 0; moveInBill != null && j < moveInBill.size(); ++j) {
                moveBill = (OneKeyBillCostInfo)moveInBill.get(j);
                List inListBill = (List)calMap.get(moveBill.getKeyId());
                for (int i = 0; inListBill != null && i < inListBill.size(); ++i) {
                    tempBill = (OneKeyBillCostInfo)inListBill.get(i);
                    if (!tempBill.getBillEntryId().equals(moveBill.getBillEntryId())) continue;
                    tempBill.setRecentCost(moveBill.getRecentCost());
                    tempBill.setPrice(moveBill.getPrice());
                    if (!tempBill.isDealComplete()) {
                        tempBill.setPriceSource(PriceSourEnum.costMove);
                    }
                    tempBill.setHasSynData(true);
                }
            }
        }
    }

    protected void synCostMovePriceToInList(HashMap calMap, OneKeyBillCostInfo bill) {
        OneKeyBillCostInfo tempBill = null;
        List inListBill = (List)calMap.get(bill.getKeyId());
        for (int i = 0; inListBill != null && i < inListBill.size(); ++i) {
            tempBill = (OneKeyBillCostInfo)inListBill.get(i);
            if (!tempBill.getBillEntryId().equals(bill.getBillEntryId())) continue;
            tempBill.setRecentCost(bill.getRecentCost());
            tempBill.setPrice(bill.getPrice());
            if (!tempBill.isDealComplete()) {
                tempBill.setPriceSource(PriceSourEnum.costMove);
            }
            tempBill.setHasSynData(true);
        }
    }

    @Override
    protected void synCostMovePriceBill(HashMap costMoveMap, OneKeyBillCostInfo bill) throws CalculateException {
        if (bill.isCostPriceMove()) {
            OneKeyBillCostInfo costMoveObj = (OneKeyBillCostInfo)costMoveMap.get(bill.getStockTransBillEntryId());
            boolean isMoveInbill = false;
            if (bill.isMoveInBill()) {
                isMoveInbill = true;
            }
            if (!isMoveInbill) {
                OneKeyBillCostInfo moveCostBill = null;
                ArrayList moveCostList = costMoveObj.getMoveOutbillList();
                for (int i = 0; i < moveCostList.size(); ++i) {
                    moveCostBill = (OneKeyBillCostInfo)moveCostList.get(i);
                    if (moveCostBill.getBillEntryId().equals(bill.getBillEntryId())) {
                        moveCostBill.setRecentCost(bill.getRecentCost());
                        moveCostBill.setPrice(bill.getPrice());
                        bill.setNeedUpdate(true);
                    }
                    if (moveCostBill.isDealComplete() || moveCostBill.isNeedUpdate()) continue;
                    return;
                }
            }
            this.calCostMoveBill(costMoveObj, bill, isMoveInbill);
        }
    }

    protected void synListInBill(List listInBill, OneKeyBillCostInfo bill) {
        String strCalType = this.calParams.getCalType();
        if (bill.isNeedUpdate()) {
            OneKeyBillCostInfo inBill = null;
            for (int i = 0; i < listInBill.size(); ++i) {
                inBill = (OneKeyBillCostInfo)listInBill.get(i);
                if (inBill.isHasSynData() || !inBill.getBillEntryId().equals(bill.getBillEntryId())) continue;
                inBill.setRecentCost(bill.getRecentCost());
                inBill.setPrice(bill.getPrice());
                inBill.setRecentQty(bill.getRecentQty());
                if (!bill.isRedBill() || bill.getSrcBilInCurrPid() == 1 || !OneKeyCalculateHelper.isEffectBalance(bill, strCalType)) break;
                inBill.setRecentCost(bill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                inBill.setRecentQty(bill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                break;
            }
        }
    }

    protected void calMatAttrChangeCost(List needUpdatedBills, Map matAttrChgMap) {
        OneKeyBillCostInfo info = null;
        for (Map.Entry entry : matAttrChgMap.entrySet()) {
            MatAttrChangeVO vo = (MatAttrChangeVO)entry.getValue();
            vo.calculateCost();
            for (int i = 0; i < vo.getInBillCount(); ++i) {
                info = vo.getInBill(i);
                if (info == null || info.getFiVouchered() != 0) continue;
                needUpdatedBills.add(info);
            }
        }
    }

    private void getFifoBalance(HashMap balanceMap, ArrayList listInBill, String keyId) {
        OneKeyBalanceCostInfo balanceCostInfo = (OneKeyBalanceCostInfo)balanceMap.get(keyId);
        OneKeyBillCostInfo resultInfo = null;
        OneKeyBillCostInfo tempInfo = null;
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (balanceCostInfo != null) {
            resultInfo = balanceCostInfo.getReusltBillInfo();
            totalQty = resultInfo.getRecentQty();
            totalAmount = resultInfo.getRecentCost();
        } else {
            balanceCostInfo = new OneKeyBalanceCostInfo();
            resultInfo = new OneKeyBillCostInfo();
            if (listInBill != null && !listInBill.isEmpty()) {
                for (int i = 0; i < listInBill.size(); ++i) {
                    tempInfo = (OneKeyBillCostInfo)listInBill.get(i);
                    totalQty = totalQty.add(tempInfo.getRecentQty());
                    totalAmount = totalAmount.add(tempInfo.getRecentCost());
                }
            }
        }
        resultInfo.setRecentQty(totalQty);
        resultInfo.setRecentCost(totalAmount);
        balanceCostInfo.setReusltBillInfo(resultInfo);
        balanceMap.put(keyId, balanceCostInfo);
    }

    protected boolean calculateFIFOOutBillCost(ArrayList rsInpour, OneKeyBillCostInfo rsPayout, BigDecimal newInpPrice) {
        boolean isExceptionState = false;
        boolean isNeedUpdate = !rsPayout.isDealComplete() && !rsPayout.isCostAdjustBill() && !rsPayout.isNeedUpdate();
        int localCurrcyPrecision = rsPayout.getBaseCurrencyPrecision();
        int pricePrecision = rsPayout.getPricePrecision();
        BigDecimal baseqtyPayout = rsPayout.getRecentQty();
        BigDecimal amtPayout = rsPayout.getRecentCost();
        BigDecimal pricePayout = rsPayout.getPrice();
        BigDecimal baseqtyInpour = CalculateUtil.ZERO;
        BigDecimal amtInpour = CalculateUtil.ZERO;
        BigDecimal addUpAmount = CalculateUtil.ZERO;
        BigDecimal addUpQty = CalculateUtil.ZERO;
        BigDecimal addUpPrice = CalculateUtil.ZERO;
        BigDecimal lastSumQty = CalculateUtil.ZERO;
        BigDecimal lastSumAmount = CalculateUtil.ZERO;
        BigDecimal temp = CalculateUtil.ZERO;
        OneKeyBillCostInfo settleAccounts = null;
        boolean isCompleted = false;
        PriceSourEnum priceSource = PriceSourEnum.userDefine;
        for (int i = 0; rsInpour != null && i < rsInpour.size(); ++i) {
            priceSource = PriceSourEnum.fifoPrice;
            isCompleted = false;
            settleAccounts = (OneKeyBillCostInfo)rsInpour.get(i);
            baseqtyInpour = settleAccounts.getRecentQty();
            amtInpour = settleAccounts.getRecentCost();
            BigDecimal priceInpour = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(settleAccounts.getPrice()) <= 0) {
                newInpPrice = settleAccounts.getPrice();
            }
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0) {
                priceInpour = amtInpour.divide(baseqtyInpour, pricePrecision, 4);
            }
            if (settleAccounts.isMinusSettleAccount()) {
                if (isNeedUpdate) {
                    pricePayout = priceInpour;
                    amtPayout = baseqtyPayout.multiply(pricePayout).setScale(localCurrcyPrecision, 4);
                }
                settleAccounts.setRecentQty(settleAccounts.getRecentQty().subtract(baseqtyPayout));
                settleAccounts.setRecentCost(settleAccounts.getRecentCost().subtract(amtPayout));
                break;
            }
            addUpAmount = addUpAmount.add(amtInpour);
            addUpQty = addUpQty.add(baseqtyInpour);
            addUpPrice = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(addUpQty) != 0) {
                addUpPrice = addUpAmount.divide(addUpQty, pricePrecision, 4);
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) == 0) {
                addUpPrice = newInpPrice;
                priceSource = PriceSourEnum.newIn;
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) == 0) {
                addUpPrice = pricePayout;
                priceSource = PriceSourEnum.newOut;
            }
            if (baseqtyPayout.compareTo(addUpQty) <= 0) {
                if (isNeedUpdate) {
                    if (baseqtyPayout.compareTo(addUpQty) == 0) {
                        amtPayout = addUpAmount;
                        pricePayout = addUpPrice;
                    } else {
                        temp = baseqtyPayout.subtract(lastSumQty).multiply(priceInpour).setScale(localCurrcyPrecision, 4);
                        if (temp.compareTo(BigDecimal.ZERO) == 0 && baseqtyPayout.subtract(lastSumQty).compareTo(BigDecimal.ZERO) != 0 && priceInpour.compareTo(BigDecimal.ZERO) != 0) {
                            temp = RecentCostHelp.getMinValueByScale(localCurrcyPrecision, baseqtyPayout.subtract(lastSumQty).signum());
                        }
                        amtPayout = lastSumAmount.add(temp);
                        pricePayout = amtPayout.divide(baseqtyPayout, pricePrecision, 4);
                    }
                    baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    amtInpour = addUpAmount.subtract(amtPayout);
                    isCompleted = true;
                } else if (amtPayout.compareTo(addUpAmount) <= 0) {
                    baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    amtInpour = addUpAmount.subtract(amtPayout);
                    if (i == rsInpour.size() - 1 && CalculateUtil.ZERO.compareTo(amtInpour) == 0 && CalculateUtil.ZERO.compareTo(baseqtyInpour) == 0) {
                        settleAccounts.setMinusSettleAccount(true);
                    }
                    isCompleted = true;
                } else {
                    lastSumQty = lastSumQty.add(baseqtyInpour);
                    lastSumAmount = lastSumAmount.add(amtInpour);
                    baseqtyInpour = CalculateUtil.ZERO;
                    amtInpour = CalculateUtil.ZERO;
                    if (i == rsInpour.size() - 1) {
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                        amtInpour = addUpAmount.subtract(amtPayout);
                        settleAccounts.setMinusSettleAccount(true);
                        isCompleted = true;
                    }
                }
            } else {
                lastSumQty = lastSumQty.add(baseqtyInpour);
                lastSumAmount = lastSumAmount.add(amtInpour);
                baseqtyInpour = CalculateUtil.ZERO;
                amtInpour = CalculateUtil.ZERO;
                if (i == rsInpour.size() - 1) {
                    if (isNeedUpdate) {
                        pricePayout = addUpPrice;
                        amtPayout = pricePayout.multiply(baseqtyPayout).setScale(localCurrcyPrecision, 4);
                    }
                    baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    amtInpour = addUpAmount.subtract(amtPayout);
                    settleAccounts.setMinusSettleAccount(true);
                    isCompleted = true;
                }
            }
            settleAccounts.setRecentQty(baseqtyInpour);
            settleAccounts.setRecentCost(amtInpour);
            if (CalculateUtil.ZERO.compareTo(pricePayout) > 0 && isCompleted) {
                isExceptionState = true;
            }
            if (!isExceptionState && CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0 && isCompleted) {
                priceInpour = amtInpour.divide(baseqtyInpour, pricePrecision, 4);
                boolean bl = isExceptionState = CalculateUtil.ZERO.compareTo(priceInpour) > 0;
            }
            if (isCompleted) break;
        }
        if (isNeedUpdate) {
            rsPayout.setPriceSource(priceSource);
            rsPayout.setPrice(pricePayout);
            rsPayout.setRecentCost(amtPayout);
        }
        this.clearDealedInpourList(rsInpour);
        return isExceptionState;
    }

    @Override
    protected void clearDealedInpourList(ArrayList rsInpour) {
        for (int i = rsInpour.size() - 1; i >= 0; --i) {
            OneKeyBillCostInfo settleAccounts = (OneKeyBillCostInfo)rsInpour.get(i);
            BigDecimal baseqtyInpour = settleAccounts.getRecentQty();
            BigDecimal amtInpour = settleAccounts.getRecentCost();
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0 || CalculateUtil.ZERO.compareTo(amtInpour) != 0 || rsInpour.size() <= 1) continue;
            rsInpour.remove(i);
        }
    }

    protected void handleDetailDiffer(Context ctx, ArrayList listIn, ArrayList listPayout, ArrayList needUpdatedBills) throws EASBizException, BOSException {
        BigDecimal lastQty = new BigDecimal("0");
        BigDecimal lastAmount = new BigDecimal("0");
        boolean isHandleDiffer = false;
        OneKeyBillCostInfo outCostInfo = null;
        if (listIn != null && !listIn.isEmpty()) {
            OneKeyBillCostInfo inCostInfo;
            int i;
            for (i = 0; i < listIn.size(); ++i) {
                inCostInfo = (OneKeyBillCostInfo)listIn.get(i);
                lastQty = lastQty.add(inCostInfo.getRecentQty());
                lastAmount = lastAmount.add(inCostInfo.getRecentCost());
            }
            if (CalculateUtil.ZERO.compareTo(lastQty) == 0 && CalculateUtil.ZERO.compareTo(lastAmount) != 0) {
                for (i = listPayout.size() - 1; i >= 0; --i) {
                    outCostInfo = (OneKeyBillCostInfo)listPayout.get(i);
                    if (!this.isHandleDetailDiffer(lastAmount, outCostInfo)) continue;
                    isHandleDiffer = true;
                    outCostInfo.setRecentCost(outCostInfo.getRecentCost().add(lastAmount));
                    if (CalculateUtil.ZERO.compareTo(outCostInfo.getRecentQty()) != 0) {
                        outCostInfo.setPrice(outCostInfo.getRecentCost().divide(outCostInfo.getRecentQty(), outCostInfo.getPricePrecision(), 4));
                        break;
                    }
                    outCostInfo.setPrice(CalculateUtil.ZERO);
                    break;
                }
                if (isHandleDiffer) {
                    for (i = 0; i < listIn.size(); ++i) {
                        inCostInfo = (OneKeyBillCostInfo)listIn.get(i);
                        inCostInfo.setRecentQty(CalculateUtil.ZERO);
                        inCostInfo.setRecentCost(CalculateUtil.ZERO);
                    }
                    needUpdatedBills.add(outCostInfo);
                    outCostInfo.setNeedUpdate(true);
                    this.addReportInfo(ctx, outCostInfo, listIn, 4, 0);
                }
            }
        }
    }

    private boolean isHandleDetailDiffer(BigDecimal adjustAmount, OneKeyBillCostInfo infoBill) {
        return infoBill.getFiVouchered() == 0 && infoBill.getIsCombition() != 1 && !infoBill.isNeedUpdate() && CalculateUtil.ZERO.compareTo(infoBill.getReverseQty()) == 0 && CalculateUtil.ZERO.compareTo(infoBill.getRecentCost().add(adjustAmount)) < 0 && !infoBill.isCostPriceMove() && !infoBill.isDealComplete() && !infoBill.isMatAttrChange();
    }

    protected void addReportInfo(Context ctx, OneKeyBillCostInfo bill, ArrayList list, int outwarehouseType, int state) throws EASBizException, BOSException {
        CostComputeReportPriceSourceInfo reportInfo = new CostComputeReportPriceSourceInfo();
        reportInfo.setParent(this.calParams.getReportHeaderInfo());
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)bill.getCompanyOrgUnitId()));
        reportInfo.setCompanyOrgUnit(companyInfo);
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(periodInfo.getPeriodNumber());
        if (!StringUtil.isEmpty((String)bill.getStorageOrgUnitId())) {
            StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
            storageInfo.setId(BOSUuid.read((String)bill.getStorageOrgUnitId()));
            reportInfo.setStorageOrgUnit(storageInfo);
        }
        if (!StringUtil.isEmpty((String)bill.getWarehouseId())) {
            WarehouseInfo warehouseInfo = new WarehouseInfo();
            warehouseInfo.setId(BOSUuid.read((String)bill.getWarehouseId()));
            reportInfo.setWarehouse(warehouseInfo);
        }
        if (!StringUtil.isEmpty((String)bill.getMaterialId())) {
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)bill.getMaterialId()));
            reportInfo.setMaterial(materialInfo);
        }
        reportInfo.setAccountType((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get());
        reportInfo.setLot(bill.getLot());
        if (!StringUtil.isEmpty((String)bill.getAssistPropertyId())) {
            AsstAttrValueInfo assPropInfo = new AsstAttrValueInfo();
            assPropInfo.setId(BOSUuid.read((String)bill.getAssistPropertyId()));
            reportInfo.setAssistProperty(assPropInfo);
        }
        if (!StringUtil.isEmpty((String)bill.getProjectId())) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(BOSUuid.read((String)bill.getProjectId()));
            reportInfo.setProject(projectInfo);
        }
        if (!StringUtil.isEmpty((String)bill.getTrackNumberId())) {
            TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
            trackNumberInfo.setId(BOSUuid.read((String)bill.getTrackNumberId()));
            reportInfo.setTrackNumber(trackNumberInfo);
        }
        reportInfo.setState(state);
        long timeSerialNumber = bill.getTimeSerialNumber();
        StringBuffer income = new StringBuffer();
        StringBuffer payout = new StringBuffer();
        StringBuffer settleAccountSb = new StringBuffer();
        String billName = "";
        String billNumber = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        String createTime = null;
        if (2 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_CLOSE_ACCOUNT", (Context)ctx);
            createTime = "1900-01-01 00:00:00.000";
        } else if (3 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_END_CLOSE_ACCOUNT", (Context)ctx);
            createTime = "2900-01-01 00:00:00.000";
            timeSerialNumber = new Long("9999999999999");
        } else if (4 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DealCostDiffApportion", (Context)ctx);
            billNumber = bill.getBillNumber();
            createTime = "2899-01-01 00:00:00.000";
            timeSerialNumber = new Long("9999999999998");
        } else {
            createTime = sdf.format(bill.getBizDate());
            billNumber = bill.getBillNumber();
            billName = bill.getBillTypeName();
        }
        if (0 == outwarehouseType || 2 == outwarehouseType) {
            income.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getRecentQty(), bill.getPrice()));
        }
        if (1 == outwarehouseType || 4 == outwarehouseType) {
            payout.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getRecentQty(), bill.getPrice()));
        }
        if (bill.isExceptionState()) {
            settleAccountSb.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SettleAccounts_Exception", (Context)ctx));
        } else if (bill.getSrcBilInCurrPid() == 1 && bill.getBillTypeId().equals(bill.getSourceBillTypeId())) {
            settleAccountSb.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DealCombitionBill", (Context)ctx)).append("\n");
        } else {
            int reportShowRecordsCount = 3;
            int reportShowRecordsCountIndex = 0;
            for (int i = 0; list != null && i < list.size(); ++i) {
                OneKeyBillCostInfo settleAccounts = (OneKeyBillCostInfo)list.get(i);
                if (3 != outwarehouseType && settleAccounts.getTimeSerialNumber() - bill.getTimeSerialNumber() > 0L) break;
                BigDecimal baseqtyInpour = settleAccounts.getRecentQty();
                BigDecimal amtInpour = settleAccounts.getRecentCost();
                BigDecimal priceInpour = CalculateUtil.ZERO;
                if (CalculateUtil.ZERO.compareTo(settleAccounts.getRecentQty()) != 0) {
                    priceInpour = settleAccounts.getRecentCost().divide(settleAccounts.getRecentQty(), bill.getPricePrecision(), 4);
                }
                if (CalculateUtil.ZERO.compareTo(baseqtyInpour) == 0 && CalculateUtil.ZERO.compareTo(amtInpour) == 0) continue;
                settleAccountSb.append(RecentCostHelp.takeAmountQytPriceDesc(amtInpour, baseqtyInpour, priceInpour));
                if (3 != outwarehouseType && ++reportShowRecordsCountIndex >= reportShowRecordsCount) {
                    settleAccountSb.append("  ......");
                    break;
                }
                settleAccountSb.append("\n");
            }
            if (settleAccountSb.toString().trim().length() == 0) {
                settleAccountSb.append("0.00 * 0.00 = 0.00\n");
            }
        }
        String settleStr = settleAccountSb.toString();
        if (settleAccountSb.toString().length() > 255) {
            settleStr = settleAccountSb.substring(0, 255);
        }
        reportInfo.setBillName(billName);
        reportInfo.setBillNumber(billNumber);
        reportInfo.setIncome(income.toString());
        reportInfo.setPayout(payout.toString());
        reportInfo.setSettleAccounts(settleStr);
        reportInfo.setCalculateKind(outwarehouseType);
        reportInfo.setTimeSerialNumber(String.valueOf(timeSerialNumber));
        if (StringUtils.isEmpty((String)income.toString()) || bill.isCostPriceMove()) {
            reportInfo.setPriceSource(bill.getPriceSource());
        }
        reportInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        try {
            Timestamp timestamp = new Timestamp(sdf.parse(createTime).getTime());
            reportInfo.setCreateTime(timestamp);
        }
        catch (ParseException timestamp) {
            // empty catch block
        }
        reportInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        ((CostComputeReportPriceSourceCollection)((Object)this.reportColLocal.get())).add(reportInfo);
        if (((CostComputeReportPriceSourceCollection)((Object)this.reportColLocal.get())).size() >= 500) {
            CoreBaseCollection coll = new CoreBaseCollection();
            coll.addObjectCollection((IObjectCollection)this.reportColLocal.get());
            CostComputeReportPriceSourceFactory.getLocalInstance(ctx).addnewBatchData(coll);
            ((CostComputeReportPriceSourceCollection)((Object)this.reportColLocal.get())).clear();
        }
    }
}

