/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.calculateimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBalanceCostInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBillCostInfo;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.AbstractOneKeyCalculate;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyUpdateBillCostHelper;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateHelper;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OneKeyMovingAverageCalaulte
extends AbstractOneKeyCalculate {
    private static final String CALORDER = "calOrder";

    @Override
    protected void calculateStrategy(Context ctx, CalculateUnitInfo calculateUnitInfo) throws EASBizException, BOSException {
        OneKeyUpdateBillCostHelper updateBillCostHelper = null;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            updateBillCostHelper = new OneKeyUpdateBillCostHelper(con);
            this.checkInterrupted();
            HashMap balanceMap = this.movingAvgCalculate(ctx, calculateUnitInfo, con);
            List allBillList = (List)balanceMap.get("ALLINOUTLIST");
            updateBillCostHelper.updateBills(allBillList, new HashMap());
            this.checkInterrupted();
            this.handleReport(ctx, balanceMap);
            int size = allBillList.size();
            if (this.calParams.getCalcResulteTbl() != null && size > 0) {
                for (int i = size - 1; i >= 0; --i) {
                    OneKeyBillCostInfo bill = (OneKeyBillCostInfo)allBillList.get(i);
                    if (bill.getCalculateKind() != 1 || bill.getFiVouchered() != 0) continue;
                    this.insertCalcResultInfo(ctx, bill, this.calParams.getCalcResulteTbl());
                    break;
                }
            }
            updateBillCostHelper.executeBatch(true);
            this.checkInterrupted();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            updateBillCostHelper.close();
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void handleReport(Context ctx, HashMap balanceMap) throws EASBizException, BOSException {
        List rptList = (List)balanceMap.get("ALLINOUTLIST");
        Map keyExcStateMap = null;
        if (this.calParams.isOnlyWriteExpReport()) {
            keyExcStateMap = this.getKeyExceptionState(balanceMap);
        }
        this.addOneKeyReportInfo(ctx, rptList, keyExcStateMap);
    }

    private HashMap movingAvgCalculate(Context ctx, CalculateUnitInfo calculateUnitInfo, Connection conn) throws BOSException {
        HashMap hashMap;
        ResultSet rs = null;
        PreparedStatement billPreStatement = null;
        try {
            PeriodInfo periodInfo = this.calParams.getPeriodInfo();
            ArrayList<OneKeyBillCostInfo> listAllBill = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> listRedOutBill = new ArrayList<OneKeyBillCostInfo>();
            LinkedHashMap costMoveMap = new LinkedHashMap();
            HashMap<String, OneKeyBillCostInfo> periodBillMap = new HashMap<String, OneKeyBillCostInfo>();
            HashMap matAttrChgMap = new HashMap();
            HashMap prePeriodCostMoveMap = new HashMap();
            HashMap<String, OneKeyBillCostInfo> costBillMap = new HashMap<String, OneKeyBillCostInfo>();
            HashMap<String, OneKeyBillCostInfo> combitionMap = new HashMap<String, OneKeyBillCostInfo>();
            OneKeyBillCostInfo periodBeginBill = null;
            OneKeyBillCostInfo costBill = null;
            OneKeyBillCostInfo bill = null;
            billPreStatement = this.getBillPreparedStatement(conn, calculateUnitInfo);
            rs = this.getBillRowSet(billPreStatement, calculateUnitInfo);
            this.checkInterrupted();
            long timeSerialNumber = new Date().getTime();
            while (rs.next()) {
                bill = this.convertOneKeyBillCostInfo(rs, timeSerialNumber += 10L);
                if (bill.getFiVouchered() == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                if (2 == bill.getCalculateKind()) {
                    periodBeginBill = (OneKeyBillCostInfo)periodBillMap.get(bill.getKeyId());
                    if (periodBeginBill == null) {
                        periodBeginBill = bill;
                        periodBillMap.put(bill.getKeyId(), periodBeginBill);
                        listAllBill.add(periodBeginBill);
                    } else {
                        periodBeginBill.setRecentCost(periodBeginBill.getRecentCost().add(bill.getRecentCost()));
                        periodBeginBill.setRecentQty(periodBeginBill.getRecentQty().add(bill.getRecentQty()));
                    }
                    OneKeyCalculateHelper.calculateAvgPrice(periodBeginBill);
                }
                if (1 == bill.getCalculateKind() && ("1".equals(this.calParams.getNoSrcOutBillCalType()) || "1".equals(this.calParams.getSrcBillPreperiodCalType()))) {
                    if (bill.getSourceBillEntryId() != null) {
                        if (bill.isSrcOutBillInPrePeriod()) {
                            if ("1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                                bill.setOutRetBillisIn(true);
                            }
                            bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            bill.setNotUpdateCostAgain(true);
                        } else if (bill.isSrcOutBillInCurrentPd()) {
                            bill.setNotUpdateCostAgain(true);
                            bill.setNeedUpdate(true);
                        } else if (bill.isRedBill() && "1".equals(this.calParams.getNoSrcOutBillCalType())) {
                            bill.setOutRetBillisIn(true);
                            bill.setNotUpdateCostAgain(true);
                        }
                    } else {
                        if (bill.isNotSrcOutRetBill() && "1".equals(this.calParams.getNoSrcOutBillCalType())) {
                            bill.setOutRetBillisIn(true);
                            bill.setNotUpdateCostAgain(true);
                        }
                        if (bill.isSrcOutBillInPrePeriod() && "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                            bill.setOutRetBillisIn(true);
                            bill.setNotUpdateCostAgain(true);
                        }
                    }
                }
                bill.setMoveAvgQty(CalculateUtil.ZERO);
                bill.setMoveAvgPrice(CalculateUtil.ZERO);
                bill.setMoveAvgCost(CalculateUtil.ZERO);
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill);
                    this.buildCostPriceMove(bill, costMoveMap);
                }
                if (bill.isMatAttrChange()) {
                    bill.setCalculate(false);
                    this.buildMatAttrChange(bill, matAttrChgMap);
                }
                if (OneKeyCalculateHelper.isPrePeriodBill(bill, periodInfo) || 2 == bill.getCalculateKind()) continue;
                combitionMap.put(bill.getBillEntryId(), bill);
                if (bill.getSrcBilInCurrPid() == -1) {
                    if (!combitionMap.containsKey(bill.getSourceBillEntryId())) continue;
                    OneKeyBillCostInfo combinBill = (OneKeyBillCostInfo)combitionMap.get(bill.getSourceBillEntryId());
                    bill.setTimeSerialNumber(combinBill.getTimeSerialNumber() + 1L);
                    int index = listAllBill.indexOf(combinBill);
                    listAllBill.add(index + 1, bill);
                    if (!bill.isRedBill()) continue;
                    listRedOutBill.add(bill);
                    continue;
                }
                if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getBillTypeId())) {
                    costBill = (OneKeyBillCostInfo)costBillMap.get(bill.getBillId() + bill.getKeyId());
                    if (costBill == null) {
                        costBill = bill;
                        costBillMap.put(bill.getBillId() + bill.getKeyId(), bill);
                        listAllBill.add(costBill);
                        continue;
                    }
                    costBill.setRecentCost(costBill.getRecentCost().add(bill.getRecentCost()));
                    costBill.setRecentQty(costBill.getRecentQty().add(bill.getRecentQty()));
                    continue;
                }
                listAllBill.add(bill);
                if (!bill.isRedBill()) continue;
                listRedOutBill.add(bill);
            }
            this.checkInterrupted();
            this.getCostMoveInBillByIssue(conn, prePeriodCostMoveMap, costMoveMap, timeSerialNumber, periodInfo);
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, null);
            this.checkInterrupted();
            HashMap balanceMap = this.calculateOutBillCost(ctx, listAllBill, costMoveMap, listRedOutBill);
            this.updateMoveLocationBill(ctx, balanceMap, (ArrayList)balanceMap.get(CALORDER), calculateUnitInfo);
            balanceMap.remove(CALORDER);
            this.calMatAttrChangeCost(matAttrChgMap);
            this.checkInterrupted();
            hashMap = balanceMap;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, billPreStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)billPreStatement);
        return hashMap;
    }

    @Override
    protected String getBillSqlOrder() {
        return " Order by Bill.FBizdate,BILL.FAUDITTIME,Bill.FNumber desc ,Bill.FSeqNum,bill.fcalculatekind ";
    }

    @Override
    protected void adjustPrePeriodData(Context ctx) throws BOSException {
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        DBUtil.execute(ctx, this.getUpateMaterialReqPriceFromPrePeriod(periodInfo));
        DBUtil.execute(ctx, this.getUpateSaleIssuePriceFromPrePeriod(periodInfo));
        DbUtil.execute((Context)ctx, (String)this.getUpateCostMoveIssueFromPrePeriod(periodInfo));
        DBUtil.execute(ctx, this.getUpateCostMoveInFromPrePeriod(periodInfo));
        DbUtil.execute((Context)ctx, (String)this.getUpdateSrcBillBizDate());
    }

    private HashMap calculateOutBillCost(Context ctx, List listAllBill, HashMap costMoveMap, List listRedOutBill) throws BOSException, CalculateException {
        String strCalType = this.calParams.getCalType();
        OneKeyBalanceCostInfo balanceCostInfo = null;
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        boolean noSrcOutBillCalType = "1".equals(this.calParams.getNoSrcOutBillCalType());
        boolean srcBillPreperiodCalType = "1".equals(this.calParams.getSrcBillPreperiodCalType());
        OneKeyBillCostInfo bill = null;
        ArrayList<String> calOrder = new ArrayList<String>();
        balanceMap.put(CALORDER, calOrder);
        for (int i = 0; listAllBill != null && i < listAllBill.size(); ++i) {
            bill = (OneKeyBillCostInfo)listAllBill.get(i);
            String key = bill.getKeyId();
            if (balanceMap.get(key) == null) {
                balanceCostInfo = new OneKeyBalanceCostInfo();
                balanceCostInfo.setStrCalType(strCalType);
                balanceCostInfo.setRecentInPrice(CalculateUtil.ZERO);
                balanceCostInfo.setRecentOutPrice(CalculateUtil.ZERO);
                balanceCostInfo.setRecentPrice(CalculateUtil.ZERO);
                OneKeyBillCostInfo tmpInfo = (OneKeyBillCostInfo)bill.clone();
                tmpInfo.setRecentCost(CalculateUtil.ZERO);
                tmpInfo.setRecentQty(CalculateUtil.ZERO);
                OneKeyCalculateHelper.calculateAvgPrice(tmpInfo);
                balanceCostInfo.setReusltBillInfo(tmpInfo);
                calOrder.add(key);
            } else {
                balanceCostInfo = (OneKeyBalanceCostInfo)balanceMap.get(key);
            }
            if (balanceCostInfo.isExceptionState()) continue;
            if (1 != bill.getCalculateKind()) {
                this.calcualteBlueInOrOutBillCost(ctx, balanceCostInfo, bill, true);
            } else if (1 == bill.getCalculateKind()) {
                if (bill.isRedBill() && !bill.isCostAdjustBill()) {
                    if (bill.getSourceBillEntryId() != null) {
                        if (!bill.isNotUpdateCostAgain()) {
                            bill.setNeedUpdate(true);
                            if (bill.isSrcOutBillInPrePeriod()) {
                                bill.setOutRetBillisIn(srcBillPreperiodCalType);
                                bill.setNotUpdateCostAgain(true);
                                this.calcualteBlueInOrOutBillCost(ctx, balanceCostInfo, bill, srcBillPreperiodCalType);
                            } else {
                                bill.setNeedUpdate(true);
                                this.calculateBlueOutCost(ctx, balanceCostInfo, bill);
                            }
                        } else {
                            this.calcualteBlueInOrOutBillCost(ctx, balanceCostInfo, bill, false);
                        }
                    } else {
                        this.calcualteBlueInOrOutBillCost(ctx, balanceCostInfo, bill, noSrcOutBillCalType);
                        bill.setOutRetBillisIn(noSrcOutBillCalType);
                        this.handleBlueBillAndRedBillRel(listRedOutBill, bill);
                    }
                } else if (CalculateUtil.ZERO.compareTo(bill.getRecentQty()) <= 0 && !bill.isCostAdjustBill()) {
                    this.calculateBlueOutCost(ctx, balanceCostInfo, bill);
                    this.synCostMovePriceBill(costMoveMap, bill);
                    this.handleBlueBillAndRedBillRel(listRedOutBill, bill);
                    bill.setCanAdjustDiffer(true);
                } else {
                    this.calcualteBlueInOrOutBillCost(ctx, balanceCostInfo, bill, false);
                }
            }
            balanceMap.put(key, balanceCostInfo);
        }
        this.handleDetailDiff(listAllBill, balanceMap);
        balanceMap.put("ALLINOUTLIST", listAllBill);
        return balanceMap;
    }

    private void handleDetailDiff(List allList, HashMap costMoveMap) {
        OneKeyBillCostInfo tmpBillInfo = null;
        OneKeyBalanceCostInfo balanceInfo = null;
        if (costMoveMap == null || costMoveMap.size() == 0 || allList == null || allList.isEmpty()) {
            return;
        }
        Iterator iter = costMoveMap.entrySet().iterator();
        String mapKey = null;
        block0: while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof OneKeyBalanceCostInfo)) continue;
            mapKey = (String)entry.getKey();
            balanceInfo = (OneKeyBalanceCostInfo)entry.getValue();
            if (balanceInfo == null) {
                return;
            }
            if (!balanceInfo.isNeedAdjustDetail()) continue;
            for (int i = allList.size() - 1; i >= 0; --i) {
                tmpBillInfo = (OneKeyBillCostInfo)allList.get(i);
                if (mapKey == null || !mapKey.equals(tmpBillInfo.getKeyId()) || !this.isHandleDetailDiffer(balanceInfo, tmpBillInfo)) continue;
                tmpBillInfo.setRecentCost(tmpBillInfo.getRecentCost().add(balanceInfo.getRecentCost()));
                OneKeyCalculateHelper.calculateAvgPrice(tmpBillInfo);
                tmpBillInfo.setMoveAvgQty(CalculateUtil.ZERO);
                tmpBillInfo.setMoveAvgPrice(CalculateUtil.ZERO);
                tmpBillInfo.setMoveAvgCost(CalculateUtil.ZERO);
                tmpBillInfo.setCanAdjustDiffer(true);
                balanceInfo.handleDetailDifer(tmpBillInfo);
                tmpBillInfo.setHandleTailDiff(1);
                continue block0;
            }
        }
    }

    private boolean isHandleDetailDiffer(OneKeyBalanceCostInfo balanceInfo, OneKeyBillCostInfo infoBill) {
        return !infoBill.isDealComplete() && infoBill.isCanAdjustDiffer() && CalculateUtil.ZERO.compareTo(balanceInfo.getRecentCost().add(infoBill.getRecentCost())) < 0 && CalculateUtil.ZERO.compareTo(infoBill.getReverseQty()) == 0 && !infoBill.isCostPriceMove() && !infoBill.isMatAttrChange();
    }

    private void calculateBlueOutCost(Context ctx, OneKeyBalanceCostInfo balanceCostInfo, OneKeyBillCostInfo bill) throws BOSException {
        BigDecimal recntInPrice = balanceCostInfo.getRecentInPrice();
        PriceSourEnum priceSource = PriceSourEnum.realtimePrice;
        int priceType = Integer.parseInt(this.calParams.getZeroGetCostType());
        if (CalculateUtil.isZero(recntInPrice)) {
            recntInPrice = this.getPrice(ctx, bill);
            if (priceType == 0) {
                priceSource = PriceSourEnum.newOut;
            } else if (priceType == 1) {
                priceSource = PriceSourEnum.newIn;
            } else if (priceType == 2) {
                priceSource = PriceSourEnum.standUnitPrice;
            } else if (priceType == 4) {
                priceSource = PriceSourEnum.newReturnPrice;
            }
        }
        if (recntInPrice == null) {
            recntInPrice = CalculateUtil.ZERO;
        }
        if (CalculateUtil.ZERO.compareTo(recntInPrice) >= 0) {
            bill.setExceptionState(true);
            if (CalculateUtil.ZERO.compareTo(recntInPrice) > 0) {
                priceSource = PriceSourEnum.negativePrice;
            }
            if (CalculateUtil.ZERO.compareTo(recntInPrice) == 0) {
                priceSource = PriceSourEnum.zeroPrice;
            }
            bill.setPriceSource(priceSource);
            bill.setErrorMsg(this.errorMsg);
            balanceCostInfo.setExceptionState(true);
            return;
        }
        if (!bill.isNotUpdateCostAgain() && !bill.isDealComplete()) {
            BigDecimal cost = bill.getRecentQty().multiply(recntInPrice).setScale(bill.getBaseCurrencyPrecision(), 4);
            if (cost.compareTo(BigDecimal.ZERO) == 0 && bill.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && recntInPrice.compareTo(BigDecimal.ZERO) != 0) {
                cost = RecentCostHelp.getMinValueByScale(bill.getBaseCurrencyPrecision(), bill.getRecentQty().signum());
            }
            bill.setRecentCost(cost);
            bill.setPrice(recntInPrice);
            bill.setPriceSource(priceSource);
            bill.setNeedUpdate(true);
        }
        balanceCostInfo.calculateBalance(bill, false);
    }

    private boolean calcualteBlueInOrOutBillCost(Context ctx, OneKeyBalanceCostInfo balanceBill, OneKeyBillCostInfo billInfo, boolean isIn) throws BOSException {
        BigDecimal avgPrice = balanceBill.getPrice();
        BigDecimal recntOutPrice = balanceBill.getRecentOutPrice();
        BigDecimal recntInPrice = balanceBill.getRecentInPrice();
        PriceSourEnum priceSource = PriceSourEnum.realtimePrice;
        int priceType = Integer.parseInt(this.calParams.getZeroGetCostType());
        if (CalculateUtil.isZero(avgPrice)) {
            avgPrice = recntInPrice;
            priceSource = PriceSourEnum.newIn;
        }
        if (CalculateUtil.isZero(avgPrice)) {
            avgPrice = recntOutPrice;
            priceSource = PriceSourEnum.newOut;
        }
        if (CalculateUtil.isZero(avgPrice)) {
            avgPrice = billInfo.getPrice();
            priceSource = PriceSourEnum.userDefine;
        }
        if (!isIn && CalculateUtil.isZero(avgPrice)) {
            avgPrice = this.getPrice(ctx, billInfo);
            if (priceType == 0) {
                priceSource = PriceSourEnum.newOut;
            } else if (priceType == 1) {
                priceSource = PriceSourEnum.newIn;
            } else if (priceType == 2) {
                priceSource = PriceSourEnum.standUnitPrice;
            } else if (priceType == 4) {
                priceSource = PriceSourEnum.newReturnPrice;
            }
        }
        if (avgPrice == null) {
            avgPrice = CalculateUtil.ZERO;
        }
        if (!(isIn || billInfo.isDealComplete() || billInfo.isCostAdjustBill())) {
            if (CalculateUtil.ZERO.compareTo(avgPrice) >= 0 && 2 != billInfo.getCalculateKind()) {
                if (CalculateUtil.ZERO.compareTo(avgPrice) > 0) {
                    priceSource = PriceSourEnum.negativePrice;
                }
                if (CalculateUtil.ZERO.compareTo(avgPrice) == 0) {
                    priceSource = PriceSourEnum.zeroPrice;
                }
                if (priceType == 3 && billInfo.getPrice().compareTo(CalculateUtil.ZERO) > 0) {
                    priceSource = PriceSourEnum.userDefine;
                }
                billInfo.setPriceSource(priceSource);
                billInfo.setExceptionState(true);
                billInfo.setErrorMsg(this.errorMsg);
                balanceBill.setExceptionState(true);
                return false;
            }
            if (!billInfo.isNotUpdateCostAgain()) {
                billInfo.setRecentCost(billInfo.getRecentQty().multiply(avgPrice).setScale(billInfo.getBaseCurrencyPrecision(), 4));
                billInfo.setPrice(avgPrice);
                if (!billInfo.isDealComplete()) {
                    billInfo.setPriceSource(priceSource);
                }
                billInfo.setNeedUpdate(true);
            }
            if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) != 0) {
                balanceBill.setRecentOutPrice(avgPrice);
            }
        } else if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) != 0) {
            balanceBill.setRecentInPrice(avgPrice);
        }
        balanceBill.calculateBalance(billInfo, isIn);
        if (2 != billInfo.getCalculateKind() && CalculateUtil.ZERO.compareTo(balanceBill.getPrice()) > 0) {
            billInfo.setExceptionState(true);
            billInfo.setErrorMsg(this.errorMsg);
            balanceBill.setExceptionState(true);
            return false;
        }
        if (1 != billInfo.getCalculateKind() || !billInfo.isCostAdjustBill()) {
            balanceBill.setRecentPrice(balanceBill.getPrice());
        }
        return true;
    }
}

