/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCostAdjustLotAndAssistVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckCostAdjustLotAndAssistVRule.class);

    public CheckCostAdjustLotAndAssistVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        block7: {
            Map<String, Boolean> materialList;
            CostAdjustBillEntryInfo entry;
            String paramValue;
            CompanyOrgUnitInfo companyInfo;
            CostAdjustBillInfo info;
            block6: {
                if (bean == null) {
                    return;
                }
                info = (CostAdjustBillInfo)bean;
                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.getCtx());
                companyInfo = InvServerUtils.getCompanyInfoForStorage((Context)this.getCtx(), (StorageOrgUnitInfo)info.getStorageOrgUnit());
                if (companyInfo == null || companyInfo.getId() == null) {
                    return;
                }
                paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyInfo.getId()), "SCM_CAL_012");
                entry = null;
                materialList = this.getMaterialList(info);
                if (paramValue == null || !"true".equals(paramValue.trim())) break block6;
                MaterialInventoryInfo materialInventoryInfo = null;
                int size = info.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    String materialId;
                    entry = info.getEntry().get(i);
                    if (entry.getMaterial() == null || (materialInventoryInfo = this.getMaterialInventoryInfo(materialId = entry.getMaterial().getId().toString(), info.getStorageOrgUnit().getId().toString())) == null) continue;
                    if (materialInventoryInfo.isIsLotNumber() && (entry.getLot() == null || "".equals(entry.getLot()))) {
                        throw new InvBizException(InvBizException.COSTADJUST_LOT_NULL, new Object[]{entry.getSeq()});
                    }
                    boolean isUseAsstAttrRelation = materialList.get(materialId);
                    if (!isUseAsstAttrRelation || entry.getAssistProperty() != null) continue;
                    throw new InvBizException(InvBizException.COSTADJUST_ASSIST_NULL, new Object[]{entry.getSeq()});
                }
                break block7;
            }
            if (paramValue == null || !"false".equals(paramValue.trim())) break block7;
            MaterialCompanyInfoInfo materialCopangy = null;
            MaterialInventoryInfo materialInventoryInfo = null;
            int size = info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entry = info.getEntry().get(i);
                if (entry.getMaterial() == null) continue;
                materialCopangy = this.getMaterialCompanyInfo(entry.getMaterial().getId().toString(), companyInfo.getId().toString());
                materialInventoryInfo = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString(), info.getStorageOrgUnit().getId().toString());
                if (materialInventoryInfo == null || materialCopangy == null) continue;
                if (materialInventoryInfo.isIsLotNumber() && materialCopangy.getAccountType().getValue() == 5 && (entry.getLot() == null || "".equals(entry.getLot()))) {
                    throw new InvBizException(InvBizException.COSTADJUST_LOT_NULL, new Object[]{entry.getSeq()});
                }
                boolean isUseAsstAttrRelation = materialList.get(entry.getMaterial().getId().toString());
                if (!isUseAsstAttrRelation || materialCopangy.getAccountType().getValue() != 5 || entry.getAssistProperty() != null) continue;
                throw new InvBizException(InvBizException.COSTADJUST_ASSIST_NULL, new Object[]{entry.getSeq()});
            }
        }
    }

    private Map<String, Boolean> getMaterialList(CostAdjustBillInfo info) throws BOSException, EASBizException {
        CostAdjustBillEntryInfo entry = null;
        StringBuffer idWhere = new StringBuffer();
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entry = info.getEntry().get(i);
            if (i > 0) {
                idWhere.append(",");
            }
            idWhere.append("'").append(entry.getMaterial().getId().toString()).append("'");
        }
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select FID, FUseAsstAttrRelation From T_BD_Material ");
        sSQL.append("Where FID IN (").append(idWhere.toString()).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sSQL.toString());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            while (rs.next()) {
                result.put(rs.getString("FID"), rs.getBoolean("FUseAsstAttrRelation"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String storageUnitId) throws BOSException {
        String key = materialId + storageUnitId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(key, DataTypeEnum.MATERIAL_INVENTORY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u9875\u7b7e\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7684\u6570\u636e\u7f13\u5b58\u3002class-method: com.kingdee.eas.scm.cal.vrule.app.CheckCostAdjustLotAndAssistVRule.getMaterialInventoryInfo(String, String)");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isLotNumber");
        entityViewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageUnitId));
        entityViewInfo.setFilter(filter);
        MaterialInventoryCollection col = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx()).getMaterialInventoryCollection(entityViewInfo);
        if (col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_INVENTORY);
            return col.get(0);
        }
        return null;
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId, String companyId) throws BOSException {
        String key = materialId + companyId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_COMPANY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(key, DataTypeEnum.MATERIAL_COMPANY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u8d22\u52a1\u9875\u7b7e\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7684\u6570\u636e\u7f13\u5b58\u3002class-method: com.kingdee.eas.scm.cal.vrule.app.CheckCostAdjustLotAndAssistVRule.getMaterialCompanyInfo(String, String)");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("ACCOUNTTYPE");
        selector.add("ISLOT");
        selector.add("ISASSISTPROPERTY");
        entityViewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        entityViewInfo.setFilter(filter);
        MaterialCompanyInfoCollection col = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx()).getMaterialCompanyInfoCollection(entityViewInfo);
        if (col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_COMPANY);
            return col.get(0);
        }
        return null;
    }
}

