/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CloseAccountFacadeFactory;
import com.kingdee.eas.scm.cal.ExceptionBalanceReportFacadeFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.im.inv.InvCkAccountFacadeFactory;
import com.kingdee.eas.scm.im.inv.InvCkMutiAccountFacadeFactory;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CloseAccountCheckHelper {
    public static final int CHECKTYPE_BILLAUDIT = 1;
    public static final int CHECKTYPE_COSTISZERO = 2;
    public static final int CHECKTYPE_BILLVOUCHER = 3;
    public static final int CHECKTYPE_CLOSEACCOUNT = 4;
    public static final int CHECKTYPE_ACCOUNTVIEW = 5;
    public static final int SALEISSUE = 0;
    public static final int MATERIALREQ = 1;
    public static final int OTHERISSUE = 2;
    public static final int MOVEISSUE = 3;
    public static final int PURCHERIN = 4;
    public static final int MANUFACTUREIN = 5;
    public static final int OTHERIN = 6;
    public static final int MOVEIN = 7;
    public static final int INVINIT = 8;
    public static final int MOVELOCATION = 9;
    public static final int COSTADJ = 10;
    public static final int STDCOSTADJ = 11;
    public static final int CALCULATEKIND = 12;
    public static final int DECOMPOSE = 13;
    public static final int INVSTATEADJUST = 14;
    private static String NEWLINE = "\n\r";

    public static String getCheckSQL(Context ctx, Map paramMap, CompanyOrgUnitInfo companyInfo, int checkType, String tempCheckDataTableName, String locale) throws BOSException {
        Boolean isPreCloseAccount;
        StringBuffer sqlBuffer = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)paramMap.get("period");
        int period = periodInfo.getPeriodNumber();
        int year = periodInfo.getPeriodYear();
        String companyID = companyInfo.getId().toString();
        String whereOpt = "";
        ArrayList listTableNames = (ArrayList)paramMap.get("listTableNames");
        ArrayList listEntryTableNames = (ArrayList)paramMap.get("listEntryTableNames");
        int recount = listTableNames.size();
        if (checkType == 4) {
            recount -= 3;
        }
        if ((isPreCloseAccount = (Boolean)paramMap.get("isPreCloseAccount")) == null) {
            isPreCloseAccount = Boolean.FALSE;
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" insert into ").append(tempCheckDataTableName).append("(FBillType,FBizOrTransName,FBillNumber,FBillID,FSumAmount)");
        for (int i = 0; i < recount; ++i) {
            if (checkType == 3 && (i == 8 || i == 12 || i == 13 || i == 14) || checkType == 2 && (i == 11 || i == 12 || i == 13 || i == 14) || checkType == 5 && i > 7 && i != 10) continue;
            if (sqlBuffer.length() > 0) {
                sqlBuffer.append(";");
            }
            sqlBuffer.append(insertSQL).append(NEWLINE);
            String entryTable = listEntryTableNames.get(i).toString();
            if (i == 11) {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FNewStandardAmount) as sumAmount   FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            } else if (i == 12) {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FAdjAftActualAmount) as sumAmount  FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            } else if (i == 8 || i == 10) {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FAmount) as sumAmount              FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            } else {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FActualCost) as sumAmount          FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            }
            sqlBuffer.append(" ON A.FID = B.FParentID");
            if (i == 11 || i == 10 || i == 12 || i == 13 || i == 14) {
                sqlBuffer.append(" INNER JOIN T_SCM_BillType D ON A.FBillTypeID = D.FID");
            } else if (i == 7 || i == 3) {
                sqlBuffer.append(" INNER JOIN T_SCM_TransactionType C ON A.FTransactionTypeID = C.FID");
                if (3 == checkType) {
                    sqlBuffer.append(" AND C.FISMANUCHECKACCOUNT = 1 ");
                }
                sqlBuffer.append(" INNER JOIN T_IM_InvUpdateType F ON B.FInvUpdateTypeID = F.FID");
                sqlBuffer.append(" INNER JOIN T_SCM_BillType D ON A.FBillTypeID = D.FID");
                sqlBuffer.append(" INNER JOIN T_SCM_BizType E ON A.FBizTypeID = E.FID");
            } else {
                sqlBuffer.append(" INNER JOIN T_SCM_TransactionType C ON A.FTransactionTypeID = C.FID");
                if (3 == checkType) {
                    sqlBuffer.append(" AND C.FISMANUCHECKACCOUNT = 1 ");
                }
                sqlBuffer.append(" INNER JOIN T_IM_InvUpdateType F ON B.FInvUpdateTypeID = F.FID");
                sqlBuffer.append(" INNER JOIN T_SCM_BillType D ON A.FBillTypeID = D.FID");
            }
            if (i == 11 || i == 12) {
                sqlBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyID + "'");
            } else {
                sqlBuffer.append(" AND B.FCompanyOrgUnitID = '" + companyID + "'");
            }
            sqlBuffer.append(" inner join t_bd_material MATERIAL on MATERIAL.fid = B.fmaterialid ");
            sqlBuffer.append(" inner join T_BD_MATERIALCOMPANYINFO MC on MC.fmaterialid = MATERIAL.fid ");
            if (i == 0 || i == 4) {
                sqlBuffer.append(" INNER JOIN T_ORG_UNITRELATION Relation ON A.FSTORAGEORGUNITID = Relation.FFROMUNITID ");
            }
            sqlBuffer.append(" WHERE A.FPeriod = " + period);
            sqlBuffer.append(" AND A.FYear = " + year);
            if (i == 0 || i == 4) {
                sqlBuffer.append(" AND Relation.FTOUNITID = '" + companyID + "' ");
                sqlBuffer.append(" AND Relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5' ");
            }
            if (checkType == 5 && i < 7) {
                sqlBuffer.append(" AND ((F.FExistingQty > 0 AND B.FAccountViewInId is null) or F.FExistingQty <= 0) ");
                sqlBuffer.append(" AND ((F.FExistingQtyPre > 0 AND B.FAccountViewOutId is null) or F.FExistingQtyPre <= 0) ");
            }
            if (checkType == 5 && i == 10) {
                sqlBuffer.append(" AND ( (A.FCalculateKind = 0 and B.FAccountViewInId is null) or (A.FCalculateKind = 1 and B.FAccountVIewOutId is null) )");
            }
            if (checkType == 3 && i <= 7) {
                sqlBuffer.append(" AND C.FIsManuCheckAccount = 1");
            }
            if ((checkType == 3 || checkType == 2) && i <= 7) {
                sqlBuffer.append(" AND (A.FIsInitBill <> 1 OR  A.FIsInitBill IS NULL)");
            }
            if (checkType == 3 && (i == 7 || i == 3) && paramMap.get("IsCheckCostbill").toString().equalsIgnoreCase("false")) {
                sqlBuffer.append(" AND E.FID NOT IN ");
                sqlBuffer.append("('");
                sqlBuffer.append("d8e80652-011a-1000-e000-04c5c0a812202407435C");
                sqlBuffer.append("','");
                sqlBuffer.append("YJN9V65PSkutQxeUH6F72SQHQ1w=");
                sqlBuffer.append("','");
                sqlBuffer.append("d8e80652-011b-1000-e000-04c5c0a812202407435C')");
            }
            if (i == 4 && checkType == 3 && paramMap.get("isCheckVoucher").equals("1")) {
                sqlBuffer.append(" AND B.FUNWRITEOFFBASEQTY <> 0 ");
            }
            if (checkType == 3 && (i == 0 || i == 2 || i == 1)) {
                sqlBuffer.append(" AND F.FSTORETYPEPREID <> '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' ");
            }
            if (checkType == 1 || checkType == 4) {
                sqlBuffer.append(" AND A.FBaseStatus = 2");
                if (isPreCloseAccount.booleanValue()) {
                    CloseAccountCheckHelper.setConditionWhere(sqlBuffer, paramMap, entryTable);
                }
                sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + locale + ",A.FNumber,A.FID");
                continue;
            }
            if (checkType == 2) {
                sqlBuffer.append(" AND A.FBaseStatus <> 3");
                if (i != 11 && i != 8) {
                    sqlBuffer.append(" AND B.FIsPresent = 0");
                    if (i != 11 && i != 10) {
                        sqlBuffer.append(" AND C.FIsCalculate=1");
                    }
                }
                if (isPreCloseAccount.booleanValue()) {
                    CloseAccountCheckHelper.setConditionWhere(sqlBuffer, paramMap, entryTable);
                }
                sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + locale + ",A.FNumber,A.FID");
                if (i == 8 || i == 10) {
                    sqlBuffer.append(" HAVING SUM(B.FAmount) = 0");
                    continue;
                }
                sqlBuffer.append(" HAVING SUM(B.FActualCost) = 0");
                continue;
            }
            if (checkType == 3) {
                sqlBuffer.append(" AND A.FBaseStatus = 4");
                sqlBuffer.append(" AND (A.FFiVouchered IS NULL OR A.FFiVouchered = 0)");
                if (i != 11 && i != 10) {
                    sqlBuffer.append(" AND C.FIsCalculate=1");
                }
                if (isPreCloseAccount.booleanValue()) {
                    CloseAccountCheckHelper.setConditionWhere(sqlBuffer, paramMap, entryTable);
                }
                sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + locale + ",A.FNumber,A.FID");
                continue;
            }
            if (checkType != 5) continue;
            sqlBuffer.append(" AND A.FBaseStatus = 4");
            sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + locale + ",A.FNumber,A.FID");
        }
        whereOpt = sqlBuffer.toString().replaceAll("ENTRY.F", "B.F");
        String[] sqls = whereOpt.toString().split(";");
        KsqlUtil.execute((Context)ctx, (String[])sqls);
        sqlBuffer = new StringBuffer();
        if (checkType == 3) {
            sqlBuffer.append(" SELECT * FROM ").append(tempCheckDataTableName);
            if (paramMap.get("IsCheckZeroCostbill").toString().equalsIgnoreCase("false") && !paramMap.get("isCheckVoucher").equals("2")) {
                sqlBuffer.append(" Where isnull(FSumAmount,0) <> 0");
            }
        } else {
            sqlBuffer.append(" SELECT * FROM ").append(tempCheckDataTableName);
        }
        return sqlBuffer.toString();
    }

    public static String checkCostMoveBillBalance(Context ctx, Map paramMap, CompanyOrgUnitInfo companyInfo, String tempCostMoveTable) throws BOSException {
        tempCostMoveTable = DBUtil.createTempTable((Context)ctx, (String)"", (String[][])CloseAccountCheckHelper.getCostMoveTableField());
        DBUtil.createTempTableIndex((Context)ctx, (String)tempCostMoveTable, (String)"FTRANSBILLENTRYID", (boolean)false);
        PeriodInfo curPeriod = (PeriodInfo)paramMap.get("period");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(CloseAccountCheckHelper.getInsertSql(tempCostMoveTable)).append(CloseAccountCheckHelper.getIssueSelectSql()).append(CloseAccountCheckHelper.getCommonCondition(curPeriod, companyInfo, true));
        DBUtil.execute((Context)ctx, (String)insertSql.toString());
        insertSql.setLength(0);
        insertSql.append(CloseAccountCheckHelper.getInsertSql(tempCostMoveTable)).append(CloseAccountCheckHelper.getInWarehsSelectSql()).append(CloseAccountCheckHelper.getCommonCondition(curPeriod, companyInfo, true)).append(CloseAccountCheckHelper.getExtCondition());
        DBUtil.execute((Context)ctx, (String)insertSql.toString());
        insertSql.setLength(0);
        insertSql.append(CloseAccountCheckHelper.getInsertSql(tempCostMoveTable)).append(CloseAccountCheckHelper.getIssueSelectSql());
        insertSql.append(" inner join (select distinct FTRANSBILLENTRYID from ").append(tempCostMoveTable).append(" )temp on temp.FTRANSBILLENTRYID = ENTRY.FSTOCKTRANSBILLENTRYID ");
        insertSql.append(CloseAccountCheckHelper.getCommonCondition(curPeriod, companyInfo, false));
        DBUtil.execute((Context)ctx, (String)insertSql.toString());
        insertSql.setLength(0);
        insertSql.append(CloseAccountCheckHelper.getInsertSql(tempCostMoveTable)).append(CloseAccountCheckHelper.getInWarehsSelectSql());
        insertSql.append(" inner join (select distinct FTRANSBILLENTRYID from ").append(tempCostMoveTable).append(" )temp on temp.FTRANSBILLENTRYID = ENTRY.FSTOCKTRANSBILLENTRYID ");
        insertSql.append(CloseAccountCheckHelper.getCommonCondition(curPeriod, companyInfo, false));
        DBUtil.execute((Context)ctx, (String)insertSql.toString());
        StringBuffer checkBalanceSql = new StringBuffer();
        checkBalanceSql.append("SELECT FBILLNUMBER,FMATERIALNUMBER FROM (");
        checkBalanceSql.append(" SELECT FTRANSBILLENTRYID,FBILLNUMBER,FMATERIALNUMBER,FCLOSEPERIOD,FBASESTATUS,SUM(ISSUECOST) ISSUECOST,SUM(ISSUEQTY) ISSUEQTY,SUM(INCOST) INCOST,SUM(INQTY) INQTY FROM ");
        checkBalanceSql.append(tempCostMoveTable).append(" GROUP BY FTRANSBILLENTRYID,FBILLNUMBER,FMATERIALNUMBER,FCLOSEPERIOD,FBASESTATUS ) AS TEMP");
        checkBalanceSql.append(" WHERE (ISSUEQTY = INQTY OR (FBASESTATUS = 7 AND FCLOSEPERIOD <= ").append(curPeriod.getNumber()).append(")) AND ISSUECOST <> INCOST");
        checkBalanceSql.append(" OR (ISSUEQTY < INQTY) ");
        return checkBalanceSql.toString();
    }

    private static StringBuffer getInsertSql(String tempCostMoveTable) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(tempCostMoveTable);
        insertSql.append(" (FTRANSBILLENTRYID, FBILLNUMBER, FMATERIALNUMBER, FCLOSEPERIOD, FBASESTATUS, ISSUECOST, ISSUEQTY, INCOST, INQTY)").append("\n");
        return insertSql;
    }

    private static StringBuffer getIssueSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TRANSENTRY.FID FTRANSBILLENTRYID,TRANSBILL.FNUMBER FBILLNUMBER ,M.FNUMBER FMATERIALNUMBER,TRANSENTRY.FCLOSEPERIOD,TRANSENTRY.FBASESTATUS,").append("\n");
        sql.append(" ENTRY.FACTUALCOST ISSUECOST,ENTRY.FQTY ISSUEQTY,0 as INCOST,0 AS INQTY").append("\n");
        sql.append(" FROM T_IM_MOVEISSUEBILL BILL INNER JOIN T_IM_MOVEISSUEBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID").append("\n");
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID").append("\n");
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypePreID = StoreType.FID").append("\n");
        sql.append(" INNER JOIN T_IM_STOCKTRANSFERBILLENTRY TRANSENTRY ON TRANSENTRY.FID = ENTRY.FSTOCKTRANSBILLENTRYID").append("\n");
        sql.append(" INNER JOIN T_IM_STOCKTRANSFERBILL TRANSBILL ON TRANSENTRY.FPARENTID = TRANSBILL.FID").append("\n");
        sql.append(" INNER JOIN T_BD_MATERIAL M ON M.FID = TRANSENTRY.FMATERIALID").append("\n");
        return sql;
    }

    private static StringBuffer getInWarehsSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TRANSENTRY.FID FTRANSBILLENTRYID,TRANSBILL.FNUMBER FBILLNUMBER ,M.FNUMBER FMATERIALNUMBER,TRANSENTRY.FCLOSEPERIOD,TRANSENTRY.FBASESTATUS,").append("\n");
        sql.append(" 0 AS ISSUECOST,0 AS ISSUEQTY,ENTRY.FACTUALCOST AS INCOST,ENTRY.FQTY AS INQTY").append("\n");
        sql.append(" FROM T_IM_MOVEINWAREHSBILL BILL INNER JOIN T_IM_MOVEINWAREHSBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID").append("\n");
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID").append("\n");
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypeID = StoreType.FID").append("\n");
        sql.append(" INNER JOIN T_IM_STOCKTRANSFERBILLENTRY TRANSENTRY ON TRANSENTRY.FID = ENTRY.FSTOCKTRANSBILLENTRYID").append("\n");
        sql.append(" INNER JOIN T_IM_STOCKTRANSFERBILL TRANSBILL ON TRANSENTRY.FPARENTID = TRANSBILL.FID").append("\n");
        sql.append(" INNER JOIN T_BD_MATERIAL M ON M.FID = TRANSENTRY.FMATERIALID").append("\n");
        return sql;
    }

    private static StringBuffer getCommonCondition(PeriodInfo curPeriod, CompanyOrgUnitInfo companyInfo, boolean isQueryCurrPeriod) {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" WHERE BILL.FBaseStatus = 4 AND ISNULL(BILL.FIsInitBill, 0) = 0").append("\n");
        if (isQueryCurrPeriod) {
            whereSql.append(" AND (BILL.FBIZDATE >=TO_DATE('").append(curPeriod.getBeginDate()).append("') AND BILL.FBIZDATE <=TO_DATE('").append(curPeriod.getEndDate()).append("'))").append("\n");
            whereSql.append(" AND (ENTRY.FBIZDATE >=TO_DATE('").append(curPeriod.getBeginDate()).append("') AND ENTRY.FBIZDATE <=TO_DATE('").append(curPeriod.getEndDate()).append("'))").append("\n");
        } else {
            whereSql.append(" AND BILL.FBIZDATE <TO_DATE('").append(curPeriod.getBeginDate()).append("')").append("\n");
            whereSql.append(" AND ENTRY.FBIZDATE <TO_DATE('").append(curPeriod.getBeginDate()).append("')").append("\n");
        }
        whereSql.append(" AND StoreType.FIsForwardAmt = 1 AND ENTRY.FCompanyOrgUnitId = '").append(companyInfo.getId().toString()).append("'").append("\n");
        whereSql.append(" AND Bill.FBizTypeID IN (");
        whereSql.append("'").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        whereSql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        whereSql.append(")").append("\n");
        return whereSql;
    }

    private static StringBuffer getExtCondition() {
        StringBuffer extSql = new StringBuffer();
        extSql.append(" and bill.FBizTypeID not in  (");
        extSql.append("'").append("i6DbShN4SLaNlFkX90UXOiQHQ1w=").append("' ,");
        extSql.append("'").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ,");
        extSql.append("'").append("YJN9V65PSkutQxeUH6F72SQHQ1w=").append("')");
        return extSql;
    }

    private static String[][] getCostMoveTableField() {
        String[][] fields = new String[][]{{"FTRANSBILLENTRYID", "VARCHAR(44)"}, {"FBILLNUMBER", "NVARCHAR(80)"}, {"FMATERIALNUMBER", "NVARCHAR(80)"}, {"FCLOSEPERIOD", "INT"}, {"FBASESTATUS", "INT"}, {"ISSUECOST", "NUMERIC(17,4)"}, {"ISSUEQTY", "NUMERIC(28,16)"}, {"INCOST", "NUMERIC(17,4)"}, {"INQTY", "NUMERIC(28,16)"}};
        return fields;
    }

    public static String checkInvckAccount(Context ctx, CompanyOrgUnitInfo currCompany, PeriodInfo currentPeriodInfo, boolean isUseMutiCk, boolean noSelectWarehouseMoveBill, boolean noSelectStorageMoveBill) throws BOSException, EASBizException {
        RptParams rptParam = new RptParams();
        rptParam.setObject("bizCompnayOrg", (Object)currCompany);
        if (currentPeriodInfo == null) {
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currCompany);
        }
        rptParam.setObject("spnYearFrom", (Object)currentPeriodInfo.getPeriodYear());
        rptParam.setObject("spnPeriodFrom", (Object)currentPeriodInfo.getPeriodNumber());
        rptParam.setObject("spnYearTo", (Object)currentPeriodInfo.getPeriodYear());
        rptParam.setObject("spnPeriodTo", (Object)currentPeriodInfo.getPeriodNumber());
        rptParam.setObject("ckShowNoCalculate", (Object)false);
        rptParam.setObject("noSelectMovebill", (Object)false);
        rptParam.setObject("noSelectStorageMoveBill", (Object)noSelectStorageMoveBill);
        rptParam.setObject("noSelectWarehouseMoveBill", (Object)noSelectWarehouseMoveBill);
        Object iRptBase = null;
        iRptBase = isUseMutiCk ? InvCkMutiAccountFacadeFactory.getLocalInstance((Context)ctx) : InvCkAccountFacadeFactory.getLocalInstance((Context)ctx);
        RptParams tempInvckResult = iRptBase.createTempTable(rptParam);
        return tempInvckResult.getString("tempTable");
    }

    public static String checkPeriodEndBalanceException(Context ctx, CompanyOrgUnitInfo currCompany, PeriodInfo currentPeriodInfo) throws EASBizException, BOSException {
        RptParams rptParam = new RptParams();
        rptParam.setString("COMPANY_ID", currCompany.getId().toString());
        rptParam.setString("COMPANY_NAME", currCompany.getName());
        if (currentPeriodInfo == null) {
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currCompany);
        }
        rptParam.setInt("YEAR_FROM", currentPeriodInfo.getPeriodYear());
        rptParam.setInt("PERIOD_FROM", currentPeriodInfo.getPeriodNumber());
        rptParam.setInt("YEAR_TO", currentPeriodInfo.getPeriodYear());
        rptParam.setInt("PERIOD_TO", currentPeriodInfo.getPeriodNumber());
        rptParam.setInt("calcType", 0);
        rptParam.setInt("cbQty", 0);
        rptParam.setInt("cbAmount", 0);
        ObjectUuidPK pk = new ObjectUuidPK(currCompany.getBOSUuid("id"));
        String paramValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "SCM_CAL_026");
        rptParam.setInt("sumType", Integer.parseInt(paramValue));
        rptParam.setBoolean("isPreCloseAccount", true);
        RptParams preCloseParams = new RptParams();
        preCloseParams.setBoolean("isPreCloseAccount", true);
        preCloseParams.setInt("YEAR_FROM", currentPeriodInfo.getPeriodYear());
        preCloseParams.setInt("PERIOD_FROM", currentPeriodInfo.getPeriodNumber());
        preCloseParams.setInt("YEAR_TO", currentPeriodInfo.getPeriodYear());
        preCloseParams.setInt("PERIOD_TO", currentPeriodInfo.getPeriodNumber());
        HashMap<String, Object> preCloseMap = new HashMap<String, Object>();
        preCloseMap.put("IsCheckCostbill", "false");
        preCloseMap.put("isPreCloseAccount", new Boolean(true));
        preCloseMap.put("period", currentPeriodInfo);
        preCloseMap.put("calculateParams", rptParam);
        CloseAccountFacadeFactory.getLocalInstance((Context)ctx).closeAccount(currCompany, preCloseMap);
        RptParams tempPeriodEndResult = ExceptionBalanceReportFacadeFactory.getLocalInstance((Context)ctx).createTempTable(rptParam);
        return tempPeriodEndResult.getString("tempTable");
    }

    private static void setConditionWhere(StringBuffer sql, Map param, String entryTable) {
        RptParams pp = (RptParams)param.get("calculateParams");
        if (pp == null) {
            return;
        }
        if (pp.getString("MATERIAL_FROM") != null && pp.getString("MATERIAL_FROM").length() != 0) {
            sql.append(" and MATERIAL.FNumber >= '").append(pp.getString("MATERIAL_FROM")).append("'");
        }
        if (pp.getString("MATERIAL_TO") != null && pp.getString("MATERIAL_TO").length() != 0) {
            sql.append(" and MATERIAL.FNumber <= '").append(pp.getString("MATERIAL_TO")).append("'");
        }
        if (!("T_CL_CostAdjustBillEntry".equals(entryTable) || "T_CL_StandardCostAdjEntry".equals(entryTable) || "T_CL_CalculateKindRefactEntry".equals(entryTable))) {
            int i;
            if (pp.getObject("STORAGEORGUNIT") != null) {
                StringBuffer inStorages = new StringBuffer(" and ENTRY.FSTORAGEORGUNITID in ('");
                Object[] storages = (Object[])pp.getObject("STORAGEORGUNIT");
                for (i = 0; i < storages.length; ++i) {
                    StorageOrgUnitInfo storage = (StorageOrgUnitInfo)storages[i];
                    inStorages.append(storage.getId().toString()).append("','");
                }
                inStorages.setLength(inStorages.length() - 2);
                inStorages.append(") ");
                sql.append(inStorages.toString());
            }
            if (pp.getObject("WAREHOUSE") != null) {
                StringBuffer inWarehs = new StringBuffer(" and ENTRY.FWAREHOUSEID in ('");
                Object[] warehouses = (Object[])pp.getObject("WAREHOUSE");
                for (i = 0; i < warehouses.length; ++i) {
                    WarehouseInfo warehs = (WarehouseInfo)warehouses[i];
                    inWarehs.append(warehs.getId().toString()).append("','");
                }
                inWarehs.setLength(inWarehs.length() - 2);
                inWarehs.append(") ");
                sql.append(inWarehs.toString());
            }
        }
        if (pp.getBoolean("isPreCloseAccount") && pp.getInt("calcType") != 0) {
            sql.append(" and MC.FCALCULATETYPE = " + (pp.getInt("calcType") - 1));
        }
        if (pp.getBoolean("isPreCloseAccount")) {
            sql.append(" and MC.FACCOUNTTYPE<>1");
        }
    }
}

