/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.BizCLOSEACCOUNTException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.AbstractCloseAccountProcessor;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.CloseAccountCheckHelper;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class CloseAccountCheckProcessor
extends AbstractCloseAccountProcessor {
    private static final long serialVersionUID = 1L;
    public static final int CHECKTYPE_BILLAUDIT = 1;
    public static final int CHECKTYPE_COSTISZERO = 2;
    public static final int CHECKTYPE_BILLVOUCHER = 3;
    public static final int CHECKTYPE_CLOSEACCOUNT = 4;
    public static final int CHECKTYPE_ACCOUNTVIEW = 5;
    public static final String UNIONOPT = " UNION ALL ";
    public static final String NEWLINE = "\r\n";
    private String locale;
    private String tempCheckDataTableName = "CheckDataTempTable";
    private String tempCheckPrecisonTable = "CheckPrecisonTable";

    public CloseAccountCheckProcessor(ProcessorConstructParam param) {
        super(param);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (OperationTypeEnum.Positive.equals((Object)this.OPType)) {
            this.closeAccountCheck();
        } else {
            this.reverseCloseAccountCheck();
        }
    }

    protected void closeAccountCheck() throws BOSException, EASBizException {
        block21: {
            if (!SystemStatusCtrolUtils.isStart((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo)) {
                throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.SCMNOTSTART);
            }
            this.locale = this.getLocale(this.ctx);
            String msg = "";
            Object[] msgs = new String[1];
            boolean isPreCloseAccount = false;
            if (this.paramMap.get("isPreCloseAccount") != null) {
                isPreCloseAccount = (Boolean)this.paramMap.get("isPreCloseAccount");
            }
            Boolean isNotCheckStatus = false;
            isNotCheckStatus = CalculateUtil.getCostCalculateParam((Context)this.ctx, (String)this.companyInfo.getId().toString(), (String)"SCM_CAL_032");
            if (!isPreCloseAccount || !isNotCheckStatus.booleanValue() && isPreCloseAccount) {
                msg = this.exeVaildSQL(this.ctx, this.paramMap, this.companyInfo, 1);
            }
            if (msg.length() > 0) {
                msgs[0] = msg;
                throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.BILLHASNOAUDIT, msgs);
            }
            if (!this.paramMap.get("isCheckVoucher").toString().equals("0") && !isPreCloseAccount && (msg = this.exeVaildSQL(this.ctx, this.paramMap, this.companyInfo, 3)).length() > 0) {
                msgs[0] = msg;
                throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.BILLHASVOUCHER, msgs);
            }
            if (this.getDtTempParamValue(this.ctx, "isCheckAmtPrecision").booleanValue() && (msg = this.getPrecisonCheckMsg()).length() > 0) {
                msgs[0] = msg;
                throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.BILLPRECISIONERROR, msgs);
            }
            if (this.paramMap.get("isCheckCostMoveBalance").toString().equals("1")) {
                String tempCostMoveTable = null;
                String checkBalanceSql = CloseAccountCheckHelper.checkCostMoveBillBalance(this.ctx, this.paramMap, this.companyInfo, tempCostMoveTable);
                IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)checkBalanceSql.toString());
                StringBuffer exceptionBill = new StringBuffer();
                try {
                    while (rs.next()) {
                        exceptionBill.append(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"closeAccountCostMoveTip", (Object[])new String[]{rs.getString("FBILLNUMBER"), rs.getString("FMATERIALNUMBER")})).append(" \n");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    DBUtil.releaseTempTable((Context)this.ctx, tempCostMoveTable);
                }
                if (exceptionBill.length() > 0) {
                    msgs[0] = "\n" + exceptionBill;
                    throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.COSTMOVENOTBALANCE, msgs);
                }
            }
            if (!this.paramMap.get("isExceBalPermitCloseAccount").toString().equals("1") || isPreCloseAccount) break block21;
            String tempTable = null;
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
            StringBuffer exceptionBill = new StringBuffer();
            try {
                tempTable = CloseAccountCheckHelper.checkPeriodEndBalanceException(this.ctx, this.companyInfo, currentPeriodInfo);
                String checkSql = "select count(1) c from " + tempTable;
                IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)checkSql);
                while (rs.next()) {
                    if (rs.getInt("c") <= 0) continue;
                    exceptionBill.append(EASResource.getString((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"CHECK_BAL_EXCEPTION_TIPS"));
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.releaseTempTable((Context)this.ctx, tempTable);
                    throw throwable;
                }
            }
            DBUtil.releaseTempTable((Context)this.ctx, (String)tempTable);
            if (exceptionBill.length() > 0) {
                msgs[0] = "\n" + exceptionBill;
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, msgs);
            }
        }
    }

    private String getPrecisonCheckMsg() throws BOSException, EASBizException {
        String createSQL = SysTempTableHelper.getCreateSQl((String[][])CloseAccountCheckProcessor.getTempCheckPrecisionNameFields());
        this.tempCheckPrecisonTable = KsqlUtil.createTempTable((Context)this.ctx, (String)createSQL);
        String sql = this.getCheckPrecisionSQL(this.ctx, this.paramMap, this.companyInfo);
        ResultSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        StringBuffer msg = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                msg.append("\n ");
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"BillPrecisionInfo", (Locale)this.ctx.getLocale(), (Object[])new Object[]{rs.getString("FBizOrTransName"), rs.getString("FBillNumber"), rs.getInt("Fseq"), rs.getString("FField")}));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)this.ctx, (String)this.tempCheckPrecisonTable);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)this.ctx, (String)this.tempCheckPrecisonTable);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return msg.toString();
    }

    protected void reverseCloseAccountCheck() throws BOSException, EASBizException {
        PeriodInfo curPeriod = (PeriodInfo)this.paramMap.get("period");
        this.locale = this.getLocale(this.ctx);
        this.checkSystemStatus(this.ctx, this.companyInfo, curPeriod);
        boolean isDelCostAdjBill = this.paramMap.get("isDelCostAdjBill").toString().equalsIgnoreCase("true");
        if (isDelCostAdjBill) {
            CloseAccountCheckProcessor.isExistExpAdjZeroCostAdjBill(this.ctx, this.companyInfo, curPeriod, CostAdjuestCreateTypeEnum.PeriodBeginExpBalanceAjdust);
            this.deleteCostAdjust(this.ctx, this.companyInfo, curPeriod, CostAdjuestCreateTypeEnum.PeriodBeginExpBalanceAjdust);
        }
        this.checkWarehouseStartedPeriod(this.ctx, this.companyInfo, curPeriod);
        this.checkIsExistAuditStandardCostAdjBill(this.ctx, this.companyInfo, curPeriod);
    }

    private String exeVaildSQL(Context ctx, Map paramMap, CompanyOrgUnitInfo companyInfo, int checkType) throws EASBizException, BOSException {
        String string;
        ResultSet rs = null;
        String msg = "";
        Connection conn = null;
        Statement stmt = null;
        try {
            String createSQL = SysTempTableHelper.getCreateSQl((String[][])CloseAccountCheckProcessor.getTempCheckDataNameFields());
            this.tempCheckDataTableName = KsqlUtil.createTempTable((Context)ctx, (String)createSQL);
            String sql = CloseAccountCheckHelper.getCheckSQL(ctx, paramMap, companyInfo, checkType, this.tempCheckDataTableName, this.locale);
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                String billType = rs.getString("FBillType");
                if (checkType == 3 && this.checkEntryIsPresent(ctx, billType, rs.getString("FBillID"))) continue;
                if (billType != null && billType.trim().equals("104")) {
                    msg = msg + "\n" + ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"239_MaterialReqBillOrSubBill", (Locale)ctx.getLocale()) + ": " + rs.getString("FBillNumber");
                    continue;
                }
                if (billType != null && billType.trim().equals("103")) {
                    msg = msg + "\n" + ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"238_PurBillOrSubBill", (Locale)ctx.getLocale()) + ": " + rs.getString("FBillNumber");
                    continue;
                }
                msg = msg + "\n" + rs.getString("FBizOrTransName") + ": " + rs.getString("FBillNumber");
            }
            string = msg;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)ctx, (String)this.tempCheckDataTableName);
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)this.tempCheckDataTableName);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return string;
    }

    private boolean checkEntryIsPresent(Context ctx, String billType, String billID) throws EASBizException, BOSException {
        IRowSet rs = null;
        StringBuffer stringBuffer = new StringBuffer();
        String entryTableName = null;
        if (billType.equals("102")) {
            entryTableName = "T_IM_SaleIssueEntry";
        } else if (billType.equals("103")) {
            entryTableName = "T_IM_PurInWarehsEntry";
        } else if (billType.equals("420")) {
            entryTableName = "T_CL_StandardCostAdjEntry";
        } else {
            return false;
        }
        stringBuffer.append(" SELECT COUNT(FID) AS RECS");
        stringBuffer.append(" FROM " + entryTableName);
        stringBuffer.append(" WHERE FParentID = '" + billID + "'");
        if (billType.equals("102") || billType.equals("103")) {
            stringBuffer.append(" AND FIsPresent <> 1");
        } else if (billType.equals("420")) {
            stringBuffer.append(" AND FDiffAmount <> 0");
        }
        try {
            String sqlStr = stringBuffer.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            if (rs.next() && rs.getInt("RECS") > 0) {
                return false;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return true;
    }

    private String getCheckPrecisionSQL(Context ctx, Map paramMap, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo periodInfo = (PeriodInfo)paramMap.get("period");
        int period = periodInfo.getPeriodNumber();
        int year = periodInfo.getPeriodYear();
        String companyID = companyInfo.getId().toString();
        CurrencyInfo currencyInfo = null;
        if (companyInfo.getBaseCurrency() != null && companyInfo.getBaseCurrency().getId() != null) {
            SelectorItemCollection sics = new SelectorItemCollection();
            sics.add(new SelectorItemInfo("precision"));
            sics.add(new SelectorItemInfo("id"));
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()), sics);
        }
        int baseCurrencyPrecision = currencyInfo.getPrecision();
        ArrayList listTableNames = (ArrayList)paramMap.get("listTableNames");
        ArrayList listEntryTableNames = (ArrayList)paramMap.get("listEntryTableNames");
        int recount = listTableNames.size();
        for (int i = 0; i < recount; ++i) {
            String sql;
            String headTable = listTableNames.get(i).toString();
            String entryTable = listEntryTableNames.get(i).toString();
            if (4 == i) {
                sql = this.getFormatSql(headTable, entryTable, companyID, year, period, baseCurrencyPrecision, "FPURCHASECOST", false);
                KsqlUtil.execute((Context)ctx, (String)sql);
                sql = this.getFormatSql(headTable, entryTable, companyID, year, period, baseCurrencyPrecision, "FACTUALCOST", false);
                KsqlUtil.execute((Context)ctx, (String)sql);
                sql = this.getFormatSql(headTable, entryTable, companyID, year, period, baseCurrencyPrecision, "FAMOUNT", true);
                KsqlUtil.execute((Context)ctx, (String)sql);
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append(" UPDATE T_IM_PURINWAREHSENTRY SET FLOCALAMOUNT = ");
                sqlBuffer.append(" ROUND(FLOCALAMOUNT," + baseCurrencyPrecision + ") \n");
                sqlBuffer.append(" WHERE FID IN ( \n");
                sqlBuffer.append(" SELECT B.FID ");
                sqlBuffer.append(" FROM T_IM_PURINWAREHSBILL A \n");
                sqlBuffer.append(" INNER JOIN T_IM_PURINWAREHSENTRY B ON A.FID = B.FPARENTID \n");
                sqlBuffer.append(" WHERE A.FBASESTATUS = 4 AND A.FYEAR = " + year + " AND A.FPERIOD = " + period + " \n");
                sqlBuffer.append(" AND B.FCOMPANYORGUNITID = '" + companyID + "' \n");
                sqlBuffer.append(" AND DECIMAL(B.FLOCALAMOUNT * POWER(10," + baseCurrencyPrecision + " ),21,4)%1 <> 0 \n");
                sqlBuffer.append(" )");
                KsqlUtil.execute((Context)ctx, (String)sqlBuffer.toString());
            }
            if (0 == i || 5 == i || 1 == i || 7 == i || 3 == i || 6 == i || 2 == i) {
                sql = this.getFormatSql(headTable, entryTable, companyID, year, period, baseCurrencyPrecision, "FACTUALCOST", false);
                KsqlUtil.execute((Context)ctx, (String)sql);
            }
            if (10 != i) continue;
            sql = this.getFormatSql(headTable, entryTable, companyID, year, period, baseCurrencyPrecision, "FAMOUNT", false);
            KsqlUtil.execute((Context)ctx, (String)sql);
            sql = this.getFormatSql(headTable, entryTable, companyID, year, period, baseCurrencyPrecision, "FACTUALCOST", false);
            KsqlUtil.execute((Context)ctx, (String)sql);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT FBillType,FBizOrTransName,FBillNumber,FBillID,Fseq,FField FROM ").append(this.tempCheckPrecisonTable);
        return sqlBuffer.toString();
    }

    private String getFormatSql(String table, String entryTable, String companyID, int year, int period, int baseCurrPrecision, String field, boolean joinCurr) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" INSERT INTO ").append(this.tempCheckPrecisonTable).append("(FBILLTYPE,FBIZORTRANSNAME,FBILLNUMBER,FBILLID,FSEQ,FFIELD) \n");
        sqlBuffer.append(" SELECT D.FNUMBER AS FBILLTYPE,D.FNAME_" + this.locale + " AS FBIZORTRANSNAME,A.FNUMBER AS FBILLNUMBER,A.FID AS FBILLID,B.FSEQ AS FSEQ ");
        sqlBuffer.append(" ,'" + field + "' AS FFIELD \n");
        sqlBuffer.append(" FROM " + table + " A \n INNER JOIN " + entryTable + " B");
        sqlBuffer.append(" ON A.FID = B.FPARENTID \n");
        if (joinCurr) {
            sqlBuffer.append(" INNER JOIN T_BD_CURRENCY C ON A.FCURRENCYID = C.FID \n");
        }
        sqlBuffer.append(" INNER JOIN T_SCM_BILLTYPE D ON A.FBILLTYPEID = D.FID \n");
        sqlBuffer.append(" WHERE A.FBASESTATUS = 4 AND A.FYEAR = " + year + " AND A.FPERIOD = " + period + " \n");
        sqlBuffer.append(" AND B.FCOMPANYORGUNITID = '" + companyID + "' \n");
        if (joinCurr) {
            sqlBuffer.append(" AND DECIMAL(B." + field + "*POWER(10,C.FPRECISION),21,4)%1 <> 0");
        } else {
            sqlBuffer.append(" AND DECIMAL(B." + field + "*POWER(10," + baseCurrPrecision + "),21,4)%1 <> 0");
        }
        return sqlBuffer.toString();
    }

    private String getCheckSQL(Context ctx, Map paramMap, CompanyOrgUnitInfo companyInfo, int checkType) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)paramMap.get("period");
        int period = periodInfo.getPeriodNumber();
        int year = periodInfo.getPeriodYear();
        String companyID = companyInfo.getId().toString();
        String whereOpt = "";
        ArrayList listTableNames = (ArrayList)paramMap.get("listTableNames");
        ArrayList listEntryTableNames = (ArrayList)paramMap.get("listEntryTableNames");
        int recount = listTableNames.size();
        if (checkType == 4) {
            recount -= 3;
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" insert into ").append(this.tempCheckDataTableName).append("(FBillType,FBizOrTransName,FBillNumber,FBillID,FSumAmount)");
        for (int i = 0; i < recount; ++i) {
            if (checkType == 3 && (i == 8 || i == 12) || checkType == 2 && (i == 11 || i == 12) || checkType == 5 && i > 7 && i != 10) continue;
            if (sqlBuffer.length() > 0) {
                sqlBuffer.append(";");
            }
            sqlBuffer.append(insertSQL).append(NEWLINE);
            String entryTable = listEntryTableNames.get(i).toString();
            if (i == 11) {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + this.locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FNewStandardAmount) as sumAmount   FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            } else if (i == 12) {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + this.locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FAdjAftActualAmount) as sumAmount  FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            } else if (i == 8 || i == 10) {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + this.locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FAmount) as sumAmount              FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            } else {
                sqlBuffer.append("SELECT D.FNumber AS FBillType,D.FName_" + this.locale + " AS FBizOrTransName,A.FNumber AS FBillNumber,A.FID AS FBillID,SUM(B.FActualCost) as sumAmount          FROM " + listTableNames.get(i).toString() + " A INNER JOIN " + entryTable + " B");
            }
            sqlBuffer.append(" ON A.FID = B.FParentID");
            if (i == 11 || i == 10 || i == 12) {
                sqlBuffer.append(" INNER JOIN T_SCM_BillType D ON A.FBillTypeID = D.FID");
            } else if (i == 7 || i == 3) {
                sqlBuffer.append(" INNER JOIN T_SCM_TransactionType C ON A.FTransactionTypeID = C.FID");
                if (3 == checkType) {
                    sqlBuffer.append(" AND C.FISMANUCHECKACCOUNT = 1 ");
                }
                sqlBuffer.append(" INNER JOIN T_IM_InvUpdateType F ON B.FInvUpdateTypeID = F.FID");
                sqlBuffer.append(" INNER JOIN T_SCM_BillType D ON A.FBillTypeID = D.FID");
                sqlBuffer.append(" INNER JOIN T_SCM_BizType E ON A.FBizTypeID = E.FID");
            } else {
                sqlBuffer.append(" INNER JOIN T_SCM_TransactionType C ON A.FTransactionTypeID = C.FID");
                if (3 == checkType) {
                    sqlBuffer.append(" AND C.FISMANUCHECKACCOUNT = 1 ");
                }
                sqlBuffer.append(" INNER JOIN T_IM_InvUpdateType F ON B.FInvUpdateTypeID = F.FID");
                sqlBuffer.append(" INNER JOIN T_SCM_BillType D ON A.FBillTypeID = D.FID");
            }
            if (i == 11 || i == 12) {
                sqlBuffer.append(" AND A.FCompanyOrgUnitID = '" + companyID + "'");
            } else {
                sqlBuffer.append(" AND B.FCompanyOrgUnitID = '" + companyID + "'");
            }
            sqlBuffer.append(" inner join t_bd_material MATERIAL on MATERIAL.fid = B.fmaterialid ");
            sqlBuffer.append(" inner join T_BD_MATERIALCOMPANYINFO MC on MC.fmaterialid = MATERIAL.fid ");
            if (i == 0 || i == 4) {
                sqlBuffer.append(" INNER JOIN T_ORG_UNITRELATION Relation ON A.FSTORAGEORGUNITID = Relation.FFROMUNITID ");
            }
            sqlBuffer.append(" WHERE A.FPeriod = " + period);
            sqlBuffer.append(" AND A.FYear = " + year);
            if (i == 0 || i == 4) {
                sqlBuffer.append(" AND Relation.FTOUNITID = '" + companyID + "' ");
                sqlBuffer.append(" AND Relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5' ");
            }
            if (checkType == 5 && i < 7) {
                sqlBuffer.append(" AND ((F.FExistingQty > 0 AND B.FAccountViewInId is null) or F.FExistingQty <= 0) ");
                sqlBuffer.append(" AND ((F.FExistingQtyPre > 0 AND B.FAccountViewOutId is null) or F.FExistingQtyPre <= 0) ");
            }
            if (checkType == 5 && i == 10) {
                sqlBuffer.append(" AND ( (A.FCalculateKind = 0 and B.FAccountViewInId is null) or (A.FCalculateKind = 1 and B.FAccountVIewOutId is null) )");
            }
            if (checkType == 3 && i <= 7) {
                sqlBuffer.append(" AND C.FIsManuCheckAccount = 1");
            }
            if ((checkType == 3 || checkType == 2) && i <= 7) {
                sqlBuffer.append(" AND (A.FIsInitBill <> 1 OR  A.FIsInitBill IS NULL)");
            }
            if (checkType == 3 && (i == 7 || i == 3) && paramMap.get("IsCheckCostbill").toString().equalsIgnoreCase("false")) {
                sqlBuffer.append(" AND E.FID NOT IN ");
                sqlBuffer.append("('");
                sqlBuffer.append("d8e80652-011a-1000-e000-04c5c0a812202407435C");
                sqlBuffer.append("','");
                sqlBuffer.append("d8e80652-011b-1000-e000-04c5c0a812202407435C')");
            }
            if (i == 4 && checkType == 3 && paramMap.get("isCheckVoucher").equals("1")) {
                sqlBuffer.append(" AND B.FUNWRITEOFFBASEQTY <> 0 ");
            }
            if (checkType == 1 || checkType == 4) {
                sqlBuffer.append(" AND A.FBaseStatus = 2");
                this.setConditionWhere(sqlBuffer, paramMap, entryTable);
                sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + this.locale + ",A.FNumber,A.FID");
                continue;
            }
            if (checkType == 2) {
                if (i != 11 && i != 8) {
                    sqlBuffer.append(" AND B.FIsPresent = 0");
                    if (i != 11 && i != 10) {
                        sqlBuffer.append(" AND C.FIsCalculate=1");
                    }
                }
                this.setConditionWhere(sqlBuffer, paramMap, entryTable);
                sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + this.locale + ",A.FNumber,A.FID");
                if (i == 8 || i == 10) {
                    sqlBuffer.append(" HAVING SUM(B.FAmount) = 0");
                    continue;
                }
                sqlBuffer.append(" HAVING SUM(B.FActualCost) = 0");
                continue;
            }
            if (checkType == 3) {
                sqlBuffer.append(" AND A.FBaseStatus = 4");
                sqlBuffer.append(" AND (A.FFiVouchered IS NULL OR A.FFiVouchered = 0)");
                if (i != 11 && i != 10) {
                    sqlBuffer.append(" AND C.FIsCalculate=1");
                }
                this.setConditionWhere(sqlBuffer, paramMap, entryTable);
                sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + this.locale + ",A.FNumber,A.FID");
                continue;
            }
            if (checkType != 5) continue;
            sqlBuffer.append(" AND A.FBaseStatus = 4");
            sqlBuffer.append(" GROUP BY D.FNumber,D.FName_" + this.locale + ",A.FNumber,A.FID");
        }
        whereOpt = sqlBuffer.toString().replaceAll("ENTRY.F", "B.F");
        String[] sqls = whereOpt.toString().split(";");
        KsqlUtil.execute((Context)ctx, (String[])sqls);
        sqlBuffer = new StringBuffer();
        if (checkType == 3) {
            sqlBuffer.append(" SELECT * FROM ").append(this.tempCheckDataTableName);
            if (paramMap.get("IsCheckZeroCostbill").toString().equalsIgnoreCase("false") && !paramMap.get("isCheckVoucher").equals("2")) {
                sqlBuffer.append(" Where isnull(FSumAmount,0) <> 0");
            }
        } else {
            sqlBuffer.append(" SELECT * FROM ").append(this.tempCheckDataTableName);
        }
        return sqlBuffer.toString();
    }

    private void setConditionWhere(StringBuffer sql, Map param, String entryTable) {
        RptParams pp = (RptParams)param.get("calculateParams");
        if (pp == null) {
            return;
        }
        if (pp.getString("MATERIAL_FROM") != null && pp.getString("MATERIAL_FROM").length() != 0) {
            sql.append(" and MATERIAL.FNumber >= '").append(pp.getString("MATERIAL_FROM")).append("'");
        }
        if (pp.getString("MATERIAL_TO") != null && pp.getString("MATERIAL_TO").length() != 0) {
            sql.append(" and MATERIAL.FNumber <= '").append(pp.getString("MATERIAL_TO")).append("'");
        }
        if (!("T_CL_CostAdjustBillEntry".equals(entryTable) || "T_CL_StandardCostAdjEntry".equals(entryTable) || "T_CL_CalculateKindRefactEntry".equals(entryTable))) {
            int i;
            if (pp.getObject("STORAGEORGUNIT") != null) {
                StringBuffer inStorages = new StringBuffer(" and ENTRY.FSTORAGEORGUNITID in ('");
                Object[] storages = (Object[])pp.getObject("STORAGEORGUNIT");
                for (i = 0; i < storages.length; ++i) {
                    StorageOrgUnitInfo storage = (StorageOrgUnitInfo)storages[i];
                    inStorages.append(storage.getId().toString()).append("','");
                }
                inStorages.setLength(inStorages.length() - 2);
                inStorages.append(") ");
                sql.append(inStorages.toString());
            }
            if (pp.getObject("WAREHOUSE") != null) {
                StringBuffer inWarehs = new StringBuffer(" and ENTRY.FWAREHOUSEID in ('");
                Object[] warehouses = (Object[])pp.getObject("WAREHOUSE");
                for (i = 0; i < warehouses.length; ++i) {
                    WarehouseInfo warehs = (WarehouseInfo)warehouses[i];
                    inWarehs.append(warehs.getId().toString()).append("','");
                }
                inWarehs.setLength(inWarehs.length() - 2);
                inWarehs.append(") ");
                sql.append(inWarehs.toString());
            }
        }
        if (pp.getBoolean("isPreCloseAccount") && pp.getInt("calcType") != 0) {
            sql.append(" and MC.FCALCULATETYPE = " + (pp.getInt("calcType") - 1));
        }
        if (pp.getBoolean("isPreCloseAccount")) {
            sql.append(" and MC.FACCOUNTTYPE<>1");
        }
    }

    private void checkSystemStatus(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo currPeriod) throws BOSException, EASBizException {
        if (companyInfo == null || currPeriod == null) {
            return;
        }
        boolean flag = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (!flag) {
            return;
        }
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currPeriod);
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
        if (prePeriod.getNumber() < periodInfo.getNumber()) {
            throw new CalculateException(CalculateException.PREPERIOD_LESS_GENERALLEDGER);
        }
    }

    public static boolean isExistExpAdjZeroCostAdjBill(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo currperiod, CostAdjuestCreateTypeEnum type) throws BOSException, CalculateException {
        StringBuffer filterStr = new StringBuffer();
        if (type != null) {
            filterStr.append("T1.FCreateType = ").append(type.getValue());
        }
        if (currperiod != null) {
            filterStr.append("\n AND ((T1.FYEAR > ").append(currperiod.getPeriodYear()).append(")");
            filterStr.append("\n or (T1.FYEAR = ").append(currperiod.getPeriodYear()).append(" and T1.FPERIOD > ").append(currperiod.getPeriodNumber() - 1).append("))");
        }
        if (companyInfo != null) {
            filterStr.append("\n AND T2.FCOMPANYORGUNITID = '").append(companyInfo.getId().toString()).append("'");
        }
        filterStr.append("\n AND T1.FFIVOUCHERED = 1 AND T1.FBASESTATUS = ").append(4);
        StringBuffer bufferSql = new StringBuffer();
        bufferSql.append("SELECT 1 FROM T_CL_COSTADJUSTBILL T1 ");
        bufferSql.append("\n INNER JOIN T_CL_COSTADJUSTBILLENTRY T2 ON T1.FID = T2.FPARENTID");
        bufferSql.append("\n WHERE ").append(filterStr.toString());
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)bufferSql.toString());
            if (rowSet.next()) {
                throw new CalculateException(CalculateException.PERIODBEGINEXPCOSTADJZERO_ISCLOSED);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private void deleteCostAdjust(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo currperiod, CostAdjuestCreateTypeEnum type) throws EASBizException, BOSException {
        CloseAccountCheckProcessor.deleteCostAdjustBill(ctx, companyInfo, currperiod, type);
    }

    public static boolean deleteCostAdjustBill(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo currperiod, CostAdjuestCreateTypeEnum type) throws BOSException {
        boolean success = false;
        if (companyInfo != null) {
            String[] sqls = new String[]{CloseAccountCheckProcessor.getDeleteCostAdjBillEntrySql(companyInfo, currperiod, type), CloseAccountCheckProcessor.getDeleteCostAdjBillSql(companyInfo, currperiod, type)};
            DBUtil.execute((Context)ctx, (String[])sqls);
            success = true;
        }
        return success;
    }

    public static String getDeleteCostAdjBillEntrySql(CompanyOrgUnitInfo companyInfo, PeriodInfo currperiod, CostAdjuestCreateTypeEnum type) {
        StringBuffer bufferSql = new StringBuffer();
        bufferSql.append("DELETE FROM T_CL_COSTADJUSTBILLENTRY ");
        bufferSql.append("\n WHERE  EXISTS ( ");
        bufferSql.append("\n SELECT T2.FID  FROM T_CL_COSTADJUSTBILL T2,T_CL_COSTADJUSTBILLENTRY T1 WHERE T2.FID = T1.FPARENTID");
        if (currperiod != null) {
            bufferSql.append("\n AND ((T2.FYEAR > ").append(currperiod.getPeriodYear()).append(")");
            bufferSql.append("\n or (T2.FYEAR = ").append(currperiod.getPeriodYear()).append(" and T2.FPERIOD > ").append(currperiod.getPeriodNumber() - 1).append("))");
        }
        if (type != null) {
            bufferSql.append("\n AND T2.FCREATETYPE = ").append(type.getValue());
        }
        if (companyInfo != null) {
            bufferSql.append("\n AND T1.FCOMPANYORGUNITID = '").append(companyInfo.getId().toString()).append("'");
        }
        bufferSql.append("\n AND T2.FFIVOUCHERED = 0 ");
        bufferSql.append(" AND T_CL_COSTADJUSTBILLENTRY.FPARENTID = T2.FID");
        bufferSql.append(")");
        return bufferSql.toString();
    }

    public static String getDeleteCostAdjBillSql(CompanyOrgUnitInfo companyInfo, PeriodInfo currperiod, CostAdjuestCreateTypeEnum type) {
        StringBuffer bufferSql = new StringBuffer();
        bufferSql.append("DELETE FROM T_CL_COSTADJUSTBILL ");
        bufferSql.append("\n WHERE EXISTS(");
        bufferSql.append("\n SELECT T1.FID FROM T_CL_COSTADJUSTBILL T1");
        bufferSql.append("\n LEFT JOIN T_CL_COSTADJUSTBILLENTRY T2 ON T1.FID = T2.FPARENTID");
        bufferSql.append("\n WHERE T1.FBASESTATUS = 4 AND T2.FID IS  NULL  \n AND T_CL_COSTADJUSTBILL.FID = T1.FID )");
        return bufferSql.toString();
    }

    private void checkWarehouseStartedPeriod(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo curPeriod) throws EASBizException, BOSException {
        String checkSql = this.getCheckWarehousePeriodSql(companyInfo.getId().toString(), curPeriod.getId().toString());
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)checkSql);
        try {
            StringBuilder msg = new StringBuilder();
            while (rowSet.next()) {
                msg.append("\n");
                msg.append(rowSet.getString("orgNum")).append("(").append(rowSet.getString("orgName")).append(")-");
                msg.append(rowSet.getString("whNum")).append("(").append(rowSet.getString("whName")).append(")");
            }
            if (msg.length() > 0) {
                throw new CalculateException(CalculateException.REVCLOSEACCTWAREHOUSE, new Object[]{msg.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
    }

    private void checkIsExistAuditStandardCostAdjBill(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo curPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 from T_CL_StandardCostAdjBill ");
        sql.append(" where FBaseStatus = ").append(4);
        sql.append(" and FCompanyOrgUnitID = '").append(companyInfo.getId().toString()).append("' ");
        sql.append(" and FYear = ").append(curPeriod.getPeriodYear());
        sql.append(" and FPeriod = ").append(curPeriod.getPeriodNumber());
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new CalculateException(CalculateException.STANDARDCOSTADJBILL_IS_AUDIT, (Object[])new String[]{companyInfo.getName()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getCheckWarehousePeriodSql(String companyID, String currPeriodID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT org.fnumber orgNum, org.fname_").append(this.locale).append(" orgName,");
        buffer.append("\n wh.fnumber whNum, wh.fname_").append(this.locale).append(" whName");
        buffer.append("\n FROM T_DB_SOAccreditWH so");
        buffer.append("\n INNER JOIN t_Org_Storage org on org.fid = so.FStorageOrgId");
        buffer.append("\n INNER JOIN T_DB_Warehouse wh on wh.fid = so.FWarehouseId");
        buffer.append("\n WHERE FCompanyID ='").append(companyID).append("'");
        buffer.append("\n AND FIsStarted =1");
        buffer.append("\n AND FPeriodID='").append(currPeriodID).append("'");
        return buffer.toString();
    }

    private String getLocale(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public static String[][] getTempCheckDataNameFields() {
        String[][] fields = new String[][]{{"FBillType", "varchar(80) NOT NULL"}, {"FBizOrTransName", "varchar(255) NOT NULL"}, {"FBillNumber", "varchar(80) NOT NULL"}, {"FBillID", "varchar(44) NOT NULL"}, {"FSumAmount", "NUMERIC(19, 4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getTempCheckPrecisionNameFields() {
        String[][] fields = new String[][]{{"FBillType", "varchar(80) NOT NULL"}, {"FBizOrTransName", "varchar(255) NOT NULL"}, {"FBillNumber", "varchar(80) NOT NULL"}, {"FBillID", "varchar(44) NOT NULL"}, {"Fseq", "int"}, {"FField", "varchar(80)"}};
        return fields;
    }

    private Boolean getDtTempParamValue(Context ctx, String key) throws BOSException {
        Boolean result = false;
        IRowSet rs = null;
        String sql = "select FValue from t_dt_dttempparam where FKey = '" + key + "'";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && "1".equals(rs.getString("FValue"))) {
                result = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        return result;
    }
}

