/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.engin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.engin.CalPreCloseAccountSQLBuilder;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceCalculator;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;

public class CalPreCloseAccountCalculator
extends PeriodBalanceCalculator {
    private static final String TABLE_NAME = "T_IM_PreInventoryBalance";
    private RptParams paramMap;

    private CalPreCloseAccountCalculator(Context ctx, BalanceModelInfo balanceModelInfo, RptParams paramMap) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
        this.paramMap = paramMap;
    }

    public static IBalanceCalculator getInstance(Context ctx, RptParams paramMap) throws BOSException, EASBizException {
        CalPreCloseAccountCalculator balanceCalculator = null;
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance((Context)ctx).getBalanceModelInfo((IObjectPK)new ObjectUuidPK("seqjlFTGSS+fnntnBdl2kyPUYjI="), BalanceEnginUtil.getBalanceModelSelector());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        balanceCalculator = new CalPreCloseAccountCalculator(ctx, balanceModelInfo, paramMap);
        return balanceCalculator;
    }

    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new CalPreCloseAccountSQLBuilder(this.balanceModelInfo, dataModelInfo, this.getOrgUnitID(), this.getCurPeriod(), this.paramMap);
    }

    protected void calculateStep() throws BOSException, EASBizException {
        if (this.getPrePeriod() != null) {
            this.timer.reset();
            this.takeBeginData();
            this.logger.info("\u53d6\u671f\u521d\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        } else {
            this.logger.info("\u5f53\u524d\u671f\u95f4\u4e3a\u5f00\u59cb\u671f\u95f4\uff0c\u4e0d\u9700\u8981\u53d6\u671f\u521d\u6570\u636e\uff01");
        }
        this.timer.reset();
        this.takeBillData();
        this.logger.info("\u6839\u636e\u6a21\u578b\u53d6\u6570\u914d\u7f6e\u4fe1\u606f\u53d6\u6570\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("============\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e============");
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.logger.info("============\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "============");
        this.timer.reset();
        this.groupDetailDataToFinalTable();
        this.logger.info("\u5c06\u660e\u7ec6\u6570\u636e\u6309\u7ef4\u5ea6\u6c47\u603b\u5230\u5206\u7ec4\u4e34\u65f6\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.updateCalculateField();
        this.logger.info("\u66f4\u65b0\u4f59\u989d\u6a21\u578b\u52a8\u6001\u8ba1\u7b97\u5b57\u6bb5\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.balanceModelInfo.setTabName(TABLE_NAME);
        this.timer.reset();
        this.deletePeriodBalance(this.getCurPeriod());
        this.logger.info("\u5220\u9664\u4f59\u989d\u8868\u672c\u671f\u671f\u521d\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.insertReadyDataToBalanceTable();
        this.logger.info("\u63d2\u5165\u672c\u671f\u6700\u7ec8\u6570\u636e\u5230\u4f59\u989d\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    protected void takeBeginData() throws BalanceModelException, BOSException {
        StringBuffer selectSQL = new StringBuffer();
        String insertSQL = this.getInsertSQL(this.detailTempTable);
        selectSQL.append(insertSQL).append("\r\n");
        selectSQL.append(this.getBeginDataSQL(this.curPeriod));
        this.logger.debugSQL("\u83b7\u53d6\u671f\u521d\u6570\u636eSQL\uff1a", selectSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)selectSQL.toString());
    }

    protected String getBeginDataSQL(PeriodInfo curPeriod) {
        StringBuffer selectSQL = new StringBuffer("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                selectSQL.append(",");
            }
            if (fieldInfo.getFieldName().equalsIgnoreCase("FISISSEBILL")) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (fieldInfo.getFieldName().equalsIgnoreCase("FCOSTADJUSTBILL")) {
                selectSQL.append("''").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (curPeriod.getPeriodNumber() == 1 && BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            selectSQL.append(fieldInfo.getFieldName());
        }
        selectSQL.append("\r\n");
        selectSQL.append("FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        selectSQL.append(this.getBalanceTableFilter(curPeriod));
        return selectSQL.toString();
    }

    public RptParams getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(RptParams paramMap) {
        this.paramMap = paramMap;
    }
}

