/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.app.calculate.FIFOCalculate;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.BalancePlugInAdapter;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.util.LowTimer;
import java.math.BigDecimal;

public class InvPeriodBalancePlugInHandler
extends BalancePlugInAdapter {
    private IBalanceLogger logger;
    private LowTimer timer = new LowTimer();

    public void handleAfterDetailData(Context ctx, String detailTempTable, HandlerParameter params) throws BOSException, EASBizException {
        this.logger = params.getLogger();
        this.timer.reset();
        this.handleStandardCostData(ctx, detailTempTable, params);
        this.logger.info("\u53d6\u6807\u51c6\u4ef7\u53d8\u66f4\u5355\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.handleARBillData(ctx, detailTempTable, params);
        this.logger.info("\u53d6\u59d4\u6258\u4ee3\u9500\u5e94\u6536\u5355\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.handleCostAndProjectNO(ctx, detailTempTable);
        this.logger.info("\u6839\u636e\u5e93\u5b58\u7c7b\u578b\u6807\u5fd7\u5904\u7406\u6210\u672c\u3001\u9879\u76ee\u53f7\u548c\u8ddf\u8e2a\u53f7\u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    private void handleCostAndProjectNO(Context ctx, String detailTempTable) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update ").append(detailTempTable).append(" as T set FPeriodReceiptAmount = 0, FPeriodReceiptCostDiff = 0, ");
        sSQL.append("FPeriodIssueAmount = 0, FPeriodIssueCostDiff = 0 ");
        sSQL.append("where exists (select 1 from T_IM_StoreType storeType where T.FStoreTypeId = storeType.FID ");
        sSQL.append("and storeType.FIsForwardAmt = 0)");
        this.logger.debugSQL("\u5c06\u5ba2\u6237\u548c\u4f9b\u5e94\u5546\u5bc4\u5b58\u7684\u7269\u6599\u6210\u672c\u7f6e\u4e3a\u96f6SQL\uff1a", sSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)sSQL.toString());
        sSQL.setLength(0);
        sSQL.append("update ").append(detailTempTable).append(" as T set FProjectID = null ");
        sSQL.append("where exists (select 1 from t_bd_materialinventory matInv where t.FMaterialId = matInv.FMaterialID ");
        sSQL.append("and t.FStorageOrgUnitID = matInv.FOrgUnit and isnull(matInv.fisprojectnumber, 0) = 0 and T.FProjectID is not null");
        sSQL.append(")");
        this.logger.debugSQL("\u66f4\u65b0\u9879\u76ee\u53f7SQL\uff1a", sSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)sSQL.toString());
        sSQL.setLength(0);
        sSQL.append("update ").append(detailTempTable).append(" as T set FTrackNumberID = null ");
        sSQL.append("where exists (select 1 from t_bd_materialinventory matInv where T.FMaterialId = matInv.FMaterialID ");
        sSQL.append("and t.FStorageOrgUnitID = matInv.FOrgUnit and isnull(matInv.fistrackingnumber, 0) = 0 and T.FTrackNumberID is not null");
        sSQL.append(")");
        this.logger.debugSQL("\u66f4\u65b0\u8ddf\u8e2a\u53f7SQL\uff1a", sSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)sSQL.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStandardCostData(Context ctx, String detailTempTable, HandlerParameter params) throws BOSException, BalanceModelException {
        String createSQL = BalanceEnginUtil.getCreateTempTableSQL((Context)ctx, (BalanceModelInfo)params.getBalanceModelInfo());
        String tempTable = KsqlUtil.createTempTable((Context)ctx, (String)createSQL);
        String maxFIDTempTable = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateMaxFIDTempTableSQL());
        try {
            this.takeDetailStandardCostData(ctx, params, tempTable);
            this.handleDetailDiff(ctx, tempTable, maxFIDTempTable);
            this.insertStandardCostToDetailTempTable(ctx, detailTempTable, tempTable, params);
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
            KsqlUtil.releaseTempTable((Context)ctx, (String)maxFIDTempTable);
        }
    }

    private void handleARBillData(Context ctx, String detailTempTable, HandlerParameter params) throws BOSException, EASBizException {
        boolean isArUpdateInventory = this.getARUpdateInvParam(ctx, params);
        if (!isArUpdateInventory) {
            return;
        }
        String companyId = params.getOrgUnitID();
        int precision = this.getPrecision(ctx, companyId);
        PeriodInfo curPeriod = params.getCurPeriod();
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("Insert into ").append(detailTempTable);
        insertSQL.append("(FId,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FAssistPropertyID,FStoreTypeID,FStoreStatusID,");
        insertSQL.append("FSupplierID,FCustomerID,FWarehouseID,FLocationID,FLot,FProjectID,FTrackNumberID,FYear,FPeriod,FIsCalculate,");
        insertSQL.append("FPeriodIssueQty,FPeriodIssueAssistQty,FPeriodIssueAmount,FPeriodIssueCostDiff)").append("\r\n");
        insertSQL.append("Select T0.FID,T0.FCompanyID,T2.FStorageOrgUnitID,T1.FMaterialID,T1.FAssistPropertyID,");
        insertSQL.append("'181875d5-0105-1000-e000-011ac0a812fd97D461A6' AS FStoreTypeID,'181875d5-0105-1000-e000-012ec0a812fd62A73FA5' AS FStoreStatusID,");
        insertSQL.append("null as FSupplierID,T1.FServiceCustomerID,T2.FWarehouseID,T2.FLocationID,T2.FLot,T2.FProjectID,T2.FTrackNumberID,");
        insertSQL.append(curPeriod.getPeriodYear()).append(" as FYear,").append(curPeriod.getPeriodNumber()).append(" as FPeirod,1 as FIsCalculate,");
        insertSQL.append("ISNULL(T1.FBaseQty, 0) as FPeriodIssueQty,ISNULL(T1.FAssistQty, 0) AS FPeriodIssueAssistQty,");
        insertSQL.append("Round(TO_DECIMAL((CASE T3.FAccountType WHEN 2 THEN T2.FStandardCost ELSE T2.FActualCost END) * TO_DECIMAL(T1.FBaseQty/T2.FBaseQty, 21, 8), 17, 4), ").append(precision).append(") as FPeriodIssueAmount,");
        insertSQL.append("Round(TO_DECIMAL((CASE T3.FAccountType WHEN 2 THEN T2.FActualCost - T2.FStandardCost ELSE 0 END) * TO_DECIMAL(T1.FBaseQty/T2.FBaseQty, 21, 8), 17, 4), ").append(precision).append(") as FPeriodIssueCostDiff").append("\r\n");
        insertSQL.append("FROM T_AR_OtherBill T0").append("\r\n");
        insertSQL.append("INNER JOIN T_AR_OtherBillentry T1 ON T1.FParentID=T0.FID").append("\r\n");
        insertSQL.append("INNER JOIN T_IM_SaleIssueEntry T2 ON T2.FID=T1.FSourceBillEntryId").append("\r\n");
        insertSQL.append("INNER JOIN T_BD_MaterialCompanyInfo T3 ON T3.FMaterialID=T2.FMaterialID AND T3.FCompanyID=T2.FCompanyOrgUnitID").append("\r\n");
        insertSQL.append("WHERE T0.FBillStatus = 3 AND isnull(T0.FIsInitializeBill, 0) = 0").append("\r\n");
        insertSQL.append("AND (T0.FBizTypeID = 'd8e80652-0113-1000-e000-04c5c0a812202407435C' OR T0.FBizTypeID = 'd8e80652-0114-1000-e000-04c5c0a812202407435C')").append("\r\n");
        insertSQL.append("AND T0.FCompanyID = '").append(params.getOrgUnitID()).append("'").append("\r\n");
        insertSQL.append("AND T0.FYear = ").append(curPeriod.getPeriodYear()).append(" AND T0.FPeriod = ").append(curPeriod.getPeriodNumber());
        this.logger.debugSQL("\u63d0\u53d6\u59d4\u6258\u4ee3\u9500\u5e94\u6536\u5355\u5230\u4e34\u65f6\u8868SQL\uff1a", insertSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    private boolean getARUpdateInvParam(Context ctx, HandlerParameter params) throws BOSException, EASBizException {
        String companyId;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String isUpdateByARBILL = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId = params.getOrgUnitID()), "CONSIGNSALES");
        boolean isArUpdateInventory = isUpdateByARBILL == null ? false : isUpdateByARBILL.trim().equals("true");
        return isArUpdateInventory;
    }

    private void takeDetailStandardCostData(Context ctx, HandlerParameter params, String tempTable) throws BOSException {
        String balanceTable = params.getBalanceModelInfo().getTabName();
        PeriodInfo curPeriod = params.getCurPeriod();
        String companyId = params.getOrgUnitID();
        int precision = this.getPrecision(ctx, companyId);
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ");
        insertSQL.append(tempTable).append("(FID,").append(BalanceEnginUtil.getBalanceDimFieldStr((BalanceModelInfo)params.getBalanceModelInfo(), null));
        insertSQL.append(",FPeriodReceiptAmount, FPeriodReceiptCostDiff, FPeriodEndBalance, FPeriodBeginQty)").append("\r\n");
        insertSQL.append("SELECT ").append("newbosid('12345678'),").append(BalanceEnginUtil.getBalanceDimFieldStr((BalanceModelInfo)params.getBalanceModelInfo(), (String)"A"));
        insertSQL.append(",ROUND(TO_Decimal(T1.PriceDiff*A.FPeriodBeginQty, 17, 4), ").append(precision).append(") as FPeriodReceiptAmount").append("\r\n");
        insertSQL.append(",ROUND(TO_Decimal(T1.PriceDiff*A.FPeriodBeginQty, 17, 4), ").append(precision).append(")*(-1) as FPeriodReceiptCostDiff").append("\r\n");
        insertSQL.append(",T1.FDiffAmount as FPeriodEndBalance, A.FPeriodBeginQty").append("\r\n");
        insertSQL.append("FROM (").append("\r\n");
        insertSQL.append(this.getSumStandardCostAdjBillPriceSql(curPeriod, companyId));
        insertSQL.append(") AS T1").append("\r\n");
        insertSQL.append("INNER JOIN ").append(balanceTable).append(" A ");
        insertSQL.append(" ON (A.FCompanyOrgUnitID = T1.FCompanyOrgUnitID AND A.FMATERIALID = T1.FMATERIALID)").append("\r\n");
        insertSQL.append("INNER JOIN T_IM_StoreType B ON A.FStoreTypeID = B.FID").append("\r\n");
        insertSQL.append("WHERE A.FPeriod = " + curPeriod.getPeriodNumber());
        insertSQL.append(" AND A.FYear = " + curPeriod.getPeriodYear()).append("\r\n");
        insertSQL.append(" AND A.FCompanyOrgUnitID = '").append(companyId).append("'");
        insertSQL.append(" AND A.FISCALCULATE = 1 AND B.FIsForwardAmt = 1");
        this.logger.debugSQL("\u8ba1\u7b97\u6807\u51c6\u6210\u672c\u5bfc\u81f4\u7684\u672c\u671f\u6536\u5165\u548c\u672c\u671f\u6536\u5165\u6210\u672c\u5dee\u5f02\u5230\u4e34\u65f6\u8868SQL\uff1a", insertSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    private String getCreateMaxFIDTempTableSQL() {
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("Create Table T_TEMP_MaxFIDTempTable(");
        createSQL.append("  FID varchar(44) NOT NULL,");
        createSQL.append("  FCompanyOrgUnitID varchar(44) NULL,");
        createSQL.append("  FMaterialID varchar(44) NULL");
        createSQL.append(")");
        return createSQL.toString();
    }

    private String getSumStandardCostAdjBillPriceSql(PeriodInfo period, String companyOrgUnitid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT B.FMaterialID AS FMaterialID,A.FCompanyOrgUnitID AS FCompanyOrgUnitID");
        buffer.append(",SUM(B.FNewStandardPrice -B.FOldStandardPrice) AS PriceDiff,SUM(B.FDiffAmount) as FDiffAmount");
        buffer.append("\n FROM  T_CL_StandardCostAdjBill A INNER JOIN T_CL_StandardCostAdjEntry B ON A.FID = B.FParentID");
        buffer.append("\n WHERE A.FBaseStatus = 4 ");
        buffer.append("\n AND A.FYEAR = ").append(period.getPeriodYear());
        buffer.append("\n AND A.FPERIOD = ").append(period.getPeriodNumber());
        buffer.append("\n AND A.FCompanyOrgUnitID = '").append(companyOrgUnitid).append("'");
        buffer.append("\n GROUP BY A.FCompanyOrgUnitID,B.FMaterialID");
        return buffer.toString();
    }

    private void handleDetailDiff(Context ctx, String tempTable, String maxFIDTempTable) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Insert into ").append(maxFIDTempTable).append("(FID,FCompanyOrgUnitId,FMaterialId)").append("\r\n");
        sSQL.append("Select Max(A.FID),A.FCompanyOrgUnitId,A.FMaterialId from (").append("\r\n");
        sSQL.append("Select t.FID,t.FCompanyOrgUnitId,t.FMaterialId from (").append("\r\n");
        sSQL.append("Select Max(FPeriodBeginQty) as FPeriodBeginQty,FCompanyOrgUnitId,FMaterialId from ").append(tempTable).append("\r\n");
        sSQL.append("Group by FCompanyOrgUnitId, FMaterialId) tmp Inner Join ").append(tempTable).append(" t ");
        sSQL.append("ON tmp.FCompanyOrgUnitId = t.FCompanyOrgUnitId AND tmp.FMaterialId = t.FMaterialId AND tmp.FPeriodBeginQty = t.FPeriodBeginQty");
        sSQL.append(" ) A Group by A.FCompanyOrgUnitId,A.FMaterialId");
        this.logger.debugSQL("\u83b7\u53d6\u6700\u5927\u6570\u91cf\u7684\u8bb0\u5f55\uff0c\u7528\u6765\u505a\u5c3e\u5dee\u8c03\u6574\u7684\u8bb0\u5f55SQL\uff1a", sSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)sSQL.toString());
        sSQL.setLength(0);
        sSQL.append("Update ").append(tempTable).append(" AS T1 Set (FPeriodReceiptAmount, FPeriodReceiptCostDiff) = (").append("\r\n");
        sSQL.append(" Select T1.FPeriodEndBalance - T2.FSumReceiptAmount,(-1)*T1.FPeriodEndBalance - T2.FSumReceiptDiff From (").append("\r\n");
        sSQL.append("   Select A.FID, Sum(B.FPeriodReceiptAmount) as FSumReceiptAmount, Sum(B.FPeriodReceiptCostDiff) as FSumReceiptDiff ").append("\r\n");
        sSQL.append("   From ").append(maxFIDTempTable).append(" A").append("\r\n");
        sSQL.append("   Inner Join ").append(tempTable).append(" B ").append("\r\n");
        sSQL.append("   On (B.FID <> A.FID And B.FCompanyOrgUnitId = A.FCompanyOrgUnitId And B.FMaterialId = A.FMaterialId)").append("\r\n");
        sSQL.append("   Group by A.FID,B.FCompanyOrgUnitID,B.FMaterialId").append("\r\n");
        sSQL.append(" ) T2 Where T1.FId = T2.FId").append("\r\n");
        sSQL.append(")");
        this.logger.debugSQL("\u66f4\u65b0\u5c3e\u5deeSQL\uff1a", sSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)sSQL.toString());
    }

    private int getPrecision(Context ctx, String companyId) throws BOSException {
        StringBuffer sql = new StringBuffer(50);
        sql.append(" select currency.fPrecision from ");
        sql.append(" t_org_company company inner join t_bd_currency currency");
        sql.append(" on company.fbaseCurrencyid=currency.fid");
        sql.append(" where company.fid='").append(companyId).append("'");
        Object obj = DBUtil.takeValue((Context)ctx, (String)sql.toString());
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        return 2;
    }

    private void insertStandardCostToDetailTempTable(Context ctx, String detailTempTable, String tempTable, HandlerParameter params) throws BOSException {
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ");
        insertSQL.append(detailTempTable).append("(FID,").append(BalanceEnginUtil.getBalanceDimFieldStr((BalanceModelInfo)params.getBalanceModelInfo(), null));
        insertSQL.append(",FPeriodReceiptAmount, FPeriodReceiptCostDiff, FPeriodAdjustDiff)").append("\r\n");
        insertSQL.append("SELECT ").append("newbosid('12345678'),");
        insertSQL.append(BalanceEnginUtil.getBalanceDimFieldStr((BalanceModelInfo)params.getBalanceModelInfo(), null)).append("\r\n");
        insertSQL.append(",FPeriodReceiptAmount, FPeriodReceiptCostDiff, (-1 * FPeriodReceiptCostDiff)").append("\r\n");
        insertSQL.append("FROM ").append(tempTable);
        this.logger.debugSQL("\u63d2\u5165\u5904\u7406\u5b8c\u6bd5\u7684\u6807\u51c6\u4ef7\u53d8\u66f4\u5355\u6570\u636eSQL\uff1a", insertSQL.toString());
        KsqlUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    public void handleAfterFinalReadyData(Context ctx, String finalTempTable, HandlerParameter params) throws BOSException, EASBizException {
        this.timer.reset();
        this.logger = params.getLogger();
        this.calculateFIFOBalance(ctx, finalTempTable, params);
        this.logger.info("\u8ba1\u7b97\u5148\u8fdb\u5148\u51fa\u8ba1\u4ef7\u6cd5\u7ed3\u5b58\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateFIFOBalance(Context ctx, String finalTempTable, HandlerParameter params) throws BOSException, EASBizException {
        CalculateParams calParams = new CalculateParams();
        calParams.setString("tempTalbeNameKEY", finalTempTable);
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)params.getOrgUnitID()));
        calParams.setString("Colse_Account_Table", "T_CL_InventoryBalance");
        calParams.setString("COMPANY_ID", params.getOrgUnitID());
        calParams.setObject("COMPANY_OBJ", (Object)cou);
        calParams.setObject("PERIOD_OBJ", (Object)params.getCurPeriod());
        calParams.setObject("nextPeriod", (Object)params.getNextPeriod());
        calParams.setBoolean("ISWRITECOSTCOMPUTEREPORT", true);
        calParams.setInt("ACCOUNT_TYPE", 4);
        SysTempTableHelper sysTempTableHelper = new SysTempTableHelper(ctx, null);
        try {
            String temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFIFOTableFields());
            sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
            sysTempTableHelper.createTempTableIndex(temTableName, "FBillEntryId", false, false);
            sysTempTableHelper.createTempTableIndex(temTableName, "FSOURCEBILLENTRYID", false, false);
            calParams.setString("T_Temp_FIFOBills", temTableName);
            temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getFIFOMaterialTableFields());
            calParams.setString("T_Temp_FIFOMaterialList", temTableName);
            temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getMiddleFIFOTableFields());
            sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
            sysTempTableHelper.createTempTableIndex(temTableName, "FMaterialID,FBaseUnit", false, false);
            calParams.setString("T_Temp_MiddleFIFOBills", temTableName);
            temTableName = sysTempTableHelper.createTempTable(ctx, this.getTempFifoAssistNameFields());
            calParams.setString("T_Temp_ASSISTTABLE", temTableName);
            FIFOCalculate ical = new FIFOCalculate();
            ical.calculateCost(ctx, calParams, sysTempTableHelper);
        }
        finally {
            sysTempTableHelper.releaseTempTable(calParams.getString("T_Temp_FIFOBills"));
            sysTempTableHelper.releaseTempTable(calParams.getString("T_Temp_FIFOMaterialList"));
            sysTempTableHelper.releaseTempTable(calParams.getString("T_Temp_MiddleFIFOBills"));
            sysTempTableHelper.releaseTempTable(calParams.getString("T_Temp_ASSISTTABLE"));
            sysTempTableHelper.releaseConnection();
        }
    }

    private String[][] getTempFifoAssistNameFields() {
        String[][] fields = new String[][]{{"FID", "varchar(44) NOT NULL"}, {"FBaseQty", "NUMERIC(21, 8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17, 4) DEFAULT 0 NOT NULL"}, {"FOutwarehouseType", "int DEFAULT 0 NOT NULL"}, {"FEntryTableMame", "varchar(44)"}};
        return fields;
    }
}

