/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlResourceReader {
    private String beansConfigXml;
    private String resourceDir;
    private List<Element> standardResourceList;
    private List<Element> extResourceList;

    XmlResourceReader(String beansConfigXml) throws BOSException {
        this.beansConfigXml = beansConfigXml;
        this.init();
    }

    private void init() throws BOSException {
        this.standardResourceList = new ArrayList<Element>();
        this.extResourceList = new ArrayList<Element>();
        Element root = this.readXml(this.beansConfigXml);
        this.resourceDir = root.getAttributeValue("resourceDir");
        List beanConfigs = root.getChildren("beanconfig");
        for (Element e : beanConfigs) {
            String source = e.getAttributeValue("source");
            String standard = e.getAttributeValue("standard");
            String resourceXml = source.startsWith("com.kingdee.eas") ? source : this.resourceDir + "." + source;
            Element subElement = this.readXml(resourceXml);
            if ("true".equalsIgnoreCase(standard)) {
                this.standardResourceList.add(subElement);
                continue;
            }
            this.extResourceList.add(subElement);
        }
    }

    private Element readXml(String xmlFile) throws BOSException {
        Element root;
        InputStream is = null;
        try {
            if (xmlFile.endsWith(".xml")) {
                xmlFile = xmlFile.substring(0, xmlFile.length() - 4);
            }
            if ((is = (xmlFile = xmlFile.replaceAll("\\.", "/") + ".xml").indexOf("/") < 0 ? this.getClass().getResourceAsStream(xmlFile) : this.getClass().getClassLoader().getResourceAsStream(xmlFile)) == null) {
                Element element = null;
                return element;
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(XmlResourceReader.class);
            logger.error("\u8bfb\u53d6xml\u914d\u7f6e\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return root;
    }

    List<Element> getStandardResourceList() {
        return this.standardResourceList;
    }

    List<Element> getExtResourceList() {
        return this.extResourceList;
    }
}

