/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.credit.app.balance.PushCreditBalanceFactory;
import java.lang.reflect.Method;
import java.util.Set;

public class CreditUpdatingProcessor
extends AbstractBusinessProcessor {
    public CreditUpdatingProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public CreditUpdatingProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public CreditUpdatingProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        EntityViewInfo view;
        Set idSet = batchResults.getToDoIdsSet();
        if (idSet.size() == 0) {
            return;
        }
        String policy = null;
        String oql = null;
        boolean hasVersion = false;
        if (!this.bosType.toString().equals("C48A423A")) {
            return;
        }
        policy = "com.kingdee.eas.scm.credit.app.balance.SaleOrderBalanceUpdateProxy";
        oql = "select id, version";
        hasVersion = true;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        Method mGetCollection = BusinessProcessUtil.getCollectionMethod((Context)this.ctx, (BOSObjectType)this.bosType);
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface((Context)this.ctx, (BOSObjectType)this.bosType);
        IObjectCollection collection = (IObjectCollection)BusinessProcessUtil.invokeBizMethod((IBizCtrl)iBiz, (Method)mGetCollection, (Object[])new Object[]{view});
        if (collection == null || collection.size() == 0) {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objValue = collection.getObject(i);
            String id = objValue.get(objValue.getPKField()).toString();
            try {
                if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                    int version;
                    if (hasVersion && (version = ((Integer)objValue.get("version")).intValue()) > 1) {
                        oql = new StringBuffer().append("select id where oldID = '").append(id).append("' and version = ").append(version - 1).toString();
                        CoreBaseInfo oldValue = ((ICoreBase)iBiz).getValue(oql);
                        PushCreditBalanceFactory.getAlterPushInstance((Context)this.ctx, (String)policy).pushCreditBalanceAtAlter(objValue, (IObjectValue)oldValue).updateCreditBalance();
                        continue;
                    }
                    PushCreditBalanceFactory.getAuditPushInstance((Context)this.ctx, (String)policy).pushCreditBalanceAtAudit(objValue).updateCreditBalance();
                    continue;
                }
                if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) continue;
                PushCreditBalanceFactory.getUnAuditPushInstance((Context)this.ctx, (String)policy).pushCreditBalanceAtUnAudit(objValue).updateCreditBalance();
                continue;
            }
            catch (Exception e) {
                batchResults.addError(id, e);
            }
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }
}

