/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMCommonBizMethodProcessor;
import java.util.Date;

public abstract class SCMBizDataCheckProcessor
extends SCMCommonBizMethodProcessor {
    private static final long serialVersionUID = 4922690523091287929L;

    public SCMBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCMBizDataCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCMBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() < 1) {
            return;
        }
        SCMBillBaseInfo info = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = (SCMBillBaseInfo)collection.getObject(i);
            if (info.getNumber() == null) {
                throw new SCMBillException(SCMBillException.CHECKBILLNUMBLANK, new Object[]{info.getString("number")});
            }
            if (this.isSameNumber(this.ctx, (IObjectValue)info) || this.isSameNumber(this.ctx, info.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR, new Object[]{info.getString("number")});
            }
            if (info.getBizDate() == null) {
                throw new SCMBillException(SCMBillException.BIZDATENOTNULL, new Object[]{info.getString("number")});
            }
            if (info.getBillType() == null) {
                throw new SCMBillException(SCMBillException.BILLTYPE_IS_NULL, new Object[]{info.getString("number")});
            }
            if (info.getBizType() != null) continue;
            throw new SCMBillException(SCMBillException.BIZTYPE_IS_NULL, new Object[]{info.getString("number")});
        }
    }

    protected void checkAccountClosed(Context ctx, SCMBillBaseInfo model) throws EASBizException, BOSException {
        ObjectUuidPK pk = model.getId() == null ? null : new ObjectUuidPK(model.getId());
        this.check4AccountClosed(ctx, (IObjectPK)pk, model);
    }

    protected void check4AccountClosed(Context ctx, IObjectPK pk, SCMBillBaseInfo model) throws EASBizException, BOSException {
        if (!this.isCheckCloseAccount()) {
            return;
        }
        if (model != null && !this.isCloseAccount(ctx, model)) {
            return;
        }
        CompanyOrgUnitInfo couInfo = null;
        if (model != null) {
            couInfo = this.getCompanyOrgUnit(ctx, (IObjectValue)model);
        }
        if (couInfo != null && couInfo.getName() == null) {
            couInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(couInfo.getId()));
        }
        throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED, (Object[])new String[]{couInfo.getName()});
    }

    protected boolean isCloseAccount(Context ctx, SCMBillBaseInfo model) throws EASBizException, BOSException {
        boolean isShuted;
        Date bizDate = model.getBizDate();
        if (bizDate == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        CompanyOrgUnitInfo cou = this.getCompanyOrgUnit(ctx, (IObjectValue)model);
        if (cou != null && (isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou)) && this.isCheckCloseAccount()) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou);
            PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            if (periodInfo != null && periodInfo.equals((Object)curPeriodInfo)) {
                return true;
            }
        }
        return false;
    }
}

