/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseCollection;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Submit2AuditProcessor
extends AbstractSCMBusinessProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Submit2AuditProcessor.class);
    private static final long serialVersionUID = -3075551904393289501L;

    public Submit2AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public Submit2AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public Submit2AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = this.getAutoAuditBillCollection(batchResults.getObjCollection());
        if (null == objCol || objCol.size() == 0) {
            return;
        }
        int size = objCol.size();
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[size];
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            entries[i] = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        }
        Class[] parameTypes = new Class[]{IObjectPK.class};
        ISCMBillBase iScmBillBase = (ISCMBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)this.bosType);
        try {
            BatchExecuteResult batchExecuteResult = iScmBillBase.batchExecute("audit", parameTypes, entries);
            Throwable[] throwables = batchExecuteResult.getExceptions();
            if (null != throwables && throwables.length > 0 && null != throwables[0]) {
                throw throwables[0];
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    protected OrgType getMainOrgType(SCMBillBaseInfo info) {
        return info == null ? null : info.getMainOrgType();
    }

    protected IObjectCollection getAutoAuditBillCollection(IObjectCollection objCollection) throws BOSException, EASBizException {
        String orgUnitID;
        OrgUnitInfo orgTypeInfo;
        if (null == objCollection || objCollection.size() == 0) {
            return null;
        }
        HashSet<String> orgIdSet = new HashSet<String>(objCollection.size());
        SCMBillBaseInfo info = null;
        int size = objCollection.size();
        for (int i = 0; i < size; ++i) {
            info = (SCMBillBaseInfo)objCollection.getObject(i);
            orgTypeInfo = (OrgUnitInfo)info.get(info.getBizOrgPropertyName());
            if (null == orgTypeInfo) continue;
            orgIdSet.add(orgTypeInfo.getId().toString());
        }
        int orgIdSize = orgIdSet.size();
        SCMBillBaseCollection objCol = new SCMBillBaseCollection();
        if (orgIdSize == 0) {
            return objCol;
        }
        if (orgIdSize > 3) {
            logger.warn("\u6279\u91cf\u63d0\u4ea4\u65f6\uff0c\u4e0d\u540c\u7684\u4e1a\u52a1\u7ec4\u7ec7\u6570\u91cf\u8d85\u8fc73\u4e2a\uff0c\u53d6\u53c2\u6570\u65f6\uff0c\u9700\u4fee\u6539\u4e3a\u6279\u91cf\u53d6\u6570\uff01");
        }
        if (this.getMainOrgType(info) == null) {
            throw new BOSException("info\u7c7b\u5fc5\u987b\u8986\u76d6SCM\u57fa\u7c7b\u7684getMainOrgType\u65b9\u6cd5\uff0c\u8fd4\u56de\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u7c7b\u578b\uff01");
        }
        int orgType = this.getMainOrgType(info).getValue();
        String billTypeId = ((SCMBillBaseInfo)objCollection.getObject(0)).getBillType().getId().toString();
        Iterator iterator = orgIdSet.iterator();
        HashMap<String, Boolean> autoAuditOrgMap = new HashMap<String, Boolean>(orgIdSet.size());
        ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)this.ctx);
        while (iterator.hasNext()) {
            orgUnitID = (String)iterator.next();
            String strAutoAudit = iSCMBillParam.getParamByBillTypeID("SCM_Submit_01", orgType, orgUnitID, billTypeId);
            if (null == strAutoAudit || !"1".equals(strAutoAudit.trim())) continue;
            autoAuditOrgMap.put(orgUnitID, Boolean.TRUE);
        }
        int size2 = objCollection.size();
        for (int i = 0; i < size2; ++i) {
            info = (SCMBillBaseInfo)objCollection.getObject(i);
            orgTypeInfo = (OrgUnitInfo)info.get(info.getBizOrgPropertyName());
            if (null == orgTypeInfo || !autoAuditOrgMap.containsKey(orgUnitID = orgTypeInfo.getId().toString())) continue;
            objCol.addObject((IObjectValue)info);
        }
        return objCol;
    }
}

