/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.util.app.ContextUtil;

public class SCMCheckIsSamePerson4AuditVRule
implements IVRule {
    Context ctx;

    public SCMCheckIsSamePerson4AuditVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SCMBillBaseInfo model = (SCMBillBaseInfo)bean;
        this.isSamePerson4Audit(model);
    }

    public void isSamePerson4Audit(SCMBillBaseInfo model) throws EASBizException, BOSException {
        String paramValue;
        UserInfo userInfo;
        String creatorID = null;
        String currentUserId = null;
        if (model.getCreator() != null) {
            creatorID = model.getCreator().getId().toString();
        }
        if ((userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx)) != null) {
            currentUserId = userInfo.getId().toString();
        }
        if ((paramValue = this.getAuditParam(this.ctx, model, BatchActionEnum.AUDIT)) != null && "true".equals(paramValue.trim()) && creatorID != null && creatorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_CREATOR_ISSAME);
        }
        if (paramValue != null && "1".equals(paramValue.trim()) && creatorID != null && creatorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_CREATOR_ISSAME);
        }
    }

    public String getAuditParam(Context ctx, SCMBillBaseInfo model, BatchActionEnum action) throws EASBizException, BOSException {
        OrgUnitInfo orgUnitInfo = this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)model);
        String paramName = action == BatchActionEnum.AUDIT ? this.getParamCon4Audit() : this.getParamCon4UnAudit();
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String paramValue = null;
        if (paramName != null && orgUnitInfo != null) {
            paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()), paramName);
        }
        return paramValue;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)this.getMainBizOrgType());
    }

    public String getParamCon4Audit() {
        return null;
    }

    public String getParamCon4UnAudit() {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return null;
    }
}

