/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.ControlMethodEnum;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditLimit;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CreditCondition
implements Serializable {
    private static final long serialVersionUID = 5051250832810656643L;
    public static final String BILL_NUMERIC_AMOUNT = "BILL_NUMERIC_AMOUNT";
    public static final String BILL_NUMERIC_QTY = "BILL_NUMERIC_QTY";
    public static final String BILL_NUMERIC_AMOUNT_BIZCODE = "BILL_NUMERIC_AMOUNT_BIZCODE";
    private CompanyOrgUnitInfo company = null;
    private int creditControlScene = 1;
    private CustomerInfo customer = null;
    private String customerFrom = null;
    private String customerTo = null;
    private Set customerIn = null;
    private String customerGroupFrom = null;
    private String customerGroupTo = null;
    private String bizCodeFrom = null;
    private String bizCodeTo = null;
    private boolean isByBizCode_Param = false;
    public boolean isCheck = false;
    private boolean onlyCreditCusSelected = false;
    private boolean isRootControl = false;
    private CreditParamInfo creditParam = null;
    private boolean isByBizCode_Sys = false;
    private boolean isCustFirst = false;
    private ContrlTimeEnum creditControlTime = ContrlTimeEnum.ONAUDIT;
    private boolean isInfinityCreditAmt = true;
    private BigDecimal defaultAmount = null;
    private String creditFormula = null;
    private OrgUnitInfo orgUnit = null;
    private PaymentTypeInfo paymentType = null;
    private Map billNumeric = new HashMap();
    private String billNumber = null;
    private Date billDate = new Date(System.currentTimeMillis());
    private boolean isFromSaleOrderQuery = false;
    private CreditOperationEnum operation;
    private CreditDirectionEnum direction;
    private CreditFormulaSceneEnum billType;
    private BigDecimal billAmount = SCMConstant.BIGDECIMAL_ZERO;
    private String bizCodeID = null;
    private boolean isFromRptUI = false;

    public void initCreditParam(Context ctx) throws EASBizException, BOSException {
        this.isRootControl = CreditServerUtil.isCreditParamG00X(ctx, "", "G005");
        this.creditParam = this.isRootControl ? CreditServerUtil.getCreditParamInfo(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4") : CreditServerUtil.getCreditParamInfo(ctx, this.company.getId().toString());
        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(CreditFormulaSceneEnum.getEnum(this.creditControlScene), this.creditParam);
        this.creditFormula = billCtrlStrategy.getFormulaForSave();
        if (this.creditParam != null) {
            this.isByBizCode_Sys = this.creditParam.isBizCode();
            this.creditControlTime = billCtrlStrategy.getControlTime();
            this.isInfinityCreditAmt = !this.creditParam.isDefault0();
            this.isCustFirst = this.creditParam.isCustFirst();
        }
        this.defaultAmount = this.isInfinityCreditAmt ? CreditLimit.BIGDECIMAL_NEGATE_ONE : SysConstant.BIGZERO;
    }

    public BigDecimal readBillAmount() {
        return this.getNumericValue(BILL_NUMERIC_AMOUNT);
    }

    public BigDecimal getNumericValue(String key) {
        BigDecimal v = SysConstant.BIGZERO;
        if (this.billNumeric.containsKey(key)) {
            Object o = this.billNumeric.get(key);
            BigDecimal bigDecimal = o = o == null ? SysConstant.BIGZERO : o;
            if (o instanceof BigDecimal) {
                v = SCMUtils.effectualNumeric((BigDecimal)((BigDecimal)this.billNumeric.get(key)));
            }
        }
        return v;
    }

    public String getBillName() {
        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(CreditFormulaSceneEnum.getEnum(this.getCreditControlScene()), null);
        return billCtrlStrategy.getBillName();
    }

    public String getBillName(Context ctx) {
        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(CreditFormulaSceneEnum.getEnum(this.getCreditControlScene()), null);
        return billCtrlStrategy.getBillName(ctx);
    }

    public final ControlMethodEnum getCreditControlMethod() throws CreditControlException {
        ControlMethodEnum creditCtrlMode = ControlMethodEnum.AUDITING;
        CreditParamInfo creditParam = this.getCreditParam();
        if (creditParam != null) {
            BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(CreditFormulaSceneEnum.getEnum(this.creditControlScene), creditParam);
            creditCtrlMode = billCtrlStrategy.getControlMethod();
        }
        return creditCtrlMode;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public int getCreditControlScene() {
        return this.creditControlScene;
    }

    public void setCreditControlScene(int creditControlScene) {
        this.creditControlScene = creditControlScene;
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerInfo customer) {
        this.customer = customer;
    }

    public String getCustomerFrom() {
        return this.customerFrom;
    }

    public void setCustomerFrom(String customerFrom) {
        this.customerFrom = customerFrom;
    }

    public String getCustomerTo() {
        return this.customerTo;
    }

    public void setCustomerTo(String customerTo) {
        this.customerTo = customerTo;
    }

    public String getCustomerGroupFrom() {
        return this.customerGroupFrom;
    }

    public void setCustomerGroupFrom(String customerGroupFrom) {
        this.customerGroupFrom = customerGroupFrom;
    }

    public String getCustomerGroupTo() {
        return this.customerGroupTo;
    }

    public void setCustomerGroupTo(String customerGroupTo) {
        this.customerGroupTo = customerGroupTo;
    }

    public String getBizCodeFrom() {
        return this.bizCodeFrom;
    }

    public void setBizCodeFrom(String bizCodeFrom) {
        this.bizCodeFrom = bizCodeFrom;
    }

    public String getBizCodeTo() {
        return this.bizCodeTo;
    }

    public void setBizCodeTo(String bizCodeTo) {
        this.bizCodeTo = bizCodeTo;
    }

    public boolean isByBizCode_Param() {
        return this.isByBizCode_Param;
    }

    public boolean isCheck() {
        return this.isCheck;
    }

    public void setIsCheck(boolean isCheck) {
        this.isCheck = isCheck;
    }

    public void setByBizCode_Param(boolean isByBizCodeParam) {
        this.isByBizCode_Param = isByBizCodeParam;
    }

    public boolean isonlyCreditCusSelected() {
        return this.onlyCreditCusSelected;
    }

    public void setonlyCreditCusSelected(boolean selected) {
        this.onlyCreditCusSelected = selected;
    }

    public boolean isRootControl() {
        return this.isRootControl;
    }

    public void setRootControl(boolean isRootControl) {
        this.isRootControl = isRootControl;
    }

    public CreditParamInfo getCreditParam() {
        return this.creditParam;
    }

    public void setCreditParam(CreditParamInfo creditParam) {
        this.creditParam = creditParam;
    }

    public boolean isByBizCode_Sys() {
        return this.isByBizCode_Sys;
    }

    public void setByBizCode_Sys(boolean isByBizCodeSys) {
        this.isByBizCode_Sys = isByBizCodeSys;
    }

    public boolean isCustFirst() {
        return this.isCustFirst;
    }

    public void setCustFirst(boolean isCustFirst) {
        this.isCustFirst = isCustFirst;
    }

    public ContrlTimeEnum getCreditControlTime() {
        return this.creditControlTime;
    }

    public void setCreditControlTime(ContrlTimeEnum creditControlTime) {
        this.creditControlTime = creditControlTime;
    }

    public boolean isInfinityCreditAmt() {
        return this.isInfinityCreditAmt;
    }

    public void setInfinityCreditAmt(boolean isInfinityCreditAmt) {
        this.isInfinityCreditAmt = isInfinityCreditAmt;
        this.defaultAmount = isInfinityCreditAmt ? CreditLimit.BIGDECIMAL_NEGATE_ONE : SysConstant.BIGZERO;
    }

    public String getCreditFormula() {
        return this.creditFormula;
    }

    public void setCreditFormula(String creditFormula) {
        this.creditFormula = creditFormula;
    }

    public OrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(OrgUnitInfo orgUnit) {
        this.orgUnit = orgUnit;
    }

    public PaymentTypeInfo getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentTypeInfo paymentType) {
        this.paymentType = paymentType;
    }

    public Map getBillNumeric() {
        return this.billNumeric;
    }

    public void setBillNumeric(Map billNumeric) {
        this.billNumeric = billNumeric;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public Date getBillDate() {
        return this.billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public boolean isFromSaleOrderQuery() {
        return this.isFromSaleOrderQuery;
    }

    public void setFromSaleOrderQuery(boolean isFromSaleOrderQuery) {
        this.isFromSaleOrderQuery = isFromSaleOrderQuery;
    }

    public BigDecimal getDefaultAmount() {
        return this.defaultAmount;
    }

    public void setDefaultAmount(BigDecimal defaultAmount) {
        this.defaultAmount = defaultAmount;
    }

    public CreditOperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(CreditOperationEnum operation) {
        this.operation = operation;
    }

    public CreditDirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(CreditDirectionEnum direction) {
        this.direction = direction;
    }

    public CreditFormulaSceneEnum getBillType() {
        return this.billType;
    }

    public void setBillType(CreditFormulaSceneEnum billType) {
        this.billType = billType;
    }

    public BigDecimal getBillAmount() {
        return this.billAmount;
    }

    public void setBillAmount(BigDecimal billAmount) {
        this.billAmount = billAmount;
    }

    public String getBizCodeID() {
        return this.bizCodeID;
    }

    public void setBizCodeID(String bizCodeID) {
        this.bizCodeID = bizCodeID;
    }

    public boolean isFromRptUI() {
        return this.isFromRptUI;
    }

    public void setFromRptUI(boolean isFromRptUI) {
        this.isFromRptUI = isFromRptUI;
    }

    public Set getCustomerIn() {
        return this.customerIn;
    }

    public void setCustomerIn(Set customerIn) {
        this.customerIn = customerIn;
    }
}

