/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.io.Serializable;
import java.math.BigDecimal;

public final class CreditLimit
implements Serializable {
    private static final long serialVersionUID = 6815265774350447133L;
    public static final BigDecimal BIGDECIMAL_NEGATE_ONE = SCMUtils.BIGDECIMAL_ONE.negate();
    public static final String INFINITY_STRING = "\u221e";
    public static final CreditLimit INFINITY = new CreditLimit(true);
    public static final CreditLimit ZERO = new CreditLimit(SysConstant.BIGZERO);
    private boolean isInfinity = false;
    private BigDecimal value = SysConstant.BIGZERO;

    public CreditLimit() {
        this.value = SysConstant.BIGZERO;
    }

    public CreditLimit(BigDecimal v) {
        this.value = SCMUtils.effectualNumeric((BigDecimal)v);
    }

    private CreditLimit(boolean isInfinity) {
        this.isInfinity = isInfinity;
        this.value = SysConstant.BIGZERO;
    }

    public static CreditLimit read(BigDecimal value) {
        return new CreditLimit(value);
    }

    public BigDecimal bigDecimalValue() throws BOSException {
        if (this.isInfinity()) {
            throw new BOSException("Then CreditLimit Is Infinity!");
        }
        return SCMUtils.effectualNumeric((BigDecimal)this.value);
    }

    public static boolean isCreditLimitInfinity(BigDecimal creditAmount) {
        return SCMUtils.effectualNumeric((BigDecimal)creditAmount).compareTo(SysConstant.BIGZERO) == -1;
    }

    public static CreditLimit effectualCreditLimit(BigDecimal creditAmount) {
        return CreditLimit.isCreditLimitInfinity(creditAmount) ? INFINITY : CreditLimit.read(creditAmount);
    }

    public static CreditLimit effectualCreditLimit(CreditLimit creditAmount) throws BOSException {
        CreditLimit creditLimit = ZERO;
        if (creditAmount != null) {
            creditLimit = creditAmount.isInfinity() ? INFINITY : CreditLimit.effectualCreditLimit(creditAmount.bigDecimalValue());
        }
        return creditLimit;
    }

    public boolean isInfinity() {
        return this.isInfinity;
    }

    public static boolean isInfinity(CreditLimit creditLimit) {
        return creditLimit == null ? false : creditLimit.isInfinity();
    }

    public boolean isOverspend(BigDecimal usedCreditAmount) {
        return this.isInfinity() ? false : SCMUtils.effectualNumeric((BigDecimal)this.value).compareTo(SCMUtils.effectualNumeric((BigDecimal)usedCreditAmount)) == -1;
    }

    public static boolean isOverspend(CreditLimit creditLimit, BigDecimal usedCreditAmount) throws BOSException {
        return CreditLimit.effectualCreditLimit(creditLimit).isOverspend(usedCreditAmount);
    }

    public static boolean isOverspend(BigDecimal creditAmount, BigDecimal usedCreditAmount) throws BOSException {
        return CreditLimit.isOverspend(CreditLimit.effectualCreditLimit(creditAmount), usedCreditAmount);
    }

    public static CreditLimit calculateCreditBalance(BigDecimal creditAmount, BigDecimal usedCreditAmount) throws BOSException {
        return CreditLimit.calculateCreditBalance(CreditLimit.effectualCreditLimit(creditAmount), usedCreditAmount);
    }

    public CreditLimit calculateCreditBalance(CreditLimit usedCreditAmount) throws BOSException {
        return CreditLimit.calculateCreditBalance(this, usedCreditAmount);
    }

    public static CreditLimit calculateCreditBalance(CreditLimit creditLimit, CreditLimit usedCreditAmount) throws BOSException {
        CreditLimit creditBalance = ZERO;
        creditBalance = CreditLimit.effectualCreditLimit(creditLimit).isInfinity() ? INFINITY : (CreditLimit.effectualCreditLimit(usedCreditAmount).isInfinity() ? ZERO : CreditLimit.calculateCreditBalance(CreditLimit.effectualCreditLimit(creditLimit).bigDecimalValue(), CreditLimit.effectualCreditLimit(usedCreditAmount).bigDecimalValue()));
        return creditBalance;
    }

    public static CreditLimit calculateCreditBalance(CreditLimit creditLimit, BigDecimal usedCreditAmount) throws BOSException {
        return CreditLimit.effectualCreditLimit(creditLimit).isInfinity() ? INFINITY : CreditLimit.read(CreditLimit.effectualCreditLimit(creditLimit).bigDecimalValue().subtract(SCMUtils.effectualNumeric((BigDecimal)usedCreditAmount)));
    }

    public CreditLimit calculateCreditBalance(BigDecimal usedCreditAmount) throws BOSException {
        return CreditLimit.calculateCreditBalance(this, usedCreditAmount);
    }

    public String toString() {
        return this.isInfinity() ? INFINITY_STRING : SCMUtils.effectualNumeric((BigDecimal)this.value).toString();
    }
}

