/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditQueryFacadeFactory;
import com.kingdee.eas.scm.credit.app.AbstractCreditAnalysisRptFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.TestCreditMobileSupport;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;

public class CreditAnalysisRptFacadeControllerBean
extends AbstractCreditAnalysisRptFacadeControllerBean {
    private static final long serialVersionUID = 7134122603197632390L;
    private String sp = "\r\n";
    private String tempTable;
    private CreditCondition creditCondition = null;
    private static final String TempTableNameKey = "TempTableName";

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        try {
            String tempTableName = params.getString(TempTableNameKey);
            RptRowSet rs = this.executeQuery("select * from " + tempTableName, null, from, len, ctx);
            pp.setObject("rowset", (Object)rs);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        KsqlUtil.releaseTempTable((Context)ctx, (String)params.getString("preTempTable"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        String companyId = company.getId().toString();
        Boolean flag = CreditServerUtil.getAuthorizedOrgUnit(ctx, companyId, "CreditAnalysRpt_view");
        this.tempTable = flag != false ? this.processData(ctx, params) : this.createCreditFilesTempTable(ctx, false);
        StringBuffer sql = new StringBuffer();
        if (this.creditCondition.isByBizCode_Param()) {
            sql.append(" SELECT count(1) cc").append(" FROM ").append(this.tempTable).append(this.sp);
            sql.append(" temp inner join t_org_company company on temp.FCOMPANYID=company.fid where temp.FPlevel <> 7").append(this.sp);
        } else {
            sql.append(" SELECT count(1) cc FROM ").append(this.tempTable).append(" temp where 1=1");
        }
        if (this.creditCondition.isonlyCreditCusSelected()) {
            sql.append(" and FAmount <> 0");
        }
        RptRowSet rsCount = this.executeQuery(sql.toString(), null, ctx);
        int count = 0;
        if (rsCount.next() && rsCount.getObject(0) != null) {
            count = rsCount.getInt(0);
        }
        this.copyToIndexTbl(ctx, this.tempTable);
        RptParams result = new RptParams();
        result.setString(TempTableNameKey, this.tempTable);
        result.setInt("RowCount", count);
        result.setInt("ControlTime", this.creditCondition.getCreditControlTime().getValue());
        result.setBoolean("isByBizCode", this.creditCondition.isByBizCode_Sys());
        result.setBoolean("isByBizCode_Param", this.creditCondition.isByBizCode_Param());
        result.setBoolean("onlyCreditCusSelected", this.creditCondition.isonlyCreditCusSelected());
        return result;
    }

    private void copyToIndexTbl(Context ctx, String tempTableName) throws BOSException {
        try {
            String newTempTable = this.createCreditFilesTempTable(ctx, true);
            boolean isByBizCode = this.creditCondition.isByBizCode_Sys();
            boolean isByBizCode_Param = this.creditCondition.isByBizCode_Param();
            boolean onlyCreditCus = this.creditCondition.isonlyCreditCusSelected();
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(newTempTable);
            sql.append("(id, FCompanyNumber,FCompanyName,FBizCodeNum,FBizCodeName,FPLevel,");
            sql.append("FCustomerNumber,FCustomerName,FGradeName,FUnAuditSOAmt,");
            sql.append("FUnAuditARAmt,FUnArBillIssuedAmt,FUnAuditIssuedAmt,FReserve1,FReserve2,");
            sql.append("FReserve3,FReserve4,FReserve5,FUnAuditPostBillAmt,FUnOutPostBillAmt,");
            sql.append("FUnOutSaleOrderBillAmt,FBaseCurrencyName,FBaseCurrencyPrecision,FAmount,FArBalance,");
            sql.append("UsedAmount,CreditBalance,FIsBalanceRate,FBalanceRate,FRatedBalance,ImcomeAmt,PayAmt, ");
            sql.append("FUnArBillOrderAmt,FCompanyId,FCustomerId,FBaseCurrencyID,FCOMPANYLONGNUMBER, ");
            sql.append("FLevel,orderField1,orderField2) ").append(this.sp);
            if (isByBizCode) {
                if (isByBizCode_Param) {
                    sql.append(this.getBaseSelectSql());
                    sql.append("company.FLevel,");
                    sql.append("0 orderField1,temp.FCustomerNumber orderField2 ").append(this.sp);
                    sql.append(" FROM ").append(tempTableName).append(" temp inner join t_org_company company on temp.FCOMPANYID=company.fid").append(this.sp);
                    sql.append(" where temp.FPlevel <> 7");
                    if (onlyCreditCus) {
                        sql.append(" and temp.FAmount <> 0");
                    }
                    sql.append(" ORDER BY temp.FBizCodeNum,company.flevel,company.FLONGNUMBER,temp.FCOMPANYLONGNUMBER ASC ");
                } else {
                    sql.append(this.getBaseSelectSql());
                    sql.append("company.FLevel,");
                    sql.append("case when FBizCodeNum is null then 0 else company.flevel end as orderField1,");
                    sql.append("case when FBizCodeNum is null then temp.FCustomerNumber else N'0' end as orderField2 ");
                    sql.append(" FROM ").append(tempTableName).append(" temp inner join t_org_company company on temp.FCOMPANYID=company.fid").append(this.sp);
                    if (onlyCreditCus) {
                        sql.append(" where temp.FAmount <> 0");
                    }
                    sql.append(" ORDER BY temp.FBizCodeNum,orderField1,orderField2,temp.FCOMPANYLONGNUMBER,temp.FCustomerNumber");
                }
            } else {
                sql.append(this.getBaseSelectSql());
                sql.append("0,0,'0' ").append(this.sp);
                sql.append(" FROM ").append(tempTableName).append(" temp ").append(this.sp);
                if (onlyCreditCus) {
                    sql.append(" where temp.FAmount <> 0");
                }
                sql.append(" ORDER BY temp.FCustomerNumber,temp.FCompanyLongNumber ");
            }
            this.executeUpdate(ctx, sql.toString(), null);
            this.tempTable = newTempTable;
            TempTablePool.getInstance((Context)ctx).createIndex(newTempTable, "KSQL_SEQ", true, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
    }

    protected String getBaseSelectSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT temp.id, temp.FCompanyNumber,temp.FCompanyName,temp.FBizCodeNum,temp.FBizCodeName,temp.FPLevel,").append(this.sp);
        sql.append("temp.FCustomerNumber,temp.FCustomerName,temp.FGradeName,temp.FUnAuditSOAmt,").append(this.sp);
        sql.append("temp.FUnAuditARAmt,temp.FUnArBillIssuedAmt,temp.FUnAuditIssuedAmt,temp.FReserve1,temp.FReserve2,").append(this.sp);
        sql.append("temp.FReserve3,temp.FReserve4,temp.FReserve5,temp.FUnAuditPostBillAmt,temp.FUnOutPostBillAmt,").append(this.sp);
        sql.append("temp.FUnOutSaleOrderBillAmt,temp.FBaseCurrencyName,temp.FBaseCurrencyPrecision,temp.FAmount,temp.FArBalance,").append(this.sp);
        sql.append("temp.UsedAmount,temp.CreditBalance,temp.FIsBalanceRate,temp.FBalanceRate,temp.FRatedBalance,temp.ImcomeAmt,temp.PayAmt, ").append(this.sp);
        sql.append("temp.FUnArBillOrderAmt,temp.FCompanyId,temp.FCustomerId,temp.FBaseCurrencyID,temp.FCOMPANYLONGNUMBER,").append(this.sp);
        return sql.toString();
    }

    private String createCreditFilesTempTable(Context ctx, boolean needIncrease) throws BOSException {
        String tempTable;
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(CreditServerUtil.getCreditAnalysisTempTableSql(needIncrease));
        }
        catch (Exception e) {
            throw new SQLDataException(e.getMessage());
        }
        return tempTable;
    }

    public String processData(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.analysisParms(ctx, params);
        return CreditQueryFacadeFactory.getLocalInstance(ctx).calcCredit(this.creditCondition);
    }

    private void analysisParms(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.creditCondition = new CreditCondition();
        this.creditCondition.setCompany((CompanyOrgUnitInfo)params.getObject("company"));
        if (params.containsKey("customerId")) {
            CustomerInfo customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)params.getString("customerId")));
            this.creditCondition.setCustomer(customer);
        }
        if (params.containsKey("customerFrom") && params.getObject("customerFrom") != null) {
            if (params.getObject("customerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("customerFrom");
                if (customers.length == 1) {
                    this.creditCondition.setCustomerFrom(((CustomerInfo)customers[0]).getNumber());
                } else {
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < customers.length; ++i) {
                        set.add(((CustomerInfo)customers[i]).getNumber());
                    }
                    this.creditCondition.setCustomerIn(set);
                }
            } else if (params.getObject("customerFrom") instanceof CustomerInfo) {
                this.creditCondition.setCustomerFrom(((CustomerInfo)params.getObject("customerFrom")).getNumber());
            } else {
                this.creditCondition.setCustomerFrom(params.getObject("customerFrom").toString());
            }
        }
        if (params.containsKey("customerTo") && params.getObject("customerTo") != null) {
            if (params.getObject("customerTo") instanceof CustomerInfo) {
                this.creditCondition.setCustomerTo(((CustomerInfo)params.getObject("customerTo")).getNumber());
            } else {
                this.creditCondition.setCustomerTo(params.getObject("customerTo").toString());
            }
        }
        if (params.containsKey("customerGroupFrom")) {
            this.creditCondition.setCustomerGroupFrom(params.getString("customerGroupFrom"));
        }
        if (params.containsKey("customerGroupTo")) {
            this.creditCondition.setCustomerGroupTo(params.getString("customerGroupTo"));
        }
        if (params.containsKey("bizCodeFrom")) {
            this.creditCondition.setBizCodeFrom(params.getString("bizCodeFrom"));
        }
        if (params.containsKey("bizCodeTo")) {
            this.creditCondition.setBizCodeTo(params.getString("bizCodeTo"));
        }
        if (params.containsKey("isBizCode")) {
            this.creditCondition.setByBizCode_Param(params.getBoolean("isBizCode"));
        }
        if (params.containsKey("onlyCreditCusSelected")) {
            this.creditCondition.setonlyCreditCusSelected(params.getBoolean("onlyCreditCusSelected"));
        }
        if (params.containsKey("ControlScene")) {
            this.creditCondition.setCreditControlScene(params.getInt("ControlScene"));
        }
        if (params.getString("isFromSaleOrderQuery") != null) {
            this.creditCondition.setFromSaleOrderQuery(params.getString("isFromSaleOrderQuery").equalsIgnoreCase("TRUE"));
        }
        if (params.containsKey("isFromRptUI")) {
            this.creditCondition.setFromRptUI(params.getBoolean("isFromRptUI"));
        } else {
            this.creditCondition.setFromRptUI(true);
        }
    }

    @Override
    protected void _test(Context ctx) throws BOSException, EASBizException {
        TestCreditMobileSupport testMs = new TestCreditMobileSupport(ctx);
        testMs.mainTest();
    }

    @Override
    protected String _isExistsOverSpendByCompany(Context ctx, String companyNumber) throws BOSException, EASBizException {
        StringBuilder result = new StringBuilder();
        StringBuilder resultTemp = new StringBuilder();
        if (companyNumber == null) {
            return null;
        }
        String[] companyNumberArray = companyNumber.split(",");
        HashSet companyNumberSet = new HashSet();
        Collections.addAll(companyNumberSet, companyNumberArray);
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", companyNumberSet, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityView);
        if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
            for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
                companyOrgUnitInfo = companyOrgUnitCollection.get(i);
                if (companyOrgUnitInfo != null) {
                    RptParams params = new RptParams();
                    params.setBoolean("isFromRptUI", false);
                    params.setObject("company", (Object)companyOrgUnitInfo);
                    this._createTempTable(ctx, params);
                    String sql = "select FCompanyNumber,FCompanyName,FCustomerNumber,FCustomerName,FAmount,CreditBalance from " + this.tempTable + " where CreditBalance < 0";
                    IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        while (resultSet.next()) {
                            resultTemp.append(ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditAnalysisRptResource", (String)"CUSTOMER_REMAIN_AMOUNT", (Locale)ctx.getLocale(), (Object[])new Object[]{resultSet.getString("FCompanyNumber"), resultSet.getString("FCompanyName"), resultSet.getString("FCustomerNumber"), resultSet.getString("FCustomerName"), resultSet.getString("FAmount"), resultSet.getString("CreditBalance")}));
                            resultTemp.append("\r\n");
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                result = result.append((CharSequence)resultTemp);
            }
        }
        return result.toString();
    }
}

