/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.CreditReserveEnum;
import com.kingdee.eas.scm.credit.app.AbstractCreditBalanceUpdateFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.processor.CreditGeneralProcessor;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CreditBalanceUpdateFacadeControllerBean
extends AbstractCreditBalanceUpdateFacadeControllerBean {
    private static final long serialVersionUID = 3004309129748909547L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditBalanceUpdateFacadeControllerBean");
    private Context ctx;
    private String companyId;
    private String customerId;
    private CreditReserveEnum reserveField;
    private BigDecimal amount;

    @Override
    protected void _UpdateBalance(Context ctx, IObjectPK companyId, IObjectPK customerId, CreditReserveEnum reserveField, BigDecimal amount) throws BOSException, EASBizException {
        if (companyId == null) {
            throw new CreditControlException(CreditControlException.PARAM_COMPANY_NULL);
        }
        if (customerId == null) {
            throw new CreditControlException(CreditControlException.PARAM_CUSTOMER_NULL);
        }
        if (reserveField == null) {
            throw new CreditControlException(CreditControlException.PARAM_RESERVE_NULL);
        }
        if (amount == null) {
            throw new CreditControlException(CreditControlException.PARAM_AMOUNT_NULL);
        }
        this.ctx = ctx;
        this.companyId = companyId.toString();
        this.customerId = customerId.toString();
        this.reserveField = reserveField;
        this.amount = amount;
        if (!this.isNeedUpdateCreditBalance()) {
            return;
        }
        try {
            String strSQL = null;
            ArrayList params = new ArrayList();
            strSQL = this.isExistsBalanceRecord() ? this.getUpdateBalanceSQLString(params) : this.getInsertBalanceSQLString(params);
            logger.debug((Object)strSQL);
            DbUtil.execute((Context)ctx, (String)strSQL, (Object[])params.toArray());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean isNeedUpdateCreditBalance() throws BOSException, EASBizException {
        boolean isNeed = false;
        CustomerInfo customer = new CustomerInfo();
        customer.setId(BOSUuid.read((String)this.customerId));
        customer = CreditUtils.readFullCustomerInfo(this.ctx, customer);
        CreditParamInfo param = CreditServerUtil.getCreditParamInfo(this.ctx, this.companyId);
        if (param != null && param.isCompnayCredited()) {
            isNeed = customer.isIsCredited();
        }
        return isNeed;
    }

    private String getUpdateBalanceSQLString(List params) {
        StringBuffer strSQL = new StringBuffer("Update T_SD_CreditBalance Set ");
        strSQL.append(this.reserveField.getValue()).append(" = ").append(this.reserveField.getValue()).append(" + ? ").append(" Where FCompanyID = ? And FCustomerID = ? And FCreditAccountID = 'DawAAAAPiJDuN4KI' ");
        params.add(this.amount);
        params.add(this.companyId);
        params.add(this.customerId);
        return strSQL.toString();
    }

    private String getInsertBalanceSQLString(List params) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Insert Into T_SD_CreditBalance(FID,FCreditAccountID,FCompanyID,FCustomerID,").append(this.reserveField.getValue()).append(") ").append(" Values(?,?,?,?) ");
        params.add(BOSUuid.create((String)"12D4D072").toString());
        params.add("DawAAAAPiJDuN4KI");
        params.add(this.companyId);
        params.add(this.customerId);
        params.add(this.amount);
        return strSQL.toString();
    }

    private boolean isExistsBalanceRecord() throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"Select FID From T_SD_CreditBalance Where FCompanyID = ? And FCustomerID = ? And FCreditAccountID = 'DawAAAAPiJDuN4KI' ", (Object[])new Object[]{this.companyId, this.customerId});
        return rs != null && rs.next();
    }

    @Override
    protected void _updateBalanceEx(Context ctx, String companyID, String customerID, CreditReserveEnum reserveField, BigDecimal amount) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateBalance(Context ctx, Object[] pks, IRowSet rs, CreditOperationEnum bizAction) throws BOSException, EASBizException {
        if (pks == null || pks.length < 1 || bizAction == null) {
            return;
        }
        long lstart = System.currentTimeMillis();
        CreditGeneralProcessor.process(ctx, pks, rs, bizAction);
        long lstop = System.currentTimeMillis();
        logger.info((Object)("update credit balance spend total time:" + (lstop - lstart)));
    }

    @Override
    protected void _updateBalance(Context ctx, Object[] pks, CreditOperationEnum bizAction) throws BOSException, EASBizException {
        this._updateBalance(ctx, pks, null, bizAction);
    }
}

