/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditExceptionRptFacadeFactory;
import com.kingdee.eas.scm.credit.CreditFileInfo;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.ICreditControlFacade;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.util.HashMap;

public final class CreditCheck {
    public static CreditCtrlResult checkSOAtSubmit(Context ctx, SaleOrderInfo so) throws BOSException, EASBizException {
        SaleOrderInfo simpleSo = new SaleOrderInfo();
        simpleSo.setId(so.getId());
        simpleSo.setCompanyOrgUnit(so.getCompanyOrgUnit());
        simpleSo.setOrderCustomer(so.getOrderCustomer());
        simpleSo.setLocalTotalTaxAmount(so.getLocalTotalTaxAmount());
        simpleSo.setBaseStatus(so.getBaseStatus());
        simpleSo.setPaymentType(so.getPaymentType());
        simpleSo.setNumber(so.getNumber());
        simpleSo.setBizDate(so.getBizDate());
        simpleSo.put("soBillAmount", (Object)so.getBigDecimal("soBillAmount"));
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(simpleSo);
        return result;
    }

    public static CreditCtrlResult checkSOAtAudit(Context ctx, SaleOrderInfo so) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(so.getId().toString(), CreditFormulaSceneEnum.ORDER);
        return result;
    }

    public static CreditCtrlResult checkSOAtUnAudit(Context ctx, SaleOrderInfo so) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(so.getId().toString(), CreditFormulaSceneEnum.ORDER);
        return result;
    }

    public static CreditCtrlResult checkSRAtSubmit(Context ctx, SaleReturnsInfo sr) throws BOSException, EASBizException {
        SaleReturnsInfo simpleSr = new SaleReturnsInfo();
        simpleSr.setId(sr.getId());
        simpleSr.setCompanyOrgUnit(sr.getCompanyOrgUnit());
        simpleSr.setOrderCustomer(sr.getReturnsCustomer());
        simpleSr.setReturnsCustomer(sr.getReturnsCustomer());
        simpleSr.setLocalTotalTaxAmount(sr.getLocalTotalTaxAmount());
        simpleSr.setBaseStatus(sr.getBaseStatus());
        simpleSr.setPaymentType(sr.getPaymentType());
        simpleSr.setNumber(sr.getNumber());
        simpleSr.setBizDate(sr.getBizDate());
        simpleSr.put("srBillAmount", (Object)sr.getBigDecimal("srBillAmount"));
        simpleSr.getEntries().addCollection(sr.getEntries());
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(simpleSr);
        return result;
    }

    public static CreditCtrlResult checkSRAtAudit(Context ctx, SaleReturnsInfo sr) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(sr.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        return result;
    }

    public static CreditCtrlResult checkSRAtDelete(Context ctx, SaleReturnsInfo sr) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtDelete(sr.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        String lockKey = sr.getCompanyOrgUnit().getId().toString() + sr.getReturnsCustomer().getId().toString();
        String companyId = sr.getCompanyOrgUnit().getId().toString();
        return result;
    }

    public static CreditCtrlResult checkSRAtUnAudit(Context ctx, SaleReturnsInfo sr) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(sr.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        return result;
    }

    public static CreditCtrlResult checkPostbillAtSubmit(Context ctx, PostRequisitionInfo bill) throws BOSException, EASBizException {
        if (bill.getSourceBillType() != null && bill.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552")) {
            return new CreditCtrlResult();
        }
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(bill);
        return result;
    }

    public static CreditCtrlResult checkPostbillAtAudit(Context ctx, PostRequisitionInfo bill) throws BOSException, EASBizException {
        if (bill.getSourceBillType() != null && bill.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-011bc0a812fd463ED552")) {
            return new CreditCtrlResult();
        }
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtAudit(bill.getId().toString(), CreditFormulaSceneEnum.POSTBILL);
        return result;
    }

    public static CreditCtrlResult checkIssuedBillAtSubmit(Context ctx, SaleIssueBillInfo issueBill) throws BOSException, EASBizException {
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
            CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(issueBill);
            return result;
        }
        return null;
    }

    public static CreditCtrlResult checkIssuedBillAtAudit(Context ctx, SaleIssueBillInfo issueBill) throws BOSException, EASBizException {
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
            CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(issueBill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
            return result;
        }
        return null;
    }

    public static CreditCtrlResult checkIssuedBillAtDelete(Context ctx, SaleIssueBillInfo issueBill) throws BOSException, EASBizException {
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
            CreditCtrlResult result = creditCtrl.verifyCreditAtDelete(issueBill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
            return result;
        }
        return null;
    }

    public static CreditCtrlResult checkIssuedBillAtUnAudit(Context ctx, SaleIssueBillInfo issueBill) throws BOSException, EASBizException {
        if (!issueBill.isIsInitBill()) {
            ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
            CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(issueBill.getId().toString(), CreditFormulaSceneEnum.ISSUEDBILL);
            return result;
        }
        return null;
    }

    public static CreditCtrlResult checkARAtSubmit(Context ctx, BillBaseInfo ar) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtSubmit(ar);
        return result;
    }

    public static CreditCtrlResult checkARAtAudit(Context ctx, BillBaseInfo ar) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtAudit(ar.getId().toString(), CreditFormulaSceneEnum.ARBILL);
        return result;
    }

    public static CreditCtrlResult checkARAtUnAudit(Context ctx, BillBaseInfo ar) throws BOSException, EASBizException {
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getLocalInstance(ctx);
        CreditCtrlResult result = creditCtrl.verifyCreditAtUnAudit(ar.getId().toString(), CreditFormulaSceneEnum.ARBILL);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(Context ctx, String billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billID == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyArSysBillAtOperation(new String[]{billID}, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(Context ctx, String[] billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billID == null || billID.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyArSysBillAtOperation(billID, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(Context ctx, IObjectValue billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billInfo == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyArSysBillAtOperation(new IObjectValue[]{billInfo}, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkArSysBillAtOperation(Context ctx, IObjectValue[] billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billInfo == null || billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyArSysBillAtOperation(billInfo, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(Context ctx, String billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billID == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyApSysBillAtOperation(new String[]{billID}, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(Context ctx, String[] billID, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billID == null || billID.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyApSysBillAtOperation(billID, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(Context ctx, IObjectValue billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billInfo == null) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyApSysBillAtOperation(new IObjectValue[]{billInfo}, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkApSysBillAtOperation(Context ctx, IObjectValue[] billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billInfo == null || billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyApSysBillAtOperation(billInfo, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkCreditFileAtAlter(Context ctx, CreditFileInfo[] billInfo, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billInfo == null || billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyCreditFileAtAlter((IObjectValue[])billInfo, operation, direction, billType);
        return result;
    }

    public static CreditCtrlResult checkCreditFileAtOperate(Context ctx, String[] billIDs, CreditFormulaSceneEnum billType, CreditOperationEnum operation, CreditDirectionEnum direction) throws BOSException, EASBizException {
        if (billIDs == null || billIDs.length == 0) {
            return new CreditCtrlResult();
        }
        CreditCtrlResult result = CreditControlFacadeFactory.getLocalInstance(ctx).verifyCreditFileAtOperation(billIDs, operation, direction, billType);
        return result;
    }

    public static void addExceptionRecord(Context ctx, CoreBillBaseInfo billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws EASBizException, BOSException {
        CreditExceptionRptFacadeFactory.getLocalInstance(ctx).addExceptionRecord(billInfo, billType, result, operation);
    }

    public static void addExceptionRecord(Context ctx, CoreBillBaseInfo[] billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws EASBizException, BOSException {
        if (billInfo == null || billInfo.length == 0) {
            return;
        }
        HashMap<String, String> billMap = new HashMap<String, String>();
        int length = billInfo.length;
        for (int i = 0; i < length; ++i) {
            if (billInfo[i].getId() != null) {
                if (billInfo[i].getNumber() != null) {
                    billMap.put(billInfo[i].getId().toString(), billInfo[i].getNumber());
                    continue;
                }
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("number"));
                BillBaseInfo info = (BillBaseInfo)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(billInfo[i].getId()), (SelectorItemCollection)selectors);
                billMap.put(billInfo[i].getId().toString(), info.getNumber());
                continue;
            }
            if (billInfo[i].getNumber() == null) continue;
            billMap.put(billInfo[i].getNumber(), billInfo[i].getNumber());
        }
        if (billMap.size() == 0) {
            return;
        }
        CreditExceptionRptFacadeFactory.getLocalInstance(ctx).addExceptionRecord(billMap, billType, result, operation);
    }

    public static void addExceptionRecord(Context ctx, DataBaseInfo[] billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws EASBizException, BOSException {
        if (billInfo == null || billInfo.length == 0) {
            return;
        }
        HashMap<String, String> billMap = new HashMap<String, String>();
        int length = billInfo.length;
        for (int i = 0; i < length; ++i) {
            if (billInfo[i].getId() == null) continue;
            billMap.put(billInfo[i].getId().toString(), billInfo[i].getNumber() == null ? "" : billInfo[i].getNumber());
        }
        if (billMap.size() == 0) {
            return;
        }
        CreditExceptionRptFacadeFactory.getLocalInstance(ctx).addExceptionRecord(billMap, billType, result, operation);
    }
}

