/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditInitFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.InitCreditBalanceInfo;
import com.kingdee.eas.scm.credit.app.AbstractCreditControlFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.control.ApSysBillCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.ArSysBillCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlBaseStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.app.balance.control.CreditFileAlterCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.PostRequisitionCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.ReceivableCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.SaleIssueCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.SaleOrderCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.control.SaleReturnsCreditControlStrategy;
import com.kingdee.eas.scm.credit.app.balance.strategy.ReceivableUpdateStrategy;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CreditControlFacadeControllerBean
extends AbstractCreditControlFacadeControllerBean {
    private static final long serialVersionUID = 6431617339108399777L;

    @Override
    protected void _createCreditBalanceByCustomer(Context ctx, List customer) throws BOSException, EASBizException {
        CreditInitFacadeFactory.getLocalInstance(ctx).createCreditBalance(null, customer);
    }

    @Override
    protected void _createCreditBalanceByCompany(Context ctx, List company) throws BOSException, EASBizException {
        String companyId;
        if (company != null && company.size() == 1 && CreditServerUtil.isCreditParamG00X(ctx, "", "G005") && (companyId = (String)company.get(0)).equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            String localString = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String sp = " \r\n";
            StringBuffer strSQL = new StringBuffer();
            strSQL.append("SELECT DISTINCT t0.FID").append(sp);
            strSQL.append("FROM t_org_company t0 ").append(sp);
            strSQL.append("    INNER JOIN T_Bas_ParamItem pit ON t0.fid = pit.FOrgUnitID ").append(sp);
            strSQL.append("    INNER JOIN T_Bas_Param p ON pit.FKeyID = p.FID ").append(sp);
            strSQL.append("WHERE (p.FNumber = 'G004') ").append(sp);
            strSQL.append("  AND (ISNULL(pit.FValue_").append(localString).append(", 'false') = 'true')").append(sp);
            strSQL.append(" AND t0.FIsBizunit = 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[0]);
            if (rs != null) {
                company.clear();
                try {
                    while (rs.next()) {
                        company.add(rs.getString("FID"));
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        CreditInitFacadeFactory.getLocalInstance(ctx).createCreditBalance(company, null);
    }

    @Override
    protected void _createCreditBalance(Context ctx, String company, List customer) throws BOSException, EASBizException {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add(company);
        CreditInitFacadeFactory.getLocalInstance(ctx).createCreditBalance(ls, customer);
    }

    @Override
    protected void _createCreditBalance(Context ctx, List company, String customer) throws BOSException, EASBizException {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add(customer);
        CreditInitFacadeFactory.getLocalInstance(ctx).createCreditBalance(company, ls);
    }

    @Override
    protected void _createCreditBalanceByCompanyCustomer(Context ctx, List params) throws BOSException, EASBizException {
        if (params == null || params.size() < 1) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i) == null || !(params.get(i) instanceof InitCreditBalanceInfo)) continue;
            InitCreditBalanceInfo paramInfo = (InitCreditBalanceInfo)params.get(i);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("customer.number", (Object)paramInfo.getCustomer().getNumber(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)paramInfo.getCompany().getId().toString(), CompareType.INCLUDE));
            view.setFilter(filterInfo);
            CustomerCompanyInfoCollection collection = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfoCollection(view);
            if (collection == null || collection.size() <= 0 || collection.get(0) == null || collection.get(0).getCustomer() == null) continue;
            CreditInitFacadeFactory.getLocalInstance(ctx).createCreditBalanceForOneCustom(paramInfo.getCompany().getId().toString(), collection.get(0).getCustomer().getId().toString());
        }
    }

    @Override
    protected CreditCtrlResult _verifyCreditAtSubmit(Context ctx, Object billInfo) throws BOSException, EASBizException {
        if (billInfo == null) {
            return null;
        }
        CreditFormulaSceneEnum scene = CreditFormulaSceneEnum.ORDER;
        CreditControlBaseStrategy strategy = null;
        if (billInfo instanceof SaleOrderInfo) {
            scene = CreditFormulaSceneEnum.ORDER;
            strategy = new SaleOrderCreditControlStrategy();
        } else if (billInfo instanceof SaleIssueBillInfo) {
            scene = CreditFormulaSceneEnum.ISSUEDBILL;
            strategy = new SaleIssueCreditControlStrategy();
        } else if (billInfo instanceof PostRequisitionInfo) {
            scene = CreditFormulaSceneEnum.POSTBILL;
            strategy = new PostRequisitionCreditControlStrategy();
        } else if (billInfo instanceof SaleReturnsInfo) {
            scene = CreditFormulaSceneEnum.SALERETURN;
            strategy = new SaleReturnsCreditControlStrategy();
        } else if (!(billInfo instanceof NetOrderBillInfo) && billInfo instanceof BillBaseInfo) {
            scene = CreditFormulaSceneEnum.ARBILL;
            strategy = new ReceivableCreditControlStrategy();
        }
        if (strategy == null) {
            return new CreditCtrlResult();
        }
        return strategy.verifyCredit(ctx, billInfo, scene, CreditOperationEnum.SUBMIT, CreditDirectionEnum.ADD);
    }

    @Override
    protected CreditCtrlResult _verifyCreditAtAudit(Context ctx, String billId, CreditFormulaSceneEnum creditScene) throws BOSException, EASBizException {
        CreditControlBaseStrategy strategy = null;
        if (creditScene.equals((Object)CreditFormulaSceneEnum.ORDER)) {
            strategy = new SaleOrderCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.POSTBILL)) {
            strategy = new PostRequisitionCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.ISSUEDBILL)) {
            strategy = new SaleIssueCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.ARBILL)) {
            strategy = new ReceivableCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.SALERETURN)) {
            strategy = new SaleReturnsCreditControlStrategy();
        }
        if (strategy == null) {
            return new CreditCtrlResult();
        }
        return strategy.verifyCredit(ctx, billId, creditScene, CreditOperationEnum.AUDIT, CreditDirectionEnum.ADD);
    }

    @Override
    protected CreditCtrlResult _verifyCreditAtUnAudit(Context ctx, String billId, CreditFormulaSceneEnum creditScene) throws BOSException, EASBizException {
        CreditControlBaseStrategy strategy = null;
        if (creditScene.equals((Object)CreditFormulaSceneEnum.ORDER)) {
            strategy = new SaleOrderCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.POSTBILL)) {
            strategy = new PostRequisitionCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.ISSUEDBILL)) {
            strategy = new SaleIssueCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.ARBILL)) {
            strategy = new ReceivableCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.SALERETURN)) {
            strategy = new SaleReturnsCreditControlStrategy();
        }
        if (strategy == null) {
            return new CreditCtrlResult();
        }
        return strategy.verifyCredit(ctx, billId, creditScene, CreditOperationEnum.UNAUDIT, CreditDirectionEnum.LESS);
    }

    @Override
    protected CreditCtrlResult _verifyCreditAtDelete(Context ctx, String billId, CreditFormulaSceneEnum creditScene) throws BOSException, EASBizException {
        CreditControlBaseStrategy strategy = null;
        if (creditScene.equals((Object)CreditFormulaSceneEnum.ORDER)) {
            strategy = new SaleOrderCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.POSTBILL)) {
            strategy = new PostRequisitionCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.ISSUEDBILL)) {
            strategy = new SaleIssueCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.ARBILL)) {
            strategy = new ReceivableCreditControlStrategy();
        } else if (creditScene.equals((Object)CreditFormulaSceneEnum.SALERETURN)) {
            strategy = new SaleReturnsCreditControlStrategy();
        }
        if (strategy == null) {
            return new CreditCtrlResult();
        }
        return strategy.verifyCredit(ctx, billId, creditScene, CreditOperationEnum.DELETE, CreditDirectionEnum.LESS);
    }

    @Override
    protected CreditCtrlResult _verifyArSysBillAtOperation(Context ctx, String[] billID, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        ArSysBillCreditControlStrategy strategy = new ArSysBillCreditControlStrategy(billType);
        if (billID.length == 0) {
            return new CreditCtrlResult();
        }
        int length = billID.length;
        ArrayList<CreditCtrlResult> creditList = new ArrayList<CreditCtrlResult>();
        CreditCtrlResult result = null;
        boolean isOverspend = false;
        for (int i = 0; i < length; ++i) {
            if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(billID[i]))) {
                BillBaseInfo billInfo = (BillBaseInfo)CreditControlHelper.readFullARBillInfo(ctx, billID[i]);
                result = this.verifyArOtherBill(ctx, billInfo, operation, direction, billType);
                if (!result.isOverspend()) continue;
                isOverspend = result.isOverspend();
                creditList.add(result);
                continue;
            }
            result = strategy.verifyCredit(ctx, billID[i], CreditFormulaSceneEnum.ARSYSBILL, operation, direction);
            if (!result.isOverspend()) continue;
            isOverspend = result.isOverspend();
            creditList.add(result);
        }
        result = new CreditCtrlResult();
        result.setOverspend(isOverspend);
        if (creditList.size() > 0) {
            result.setCreditResult(creditList.toArray());
        }
        return result;
    }

    @Override
    protected CreditCtrlResult _verifyArSysBillAtOperation(Context ctx, IObjectValue[] billInfo, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        ArSysBillCreditControlStrategy strategy = new ArSysBillCreditControlStrategy(billType);
        if (billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        int length = billInfo.length;
        CreditCtrlResult result = null;
        boolean isOverspend = false;
        boolean isTimeOut = false;
        ArrayList<CreditCtrlResult> creditList = new ArrayList<CreditCtrlResult>();
        for (int i = 0; i < length; ++i) {
            if (billInfo[i] instanceof BillBaseInfo) {
                BillBaseInfo info = (BillBaseInfo)billInfo[i];
                if (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType(info.getBOSType()))) {
                    result = this.verifyArOtherBill(ctx, info, operation, direction, billType);
                    if (!result.isOverspend() && !result.isTimeout()) continue;
                    isOverspend = result.isOverspend();
                    isTimeOut = result.isTimeout();
                    creditList.add(result);
                    continue;
                }
                result = strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.ARSYSBILL, operation, direction);
                if (!result.isOverspend() && !result.isTimeout()) continue;
                isOverspend = result.isOverspend();
                isTimeOut = result.isTimeout();
                creditList.add(result);
                continue;
            }
            result = strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.ARSYSBILL, operation, direction);
            if (!result.isOverspend()) continue;
            isOverspend = result.isOverspend();
            isTimeOut = result.isTimeout();
            creditList.add(result);
        }
        result = new CreditCtrlResult();
        result.setOverspend(isOverspend);
        result.setTimeout(isTimeOut);
        result.setBillType(billType);
        result.setBillInfos(billInfo);
        if (creditList.size() > 0) {
            result.setCreditResult(creditList.toArray());
        }
        return result;
    }

    @Override
    protected CreditCtrlResult _verifyApSysBillAtOperation(Context ctx, String[] billID, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        if (billID.length == 0) {
            return new CreditCtrlResult();
        }
        ApSysBillCreditControlStrategy strategy = new ApSysBillCreditControlStrategy(billType);
        CreditCtrlResult result = null;
        int length = billID.length;
        ArrayList<CreditCtrlResult> creditList = new ArrayList<CreditCtrlResult>();
        boolean isOverspend = false;
        for (int i = 0; i < length; ++i) {
            result = strategy.verifyCredit(ctx, billID[i], CreditFormulaSceneEnum.APSYSBILL, operation, direction);
            if (!result.isOverspend()) continue;
            isOverspend = result.isOverspend();
            creditList.add(result);
        }
        result = new CreditCtrlResult();
        result.setOverspend(isOverspend);
        if (creditList.size() > 0) {
            result.setCreditResult(creditList.toArray());
        }
        return result;
    }

    @Override
    protected CreditCtrlResult _verifyApSysBillAtOperation(Context ctx, IObjectValue[] billInfo, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        if (billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        ApSysBillCreditControlStrategy strategy = new ApSysBillCreditControlStrategy(billType);
        CreditCtrlResult result = null;
        int length = billInfo.length;
        ArrayList<CreditCtrlResult> creditList = new ArrayList<CreditCtrlResult>();
        boolean isOverspend = false;
        for (int i = 0; i < length; ++i) {
            result = strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.APSYSBILL, operation, direction);
            if (!result.isOverspend()) continue;
            isOverspend = result.isOverspend();
            creditList.add(result);
        }
        result = new CreditCtrlResult();
        result.setOverspend(isOverspend);
        result.setBillType(billType);
        result.setBillInfos(billInfo);
        if (creditList.size() > 0) {
            result.setCreditResult(creditList.toArray());
        }
        return result;
    }

    @Override
    protected void _verifyAPSysBillAtOperationForListUI(Context ctx, IObjectValue[] billInfo, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        if (billInfo.length == 0) {
            return;
        }
        ApSysBillCreditControlStrategy strategy = new ApSysBillCreditControlStrategy(billType);
        CreditCtrlResult result = null;
        int length = billInfo.length;
        StringBuffer resultparams = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            result = strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.APSYSBILL, operation, direction);
            if (result == null || !result.isOverspend() || result.getMsgBody() == null) continue;
            resultparams.append(result.getMsgBody());
        }
        if (resultparams.length() > 0) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)"BILL_OPERATION", (Locale)ctx.getLocale());
            str = str.replaceAll("OPERATION", operation.getAlias());
            resultparams.append(str).append("\r\n");
            resultparams.append(ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)"CANCEL_OPT", (Locale)ctx.getLocale()));
            throw new CreditControlException(CreditControlException.OVER_SPEND, new String[]{resultparams.toString()});
        }
    }

    @Override
    protected void _verifyArSysBillAtOperationForListUI(Context ctx, IObjectValue[] billInfo, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        if (billInfo.length == 0) {
            return;
        }
        ArSysBillCreditControlStrategy strategy = new ArSysBillCreditControlStrategy(billType);
        CreditCtrlResult result = null;
        int length = billInfo.length;
        StringBuffer resultparams = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            BillBaseInfo info;
            result = billInfo[i] instanceof BillBaseInfo ? (CreditFormulaSceneEnum.ARBILL.equals((Object)CreditUtils.getBillTypeByBosType((info = (BillBaseInfo)billInfo[i]).getBOSType())) ? this.verifyArOtherBill(ctx, info, operation, direction, billType) : strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.ARSYSBILL, operation, direction)) : strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.ARSYSBILL, operation, direction);
            if (result == null || !result.isOverspend() || result.getMsgBody() == null) continue;
            resultparams.append(result.getMsgBody());
        }
        if (resultparams.length() > 0) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)"BILL_OPERATION", (Locale)ctx.getLocale());
            str = str.replaceAll("OPERATION", operation.getAlias());
            resultparams.append(str).append("\r\n");
            resultparams.append(ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)"CANCEL_OPT", (Locale)ctx.getLocale()));
            throw new CreditControlException(CreditControlException.OVER_SPEND, new String[]{resultparams.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreditCtrlResult verifyArOtherBill(Context ctx, BillBaseInfo info, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws EASBizException, BOSException {
        CreditControlBaseStrategy strategy = new ArSysBillCreditControlStrategy(billType);
        String companyID = info.getCompany().getId().toString();
        IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("Value"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.number"));
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> numberSet = new HashSet<String>();
        numberSet.add("CreditParam04");
        numberSet.add("CreditParam06");
        numberSet.add("CreditParam041");
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", numberSet, CompareType.INCLUDE));
        Map paramMap = CreditServerUtil.isCreditParamG00X(ctx, companyID);
        if ("true".equals(paramMap.get("G005"))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)companyID, CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
        boolean isCtrlArAmount = false;
        boolean isCtrlArTimelimit = false;
        boolean isCtrlAtAudit = false;
        boolean isCtrlAtSubmit = false;
        CreditCtrlResult result = null;
        if (collection != null && collection.size() > 0) {
            ParamItemInfo itemInfo = null;
            int size = collection.size();
            for (int j = 0; j < size; ++j) {
                itemInfo = collection.get(j);
                if ("CreditParam04".equalsIgnoreCase(itemInfo.getKeyID().getNumber()) && (Boolean.valueOf(itemInfo.getValue()).booleanValue() || "1".equals(itemInfo.getValue()))) {
                    isCtrlArAmount = true;
                }
                if ("CreditParam041".equalsIgnoreCase(itemInfo.getKeyID().getNumber()) && (Boolean.valueOf(itemInfo.getValue()).booleanValue() || "1".equals(itemInfo.getValue()))) {
                    isCtrlArTimelimit = true;
                }
                if (!"CreditParam06".equalsIgnoreCase(itemInfo.getKeyID().getNumber())) continue;
                if (2 == Integer.parseInt(itemInfo.getValue())) {
                    isCtrlAtAudit = true;
                    continue;
                }
                isCtrlAtSubmit = true;
            }
        }
        if (isCtrlArAmount && isCtrlAtAudit) {
            if (CreditOperationEnum.CREDITORTRANS == operation || CreditOperationEnum.CANCELCREDITORTRANS == operation || CreditOperationEnum.ALLOWANCE == operation || CreditOperationEnum.CANCELALLOWANCE == operation || CreditOperationEnum.REVERSE == operation || CreditOperationEnum.CANCELREVERSE == operation) {
                result = strategy.verifyCredit(ctx, info, CreditFormulaSceneEnum.ARSYSBILL, operation, direction);
            } else {
                strategy = new ReceivableCreditControlStrategy();
                result = strategy.verifyCredit(ctx, info, CreditFormulaSceneEnum.ARBILL, operation, direction);
            }
        } else if ((isCtrlArAmount || isCtrlArTimelimit) && isCtrlAtSubmit && (1 == operation.getValue() || 4 == operation.getValue())) {
            strategy = new ReceivableCreditControlStrategy();
            result = strategy.verifyCredit(ctx, info, CreditFormulaSceneEnum.ARBILL, operation, direction);
        } else if (!isCtrlArAmount && 1 != operation.getValue() && 4 != operation.getValue()) {
            IObjectCollection entryColl = (IObjectCollection)info.get("entry");
            boolean coreBill = false;
            for (int j = 0; j < entryColl.size(); ++j) {
                BillTypeInfo billtypeInfo = (BillTypeInfo)entryColl.getObject(j).get("coreBillType");
                if (billtypeInfo == null || billtypeInfo.getId() == null || !billtypeInfo.getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") && !billtypeInfo.getId().toString().equals("50957179-0105-1000-e008-8152c0a812fd463ED552")) continue;
                coreBill = true;
                break;
            }
            if (coreBill && (operation == CreditOperationEnum.AUDIT || operation == CreditOperationEnum.UNAUDIT || operation == CreditOperationEnum.REVERSE || operation == CreditOperationEnum.CANCELREVERSE)) {
                String tableName;
                BOSObjectType objType = BOSUuid.getBOSObjectType((String)info.getId().toString(), (boolean)true);
                String bosType = CreditUpdateHelper.getBosType(objType);
                String prefix = "billEntry";
                if (objType.toString().equals(bosType)) {
                    prefix = "bill";
                }
                if ((tableName = CreditUpdateHelper.init(ctx, new Object[]{info.getId()}, prefix, bosType)) != null && tableName.trim().length() >= 1) {
                    HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                    paramsMap.put("bizAction", (Object)operation);
                    paramsMap.put("tableName", tableName);
                    paramsMap.put("arBillCtrl", true);
                    paramsMap.put("bosType", bosType);
                    ReceivableUpdateStrategy updateStrategy = null;
                    updateStrategy = new ReceivableUpdateStrategy(ctx, paramsMap);
                    updateStrategy.preProcess();
                    updateStrategy.preCheck();
                    if (operation == CreditOperationEnum.AUDIT || operation == CreditOperationEnum.REVERSE) {
                        updateStrategy.processCreditBalanceAtAuditCheck();
                    } else {
                        updateStrategy.processCreditBalanceAtUnAudit();
                    }
                    String selectSql = updateStrategy.getSelectBalanceTempTableSql();
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
                    try {
                        BigDecimal arAmount = info.getBigDecimal("amountLocal");
                        while (rs.next()) {
                            if (rs.getBigDecimal("FUnArBillOrderAmt") != null && SCMConstant.BIGDECIMAL_ZERO.compareTo(rs.getBigDecimal("FUnArBillOrderAmt")) != 0) {
                                if (operation == CreditOperationEnum.AUDIT || operation == CreditOperationEnum.REVERSE) {
                                    arAmount = arAmount.add(rs.getBigDecimal("FUnArBillOrderAmt"));
                                    continue;
                                }
                                arAmount = arAmount.subtract(rs.getBigDecimal("FUnArBillOrderAmt"));
                                continue;
                            }
                            if (rs.getBigDecimal("FUnArBillIssuedAmt") == null || SCMConstant.BIGDECIMAL_ZERO.compareTo(rs.getBigDecimal("FUnArBillIssuedAmt")) == 0) continue;
                            if (operation == CreditOperationEnum.AUDIT || operation == CreditOperationEnum.REVERSE) {
                                arAmount = arAmount.add(rs.getBigDecimal("FUnArBillIssuedAmt"));
                                continue;
                            }
                            arAmount = arAmount.subtract(rs.getBigDecimal("FUnArBillIssuedAmt"));
                        }
                        info.setBigDecimal("amountLocal", arAmount);
                    }
                    catch (SQLException e) {
                        Logger.error((Throwable)e, (String)("sql is :" + selectSql));
                    }
                    finally {
                        if (updateStrategy != null) {
                            updateStrategy.releaseTable();
                        }
                    }
                }
            }
            result = strategy.verifyCredit(ctx, info, CreditFormulaSceneEnum.ARSYSBILL, operation, direction);
        } else {
            result = new CreditCtrlResult();
        }
        return result;
    }

    @Override
    protected CreditCtrlResult _verifyCreditFileAtAlter(Context ctx, IObjectValue[] billInfo, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        if (billInfo.length == 0) {
            return new CreditCtrlResult();
        }
        CreditFileAlterCreditControlStrategy strategy = new CreditFileAlterCreditControlStrategy();
        CreditCtrlResult result = null;
        int length = billInfo.length;
        ArrayList<CreditCtrlResult> creditList = new ArrayList<CreditCtrlResult>();
        boolean isOverspend = false;
        for (int i = 0; i < length; ++i) {
            result = strategy.verifyCredit(ctx, billInfo[i], CreditFormulaSceneEnum.CREDITFILE, operation, direction);
            if (!result.isOverspend()) continue;
            isOverspend = result.isOverspend();
            creditList.add(result);
        }
        result = new CreditCtrlResult();
        result.setOverspend(isOverspend);
        if (creditList.size() > 0) {
            result.setCreditResult(creditList.toArray());
        }
        return result;
    }

    @Override
    protected CreditCtrlResult _verifyCreditFileAtOperation(Context ctx, String[] billIDs, CreditOperationEnum operation, CreditDirectionEnum direction, CreditFormulaSceneEnum billType) throws BOSException, EASBizException {
        if (billIDs.length == 0) {
            return new CreditCtrlResult();
        }
        CreditFileAlterCreditControlStrategy strategy = new CreditFileAlterCreditControlStrategy();
        CreditCtrlResult result = null;
        int length = billIDs.length;
        ArrayList<CreditCtrlResult> creditList = new ArrayList<CreditCtrlResult>();
        boolean isOverspend = false;
        for (int i = 0; i < length; ++i) {
            result = strategy.verifyCredit(ctx, billIDs[i], CreditFormulaSceneEnum.CREDITFILE, operation, direction);
            if (!result.isOverspend()) continue;
            isOverspend = result.isOverspend();
            creditList.add(result);
        }
        result = new CreditCtrlResult();
        result.setOverspend(isOverspend);
        if (creditList.size() > 0) {
            result.setCreditResult(creditList.toArray());
        }
        return result;
    }

    @Override
    protected CreditCtrlResult _verifyCredit(Context ctx, CreditCondition creditcondition) throws BOSException, EASBizException {
        CustomerInfo customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(creditcondition.getCustomer().getId()));
        creditcondition.setCompany(CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, (OrgUnitInfo)creditcondition.getCompany()));
        creditcondition.setCustomer(customer);
        SaleIssueCreditControlStrategy strategy = new SaleIssueCreditControlStrategy();
        return strategy.verifyCredit(ctx, creditcondition);
    }
}

