/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.AbstractCreditExceptionRptFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditExceptionRptFacadeControllerBean
extends AbstractCreditExceptionRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditExceptionRptFacadeControllerBean");
    private String LNAME = "_L2";
    private String sp = "\r\n";

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        SimpleDateFormat sdf;
        this.LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("");
        sql.append(" select company.FNAME").append(this.LNAME).append(" FCompanyName,case when customer.FID is not null then customer.FNAME").append(this.LNAME).append(" else supplier.FNAME").append(this.LNAME).append(" end  FCustomerName,creditExc.FBillType,creditExc.FBillNumber,creditExc.FCreditOperation,").append(this.sp);
        sql.append(" operator.FNAME").append(this.LNAME).append(" FOperatorName,creditExc.FOperateTime,creditExc.FControlMode,creditExc.FCreditBalanceBefore,creditExc.FCreditBalanceAfter,creditExc.FRemark").append(this.sp);
        sql.append(" FROM T_SD_CreditException creditExc ").append(this.sp);
        sql.append(" LEFT OUTER JOIN T_ORG_COMPANY company on creditExc.FCompanyID = company.FID ").append(this.sp);
        sql.append(" LEFT OUTER JOIN T_BD_CUSTOMER customer on creditExc.FCustomerID = customer.FID").append(this.sp);
        sql.append(" LEFT OUTER JOIN T_BD_SUPPLIER supplier on creditExc.FCustomerID = supplier.FID").append(this.sp);
        sql.append(" LEFT OUTER JOIN T_PM_User operator on creditExc.FOperatorID = operator.FID").append(this.sp);
        sql.append(" where 1=1 ");
        if (params.containsKey("company") && params.getObject("company") instanceof CompanyOrgUnitInfo) {
            String companyId = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
            Boolean flag = CreditServerUtil.getAuthorizedOrgUnit(ctx, companyId, "CreditException_view");
            if (flag.booleanValue()) {
                sql.append(" and company.fid = '" + ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() + "'");
            } else {
                sql.append(" and company.fid = 'xxx'");
            }
        }
        if (params.containsKey("operateTimeFrom") && params.getObject("operateTimeFrom") != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql.append(" and creditExc.FOperateTime >= to_date('").append(sdf.format(CreditUtils.getStartDate((Date)params.getObject("operateTimeFrom")))).append("')");
        }
        if (params.containsKey("operateTimeTo") && params.getObject("operateTimeTo") != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql.append(" and creditExc.FOperateTime < to_date('").append(sdf.format(CreditUtils.getEndDate((Date)params.getObject("operateTimeTo")))).append("')");
        }
        boolean querySupplier = false;
        StringBuffer whereSql = new StringBuffer("");
        StringBuffer customerWhere = new StringBuffer("");
        if (params.containsKey("customerFrom") && params.getString("customerFrom") != null) {
            customerWhere.append(" customer.Fnumber >= '").append(params.getString("customerFrom")).append("'");
            whereSql.append(" where customer.Fnumber >= '").append(params.getString("customerFrom")).append("'");
            querySupplier = true;
        }
        if (params.containsKey("customerTo") && params.getString("customerTo") != null) {
            if (customerWhere.length() > 0) {
                customerWhere.append(" and customer.Fnumber <= '").append(params.getString("customerTo")).append("'");
            } else {
                customerWhere.append(" customer.Fnumber <= '").append(params.getString("customerTo")).append("'");
            }
            if (whereSql.length() > 0) {
                whereSql.append(" and customer.Fnumber <= '").append(params.getString("customerTo")).append("'");
            } else {
                whereSql.append(" where customer.Fnumber <= '").append(params.getString("customerTo")).append("'");
            }
            querySupplier = true;
        }
        if (querySupplier) {
            StringBuffer querySql = new StringBuffer("");
            querySql.append(" or creditExc.FCustomerID in (");
            querySql.append(" select supplier.fid from T_BD_SUPPLIER supplier INNER JOIN ").append(this.sp);
            querySql.append(" (select bz.FID FROM T_SD_CreditException creditExc  ").append(this.sp);
            querySql.append("  LEFT OUTER JOIN T_BD_CUSTOMER customer on creditExc.FCustomerID = customer.FID  ").append(this.sp);
            querySql.append("  LEFT OUTER JOIN T_BD_BizAnaylysisCode bz on customer.FBizAnalysisCodeID = bz.FID ").append(this.sp);
            querySql.append(whereSql).append(this.sp);
            querySql.append(" group by bz.FID ) bizcode on supplier.FBizAnalysisCodeID = bizcode.fid)");
            customerWhere.append(querySql);
            sql.append(" and (").append(customerWhere).append(")");
        }
        if (params.containsKey("billType") && params.getInt("billType") != -1) {
            sql.append(" and creditExc.FBillType = ").append(params.getInt("billType"));
        }
        if (params.containsKey("billNumber") && params.getString("billNumber") != null) {
            sql.append(" and creditExc.FBillNumber like '%").append(params.getString("billNumber")).append("%'");
        }
        sql.append(" order by creditExc.FOperateTime desc,creditExc.FBillNumber desc ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    @Override
    protected void _addExceptionRecord(Context ctx, IObjectValue billInfo, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws BOSException, EASBizException {
        String number;
        if (!result.isOverspend() || result.getCreditResult().length == 0) {
            return;
        }
        if (billInfo == null) {
            return;
        }
        result = (CreditCtrlResult)result.getCreditResult()[0];
        StringBuffer sql = new StringBuffer("");
        sql.append("Insert into T_SD_CreditException(");
        sql.append("FID,FCustomerID ,FCompanyID ,FBillType,FBillID ,FBillNumber,FCreditOperation,FOperatorID ,FOperateTime,FControlMode,FCreditBalanceBefore,FCreditBalanceAfter,FRemark)");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String operatorID = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).get("id").toString();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(14, 0);
        Timestamp date = new Timestamp(cal.getTime().getTime());
        String billID = billInfo.get("id") == null ? "" : billInfo.get("id").toString();
        String string = number = billInfo.get("number") == null ? null : billInfo.get("number").toString();
        if (number == null && result.getBillInfo() != null) {
            number = result.getBillInfo().getNumber();
        }
        if (number == null && !"".equals(billID)) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("number"));
            BillBaseInfo info = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billID), (SelectorItemCollection)selectors);
            number = info.getNumber();
        }
        String remark = "";
        if (result.getBizCodeInfo() != null && result.getBizCodeInfo().getId() != null) {
            remark = ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditFileResource", (String)"bizcode", (Locale)ctx.getLocale()) + "\uff1a" + result.getBizCodeInfo().getNumber() + "(" + result.getBizCodeInfo().getName() + ")";
        }
        Object[] params = new Object[]{BOSUuid.create((String)"18F58F66").toString(), result.getCustomerId(), result.getCompanyId(), billType.getValue(), billID, number, operation.getValue(), operatorID, date, result.getCreditCtrlMode().getValue(), result.getCreditBalanceBefore(), result.getCreditBalanceAfter(), remark};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }

    @Override
    protected void _addExceptionRecord(Context ctx, Map billMap, CreditFormulaSceneEnum billType, CreditCtrlResult result, CreditOperationEnum operation) throws BOSException {
        if (!result.isOverspend()) {
            return;
        }
        if (billMap == null || billMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("");
        sql.append("Insert into T_SD_CreditException(");
        sql.append("FID,FCustomerID ,FCompanyID ,FBillType,FBillID ,FBillNumber,FCreditOperation,FOperatorID ,FOperateTime,FControlMode,FCreditBalanceBefore,FCreditBalanceAfter,FRemark)");
        sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        Iterator iter = billMap.keySet().iterator();
        String billID = null;
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String operatorID = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).get("id").toString();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(14, 0);
        Timestamp date = new Timestamp(cal.getTime().getTime());
        String remark = "";
        Object[] obj = result.getCreditResult();
        CreditCtrlResult creditResult = null;
        while (iter.hasNext()) {
            billID = iter.next().toString();
            if (obj != null && obj.length > 0) {
                int length = obj.length;
                for (int i = 0; i < length; ++i) {
                    creditResult = (CreditCtrlResult)obj[i];
                    if (creditResult.getBillInfo() != null) {
                        if (creditResult.getBillInfo().getId() != null && creditResult.getBillInfo().getId().toString().equals(billID) || billID != null && billID.equals(creditResult.getBillInfo().getNumber())) break;
                        creditResult = null;
                        continue;
                    }
                    if (creditResult.getCreditFile() == null) continue;
                    if (creditResult.getCreditFile().getId() != null && creditResult.getCreditFile().getId().toString().equals(billID) || billID != null && billID.equals(creditResult.getCreditFile().getNumber())) break;
                    creditResult = null;
                }
            }
            if (creditResult == null) {
                creditResult = result;
            }
            if (creditResult.getBizCodeInfo() != null && creditResult.getBizCodeInfo().getId() != null) {
                remark = ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditFileResource", (String)"bizcode", (Locale)ctx.getLocale()) + "\uff1a" + creditResult.getBizCodeInfo().getNumber() + "(" + creditResult.getBizCodeInfo().getName() + ")";
            }
            Object[] params = new Object[]{BOSUuid.create((String)"18F58F66").toString(), creditResult.getCustomerId(), creditResult.getCompanyId(), billType.getValue(), billID, billMap.get(billID), operation.getValue(), operatorID, date, creditResult.getCreditCtrlMode().getValue(), creditResult.getCreditBalanceBefore(), creditResult.getCreditBalanceAfter(), remark};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }
}

