/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditFileAlterRecordEntryInfo;
import com.kingdee.eas.scm.credit.CreditFileAlterRecordFactory;
import com.kingdee.eas.scm.credit.CreditFileAlterRecordInfo;
import com.kingdee.eas.scm.credit.CreditFileBaseStatusEnum;
import com.kingdee.eas.scm.credit.CreditFileCollection;
import com.kingdee.eas.scm.credit.CreditFileException;
import com.kingdee.eas.scm.credit.CreditFileFactory;
import com.kingdee.eas.scm.credit.CreditFileInfo;
import com.kingdee.eas.scm.credit.CreditFileTypeEnum;
import com.kingdee.eas.scm.credit.app.AbstractCreditFileControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditFileControllerBean
extends AbstractCreditFileControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditFileControllerBean");
    private static final String sp = "\r\n";
    private static String LNAME = "_L2";

    @Override
    protected boolean _checkDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        CreditFileInfo cfInfo = (CreditFileInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterType = new FilterItemInfo("creditFileType", (Object)cfInfo.getCreditFileType(), CompareType.EQUALS);
        filter.getFilterItems().add(filterType);
        FilterItemInfo filterCompany = new FilterItemInfo("companyOrgUnit.id", (Object)cfInfo.getCompanyOrgUnit().getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterCompany);
        FilterItemInfo filterCurrency = new FilterItemInfo("currency.id", (Object)cfInfo.getCurrency().getId(), CompareType.EQUALS);
        filter.getFilterItems().add(filterCurrency);
        FilterItemInfo filterBaseStatus = new FilterItemInfo("baseStatus", (Object)CreditFileBaseStatusEnum.INVALID, CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterBaseStatus);
        if (cfInfo.getCreditFileType().equals((Object)CreditFileTypeEnum.CUSTOMER)) {
            FilterItemInfo filterCustomer = new FilterItemInfo("customer.id", (Object)cfInfo.getCustomer().getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterCustomer);
        } else if (cfInfo.getCreditFileType().equals((Object)CreditFileTypeEnum.CUSTCATEGORY)) {
            FilterItemInfo filterCustGroup = new FilterItemInfo("customerGroup.id", (Object)cfInfo.getCustomerGroup().getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterCustGroup);
        } else if (cfInfo.getCreditFileType().equals((Object)CreditFileTypeEnum.BIZCODE)) {
            FilterItemInfo filterBizCode = new FilterItemInfo("bizAnsCode.id", (Object)cfInfo.getBizAnsCode().getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterBizCode);
        }
        if (cfInfo.getId() != null) {
            String id = cfInfo.getId().toString();
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            CreditFileCollection cfc = this.getCreditFileCollection(ctx, ev);
            int size = cfc.size();
            for (int i = 0; i < size; ++i) {
                if (id.equalsIgnoreCase(cfc.get(i).getId().toString())) continue;
                return true;
            }
        } else {
            return super._exists(ctx, filter);
        }
        return false;
    }

    @Override
    protected boolean _checkDup(Context ctx, String pkStr, String companyId, int creditFileType) throws BOSException, EASBizException {
        boolean bl;
        LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer("");
        StringBuffer couIDs = new StringBuffer("");
        sql.append("select cf.FID");
        sql.append(" from t_sd_creditFile cf where ");
        switch (creditFileType) {
            case 1: {
                sql.append(" cf.FCustomerID = '").append(pkStr).append("'");
                break;
            }
            case 2: {
                sql.append(" cf.FCustomerGroupID=").append("'").append(pkStr).append("'");
                break;
            }
            case 3: {
                sql.append(" cf.FBizAnsCodeID=").append("'").append(pkStr).append("'");
            }
        }
        boolean isRootControl = this._isCtrlG005(ctx, companyId);
        if (isRootControl) {
            List list = this.getCompanyIDList(ctx, companyId);
            list.addAll(this.getJuniorIDList(ctx, companyId));
            if (list != null && list.size() > 0) {
                CompanyOrgUnitInfo couInfo = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    couInfo = (CompanyOrgUnitInfo)list.get(i);
                    if (couInfo == null) continue;
                    if (i > 0) {
                        couIDs.append(",");
                    }
                    couIDs.append("'").append(couInfo.getId().toString()).append("'");
                }
            }
            if (couIDs.length() > 0) {
                couIDs.append(",'").append(companyId).append("'");
                sql.append(" AND cf.FCompanyOrgUnitID IN (").append(couIDs).append(")");
            } else {
                sql.append(" AND cf.FCompanyOrgUnitID =").append("'").append(companyId).append("'");
            }
        } else {
            sql.append(" AND cf.FCompanyOrgUnitID =").append("'").append(companyId).append("'");
        }
        sql.append(" AND cf.FBaseStatus <>").append(3);
        try {
            String sqlStr = sql.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            bl = rs.next();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    @Override
    protected boolean _isCtrlG005(Context ctx, String companyID) throws BOSException, EASBizException {
        return CreditServerUtil.isCreditParamG00X(ctx, "", "G005");
    }

    @Override
    protected List _getCompanyIDList(Context ctx, String companyID) throws BOSException, EASBizException {
        CompanyOrgUnitCollection orgCol = CreditOrgUnitUtils.getSuperiorCompanyCollection(ctx, companyID.toString(), 3, false);
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        for (int i = 0; i < orgCol.size(); ++i) {
            list.add(orgCol.get(i));
        }
        return list;
    }

    @Override
    protected List _getJuniorIDList(Context ctx, String companyID) throws BOSException, EASBizException {
        CompanyOrgUnitCollection orgCol = CreditOrgUnitUtils.getChildrenCompanyCollection(ctx, companyID.toString(), 3, false);
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        for (int i = 0; i < orgCol.size(); ++i) {
            list.add(orgCol.get(i));
        }
        return list;
    }

    @Override
    protected String _getCreditFile(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String tempTable = this.createCreditFilesTempTable(ctx);
        SqlParams sqlParams = new SqlParams();
        this.executeCreateAsSelectInto(ctx, this.insertCreditFileTempTable(tempTable, this.getCreditFileForCustomer(creditCondition, sqlParams)), sqlParams);
        DbUtil.execute((Context)ctx, (String)this.getCreditFileForCustomerGroup(tempTable));
        if (creditCondition.isCheck || creditCondition.isByBizCode_Param()) {
            this.dealCreditFileForBizCode(ctx, tempTable, creditCondition);
        }
        this.deleteDupRec(ctx, tempTable);
        return tempTable;
    }

    private void dealCreditFileForBizCode(Context ctx, String tempTable, CreditCondition creditCondition) throws BOSException, EASBizException {
        if (creditCondition.isByBizCode_Sys()) {
            DbUtil.execute((Context)ctx, (String)this.insertCreditFileTempTable(tempTable, this.getCreditFileForBizCode(tempTable, creditCondition)));
            if (creditCondition.isByBizCode_Param()) {
                DbUtil.execute((Context)ctx, (String)("delete from " + tempTable + "  where FPLevel=20"));
            }
        }
    }

    private String getCreditFileForCustomer(CreditCondition creditCondition, SqlParams params) {
        StringBuilder sqlStr = this.getSelectSQL(creditCondition, 20);
        sqlStr.append(" FROM T_BD_Customer cst").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CustomerGroupDetail as cgd on cgd.FCUSTOMERID = cst.FID  ").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CSSPGroup cp on cp.FID = cgd.FCUSTOMERGROUPID ").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CustomerCompanyInfo cci ON cci.FCustomerID = cst.FID").append(sp);
        sqlStr.append(" INNER JOIN T_ORG_Company org ON cci.FComOrgID = org.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_Currency bc ON org.FBaseCurrencyID = bc.FID").append(sp);
        sqlStr.append(" LEFT  JOIN T_BD_BizAnaylysisCode bz ON cst.FBizAnalysisCodeID = bz.FID").append(sp);
        sqlStr.append(" LEFT JOIN T_SD_CreditFile cf ON cf.fcustomerid = cst.FID and cf.FCompanyOrgUnitID = org.fid").append(sp);
        sqlStr.append(" AND cf.FBaseStatus =").append(2).append(sp);
        sqlStr.append(" LEFT JOIN T_BD_Currency cy ON cf.FCurrencyID = cy.FID").append(sp);
        sqlStr.append(" LEFT JOIN T_SD_CreditGrade grade ON cf.FGrade = grade.FID").append(sp);
        sqlStr.append(this.getWhereSQL(creditCondition, params));
        return sqlStr.toString();
    }

    private String getCreditFileForBizCode(String tempTable, CreditCondition creditCondition) {
        StringBuilder sqlStr = this.getSelectSQL(creditCondition, 10);
        sqlStr.append(" FROM T_BD_BizAnaylysisCode bz").append(sp);
        sqlStr.append(" INNER JOIN T_BD_Customer cst ON cst.FBizAnalysisCodeID = bz.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CustomerCompanyInfo cci ON cci.FCustomerID = cst.FID").append(sp);
        sqlStr.append(" INNER JOIN T_ORG_Company org ON cci.FComOrgID = org.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_Currency bc ON org.FBaseCurrencyID = bc.FID").append(sp);
        sqlStr.append(" INNER JOIN (select distinct FCompanyId, FBizCodeID from ").append(tempTable).append(") TMP ON TMP.FBizCodeID = bz.FID and TMP.FCompanyId=org.FID").append(sp);
        sqlStr.append(" LEFT JOIN T_SD_CreditFile cf ON cf.FBizAnsCodeID = bz.FID and cf.FCompanyOrgUnitID = org.FID").append(sp);
        sqlStr.append(" and cf.FBaseStatus =").append(2);
        sqlStr.append(" LEFT JOIN T_BD_Currency cy ON cf.FCurrencyID = cy.FID").append(sp);
        sqlStr.append(" LEFT JOIN T_SD_CreditGrade grade ON cf.FGrade = grade.FID").append(sp);
        return sqlStr.toString();
    }

    private StringBuilder getSelectSQL(CreditCondition creditCondition, int level) {
        StringBuilder sqlStr = new StringBuilder(400);
        sqlStr.append("SELECT newbosid('88888888') as id,").append(sp);
        sqlStr.append("       newbosid('29EF5301') AS FRecID,").append(sp);
        sqlStr.append("       cf.FID AS FCreditFileID,").append(sp);
        sqlStr.append("       isnull(cf.FAmount,").append(creditCondition.getDefaultAmount() == null ? "0" : creditCondition.getDefaultAmount().toString()).append(") AS FAmount,").append(sp);
        sqlStr.append("       isnull(cf.FCreditTerm,0) AS FTerm,").append(sp);
        sqlStr.append("       isnull(cf.FIsBalanceRate,0) AS FIsBalanceRate,").append(sp);
        sqlStr.append("       isnull(cf.FBalanceRate,100) AS FBalanceRate,").append(sp);
        sqlStr.append("       grade.FDescription").append(LNAME).append(" AS FGradeName,").append(sp);
        sqlStr.append("       bz.FID as FBizCodeID,").append(sp);
        sqlStr.append("       bz.FNumber AS FBizCodeNum,").append(sp);
        sqlStr.append("       bz.FName").append(LNAME).append(" AS FBizCodeName,").append(sp);
        sqlStr.append(level).append(" AS FPLevel,").append(sp);
        sqlStr.append("       cst.FID AS FCustomerId,").append(sp);
        sqlStr.append("       cst.FName").append(LNAME).append(" AS FCustomerName,").append(sp);
        sqlStr.append("       cst.FNumber AS FCustomerNumber,").append(sp);
        sqlStr.append("       org.FID AS FCompanyId,").append(sp);
        sqlStr.append("       org.FNumber AS FCompanyNumber,").append(sp);
        sqlStr.append("       org.FLongNumber AS FCompanyLongNumber,").append(sp);
        sqlStr.append("       org.FName").append(LNAME).append(" AS FCompanyName,").append(sp);
        sqlStr.append("       org.FBaseExgTableID,").append(sp);
        sqlStr.append("       org.FBaseCurrencyID,").append(sp);
        sqlStr.append("       bc.FName").append(LNAME).append(" AS FBaseCurrencyName,").append(sp);
        sqlStr.append("       bc.FPrecision AS FBaseCurrencyPrecision,").append(sp);
        sqlStr.append("       isnull(cy.FID, bc.FID) AS FCurrencyID,").append(sp);
        sqlStr.append("       isnull(cy.FNumber, bc.fnumber) AS FCurrencyNumber,").append(sp);
        sqlStr.append("       isnull(cy.FName").append(LNAME).append(", bc.FName").append(LNAME).append(") AS FCurrencyName,").append(sp);
        sqlStr.append("       isnull(cy.FPrecision, bc.FPrecision) AS FPrecision").append(sp);
        return sqlStr;
    }

    private String getWhereSQL(CreditCondition creditCondition, SqlParams params) {
        StringBuilder sqlStr = new StringBuilder(200);
        if (creditCondition.isRootControl()) {
            sqlStr.append(",T_ORG_Company cc  WHERE cc.fid = ?  ").append(sp);
            if (!creditCondition.getCompany().isIsBizUnit()) {
                sqlStr.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sqlStr.append("   OR cc.FLongNumber = org.FLongNumber ").append(sp);
                sqlStr.append("   OR (SUBSTRING(org.FLongNumber,0,LENGTH(cc.FLongNumber) + 1 ) = cc.FLongNumber || '!' AND org.FLevel > cc.flevel)) ").append(sp);
            } else {
                sqlStr.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sqlStr.append("   OR cc.FLongNumber = org.FLongNumber) ").append(sp);
            }
            params.addString(creditCondition.getCompany().getId().toString());
        } else {
            sqlStr.append(" WHERE org.FID  = ? ").append(sp);
            params.addString(creditCondition.getCompany().getId().toString());
        }
        sqlStr.append(" and cst.fiscredited=1 ").append(sp);
        if (!creditCondition.isFromRptUI() && creditCondition.getDefaultAmount().compareTo(BigDecimal.ZERO) < 0) {
            sqlStr.append(" and cf.FAmount is not null ").append(sp);
        }
        if (creditCondition.getCustomer() != null) {
            sqlStr.append(" AND cst.FID = ? ").append(sp);
            params.addString(creditCondition.getCustomer().getId().toString());
        } else {
            if (creditCondition.getCustomerGroupFrom() != null) {
                sqlStr.append(" AND cp.FNumber >= ? ").append(sp);
                params.addString(creditCondition.getCustomerGroupFrom());
            }
            if (creditCondition.getCustomerGroupTo() != null) {
                sqlStr.append(" AND cp.FNumber <= ? ").append(sp);
                params.addString(creditCondition.getCustomerGroupTo());
            }
            if (creditCondition.getCustomerFrom() != null) {
                sqlStr.append(" AND cst.FNumber >= ? ").append(sp);
                params.addString(creditCondition.getCustomerFrom());
            }
            if (creditCondition.getCustomerTo() != null) {
                sqlStr.append(" AND cst.FNumber <= ? ").append(sp);
                params.addString(creditCondition.getCustomerTo());
            }
            if (creditCondition.getCustomerIn() != null) {
                Set customerIn = creditCondition.getCustomerIn();
                Object[] objects = customerIn.toArray();
                sqlStr.append(" AND cst.FNumber in (");
                for (int i = 0; i < objects.length; ++i) {
                    if (i > 0) {
                        sqlStr.append(",");
                    }
                    sqlStr.append("?");
                    params.addString((String)objects[i]);
                }
                sqlStr.append(") ").append(sp);
            }
        }
        if (creditCondition.getBizCodeID() != null) {
            sqlStr.append(" AND bz.FID = ? ").append(sp);
            params.addString(creditCondition.getBizCodeID());
        }
        if (creditCondition.getBizCodeFrom() != null) {
            sqlStr.append(" AND bz.FNumber >= ? ").append(sp);
            params.addString(creditCondition.getBizCodeFrom());
        }
        if (creditCondition.getBizCodeTo() != null) {
            sqlStr.append(" AND bz.FNumber <= ? ").append(sp);
            params.addString(creditCondition.getBizCodeTo());
        }
        return sqlStr.toString();
    }

    private String getCreditFileForCustomerGroup(String tempTable) {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("update ").append(tempTable).append(" as TMP ").append(sp);
        sqlStr.append("SET (FCreditFileID,FAmount,FTerm,FIsBalanceRate,FBalanceRate,FGradeName,FCurrencyID,FCurrencyNumber,FCurrencyName,FPrecision)=").append(sp);
        sqlStr.append("(select cf.FID AS FCreditFileID,").append(sp);
        sqlStr.append("       cf.FAmount AS FAmount,").append(sp);
        sqlStr.append("       cf.FCreditTerm AS FTerm,").append(sp);
        sqlStr.append("       cf.FIsBalanceRate AS FIsBalanceRate,").append(sp);
        sqlStr.append("       cf.FBalanceRate AS FBalanceRate,").append(sp);
        sqlStr.append("       grade.FDescription").append(LNAME).append(" AS FGradeName,").append(sp);
        sqlStr.append("       cy.FID AS FCurrencyID,").append(sp);
        sqlStr.append("       cy.FNumber AS FCurrencyNumber,").append(sp);
        sqlStr.append("       cy.FName").append(LNAME).append(" AS FCurrencyName,").append(sp);
        sqlStr.append("       cy.FPrecision AS FPrecision").append(sp);
        sqlStr.append("FROM T_SD_CreditFile cf").append(sp);
        sqlStr.append(" INNER JOIN T_ORG_Company org ON cf.FCompanyOrgUnitID = org.FID").append(sp);
        sqlStr.append(" LEFT  JOIN T_SD_CreditGrade grade ON cf.FGrade = grade.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_Currency cy ON cf.FCurrencyID = cy.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CSSPGroup cp ON cf.FCustomerGroupID = cp.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CustomerGroupDetail cg ON cg.FCustomerGroupID = cp.FID").append(sp);
        sqlStr.append(" INNER JOIN T_BD_CSSPGroupStandard css ON cg.FCustomerGroupStandardID =css.FID").append(sp);
        sqlStr.append(" WHERE css.FisBasic = -1 and TMP.FCustomerId = cg.FCustomerID AND TMP.FCompanyId=CF.FCOMPANYORGUNITID").append(sp);
        sqlStr.append(" AND cf.FBaseStatus =").append(2).append(" )").append(sp);
        sqlStr.append("WHERE (TMP.FCreditFileID IS NULL OR TMP.FCreditFileID='') AND EXISTS ").append(sp);
        sqlStr.append("        (SELECT 1 from T_SD_CreditFile cf").append(sp);
        sqlStr.append("                INNER JOIN T_BD_CSSPGroup cp ON cf.FCustomerGroupID = cp.FID").append(sp);
        sqlStr.append("                INNER JOIN T_BD_CustomerGroupDetail cg ON cg.FCustomerGroupID = cp.FID").append(sp);
        sqlStr.append("                INNER JOIN T_BD_CSSPGroupStandard css ON cg.FCustomerGroupStandardID =css.FID").append(sp);
        sqlStr.append("         WHERE TMP.FCustomerId = cg.FCustomerID AND TMP.FCompanyId=CF.FCOMPANYORGUNITID and css.FisBasic = -1").append(sp);
        sqlStr.append(" AND cf.FBaseStatus =").append(2).append(" )").append(sp);
        return sqlStr.toString();
    }

    private String createCreditFilesTempTable(Context ctx) throws BOSException, EASBizException {
        String tempTable;
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(CreditServerUtil.getCreditAnalysisTempTableSql(false));
        }
        catch (Exception e) {
            throw new SQLDataException(e.getMessage());
        }
        return tempTable;
    }

    private String insertCreditFileTempTable(String tempTable, String selectSql) {
        StringBuilder insertSQL = new StringBuilder(600);
        insertSQL.append("INSERT INTO ").append(tempTable).append(sp);
        insertSQL.append(" SELECT id, 1 as FIsOverBalance,FRecID,FCreditFileID,FAmount,");
        insertSQL.append(" FTerm,FIsBalanceRate,FBalanceRate,");
        insertSQL.append(" to_decimal(0.0,19,4) FRatedBalance,");
        insertSQL.append(" to_decimal(0.0,19,4) FUnArBillIssuedAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) FUnAuditIssuedAmt,");
        insertSQL.append(sp);
        insertSQL.append(" to_decimal(0.0,19,4) FUnAuditARAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) FReserve1,");
        insertSQL.append(" to_decimal(0.0,19,4) FReserve2,");
        insertSQL.append(sp);
        insertSQL.append(" to_decimal(0.0,19,4) FReserve3,");
        insertSQL.append(" to_decimal(0.0,19,4) FReserve4,");
        insertSQL.append(" to_decimal(0.0,19,4) FReserve5,");
        insertSQL.append(sp);
        insertSQL.append(" to_decimal(0.0,19,4) FArBalance,");
        insertSQL.append(" to_decimal(0.0,19,4) FUnArBillOrderAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) UsedAmount,");
        insertSQL.append(sp);
        insertSQL.append(" to_decimal(0.0,19,4) CreditBalance,");
        insertSQL.append(" to_decimal(0.0,19,4) FUnAuditSOAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) ImcomeAmt,");
        insertSQL.append(sp);
        insertSQL.append(" to_decimal(0.0,19,4) PayAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) AS unTimeoutAmount,");
        insertSQL.append(" to_decimal(0.0,19,4) AS timeoutAmount,");
        insertSQL.append(sp);
        insertSQL.append(" to_decimal(0.0,19,4) AS FUnAuditPostBillAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) AS FUnOutPostBillAmt,");
        insertSQL.append(" to_decimal(0.0,19,4) AS FUnOutSaleOrderBillAmt,");
        insertSQL.append(sp);
        insertSQL.append(" FGradeName,FBizCodeID,FBizCodeNum,").append(sp);
        insertSQL.append(" FBizCodeName,FPLevel,FCustomerName,").append(sp);
        insertSQL.append(" FCustomerId,FCustomerNumber,FCompanyId,").append(sp);
        insertSQL.append(" FCompanyNumber,FCompanyLongNumber,FCompanyName,").append(sp);
        insertSQL.append(" FBaseExgTableID,FBaseCurrencyID,FBaseCurrencyName,").append(sp);
        insertSQL.append(" FBaseCurrencyPrecision,FCurrencyID,FCurrencyNumber,").append(sp);
        insertSQL.append(" FCurrencyName,FPrecision, to_decimal(1.0,19,4) AS FExchangeRate ");
        insertSQL.append(" FROM (").append(sp);
        insertSQL.append(selectSql).append(sp);
        insertSQL.append(") CRD_TMP___ ").append(sp);
        return insertSQL.toString();
    }

    private void deleteDupRec(Context ctx, String tempTable) throws BOSException, EASBizException {
        String sql = "SELECT FCompanyId,FCustomerId,FRecID,FCompanyLongNumber,FPLevel FROM " + tempTable + " where FPLevel not in (10,18) ORDER BY FPLevel,FCompanyLongNumber ASC ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[0]);
        try {
            Hashtable<String, String> custExistFile = new Hashtable<String, String>();
            StringBuffer deleteSqlBuf = new StringBuffer("Delete from ").append(tempTable).append(" WHERE FRecID IN ('XXXX_00000'");
            while (rs.next()) {
                String custId = rs.getString("FCustomerId");
                String compLongNum = rs.getString("FCompanyLongNumber");
                String customerCompany = custId + compLongNum;
                if (custExistFile.containsKey(customerCompany)) {
                    deleteSqlBuf.append(",'").append(rs.getString("FRecID")).append("'");
                    continue;
                }
                custExistFile.put(customerCompany, customerCompany);
            }
            deleteSqlBuf.append(") ");
            DbUtil.execute((Context)ctx, (String)deleteSqlBuf.toString());
        }
        catch (SQLException exp) {
            throw new SQLDataException(exp);
        }
    }

    @Override
    protected String _createSelectSql(Context ctx, SqlParams sqlParams, CreditCondition creditCondition) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (creditCondition.isByBizCode_Param() && creditCondition.isByBizCode_Sys()) {
            sql.append(this.buildSqlByType(4, sqlParams, creditCondition));
            sql.append(" UNION ALL ").append(sp);
            sql.append(this.nonCreditFileBizCode(sqlParams, creditCondition)).append(sp);
        } else if (creditCondition.getCustomerGroupFrom() != null) {
            if (creditCondition.getCustomerFrom() == null) {
                sql.append(this.buildSqlByType(6, sqlParams, creditCondition));
            } else {
                sql.append(this.buildSqlByType(7, sqlParams, creditCondition));
                sql.append(" and cst.FNumber in(select ");
                sql.append(this.buildSqlByType(8, sqlParams, creditCondition)).append(")");
            }
        } else {
            sql.append(this.buildSqlByType(2, sqlParams, creditCondition)).append(sp);
            sql.append(" UNION ALL ").append(sp);
            sql.append(this.buildSqlByType(3, sqlParams, creditCondition)).append(sp);
            sql.append(" UNION ALL ").append(sp);
            sql.append(this.nonCreditFileCustomer(sqlParams, creditCondition)).append(sp);
            if (creditCondition.isByBizCode_Sys()) {
                sql.append(" UNION ALL ").append(sp);
                sql.append(this.buildSqlByType(1, sqlParams, creditCondition)).append(sp);
                sql.append(" UNION ALL ").append(sp);
                sql.append(this.nonCreditFileBizCode(sqlParams, creditCondition)).append(sp);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql.toString());
        }
        return sql.toString();
    }

    private String nonCreditFileCustomer(SqlParams params, CreditCondition creditCondition) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT newbosid('").append(new CreditFileInfo().getBOSType().toString());
        sql.append("') AS FRecID,null FCreditFileID,");
        sql.append(creditCondition.getDefaultAmount()).append(" FAmount,0 FTerm,0 FIsBalanceRate,100 FBalanceRate,").append(sp);
        sql.append(" null FGradeName,null as FBizCodeID,null AS FBizCodeNum,null AS FBizCodeName,38 FPLevel,");
        sql.append(" cst.FID AS FCustomerId,cst.FName").append(LNAME).append(" AS FCustomerName,").append(sp);
        sql.append(" cst.FNumber AS FCustomerNumber,org.FID AS FCompanyId,").append(sp);
        sql.append(" org.FNumber AS FCompanyNumber,org.FLongNumber AS FCompanyLongNumber,").append(sp);
        sql.append(" org.FName").append(LNAME).append(" AS FCompanyName,org.FBaseExgTableID,org.FBaseCurrencyID,").append(sp);
        sql.append(" bc.FName").append(LNAME).append(" AS FBaseCurrencyName,bc.FPrecision AS FBaseCurrencyPrecision,").append(sp);
        sql.append(" bc.FID AS FCurrencyID,bc.FNumber AS FCurrencyNumber,").append(sp);
        sql.append(" bc.FName").append(LNAME).append(" AS FCurrencyName,bc.FPrecision ").append(sp);
        sql.append(" FROM T_BD_Customer cst ").append(sp);
        sql.append(" INNER JOIN T_BD_CustomerCompanyInfo cstCom ON cstCom.FCustomerID = cst.FID ");
        sql.append(" INNER JOIN T_ORG_Company org ON cstCom.FComOrgID  = org.FID ").append(sp);
        sql.append(" INNER JOIN T_BD_Currency bc ON org.FBaseCurrencyID = bc.FID ").append(sp);
        if (creditCondition.isRootControl()) {
            sql.append(",T_ORG_Company cc ").append(sp);
            sql.append(" WHERE cc.fid = ?  ").append(sp);
            if (!creditCondition.getCompany().isIsBizUnit()) {
                sql.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sql.append("   OR cc.FLongNumber = org.FLongNumber ").append(sp);
                sql.append("   OR (SUBSTRING(org.FLongNumber,0,LENGTH(cc.FLongNumber) + 1 ) = cc.FLongNumber || '!' AND org.FLevel > cc.flevel)) ").append(sp);
            } else {
                sql.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sql.append("   OR cc.FLongNumber = org.FLongNumber) ").append(sp);
            }
            params.addString(creditCondition.getCompany().getId().toString());
        } else {
            sql.append(" WHERE org.FID  = ? ").append(sp);
            params.addString(creditCondition.getCompany().getId().toString());
        }
        sql.append(" AND cst.FIsCredited = 1 AND  NOT EXISTS (");
        sql.append(" SELECT cf.fid FROM T_SD_CreditFile cf WHERE cf.FCustomerID = cst.FID AND cf.FCompanyOrgUnitID = org.FID) ").append(sp);
        if (creditCondition.getCustomer() != null) {
            sql.append(" AND cst.FID = ? ").append(sp);
            params.addString(creditCondition.getCustomer().getId().toString());
        } else {
            if (creditCondition.getCustomerFrom() != null) {
                sql.append(" AND cst.FNumber >= ? ").append(sp);
                params.addString(creditCondition.getCustomerFrom());
            }
            if (creditCondition.getCustomerTo() != null) {
                sql.append(" AND cst.FNumber <= ? ").append(sp);
                params.addString(creditCondition.getCustomerTo());
            }
        }
        return sql.toString();
    }

    private String nonCreditFileBizCode(SqlParams params, CreditCondition creditCondition) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT newbosid('").append(new CreditFileInfo().getBOSType().toString());
        sql.append("') AS FRecID,null FCreditFileID,");
        sql.append(creditCondition.getDefaultAmount()).append(" FAmount,0 FTerm,0 FIsBalanceRate,100 FBalanceRate,");
        sql.append(" null FGradeName,bz.FID as FBizCodeID,bz.FNumber AS FBizCodeNum,bz.FName").append(LNAME).append(" AS FBizCodeName,18 FPLevel,");
        sql.append(" cst.FID AS FCustomerId,cst.FName").append(LNAME).append(" AS FCustomerName,").append(sp);
        sql.append(" cst.FNumber AS FCustomerNumber,org.FID AS FCompanyId,").append(sp);
        sql.append(" org.FNumber AS FCompanyNumber,org.FLongNumber AS FCompanyLongNumber,").append(sp);
        sql.append(" org.FName").append(LNAME).append(" AS FCompanyName,org.FBaseExgTableID,org.FBaseCurrencyID,").append(sp);
        sql.append(" bc.FName").append(LNAME).append(" AS FBaseCurrencyName,bc.FPrecision AS FBaseCurrencyPrecision,").append(sp);
        sql.append(" bc.FID AS FCurrencyID,bc.FNumber AS FCurrencyNumber,").append(sp);
        sql.append(" bc.FName").append(LNAME).append(" AS FCurrencyName,bc.FPrecision ").append(sp);
        sql.append(" FROM T_BD_BizAnaylysisCode bz ").append(sp);
        sql.append(" INNER JOIN T_BD_Customer cst ON cst.FBizAnalysisCodeID = bz.FID ").append(sp);
        sql.append(" INNER JOIN T_BD_CustomerCompanyInfo cstCom ON cstCom.FCustomerID = cst.FID ").append(sp);
        sql.append(" INNER JOIN T_ORG_Company org ON cstCom.FComOrgID  = org.FID ").append(sp);
        sql.append(" INNER JOIN T_BD_Currency bc ON org.FBaseCurrencyID = bc.FID ").append(sp);
        if (creditCondition.isRootControl()) {
            sql.append(",T_ORG_Company cc ").append(sp);
            sql.append(" WHERE cc.fid = ?  ").append(sp);
            if (!creditCondition.getCompany().isIsBizUnit()) {
                sql.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sql.append("   OR cc.FLongNumber = org.FLongNumber ").append(sp);
                sql.append("   OR (SUBSTRING(org.FLongNumber,0,LENGTH(cc.FLongNumber) + 1 ) = cc.FLongNumber || '!' AND org.FLevel > cc.flevel)) ").append(sp);
            } else {
                sql.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sql.append("   OR cc.FLongNumber = org.FLongNumber) ").append(sp);
            }
            params.addString(creditCondition.getCompany().getId().toString());
        } else {
            sql.append(" WHERE org.FID  = ? ").append(sp);
            params.addString(creditCondition.getCompany().getId().toString());
        }
        if (creditCondition.getBizCodeFrom() != null) {
            sql.append(" AND bz.FNumber >= ? ").append(sp);
            params.addString(creditCondition.getBizCodeFrom());
        }
        if (creditCondition.getBizCodeTo() != null) {
            sql.append(" AND bz.FNumber <= ? ").append(sp);
            params.addString(creditCondition.getBizCodeTo());
        }
        sql.append(" AND NOT EXISTS (");
        sql.append(" SELECT cf.FID FROM T_SD_CreditFile cf WHERE cf.FBizAnsCodeID = bz.FID AND cf.FCompanyOrgUnitID = org.FID) ").append(sp);
        sql.append(" AND bz.FID IN (SELECT FBizAnalysisCodeID FROM T_BD_Customer cst22 ");
        sql.append(" WHERE cst22.FIsCredited = 1");
        if (creditCondition.getCustomer() != null) {
            sql.append(" AND cst22.FID = ? ").append(sp);
            params.addString(creditCondition.getCustomer().getId().toString());
        } else {
            if (creditCondition.getCustomerFrom() != null) {
                sql.append(" AND cst22.FNumber >= ? ").append(sp);
                params.addString(creditCondition.getCustomerGroupFrom());
            }
            if (creditCondition.getCustomerTo() != null) {
                sql.append(" AND cst22.FNumber <= ? ").append(sp);
                params.addString(creditCondition.getCustomerTo());
            }
        }
        sql.append(")");
        return sql.toString();
    }

    private String buildSqlByType(int byType, SqlParams params, CreditCondition creditCondition) {
        StringBuffer sql = new StringBuffer();
        if (byType != 8) {
            sql.append("SELECT newbosid('").append(new CreditFileInfo().getBOSType().toString()).append("') AS FRecID,");
            sql.append(" cf.FID AS FCreditFileID,cf.FAmount AS FAmount,cf.FCreditTerm AS FTerm,cf.FIsBalanceRate AS FIsBalanceRate,cf.FBalanceRate AS FBalanceRate,");
            sql.append(" grade.FDescription").append(LNAME).append(" AS FGradeName,").append(sp);
        }
        switch (byType) {
            case 1: {
                sql.append("bz.FID as FBizCodeID,bz.FNumber AS FBizCodeNum,bz.FName").append(LNAME).append(" AS FBizCodeName,10 FPLevel,");
                break;
            }
            case 4: {
                sql.append("bz.FID as FBizCodeID,bz.FNumber AS FBizCodeNum,bz.FName").append(LNAME).append(" AS FBizCodeName,10 FPLevel,");
                break;
            }
            case 2: {
                sql.append(" null as FBizCodeID,null AS FBizCodeNum,null AS FBizCodeName,20 FPLevel,");
                break;
            }
            case 3: {
                sql.append(" null as FBizCodeID,null AS FBizCodeNum,null AS FBizCodeName,30 FPLevel,");
                break;
            }
            case 6: {
                sql.append(" null as FBizCodeID,null AS FBizCodeNum,null AS FBizCodeName,20 FPLevel,");
                break;
            }
            case 7: {
                sql.append(" null as FBizCodeID,null AS FBizCodeNum,null AS FBizCodeName,20 FPLevel,");
                break;
            }
            case 8: {
                sql.append("cst.FNumber ");
            }
        }
        if (byType != 8) {
            sql.append(" cst.FID AS FCustomerId,cst.FName").append(LNAME).append(" AS FCustomerName, cst.FNumber AS FCustomerNumber,").append(sp);
            sql.append(" org.FID AS FCompanyId, org.FNumber AS FCompanyNumber,org.FLongNumber AS FCompanyLongNumber,").append(sp);
            sql.append(" org.FName").append(LNAME).append(" AS FCompanyName,");
            sql.append(" org.FBaseExgTableID,org.FBaseCurrencyID,").append(sp);
            sql.append(" bc.FName").append(LNAME).append(" AS FBaseCurrencyName,bc.FPrecision AS FBaseCurrencyPrecision,").append(sp);
            sql.append(" cy.FID AS FCurrencyID,cy.FNumber AS FCurrencyNumber,").append(sp);
            sql.append(" cy.FName").append(LNAME).append(" AS FCurrencyName,cy.FPrecision ").append(sp);
        }
        sql.append("FROM T_SD_CreditFile cf").append(sp);
        sql.append(" INNER JOIN T_ORG_Company org ON cf.FCompanyOrgUnitID  = org.FID ").append(sp);
        sql.append(" LEFT OUTER JOIN T_SD_CreditGrade grade ON cf.FGrade  = grade.FID ").append(sp);
        sql.append(" INNER JOIN T_BD_Currency cy ON cf.FCurrencyID = cy.FID ").append(sp);
        sql.append(" INNER JOIN T_BD_Currency bc ON org.FBaseCurrencyID = bc.FID ").append(sp);
        switch (byType) {
            case 1: {
                sql.append(" INNER JOIN T_BD_BizAnaylysisCode bz ON cf.FBizAnsCodeID = bz.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_Customer cst ON cst.FBizAnalysisCodeID = bz.FID ").append(sp);
                break;
            }
            case 2: {
                sql.append(" INNER JOIN T_BD_Customer cst ON cf.FCustomerID = cst.FID ").append(sp);
                break;
            }
            case 3: {
                sql.append(" INNER JOIN T_BD_CSSPGroup cp ON cf.FCustomerGroupID =cp.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_CustomerGroupDetail cg ON cg.FCustomerGroupID = cp.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_CSSPGroupStandard css ON cg.FCustomerGroupStandardID = css.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_Customer cst ON cg.FCustomerID = cst.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_CustomerCompanyInfo bdCC ON bdCC.FCustomerID = cst.FID AND bdCC.FComOrgID = org.FID ").append(sp);
                break;
            }
            case 4: {
                sql.append(" INNER JOIN  T_BD_BizAnaylysisCode bz ON cf.FBizAnsCodeID = bz.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_Customer cst ON cst.FBizAnalysisCodeID = bz.FID ").append(sp);
                break;
            }
            case 6: {
                sql.append(" INNER JOIN T_BD_Customer cst ON cf.FCustomerID = cst.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_CSSPGroup cp on cp.FID=cst.FBrowseGroupID").append(sp);
                break;
            }
            case 7: {
                sql.append(" INNER JOIN T_BD_Customer cst ON cf.FCustomerID = cst.FID ").append(sp);
                break;
            }
            case 8: {
                sql.append(" INNER JOIN T_BD_Customer cst ON cf.FCustomerID = cst.FID ").append(sp);
                sql.append(" INNER JOIN T_BD_CSSPGroup cp on cp.FID=cst.FBrowseGroupID").append(sp);
            }
        }
        if (creditCondition.isRootControl()) {
            sql.append(",T_ORG_Company cc WHERE cc.fid = ?  ").append(sp);
            if (!creditCondition.getCompany().isIsBizUnit()) {
                sql.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sql.append("   OR cc.FLongNumber = org.FLongNumber ").append(sp);
                sql.append("   OR (SUBSTRING(org.FLongNumber,0,LENGTH(cc.FLongNumber) + 1 ) = cc.FLongNumber || '!' AND org.FLevel > cc.flevel)) ").append(sp);
            } else {
                sql.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(org.FLongNumber) + 1 ) = org.FLongNumber || '!' AND org.FLevel < cc.flevel)").append(sp);
                sql.append("   OR cc.FLongNumber = org.FLongNumber) ").append(sp);
            }
            params.addString(creditCondition.getCompany().getId().toString());
        } else if (byType != 8 && byType != 6) {
            sql.append(" WHERE org.FID  = ? ").append(sp);
            params.addString(creditCondition.getCompany().getId().toString());
        }
        if (byType == 2 || byType == 3 || byType == 7) {
            sql.append(" AND cst.FIsCredited = 1 ");
        }
        if (byType == 3) {
            sql.append(" AND css.FisBasic = -1 ");
        }
        if (byType != 1) {
            if (creditCondition.getCustomer() != null) {
                sql.append(" AND cst.FID = ? ").append(sp);
                params.addString(creditCondition.getCustomer().getId().toString());
            } else if (byType == 6 || byType == 8) {
                if (creditCondition.getCustomerGroupFrom() != null) {
                    sql.append(" AND cp.FNumber >= ? ").append(sp);
                    params.addString(creditCondition.getCustomerGroupFrom());
                }
                if (creditCondition.getCustomerGroupTo() != null) {
                    sql.append(" AND cp.FNumber <= ? ").append(sp);
                    params.addString(creditCondition.getCustomerGroupTo());
                }
            } else {
                if (creditCondition.getCustomerFrom() != null) {
                    sql.append(" AND cst.FNumber >= ? ").append(sp);
                    params.addString(creditCondition.getCustomerFrom());
                }
                if (creditCondition.getCustomerTo() != null) {
                    sql.append(" AND cst.FNumber <= ? ").append(sp);
                    params.addString(creditCondition.getCustomerTo());
                }
            }
        } else if (byType == 1 && (creditCondition.getCustomer() != null || creditCondition.getCustomerFrom() != null || creditCondition.getCustomerTo() != null)) {
            sql.append(" AND bz.FID IN (SELECT FBizAnalysisCodeID FROM T_BD_Customer cst22 ");
            sql.append(" WHERE cst22.FIsCredited = 1");
            if (creditCondition.getCustomer() != null) {
                sql.append(" AND cst22.FID = ? ").append(sp);
                params.addString(creditCondition.getCustomer().getId().toString());
            } else {
                if (creditCondition.getCustomerFrom() != null) {
                    sql.append(" AND cst22.FNumber >= ? ").append(sp);
                    params.addString(creditCondition.getCustomerFrom());
                }
                if (creditCondition.getCustomerTo() != null) {
                    sql.append(" AND cst22.FNumber <= ? ").append(sp);
                    params.addString(creditCondition.getCustomerTo());
                }
            }
            sql.append(")");
        }
        if (byType == 4) {
            if (creditCondition.getBizCodeFrom() != null) {
                sql.append(" AND bz.FNumber >= ? ").append(sp);
                params.addString(creditCondition.getBizCodeFrom());
            }
            if (creditCondition.getBizCodeTo() != null) {
                sql.append(" AND bz.FNumber <= ? ").append(sp);
                params.addString(creditCondition.getBizCodeTo());
            }
        }
        return sql.toString();
    }

    protected int executeCreateAsSelectInto(Context ctx, String sql, SqlParams parameters) throws BOSException {
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            logger.info((Object)sql);
            int n = DBUtil.executeUpdate((String)sql, (SqlParams)parameters, (Connection)con);
            return n;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)con);
        }
    }

    @Override
    protected void _alter(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CreditFileInfo newCredidFile = (CreditFileInfo)model;
        CreditFileInfo oldCredidFile = CreditFileFactory.getLocalInstance(ctx).getCreditFileInfo("select amount,currency.id,creditTerm,grade.id where id = '" + pk.toString() + "'");
        CreditFileAlterRecordInfo alterInfo = new CreditFileAlterRecordInfo();
        alterInfo.setCompany(newCredidFile.getCompanyOrgUnit());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? null : ContextUtil.getCurrentUserInfo((Context)ctx);
        alterInfo.setAlteror(userInfo);
        alterInfo.setAlterTime(new Timestamp(new Date().getTime()));
        CreditFileAlterRecordEntryInfo alterEInfo = new CreditFileAlterRecordEntryInfo();
        alterEInfo.setCreditFile(newCredidFile);
        alterEInfo.setCustomer(newCredidFile.getCustomer());
        alterEInfo.setOldAmount(oldCredidFile.getAmount());
        alterEInfo.setNewAmount(newCredidFile.getAmount());
        alterEInfo.setOldCurrency(oldCredidFile.getCurrency());
        alterEInfo.setNewCurrency(newCredidFile.getCurrency());
        alterEInfo.setOldCreditTerm(oldCredidFile.getCreditTerm());
        alterEInfo.setNewCreditTerm(newCredidFile.getCreditTerm());
        alterEInfo.setOldGrade(oldCredidFile.getGrade());
        alterEInfo.setNewGrade(newCredidFile.getGrade());
        alterInfo.getEntries().add(alterEInfo);
        CreditFileAlterRecordFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)alterInfo);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("companyOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("customer.id"));
        if (pks.length == 0) {
            return;
        }
        StringBuffer ids = new StringBuffer("");
        Object[] params = new Object[pks.length + 3];
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            ids.append("?,");
            params[i + 3] = pks[i].toString();
        }
        if (ids.length() > 0) {
            ids = ids.deleteCharAt(ids.length() - 1);
            String sql = "update T_SD_CreditFile set FBaseStatus= ?,FAuditorID = ?,FAuditTime=? where FID in (" + ids.toString() + ")";
            params[0] = 2;
            params[1] = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(14, 0);
            params[2] = new Timestamp(cal.getTime().getTime());
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    @Override
    protected void _getAlterRecords(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected void _invalid(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks.length == 0) {
            return;
        }
        StringBuilder idStr = new StringBuilder("");
        StringBuilder ids = new StringBuilder("");
        Object[] params = new Object[pks.length + 3];
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            ids.append("?,");
            params[i + 3] = pks[i].toString();
            idStr.append("'").append(pks[i]).append("'").append(",");
        }
        StringBuilder checkSql = new StringBuilder(300);
        checkSql.append(" SELECT 1");
        checkSql.append(" FROM T_SD_CreditFile");
        checkSql.append(" WHERE FBASESTATUS != ").append(2);
        checkSql.append(" \tAND FID in (").append(idStr.substring(0, idStr.length() - 1)).append(")");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (result.next()) {
                throw new CreditFileException(CreditFileException.AUDIT_INVALID);
            }
        }
        catch (SQLException e) {
            throw new BOSException("CreditFileControllerBean._invalid SQL ERROR ", (Throwable)e);
        }
        if (ids.length() > 0) {
            ids = ids.deleteCharAt(ids.length() - 1);
            String sql = "update T_SD_CreditFile set FBaseStatus= ?,FInvalidorID = ?,fInvalidTime=? where FID in (" + ids.toString() + ")";
            params[0] = 3;
            params[1] = ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(14, 0);
            params[2] = new Timestamp(cal.getTime().getTime());
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("creditFileType"));
        view.getSelector().add(new SelectorItemInfo("companyOrgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("customer.number"));
        view.getSelector().add(new SelectorItemInfo("customerGroup.number"));
        view.getSelector().add(new SelectorItemInfo("bizAnsCode.number"));
        CreditFileCollection creditFileColl = this.getCreditFileCollection(ctx, view);
        String value = "";
        if (creditFileColl != null && creditFileColl.size() > 0) {
            CreditFileInfo info = creditFileColl.get(0);
            if (info.getCreditFileType().getValue() == 1) {
                value = this.getResource("companyOrg", ctx) + ": " + info.getCompanyOrgUnit().getNumber() + "   " + this.getResource("customer", ctx) + ": " + info.getCustomer().getNumber();
            } else if (info.getCreditFileType().getValue() == 6) {
                value = this.getResource("companyOrg", ctx) + ": " + info.getCompanyOrgUnit().getNumber() + "   " + this.getResource("bizcode", ctx) + ": " + info.getBizAnsCode().getNumber();
            } else if (info.getCreditFileType().getValue() == 3) {
                value = this.getResource("companyOrg", ctx) + ": " + info.getCompanyOrgUnit().getNumber() + "   " + this.getResource("csspgroup", ctx) + ": " + info.getCustomerGroup().getNumber();
            }
        }
        return value;
    }

    protected String getResource(String key, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditFileResource", (String)key, (Locale)ctx.getLocale());
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuilder checkSql = new StringBuilder(300);
        checkSql.append(" SELECT 1");
        checkSql.append(" FROM T_SD_CreditFile");
        checkSql.append(" WHERE FBASESTATUS = ").append(2);
        checkSql.append(" \tAND FID = '").append(pk).append("'");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (result.next()) {
                throw new CreditFileException(CreditFileException.SAVE_DELETE);
            }
        }
        catch (SQLException e) {
            throw new BOSException("CreditFileControllerBean._delete SQL ERROR ", (Throwable)e);
        }
        super._delete(ctx, pk);
    }
}

