/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditFormulaException;
import com.kingdee.eas.scm.credit.CreditFormulaInfo;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditParamFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.ICreditParamFacade;
import com.kingdee.eas.scm.credit.app.AbstractCreditFormulaControllerBean;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class CreditFormulaControllerBean
extends AbstractCreditFormulaControllerBean {
    private static final long serialVersionUID = 6558221370571799320L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditFormulaControllerBean");

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectValue comOrgUnit, int type) throws BOSException, EASBizException {
        CreditFormulaSceneEnum scene = CreditFormulaSceneEnum.getEnum(type);
        CreditFormulaInfo defaultInfo = this.getDefaultWithType(ctx, (CompanyOrgUnitInfo)comOrgUnit, scene);
        return defaultInfo;
    }

    @Override
    protected void _setDefault(Context ctx) throws BOSException, EASBizException {
        throw new CreditFormulaException(CreditFormulaException.NOT_SUPPORT_METHOD);
    }

    protected CreditFormulaInfo getDefaultWithType(Context ctx, CompanyOrgUnitInfo companyInfo, CreditFormulaSceneEnum type) throws BOSException, EASBizException {
        logger.info((Object)"create a default formula.");
        if (companyInfo == null) {
            throw new CreditFormulaException(CreditFormulaException.NULL_COMPANY);
        }
        ICreditParamFacade icf = CreditParamFacadeFactory.getLocalInstance(ctx);
        CreditParamInfo creditParam = icf.getParameter(companyInfo.getId().toString());
        CreditFormulaInfo formulaInfo = new CreditFormulaInfo();
        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(type, creditParam);
        String Amount_Formula_ForSave = billCtrlStrategy.getFormulaForSave();
        formulaInfo.setFormulaAmount(Amount_Formula_ForSave);
        formulaInfo.setFormulaTerm("FIRST_AR_DATE+CREDIT_TIMELIMIT");
        formulaInfo.setScene(type);
        formulaInfo.setCompanyOrgUnit(companyInfo);
        formulaInfo.setCU(companyInfo.getCU());
        formulaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        formulaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return formulaInfo;
    }

    @Override
    protected IObjectValue _getValueForUI(Context ctx, IObjectValue comOrgUnit, int type) throws BOSException, EASBizException {
        return this._getValue(ctx, comOrgUnit, type);
    }

    @Override
    protected boolean _isARByInv(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AR_BY_INV_001");
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }
}

