/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditLogFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.ICreditLogFacade;
import com.kingdee.eas.scm.credit.app.AbstractCreditInitFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.sql.ClearCreditBalanceSQLString;
import com.kingdee.eas.scm.credit.app.balance.sql.CreateCreditBalanceSQLString;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CreditInitFacadeControllerBean
extends AbstractCreditInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditInitFacadeControllerBean");
    private String sp = "\r\n";

    @Override
    protected void _createCreditBalance(Context ctx, List companyIds, List customIds) throws BOSException, EASBizException {
        if (companyIds == null && customIds == null) {
            return;
        }
        ArrayList params = new ArrayList();
        String customerIdString = null;
        if (customIds != null && customIds.size() != 0) {
            customerIdString = SCMUtils.toParamString(customIds.iterator(), params);
        }
        if (companyIds == null || companyIds.size() == 0) {
            companyIds = this.getCreditCompanyListByCustomers(ctx, customerIdString, params);
        }
        if (companyIds != null) {
            int size = companyIds.size();
            for (int i = 0; i < size; ++i) {
                this.createBalance(ctx, companyIds.get(i).toString(), customerIdString, params);
            }
        }
    }

    @Override
    protected void _createCreditBalanceForOneCustom(Context ctx, String companyID, String customID) throws BOSException, EASBizException {
        if (companyID == null || customID == null) {
            return;
        }
        String lockSql = "update T_SD_CreditBalance set FID = FID  WHERE FCompanyID = '" + companyID + "' and FCustomerID = '" + customID + "'";
        DbUtil.execute((Context)ctx, (String)lockSql);
        ArrayList<String> params = new ArrayList<String>();
        String customerIdString = null;
        if (customID != null) {
            customerIdString = "(?)";
            params.add(customID);
        }
        this.createBalance(ctx, companyID, customerIdString, params);
    }

    private void createBalance(Context ctx, String companyIdString, String customerIdString, ArrayList params) throws BOSException, EASBizException {
        ICreditLogFacade creditLogFacade = CreditLogFacadeFactory.getLocalInstance(ctx);
        ArrayList cloneParams = (ArrayList)params.clone();
        if (this.isNeedUpdateBalance(ctx, companyIdString)) {
            params = (ArrayList)cloneParams.clone();
            this.clearBalance(ctx, companyIdString, customerIdString, params);
            params = (ArrayList)cloneParams.clone();
            CreateCreditBalanceSQLString createCreditSql = new CreateCreditBalanceSQLString(ctx);
            createCreditSql.createCredit(companyIdString, customerIdString, params);
            params = (ArrayList)cloneParams.clone();
            creditLogFacade.createBalanceHis(companyIdString, customerIdString, params);
        }
    }

    private List getCreditCompanyListByCustomers(Context ctx, String customerIdString, List params) throws BOSException {
        ArrayList<String> c = new ArrayList<String>();
        if (customerIdString != null && customerIdString.trim().length() != 0) {
            String localString = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            StringBuffer strSQL = new StringBuffer();
            strSQL.append("SELECT DISTINCT cc.FComOrgID");
            strSQL.append(this.sp);
            strSQL.append(" FROM T_BD_CustomerCompanyInfo cc INNER JOIN T_Bas_ParamItem pit ON cc.FComOrgID = pit.FOrgUnitID");
            strSQL.append(this.sp);
            strSQL.append(" INNER JOIN T_Bas_Param p ON pit.FKeyID = p.FID");
            strSQL.append(this.sp);
            strSQL.append(" WHERE (p.FNumber = 'G004') ");
            strSQL.append(" AND (cc.FCustomerID IN ").append(customerIdString).append(") ").append(this.sp);
            strSQL.append(" AND (ISNULL(pit.FValue_").append(localString).append(", 'false') = 'true')").append(this.sp);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params.toArray());
            if (rs != null) {
                try {
                    while (rs.next()) {
                        c.add(rs.getString("FComOrgID"));
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        return c;
    }

    private boolean isNeedUpdateBalance(Context ctx, String companyId) throws BOSException, EASBizException {
        CreditParamInfo param = CreditServerUtil.getCreditParamInfo(ctx, companyId);
        if (param == null) {
            return false;
        }
        return param.isCompnayCredited() && (param.isCtrlSaleOrderAmount() || param.isCtrlIssuedAmount() || param.isCtrlARAmount() || param.isCtrlPostbillAmount());
    }

    private void clearBalance(Context ctx, String companyIdString, String customerIdString, List params) throws BOSException {
        DbUtil.execute((Context)ctx, (String)ClearCreditBalanceSQLString.clearCreditBalanceSQLString(companyIdString, customerIdString, params), (Object[])params.toArray());
    }
}

