/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.AbstractCreditLogAnalysisRptFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditLogAnalysisRptFacadeControllerBean
extends AbstractCreditLogAnalysisRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditLogAnalysisRptFacadeControllerBean");
    private String LNAME = "_L2";
    private String sp = "\r\n";
    private String tempTable = null;
    private static final String TempTableNameKey = "TempTableName";

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.LNAME = "_" + this.getLoc(ctx);
        String tempTableName = params.getString(TempTableNameKey);
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tmp.FRowIndex FRowIndex, tmp.FBillID FBillID, bt.FNumber billTypeNumber,tmp.FBillNumber FBillNumber,tmp.FOperateTime FOperateTime,tmp.FRemark FRemark,currency.FPrecision FPrecision,").append("tmp.FBizDate FBizDate, (case when tmp.FCreditOperation=100 then '").append(CreditOperationEnum.getEnum(100).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=200 then '").append(this.getResource("CALC_CREDITBALANCE", ctx)).append("'").append(this.sp).append(" when tmp.FCreditOperation=300 then '").append(this.getResource("CURRENT_CREDITBALANCE", ctx)).append("'").append(this.sp).append(" when tmp.FCreditOperation=400 then '").append(this.getResource("DIFF_CREDITBALANCE", ctx)).append("'").append(this.sp).append(" when tmp.FCreditOperation=101 then '").append(CreditOperationEnum.getEnum(101).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=102 then '").append(CreditOperationEnum.getEnum(102).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=1 then '").append(CreditOperationEnum.getEnum(1).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=2 then '").append(CreditOperationEnum.getEnum(2).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=3 then '").append(CreditOperationEnum.getEnum(3).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=4 then '").append(CreditOperationEnum.getEnum(4).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=5 then '").append(CreditOperationEnum.getEnum(5).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=6 then '").append(CreditOperationEnum.getEnum(6).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=7 then '").append(CreditOperationEnum.getEnum(7).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=8 then '").append(CreditOperationEnum.getEnum(8).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=9 then '").append(CreditOperationEnum.getEnum(9).getAlias(locale)).append("'").append(this.sp).append(" when tmp.FCreditOperation=10 then '").append(CreditOperationEnum.getEnum(10).getAlias(locale)).append("'").append(this.sp).append(" else ' ' end) FCreditOperation, ").append(this.sp).append("bt.FName").append(this.LNAME).append(" billTypeName, currency.FName").append(this.LNAME).append(" currencyName,").append(this.sp).append("tmp.FArBalance,tmp.FUnInvoicedOrderAmt,tmp.FUnArBillInvoiceAmt,tmp.FUnInvoicedReturnAmt,tmp.FUnIssuedOrderAmt,").append(this.sp).append("tmp.FUnIssuedReturnAmt,tmp.FUnArBillIssuedAmt,tmp.FUnArBillOrderAmt,tmp.FUnAuditSOAmt,tmp.FUnAuditIssuedAmt,").append(this.sp).append("tmp.FReserve1,tmp.FReserve2,tmp.FReserve3,tmp.FReserve4,tmp.FReserve5,").append(this.sp).append("tmp.FUnAuditPostBillAmt,tmp.FUnOutPostBillAmt,tmp.FUnOutSaleOrderBillAmt").append(this.sp).append(" FROM ").append(tempTableName).append(" tmp ").append(this.sp).append(" left JOIN T_ORG_Company org ON tmp.FCompanyID  = org.FID ").append(this.sp).append(" left JOIN T_BD_Currency currency on currency.fid =org.FBaseCurrencyID").append(this.sp).append(" left JOIN t_scm_billtype bt on bt.fid = tmp.FBillTypeID").append(this.sp).append(" ORDER BY tmp.FRowIndex,FOperateTime");
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String oql;
        KsqlUtil.releaseTempTable((Context)ctx, (String)params.getString(TempTableNameKey));
        this.LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (params.getObject("company") == null || params.getObject("customer") == null || params.getObject("traceTime") == null) {
            throw new CreditControlException(CreditControlException.ERROR_ANALYSIS_PARAMS);
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
        CustomerInfo customerInfo = (CustomerInfo)params.getObject("customer");
        ICustomer icustomer = CustomerFactory.getLocalInstance((Context)ctx);
        if (!icustomer.exists(oql = "select id,name,number where number='" + customerInfo.getNumber() + "'")) {
            throw new CreditControlException(CreditControlException.ERROR_ANALYSIS_PARAMS);
        }
        customerInfo = (CustomerInfo)icustomer.getValue(oql);
        params.setString("customerID", customerInfo.getId().toString());
        params.setString("companyID", companyInfo.getId().toString());
        this.tempTable = this.createAnalysisTable(ctx);
        String companyId = companyInfo.getId().toString();
        Boolean flag = CreditServerUtil.getAuthorizedOrgUnit(ctx, companyId, "CreditLog_view");
        if (flag.booleanValue()) {
            this.insertBeginData(ctx, params);
            this.insertLogData(ctx, params);
            if (params.getObject("tracePoint") != null) {
                this.calcEndData(ctx, params);
                this.insertActualEndData(ctx, params);
                this.calcDiffEndData(ctx, params);
                this.insertAnalyseResult(ctx, params);
            }
        }
        String countSql = "SELECT count(*) cc FROM " + this.tempTable;
        RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (rsCount.next() && rsCount.getObject(0) != null) {
            count = rsCount.getInt(0);
        }
        RptParams result = new RptParams();
        result.setString(TempTableNameKey, this.tempTable);
        result.setInt("RowCount", count);
        return result;
    }

    private void insertAnalyseResult(Context ctx, RptParams params) throws BOSException {
        boolean isAuditControl;
        int controlScene = params.containsKey("ControlScene") ? params.getInt("ControlScene") : 1;
        int controlTime = params.containsKey("ControlTime") ? params.getInt("ControlTime") : 1;
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("SELECT * from ").append(this.tempTable).append(" where FRowIndex=4 ");
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        boolean bl = isAuditControl = 2 == controlTime;
        if (controlScene == 1) {
            sqlStr.append(" and (FUnArBillOrderAmt<>0 ").append(isAuditControl ? ")" : " or FUnAuditSOAmt<>0)");
        } else if (controlScene == 3) {
            sqlStr.append(" and (FUnArBillIssuedAmt<>0 ").append(isAuditControl ? ")" : " or FUnAuditIssuedAmt<>0)");
        } else if (controlScene == 4) {
            sqlStr.append(" and (FUnOutPostBillAmt<>0  or FUnArBillIssuedAmt<>0").append(isAuditControl ? ")" : " or FUnAuditPostBillAmt<>0)");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        if (rs != null && rs.size() > 0) {
            sqlStr.append("update ").append(this.tempTable).append(" set FRemark='").append(this.getResource("DIFF_BALANCE", ctx)).append("' where FRowIndex=4");
        } else {
            sqlStr.append("update ").append(this.tempTable).append(" set FRemark='").append(this.getResource("UNDIFF_BALANCE", ctx)).append("' where FRowIndex=4");
        }
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
    }

    private String getResource(String key, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditLogResource", (String)key, (Locale)ctx.getLocale());
    }

    public String createAnalysisTable(Context ctx) throws BOSException, EASBizException {
        this.tempTable = "T_CreditLogAnalysis";
        StringBuffer createSql = new StringBuffer();
        createSql.append("Create Table ").append(this.tempTable).append(this.sp).append(" (FCompanyID VARCHAR(44),FCustomerID VARCHAR(44),FCreditOperation INT,FOperateTime DateTime,FBillTypeID VARCHAR(44),").append(this.sp).append(" FBillID NVARCHAR(44),FBillNumber NVARCHAR(80),FBizDate DateTime,FArBalance NUMERIC(17,4) DEFAULT 0,FUnInvoicedOrderAmt NUMERIC(17,4) DEFAULT 0,").append(this.sp).append(" FUnArBillInvoiceAmt NUMERIC(17,4) DEFAULT 0,FUnInvoicedReturnAmt NUMERIC(17,4) DEFAULT 0,FUnIssuedOrderAmt NUMERIC(17,4) DEFAULT 0,").append(this.sp).append(" FUnIssuedReturnAmt NUMERIC(17,4) DEFAULT 0,FUnArBillIssuedAmt NUMERIC(17,4) DEFAULT 0,FUnArBillOrderAmt NUMERIC(17,4) DEFAULT 0,").append(this.sp).append(" FUnAuditSOAmt NUMERIC(17,4) DEFAULT 0,FUnAuditIssuedAmt NUMERIC(17,4) DEFAULT 0,FUnAuditPostBillAmt NUMERIC(17,4) DEFAULT 0,").append(this.sp).append(" FUnOutPostBillAmt NUMERIC(17,4) DEFAULT 0,FUnOutSaleOrderBillAmt NUMERIC(17,4) DEFAULT 0,FReserve1 NUMERIC(17,4) DEFAULT 0,").append(this.sp).append(" FReserve2 NUMERIC(17,4) DEFAULT 0,FReserve3 NUMERIC(17,4) DEFAULT 0,FReserve4 NUMERIC(17,4) DEFAULT 0,FReserve5 NUMERIC(17,4) DEFAULT 0,").append(this.sp).append(" FRemark NVARCHAR(255),FRowIndex INT)").append(this.sp);
        return KsqlUtil.createTempTable((Context)ctx, (String)createSql.toString());
    }

    public String getAmountFieldSQL() {
        StringBuffer fieldSQL = new StringBuffer();
        fieldSQL.append("FArBalance,FUnInvoicedOrderAmt,FUnArBillInvoiceAmt,FUnInvoicedReturnAmt,FUnIssuedOrderAmt,").append(this.sp).append("FUnIssuedReturnAmt,FUnArBillIssuedAmt,FUnArBillOrderAmt,FUnAuditSOAmt,FUnAuditIssuedAmt,FReserve1,FReserve2,FReserve3,").append(this.sp).append("FReserve4,FReserve5,FUnAuditPostBillAmt,FUnOutPostBillAmt,FUnOutSaleOrderBillAmt").append(this.sp);
        return fieldSQL.toString();
    }

    public void insertBeginData(Context ctx, RptParams params) throws BOSException {
        if (params.getString("companyID") == null || params.getString("customerID") == null || params.getObject("traceTime") == null || params.getObject("tracePoint") == null) {
            return;
        }
        Object[] sqlParams = new Object[]{params.getString("companyID"), params.getString("customerID"), params.getObject("tracePoint")};
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(this.tempTable).append(this.sp).append("(FRowIndex,FCompanyID,FCustomerID,FCreditOperation,FOperateTime,").append(this.sp).append(this.getAmountFieldSQL()).append(")").append(this.sp).append("SELECT 0,FCompanyID,FCustomerID,100,FOperateTime,").append(this.getAmountFieldSQL()).append(" from T_SD_CreditBalanceHis where FCompanyID=? and FCustomerID=? and fid=? and FCreditAccountID = 'DawAAAAPiJDuN4KI'");
        DbUtil.execute((Context)ctx, (String)insertSQL.toString(), (Object[])sqlParams);
        String countSql = "SELECT count(*) cc FROM " + this.tempTable;
        RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (rsCount.next() && rsCount.getObject(0) != null) {
            count = rsCount.getInt(0);
        }
        insertSQL.setLength(0);
        if (count < 1) {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date traceTime = (Date)params.getObject("traceTime");
            insertSQL.append("INSERT INTO ").append(this.tempTable).append(this.sp).append("(FRowIndex,FCompanyID,FCustomerID,FCreditOperation,FOperateTime,").append(this.sp).append(this.getAmountFieldSQL()).append(")").append(this.sp).append("values (0,'").append(params.getString("companyID")).append("','").append(params.getString("customerID")).append("',").append(" 0,").append("{ts'" + formater.format(traceTime) + "'}").append(",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 )");
            DbUtil.execute((Context)ctx, (String)insertSQL.toString());
        }
    }

    public void insertLogData(Context ctx, RptParams params) throws BOSException {
        boolean isAuditControl;
        if (params.getString("companyID") == null || params.getString("customerID") == null || params.getObject("traceTime") == null) {
            return;
        }
        Object[] sqlParams = new Object[]{params.getString("companyID"), params.getString("customerID")};
        int controlScene = params.containsKey("ControlScene") ? params.getInt("ControlScene") : 1;
        int controlTime = params.containsKey("ControlTime") ? params.getInt("ControlTime") : 1;
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(this.tempTable).append(this.sp).append("(FRowIndex,FCompanyID,FCustomerID,FCreditOperation,FOperateTime,").append(this.sp).append("FBillID,FBillTypeID,FBillNumber,FBizDate,FRemark,").append(this.getAmountFieldSQL()).append(")").append(this.sp).append("SELECT 1,FCompanyID,FCustomerID,FCreditOperation,FOperateTime,").append(this.sp).append("FBillID,FBillTypeID,FBillNumber,FBizDate,FRemark").append(this.LNAME).append(",").append(this.sp).append(this.getAmountFieldSQL()).append(" from T_SD_CreditLog  where FCompanyID=? and FCustomerID=? and FCreditAccountID = 'DawAAAAPiJDuN4KI' ");
        if (params.getObject("tracePoint") == null) {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date traceTime = (Date)params.getObject("traceTime");
            insertSQL.append(" and FOperateTime>={ts'" + formater.format(traceTime) + "'} ");
        } else {
            insertSQL.append(" and FOperateTime>=(select min(FOperateTime) from ").append(this.tempTable).append(") ");
        }
        boolean bl = isAuditControl = 2 == controlTime;
        if (controlScene == 1) {
            insertSQL.append(" and (FUnArBillOrderAmt<>0 ").append(isAuditControl ? ")" : " or FUnAuditSOAmt<>0)");
        } else if (controlScene == 3) {
            insertSQL.append(" and (FUnArBillIssuedAmt<>0 ").append(isAuditControl ? ")" : " or FUnAuditIssuedAmt<>0)");
        } else if (controlScene == 2) {
            insertSQL.append(isAuditControl ? "" : " and funarbillorderamt<>0");
        } else if (controlScene == 4) {
            insertSQL.append(" and (FUnOutPostBillAmt<>0  or FUnArBillIssuedAmt<>0").append(isAuditControl ? ")" : " or FUnAuditPostBillAmt<>0)");
        }
        if (controlScene == 5) {
            insertSQL.append(" and (FUnArBillOrderAmt<>0 ").append(isAuditControl ? ")" : " or FUnAuditSOAmt<>0)");
        }
        DbUtil.execute((Context)ctx, (String)insertSQL.toString(), (Object[])sqlParams);
    }

    public void calcEndData(Context ctx, RptParams params) throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(this.tempTable).append(this.sp).append("(FRowIndex,FCompanyID,FCustomerID,FCreditOperation,").append(this.sp).append(this.getAmountFieldSQL()).append(")").append(this.sp).append("SELECT 2,FCompanyID,FCustomerID,200,SUM(ISNULL(FArBalance,0)),SUM(ISNULL(FUnInvoicedOrderAmt,0)),").append(this.sp).append("SUM(ISNULL(FUnArBillInvoiceAmt,0)),SUM(ISNULL(FUnInvoicedReturnAmt,0)),SUM(ISNULL(FUnIssuedOrderAmt,0)),").append(this.sp).append("SUM(ISNULL(FUnIssuedReturnAmt,0)),SUM(ISNULL(FUnArBillIssuedAmt,0)),SUM(ISNULL(FUnArBillOrderAmt,0)),").append(this.sp).append("SUM(ISNULL(FUnAuditSOAmt,0)),SUM(ISNULL(FUnAuditIssuedAmt,0)),SUM(ISNULL(FReserve1,0)),SUM(ISNULL(FReserve2,0)),SUM(ISNULL(FReserve3,0)),").append(this.sp).append("SUM(ISNULL(FReserve4,0)),SUM(ISNULL(FReserve5,0)),SUM(ISNULL(FUnAuditPostBillAmt,0)),SUM(ISNULL(FUnOutPostBillAmt,0)),SUM(ISNULL(FUnOutSaleOrderBillAmt,0))").append(this.sp).append(" from ").append(this.tempTable).append(" where FRowIndex=0 or FRowIndex=1 group by FCompanyID,FCustomerID");
        DbUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    public void insertActualEndData(Context ctx, RptParams params) throws BOSException {
        Object[] sqlParams = new Object[]{params.getString("companyID"), params.getString("customerID")};
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(this.tempTable).append(this.sp).append("(FRowIndex,FCompanyID,FCustomerID,FCreditOperation,").append(this.sp).append(this.getAmountFieldSQL()).append(")").append(this.sp).append("SELECT 3,FCompanyID,FCustomerID,300,").append(this.getAmountFieldSQL()).append(" from T_SD_CreditBalance where FCompanyID=? and FCustomerID=? and FCreditAccountID = 'DawAAAAPiJDuN4KI'");
        DbUtil.execute((Context)ctx, (String)insertSQL.toString(), (Object[])sqlParams);
    }

    public void calcDiffEndData(Context ctx, RptParams params) throws BOSException {
        if (params.getString("companyID") == null || params.getString("customerID") == null || params.getObject("traceTime") == null) {
            return;
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(this.tempTable).append(this.sp).append("(FRowIndex,FCompanyID,FCustomerID,FCreditOperation,").append(this.sp).append(this.getAmountFieldSQL()).append(")").append(this.sp).append("SELECT 4,FCompanyID,FCustomerID,400,SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FArBalance,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FArBalance,0) ELSE 0 END)) AS FArBalance,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnInvoicedOrderAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnInvoicedOrderAmt,0) ELSE 0 END)) AS FUnInvoicedOrderAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnArBillInvoiceAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnArBillInvoiceAmt,0) ELSE 0 END)) AS FUnArBillInvoiceAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnInvoicedReturnAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnInvoicedReturnAmt,0) ELSE 0 END)) AS FUnInvoicedReturnAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnIssuedOrderAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnIssuedOrderAmt,0) ELSE 0 END)) AS FUnIssuedOrderAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnIssuedReturnAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnIssuedReturnAmt,0) ELSE 0 END)) AS FUnIssuedReturnAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnArBillIssuedAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnArBillIssuedAmt,0) ELSE 0 END)) AS FUnArBillIssuedAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnArBillOrderAmt,0) ELSE 0 END) -(CASE WHEN FRowIndex=3 THEN ISNULL(FUnArBillOrderAmt,0) ELSE 0 END)) AS FUnArBillOrderAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnAuditSOAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnAuditSOAmt,0) ELSE 0 END)) AS FUnAuditSOAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnAuditIssuedAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnAuditIssuedAmt,0) ELSE 0 END)) AS FUnAuditIssuedAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FReserve1,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FReserve1,0) ELSE 0 END)) AS FReserve1,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FReserve2,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FReserve2,0) ELSE 0 END)) AS FReserve2,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FReserve3,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FReserve3,0) ELSE 0 END)) AS FReserve3,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FReserve4,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FReserve4,0) ELSE 0 END)) AS FReserve4,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FReserve5,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FReserve5,0) ELSE 0 END)) AS FReserve5,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnAuditPostBillAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnAuditPostBillAmt,0) ELSE 0 END)) AS FUnAuditPostBillAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnOutPostBillAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnOutPostBillAmt,0) ELSE 0 END)) AS FUnOutPostBillAmt,").append(this.sp).append("SUM((CASE WHEN FRowIndex=2 THEN ISNULL(FUnOutSaleOrderBillAmt,0) ELSE 0 END)-(CASE WHEN FRowIndex=3 THEN ISNULL(FUnOutSaleOrderBillAmt,0) ELSE 0 END)) AS FUnOutSaleOrderBillAmt").append(this.sp).append(" from ").append(this.tempTable).append(" where FRowIndex=2 or FRowIndex=3 group by FCompanyID,FCustomerID");
        DbUtil.execute((Context)ctx, (String)insertSQL.toString());
    }

    @Override
    protected IRowSet _getCreditBalanceHisData(Context ctx, Map params) throws BOSException {
        if (params == null || params.get("COMPANY_ID") == null || params.get("CUSTOMER_NUMBER") == null) {
            return null;
        }
        this.LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String companyID = params.get("COMPANY_ID").toString();
        String customerNumber = params.get("CUSTOMER_NUMBER").toString();
        Object[] objArr = new Object[]{companyID, customerNumber};
        StringBuffer sqlStr = new StringBuffer();
        Locale locale = ctx.getLocale();
        sqlStr.append("select cbh.fid fid, (case when cbh.FCreditOperation=100 then '").append(CreditOperationEnum.getEnum(100).getAlias(locale)).append("'").append(this.sp).append(" when cbh.FCreditOperation=101 then '").append(CreditOperationEnum.getEnum(101).getAlias(locale)).append("'").append(this.sp).append(" when cbh.FCreditOperation=102 then '").append(CreditOperationEnum.getEnum(102).getAlias(locale)).append("'").append(this.sp).append(" else ' ' end) creditOperation, comp.fname").append(this.LNAME).append(" companyName, cust1.fname").append(this.LNAME).append(" customerName, cbh.foperatetime operateTime ").append(this.sp).append("from t_sd_creditbalancehis cbh inner join t_org_company comp on cbh.fcompanyid = comp.fid").append(this.sp).append("inner join t_bd_customer cust1 on cust1.fid = cbh.fcustomerid").append(this.sp).append("where cbh.fcompanyid = ? and cust1.fnumber = ? and cbh.FCreditAccountID = 'DawAAAAPiJDuN4KI'  order by cbh.foperatetime desc");
        return DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString(), (Object[])objArr);
    }
}

