/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.biz.AbstractBaseBizFunction;
import com.kingdee.eas.mobile.biz.BizFuncParamObj;
import com.kingdee.eas.mobile.biz.BizReturnObj;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditLimit;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.CreditQueryFacadeFactory;
import com.kingdee.eas.scm.credit.ICreditQueryFacade;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Locale;

public class CreditMobileSupport
extends AbstractBaseBizFunction {
    private static String RES = "com.kingdee.eas.scm.credit.CreditResource";
    public static final String CREDIT_QUERY_COMMAND = "CA01";
    private static final String PERM_NUM = "CreditTimelimitRpt_view";
    private Context ctx;
    private BizFuncParamObj msg;
    private IObjectPK userId;
    private CompanyOrgUnitInfo company;
    private CustomerInfo customer;

    public BizReturnObj executeSendAction(BizFuncParamObj paramObj) {
        this.msg = paramObj;
        BizReturnObj bizReturnObj = this.check();
        if (bizReturnObj != null) {
            return bizReturnObj;
        }
        String retMsg = null;
        try {
            retMsg = this.queryCreditAmt();
        }
        catch (Exception e) {
            bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText(this.getResource("SYSTEMERR0R"));
            bizReturnObj.setReturnText("");
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(false);
            return bizReturnObj;
        }
        bizReturnObj = new BizReturnObj();
        bizReturnObj.setErrorText("");
        bizReturnObj.setReturnText(retMsg);
        bizReturnObj.setSucceed(true);
        bizReturnObj.setMustReply(true);
        return bizReturnObj;
    }

    private BizReturnObj check() {
        this.ctx = this.msg.getCtx();
        this.userId = this.ctx.getCaller();
        if (this.msg.getCommandParams().length != 2) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText(this.getResource("FORMATTER_ERROR"));
            bizReturnObj.setReturnText("");
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        String custNum = this.msg.getCommandParams()[0];
        String companyNum = this.msg.getCommandParams()[1];
        try {
            this.company = this.getCompanyByNum(companyNum);
            this.customer = this.getCustomerByNum(custNum);
        }
        catch (BOSException e) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText(this.getResource("SYSTEMERR0R"));
            bizReturnObj.setReturnText("");
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        if (this.company == null || this.customer == null) {
            StringBuffer errBuf = new StringBuffer();
            if (this.company == null) {
                errBuf.append(this.getResource("COMPANY_NOTEXISTS"));
            }
            if (this.customer == null) {
                errBuf.append(this.getResource("CUSTOMER_NOTEXISTS"));
            }
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText(errBuf.toString());
            bizReturnObj.setReturnText("");
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        boolean ret = false;
        try {
            ret = this.hasPermission();
        }
        catch (Exception e) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText(this.getResource("SYSTEMERR0R"));
            bizReturnObj.setReturnText("");
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        if (!ret) {
            BizReturnObj bizReturnObj = new BizReturnObj();
            bizReturnObj.setErrorText(this.getResource("NOPERMISSION"));
            bizReturnObj.setReturnText("");
            bizReturnObj.setSucceed(false);
            bizReturnObj.setMustReply(true);
            return bizReturnObj;
        }
        return null;
    }

    protected boolean hasPermission() throws EASBizException, BOSException {
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        return ipermission.hasFunctionPermission(this.userId, (IObjectPK)new ObjectUuidPK(this.company.getId()), PERM_NUM);
    }

    private CompanyOrgUnitInfo getCompanyByNum(String num) throws BOSException {
        if (num == null || num.trim().length() == 0) {
            return null;
        }
        CompanyOrgUnitInfo org = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fid,t0.fname_").append(this.ctx.getLocale()).append(" fname,t0.fnumber,t1.fid fcurId,t1.fprecision ").append("from t_org_company t0,t_bd_currency t1 ").append("where t0.fbasecurrencyid = t1.fid ").append("and lower(t0.fnumber) = ?");
        IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{num.toLowerCase()});
        if (rowset.size() == 1) {
            org = new CompanyOrgUnitInfo();
            try {
                if (rowset.next()) {
                    org.setId(BOSUuid.read((String)rowset.getString("fid")));
                    org.setName(rowset.getString("fname"));
                    org.setNumber(rowset.getString("fnumber"));
                    CurrencyInfo basCur = new CurrencyInfo();
                    basCur.setId(BOSUuid.read((String)rowset.getString("fcurId")));
                    basCur.setPrecision(rowset.getInt("fprecision"));
                    org.setBaseCurrency(basCur);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return org;
    }

    private CustomerInfo getCustomerByNum(String num) throws BOSException {
        if (num == null || num.trim().length() == 0) {
            return null;
        }
        CustomerInfo ct = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fid,t0.fname_").append(this.ctx.getLocale()).append(" fname,t0.fnumber ").append("from t_bd_customer t0 ").append("where lower(t0.fnumber) = ?");
        IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{num.toLowerCase()});
        if (rowset.size() == 1) {
            ct = new CustomerInfo();
            try {
                if (rowset.next()) {
                    ct.setId(BOSUuid.read((String)rowset.getString("fid")));
                    ct.setName(rowset.getString("fname"));
                    ct.setNumber(rowset.getString("fnumber"));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return ct;
    }

    private String queryCreditAmt() throws EASBizException, BOSException {
        String noCredit = this.getResource("NO_CREDIT_INFO");
        CreditParamInfo paramInfo = CreditServerUtil.getCreditParamInfo(this.ctx, this.company.getId().toString());
        if (paramInfo == null) {
            return noCredit;
        }
        CreditFormulaSceneEnum ctrlScene = null;
        if (paramInfo.isCtrlSaleOrderAmount()) {
            ctrlScene = CreditFormulaSceneEnum.ORDER;
        } else if (paramInfo.isCtrlIssuedAmount()) {
            ctrlScene = CreditFormulaSceneEnum.ISSUEDBILL;
        } else if (paramInfo.isCtrlARAmount()) {
            ctrlScene = CreditFormulaSceneEnum.ARBILL;
        }
        if (ctrlScene == null) {
            return noCredit;
        }
        CreditCtrlResult mainCreditBalance = null;
        CreditCtrlResult custFirstCreditBalance = null;
        CreditCondition creditCondition = new CreditCondition();
        creditCondition.setCompany(this.company);
        String custId = this.customer.getId().toString();
        creditCondition.setCustomer(this.customer);
        creditCondition.setCreditControlScene(ctrlScene.getValue());
        ICreditQueryFacade creditQueryFacade = CreditQueryFacadeFactory.getLocalInstance(this.ctx);
        IRowSet creditRs = creditQueryFacade.processQueryCreditAmount(creditCondition);
        try {
            while (creditRs.next()) {
                int level = creditRs.getInt("FPLevel");
                String rCustId = creditRs.getString("FCustomerId");
                if (level == 19 || (level == 20 || level == 30 || level == 38) && rCustId.equals(custId)) {
                    mainCreditBalance = new CreditCtrlResult();
                    mainCreditBalance.setCreditAmount(CreditLimit.effectualCreditLimit(creditRs.getBigDecimal("FAmount")));
                    mainCreditBalance.setUsedCreditAmount(CreditLimit.read(creditRs.getBigDecimal("UsedAmount")));
                    mainCreditBalance.setCreditBalance(CreditLimit.read(creditRs.getBigDecimal("CreditBalance")));
                    continue;
                }
                if (level != 99 || !rCustId.equals(custId)) continue;
                custFirstCreditBalance = new CreditCtrlResult();
                if (mainCreditBalance == null) continue;
                mainCreditBalance.setCreditAmount(CreditLimit.effectualCreditLimit(creditRs.getBigDecimal("FAmount")));
                mainCreditBalance.setUsedCreditAmount(CreditLimit.read(creditRs.getBigDecimal("UsedAmount")));
                mainCreditBalance.setCreditBalance(CreditLimit.read(creditRs.getBigDecimal("CreditBalance")));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        CreditCtrlResult cb = null;
        if (custFirstCreditBalance != null) {
            cb = custFirstCreditBalance;
        } else if (mainCreditBalance != null) {
            cb = mainCreditBalance;
        }
        if (cb != null) {
            int prec = this.company.getBaseCurrency().getPrecision();
            String body = this.getResource("RET_SHORTMSG");
            body = body.replaceAll("CUSTNAME", this.customer.getName());
            body = body.replaceAll("ORGNAME", this.company.getName());
            body = CreditLimit.isInfinity(cb.getCreditAmount()) ? body.replaceAll("CREDITAMT", this.getResource("UNLIMITIED")) : body.replaceAll("CREDITAMT", this.formatNumber(prec, cb.getCreditAmount().bigDecimalValue()));
            body = body.replaceAll("USEDAMT", this.formatNumber(prec, cb.getUsedCreditAmount().bigDecimalValue()));
            body = body.replaceAll("BALANCEAMT", this.formatNumber(prec, cb.getCreditBalance().bigDecimalValue()));
            return body;
        }
        return noCredit;
    }

    private String formatNumber(int prec, BigDecimal num) throws BOSException, EASBizException {
        return num.setScale(prec, 4).toString();
    }

    private String getResource(String key) {
        return ResourceBase.getString((String)RES, (String)key, (Locale)this.ctx.getLocale());
    }
}

