/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.ICreditControlFacade;
import com.kingdee.eas.scm.credit.app.AbstractCreditParamFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditParamFacadeControllerBean
extends AbstractCreditParamFacadeControllerBean {
    private static final long serialVersionUID = -2502357433616696134L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditParamFacadeControllerBean");
    private Map paramMap = null;

    @Override
    protected CreditParamInfo _getParameter(Context ctx, String couid) throws BOSException, EASBizException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.desc"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.isUserDefine"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.isGroupControl"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.canBeModified"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.defaultValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.orgType"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.theValueRange"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.dataType"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.subSysID"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.baseType"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.userEdit"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.userClass"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("keyID.valueAlias"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"com.kingdee.eas.fi.ar.ar", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.orgType", (Object)new Integer(1), CompareType.EQUALS));
        this.paramMap = CreditServerUtil.isCreditParamG00X(ctx, couid);
        if ("true".equals(this.paramMap.get("G005"))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)couid, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.isUserDefine", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"Credit%", CompareType.LIKE));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        CreditParamInfo creditParamInfo = new CreditParamInfo();
        ParamItemInfo itemInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            itemInfo = collection.get(i);
            String aKey = itemInfo.getKeyID().getNumber().trim();
            creditParamInfo.getParamItemsAll().put(aKey, itemInfo);
            if (itemInfo.getKeyID().getDataType().getValue() == 3) {
                creditParamInfo.setParameter(aKey, Boolean.valueOf(itemInfo.getValue() == null ? "false" : itemInfo.getValue()));
                continue;
            }
            if (itemInfo.getKeyID().getDataType().getValue() == 1) {
                creditParamInfo.setParameter(aKey, Integer.valueOf(itemInfo.getValue() == null ? "-1" : itemInfo.getValue()));
                continue;
            }
            creditParamInfo.setParameter(aKey, itemInfo.getValue() == null ? "" : itemInfo.getValue());
        }
        creditParamInfo.setParameter("CreditParam01", true);
        if (creditParamInfo.getParameter("CreditParam071") == null) {
            creditParamInfo.setParameter("CreditParam071", creditParamInfo.getIntValue("CreditParam07"));
        }
        if (creditParamInfo.getParameter("CreditParam072") == null) {
            creditParamInfo.setParameter("CreditParam072", creditParamInfo.getIntValue("CreditParam07"));
        }
        if (creditParamInfo.getParameter("CreditParam09_1") == null) {
            creditParamInfo.setParameter("CreditParam09_1", Boolean.FALSE);
        }
        if (creditParamInfo.getParameter("CreditParam058") == null) {
            creditParamInfo.setParameter("CreditParam058", 2);
        }
        if (creditParamInfo.getParameter("CreditParam0591") == null) {
            creditParamInfo.setParameter("CreditParam0591", 2);
        }
        creditParamInfo.setParameter("G004", this.paramMap.get("G004"));
        creditParamInfo.setParameter("G005", this.paramMap.get("G005"));
        creditParamInfo.setParameter("G006", this.paramMap.get("G006"));
        return creditParamInfo;
    }

    private void correctData(ParamItemInfo paramItemVO, ParamInfo paramVO, Context ctx) {
        String number = paramVO.getNumber();
        if ("CreditParam111".equalsIgnoreCase(number) || "CreditParam1118".equalsIgnoreCase(number) || "CreditParam112".equalsIgnoreCase(number) || "CreditParam1119".equalsIgnoreCase(number)) {
            String value = paramItemVO.getValue();
            MutilLangeToolForParam.muti2Obj((String)value, (IObjectValue)paramItemVO, (String)"Value", (Context)ctx);
            MutilLangeToolForParam.muti2Obj((String)value, (IObjectValue)paramItemVO, (String)"valueAlias", (Context)ctx);
        }
    }

    @Override
    protected void _saveParameter(Context ctx, CreditParamInfo info) throws BOSException, EASBizException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
        IParam iParam = ParamFactory.getLocalInstance((Context)ctx);
        String companyID = info.getOrgUnitInfo().getId().toString();
        CreditParamInfo oldInfo = this._getParameter(ctx, companyID);
        boolean isCompanyCredit = false;
        String isCtrlSaleOrderAmountOV = null;
        String isCtrlIssuedAmountOV = null;
        String isCtrlPostbillAmountOV = null;
        int soCtrlTime = 1;
        int issuedCtrlTime = 1;
        int postCtrlTime = 1;
        int returnCtrlTime = 1;
        if (oldInfo != null) {
            isCompanyCredit = oldInfo.isCompnayCredited();
            isCtrlSaleOrderAmountOV = String.valueOf(oldInfo.isCtrlSaleOrderAmount());
            isCtrlIssuedAmountOV = String.valueOf(oldInfo.isCtrlIssuedAmount());
            isCtrlPostbillAmountOV = String.valueOf(oldInfo.isCtrlPostbillAmount());
            soCtrlTime = oldInfo.getSO_CtrlTime();
            issuedCtrlTime = oldInfo.getIssued_CtrlTime();
            postCtrlTime = oldInfo.getPostbill_CtrlTime();
            returnCtrlTime = oldInfo.getReturnBill_CtrlTime();
        } else {
            isCompanyCredit = Boolean.valueOf(this.paramMap.get("G004").toString());
        }
        if (isCompanyCredit && (info.isCtrlPostbillAmount() || info.isCtrlPostbillTimeLimit())) {
            CreditUtils.checkPostbill(ctx, companyID);
        }
        Hashtable htParaItem = info.getParamItemsAll();
        Enumeration iter = htParaItem.elements();
        while (iter.hasMoreElements()) {
            ParamItemInfo itemInfo = (ParamItemInfo)iter.nextElement();
            this.correctData(itemInfo, itemInfo.getKeyID(), ctx);
            if (itemInfo.getId() != null) {
                iParamItem.update((IObjectPK)new ObjectUuidPK(itemInfo.getId()), (CoreBaseInfo)itemInfo);
                continue;
            }
            ParamInfo paramInfo = itemInfo.getKeyID();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)paramInfo.getNumber(), CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            ParamCollection coll = iParam.getParamCollection(entityViewInfo);
            if (coll != null && coll.size() > 0) {
                paramInfo = coll.get(0);
            } else {
                iParam.addnew((CoreBaseInfo)paramInfo);
            }
            iParamItem.addnew(itemInfo, paramInfo);
        }
        if (isCompanyCredit && (isCtrlSaleOrderAmountOV == null || isCtrlSaleOrderAmountOV != null && !String.valueOf(info.isCtrlSaleOrderAmount()).equalsIgnoreCase(isCtrlSaleOrderAmountOV) || info.getSO_CtrlTime() != soCtrlTime || info.getReturnBill_CtrlTime() != returnCtrlTime || isCtrlIssuedAmountOV == null || isCtrlIssuedAmountOV != null && !String.valueOf(info.isCtrlIssuedAmount()).equalsIgnoreCase(isCtrlIssuedAmountOV) || info.getIssued_CtrlTime() != issuedCtrlTime || info.getReturnBill_CtrlTime() != returnCtrlTime || isCtrlPostbillAmountOV == null || isCtrlPostbillAmountOV != null && !String.valueOf(info.isCtrlPostbillAmount()).equalsIgnoreCase(isCtrlPostbillAmountOV) || info.getPostbill_CtrlTime() != postCtrlTime || info.getReturnBill_CtrlTime() != returnCtrlTime)) {
            ICreditControlFacade ctrlFacade = CreditControlFacadeFactory.getLocalInstance(ctx);
            ArrayList<String> companyList = new ArrayList<String>();
            companyList.add(info.getOrgUnitInfo().getId().toString());
            ctrlFacade.createCreditBalanceByCompany(companyList);
        }
    }
}

