/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamCheck;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamException;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.sql.ClearCreditBalanceSQLString;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import java.util.ArrayList;

public class CreditParamG004
implements IParamCheck,
INewParamCheck {
    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String tempKey = "G004IsChecked";
        try {
            if (ctx.get((Object)tempKey) != null) {
                return;
            }
            ctx.put((Object)tempKey, (Object)Boolean.TRUE);
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            String value = null;
            CompanyOrgUnitInfo company = null;
            ObjectUuidPK pk = null;
            String orgUnitID = null;
            if (model.getOrgUnitID() != null) {
                orgUnitID = model.getOrgUnitID().getId().toString();
                pk = new ObjectUuidPK(orgUnitID);
                value = paramControl.getParamValue((IObjectPK)pk, "G004");
                ICompanyOrgUnit ICompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                company = ICompany.getCompanyOrgUnitInfo((IObjectPK)pk);
            }
            if (value != null && company != null) {
                boolean start = SaleUtil.arIsStart((Context)ctx, company);
                if (!start) {
                    throw new CreditParamException(CreditParamException.ARAP_NOT_START);
                }
                if (value.trim().length() != 0 && value.trim().equalsIgnoreCase("false") && model.getValue().equalsIgnoreCase("true")) {
                    CreditParamInfo cp = CreditServerUtil.getCreditParamInfo(ctx, company.getId().toString());
                    if (cp != null && (cp.isCtrlPostbillAmount() || cp.isCtrlPostbillTimeLimit())) {
                        CreditUtils.checkPostbill(ctx, company.getId().toString());
                    }
                    paramControl.updateParamItemByNumberAndOrg("G004", orgUnitID, "true");
                    ArrayList<String> companys = new ArrayList<String>();
                    companys.add(company.getId().toString());
                    CreditControlFacadeFactory.getLocalInstance(ctx).createCreditBalanceByCompany(companys);
                } else if (value.trim().length() != 0 && value.trim().equalsIgnoreCase("true") && model.getValue().equalsIgnoreCase("false")) {
                    ClearCreditBalanceSQLString.clearCompanyBalance(ctx, company.getString("id"), null);
                }
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        finally {
            ctx.remove((Object)tempKey);
        }
    }

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        ParamItemInfo model = null;
        int size = modelCol.size();
        for (int i = 0; i < size; ++i) {
            model = modelCol.get(i);
            String tempKey = "G004IsChecked";
            try {
                if (ctx.get((Object)tempKey) != null) {
                    return;
                }
                ctx.put((Object)tempKey, (Object)Boolean.TRUE);
                IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
                String value = null;
                CompanyOrgUnitInfo company = null;
                ObjectUuidPK pk = null;
                String orgUnitID = null;
                if (model.getOrgUnitID() != null) {
                    orgUnitID = model.getOrgUnitID().getId().toString();
                    pk = new ObjectUuidPK(orgUnitID);
                    value = paramControl.getParamValue((IObjectPK)pk, "G004");
                    ICompanyOrgUnit ICompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    company = ICompany.getCompanyOrgUnitInfo((IObjectPK)pk);
                }
                if (value == null || company == null) continue;
                boolean start = SaleUtil.arIsStart((Context)ctx, company);
                if (!start) {
                    throw new CreditParamException(CreditParamException.ARAP_NOT_START);
                }
                if (value.trim().length() != 0 && value.trim().equalsIgnoreCase("false") && model.getValue().equalsIgnoreCase("true")) {
                    CreditParamInfo cp = CreditServerUtil.getCreditParamInfo(ctx, company.getId().toString());
                    if (cp != null && (cp.isCtrlPostbillAmount() || cp.isCtrlPostbillTimeLimit())) {
                        CreditUtils.checkPostbill(ctx, company.getId().toString());
                    }
                    paramControl.updateParamItemByNumberAndOrg("G004", orgUnitID, "true");
                    ArrayList<String> companys = new ArrayList<String>();
                    companys.add(company.getId().toString());
                    CreditControlFacadeFactory.getLocalInstance(ctx).createCreditBalanceByCompany(companys);
                    continue;
                }
                if (value.trim().length() == 0 || !value.trim().equalsIgnoreCase("true") || !model.getValue().equalsIgnoreCase("false")) continue;
                ClearCreditBalanceSQLString.clearCompanyBalance(ctx, company.getString("id"), null);
                continue;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
            finally {
                ctx.remove((Object)tempKey);
            }
        }
    }
}

