/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArSysFacadeFactory;
import com.kingdee.eas.fi.ar.IArSysFacade;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.ContrlTimeEnum;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditFileFactory;
import com.kingdee.eas.scm.credit.CreditFileInfo;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditLimit;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.AbstractCreditQueryFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.app.balance.control.CreditControlHelper;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditQueryFacadeControllerBean
extends AbstractCreditQueryFacadeControllerBean {
    private static final String CDATA_TMPTABLE = "creditDataTmpTable";
    private static final String CFILE_TMPTABLE = "creditFileTmpTable";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditQueryFacadeControllerBean");
    private String LNAME = "_L2";
    private String sp = "\r\n";
    private boolean isRootControl = false;
    private CompanyOrgUnitInfo companyInfo = null;
    private boolean isByBizCode_Param = false;
    private int controlScene = 1;
    private boolean isByBizCode_Sys = false;
    private ContrlTimeEnum creditCtrlTime = ContrlTimeEnum.ONAUDIT;
    private boolean isInfinity = true;
    private boolean isCustFirst = false;
    private boolean isNeedUnAuditAr = false;
    private boolean isFromSaleOrderQuery = false;
    private String creditFormula = null;

    private IRowSet getCreditForCustomer(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT FPLevel,FCompanyId,FCompanyName,FCustomerId,FCustomerName,FBizCodeID,FBizCodeNum,FBizCodeName,FAmount,UsedAmount,CreditBalance,FTerm, ").append(this.sp);
        sql.append("FIsBalanceRate,FBalanceRate,FRatedBalance,FCompanyLongNumber,FIsOverBalance,CreditBalance,FRatedBalance,FBaseCurrencyPrecision FROM ").append(tempTable).append(this.sp);
        sql.append(" where FPlevel=20 and LENGTH(FCompanyLongNumber) = (select min(LENGTH(FCompanyLongNumber)) from ").append(tempTable).append(" where FPlevel=20)").append(this.sp);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getCreditForBizCode(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT FPLevel,FCompanyId,FCompanyName,FCustomerId,FCustomerName,FBizCodeID,FBizCodeNum,FBizCodeName,FAmount,UsedAmount,CreditBalance,FTerm, ").append(this.sp);
        sql.append("FIsBalanceRate,FBalanceRate,FRatedBalance,FCompanyLongNumber,FIsOverBalance,CreditBalance,FRatedBalance,FBaseCurrencyPrecision FROM ").append(tempTable).append(this.sp);
        sql.append(" where FPlevel=10 and LENGTH(FCompanyLongNumber) = (select min(LENGTH(FCompanyLongNumber)) from ").append(tempTable).append(" where FPlevel=10)").append(this.sp);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected CreditCtrlResult _checkCreditBalance(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        CreditCtrlResult creditResult = CreditControlHelper.getCancelResult();
        if (creditCondition == null) {
            return creditResult;
        }
        creditCondition.setIsCheck(true);
        String tempTable = this._calcCredit(ctx, creditCondition);
        creditResult = this.checkCreditBalance(ctx, creditCondition, tempTable);
        this.checkCreditTerm(ctx, creditCondition, creditResult, tempTable);
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return creditResult;
    }

    @Override
    protected CreditCtrlResult _checkCredit(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        CreditParamInfo paramInfo = creditCondition.getCreditParam();
        BillControlStrategy billCtrlStrategy = ControlStategyFacotry.getStragy(CreditFormulaSceneEnum.getEnum(creditCondition.getCreditControlScene()), paramInfo);
        boolean isCtrlAmount = billCtrlStrategy.isCtrlAmount();
        boolean isCtrlTime = billCtrlStrategy.isCtrlTimelimit();
        CreditCtrlResult creditResult = CreditControlHelper.getPassResult();
        if (!isCtrlAmount && !isCtrlTime) {
            return creditResult;
        }
        creditCondition.setIsCheck(true);
        String tempTable = this._calcCredit(ctx, creditCondition);
        if (isCtrlAmount) {
            creditResult = this.checkCreditBalance(ctx, creditCondition, tempTable);
        }
        if (isCtrlTime) {
            this.checkCreditTerm(ctx, creditCondition, creditResult, tempTable);
        }
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return creditResult;
    }

    private CreditCtrlResult checkCreditTerm(Context ctx, CreditCondition creditCondition, CreditCtrlResult creditResult, String tempTable) throws BOSException, EASBizException {
        IRowSet rst = null;
        Calendar billDate = Calendar.getInstance();
        billDate.setTime(creditCondition.getBillDate());
        billDate.set(11, 0);
        billDate.set(12, 0);
        billDate.set(13, 0);
        billDate.set(14, 0);
        String selectSql = " select FCompanyId, FTerm from " + tempTable + " where FPLevel in(10,20) ORDER BY FPLevel,FCompanyLongNumber ASC ";
        rst = DbUtil.executeQuery((Context)ctx, (String)selectSql, (int)0, (int)-1);
        int term = 0;
        String companyID = "";
        try {
            if (rst != null && rst.next()) {
                companyID = rst.getString("FCompanyId");
                term = rst.getInt("FTerm");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        CompanyOrgUnitInfo company = creditCondition.getCompany();
        if (companyID != null && companyID.length() > 0 && !company.getId().toString().equals(companyID)) {
            company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyID));
            company = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, (OrgUnitInfo)company);
        }
        ObjectUuidPK custPK = new ObjectUuidPK(creditCondition.getCustomer().getId().toString());
        IArSysFacade arSysFacade = ArSysFacadeFactory.getLocalInstance((Context)ctx);
        BillBaseInfo info = null;
        info = CreditControlHelper.isUseBizAnalyseCode(creditCondition.getCreditParam(), CreditUtils.readFullCustomerInfo(ctx, creditCondition.getCustomer())) ? arSysFacade.getTermDateByBizCode(company, (IObjectPK)custPK, creditCondition.getBillDate()) : arSysFacade.getTermDate(company, (IObjectPK)custPK, creditCondition.getBillDate());
        Date firstArDate = new Date(System.currentTimeMillis());
        if (info != null) {
            firstArDate = (Date)info.get("arDate");
            creditResult.setArBillNum(info.getNumber());
            creditResult.setFirstArDate(firstArDate);
            Calendar payDate = Calendar.getInstance();
            payDate.setTime(firstArDate);
            payDate.set(11, 0);
            payDate.set(12, 0);
            payDate.set(13, 0);
            payDate.set(14, 0);
            payDate.add(5, term);
            creditResult.setTimeout(payDate.before(billDate));
            if (creditResult.isTimeout()) {
                float delayDays = billDate.getTime().getTime() - payDate.getTime().getTime();
                delayDays = delayDays / 1000.0f / 60.0f / 60.0f / 24.0f;
                int days = new Float(Math.ceil(delayDays)).intValue();
                creditResult.setOverDays(days);
                creditResult.setCreditCtrlMode(creditCondition.getCreditControlMethod());
            }
            creditResult.setTimeLimitDays(term);
        } else {
            creditResult.setTimeout(false);
        }
        return creditResult;
    }

    private CreditCtrlResult checkCreditBalance(Context ctx, CreditCondition creditCondition, String tempTable) throws BOSException, EASBizException, CreditControlException, SQLDataException {
        CreditCtrlResult creditResult = null;
        IRowSet rst = null;
        this.updateCheckResult(ctx, tempTable);
        if (creditCondition.getCustomer() != null && (creditCondition.getCustomer().getBizAnalysisCode() == null || creditCondition.getCustomer().getBizAnalysisCode().getId() == null) || !creditCondition.isByBizCode_Sys() || creditCondition.isByBizCode_Sys() && creditCondition.isCustFirst() && creditCondition.getBizCodeID() == null) {
            rst = this.getCreditForCustomer(ctx, tempTable);
            creditResult = this.buildCreditResult(ctx, creditCondition, rst);
        }
        if (creditCondition.isByBizCode_Sys()) {
            if (rst == null || rst.size() < 1 || creditResult != null && !creditResult.isOverspend()) {
                String customerID = creditResult != null ? creditResult.getCustomerId() : null;
                HashMap<String, BigDecimal> billNumeric = new HashMap<String, BigDecimal>();
                BigDecimal bizCodeAmount = creditCondition.getNumericValue("BILL_NUMERIC_AMOUNT_BIZCODE");
                if (creditCondition.readBillAmount().compareTo(SysConstant.BIGZERO) != 0 && creditCondition.readBillAmount().compareTo(bizCodeAmount) != 0) {
                    BigDecimal amount = creditCondition.readBillAmount().negate().add(bizCodeAmount);
                    billNumeric.put("BILL_NUMERIC_AMOUNT", amount);
                    creditCondition.setBillNumeric(billNumeric);
                    this.calcCreditBalance(ctx, tempTable, creditCondition);
                    this.updateCheckResult(ctx, tempTable);
                }
                if ((creditResult = this.buildCreditResult(ctx, creditCondition, rst = this.getCreditForBizCode(ctx, tempTable))) != null && creditResult.isOverspend()) {
                    creditResult.setCurAmount(bizCodeAmount);
                    creditResult.setCustomerId(customerID);
                }
            } else if (creditResult != null && creditResult.getBizCodeInfo() != null) {
                creditResult.setBizCodeInfo(null);
            }
        }
        if (creditResult == null) {
            throw new CreditControlException(CreditControlException.CREDITCUST_NO_COMPANY);
        }
        return creditResult;
    }

    private void updateCheckResult(Context ctx, String tempTable) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.setLength(0);
        sqlStr.append(" update ").append(tempTable).append(" set FIsOverBalance=0");
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" update ").append(tempTable).append(" set FIsOverBalance=1 where CreditBalance<0 and isnull(FIsBalanceRate,0)=0");
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" update ").append(tempTable).append(" set FIsOverBalance=1 where FRatedBalance<0 and isnull(FIsBalanceRate,0)=1");
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        sqlStr.setLength(0);
        sqlStr.append(" update ").append(tempTable).append(" set FIsOverBalance=0 where FAmount=").append(CreditLimit.BIGDECIMAL_NEGATE_ONE);
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
    }

    private CreditCtrlResult buildCreditResult(Context ctx, CreditCondition creditCondition, IRowSet rst) throws EASBizException, BOSException {
        CreditCtrlResult creditResult = CreditControlHelper.getPassResult();
        try {
            if (rst != null && rst.next()) {
                creditResult = new CreditCtrlResult();
                creditResult.setCreditCtrlMode(creditCondition.getCreditControlMethod());
                creditResult.setCompanyId(rst.getString("FCompanyId"));
                creditResult.setCompanyName(rst.getString("FCompanyName"));
                creditResult.setCustomerId(rst.getString("FCustomerId"));
                if (!creditCondition.isByBizCode_Sys() || rst.getString("FCustomerName") != null && !"".equals(rst.getString("FCustomerName"))) {
                    creditResult.setCustomerName(rst.getString("FCustomerName"));
                } else if (rst.getString("FCustomerName") == null || rst.getString("FCustomerName").trim().length() < 1) {
                    creditResult.setCustomerName(rst.getString("FBizCodeName"));
                }
                creditResult.setTimeLimitDays(rst.getInt("FTerm"));
                creditResult.setpLevel(rst.getInt("FPLevel"));
                creditResult.setIsBalanceRate(rst.getObject("FIsBalanceRate") == null ? false : rst.getInt("FIsBalanceRate") == 1);
                creditResult.setBalanceRate(rst.getBigDecimal("FBalanceRate"));
                if (rst.getString("FBizCodeID") != null) {
                    creditResult.getBizCodeInfo().setId(BOSUuid.read((String)rst.getString("FBizCodeID")));
                    creditResult.getBizCodeInfo().setNumber(rst.getString("FBizCodeNum"));
                    creditResult.getBizCodeInfo().setName(rst.getString("FBizCodeName"));
                }
                String companyID = rst.getString("FCompanyId");
                BigDecimal curAmount = creditCondition.readBillAmount();
                if (companyID != null && companyID.length() > 0 && !creditCondition.getCompany().getId().toString().equals(companyID)) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyID));
                    company = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, (OrgUnitInfo)company);
                    ObjectUuidPK srcCurrencyPk = new ObjectUuidPK(creditCondition.getCompany().getBaseCurrency().getId().toString());
                    ObjectUuidPK exchangeTablePk = new ObjectUuidPK(company.getBaseExchangeTable().getId().toString());
                    ObjectUuidPK destCurrencyPk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
                    BigDecimal rate = CreditUtils.getExchangeRate(ctx, (IObjectPK)exchangeTablePk, (IObjectPK)srcCurrencyPk, (IObjectPK)destCurrencyPk);
                    curAmount = curAmount.multiply(rate);
                    curAmount = curAmount.setScale(company.getBaseCurrency().getPrecision(), 4);
                }
                creditResult.setCurAmount(curAmount);
                creditResult.setOverspend(rst.getBoolean("FIsOverBalance"));
                BigDecimal FAmount = rst.getBigDecimal("FAmount");
                BigDecimal otherUsedCreditAmount = rst.getBigDecimal("UsedAmount");
                BigDecimal usedCreditAmount = rst.getBigDecimal("UsedAmount");
                BigDecimal creditBalance = rst.getBigDecimal("CreditBalance");
                BigDecimal ratedBalance = rst.getBigDecimal("FRatedBalance");
                BigDecimal creditBalanceBefore = rst.getBigDecimal("FAmount").subtract(rst.getBigDecimal("UsedAmount"));
                BigDecimal creditBalanceAfter = rst.getBigDecimal("CreditBalance");
                if (creditBalanceBefore.compareTo(creditBalanceAfter) < 0) {
                    creditResult.setOverspend(false);
                    creditResult.setRefund(true);
                }
                if (rst.getObject("FBaseCurrencyPrecision") != null) {
                    int FBaseCurrencyPrecision = rst.getInt("FBaseCurrencyPrecision");
                    creditBalanceBefore = creditBalanceBefore.setScale(FBaseCurrencyPrecision, 4);
                    creditBalanceAfter = creditBalanceAfter.setScale(FBaseCurrencyPrecision, 4);
                    FAmount = FAmount.setScale(FBaseCurrencyPrecision, 4);
                    otherUsedCreditAmount = otherUsedCreditAmount.setScale(FBaseCurrencyPrecision, 4);
                    usedCreditAmount = usedCreditAmount.setScale(FBaseCurrencyPrecision, 4);
                    creditBalance = creditBalance.setScale(FBaseCurrencyPrecision, 4);
                    ratedBalance = ratedBalance.setScale(FBaseCurrencyPrecision, 4);
                }
                creditResult.setCreditAmount(CreditLimit.effectualCreditLimit(FAmount));
                creditResult.setOtherUsedCreditAmount(otherUsedCreditAmount);
                creditResult.setUsedCreditAmount(CreditLimit.read(usedCreditAmount));
                creditResult.setCreditBalance(creditResult.getCreditAmount().isInfinity() ? CreditLimit.INFINITY : CreditLimit.read(creditBalance));
                creditResult.setRatedBalance(ratedBalance);
                creditResult.setCreditBalanceBefore(creditBalanceBefore);
                creditResult.setCreditBalanceAfter(creditBalanceAfter);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return creditResult;
    }

    @Override
    public IRowSet _processQueryCreditAmount(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        String tempTableName = this._calcCredit(ctx, creditCondition);
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT FPLevel,FCompanyId,FCompanyName,FCustomerId,FCustomerName,FAmount,UsedAmount,CreditBalance,FTerm,FIsBalanceRate,FBalanceRate,FRatedBalance,FCompanyLongNumber ").append(this.sp).append(" FROM ").append(tempTableName).append(this.sp);
        if (this.isRootControl) {
            if (this.isByBizCode_Sys) {
                StringBuffer selectBizCodeQuery = new StringBuffer("");
                StringBuffer selectCustomerFirstQuery = new StringBuffer("");
                selectBizCodeQuery.append(" SELECT temp_001.FPLevel FPLevel,temp_001.FCompanyId FCompanyId,temp_001.FCompanyName FCompanyName,").append(this.sp);
                selectBizCodeQuery.append(" temp_001.FCustomerId FCustomerId,temp_001.FCustomerName FCustomerName,temp_001.FAmount FAmount,").append(this.sp);
                selectBizCodeQuery.append(" temp_001.UsedAmount UsedAmount,temp_001.CreditBalance CreditBalance,temp_001.FTerm FTerm,").append(this.sp);
                selectBizCodeQuery.append(" temp_001.FIsBalanceRate FIsBalanceRate,temp_001.FBalanceRate FBalanceRate,temp_001.FRatedBalance FRatedBalance  ").append(this.sp);
                selectBizCodeQuery.append(" from (").append(sql.toString());
                selectBizCodeQuery.append(" where FPlevel in (10,18)) temp_001 where LENGTH(temp_001.FCompanyLongNumber) = ").append(this.sp);
                selectBizCodeQuery.append("(select min(LENGTH(FCompanyLongNumber)) from ").append(tempTableName).append(" where FPlevel in (10,18))");
                if (this.isCustFirst) {
                    selectCustomerFirstQuery.append(" SELECT temp_001.FPLevel FPLevel,temp_001.FCompanyId FCompanyId,temp_001.FCompanyName FCompanyName,").append(this.sp);
                    selectCustomerFirstQuery.append(" temp_001.FCustomerId FCustomerId,temp_001.FCustomerName FCustomerName,temp_001.FAmount FAmount,").append(this.sp);
                    selectCustomerFirstQuery.append(" temp_001.UsedAmount UsedAmount,temp_001.CreditBalance CreditBalance,temp_001.FTerm FTerm,").append(this.sp);
                    selectCustomerFirstQuery.append(" temp_001.FIsBalanceRate FIsBalanceRate,temp_001.FBalanceRate FBalanceRate,temp_001.FRatedBalance FRatedBalance  ").append(this.sp);
                    selectCustomerFirstQuery.append(" from (").append(sql.toString());
                    selectCustomerFirstQuery.append(" where FPlevel = 99) temp_001 where LENGTH(temp_001.FCompanyLongNumber) = ").append(this.sp).append("(select min(LENGTH(FCompanyLongNumber)) from ").append(tempTableName).append(" where FPlevel = 99)");
                }
                if (selectCustomerFirstQuery.length() > 0) {
                    selectBizCodeQuery.append(" UNION ALL ").append(this.sp).append(selectCustomerFirstQuery);
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)selectBizCodeQuery.toString());
                boolean isBizCode = false;
                try {
                    if (rs == null || rs != null && !rs.next()) {
                        isBizCode = true;
                    }
                }
                catch (SQLException e) {
                    e.setNextException(new SQLException("SQL: " + sql));
                    throw new SQLDataException(e);
                }
                if (isBizCode) {
                    StringBuffer selectCustomerQuery = new StringBuffer("");
                    selectCustomerQuery.append(" SELECT temp_001.FPLevel FPLevel,temp_001.FCompanyId FCompanyId,temp_001.FCustomerId FCustomerId,temp_001.FAmount FAmount,").append(this.sp).append(" temp_001.UsedAmount UsedAmount,temp_001.CreditBalance CreditBalance,temp_001.FTerm FTerm,").append(this.sp).append(" temp_001.FIsBalanceRate FIsBalanceRate,temp_001.FBalanceRate FBalanceRate,temp_001.FRatedBalance FRatedBalance  ").append(this.sp).append(" from (").append(sql.toString()).append(" where FPlevel in (20,30,38)) temp_001 where LENGTH(temp_001.FCompanyLongNumber) = ").append(this.sp).append("(select min(LENGTH(FCompanyLongNumber)) from ").append(tempTableName).append(" where FPlevel in (20,30,38))");
                    rs = DbUtil.executeQuery((Context)ctx, (String)selectCustomerQuery.toString());
                }
            } else {
                sql.append(" where LENGTH(FCompanyLongNumber) = (select min(LENGTH(FCompanyLongNumber)) from ").append(tempTableName).append(")").append(this.sp);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            }
        } else {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        try {
            logger.info((Object)sql.toString());
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analysisParams(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        this.companyInfo = creditCondition.getCompany();
        this.isByBizCode_Param = creditCondition.isByBizCode_Param();
        this.controlScene = creditCondition.getCreditControlScene();
        this.isFromSaleOrderQuery = creditCondition.isFromSaleOrderQuery();
        creditCondition.initCreditParam(ctx);
        this.creditFormula = creditCondition.getCreditFormula();
        this.isRootControl = creditCondition.isRootControl();
        this.isByBizCode_Sys = creditCondition.isByBizCode_Sys();
        this.creditCtrlTime = creditCondition.getCreditControlTime();
        this.isInfinity = creditCondition.isInfinityCreditAmt();
        this.isCustFirst = creditCondition.isCustFirst();
        if (!this.isByBizCode_Sys && this.isByBizCode_Param) {
            throw new CreditControlException(CreditControlException.ISBYBIZCODESYS_AND_ISBYBIZCODEPARAM);
        }
        if (creditCondition.getCreditParam() != null && creditCondition.isFromRptUI()) {
            if (!this.isRootControl) {
                if (!creditCondition.getCreditParam().isCompnayCredited()) throw new CreditControlException(CreditControlException.CREDIT_MANAGER);
                if (this.controlScene == 3 && !creditCondition.getCreditParam().isCtrlIssuedAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 1 && !creditCondition.getCreditParam().isCtrlSaleOrderAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 4 && !creditCondition.getCreditParam().isCtrlPostbillAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 2 && !creditCondition.getCreditParam().isCtrlARAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 5 && !creditCondition.getCreditParam().isCtrlSaleOrderAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.ORDER.getAlias(ctx.getLocale())});
                }
            } else if (this.companyInfo.isIsBizUnit()) {
                boolean creditControl = CreditServerUtil.isCreditParamG00X(ctx, this.companyInfo.getId().toString(), "G004");
                if (!creditControl) throw new CreditControlException(CreditControlException.CREDIT_MANAGER);
                if (this.controlScene == 3 && !creditCondition.getCreditParam().isCtrlIssuedAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 1 && !creditCondition.getCreditParam().isCtrlSaleOrderAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 4 && !creditCondition.getCreditParam().isCtrlPostbillAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 2 && !creditCondition.getCreditParam().isCtrlARAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 5 && !creditCondition.getCreditParam().isCtrlSaleOrderAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
            } else {
                if (this.controlScene == 3 && !creditCondition.getCreditParam().isCtrlIssuedAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 1 && !creditCondition.getCreditParam().isCtrlSaleOrderAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 4 && !creditCondition.getCreditParam().isCtrlPostbillAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 2 && !creditCondition.getCreditParam().isCtrlARAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
                if (this.controlScene == 5 && !creditCondition.getCreditParam().isCtrlSaleOrderAmount()) {
                    throw new CreditControlException(CreditControlException.CREDITAMOUNT_CONTROL, new Object[]{CreditFormulaSceneEnum.getEnum(this.controlScene).getAlias(ctx.getLocale())});
                }
            }
        }
        this.isNeedUnAuditAr = this.controlScene == 2 && this.creditCtrlTime.equals((Object)ContrlTimeEnum.ONSUBMIT);
    }

    @Override
    public String _calcCredit(Context ctx, CreditCondition creditCondition) throws BOSException, EASBizException {
        this.LNAME = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.analysisParams(ctx, creditCondition);
        String tempTable = CreditFileFactory.getLocalInstance(ctx).getCreditFile(creditCondition);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(CFILE_TMPTABLE, tempTable);
        this.updateUsedData(ctx, params);
        this.updateARData(ctx, params, creditCondition);
        this.upwardSum4Group(ctx, params);
        this.calcUsedBalance(ctx, tempTable);
        this.subTotal4BizCode(ctx, tempTable);
        this.calcCreditBalance(ctx, tempTable, creditCondition);
        this.dropTempTable(ctx, params);
        return tempTable;
    }

    private void updateUsedData(Context ctx, Map params) throws BOSException, EASBizException {
        String tempTable = params.get(CFILE_TMPTABLE).toString();
        this.updateUsedData4BizUnit(ctx, tempTable);
        if (this.isRootControl) {
            String selectSql = "SELECT temp.FCustomerID FCustomerID,temp.FCompanyID FCompanyID FROM  " + tempTable + " temp,t_org_company company  where company.fid = temp.FCompanyID and company.fisBizUnit = 1 group by temp.FCustomerID,temp.FCompanyID";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            ArrayList<String> companyList = new ArrayList<String>();
            ArrayList<String> customerList = new ArrayList<String>();
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            try {
                while (rs != null && rs.next()) {
                    if (!companyList.contains(rs.getString("FCompanyID"))) {
                        companyList.add(rs.getString("FCompanyID"));
                    }
                    if (!customerList.contains(rs.getString("FCustomerID"))) {
                        customerList.add(rs.getString("FCustomerID"));
                    }
                    String[] str = new String[]{rs.getString("FCompanyID"), rs.getString("FCustomerID")};
                    map.put(rs.getString("FCompanyID") + rs.getString("FCustomerID"), str);
                }
                ArrayList list = new ArrayList();
                String companydString = SCMUtils.toParamString(companyList.iterator(), list);
                String customerIdString = SCMUtils.toParamString(customerList.iterator(), list);
                if (!StringUtils.isEmpty((String)companydString) && !StringUtils.isEmpty((String)customerIdString)) {
                    String sql = "select FCompanyID,FCustomerID from T_SD_CreditBalance where FCompanyID in " + companydString + " and FCustomerID in " + customerIdString + " group by FCompanyID,FCustomerID";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])list.toArray());
                }
                while (rs != null && rs.next()) {
                    if (!map.containsKey(rs.getString("FCompanyID") + rs.getString("FCustomerID"))) continue;
                    map.remove(rs.getString("FCompanyID") + rs.getString("FCustomerID"));
                }
                if (map.size() > 0) {
                    StringBuffer initSQL = new StringBuffer();
                    initSQL.append("Insert Into T_SD_CreditBalance(FID,FCompanyID,FCustomerID,FUnOutSaleOrderBillAmt,");
                    initSQL.append("FUnAuditIssuedAmt,FUnArBillIssuedAmt,FUnAuditSOAmt,");
                    initSQL.append("FUnArBillOrderAmt,FUnAuditPostBillAmt,FUnOutPostBillAmt,FCreditAccountID) ");
                    initSQL.append(this.sp);
                    initSQL.append(" values (?,?,?,?,?,?,?,?,?,?,?)");
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    Object[] objParams = null;
                    String key = null;
                    Iterator iter = map.keySet().iterator();
                    while (iter.hasNext()) {
                        key = iter.next().toString();
                        objParams = new Object[]{BOSUuid.create((String)"12D4D072").toString(), ((String[])map.get(key))[0], ((String[])map.get(key))[1], SysConstant.BIGZERO, SysConstant.BIGZERO, SysConstant.BIGZERO, SysConstant.BIGZERO, SysConstant.BIGZERO, SysConstant.BIGZERO, SysConstant.BIGZERO, "DawAAAAPiJDuN4KI"};
                        paramsList.add(objParams);
                    }
                    DbUtil.executeBatch((Context)ctx, (String)initSQL.toString(), paramsList);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            String subTempTable = "CreditDataTemp__1";
            StringBuffer createTableSQL = new StringBuffer();
            createTableSQL.append("Create Table ").append(subTempTable).append(this.sp);
            createTableSQL.append(" (FUnArBillIssuedAmt numeric(19,4) DEFAULT 0,FUnAuditIssuedAmt numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FAmount numeric(19,4) DEFAULT 0,FTerm numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" ImcomeAmt numeric(19,4) DEFAULT 0,PayAmt numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FUnAuditARAmt numeric(19,4) DEFAULT 0,FArBalance numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FUnArBillOrderAmt numeric(19,4) DEFAULT 0,FUnAuditSOAmt numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FReserve1 numeric(19,4) DEFAULT 0,FReserve2 numeric(19,4) DEFAULT 0,FReserve3 numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FReserve4 numeric(19,4) DEFAULT 0,FReserve5 numeric(19,4) DEFAULT 0,FUnAuditPostBillAmt numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FUnOutPostBillAmt numeric(19,4) DEFAULT 0,FUnOutSaleOrderBillAmt numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FCustomerId varchar(44) null,FCompanyId varchar(44) null,FCompanyID_UP varchar(44) null,").append(this.sp);
            createTableSQL.append(" FBaseExgTableID varchar(44) null,FSrcCurrencyID varchar(44) null,FDestCurrencyID varchar(44) null,");
            createTableSQL.append(" FPrecision int null, FExchangeRate numeric(19,4)) ");
            try {
                subTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSQL.toString());
            }
            catch (Exception e) {
                throw new SQLDataException(e.getMessage());
            }
            params.put(CDATA_TMPTABLE, subTempTable);
            this.insertUsedData4Group(ctx, tempTable, subTempTable);
            this.updateExchangeRate(ctx, subTempTable);
        }
    }

    private void updateUsedData4BizUnit(Context ctx, String tempTable) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE ").append(tempTable).append(this.sp);
        updateSql.append(" SET (FUnArBillIssuedAmt,FUnAuditIssuedAmt,FUnArBillOrderAmt,FUnAuditSOAmt,FReserve1,").append(this.sp);
        updateSql.append(" FReserve2,FReserve3,FReserve4,FReserve5,FUnAuditPostBillAmt,FUnOutPostBillAmt,FUnOutSaleOrderBillAmt) = ");
        updateSql.append(this.sp);
        updateSql.append(" (SELECT isnull(tmp02__.FUnArBillIssuedAmt,0),isnull(tmp02__.FUnAuditIssuedAmt,0),");
        updateSql.append(" isnull(tmp02__.FUnArBillOrderAmt,0),isnull(tmp02__.FUnAuditSOAmt,0),isnull(tmp02__.FReserve1,0), ").append(this.sp);
        updateSql.append(" isnull(tmp02__.FReserve2,0),isnull(tmp02__.FReserve3,0),isnull(tmp02__.FReserve4,0),isnull(tmp02__.FReserve5,0), ").append(this.sp);
        updateSql.append(" isnull(tmp02__.FUnAuditPostBillAmt,0),isnull(tmp02__.FUnOutPostBillAmt,0), ").append(this.sp);
        updateSql.append(" isnull(tmp02__.FUnOutSaleOrderBillAmt,0) ").append(this.sp);
        updateSql.append(" FROM t_sd_creditbalance  AS tmp02__").append(this.sp);
        updateSql.append(" WHERE ").append(tempTable).append(".FCompanyId = tmp02__.FCompanyId ");
        updateSql.append(" AND ").append(tempTable).append(".FCustomerID = tmp02__.FCustomerId ").append(this.sp);
        updateSql.append(" AND tmp02__.FCreditAccountID = '").append("DawAAAAPiJDuN4KI").append("'").append(this.sp);
        updateSql.append(" AND ").append(tempTable).append(".FPLevel = ?");
        updateSql.append(" )");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{20});
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{10});
    }

    private void insertUsedData4Group(Context ctx, String tempTable, String subTempTable) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO ").append(subTempTable);
        insertSql.append(" (FCompanyID_UP,FCompanyID,FCustomerID,");
        insertSql.append(" FUnArBillIssuedAmt,FUnAuditIssuedAmt,FUnArBillOrderAmt,FUnAuditSOAmt,FReserve1,FReserve2,FReserve3,");
        insertSql.append(" FReserve4,FReserve5,FUnAuditPostBillAmt,FUnOutPostBillAmt,FUnOutSaleOrderBillAmt,");
        insertSql.append(" FDestCurrencyID, FBaseExgTableID, FSrcCurrencyID) ").append(this.sp);
        insertSql.append(" SELECT tmp01__.FCompanyId FCompanyId_UP,cc.FID FCompanyId,tmp01__.FCustomerId,");
        insertSql.append(" tmp02__.FUnArBillIssuedAmt,tmp02__.FUnAuditIssuedAmt,");
        insertSql.append(" tmp02__.FUnArBillOrderAmt,tmp02__.FUnAuditSOAmt, ").append(this.sp);
        insertSql.append(" tmp02__.FReserve1,tmp02__.FReserve2, ").append(this.sp);
        insertSql.append(" tmp02__.FReserve3,tmp02__.FReserve4,tmp02__.FReserve5,");
        insertSql.append(" tmp02__.FUnAuditPostBillAmt,tmp02__.FUnOutPostBillAmt,").append(this.sp);
        insertSql.append(" tmp02__.FUnOutSaleOrderBillAmt,").append(this.sp);
        insertSql.append(" tmp01__.FCurrencyID,tmp01__.FBaseExgTableID,cc.FBaseCurrencyID ").append(this.sp);
        insertSql.append(" FROM (select distinct tt.FCompanyId,tt.FCompanyLongNumber, tt.FCustomerId,tt.FCurrencyID,tt.FBaseExgTableID from ");
        insertSql.append(tempTable);
        insertSql.append(" as tt ) AS tmp01__,");
        insertSql.append(" t_sd_creditbalance  AS tmp02__,T_ORG_Company cc").append(this.sp);
        insertSql.append(" WHERE tmp02__.FCompanyId = cc.FID ").append(this.sp);
        insertSql.append(" AND tmp02__.FCreditAccountID = '").append("DawAAAAPiJDuN4KI").append("'").append(this.sp);
        insertSql.append(" AND (SUBSTRING(cc.FLongNumber,0,LENGTH(tmp01__.FCompanyLongNumber) + 1 ) = tmp01__.FCompanyLongNumber || '!') ");
        insertSql.append(" AND cc.fisbizunit = 1 ").append(this.sp);
        insertSql.append(" AND tmp01__.fcustomerid = tmp02__.FCustomerId").append(this.sp);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void updateExchangeRate(Context ctx, String subTempTable) throws BOSException, EASBizException {
        IRowSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement psUpdate = null;
        int preUpdate = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update " + subTempTable + " set FExchangeRate=? where FBaseExgTableID=? and FSrcCurrencyID=? and FDestCurrencyID=?");
            psUpdate = conn.prepareStatement(updateSql.toString());
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("SELECT distinct tmp.FSrcCurrencyID FSrcCurrencyID, tmp.FBaseExgTableID FBaseExgTableID, ");
            selectSql.append("tmp.FDestCurrencyID FDestCurrencyID FROM ");
            selectSql.append(subTempTable).append(" tmp inner join T_ORG_Company cc on cc.fid=tmp.FCompanyId where cc.fisbizunit=1");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            ObjectUuidPK exchangeTablePk = null;
            ObjectUuidPK srcCurrencyPk = null;
            ObjectUuidPK destCurrencyPk = null;
            while (rs.next()) {
                srcCurrencyPk = new ObjectUuidPK(rs.getString("FSrcCurrencyID"));
                exchangeTablePk = new ObjectUuidPK(rs.getString("FBaseExgTableID"));
                destCurrencyPk = new ObjectUuidPK(rs.getString("FDestCurrencyID"));
                BigDecimal rate = CreditUtils.getExchangeRate(ctx, (IObjectPK)exchangeTablePk, (IObjectPK)srcCurrencyPk, (IObjectPK)destCurrencyPk);
                psUpdate.setBigDecimal(1, rate);
                psUpdate.setString(2, rs.getString("FBaseExgTableID"));
                psUpdate.setString(3, rs.getString("FSrcCurrencyID"));
                psUpdate.setString(4, rs.getString("FDestCurrencyID"));
                psUpdate.addBatch();
                ++preUpdate;
            }
            if (preUpdate > 0) {
                psUpdate.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(psUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdate);
    }

    private void upwardSum4Group(Context ctx, Map params) throws BOSException {
        if (!this.isRootControl) {
            return;
        }
        String tempTable = params.get(CFILE_TMPTABLE).toString();
        String subTempTable = params.get(CDATA_TMPTABLE).toString();
        StringBuilder updateSql = new StringBuilder(350);
        updateSql.append("UPDATE ").append(tempTable).append(this.sp);
        updateSql.append(" SET (FUnArBillIssuedAmt,FUnAuditIssuedAmt,FUnArBillOrderAmt,FUnAuditSOAmt,FReserve1,FReserve2,FReserve3,").append(this.sp);
        updateSql.append(" FReserve4,FReserve5,FUnAuditPostBillAmt,FUnOutPostBillAmt,FUnOutSaleOrderBillAmt,FUnAuditARAmt,FArBalance,ImcomeAmt,PayAmt) = ");
        updateSql.append(this.sp);
        updateSql.append(" (SELECT tmp0003___.FUnArBillIssuedAmt,tmp0003___.FUnAuditIssuedAmt,");
        updateSql.append(" tmp0003___.FUnArBillOrderAmt,tmp0003___.FUnAuditSOAmt,tmp0003___.FReserve1,");
        updateSql.append(" tmp0003___.FReserve2,tmp0003___.FReserve3,tmp0003___.FReserve4,tmp0003___.FReserve5,tmp0003___.FUnAuditPostBillAmt,");
        updateSql.append(" tmp0003___.FUnOutPostBillAmt,tmp0003___.Funoutsaleorderbillamt,tmp0003___.FUnAuditARAmt,tmp0003___.FArBalance,tmp0003___.ImcomeAmt,tmp0003___.PayAmt");
        updateSql.append(" FROM (").append(" SELECT tmp01__.FCompanyId_UP,tmp01__.FCustomerId,");
        updateSql.append(" sum(isnull(tmp01__.FUnArBillIssuedAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnArBillIssuedAmt,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FUnAuditIssuedAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnAuditIssuedAmt,");
        updateSql.append(" sum(isnull(tmp01__.FUnArBillOrderAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnArBillOrderAmt,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FUnAuditSOAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnAuditSOAmt, ").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FReserve1,0)*isnull(tmp01__.FExchangeRate,1.0)) FReserve1,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FReserve2,0)*isnull(tmp01__.FExchangeRate,1.0)) FReserve2, ").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FReserve3,0)*isnull(tmp01__.FExchangeRate,1.0)) FReserve3,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FReserve4,0)*isnull(tmp01__.FExchangeRate,1.0)) FReserve4,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FReserve5,0)*isnull(tmp01__.FExchangeRate,1.0)) FReserve5, ").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FUnAuditPostBillAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnAuditPostBillAmt,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FUnOutPostBillAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnOutPostBillAmt, ").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FUnOutSaleOrderBillAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnOutSaleOrderBillAmt,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FUnAuditARAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) FUnAuditARAmt,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.FArBalance,0)*isnull(tmp01__.FExchangeRate,1.0)) FArBalance,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.ImcomeAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) ImcomeAmt,");
        updateSql.append(" sum(isnull(tmp01__.PayAmt,0)*isnull(tmp01__.FExchangeRate,1.0)) PayAmt ").append(this.sp);
        updateSql.append(" FROM ").append(subTempTable).append(" AS tmp01__ ");
        updateSql.append(" GROUP BY tmp01__.FCompanyId_UP,tmp01__.FCustomerId").append(this.sp);
        updateSql.append(" ) AS tmp0003___").append(this.sp);
        updateSql.append(" WHERE ").append(tempTable).append(".FCustomerID = tmp0003___.FCustomerId ");
        updateSql.append(" AND ").append(tempTable).append(".FCompanyID = tmp0003___.FCompanyId_UP ").append(this.sp);
        updateSql.append(" )");
        logger.info((Object)updateSql.toString());
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void updateARData(Context ctx, Map params, CreditCondition creditCondition) throws BOSException, EASBizException {
        String tempTable = params.get(CFILE_TMPTABLE).toString();
        ObjectUuidPK companyPK = new ObjectUuidPK(this.companyInfo.getId().toString());
        StringBuffer selectSql = null;
        if (this.isRootControl) {
            selectSql = new StringBuffer();
            selectSql.append("SELECT top 1 FCompanyID FROM ").append(tempTable).append(" where LENGTH(FCompanyLongNumber) = (select min(LENGTH(FCompanyLongNumber)) from ").append(tempTable).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            try {
                while (rs.next()) {
                    companyPK = new ObjectUuidPK(rs.getString("FCompanyID"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        List customerlist = this.getCustomerIDList(ctx, tempTable);
        IArSysFacade arSysFacade = ArSysFacadeFactory.getLocalInstance((Context)ctx);
        if (customerlist.size() > 0 && companyPK != null) {
            String unAuditARTempTable;
            selectSql = new StringBuffer();
            String auditARTempTable = arSysFacade.getCustomersCreditBalTable((IObjectPK)companyPK, customerlist, this.isByBizCode_Sys);
            if (auditARTempTable != null) {
                this.updateAuditARData(ctx, tempTable, auditARTempTable);
                selectSql.append(" select fcompanyid,fcustomerid,FBalance,FDebit,FCredit,0 as FAmount ").append(this.sp);
                selectSql.append(" from ").append(auditARTempTable).append(this.sp);
                selectSql.append(" where fbizcodeid is not null ").append(this.sp);
                if (this.isRootControl) {
                    String sql = " delete from " + auditARTempTable + " where fcompanyid in (select t2.fid from t_org_company t2 where t2.fisbizunit=0)";
                    DbUtil.execute((Context)ctx, (String)sql);
                    String subTempTable = params.get(CDATA_TMPTABLE).toString();
                    this.updateAuditARData(ctx, subTempTable, auditARTempTable);
                }
            }
            if (this.isNeedUnAuditAr && (unAuditARTempTable = arSysFacade.getCustomersUnAuditBillsAmtTable((IObjectPK)companyPK, customerlist, this.isByBizCode_Sys)) != null) {
                this.updateUnAuditARData(ctx, tempTable, unAuditARTempTable);
                if (selectSql.length() > 0) {
                    selectSql.append(" union all ").append(this.sp);
                }
                selectSql.append(" select fcompanyid,fcustomerid,0 as FBalance,0 as FDebit,0 as FCredit,FAmount ").append(this.sp);
                selectSql.append(" from ").append(unAuditARTempTable).append(this.sp);
                selectSql.append(" where fbizcodeid is not null ").append(this.sp);
                if (this.isRootControl) {
                    String sql = " delete from " + auditARTempTable + " where fcompanyid in (select t2.fid from t_org_company t2 where t2.fisbizunit=0)";
                    DbUtil.execute((Context)ctx, (String)sql);
                    String subTempTable = params.get(CDATA_TMPTABLE).toString();
                    this.updateUnAuditARData(ctx, subTempTable, unAuditARTempTable);
                }
            }
            this.insertSupplierData(ctx, params, selectSql.toString());
        }
        this.insertUnCreditCustomerARData(ctx, creditCondition, customerlist, tempTable);
    }

    private void insertSupplierData(Context ctx, Map params, String selectSql) throws BOSException, EASBizException {
        if (!this.isByBizCode_Sys || selectSql.length() < 1) {
            return;
        }
        String tempTable = params.get(CFILE_TMPTABLE).toString();
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" INSERT INTO ").append(tempTable);
        sqlStr.append(" (id, FRecID,FBizCodeID,FBizCodeNum,FBizCodeName,FCompanyId,FCompanyNumber,FCompanyLongNumber,FCompanyName,");
        sqlStr.append(" FCustomerId,FCustomerNumber,FCustomerName,FCurrencyID,FBaseExgTableID,FBaseCurrencyName,FBaseCurrencyPrecision,");
        sqlStr.append(" FAmount,FTerm,FUnAuditARAmt,ImcomeAmt,PayAmt,FArBalance, FPLevel) ").append(this.sp);
        sqlStr.append("SELECT newbosid('88888888') as id, newbosid('").append(new CreditFileInfo().getBOSType().toString());
        sqlStr.append(" ') AS FRecID, t1.FBizAnalysisCodeID,t3.FBizCodeNum,t3.FBizCodeName,t3.FCompanyId,t3.FCompanyNumber,t3.FCompanyLongNumber,t3.FCompanyName,").append(this.sp);
        sqlStr.append(" t1.fid,t1.fnumber,t1.fname").append(this.LNAME).append(",t3.FCurrencyID,t3.FBaseExgTableID,t3.FBaseCurrencyName,t3.FBaseCurrencyPrecision,").append(this.sp);
        sqlStr.append(" t3.FAmount,t3.FTerm,t0.FAmount,t0.FDebit,t0.FCredit,t0.FBalance,7 from (select tt.fcompanyid,tt.fcustomerid, ").append(this.sp);
        sqlStr.append(" sum(isnull(FBalance,0)) FBalance,sum(isnull(FDebit,0)) FDebit,sum(isnull(FCredit,0)) FCredit,sum(isnull(FAmount,0)) FAmount from (");
        sqlStr.append(selectSql).append(") as tt group by tt.fcompanyid, tt.fcustomerid) as t0,t_bd_supplier t1,T_BD_BizAnaylysisCode t2,");
        sqlStr.append("(select distinct tmp.FBizCodeNum,tmp.FBizCodeName,");
        sqlStr.append(" tmp.FCompanyId,tmp.FCompanyNumber,tmp.FCompanyLongNumber,tmp.FCompanyName, ");
        sqlStr.append(" tmp.FCurrencyID,tmp.FBaseExgTableID,tmp.FBaseCurrencyName,tmp.FBaseCurrencyPrecision,tmp.FAmount,tmp.FTerm ");
        sqlStr.append(" from ").append(tempTable).append(" as tmp where tmp.FBizCodeNum is not null AND tmp.FPLevel=10) as t3");
        if (this.isRootControl) {
            sqlStr.append(", T_ORG_Company cc ");
        }
        sqlStr.append(" where  t0.fcustomerid = t1.fid ").append(this.sp);
        if (this.isRootControl) {
            sqlStr.append(" and t0.fcompanyid = cc.fid and  cc.fisbizunit = 1 ").append(this.sp);
            sqlStr.append(" AND ((SUBSTRING(cc.FLongNumber,0,LENGTH(t3.FCompanyLongNumber) + 1 ) = t3.FCompanyLongNumber || '!') OR cc.FLongNumber = t3.FCompanyLongNumber) ");
        } else {
            sqlStr.append(" and t0.fcompanyid = t3.fcompanyid").append(this.sp);
        }
        sqlStr.append(" and t1.FBizAnalysisCodeID = t2.fid ").append(this.sp);
        sqlStr.append(" and t3.FBizCodeNum = t2.fnumber ").append(this.sp);
        logger.info((Object)sqlStr.toString());
        DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        if (this.isRootControl) {
            StringBuffer sql = new StringBuffer("");
            sql.append(" delete from ").append(tempTable).append(" where fplevel=7 and FRecID ").append(this.sp);
            sql.append(" not in (select max(FRecID) from ").append(tempTable).append(" where fplevel = 7").append(this.sp);
            sql.append(" group by FCompanyId,FBizCodeNum)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (this.isRootControl) {
            String subTempTable = params.get(CDATA_TMPTABLE).toString();
            sqlStr.setLength(0);
            sqlStr.append(" INSERT INTO ").append(subTempTable);
            sqlStr.append(" (FCompanyID_UP,FCompanyID,FCustomerID, FUnAuditARAmt, ImcomeAmt, PayAmt, FArBalance,");
            sqlStr.append(" FDestCurrencyID, FBaseExgTableID, FSrcCurrencyID) ").append(this.sp);
            sqlStr.append(" SELECT tmp01__.FCompanyId FCompanyId_UP,cc.FID FCompanyId,tmp01__.FCustomerId,tmp02__.FAmount,");
            sqlStr.append(" tmp02__.FDebit, tmp02__.FCredit, tmp02__.FBalance,").append(this.sp);
            sqlStr.append(" tmp01__.FCurrencyID,tmp01__.FBaseExgTableID,cc.FBaseCurrencyID ").append(this.sp);
            sqlStr.append(" FROM ").append(tempTable).append(" AS tmp01__, (select tt.fcompanyid,tt.fcustomerid,");
            sqlStr.append(" sum(isnull(FBalance,0)) FBalance,sum(isnull(FDebit,0)) FDebit,sum(isnull(FCredit,0)) FCredit,sum(isnull(FAmount,0)) FAmount from (");
            sqlStr.append(selectSql).append(") as tt group by tt.fcompanyid, tt.fcustomerid) AS tmp02__,T_ORG_Company cc").append(this.sp);
            sqlStr.append(" WHERE tmp02__.FCompanyId = cc.FID ").append(this.sp);
            sqlStr.append(" AND (SUBSTRING(cc.FLongNumber,0,LENGTH(tmp01__.FCompanyLongNumber) + 1 ) = tmp01__.FCompanyLongNumber || '!') ");
            sqlStr.append(" AND cc.fisbizunit = 1 ").append(this.sp);
            sqlStr.append(" AND tmp01__.fcustomerid = tmp02__.FCustomerId And tmp01__.FPLevel=7 ").append(this.sp);
            DbUtil.execute((Context)ctx, (String)sqlStr.toString());
            sqlStr.setLength(0);
            sqlStr.append("update ").append(subTempTable).append(" as t1 set FExchangeRate=(select min(t2.FExchangeRate) from ").append(this.sp);
            sqlStr.append(subTempTable).append(" as t2 where t1.FBaseExgTableID=t2.FBaseExgTableID ").append(this.sp);
            sqlStr.append(" and t1.FSrcCurrencyID=t2.FSrcCurrencyID and t1.FDestCurrencyID=t2.FDestCurrencyID)");
            DbUtil.execute((Context)ctx, (String)sqlStr.toString());
        }
    }

    private void insertUnCreditCustomerARData(Context ctx, CreditCondition creditCondition, List customerlist, String tempTable) throws BOSException, EASBizException {
        if (this.isFromSaleOrderQuery && creditCondition.getCustomer() != null && !customerlist.contains(creditCondition.getCustomer().getId().toString())) {
            customerlist = new ArrayList<String>();
            customerlist.add(creditCondition.getCustomer().getId().toString());
            ObjectUuidPK companyPK = new ObjectUuidPK(this.companyInfo.getId().toString());
            IArSysFacade arSysFacade = ArSysFacadeFactory.getLocalInstance((Context)ctx);
            String auditARTempTable = arSysFacade.getCustomersCreditBalTable((IObjectPK)companyPK, customerlist, false);
            if (auditARTempTable != null) {
                StringBuilder updateSql = new StringBuilder(300);
                updateSql.append("INSERT INTO ").append(tempTable);
                updateSql.append(" (id, FPLevel,FCompanyId,FCompanyNumber,FCompanyName,FCustomerId,FCustomerNumber,FCustomerName,").append(this.sp);
                updateSql.append("FBaseCurrencyName,FBaseCurrencyPrecision,FArBalance,ImcomeAmt,PayAmt) ").append(this.sp);
                updateSql.append("SELECT newbosid('88888888') as id, 39,org.fid,org.fnumber,org.fname").append(this.LNAME).append(",cst.fid,cst.fnumber,cst.fname").append(this.LNAME);
                updateSql.append(", bc.fname").append(this.LNAME).append(",bc.FPrecision,tmp002__.FBalance,tmp002__.FDebit,tmp002__.FCredit ").append(this.sp);
                updateSql.append("FROM ").append(auditARTempTable).append(" AS tmp002__ ").append(this.sp);
                updateSql.append("INNER JOIN T_BD_Customer cst on tmp002__.fcustomerid = cst.fid ").append(this.sp);
                updateSql.append("INNER JOIN T_ORG_Company org ON tmp002__.fcompanyid  = org.fid ").append(this.sp);
                updateSql.append("INNER JOIN T_BD_Currency bc ON org.fbasecurrencyid = bc.fid ").append(this.sp);
                updateSql.append("WHERE NOT EXISTS (select * from ").append(tempTable).append(" AS tmp001 ").append(this.sp);
                updateSql.append("where tmp002__.fcompanyid = tmp001.fcompanyid and tmp002__.fcustomerid = tmp001.fcustomerid )");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
    }

    private void calcCreditBalance(Context ctx, String tempTable, CreditCondition creditCondition) throws BOSException, EASBizException {
        BigDecimal amount;
        BigDecimal bigDecimal = amount = creditCondition != null ? creditCondition.readBillAmount() : SCMConstant.BIGDECIMAL_ZERO;
        if (this.isRootControl && amount.compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) {
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("SELECT top 1 FCompanyID FROM ").append(tempTable).append(" where LENGTH(FCompanyLongNumber) = (select min(LENGTH(FCompanyLongNumber)) from ").append(tempTable).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String companyID = null;
            try {
                while (rs.next()) {
                    companyID = rs.getString("FCompanyID");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (companyID != null && companyID.length() > 0 && !creditCondition.getCompany().getId().toString().equals(companyID)) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyID));
                company = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, (OrgUnitInfo)company);
                ObjectUuidPK srcCurrencyPk = new ObjectUuidPK(creditCondition.getCompany().getBaseCurrency().getId().toString());
                ObjectUuidPK exchangeTablePk = new ObjectUuidPK(company.getBaseExchangeTable().getId().toString());
                ObjectUuidPK destCurrencyPk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
                BigDecimal rate = CreditUtils.getExchangeRate(ctx, (IObjectPK)exchangeTablePk, (IObjectPK)srcCurrencyPk, (IObjectPK)destCurrencyPk);
                amount = amount.multiply(rate);
                amount = amount.setScale(company.getBaseCurrency().getPrecision(), 4);
            }
        }
        StringBuffer computeBal = new StringBuffer();
        String str = "";
        if (creditCondition != null) {
            str = "-(" + amount + ")";
            if (creditCondition.getDirection() != null && creditCondition.getDirection().equals((Object)CreditDirectionEnum.LESS)) {
                str = "+(" + amount + ")";
            }
        }
        computeBal.append("UPDATE ").append(tempTable).append(" SET CreditBalance = FAmount - UsedAmount").append(creditCondition != null ? str : " ").append(", FRatedBalance = (FAmount - UsedAmount)*ISNULL(FBalanceRate ,100)/100 ").append(creditCondition != null ? str : " ").append(" WHERE FPLevel NOT IN (7) ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)computeBal.toString());
        }
        DbUtil.execute((Context)ctx, (String)computeBal.toString());
        if (this.isByBizCode_Sys) {
            computeBal = new StringBuffer();
            computeBal.append("UPDATE ").append(tempTable).append(" SET FAmount = 0 WHERE FPLevel=7 ");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)computeBal.toString());
            }
            DbUtil.execute((Context)ctx, (String)computeBal.toString());
            if (!this.isCustFirst) {
                computeBal.setLength(0);
                computeBal.append("UPDATE ").append(tempTable).append(" as temp_002 SET FAmount=0, CreditBalance=0, FRatedBalance=0, FBalanceRate=0 ");
                computeBal.append(" WHERE temp_002.FPLevel in(7,20,30,38) AND EXISTS (select FCompanyId,FBizCodeID from ");
                computeBal.append(tempTable).append(" as temp_001 where FPLevel in(10,18) ");
                computeBal.append(" and temp_002.FBizCodeID=temp_001.FBizCodeID and temp_002.FCompanyId = temp_001.FCompanyId)");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)computeBal.toString());
                }
                DbUtil.execute((Context)ctx, (String)computeBal.toString());
            }
        }
        if (this.isInfinity) {
            computeBal = new StringBuffer();
            computeBal.append("UPDATE ").append(tempTable).append(" SET CreditBalance=-1, FRatedBalance=-1 ").append(" WHERE FAmount = ").append(CreditLimit.BIGDECIMAL_NEGATE_ONE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)computeBal.toString());
            }
            DbUtil.execute((Context)ctx, (String)computeBal.toString());
        }
    }

    private void subTotal4BizCode(Context ctx, String tempTable) throws BOSException, EASBizException {
        if (!this.isByBizCode_Sys) {
            return;
        }
        String SubLabel = ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditTimelimitResource", (String)"SUBTOTAL", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("");
        sql.append("update ").append(tempTable).append(" set FCompanyNumber='").append(SubLabel).append("',");
        sql.append("FCustomerNumber='',FCustomerName='',FCompanyLongNumber=FCompanyLongNumber || '!XXX' where FPLevel in(10,18)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" tmp_001").append(" set (FUnAuditSOAmt,FUnArBillOrderAmt,FUnAuditARAmt,").append(" FUnArBillIssuedAmt,FUnAuditIssuedAmt,ImcomeAmt,PayAmt,FArBalance,UsedAmount,").append(" CreditBalance,FUnAuditPostBillAmt,FUnOutPostBillAmt,FUnOutSaleOrderBillAmt,").append(" FReserve1,FReserve2,FReserve3,FReserve4,FReserve5)=").append(this.sp).append(" (select FUnAuditSOAmt,FUnArBillOrderAmt,FUnAuditARAmt,FUnArBillIssuedAmt,FUnAuditIssuedAmt,ImcomeAmt,PayAmt,FArBalance,").append(this.sp).append(" UsedAmount,CreditBalance,FUnAuditPostBillAmt,FUnOutPostBillAmt,FUnOutSaleOrderBillAmt,FReserve1,FReserve2,FReserve3,FReserve4,FReserve5").append(this.sp).append(" from (select FCompanyId,FBizCodeID,sum(FUnAuditSOAmt) FUnAuditSOAmt,sum(FUnArBillOrderAmt) FUnArBillOrderAmt,sum(FUnAuditARAmt) FUnAuditARAmt,").append(this.sp).append(" sum(FUnArBillIssuedAmt) FUnArBillIssuedAmt,sum(FUnAuditIssuedAmt) FUnAuditIssuedAmt,sum(ImcomeAmt) ImcomeAmt,sum(PayAmt) PayAmt,").append(this.sp).append(" sum(FArBalance) FArBalance,sum(UsedAmount) UsedAmount,sum(CreditBalance) CreditBalance,sum(FUnAuditPostBillAmt) FUnAuditPostBillAmt,").append(this.sp).append(" sum(FUnOutPostBillAmt) FUnOutPostBillAmt,sum(FUnOutSaleOrderBillAmt) FUnOutSaleOrderBillAmt,").append(this.sp).append(" sum(FReserve1) FReserve1,sum(FReserve2) FReserve2,sum(FReserve3) FReserve3,sum(FReserve4) FReserve4,sum(FReserve5) FReserve5").append(this.sp).append(" FROM ").append(tempTable).append(this.sp);
        sql.append(" WHERE FPLevel IN (7,10,18) ").append(this.sp);
        sql.append(" GROUP BY FCompanyId,FBizCodeID ) as tmp_002 ").append(this.sp).append(" where tmp_001.FCompanyId=tmp_002.FCompanyId and tmp_001.FBizCodeID=tmp_002.FBizCodeID and tmp_001.FPLevel in(10,18))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" delete from ").append(tempTable).append(" where (FCustomerNumber is null or FCustomerNumber='') and fplevel in(10,18) and FRecID ").append(this.sp).append(" not in (select max(FRecID) from ").append(tempTable).append(" where (FCustomerNumber is null or FCustomerNumber='') and fplevel in(10,18)").append(this.sp).append("  group by FBIZCODEID,FCompanyId)").append(this.sp);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void calcUsedBalance(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuilder calcSql = new StringBuilder(50);
        calcSql.append("UPDATE ").append(tempTable).append(" SET UsedAmount = ").append(this.creditFormula);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)calcSql.toString());
        }
        DbUtil.execute((Context)ctx, (String)calcSql.toString());
    }

    private List getCustomerIDList(Context ctx, String tempTable) throws BOSException, EASBizException {
        ArrayList<String> customerList = new ArrayList<String>();
        String selectSql = "SELECT distinct FCustomerID FROM  " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            while (rs.next()) {
                String custId = rs.getString("FCustomerID");
                customerList.add(custId);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return customerList;
    }

    private void updateUnAuditARData(Context ctx, String tempTable, String arTempTable) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE ").append(tempTable).append(this.sp);
        updateSql.append(" SET (FUnAuditARAmt) = ").append(this.sp);
        updateSql.append(" (SELECT tmp02__.FAmount ").append(this.sp);
        updateSql.append(" FROM ").append(arTempTable).append("  AS tmp02__").append(this.sp);
        updateSql.append(" WHERE ").append(tempTable).append(".FCompanyId = tmp02__.FCompanyId ");
        updateSql.append(" AND ").append(tempTable).append(".FCustomerID = tmp02__.FCustomerId ").append(" )");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void updateAuditARData(Context ctx, String tempTable, String arTempTable) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE ").append(tempTable).append(this.sp);
        updateSql.append(" SET (FArBalance,ImcomeAmt,PayAmt) = ").append(this.sp);
        updateSql.append(" (SELECT tmp02__.FBalance,tmp02__.FDebit,tmp02__.FCredit ").append(this.sp);
        updateSql.append(" FROM ").append(arTempTable).append("  AS tmp02__").append(this.sp);
        updateSql.append(" WHERE ").append(tempTable).append(".FCompanyId = tmp02__.FCompanyId ");
        updateSql.append(" AND ").append(tempTable).append(".FCustomerID = tmp02__.FCustomerId ").append(" )");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void dropTempTable(Context ctx, Map params) throws BOSException {
        String subTempTable;
        String string = subTempTable = params.get(CDATA_TMPTABLE) != null ? params.get(CDATA_TMPTABLE).toString() : null;
        if (subTempTable != null) {
            KsqlUtil.releaseTempTable((Context)ctx, (String)subTempTable);
        }
    }
}

