/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditParamFacadeFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.ICreditParamFacade;
import com.kingdee.eas.scm.util.PermissionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreditServerUtil {
    public static CreditParamInfo getCreditParamInfo(Context ctx, String companyInfoID) throws EASBizException, BOSException {
        ICreditParamFacade icf = CreditParamFacadeFactory.getLocalInstance(ctx);
        CreditParamInfo cpInfo = null;
        cpInfo = icf.getParameter(companyInfoID);
        return cpInfo;
    }

    public static boolean isBizCode(Context ctx, String companyInfoID) throws EASBizException, BOSException {
        ICreditParamFacade icf = CreditParamFacadeFactory.getLocalInstance(ctx);
        CreditParamInfo cpInfo = icf.getParameter(companyInfoID);
        if (cpInfo != null) {
            return cpInfo.isBizCode();
        }
        return false;
    }

    public static Boolean getAuthorizedOrgUnit(Context ctx, String companyId, String permissionItem) throws BOSException {
        Set authorizedOrgUnit = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)permissionItem);
        Boolean flag = false;
        FullOrgUnitInfo fullUnit2 = null;
        for (FullOrgUnitInfo fullUnit2 : authorizedOrgUnit) {
            if (!companyId.equals(fullUnit2.getId().toString())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isCreditParamG00X(Context ctx, String companyInfoID, String key) throws EASBizException, BOSException {
        String strParamG00X;
        boolean isG00X = false;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        if (!companyInfoID.equals("")) {
            pk = new ObjectUuidPK(companyInfoID);
        }
        if ((strParamG00X = ipc.getParamValue(pk, key)) != null && strParamG00X.trim().length() != 0 && strParamG00X.trim().equalsIgnoreCase("true")) {
            isG00X = true;
        }
        return isG00X;
    }

    public static Map isCreditParamG00X(Context ctx, String companyInfoID) throws EASBizException, BOSException {
        HashMap isG00X = new HashMap();
        String[] keys = new String[]{"G004", "G006"};
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        isG00X = paramControl.getParamHashMap(keys, companyInfoID);
        String paramValue = paramControl.getParamValue(null, "G005");
        isG00X.put("G005", paramValue);
        return isG00X;
    }

    public static boolean isCreditParamG00X(Context ctx, List companyList, String key) throws EASBizException, BOSException {
        ObjectUuidPK pk = null;
        String value = null;
        boolean flag = false;
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        int size = companyList.size();
        for (int i = 0; i < size; ++i) {
            pk = new ObjectUuidPK(((CompanyOrgUnitInfo)companyList.get(i)).getId());
            value = iParamControl.getParamValue((IObjectPK)pk, "G005");
            if (value == null || value.trim().length() == 0 || !value.trim().equalsIgnoreCase("true")) continue;
            return flag;
        }
        return false;
    }

    public static boolean isCreditParamPre(Context ctx, String couid) throws BOSException, EASBizException {
        ICreditParamFacade icf = CreditParamFacadeFactory.getLocalInstance(ctx);
        CreditParamInfo creditParamInfo = icf.getParameter(couid);
        int ctrlMethod = 2;
        if (creditParamInfo != null) {
            ctrlMethod = creditParamInfo.getSO_CreditCtrlMode();
        }
        return ctrlMethod == 0;
    }

    protected static CompanyOrgUnitInfo getRootCompany(Context ctx, IObjectPK companyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo couInfo = null;
        ICompanyOrgUnit ic = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        couInfo = ic.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        return couInfo;
    }

    static CompanyOrgUnitInfo getSuperiorCompany(Context ctx, IObjectPK companyID, ICompanyOrgUnit ic) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cInfo = ic.getCompanyOrgUnitInfo(companyID);
        if (cInfo != null) {
            if (cInfo.getParent() != null) {
                CreditServerUtil.getSuperiorCompany(ctx, (IObjectPK)new ObjectUuidPK(cInfo.getParent().getId()), ic);
            } else {
                return cInfo;
            }
        }
        return cInfo;
    }

    protected static String getCreditAnalysisTempTableSql(boolean needIncrease) {
        String sp = "\r\n";
        StringBuilder createTableSQL = new StringBuilder();
        createTableSQL.append("Create Table tempTbl (").append(sp);
        if (needIncrease) {
            createTableSQL.append("KSQL_SEQ INT IDENTITY(1,1),");
            createTableSQL.append("FLevel INT,");
            createTableSQL.append("orderField1 INT,");
            createTableSQL.append("orderField2 nvarchar(80),");
        }
        createTableSQL.append(" id varchar(44), FIsOverBalance int DEFAULT 0, FRecID varchar(44) null,FCreditFileID varchar(44) null, FAmount numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FTerm int DEFAULT 0, FIsBalanceRate int DEFAULT 0 ,FBalanceRate numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FRatedBalance numeric(19,4) DEFAULT 0,FUnArBillIssuedAmt numeric(19,4) DEFAULT 0,FUnAuditIssuedAmt numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FUnAuditARAmt numeric(19,4) DEFAULT 0,FReserve1 numeric(19,4) DEFAULT 0,FReserve2 numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FReserve3 numeric(19,4) DEFAULT 0,FReserve4 numeric(19,4) DEFAULT 0,FReserve5 numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FArBalance numeric(19,4) DEFAULT 0,FUnArBillOrderAmt numeric(19,4) DEFAULT 0,UsedAmount numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" CreditBalance numeric(19,4) DEFAULT 0,FUnAuditSOAmt numeric(19,4) DEFAULT 0,ImcomeAmt numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" PayAmt numeric(19,4) DEFAULT 0,unTimeoutAmount numeric(19,4) DEFAULT 0,timeoutAmount numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FUnAuditPostBillAmt numeric(19,4) DEFAULT 0,FUnOutPostBillAmt numeric(19,4) DEFAULT 0,FUnOutSaleOrderBillAmt numeric(19,4) DEFAULT 0,").append(sp);
        createTableSQL.append(" FGradeName nvarchar(255) null,FBizCodeID varchar(44) null,FBizCodeNum nvarchar(80) null,").append(sp);
        createTableSQL.append(" FBizCodeName nvarchar(255) null,FPLevel int null,FCustomerName nvarchar(255) null,").append(sp);
        createTableSQL.append(" FCustomerId varchar(44) null,FCustomerNumber nvarchar(80) null,FCompanyId varchar(44) null,").append(sp);
        createTableSQL.append(" FCompanyNumber nvarchar(80) null,FCompanyLongNumber nvarchar(80) null,FCompanyName nvarchar(255) null,");
        createTableSQL.append(" FBaseExgTableID varchar(44) null,FBaseCurrencyID varchar(44) null,FBaseCurrencyName nvarchar(255) null,");
        createTableSQL.append(" FBaseCurrencyPrecision int null,FCurrencyID varchar(44) null,FCurrencyNumber nvarchar(80) null,");
        createTableSQL.append(" FCurrencyName nvarchar(255) null,FPrecision int null, FExchangeRate numeric(19,4) DEFAULT 1) ");
        return createTableSQL.toString();
    }
}

