/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFileFactory;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.AbstractCreditTimelimitAnalysisRptFacadeControllerBean;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditTimelimitAnalysisRptFacadeControllerBean
extends AbstractCreditTimelimitAnalysisRptFacadeControllerBean {
    private static final long serialVersionUID = 7134122603197632359L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.credit.app.CreditTimelimitAnalysisRptFacadeControllerBean");
    private String sp = "\r\n";
    private String tempTable = null;
    private static final String TempTableNameKey = "TempTableName";
    private boolean isRootControl = false;
    private boolean isByBizCode_Sys = false;
    private boolean isByBizCode_Param = false;
    private Date computeDate = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private String customerFrom = null;
    private String customerTo = null;
    private Set customerIn = null;
    private String bizCodeFrom = null;
    private String bizCodeTo = null;
    private boolean isCustFirst = false;
    CreditCondition creditCondition = null;

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTableName = params.getString(TempTableNameKey);
        boolean isByBizCode = params.getBoolean("isByBizCode");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT temp.FCompanyNumber,temp.FCompanyName,temp.FBizCodeNum,temp.FBizCodeName,").append("temp.FCustomerNumber,temp.FCustomerName,temp.FBaseCurrencyName,temp.FGradeName,").append("temp.FTerm,temp.unTimeoutAmount,temp.timeoutAmount,temp.FBaseCurrencyPrecision,temp.FCOMPANYID as FCompanyId").append(this.sp).append(" FROM ").append(tempTableName).append(this.sp).append(" temp");
        if (isByBizCode) {
            sql.append(" inner join t_org_company company on temp.FCOMPANYID=company.fid").append(this.sp).append(" ORDER BY temp.FBizCodeNum,company.flevel,company.FLONGNUMBER,temp.FCOMPANYLONGNUMBER,temp.FCustomerNumber ASC ");
        } else {
            sql.append(" ORDER BY temp.FCustomerNumber,temp.FCompanyLongNumber ASC ");
        }
        RptParams pp = new RptParams();
        if (params.containsKey("isReport") && params.getBoolean("isReport")) {
            IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            pp.setObject("IRowset", (Object)irs);
        } else {
            RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
            pp.setObject("rowset", (Object)rs);
        }
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        KsqlUtil.releaseTempTable((Context)ctx, (String)params.getString(TempTableNameKey));
        String companyId = (String)params.getObject("companyID");
        Boolean flag = CreditServerUtil.getAuthorizedOrgUnit(ctx, companyId, "CreditTimelimitRpt_view");
        if (flag.booleanValue()) {
            this.processData(ctx, params);
        } else {
            this.analysisParams(ctx, params);
            this.tempTable = this.createCreditFilesTempTable(ctx);
        }
        String countSql = "SELECT count(*) cc FROM " + this.tempTable;
        RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
        int count = 0;
        if (rsCount.next() && rsCount.getObject(0) != null) {
            count = rsCount.getInt(0);
        }
        RptParams result = new RptParams();
        result.setString(TempTableNameKey, this.tempTable);
        result.setInt("RowCount", count);
        result.setBoolean("isByBizCode", this.isByBizCode_Sys);
        result.setBoolean("isByBizCode_Param", this.isByBizCode_Param);
        return result;
    }

    private String createCreditFilesTempTable(Context ctx) throws BOSException, EASBizException {
        String tempTable = "CreditFileTemp__1";
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("Create Table ").append(tempTable).append(this.sp);
        createTableSQL.append(" (id varchar(44), FIsOverBalance int DEFAULT 0, FRecID varchar(44) null,FCreditFileID varchar(44) null, FAmount numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FTerm int DEFAULT 0, FIsBalanceRate int DEFAULT 0 ,FBalanceRate numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FRatedBalance numeric(19,4) DEFAULT 0,FUnArBillIssuedAmt numeric(19,4) DEFAULT 0,FUnAuditIssuedAmt numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FUnAuditARAmt numeric(19,4) DEFAULT 0,FReserve1 numeric(19,4) DEFAULT 0,FReserve2 numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FReserve3 numeric(19,4) DEFAULT 0,FReserve4 numeric(19,4) DEFAULT 0,FReserve5 numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FArBalance numeric(19,4) DEFAULT 0,FUnArBillOrderAmt numeric(19,4) DEFAULT 0,UsedAmount numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" CreditBalance numeric(19,4) DEFAULT 0,FUnAuditSOAmt numeric(19,4) DEFAULT 0,ImcomeAmt numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" PayAmt numeric(19,4) DEFAULT 0,unTimeoutAmount numeric(19,4) DEFAULT 0,timeoutAmount numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FUnAuditPostBillAmt numeric(19,4) DEFAULT 0,FUnOutPostBillAmt numeric(19,4) DEFAULT 0,FUnOutSaleOrderBillAmt numeric(19,4) DEFAULT 0,").append(this.sp);
        createTableSQL.append(" FGradeName nvarchar(255) null,FBizCodeID varchar(44) null,FBizCodeNum varchar(80) null,").append(this.sp);
        createTableSQL.append(" FBizCodeName nvarchar(255) null,FPLevel int null,FCustomerName nvarchar(255) null,").append(this.sp);
        createTableSQL.append(" FCustomerId varchar(44) null,FCustomerNumber varchar(80) null,FCompanyId varchar(44) null,").append(this.sp);
        createTableSQL.append(" FCompanyNumber varchar(80) null,FCompanyLongNumber varchar(80) null,FCompanyName nvarchar(255) null,");
        createTableSQL.append(" FBaseExgTableID varchar(44) null,FBaseCurrencyID varchar(44) null,FBaseCurrencyName nvarchar(255) null,");
        createTableSQL.append(" FBaseCurrencyPrecision int null,FCurrencyID varchar(44) null,FCurrencyNumber varchar(80) null,");
        createTableSQL.append(" FCurrencyName nvarchar(255) null,FPrecision int null, FExchangeRate numeric(19,4) DEFAULT 1) ");
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSQL.toString());
        }
        catch (Exception e) {
            throw new SQLDataException(e.getMessage());
        }
        return tempTable;
    }

    private String processData(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.analysisParams(ctx, params);
        this.tempTable = CreditFileFactory.getLocalInstance(ctx).getCreditFile(this.creditCondition);
        this.updateARData(ctx);
        if (this.isByBizCode_Sys) {
            this.subTotal(ctx);
        }
        return this.tempTable;
    }

    private void analysisParams(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.isRootControl = CreditServerUtil.isCreditParamG00X(ctx, "", "G005");
        String companyId = params.getString("companyID");
        if (companyId == null) {
            throw new SCMBillException(SCMBillException.CUSTOMERPARAMSERROR);
        }
        ICompanyOrgUnit ie = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        this.companyInfo = ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
        this.computeDate = (Date)params.getObject("computeDate");
        if (params.containsKey("customerFrom") && params.getObject("customerFrom") != null) {
            if (params.getObject("customerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("customerFrom");
                if (customers.length == 1) {
                    this.customerFrom = ((CustomerInfo)customers[0]).getNumber();
                } else {
                    this.customerIn = new HashSet();
                    for (int i = 0; i < customers.length; ++i) {
                        this.customerIn.add(((CustomerInfo)customers[i]).getNumber());
                    }
                }
            } else {
                this.customerFrom = params.getObject("customerFrom") instanceof CustomerInfo ? ((CustomerInfo)params.getObject("customerFrom")).getNumber() : params.getObject("customerFrom").toString();
            }
        } else {
            this.customerFrom = null;
        }
        this.customerTo = params.containsKey("customerTo") && params.getObject("customerTo") != null ? (params.getObject("customerTo") instanceof CustomerInfo ? ((CustomerInfo)params.getObject("customerTo")).getNumber() : params.getObject("customerTo").toString()) : null;
        this.bizCodeFrom = params.containsKey("bizCodeFrom") ? params.getString("bizCodeFrom") : null;
        this.bizCodeTo = params.containsKey("bizCodeTo") ? params.getString("bizCodeTo") : null;
        this.isByBizCode_Param = params.containsKey("isBizCode") ? params.getBoolean("isBizCode") : false;
        CreditParamInfo param = null;
        param = this.isRootControl ? CreditServerUtil.getCreditParamInfo(ctx, "00000000-0000-0000-0000-000000000000CCE7AED4") : CreditServerUtil.getCreditParamInfo(ctx, this.companyInfo.getId().toString());
        boolean isInfinity = false;
        if (param != null) {
            this.isByBizCode_Sys = param.isBizCode();
            isInfinity = !param.isDefault0();
            this.isCustFirst = param.isCustFirst();
        } else {
            isInfinity = true;
            this.isByBizCode_Sys = false;
        }
        if (!this.isByBizCode_Sys && this.isByBizCode_Param) {
            throw new CreditControlException(CreditControlException.ISBYBIZCODESYS_AND_ISBYBIZCODEPARAM);
        }
        this.creditCondition = new CreditCondition();
        this.creditCondition.setRootControl(this.isRootControl);
        this.creditCondition.setByBizCode_Sys(this.isByBizCode_Sys);
        this.creditCondition.setByBizCode_Param(this.isByBizCode_Param);
        this.creditCondition.setInfinityCreditAmt(isInfinity);
        this.creditCondition.setCompany(this.companyInfo);
        this.creditCondition.setCustomerFrom(this.customerFrom);
        this.creditCondition.setCustomerTo(this.customerTo);
        this.creditCondition.setCustomerIn(this.customerIn);
        this.creditCondition.setBizCodeFrom(this.bizCodeFrom);
        this.creditCondition.setBizCodeTo(this.bizCodeTo);
    }

    private void updateARData(Context ctx) throws BOSException, EASBizException {
        String selectSQL = null;
        try {
            selectSQL = this.getCreditTermSql(ctx, this.computeDate, this.tempTable);
        }
        catch (Exception exp) {
            throw new CreditControlException(CreditControlException.CALL_ARAP_EXCEPTION, exp);
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE ").append(this.tempTable).append(" SET (timeoutAmount,unTimeoutAmount) = ").append(this.sp).append(" (SELECT tmp02__.timeoutAmount,tmp02__.unTimeoutAmount FROM (").append(selectSQL).append(" ) AS tmp02__").append(this.sp).append(" WHERE ").append(this.tempTable).append(".FCompanyId = tmp02__.FCompanyId ").append(" AND ").append(this.tempTable).append(".FCustomerID = tmp02__.FCustomerID) ");
        this.executeUpdate(updateSql.toString(), null, ctx);
        if (this.isRootControl) {
            String subTempTable = "CreditDataTemp__1";
            StringBuffer createTableSQL = new StringBuffer();
            createTableSQL.append("Create Table ").append(subTempTable).append(this.sp);
            createTableSQL.append(" (timeoutAmount numeric(19,4) DEFAULT 0,unTimeoutAmount numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FAmount numeric(19,4) DEFAULT 0,FTerm numeric(19,4) DEFAULT 0,").append(this.sp);
            createTableSQL.append(" FCustomerId varchar(44) null,FCompanyId varchar(44) null,FCompanyID_UP varchar(44) null,").append(this.sp);
            createTableSQL.append(" FBaseExgTableID varchar(44) null,FSrcCurrencyID varchar(44) null,FDestCurrencyID varchar(44) null,");
            createTableSQL.append(" FPrecision int null, FExchangeRate numeric(19,4)) ");
            try {
                subTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSQL.toString());
            }
            catch (Exception e) {
                throw new SQLDataException(e.getMessage());
            }
            this.insertUsedData4Group(ctx, this.tempTable, subTempTable, selectSQL);
            this.updateExchangeRate(ctx, subTempTable);
            this.upwardSum4Group(ctx, this.tempTable, subTempTable);
        }
    }

    private void insertUsedData4Group(Context ctx, String tempTable, String subTempTable, String selectSql) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO ").append(subTempTable);
        insertSql.append(" (FCompanyID_UP,FCompanyID,FCustomerID, timeoutAmount,unTimeoutAmount,");
        insertSql.append(" FDestCurrencyID, FBaseExgTableID, FSrcCurrencyID) ").append(this.sp);
        insertSql.append(" SELECT tmp01__.FCompanyId FCompanyId_UP,cc.FID FCompanyId,tmp01__.FCustomerId,");
        insertSql.append(" tmp02__.timeoutAmount,tmp02__.unTimeoutAmount,");
        insertSql.append(" tmp01__.FCurrencyID,tmp01__.FBaseExgTableID,cc.FBaseCurrencyID ").append(this.sp);
        insertSql.append(" FROM (select distinct tt.FCompanyId,tt.FCompanyLongNumber, tt.FCustomerId,tt.FCurrencyID,tt.FBaseExgTableID from ");
        insertSql.append(tempTable);
        insertSql.append(" as tt ) AS tmp01__,");
        insertSql.append(" (").append(selectSql).append(") AS tmp02__,T_ORG_Company cc").append(this.sp);
        insertSql.append(" WHERE tmp02__.FCompanyId = cc.FID ").append(this.sp);
        insertSql.append(" AND (SUBSTRING(cc.FLongNumber,0,LENGTH(tmp01__.FCompanyLongNumber) + 1 ) = tmp01__.FCompanyLongNumber || '!') ");
        insertSql.append(" AND cc.fisbizunit = 1 ").append(this.sp);
        insertSql.append(" AND tmp01__.fcustomerid = tmp02__.FCustomerId").append(this.sp);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void upwardSum4Group(Context ctx, String tempTable, String subTempTable) throws BOSException {
        if (!this.isRootControl) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE ").append(tempTable).append(this.sp);
        updateSql.append(" SET (timeoutAmount,unTimeoutAmount) = ");
        updateSql.append(this.sp);
        updateSql.append(" (SELECT tmp0003___.timeoutAmount,tmp0003___.unTimeoutAmount ");
        updateSql.append(" FROM (").append(" SELECT tmp01__.FCompanyId_UP,tmp01__.FCustomerId,");
        updateSql.append(" sum(isnull(tmp01__.timeoutAmount,0)*isnull(tmp01__.FExchangeRate,1.0)) timeoutAmount,").append(this.sp);
        updateSql.append(" sum(isnull(tmp01__.unTimeoutAmount,0)*isnull(tmp01__.FExchangeRate,1.0)) unTimeoutAmount ").append(this.sp);
        updateSql.append(" FROM ").append(subTempTable).append(" AS tmp01__ ");
        updateSql.append(" GROUP BY tmp01__.FCompanyId_UP,tmp01__.FCustomerId").append(this.sp);
        updateSql.append(" ) AS tmp0003___").append(this.sp);
        updateSql.append(" WHERE ").append(tempTable).append(".FCustomerID = tmp0003___.FCustomerId ");
        updateSql.append(" AND ").append(tempTable).append(".FCompanyID = tmp0003___.FCompanyId_UP ").append(this.sp);
        updateSql.append(" )");
        logger.info((Object)updateSql.toString());
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private String getCreditTermSql(Context ctx, Date endDate, String tempTable) throws BOSException {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sEndDate = dtFormat.format(endDate);
        sb.append("SELECT FCompanyID, FCustomerID, sum(FOutBal) timeoutAmount, sum(FBal) unTimeoutAmount from (");
        sb.append("SELECT t1.FCompanyID FCompanyID, t1.FAsstActID FCustomerID,").append(this.sp);
        sb.append(" sum(tplan.frecievepayamountlocal - tplan.fverifyamountlocal) FOutBal, 0 FBal from T_AR_OTHERBILL t1").append(this.sp);
        sb.append(" left join T_AR_OtherBillPlan tplan on t1.FID=tplan.FParentID").append(this.sp);
        sb.append(" inner join (select distinct tt.FCompanyId, tt.FCustomerId,tt.FTerm from ");
        sb.append(tempTable).append(" as tt) ttemp on t1.FCompanyId=ttemp.FCompanyId and t1.FAsstActId=ttemp.FCustomerId").append(this.sp);
        sb.append(" WHERE tplan.FRecievePayDate < add_days({").append(sEndDate).append("}, case when ttemp.FTerm <> 0 then 0-ttemp.FTerm else 0 end )").append(this.sp);
        sb.append(" and t1.fbillstatus=3 and t1.FUnVerifyAmount <>  0 AND t1.FIsBizBill = 0 ").append(this.sp);
        sb.append(" group by t1.FCompanyID, t1.FAsstActID ").append(this.sp);
        sb.append(" UNION ALL ").append(this.sp);
        sb.append("SELECT t1.FCompanyId FCompanyID, t1.FAsstActID FCustomerID,").append(this.sp);
        sb.append(" 0 FOutBal, sum(tplan.frecievepayamountlocal - tplan.fverifyamountlocal) FBal from T_AR_OTHERBILL t1").append(this.sp);
        sb.append(" left join T_AR_OtherBillPlan tplan  on t1.FID=tplan.FParentID").append(this.sp);
        sb.append(" inner join (select distinct tt.FCompanyId, tt.FCustomerId,tt.FTerm from ");
        sb.append(tempTable).append(" as tt) ttemp on t1.FCompanyId=ttemp.FCompanyId and t1.FAsstActId=ttemp.FCustomerId").append(this.sp);
        sb.append(" WHERE tplan.FRecievePayDate >= add_days({").append(sEndDate).append("}, case when ttemp.FTerm <> 0 then 0-ttemp.FTerm else 0 end )").append(this.sp);
        sb.append(" and t1.Fbillstatus=3 and t1.FUnVerifyAmount <>  0 AND t1.FIsBizBill = 0 ").append(this.sp);
        sb.append(" group by t1.FCompanyID, t1.FAsstActID) as temp03___ group by FCompanyID, FCustomerID");
        logger.debug((Object)("creditTerm anlaysis sql:\r\n" + sb));
        return sb.toString();
    }

    private void subTotal(Context ctx) throws BOSException, EASBizException {
        String SubLabel = ResourceBase.getString((String)"com.kingdee.eas.scm.credit.CreditTimelimitResource", (String)"SUBTOTAL", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer("");
        if (this.isByBizCode_Sys) {
            sql.append("update ").append(this.tempTable).append(" set FCompanyNumber='").append(SubLabel).append("',");
            sql.append("FCompanyName='',FCustomerNumber='',FCustomerName='',FCompanyLongNumber=FCompanyLongNumber || '!XXX' where FPLevel in(10,18)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(this.tempTable).append(" tmp_001").append(" set (unTimeoutAmount,timeoutAmount)=").append(this.sp).append(" (select unTimeoutAmount,timeoutAmount from").append(" (select sum(unTimeoutAmount) unTimeoutAmount,sum(timeoutAmount) timeoutAmount,FCompanyId,FBizCodeID").append(this.sp).append(" FROM ").append(this.tempTable).append(this.sp).append(" WHERE FPLevel IN (10,18) GROUP BY FCompanyId,FBizCodeID) as tmp_002 ").append(this.sp).append(" where tmp_001.FCompanyId=tmp_002.FCompanyId and tmp_001.FBizCodeID=tmp_002.FBizCodeID and tmp_001.FPLevel in(10,18))");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" delete from ").append(this.tempTable).append(" where (FCustomerNumber is null or FCustomerNumber='') and fplevel in(10,18) and FRecID not in (select max(FRecID) from ").append(this.tempTable).append(this.sp).append(" where (FCustomerNumber is null or FCustomerNumber='') and fplevel in(10,18)").append(this.sp).append("  group by FBIZCODEID,FCompanyId)").append(this.sp);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void updateExchangeRate(Context ctx, String subTempTable) throws BOSException, EASBizException {
        IRowSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement psUpdate = null;
        int preUpdate = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("update " + subTempTable + " set FExchangeRate=? where FBaseExgTableID=? and FSrcCurrencyID=? and FDestCurrencyID=?");
            psUpdate = conn.prepareStatement(updateSql.toString());
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("SELECT distinct tmp.FSrcCurrencyID FSrcCurrencyID, tmp.FBaseExgTableID FBaseExgTableID, ");
            selectSql.append("tmp.FDestCurrencyID FDestCurrencyID FROM ");
            selectSql.append(subTempTable).append(" tmp inner join T_ORG_Company cc on cc.fid=tmp.FCompanyId where cc.fisbizunit=1");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            ObjectUuidPK exchangeTablePk = null;
            ObjectUuidPK srcCurrencyPk = null;
            ObjectUuidPK destCurrencyPk = null;
            while (rs.next()) {
                srcCurrencyPk = new ObjectUuidPK(rs.getString("FSrcCurrencyID"));
                exchangeTablePk = new ObjectUuidPK(rs.getString("FBaseExgTableID"));
                destCurrencyPk = new ObjectUuidPK(rs.getString("FDestCurrencyID"));
                BigDecimal rate = CreditUtils.getExchangeRate(ctx, (IObjectPK)exchangeTablePk, (IObjectPK)srcCurrencyPk, (IObjectPK)destCurrencyPk);
                psUpdate.setBigDecimal(1, rate);
                psUpdate.setString(2, rs.getString("FBaseExgTableID"));
                psUpdate.setString(3, rs.getString("FSrcCurrencyID"));
                psUpdate.setString(4, rs.getString("FDestCurrencyID"));
                psUpdate.addBatch();
                ++preUpdate;
            }
            if (preUpdate > 0) {
                psUpdate.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(psUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)psUpdate);
    }
}

