/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.credit.CreditCondition;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditLimit;
import com.kingdee.eas.scm.credit.CreditQueryFacadeFactory;
import com.kingdee.eas.scm.credit.ICreditQueryFacade;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CreditBalanceAnalysis {
    private List<CreditCtrlResult> resultList = new ArrayList<CreditCtrlResult>();

    public List analysisCreditBalance(Context ctx) throws BOSException, EASBizException {
        String localString = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sp = " \r\n";
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT DISTINCT t0.FID,t0.FBaseCurrencyID ").append(sp);
        strSQL.append("FROM t_org_company t0 ").append(sp);
        strSQL.append("    INNER JOIN T_Bas_ParamItem pit ON t0.fid = pit.FOrgUnitID ").append(sp);
        strSQL.append("    INNER JOIN T_Bas_Param p ON pit.FKeyID = p.FID ").append(sp);
        strSQL.append("WHERE (p.FNumber = 'G004') ").append(sp);
        strSQL.append("  AND (ISNULL(pit.FValue_").append(localString).append(", 'false') = 'true')").append(sp);
        strSQL.append(" AND t0.FIsBizunit = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[0]);
        if (rs != null) {
            try {
                while (rs.next()) {
                    this.analysisForCompany(ctx, rs.getString("FID"), rs.getString("FBaseCurrencyID"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return this.resultList;
    }

    private void analysisForCompany(Context ctx, String companyID, String currencyID) throws BOSException, EASBizException {
        CreditCondition creditCondition = new CreditCondition();
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)companyID));
        creditCondition.setCompany(companyOrgUnitInfo);
        creditCondition.setCreditControlScene(1);
        ICreditQueryFacade creditQueryFacade = CreditQueryFacadeFactory.getLocalInstance(ctx);
        IRowSet creditRs = creditQueryFacade.processQueryCreditAmount(creditCondition);
        CreditCtrlResult mainCreditBalance = null;
        try {
            while (creditRs != null && creditRs.next()) {
                mainCreditBalance = new CreditCtrlResult();
                mainCreditBalance.setCreditCtrlMode(creditCondition.getCreditControlMethod());
                mainCreditBalance.setCompanyId(creditRs.getString("FCompanyId"));
                mainCreditBalance.setCustomerId(creditRs.getString("FCustomerId"));
                mainCreditBalance.setCreditAmount(CreditLimit.effectualCreditLimit(creditRs.getBigDecimal("FAmount")));
                mainCreditBalance.setTimeLimitDays(creditRs.getInt("FTerm"));
                mainCreditBalance.setpLevel(creditRs.getInt("FPLevel"));
                mainCreditBalance.setOtherUsedCreditAmount(creditRs.getBigDecimal("UsedAmount"));
                mainCreditBalance.setUsedCreditAmount(CreditLimit.read(creditRs.getBigDecimal("UsedAmount")));
                mainCreditBalance.setIsBalanceRate(creditRs.getObject("FIsBalanceRate") == null ? false : creditRs.getInt("FIsBalanceRate") == 1);
                mainCreditBalance.setBalanceRate(creditRs.getBigDecimal("FBalanceRate"));
                mainCreditBalance.setCurAmount(creditCondition.readBillAmount());
                mainCreditBalance.setBaseCurrencyID(currencyID);
                this.calculateCreditBalance(mainCreditBalance);
                this.resultList.add(mainCreditBalance);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void calculateCreditBalance(CreditCtrlResult creditBalance) throws BOSException, EASBizException {
        if (CreditLimit.isInfinity(creditBalance.getCreditAmount())) {
            creditBalance.setCreditAmount(null);
            creditBalance.setUsedCreditAmount(null);
            creditBalance.setRatedBalance(null);
        } else if (creditBalance.isBalanceRate()) {
            creditBalance.setRatedBalance(creditBalance.getCreditAmount().bigDecimalValue().subtract(creditBalance.getUsedCreditAmount().bigDecimalValue()).multiply(creditBalance.getBalanceRate()).divide(new BigDecimal(100), 4));
        } else {
            creditBalance.setRatedBalance(creditBalance.getCreditAmount().bigDecimalValue().subtract(creditBalance.getUsedCreditAmount().bigDecimalValue()));
        }
    }
}

