/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.credit.app.balance.CreditBalanceUpdateStrategy;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;

public final class CreditBalanceSeletor {
    private boolean isFIBalance = false;
    private boolean isBizBalance = false;
    private CreditBalanceUpdateStrategy balance = null;
    private CompanyOrgUnitInfo company = null;

    public CreditBalanceSeletor(CreditBalanceUpdateStrategy creditBalance) {
        this.balance = creditBalance;
    }

    public CreditBalanceUpdateStrategy balanceUpdateStrategy() {
        return this.balance;
    }

    public void pushBalance(String key, Object value) {
        if (CreditBalanceUpdateStrategy.isEffectualCreditBalanceItem(key)) {
            this.balance.creditBalance.put(key, value);
        }
    }

    public void selectFiOrBizBalance(Context ctx) throws EASBizException, BOSException {
        this.selectFiOrBizBalance(ctx, (OrgUnitInfo)this.company);
    }

    public void selectFiOrBizBalance(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(ctx, orgUnit);
        if (company != null && company.getId() != null) {
            this.isFIBalance = SCMServerUtils.isARBYINV((Context)ctx, (String)company.getId().toString());
            this.isBizBalance = !this.isFIBalance;
        }
    }

    public boolean isBizBalance() {
        return this.isBizBalance;
    }

    public boolean isFIBalance() {
        return this.isFIBalance;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }
}

