/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.credit.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditControlException;
import com.kingdee.eas.scm.credit.CreditFormulaEnum;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.CreditParamInfo;
import com.kingdee.eas.scm.credit.app.CreditServerUtil;
import com.kingdee.eas.scm.credit.util.BillControlStrategy;
import com.kingdee.eas.scm.credit.util.ControlStategyFacotry;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class CreditBalanceUpdateStrategy {
    protected static final String UPDATE = "UPDATE";
    protected static final String DELETE = "DELETE";
    protected static final String AUDIT = "AUDIT";
    protected static final String UNAUDIT = "UNAUDIT";
    protected static final String CLOSE = "CLOSE";
    protected static final String UNCLOSE = "UNCLOSE";
    protected static final String AUDIT_WB = "AUDIT_WB";
    protected static final String UNAUDIT_WB = "UNAUDIT_WB";
    protected static final String CLOSEAR = "CLOSEAR";
    protected static final String UNCLOSEAR = "UNCLOSEAR";
    protected Map creditBalance = new HashMap();
    protected Context ctx = null;
    protected List pushBalanceCommands = null;
    public static final String CREDITBALANCE_KEY_COMPANY = "COMPANY";
    public static final String CREDITBALANCE_KEY_CUSTOMER = "CUSTOMER";
    public static final String CREDITBALANCE_KEY_BILLINFO = "BILLINFO";
    private CompanyOrgUnitInfo company = null;
    private CustomerInfo customer = null;
    private IObjectValue billInfo = null;
    protected boolean isUpdateCredite = true;
    protected CreditParamInfo creditParam = null;
    private Boolean custNeedUpdate = null;
    public static final String CREDITLOG_KEY_CREDITOPERATION = "REDITOPERATION";
    public static final String CREDITLOG_KEY_REMARK = "REMARK";
    public static final String CREDITLOG_KEY_REMARK_L1 = "REMARK_L1";
    public static final String CREDITLOG_KEY_REMARK_L2 = "REMARK_L2";
    public static final String CREDITLOG_KEY_REMARK_L3 = "REMARK_L3";
    public static final String CREDITLOG_KEY_BILLTYPE = "BILLTYPE";
    public static final String CREDITLOG_KEY_BILLDATE = "BILLDATE";
    public static final String CREDITLOG_KEY_BILLID = "BILLID";
    public static final String CREDITLOG_KEY_BILLNUMBER = "BILLNUMBER";
    public static final String CREDITLOG_BOSTYPE = "CFCE011F";

    public CreditBalanceUpdateStrategy(Context ctx) {
        this.ctx = ctx;
    }

    public final Iterator pushCommandIterator() {
        this.pushBalanceCommands = this.pushBalanceCommands != null ? this.pushBalanceCommands : new ArrayList();
        return this.pushBalanceCommands.iterator();
    }

    public final void updateCreditBalance() throws BOSException, EASBizException {
        if (!this.isUpdateCredite) {
            return;
        }
        try {
            this.updateBalance();
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public final boolean isNeedUpdateCreditBalance() throws BOSException, EASBizException {
        boolean isNeed = this.isNeedUpdateCreditBalanceForCust();
        boolean billIsNeedUpdateBalance = false;
        if (isNeed) {
            billIsNeedUpdateBalance = this.isNeedUpdateCreditBalanceForBill(this.creditParam);
        }
        return isNeed && billIsNeedUpdateBalance;
    }

    protected boolean isNeedUpdateCreditBalanceForCust() throws BOSException, EASBizException {
        if (this.custNeedUpdate == null) {
            boolean isNeed = false;
            CompanyOrgUnitInfo company = this.visitCompany();
            CustomerInfo customer = this.visitCustomer();
            if (company == null) {
                throw new CreditControlException(CreditControlException.NULL_CONSIGN_COMPANY);
            }
            if (customer == null) {
                throw new CreditControlException(CreditControlException.NULL_PUSH_CUSTOMER);
            }
            if (customer.isIsCredited()) {
                this.creditParam = CreditServerUtil.getCreditParamInfo(this.ctx, company.getId().toString());
            }
            if (this.creditParam != null && this.creditParam.isCompnayCredited()) {
                isNeed = customer.isIsCredited();
            }
            this.custNeedUpdate = isNeed;
        }
        return this.custNeedUpdate;
    }

    public CreditParamInfo getCreditParam() {
        return this.creditParam;
    }

    protected void billChanged() {
        this.custNeedUpdate = null;
    }

    public abstract boolean isNeedUpdateCreditBalanceForBill(CreditParamInfo var1) throws BOSException, EASBizException;

    protected void updateBalance() throws BOSException, SQLException, EASBizException {
        if (this.visitCompany() != null && this.visitCustomer() != null) {
            String strSQL = null;
            ArrayList params = new ArrayList();
            if (this.isExistsBalanceRecord()) {
                String lockSql = "update T_SD_CreditBalance set FID = FID Where FCompanyID = ? And FCustomerID =? and FCreditAccountID = ?";
                DbUtil.execute((Context)this.ctx, (String)lockSql, (Object[])new Object[]{this.visitCompany().getId().toString(), this.visitCustomer().getId().toString(), this.getCreditAccount()});
                strSQL = this.getUpdateBalanceSQLString(params);
            } else {
                strSQL = this.getInsertBalanceSQLString(params);
            }
            if (!StringUtils.isEmpty((String)strSQL)) {
                DbUtil.execute((Context)this.ctx, (String)strSQL, (Object[])params.toArray());
                params = new ArrayList();
                if (this.isNeedCreditLog()) {
                    DbUtil.execute((Context)this.ctx, (String)this.getInsertLogSQLString(params), (Object[])params.toArray());
                }
            }
        }
    }

    private String getUpdateBalanceSQLString(List params) {
        String sp = " \r\n";
        StringBuffer strSQL = new StringBuffer("Update T_SD_CreditBalance Set ").append(sp);
        int count = 0;
        String fieldName = null;
        Iterator itor = this.creditBalance.keySet().iterator();
        while (itor.hasNext()) {
            fieldName = itor.next().toString();
            if (!CreditBalanceUpdateStrategy.isEffectualCreditBalanceItem(fieldName)) continue;
            if (count > 0) {
                strSQL.append(",").append(sp);
            }
            strSQL.append(fieldName).append(" = ").append(fieldName).append(" + ? ");
            params.add(this.visitNumeric(fieldName));
            ++count;
        }
        if (count == 0) {
            strSQL.setLength(0);
        } else {
            strSQL.append(sp).append(" Where FCompanyID = ? And FCustomerID =? and FCreditAccountID = ? ").append(sp);
            params.add(this.visitCompany().getId().toString());
            params.add(this.visitCustomer().getId().toString());
            params.add(this.getCreditAccount());
        }
        return strSQL.toString();
    }

    private String getInsertBalanceSQLString(List params) {
        StringBuffer strSQL = new StringBuffer("Insert Into T_SD_CreditBalance(FID,FCreditAccountID,FCompanyID,FCustomerID");
        params.add(BOSUuid.create((String)"12D4D072").toString());
        params.add(this.getCreditAccount());
        params.add(this.visitCompany().getId().toString());
        params.add(this.visitCustomer().getId().toString());
        int count = 0;
        String fieldName = null;
        StringBuffer vlaueString = new StringBuffer(" Values(?,?,?,?");
        Iterator itor = this.creditBalance.keySet().iterator();
        while (itor.hasNext()) {
            fieldName = itor.next().toString();
            if (!CreditBalanceUpdateStrategy.isEffectualCreditBalanceItem(fieldName)) continue;
            strSQL.append(",").append(fieldName);
            vlaueString.append(",").append("?");
            params.add(this.visitNumeric(fieldName));
            ++count;
        }
        if (count == 0) {
            strSQL.setLength(0);
        } else {
            strSQL.append(") ").append(vlaueString.toString()).append(") ");
        }
        return strSQL.toString();
    }

    private String getInsertLogSQLString(List params) {
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Insert Into T_SD_CreditLog(FID,FCreditAccountID,FCompanyID,FCustomerID,FCreditOperation,FOperateTime,");
        strSQL.append("FBillTypeID,FBillID,FBillNumber,FBizDate,FRemark,FRemark_l1,FRemark_l2,FRemark_l3");
        params.add(BOSUuid.create((String)CREDITLOG_BOSTYPE).toString());
        params.add(this.getCreditAccount());
        params.add(this.visitCompany().getId().toString());
        params.add(this.visitCustomer().getId().toString());
        params.add(new Integer(this.visitOperation().getValue()));
        params.add(new Timestamp(new Date().getTime()));
        params.add(this.visitString(CREDITLOG_KEY_BILLTYPE));
        params.add(this.visitString(CREDITLOG_KEY_BILLID));
        params.add(this.visitString(CREDITLOG_KEY_BILLNUMBER));
        params.add(this.visitDate(CREDITLOG_KEY_BILLDATE));
        params.add(this.visitString(CREDITLOG_KEY_REMARK));
        params.add(this.visitString(CREDITLOG_KEY_REMARK_L1));
        params.add(this.visitString(CREDITLOG_KEY_REMARK_L2));
        params.add(this.visitString(CREDITLOG_KEY_REMARK_L3));
        int count = 0;
        String fieldName = null;
        StringBuffer vlaueString = new StringBuffer(" Values(?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        Iterator itor = this.creditBalance.keySet().iterator();
        while (itor.hasNext()) {
            fieldName = itor.next().toString();
            if (!CreditBalanceUpdateStrategy.isEffectualCreditBalanceItem(fieldName)) continue;
            strSQL.append(",").append(fieldName);
            vlaueString.append(",").append("?");
            params.add(this.visitNumeric(fieldName));
            ++count;
        }
        if (count == 0) {
            strSQL.setLength(0);
        } else {
            strSQL.append(") ").append(vlaueString.toString()).append(") ");
        }
        return strSQL.toString();
    }

    private boolean isExistsBalanceRecord() throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"Select FID From T_SD_CreditBalance Where FCompanyID = ? And FCustomerID = ? and FCreditAccountID = ? ", (Object[])new Object[]{this.visitCompany().getId().toString(), this.visitCustomer().getId().toString(), this.getCreditAccount()});
        return rs != null && rs.next();
    }

    public void pushBalance(String key, Object value) {
        this.creditBalance.put(key, value);
    }

    public static boolean isEffectualCreditBalanceItem(String itemKey) {
        boolean isEffectual = false;
        if (itemKey != null && itemKey.trim().length() != 0) {
            isEffectual = CreditFormulaEnum.getEnum(itemKey) != null;
        }
        return isEffectual;
    }

    public IObjectValue visitBillInfo() {
        Object o;
        if (this.creditBalance.containsKey(CREDITBALANCE_KEY_BILLINFO) && (o = this.creditBalance.get(CREDITBALANCE_KEY_BILLINFO)) != null && o instanceof IObjectValue) {
            this.billInfo = (IObjectValue)o;
        }
        return this.billInfo;
    }

    public CustomerInfo visitCustomer() {
        Object o;
        if (this.creditBalance.containsKey(CREDITBALANCE_KEY_CUSTOMER) && (o = this.creditBalance.get(CREDITBALANCE_KEY_CUSTOMER)) != null && o instanceof CustomerInfo) {
            this.customer = (CustomerInfo)o;
        }
        return this.customer;
    }

    public CompanyOrgUnitInfo visitCompany() {
        Object o;
        if (this.company == null && this.creditBalance.containsKey(CREDITBALANCE_KEY_COMPANY) && (o = this.creditBalance.get(CREDITBALANCE_KEY_COMPANY)) != null && o instanceof CompanyOrgUnitInfo) {
            this.company = (CompanyOrgUnitInfo)o;
        }
        return this.company;
    }

    public BigDecimal visitNumeric(String key) {
        Object v;
        BigDecimal amount = SysConstant.BIGZERO;
        if (CreditBalanceUpdateStrategy.isEffectualCreditBalanceItem(key) && (v = this.creditBalance.get(key)) != null && v instanceof BigDecimal) {
            amount = SCMUtils.effectualNumeric((BigDecimal)((BigDecimal)v));
        }
        return amount;
    }

    public String visitString(String key) {
        Object v;
        String str = "";
        if (this.creditBalance.containsKey(key) && (v = this.creditBalance.get(key)) != null && v instanceof String) {
            str = (String)v;
        }
        return str;
    }

    public Date visitDate(String key) {
        Object v;
        Date date = new Date();
        if (this.creditBalance.containsKey(key) && (v = this.creditBalance.get(key)) != null && v instanceof Date) {
            date = (Date)v;
        }
        return new Timestamp(date.getTime());
    }

    public CreditOperationEnum visitOperation() {
        Object o;
        CreditOperationEnum operation = CreditOperationEnum.NULL;
        if (this.creditBalance.containsKey(CREDITLOG_KEY_CREDITOPERATION) && (o = this.creditBalance.get(CREDITLOG_KEY_CREDITOPERATION)) != null && o instanceof CreditOperationEnum) {
            operation = (CreditOperationEnum)((Object)o);
        }
        return operation;
    }

    protected void batchUpdate(String selectSql, List params, String operator) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        rowSet = params != null ? DbUtil.executeQuery((Context)this.ctx, (String)selectSql, (Object[])params.toArray()) : DbUtil.executeQuery((Context)this.ctx, (String)selectSql);
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        HashMap<String, CreditParamInfo> paramMap = new HashMap<String, CreditParamInfo>();
        try {
            CustomerInfo cust = null;
            CompanyOrgUnitInfo company = null;
            while (rowSet.next()) {
                String companyId = rowSet.getString("FCompanyOrgUnitId");
                String custId = rowSet.getString("FOrderCustomerID");
                BigDecimal locAmt = rowSet.getBigDecimal("locAmt");
                CreditParamInfo cp = null;
                if (companyMap.containsKey(companyId)) {
                    company = (CompanyOrgUnitInfo)companyMap.get(companyId);
                    cp = (CreditParamInfo)paramMap.get(companyId);
                } else {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    company = CreditOrgUnitUtils.readFullCompanyOrgUnitInfo(this.ctx, (OrgUnitInfo)company);
                    companyMap.put(companyId, company);
                    cp = CreditServerUtil.getCreditParamInfo(this.ctx, company.getId().toString());
                    paramMap.put(companyId, cp);
                }
                cust = new CustomerInfo();
                cust.setId(BOSUuid.read((String)custId));
                if (cp == null) continue;
                BillControlStrategy controlStrategy = ControlStategyFacotry.getStragy(this.getBillSecene(), cp);
                if (!cp.isCompnayCredited() || !controlStrategy.isCtrlAmount()) continue;
                this.creditBalance.put(CREDITBALANCE_KEY_COMPANY, company);
                this.creditBalance.put(CREDITBALANCE_KEY_CUSTOMER, cust);
                if (!this.creditBalance.containsKey(CREDITLOG_KEY_BILLID)) {
                    this.creditBalance.put(CREDITLOG_KEY_BILLDATE, rowSet.getDate("FBizDate"));
                    this.creditBalance.put(CREDITLOG_KEY_BILLTYPE, rowSet.getString("FBilltypeID"));
                    this.creditBalance.put(CREDITLOG_KEY_BILLID, rowSet.getString("FID"));
                    this.creditBalance.put(CREDITLOG_KEY_BILLNUMBER, rowSet.getString("FNumber"));
                    this.creditBalance.put(CREDITLOG_KEY_REMARK, "");
                    this.creditBalance.put(CREDITLOG_KEY_REMARK_L1, "");
                    this.creditBalance.put(CREDITLOG_KEY_REMARK_L2, "");
                    this.creditBalance.put(CREDITLOG_KEY_REMARK_L3, "");
                }
                if (locAmt == null) continue;
                this.updateRule(operator, locAmt);
                this.updateBalance();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected abstract void updateRule(String var1, BigDecimal var2);

    protected abstract CreditFormulaSceneEnum getBillSecene();

    public abstract boolean isNeedCreditLog();

    public abstract String getCreditAccount();

    protected String getResourceStr(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.credit.CreditResource", (String)key);
    }
}

